<?php

class report_relationcar extends c_report
{
    var $title = 'Отчет по связям водитель-автомобиль';
    var $filter = array();
    var $view_by_space_filter = 1;

    function setting()
    {
        $arr_orgs_ids = PERSONAL()->get_arr_orgs_to_cur_account();
        $car_arr_orgs_ids = $this->get_org_list();
        ?>
        <div id="panel_filter">
        <form id="sky-form" class="sky-form"><input type="hidden" name="filter_dir" value="<?
            echo _CUR_CAB_DIR . _CUR_REPORT . '/' ?>">
            <fieldset>
                <div class="row">
                    <?
                    $this->filter_section_input_text('name', 'ФИО водителя:', 2, array('auto_complete' => "autocomplette_personal_name"));
                    $this->filter_section_select_multiple('org_ids', 'Организация:', 3, $arr_orgs_ids);
                    $this->filter_section_input_text('car_number', 'Номер машины:', 2);
                    $this->filter_section_select_multiple('car_org_ids', 'Владелец авто:', 3, $car_arr_orgs_ids);
                    ?>
                </div>
                <div class="row">
                    <section class="col col-3">
                        <label class="checkbox">
                            <input type="checkbox" name="filter[only_active]" value="1" <?
                            if ($this->filter['only_active']) echo 'checked' ?>><i></i>Только активные
                        </label>
                    </section>
                </div>
            </fieldset>
            <?
            $this->panel_buttons(); ?>
        </form>
        </div>
        <?
    }

    function get_org_list()
    {
        $result = [];
        $result = execSQL_row('select distinct(t1.parent) as pkey,t2.obj_name 
                            from ' . TO()->table_car . ' t1 
                                left join obj_site_personals t2
                                    on t2.clss=207 and t1.parent=t2.pkey
                           order by obj_name');

        return $result;
    }

    function panel_info_filter()
    {
        $_str = [];
        $info = [];
        $title = '';
        if ($this->filter['car_number']) $info['Номер авто'] = '"' . $this->filter['car_number'] . '"';
        if ($this->filter['org_ids']) $info['Организации'] = PERSONAL()->get_org_names_by_ids(array_keys($this->filter['org_ids']));
        if ($this->filter['org_ids']) $info['Организации'] = PERSONAL()->get_org_names_by_ids(array_keys($this->filter['org_ids']));
        if ($this->filter['name']) $info['ФИО'] = '"' . $this->filter['name'] . '"';
        if ($this->filter['only_active']) $info['Только активные'] = '"Да"';

        if (sizeof($info)) foreach ($info as $title => $value) if (is_array($value)) $_str[] = $title . ': <strong>' . implode(',', $value) . '</strong>'; else $_str[] = $title . ': <strong>' . $value . '</strong>';
        if (sizeof($_str)) $title = '<p class=center>' . implode(' ', $_str) . '</p>';
        return $title;
    }

    function create_usl_select_obj($_params, &$options)
    {
        $_usl = [];

        if ($this->filter['name']) {
            $arr_ids = execSQL_line('select pkey from obj_site_personals where clss=211 and obj_name like "%' . addslashes($this->filter['name']) . '%"');
            if (sizeof($arr_ids)) $_usl[] = 'personal_id in (' . implode(',', $arr_ids) . ')';
            else                   $_usl[] = 'personal_id=-1';
        }

        if ($this->filter['org_ids']) $_usl[] = '_personal_org_id in (' . implode(',', array_keys($this->filter['org_ids'])) . ')';
        if ($this->filter['car_number']) $_usl[] = '_car_number like "%' . $this->filter['car_number'] . '%"';
        if ($this->filter['car_org_ids']) $_usl[] = '_car_org_id in (' . implode(',', array_keys($this->filter['car_org_ids'])) . ')';
        if ($this->filter['only_active']) $_usl[] = 'active=1';

        $usl = implode(' and ', $_usl);
        return $usl;
    }

    function get_cnt_items($usl, $options = array())
    {
        if ($usl) $usl = ' where ' . $usl;
        $cnt = execSQL_value('select count(pkey) from view_relationcars' . $usl, $options['debug']);
        return $cnt;
    }

    function get_items($usl, $options = array())
    {
        $limit = ($options['limit']) ? ' ' . $options['limit'] : '';
        if ($usl) $usl = ' where ' . $usl;
        $order = ' order by pkey desc ';
        $recs = execSQL('select * from view_relationcars' . $usl . $order . $limit, $options['debug']);

        return $recs;
    }

    function print_template_HTML($list_recs, $options = array())
    {
        $i = $this->first_obj;;

        ?>
        <table class="basic fz_small full auto">
            <tr>
                <th class="table_number">№</th>
                <th>Водитель</th>
                <th>Автомобиль</th>
                <th>Срок действия с</th>
                <th>Срок действия по</th>
                <th>Активна</th>
            </tr>
            <?
            foreach ($list_recs as $list_rec) {
                ?>
                <tr>
                    <td><?echo $i;$i++; ?></td>
                    <td class="left">
                        <?echo $list_rec['_personal_name'] ?>
                        <br>
                        <?echo $list_rec['_personal_org_name'] ?>
                    </td>
                    <td class="left">
                        <?echo $list_rec['_car_number'] ?>
                        <br>
                        <?echo $list_rec['_car_org_name'] ?>
                    </td>
                    <td><?echo date('d.m.Y H:i:s', $list_rec['time_from']) ?></td>
                    <td><?echo date('d.m.Y H:i:s', $list_rec['time_to']) ?></td>
                    <td>
                        <? if ($list_rec['active']) {
                            ?><img src="/images/status_1.png"><?
                        } else {
                            ?><img src="/images/status_0.png"><?
                        } ?>
                    </td>
                </tr>
                <?
            }
            ?>
        </table>
        <style>
            th.table_number {
                width: 20px;
            }
        </style>
        <?
    }
}

?>