<?php
/**
 * Contains OofState.
 */

namespace PhpEws\DataType;

use PhpEws\DataType;

/**
 * Represents a user's Out of Office (OOF) state.
 *
 * @package php-ews\Enumerations
 */
class OofState extends DataType
{
    /**
     * The user's OOF setting is currently disabled.
     *
     * @since Exchange 2007
     *
     * @var string
     */
    const DISABLED = 'Disabled';
    /**
     * The user's OOF setting is currently enabled.
     *
     * @since Exchange 2007
     *
     * @var string
     */
    const ENABLED = 'Enabled';
    /**
     * The user's OOF setting is scheduled to start at a specific date and end
     * at another specific date.
     *
     * @since Exchange 2007
     *
     * @var string
     */
    const SCHEDULED = 'Scheduled';
    /**
     * Element value.
     *
     * @var string
     */
    public $_;
    /**
     * Returns the value of this object as a string.
     *
     * @return string
     */
    public function __toString()
    {
        return $this->_;
    }
}