<?php
// отчет только с итоговыми результатами МО водителей (то есть после второго не допуска, после которого наступает блокировка 12 часов)
class report_personals_nedopusk extends c_report
{
 public $view_by_space_filter=1 ;
 var $title='Журнал учета водителей "Группа риска по медицинским показателям" и свыше 55 лет' ;
 var $arr_risk=array(1=>'возраст более 55 лет',2=>'наличие группы АГ',3=>'имели алкоголь в МО') ;
 var $allow_export_to_csv=1 ;

 function init($options=array())
 {
     if (!$this->filter['group_id']) $this->filter['group_id']=MEMBER()->cur_group_id ;
 }

    function setting($options=array())
    {   if (!is_array($options['disabled_filter'])) $options['disabled_filter']=array() ;

        $arr_groups=ACCOUNTS()->get_arr_groups_to_cur_account() ;
        $arr_orgs_ids=PERSONAL()->get_arr_orgs_to_cur_account() ;
        $arr_otdel_ids=(sizeof($this->filter['org_ids']))? PERSONAL()->get_arr_otdels_to_cur_account($this->filter['org_ids']):array() ;

        ?><div id="panel_filter">
        <form id="sky-form" class="sky-form"><input type="hidden" name="filter_dir" value="<?echo _CUR_REPORT_DIR?>">
                     <fieldset>
                      <div class="row">
                          <? $this->filter_section_select('group_id',$GLOBALS['LS_person_group_title'].':',2,$arr_groups) ;
                             $this->filter_section_select_multiple('org_ids','Организация:',2,$arr_orgs_ids) ;
                             $this->filter_section_select_multiple('otdel_ids','Подразделение:',2,$arr_otdel_ids) ;
                             $this->filter_section_input_text('name','ФИО:',2,array('auto_complete'=>"autocomplette_personal_name")) ;
                             $this->filter_section_select('risk','Причина:',2,$this->arr_risk) ;
                          ?>
                      </div>
                  </fieldset>
            <?$this->panel_buttons();?>
              </form>
        </div><br>
        <?
    }

    var $ids_alco ; // массив ID алкоголиков и число залетов

    function create_usl_select_obj($_params,&$options)
    {
        $usl=array() ;
        $usl[]=1 ;
        if ($this->filter['name'])             $usl[]='obj_name like "'.$this->filter['name'].'%"' ;
        if ($this->filter['org_ids'])          $usl[]='parent2 in ('.implode(',',array_keys($this->filter['org_ids'])).')' ;
        if ($this->filter['otdel_ids'])        $usl[]='parent3 in ('.implode(',',array_keys($this->filter['otdel_ids'])).')' ;
        if ($this->filter['uid'])              $usl[]='uid='.$this->filter['uid'] ;
        if ($this->filter['ids'])              $usl[]='pkey in ('.implode(',',array_keys($this->filter['ids'])).')' ;
        if ($this->filter['propusk'])          $usl[]='propusk="'.$this->filter['propusk'].'"' ;
        if ($this->filter['group_id'])
        {   $rec_group=ACCOUNTS()->get_group_by_id($this->filter['group_id']) ;
            if (sizeof($rec_group['_settings']['personal']['filter'])) $usl[]=$rec_group['_settings']['personal']['usl_select'] ;
            //damp_array($rec_group) ;
        }
        if ($this->filter['risk']==1)             $usl[]='risk_age=1' ;
        if ($this->filter['risk']==2)             $usl[]='risk_ag=1' ;
        if ($this->filter['risk']==3)             $usl[]='risk_alco>0' ;
        
        $usl_res=implode(' and ',$usl) ;
        //damp_array($usl,1,-1) ;
        return($usl_res) ;
    }


    function get_arr_info_filters()
    { $info=parent::get_arr_info_filters() ;
      if ($this->filter['risk']==1)   $info['Возраст более 55 лет']='Да' ;
      if ($this->filter['risk']==2)   $info['Наличие в группу АГ']='Да' ;
      if ($this->filter['risk']==3)   $info['Алкоголь в МО']='Да' ;
      return $info ;
    }

    function get_cnt_items($usl,$options=array())
    { $cnt=execSQL_value('select count(pkey) from  view_personals_riski_group where '.$usl,$options) ;
      return($cnt) ;
    }

    function get_items($usl,$options=array())
    { $limit=($options['limit'])? ' '.$options['limit']:'' ;
      $order=($this->filter['order'])? ' order by '.$this->filter['order']:' order by obj_name' ;
      $options['debug']=0 ;
      $list_rec=execSQL('select * from  view_personals_riski_group where '.$usl.$order.$limit,$options) ;
      return($list_rec) ;
    }

    function print_template_HTML($list_recs,$options=array())
    {
       $id=($options['id'])? 'id='.$options['id']:'' ;
       ?>
         <table class="basic fz_small full auto">
           <colgroup><col id="c0"><col id="c1"><col id="c3"><col id="c4"><col id="c11"><col id="c12"><col id="c13"></colgroup>
           <tr><th>№</th>
               <th>Фамилия, имя, отчество</th>
               <th>Заключение</th>
               <th>Дата постановки на учет</th>
               <th>Перечень ограничений</th>
               <th>Срок ограничения</th>
               <th>Наименование профилактических мероприятий, дата проведения</th>
               <th>Отметка о снятии с учета</th>
           </tr>
           <?
           $i=$this->first_obj ; ;
           if (sizeof($list_recs)) foreach($list_recs as $rec)
        {   ?><tr class=item>
            <td><?echo $i ; $i++ ;?></td>
                   <td class="left"><?echo $rec['obj_name']?></td>
                   <td class="left"><?
                       $arr=array() ;
                       if ($rec['risk_age']) $arr[]='<li>Возраст более 55 лет</li>' ;
                       if ($rec['risk_ag']) $arr[]='<li>Группа АГ</li>' ;
                       if ($rec['risk_alco']) $arr[]='<li>Употребление алкоголя ('.$rec['risk_alco'].' '.get_case_by_count_1_2_5($rec['risk_alco'],'случай,случая,случаев').')</li>' ;
                       if (sizeof($arr)) echo '<ul>'.implode('',$arr).'</ul>' ;
                       ?></td>
                   <td class="center"><?echo date('d.m.Y',$rec['risk_from'])?></td>
                   <td class="center">-</td>
                   <td class="center">-</td>
                   <td class="center">Периодический МО 1 раз в год</td>
                   <td></td>
               </tr><?
           }
         ?></table><?
        //damp_array($rec) ;
}

   function print_template_CSV($list_recs,$options=array())
   { $i=$options['from'] ;
     if (sizeof($list_recs)) foreach($list_recs as $rec)
       { $data=array() ;
         $data['UID сотрудника']=$rec['uid'];
         $data['ФИО сотрудника']=$rec['obj_name'] ;
         $data['Организация']=$rec['_org_name'];
         $data['Подразделение']=$rec['_otdel_name'];
         $data['Должность']=_IL('IL_works')->recs[$rec['working']]['obj_name'];
         $data['Пол']=($rec['pol'])? 'Женский':'Мужской' ;
         $data['ДатаРожд']=$rec['dr'] ;
         $data['Возраст']=$rec['age'] ;
         $data['Возраст более 55 лет']=($rec['risk_age'])? 'Да':'' ;
         $data['Группа АГ']=($rec['risk_ag'])? 'Да':'' ;
         $data['Употребление алкоголя']=($rec['risk_alco'])? $rec['risk_alco']:'' ;
         $data['Срок ограничения']=date('d.m.Y',$rec['risk_from']) ;
         $this->put_data_to_CSV($data,$i) ;
         $i++ ;
       }
   }

}


?>