<?php // СТАНДАРТНЫЙ ФАЙЛ НАСТРОЕК САЙТА

 error_reporting(E_ALL^E_NOTICE);

 $system_IP_list=array() ;
 $system_IP_list[]=$_SERVER['REMOTE_ADDR'] ;

 // совместимость $GLOBALS['_SETTING'] с старыми настройками
 if (!isset($GLOBALS['_SETTING']['esmo']['protocol']))              $GLOBALS['_SETTING']['esmo']['protocol']=(defined('_MAIN_PROTOCOL'))? str_replace('://','',_MAIN_PROTOCOL):'http' ;
 if (!isset($GLOBALS['_SETTING']['esmo']['base_domain']))           $GLOBALS['_SETTING']['esmo']['base_domain']=(defined('_BASE_DOMAIN'))? _BASE_DOMAIN:str_replace('www.','',$_SERVER['SERVER_NAME']) ;
 if (!isset($GLOBALS['_SETTING']['esmo']['main_domain']))           $GLOBALS['_SETTING']['esmo']['main_domain']=(defined('_MAIN_DOMAIN'))? _MAIN_DOMAIN:$_SERVER['SERVER_NAME'] ;
 if (!isset($GLOBALS['_SETTING']['esmo']['default_timezone']))      $GLOBALS['_SETTING']['esmo']['default_timezone']=(defined('_DEFAULT_TIMEZONE'))? _DEFAULT_TIMEZONE:'Europe/Moscow' ;
 if (!isset($GLOBALS['_SETTING']['esmo']['html2pdf']))              $GLOBALS['_SETTING']['esmo']['html2pdf']=(defined('_HTML2PDF_'))? _HTML2PDF_:$_SERVER['DOCUMENT_ROOT'].'/AddOns/html2pdf/wkhtmltopdf-amd64' ;

 if (!isset($GLOBALS['_SETTING']['dist']['engine_version']))        $GLOBALS['_SETTING']['dist']['engine_version']='engine_v'._ENGINE_VERS ;
 if (!isset($GLOBALS['_SETTING']['dist']['esmo_version']))          $GLOBALS['_SETTING']['dist']['esmo_version']='class_v'._CLASS_VERS ;
 if (!isset($GLOBALS['_SETTING']['dist']['class_version']))          $GLOBALS['_SETTING']['dist']['class_version']='class_v'._CLASS_VERS ;

 if (!isset($GLOBALS['_SETTING']['main_db']['host']))               $GLOBALS['_SETTING']['main_db']['host']=$GLOBALS['db_host'] ;
 if (!isset($GLOBALS['_SETTING']['main_db']['db_name']))            $GLOBALS['_SETTING']['main_db']['db_name']=$GLOBALS['db_name'] ;
 if (!isset($GLOBALS['_SETTING']['main_db']['username']))           $GLOBALS['_SETTING']['main_db']['username']=$GLOBALS['db_username'] ;
 if (!isset($GLOBALS['_SETTING']['main_db']['password']))           $GLOBALS['_SETTING']['main_db']['password']=$GLOBALS['db_password'] ;
 if (!isset($GLOBALS['_SETTING']['main_db']['use_db_cluster']))     $GLOBALS['_SETTING']['main_db']['use_db_cluster']=(defined('_USE_DB_CLASTER'))? _USE_DB_CLASTER:1 ; // 1 временно только для магнит
 if (!isset($GLOBALS['_SETTING']['main_db']['use_db_cluster_debug']))$GLOBALS['_SETTING']['main_db']['use_db_cluster_debug']=(defined('_USE_DB_CLUSTER_debug'))? _USE_DB_CLUSTER_debug:0 ;

 if (!isset($GLOBALS['_SETTING']['interface']['admin_logo_src']))   $GLOBALS['_SETTING']['interface']['admin_logo_src']='../images/logo-admin.png' ;
 if (!isset($GLOBALS['_SETTING']['interface']['logo_cab']))         $GLOBALS['_SETTING']['interface']['logo_cab']='/images/esmo.png';
 if (!isset($GLOBALS['_SETTING']['interface']['theme']))            $GLOBALS['_SETTING']['interface']['theme']='megamenu';

 if (!isset($GLOBALS['_SETTING']['ActiveDirectory']['ca_cert']))    $GLOBALS['_SETTING']['ActiveDirectory']['ca_cert']=(defined('_CA_CERT'))? _CA_CERT:'';
 if (!isset($GLOBALS['_SETTING']['ActiveDirectory']['server_cert']))$GLOBALS['_SETTING']['ActiveDirectory']['server_cert']=(defined('_SERVER_CERT'))? _SERVER_CERT:'';
 if (!isset($GLOBALS['_SETTING']['ActiveDirectory']['server_key'])) $GLOBALS['_SETTING']['ActiveDirectory']['server_key']=(defined('_SERVER_KEY'))? _SERVER_KEY:'';

 if ($GLOBALS['_SETTING']['modules']['signature']==1) {$GLOBALS['_SETTING']['modules']['signature']=0 ; $GLOBALS['_SETTING']['plugins']['signature']=1 ; }

 function parse_url_path($url)
  { if (isset($_SERVER['HTTP_HOST'])) $result['_CUR_DOMAIN'] = $_SERVER['HTTP_HOST'] ; // текущий домен страницы - значение HTTP_HOST более правильное чем SERVER_NAME но есть не всегда
    else                              $result['_CUR_DOMAIN'] = $_SERVER['SERVER_NAME'] ; // текущий домен страницы
    //$url=rawurldecode($url) ;
    $arr=@parse_url($url) ;
    $result['_CUR_SHEME']=(strpos('HTTPS',$_SERVER['SERVER_PROTOCOL'])!==false)? 'https://':'http://' ;
    if ($_SERVER['HTTPS'] && $_SERVER['HTTPS']!='off') $result['_CUR_SHEME']='https://' ;
    $result['_CUR_PAGE_PATH']=$url ;
    $arr_path=explode('/',$arr['path']) ;
    $result['_CUR_ROOT_DIR_NAME']=$arr_path[1] ;
    $result['_CUR_PAGE_NAME']=$arr_path[_sizeof($arr_path)-1] ;
    $result['_CUR_PAGE_NAME_SOURCE']=$arr_path[_sizeof($arr_path)-1] ;
    $result['_CUR_PAGE_IS_PAGINATOR']=0 ;
    // пытаемся определить страницу сайта через $_GET или $_POST
    if ($_POST['page']>1)
    {  $result['_CUR_PAGE_NUMBER']=$_POST['page'];
       $result['_CUR_PAGE_IS_PAGINATOR']=1 ; // помечаем, что текущая страница является страницей пагинатора (при добавлении записи в SEO ей не будут скопированы теги основной страницы)
    }
    if ($_GET['page']>1)
    {  $result['_CUR_PAGE_NUMBER']=$_GET['page'];
       $result['_CUR_PAGE_IS_PAGINATOR']=1 ; // помечаем, что текущая страница является страницей пагинатора (при добавлении записи в SEO ей не будут скопированы теги основной страницы)
    }
    // убираем страницы пагинатора для страниц сайта не в корне
    if (_sizeof($arr_path)>2)
    {   //$result['_CUR_PAGE_NAME']=preg_replace('/page_(.+?)\.html/is','',$result['_CUR_PAGE_NAME']) ;
       if (preg_match_all('/page_(.+?)\.html/is',$result['_CUR_PAGE_NAME'],$matches,PREG_SET_ORDER))
        { $result['_CUR_PAGE_NUMBER']=$matches[0][1];
          $result['_CUR_PAGE_NAME']=str_replace($matches[0][0],'',$result['_CUR_PAGE_NAME']) ;
          $result['_CUR_PAGE_IS_PAGINATOR']=1 ; // помечаем, что текущая страница является страницей пагинатора (при добавлении записи в SEO ей не будут скопированы теги основной страницы)
        }
    }
    if (isset($arr['query'])) parse_str($arr['query'],$get_params) ;
    if (!isset($result['_CUR_PAGE_NUMBER']) and isset($get_params['page'])) $result['_CUR_PAGE_NUMBER']=$get_params['page'];
    if (!isset($result['_CUR_PAGE_NUMBER'])) $result['_CUR_PAGE_NUMBER']=1 ;

    //проверяем директорию на предмет LANG DIR
    if ($result['_CUR_ROOT_DIR_NAME'] and isset($GLOBALS['lang_arr'][$result['_CUR_ROOT_DIR_NAME']]))  { $result['_CUR_LANG']=$result['_CUR_ROOT_DIR_NAME'] ; $result['_CUR_LANG_SUFF']=($GLOBALS['lang_arr'][$result['_CUR_LANG']]['suff'])? $GLOBALS['lang_arr'][$result['_CUR_LANG']]['suff']:$result['_CUR_LANG']; }
    else                                                                                               { $result['_CUR_LANG']='' ; $result['_CUR_LANG_SUFF']='' ; }

    unset($arr_path[_sizeof($arr_path)-1]) ;
    $result['_CUR_PAGE_DIR']=implode('/',$arr_path).'/' ;
    if (isset($arr['query'])) $result['_CUR_PAGE_QUERY']=$arr['query'] ;
    return($result) ;
  }

    // общие настроки ---------------------------------------------------------------------------------------------------
    if (!isset($use_server_proxi)) $use_server_proxi=0 ;
    $log_pages_for_system_ip=1 ; // ведем журнал страниц для системных IP
    $fast_edit_for_system_ip=0 ; // показываем ссылку быстрого редактирования для системных IP
    $send_mail_by_error=1 ;	// уведомлять разработчика о ошибках на сайте
    $alert_moduls=1 ;			// предупреждения модулей в главном меню
    $log_pages_robots=1 ;       // включать в лог загрузки страниц входы роботов
    $log_events_info=1 ;		// вести журнал событий
    $use_trash=0 ;    		// использование мусорной корзины для удаления объектов
    $no_index_robots_php=0;	// запрет для индексации php страниц
    define('_REBOOT_ALL_FOR_SYSTEM_IP',0) ; // постоянная перезагрука движка для системных IP
    $redirect_page_to_main_domains=0 ; // перенапрявлять страницу на основной домен
    $redirect_page_to_main_page=0 ; // перенапрявлять страницу
    $convert_obj_list_to_list_recs=1 ;
    $alert_to_slow_page=0 ;
    $no_access_to_robots=0 ;  // запрет индексации роботами всех страниц сайта (TAG NOINDEX)
    //$reboot_all=1 ;			// принудительно перегружать все данные сайта
    $enabled_fast_edit_to_system_ip=0 ;
    $allow_redirect_to_false_params=1 ; // разреширеть редирект на страницу с разрешенными параметрами запроса (разрешить ограничение парамеров в строке запроса $_GET)
    $allow_filter_GET_params=1 ;
    $save_page_in_sitemap=1 ; // разрешить сохранение страниц в карте сайта

    // настроки для отладки ---------------------------------------------------------------------------------------------------
    $debug=0 ;                // режим отладки
    $debug_trace_level=4 ;	// число уровней трассировки кода, 0 - не показывать трассировку, all - все уровни
    $debug_db=0 ;		    // вывод отладочной информации по запросам к БД, 1 - без трассировки, 2 - с трассировкой
    $debug_db_log=0 ;
    $debug_sql_save_obj=0 ;   // вывод отладочной информации в админке по запросам для сохранения данных
    $debug_mails=0 ;			// вывод отладочной информации по отправляемым письмам (0/1/2)
    $debug_mail_setting=0 ;			// вывод отладочной информации по парамерам отправки почты
    $debug_modul=0 ;			// вывод отладочной информации по подключенным модулям
    $debug_templates=0 ;		// вывод отладочной информации по подключенным шаблонам
    $debug_boot=0 ;			// вывод отладочной информации за старту движка
    $debug_page=0 ;			// вывод отладочной информации по выводимой странице
    $debug_obj_info=0  ;		// вывод отладочной информации по распознованию объекта страницы
    $debug_metatags=0 ;		// вывод отладочной информации по формированию тегов
    $debug_frame_viewer=0 ;
    $debug_admin_menu=0 ;
    $debug_search_panel_function=0 ; // отладка подключаний функций из кнопок
    $time_line_mode=0; 		// фотма трассировки времени (0/1/2/3)
    $debug_trace_files_upload_to_mail=0 ; // трассировка на email информации по загрузке файлов

    define('_DEBUG_CMD_INCLUDE',0) ; // отладка подключения скриптов для выполнения команды кнопок
    define('_MAIN_PROTOCOL',$GLOBALS['_SETTING']['esmo']['protocol'].'://') ;
    define('_TERMINAL_PORT',$GLOBALS['_SETTING']['esmo']['terminal_port']) ;

  // подготавливаем защищенные переменные по текущей странице
  $SF_REQUEST_URI=str_replace(_MAIN_PROTOCOL,'',$_SERVER['REQUEST_URI']) ; // = /data/xml/content.xml, защита от URI типа  /http://******/goods_44040.html
  $SF_REQUEST_URI=str_replace(':///','/',$SF_REQUEST_URI) ;       // защита от ошибки типа parse_url(:///catalog/?xxx=4): Unable to parse URL
  $SF_REQUEST_URI=str_replace('///','/',$SF_REQUEST_URI) ;       // защита от ошибки типа parse_url(///catalog/?yyy=4): Unable to parse URL
  $SF_REQUEST_URI=urldecode($SF_REQUEST_URI) ;
  $SF_REQUEST_URI_arr=@parse_url($SF_REQUEST_URI) ;   // print_r($arr) ;
  $cur_page_path=$SF_REQUEST_URI_arr['path'] ; // в дальшейшем заменить все $url_source на $cur_page_path - $url_source неправильно выделяет имя скрипта, если в строке запроса есть путь

  // новые переменные для упорядочивания работы со страницами
  $_CUR_PAGE=parse_url_path($SF_REQUEST_URI) ;  //echo nl2br(print_r($_CUR_PAGE,true)) ;

  define('_CUR_PAGE_PATH',$_CUR_PAGE['_CUR_PAGE_PATH']) ;   // /catalog/page_2.html?dd=2&hs=2

  define('_SERVER_IP',$_SERVER['SERVER_ADDR']) ;
  define('_USE_SUBDOMAIN',0) ;
  define('_CUR_SHEME',          $_CUR_PAGE['_CUR_SHEME']) ;   // /catalog/page_2.html

  // _BASE_DOMAIN и _MAIN_DOMAIN должны быть прописаны в patch.php при инсталяции сайта - в целях борьбы с подменой HTTP_HOST и SERVER_NAME
  define('_BASE_DOMAIN',$GLOBALS['_SETTING']['esmo']['base_domain']) ;
  define('_MAIN_DOMAIN',$GLOBALS['_SETTING']['esmo']['main_domain']) ;
  define('_MOBILE_DOMAIN',      _MAIN_DOMAIN) ;
  define('_CUR_DOMAIN',         $_CUR_PAGE['_CUR_DOMAIN']) ;   // /catalog/page_2.html
  define('_CUR_SUBDOMAIN',     str_replace(array('.'._BASE_DOMAIN,_BASE_DOMAIN),'',_CUR_DOMAIN))  ;
  define("_ADMIN_",                 'admin');

  define('_CUR_PAGE_MODE',  $_CUR_PAGE['_CUR_ROOT_DIR_NAME']) ;     // catalog
  define('_CUR_ROOT_DIR_NAME',  $_CUR_PAGE['_CUR_ROOT_DIR_NAME']) ;     // catalog
  define('_CUR_PAGE_DIR',       $_CUR_PAGE['_CUR_PAGE_DIR']) ;     // /catalog/
  define('_CUR_PAGE_NAME',      $_CUR_PAGE['_CUR_PAGE_NAME']) ;                    // page_2.html
  define('_CUR_PAGE_NAME_SOURCE',$_CUR_PAGE['_CUR_PAGE_NAME_SOURCE']) ;             // page_2.html
  define('_CUR_PAGE_IS_PAGINATOR',$_CUR_PAGE['_CUR_PAGE_IS_PAGINATOR']) ;
  define('_CUR_PAGE_QUERY',     $_CUR_PAGE['_CUR_PAGE_QUERY']) ; // dd=2&hs=2
  define('_CUR_PAGE_NUMBER',    $_CUR_PAGE['_CUR_PAGE_NUMBER']) ; // 2
  define('_CUR_LANG',    $_CUR_PAGE['_CUR_LANG']) ; // ua
  define('_CUR_LANG_SUFF', $_CUR_PAGE['_CUR_LANG_SUFF']) ; // ua
  define('_CURRENT_USER',$_SERVER['PHP_AUTH_USER']) ; // $_SERVER['PHP_AUTH_USER'];
  //echo '_CUR_DOMAIN='._CUR_DOMAIN.'<br>_CUR_PAGE_PATH='._CUR_PAGE_PATH.'<br>_CUR_ROOT_DIR_NAME='._CUR_ROOT_DIR_NAME.'<br>_CUR_PAGE_DIR='._CUR_PAGE_DIR.'<br>_CUR_PAGE_NAME='._CUR_PAGE_NAME.'<br>_CUR_PAGE_QUERY='._CUR_PAGE_QUERY.'<br>_CUR_PAGE_NUMBER='._CUR_PAGE_NUMBER.'<br>_CUR_LANG='._CUR_LANG.'<br>_CUR_LANG_SUFF='._CUR_LANG_SUFF.'<br>' ;
  define('IP',(($use_server_proxi)? $_SERVER['HTTP_X_FORWARDED_FOR']:$_SERVER['REMOTE_ADDR'])) ;
  define('_IS_SYSTEM_IP',((in_array(IP,$system_IP_list)===true)? 1:0)) ; //echo 'IP='.IP.'<br>' ;
  define('_ENGINE_VERS',str_replace('engine_v','',$GLOBALS['_SETTING']['dist']['engine_version'])) ; // =4.82.8
  define('_SERVER_ENGINE_VERS',$GLOBALS['_SETTING']['dist']['engine_version']) ; // =engine_v4.82.8
  define('_ENGINE_MODE',((_CUR_ROOT_DIR_NAME==_ADMIN_)? 'admin':'site')) ;

  $domain_arr=explode('.',str_replace(_BASE_DOMAIN,'',_CUR_DOMAIN)) ;
  $subdomain=$domain_arr[0] ;
  if (!isset($index_page)) $index_page='/' ;
  if (!isset($index_page_alias)) $index_page_alias=array('/index.php','/index.html','/index.htm') ; // синонимы главной страницы, с них будет 301 перенаправление на главную страницу
  $redicted_pages=array() ;
  if (_sizeof($index_page_alias)) foreach($index_page_alias as $page_name) if ($page_name!=$index_page) $redicted_pages[$page_name]=$index_page ;
  $section_id=0 ;

  //  стандартные имена директорий

  define("_CLASS_",                 $GLOBALS['_SETTING']['dist']['esmo_version']);
  define("_CLASS_LOCAL_",           ($GLOBALS['_SETTING']['dist']['local_version'])? $GLOBALS['_SETTING']['dist']['local_version']:'');
  define("_CLASS_VERS",             str_replace('class_v','',_CLASS_));
  define("_LOCAL_VERS",             str_replace('local_v','',_CLASS_LOCAL_));
  define("_INIT_",                  'init.php');
  define("_ADDONS_",                'AddOns');
  define('_PUBLIC_',                'public') ;
  define('_DELETED_',               '!deleted') ;
  // директриии плагинов
  define('_PHP_MAILER_',            'PHPMailer_v5.1') ;
  //define('_PHP_MAILER_',            'PHPMailer_v5.2.14') ;
  //define('_MOOTOOLS_FILEMANAGER_',  'none') ; // cpojer-mootools-filemanager-751d4ef
  define('_HIGHSLIDE_',             'highslide-4.1.12') ;
  define('_CKEDITOR_',              'ckeditor_v4.4.4_full') ;

  // используемые плагины
  define('_GEO_IP_METHOD_',         'NONE') ; //  ipGeoBase - web-сервис, GeoIP_mod - расширение PHP "GeoIP", GeoIP_db - локальная версия GeoIP в папке /AddOns/Geo/
  define('_ASYNC_SEND_MAIL',1) ; // асинхронная отправка писем

  // настройки БД
  define('_DB_ALLOW_PROCEDURE',     0) ;
  define('_DB_ALLOW_TRIGGERS',      0) ;

  // внутренние пути к директориям сайта
  // !!!! ВНИМАНИЕ! все пути к директориям НЕ ДОЛЖНЫ заканчиваться слешем.
  define('_DIR_TO_ROOT',        $_SERVER['DOCUMENT_ROOT']);
  define('_DIR_TO_ENGINE',      _DIR_TO_ROOT.'/'._SERVER_ENGINE_VERS);
  define('_DIR_TO_ADMIN',       _DIR_TO_ROOT.'/'._ADMIN_) ;
  define('_DIR_TO_CLASS',       _DIR_TO_ROOT.'/'._CLASS_);
  define('_DIR_TO_CLASS_LOCAL', _DIR_TO_ROOT.'/'._CLASS_LOCAL_);
  define('_DIR_TO_TEMPLATES',   _DIR_TO_ROOT.'/'._CLASS_.'/templates') ;
  define('_DIR_TO_MODULES',     _DIR_TO_ROOT.'/'._CLASS_.'/engine_moduls') ;
  define('_DIR_TO_MODULES_LOCAL', _DIR_TO_ROOT.'/'._CLASS_LOCAL_.'/engine_moduls') ;
  define('_DIR_TO_SITE_EXT',    _DIR_TO_ROOT.'/'._CLASS_.'/ext') ;
  define('_DIR_EXT',            _DIR_TO_ROOT.'/'._CLASS_.'/ext') ;
  define('_DIR_EXT_LOCAL',      _DIR_TO_ROOT.'/'._CLASS_LOCAL_.'/ext') ;
  define('_DIR_TO_PUBLIC',      _DIR_TO_ROOT.'/'._PUBLIC_) ;
  define('_DIR_TO_ADDONS',      _DIR_TO_ROOT.'/'._ADDONS_) ; ;
  define('_DIR_TO_DELETED',     _DIR_TO_ADMIN.'/'._DELETED_) ; ;
  define('_DIR_TO_CLSS',        _DIR_TO_ENGINE.'/class') ;
  define('_DIR_TO_EXTENSIONS',  _DIR_TO_ENGINE.'/extensions') ;
  define('_DIR_ENGINE_EXT',     _DIR_TO_ENGINE.'/ext') ;
  define('_DIR_TO_ADMIN_ADDONS',_DIR_TO_ENGINE.'/'._ADDONS_) ;

  // внешние пути к директориям сайта
  // !!!! ВНИМАНИЕ! все пути к директориям НЕ ДОЛЖНЫ заканчиваться слешем.
  define("_PATH_TO_SITE",        _MAIN_PROTOCOL._MAIN_DOMAIN);
  define("_PATH_TO_EXT",         '/'._CLASS_.'/ext');
  define("_EXT",                 '/'._CLASS_.'/ext');
  define("_PATH_TO_MODULES",     '/'._CLASS_.'/engine_moduls');
  define("_PATH_TO_ENGINE",      '/'._SERVER_ENGINE_VERS);
  define('_PATH_TO_ADMIN',       '/'._ADMIN_) ;
  define('_PATH_TO_PUBLIC',      '/'._PUBLIC_) ;
  define('_PATH_TO_ADDONS',      '/'._ADDONS_) ;
  define('_PATH_TO_DELETED',     _PATH_TO_ADMIN.'/'._DELETED_) ;
  define('_PATH_TO_ADMIN_ADDONS',_PATH_TO_ENGINE.'/'._ADDONS_) ;
  define('_PATH_TO_ADMIN_IMG','/'._CLASS_.'/ext/desktop/images/') ;
  define('_PATH_TO_BASED_CLSS_IMG','/'._CLASS_.'/ext/desktop/images/clss') ;
  define('_PATH_TO_MODUL_CLSS_IMG','/'._CLASS_.'/ext/desktop/images/clss') ;
  define('_BASE_PAGE',_DIR_TO_CLASS.'/c_page.php') ;
  define('_OK_','<span class=green>OK</span>') ;
  define('_ERROR_','<span class=red>ERROR</span>') ;

  // настройки для движка
  define('_EMAIL_ENGINE_ALERT','info@kvzrm.ru') ; // куда будет уходить почта о ошибках, подмене имени сайта и попытках взлома сайта
  define('_ENGINE_SERVER','git.kvzrm.ru') ; // адрес, с которого будут загружаться инсталируемые файлы - старая версия, но пока поддерживаем
  define('_PATH_TO_SERVER_SETUP_ALT','https://'._ENGINE_SERVER.'/setup_UTF8') ; // адрес, с которого будут загружаться инсталируемые файлы - старая версия, но пока поддерживаем

  // настройки для сайта
  define('_ENGINE_DEMO_MODE',0) ; //взамен $read_only_mode
  define('_INDEX_PAGE_NAME','Главная страница') ;
  define('_DEFAULT_TREE_ORDER','indx') ;
  define('_URL_SPACE','_') ;
  define('_URL_LANG','TRANSLIT') ; // LOCAL,TRANSLIT
  define('_URL_MODE','TREE_NAME') ; // TREE_NAME,TREE_ID
  define('_PAGE_NUMBER_SOURCE','in_name') ;
  define('_CREATE_DIR_PERMS',0775) ;
  define('_CREATE_FILE_PERMS',0664) ;
  define('_SHOW_404_AS_PAGE',1) ; // показыать 404 ошибку в контенте страницы сайта
  define('_DB_CHARSET','utf8') ; // показыать 404 ошибку в контенте страницы сайта
  define('_CONVERT_UPLOADED_GIF_TO_JPG',0) ; // преобразовывать загруженные GIF в JPG
  define('_SITE_CREATE_FULL_MODEL',1) ; // загружать для сайта полную модель классов
  //define('_YEAR',date('Y')) ; // текущий год
  define('_USE_SITE_MAP',0) ; // использовать карту сайта для хранения URL
  define('_USE_SITE_INFO',0) ; // использовать блоки информации
  define('_USE_SITE_BANNER',0) ; // использовать баннеры
  define('_USE_SITE_MENU',0) ; // использовать меню сайта

  define('SITE_CODE',       'site') ;
  define('ADMIN_CODE',      'admin') ;
  define('TM_DOT',          'obj_descr_obj_tables') ;
  define('TM_SETTING',      'obj_'.SITE_CODE.'_setting') ;
  define('TM_CRONTAB',      'obj_'.SITE_CODE.'_crontab') ;
  define('TM_MAILS',        'obj_'.SITE_CODE.'_mails') ;
  define('TM_SITE_MENU',    'obj_'.SITE_CODE.'_site_menu') ;
  define('TM_PAGES',        'obj_'.SITE_CODE.'_pages') ;
  define('TM_SITEMAP',      'obj_'.SITE_CODE.'_sitemap') ;
  define('TM_INFO',         'obj_'.SITE_CODE.'_info') ;
  define('TM_KEYWORDS',     'obj_'.SITE_CODE.'_keywords') ;
  define('TM_BANNERS',      'obj_'.SITE_CODE.'_banners') ;
  define('TM_LIST',         'obj_'.SITE_CODE.'_list') ;
  define('TM_PERSONAL',     'obj_'.SITE_CODE.'_personal') ;
  define('TM_LINK',         'obj_'.SITE_CODE.'_link') ;
  define('TM_MAIL_TURN',    'obj_'.SITE_CODE.'_mail_turn') ;
  define('TM_LOG_PAGES',    'log_'.SITE_CODE.'_pages') ;
  define('TM_LOG_EVENTS',   'log_'.SITE_CODE.'_events') ;
  define('TM_LOG_SEARCH',   'log_'.SITE_CODE.'_search') ;
  define('TM_LOG_BANNERS',  'log_'.SITE_CODE.'_banners') ;
  define('TM_LOG_SQL_ERRORS','log_'.SITE_CODE.'_sql_errors') ;
  define('TM_LOG_SQL_LONG',  'log_'.SITE_CODE.'_sql_long') ;

  mb_internal_encoding("UTF-8");
  //session_set_cookie_params(time()+31536000, '/', '.'._BASE_DOMAIN);  // при обращении к сайту по  IP нарушается работа сессий
  //session_set_cookie_params(10, '/');

  // отдельное название для сессии в браузере, чтобы данные админки не смешивались с данными сайта в пределах одного браузера и домена
  if (!isset($session_name) or !$session_name) $session_name=str_replace('.','',_ENGINE_MODE._MAIN_DOMAIN) ;  // разводим сессию сайта и админки
  session_name($session_name) ;


  if (_IS_SYSTEM_IP)
  {  $info_db_error=1 ; 		// выводить на экран информацию о ошибках SQL
  	 $show_errors=1;			// показывать ошибки
  	 $error_report_level=E_ALL^E_NOTICE ;
  } else
  {
  	 $info_db_error=0 ; 		// не выводить на экран информацию о ошибках SQL
  	 $show_errors=0 ;			// не показывать ошибки
  	 $error_report_level=0 ;
  }

  set_include_path(_DIR_TO_CLASS);
  set_include_path(_DIR_TO_TEMPLATES);

  //ini_set('session.cookie_domain','.'._BASE_DOMAIN) ;  // при обращении к сайту по  IP нарушается работа сессий
  ini_set('display_errors',$show_errors) ;
  ini_set('display_startup_errors',$show_errors) ;
  ini_set('track_errors','on') ;
  ini_set('ignore_repeated_errors','on') ;
  ini_set('ignore_repeated_source','on') ;
  ini_set('allow_url_fopen','on') ;
  ini_set('zend.ze1_compatibility_mode','0') ;
  ini_set('allow_call_time_pass_reference','0') ;
  ini_set('register_argc_argv','0') ;
  ini_set('register_long_arrays','0') ;
  ini_set('magic_quotes_gpc','on') ;
  ini_set('magic_quotes_runtime','0') ;
  ini_set('variables_order','EGPCS') ;
  //ini_set('upload_max_filesize','8000') ;
  //ini_set('post_max_size','8M') ;

  error_reporting($error_report_level);

  mb_internal_encoding("UTF-8");

  $GLOBALS['YES']='<span class=green>Да</span>' ;
  $GLOBALS['NO']='<span class=red>Нет</span>' ;

  // Пароль храниться в зашифрованном виде и рядом ключ шифрования
  // если ключа рядом нет - отрабатываться не будет
  $ini2_fname=_DIR_TO_ROOT.'/cab/ic13267832.yaml' ;
  $key_setting=(file_exists($ini2_fname))? Spyc::YAMLLoad($ini2_fname):array();
  if (isset($key_setting['sdfjhaskjfdhabfak']))                 define('_CRYPT_KEY',$key_setting['sdfjhaskjfdhabfak']);             // правильно
  else if ($GLOBALS['_SETTING']['main_db']['crypt_key'])        define('_CRYPT_KEY',$GLOBALS['_SETTING']['main_db']['crypt_key']);  // устарело
  else                                                          define('_CRYPT_KEY','bf39e14bc0d1949ba9a269109092672d');            // устарело
  if (isset($key_setting['wfhksjhdfsufauisy']))                 define('_APP_KEY',$key_setting['wfhksjhdfsufauisy']);
  else if ($GLOBALS['_SETTING']['ActiveDirectory']['app_key'])  define('_APP_KEY',$GLOBALS['_SETTING']['ActiveDirectory']['app_key']);
  else                                                          define('_APP_KEY','NIkOITgy0zN0qOwsjDrtxUXmYllWy9d+Jfz2W+0jP1U=');

  // фрагменты URL по которым можно определить, что идет попытка атаковать сайт
  $url_attack_string=array('FCKeditor','fckeditor','eval','_SERVER','_CONFIG','module_root_path','passwd','etc','allow_url_include','auto_prepend_file','dsafe_mode','group_concat','phpinfo',' or ',' and ','select','script') ;

  // переменные старых версий, используются только для совместимости. При вервой возможности заменять эти переменные на константы
  $dir_to_engine    =_DIR_TO_ENGINE.'/' ;       // более не используется

  // временно оставляем так как в старых админках опции подвязаны на заглобаленные переменные
  $TM_setting=TM_SETTING ;
  $TM_mails=TM_MAILS ;
  $TM_site_menu=TM_SITE_MENU ;
  $TM_pages=TM_PAGES ;
  $TM_sitemap=TM_SITEMAP ;
  $TM_info=TM_INFO ;
  $TM_keywords=TM_KEYWORDS ;
  $TM_banners=TM_BANNERS ;
  $TM_list=TM_LIST ;
  $TM_admin_personal=TM_PERSONAL ;
  $TM_log_pages=TM_LOG_PAGES ;
  $TM_log_events=TM_LOG_EVENTS ;
  $TM_log_search=TM_LOG_SEARCH ;
  $TM_log_banners=TM_LOG_BANNERS ;
  $TM_log_errors=TM_LOG_SQL_ERRORS ;
  $TM_log_admin_events=TM_LOG_EVENTS ;


  // пока не будут убраны все globals из большой админки
  //extract($_REQUEST);

  // переводим в константы настройки из ini.yaml
  // если контанты были объявлены ранее в patch.php - ничего не произойдет

  // ESMO
  define('_LOGO_CAB',$GLOBALS['_SETTING']['interface']['logo_cab']) ; //
  define('_LOGO_CAB_SMALL',$GLOBALS['_SETTING']['interface']['logo_cab_small']) ; //
  define('_ADMIN_LOGO_SRC',$GLOBALS['_SETTING']['interface']['admin_logo_src']) ;
  define('_DEFAULT_TIMEZONE',$GLOBALS['_SETTING']['esmo']['default_timezone']) ;
  define('_HTML2PDF_',$GLOBALS['_SETTING']['esmo']['html2pdf']) ;
  define('_THEME_',$GLOBALS['_SETTING']['interface']['theme']) ;
  define('_SESSION_LIFE_TIME',($GLOBALS['_SETTING']['security']['session_life_time'])? $GLOBALS['_SETTING']['security']['session_life_time']:31536000) ;
  define("LF","\n") ;

  date_default_timezone_set(_DEFAULT_TIMEZONE) ;

  //DB cluster
  define('_CLUSTER_NODE_ID', (int)getenv('NODE_ID')); // 0
  define('_USE_DB_CLASTER',$GLOBALS['_SETTING']['main_db']['use_db_cluster']) ;
  define('_USE_DB_CLUSTER_debug',$GLOBALS['_SETTING']['main_db']['use_db_cluster_debug']);

  // AD setting
  $AD_settings=$GLOBALS['_SETTING']['ActiveDirectory'] ;
  define('_CA_CERT', $AD_settings['ca_cert']);
  define('_SERVER_CERT', $AD_settings['server_cert']);
  define('_SERVER_KEY', $AD_settings['server_key']);

/*if (!isset($GLOBALS['_SETTING']['esmo']['modules']))
{ if (file_exists($_SERVER['DOCUMENT_ROOT'].'/ini/ini.yaml')) ;
	{ include($_SERVER['DOCUMENT_ROOT'].'/ini/spyc.php');
      $_SETTING = Spyc::YAMLLoad($_SERVER['DOCUMENT_ROOT'].'/ini/ini.yaml');
	}
} */

//print_r($GLOBALS['_SETTING']['main_db'])  ;

// автозагрузчик вызывается
// 1. в момент session_start()  для unserialize объектов классов, которые сохранены в сессии
// поэтому, если в сессии храниться объект класса, но в обновлении он будет храниться в GLOBALS - ошибки не будет
// только он будет занимать место в сессии, пока не будет удален
function engine_modul_autoload($class_name)
{ // проверяем модули
  //echo '$class_name='.$class_name.'<br>' ;

  // проверка подключения класса через namespace, например // \esmo\engine\i_page_filter
  $arr=[] ;
  if (stripos($class_name,'\\')!==false) $arr=explode('\\',$class_name);
  //print_r($arr);
  if (_sizeof($arr))
  {
    if ($arr[0]=='esmo' and $arr[1]=='ext') include_once(_DIR_EXT.'/'.$arr[2].'/'.$arr[3].'.php') ;
    else if ($arr[0]=='esmo_local' and $arr[1]=='ext') include_once(_DIR_EXT_LOCAL.'/'.$arr[2].'/'.$arr[3].'.php') ;
    else if ($arr[0]=='cab_local' and $arr[1]=='ext') include_once(_DIR_EXT_LOCAL.'/'.$arr[2].'/'.$arr[3].'.php') ;
    else if ($arr[0]=='cab' and $arr[1]=='ext') include_once(_DIR_EXT.'/'.$arr[2].'/'.$arr[3].'.php') ;
    else if ($arr[0]=='cab' and $arr[1]=='system') include_once(_DIR_TO_CLASS.'/system/class/'.$arr[2].'.php') ;
    else if ($arr[0]=='esmo') include_once(_DIR_TO_MODULES.'/'.$arr[1].'/'.$arr[2].'.php') ;
    else if ($arr[0]=='cab' and stripos($arr[1],'c_')!==false) include_once(_DIR_TO_CLASS.'/'.$arr[1].'.php') ;
    else if ($arr[0]=='cab') include_once(_DIR_TO_MODULES.'/'.$arr[1].'/'.$arr[2].'.php') ;
    else if ($arr[0]=='cab_local') include_once(_DIR_TO_MODULES_LOCAL.'/'.$arr[1].'/'.$arr[2].'.php') ;

  }
  elseif (preg_match_all('/c_page_(.+?)/is',$class_name,$math))
  {

  }
  elseif (preg_match_all('/c_(.+?)_system_install/is',$class_name,$math))
  {

  }
  else if (preg_match_all('/c_(.+?)_system/is',$class_name,$math))
  { $modul_name=$math[1][0] ;
    //include_modul($dir,$modul_name);

    if (!$GLOBALS['_SETTING']['modules_local'][$modul_name]) GENERAL()->include_modul(_DIR_TO_MODULES,$modul_name) ;
    else                                                     GENERAL()->include_modul(_DIR_TO_MODULES_LOCAL,$modul_name) ;
    //damp_array($math,1,-1) ; echo '<br>' ;
    set_time_point('engine_modul_autoload - include_modul "<strong>'.$modul_name.'</strong>"') ;
  }
  // проверяем плагины
  elseif (file_exists(_DIR_TO_MODULES.'/plugins/'.$class_name.'.php'))
  {
    include_once(_DIR_TO_MODULES.'/plugins/'.$class_name.'.php') ;
  }
  // остальные классы
  // по хорошему надо их собрать в отдельную директорию, разместить в каждом скрипте по классу и подгружать автоматически
  else
  {
    switch($class_name)
    { case 'i_setup': include_once(_DIR_TO_MODULES.'/engine/i_setup.php') ; break ;
      case 'c_doc': include_once(_DIR_TO_MODULES.'/engine/i_doc.php') ; break ;
      case 'c_report_graf':
      case 'c_report': include_once(_DIR_TO_MODULES.'/engine/i_report.php') ; break ;
      case 'JSON':
      case 'c_multiSQL_insert': include_once(_DIR_TO_MODULES.'/engine/m_engine.php') ; break ;
      case 'c_IL_list':
      case 'c_ARR_list':
      case 'c_lists': include_once(_DIR_TO_MODULES.'/engine/i_lists.php') ; break ;
      case 'i_device': include_once(_DIR_TO_MODULES.'/engine/i_device.php') ; break ;
      case 'c_mail_system':
      case 'c_mailbox': include_once(_DIR_TO_MODULES.'/engine/i_mailbox.php') ; break ;
      case 'c_json_logs':
      case 'c_logs':
      case 'c_file_log': include_once(_DIR_TO_MODULES.'/engine/i_logs.php') ; break ;
      case 'i_disk': include_once(_DIR_TO_MODULES.'/engine/i_disk.php') ; break ;
      case 'i_IB':
      case 'i_IB_work': include_once(_DIR_TO_MODULES.'/engine/i_ib.php') ; break ;
      case 'i_IM': include_once(_DIR_TO_MODULES.'/engine/i_imagemagic.php') ; break ;
      case 'i_io': include_once(_DIR_TO_MODULES.'/engine/i_io.php') ; break ;
      case 'i_cab_menu_yaml': include_once(_DIR_TO_MODULES.'/engine/i_cab_menu_yaml.php') ; break ;
      case 'i_media_server': include_once(_DIR_TO_MODULES.'/engine/i_media_server.php') ; break ;
      case 'i_messages': include_once(_DIR_TO_MODULES.'/engine/i_messages.php') ; break ;
      case 'i_tree': include_once(_DIR_TO_MODULES.'/engine/i_tree.php') ; break ;
      case 'i_personals_filter': include_once(_DIR_TO_MODULES.'/personal/i_personals_filter.php') ; break ;
      case 'ARR_deps': include_once(_DIR_TO_MODULES.'/personal/ARR_deps.php') ; break ;
      case 'ARR_accounts': include_once(_DIR_TO_MODULES.'/accounts/ARR_accounts.php') ; break ;
      case 'i_workgroups': include_once(_DIR_TO_MODULES.'/accounts/i_workgroups.php') ; break ;
      case 'i_esmo_rules': include_once(_DIR_TO_MODULES.'/aspmo/i_esmo_rules.php') ; break ;
      case 'i_esmo_rules_kt': include_once(_DIR_TO_MODULES.'/kt/i_esmo_rules_kt.php') ; break ;
      case 'clss_0': include_once(_DIR_TO_ENGINE.'/class/clss_0.php') ; break ;
      case 'c_obj':
      case 'c_obj_clss': include_once(_DIR_TO_ENGINE.'/c_objects.php') ; break ;
      case 'report_personals': include_once(_DIR_EXT.'/personal/report_personals.php') ; break ;
      // классы, которые игнорим
      case 'c_obj_table': break ;
      /*default:
      ?><h3>engine_modul_autoload(<?echo $class_name?>)</h3><?
      trace() ;*/
    }

  }
  //include_once($class_name.'.php') ;
}

spl_autoload_register('engine_modul_autoload') ;

function _sizeof($a)
{   if (isset($a))
    {   if (is_object($a)===true or is_array($a)===true)
        return(count($a)) ;
        else return(false) ;
    } else return(false) ;
}



?>
