// загружаем файл во временную директорию в возвращаем скрытую переменную с именем файла
$j.fn.file_uploader = function(options)
{ var settings = $j.extend(
           {  'debug' : 0,
              'upload_url'    :  '/cab/upload_files/recipient/',
              'upload_params'    :  {},
              'filter'    :  null,//'jpg;pdf;png;gif',
              'allowedTypes' :  '',  // image/*   application/*
              'SendFormOnUploadSuccess' :  0,  // image/*   application/*
              'ExecAjaxCmdOnUploadSuccess' :  0,  // image/*   application/*
              'onUploadSuccessFunction' :  null,  // image/*   application/*
           }, options);

  var panel=this ;

  console.log(settings) ;
  console.log(panel) ;

    //-- Some functions to work with our UI
     function add_log(message)
     { var template = '<li>[' + new Date().getTime() + '] - ' + message + '</li>';
       $j(panel).find('#debug').find('ul').prepend(template);
     }

     function add_file(id, file)
     { var template = '' +
         '<div class="file" id="uploadFile' + id + '">' +
           '<div class="info">' +
             '#1 - <span class="filename" title="Size: ' + file.size + 'bytes - Mimetype: ' + file.type + '">' + file.name + '</span><br /><small>Status: <span class="status">Waiting</span></small>' +
           '</div>' +
           '<div class="bar">' +
             '<div class="progress" style="width:0%"></div>' +
           '</div>' +
         '</div>';

         $j(panel).find('#fileList').prepend(template);
     }

     function update_file_status(id, status, message)
     {
         $j(panel).find('#uploadFile' + id).find('span.status').html(message).addClass(status);
     }

     function update_file_progress(id, percent)
     {
         $j(panel).find('#uploadFile' + id).find('div.progress').width(percent);
     }

     // Upload Plugin itself
    $j(panel).find('#drag-and-drop-zone').dmUploader({
       url: settings.upload_url,
       dataType: 'json',
       extraData: settings.upload_params,  // будет передано через POST
       allowedTypes: settings.allowedTypes,
       extFilter: settings.filter,

       onInit: function()
       { add_log('Загрузщик готов к работе');
       },
       onBeforeUpload: function(id)
       { add_log('Начало загрузки файла #' + id);
         update_file_status(id, 'uploading', 'Загрузка...');
       },
       onNewFile: function(id, file)
       { add_log('Файл поставлен в очередь загрузки #' + id);
         add_file(id, file);
       },
       onComplete: function()
       { add_log('Все загрузки завершены');
       },
       onUploadProgress: function(id, percent)
       { var percentStr = percent + '%';
         update_file_progress(id, percentStr);
       },
       onUploadSuccess: function(id, data)
       { add_log('Загрузка файла #' + id + ' завершена');
         //add_log('Ответ сервера по файлу #' + id + ': ' + JSON.stringify(data));
         add_log('Ответ сервера по файлу #' + id + ': ' + data.status);
         update_file_status(id, 'success', 'Загрузка завершена');
         update_file_progress(id, '100%');
         $j('div#report').html(data.report) ;
         //console.log(settings) ;
         if (settings.onUploadSuccessFunction!=null)  settings.onUploadSuccessFunction(data) ;
         // если документ загружен не Техником ПДД на АТП - перейти к обработке документа
         //if (data.account_rol_id!=12) document.window.location='/cab/esmo_magnit/pdd/scan/'+data.scan_id+'/' ;
         if (settings.SendFormOnUploadSuccess) $j(this).closest('form').find('input[type=submit]').click() ;
          
       },
       onUploadError: function(id, message)
       { add_log('Failed to Upload file #' + id + ': ' + message);
         update_file_status(id, 'error', message);
       },
       onFileTypeError: function(file)
       { add_log('File \'' + file.name + '\' cannot be added: must be an image');
       },
       onFileSizeError: function(file){
         add_log('File \'' + file.name + '\' cannot be added: size excess limit');
       },
       /*onFileExtError: function(file){
         $.danidemo.addLog('#demo-debug', 'error', 'File \'' + file.name + '\' has a Not Allowed Extension');
       },*/
       onFallbackMode: function(message)
       { alert('Browser not supported(do something else here!): ' + message);
       }
     });




}