<?php
include_once('c_skd.php') ;
include_once(_DIR_TO_MODULES.'/m_skd.php');
class c_page_cab_skd_terminals extends c_page_cab_skd
{
    public $h1 = 'Конфигурация устройств СКД';

    function block_main()
    {
        $this->panel_terminal_create() ;
        $this->panel_terminal_list();
    }

    function panel_terminal_create()
    {
        $this->page_title('Терминалы турникета') ;
        $arr_groups=SKD()->get_list_zone() ;
        ?><div id="panel_filter">
        <form id="sky-form_termianl" class="sky-form">
            <input type="hidden" name="filter_dir" value="<?echo _CUR_REPORT_DIR?>">
            <fieldset>
                <div class="row">
                    <section class="col col-4">
                        <label class="label">Зона доступа</label>
                        <label class="select">
                            <select name="filter[zone_id]" data-required >
                                <?if (_sizeof($arr_groups)) foreach($arr_groups as $rec){?><option value="<?echo $rec['pkey']?>"><?echo SKD()->get_full_zone_path($rec['pkey'])?></option><?}?>
                            </select>
                        </label>
                    </section>
                    <section class="col col-3">
                        <label class="label">Название терминала:</label>
                        <label class="input"><input type="text" data-required name="filter[name]" value="<?echo $this->filter['name']?>" autocomplete="off"></label>
                    </section>
                </div>
                <div class="row">
                    <section class="col col-2">
                        <label class="label">ID терминала:</label>
                        <label class="input"><input type="text" data-required name="filter[id]" value="<?echo $this->filter['id']?>" autocomplete="off"></label>
                    </section>
                    <section class="col col-2">
                        <label class="label">IP адрес:</label>
                        <label class="input"><input type="text" data-required name="filter[ip]" value="<?echo $this->filter['ip']?>" autocomplete="off"></label>
                    </section>
                    <section class="col col-2">
                        <label class="label">Версия терминала:</label>
                        <label class="input"><input type="text" data-required name="filter[version]" value="<?echo $this->filter['version']?>"></label>
                    </section>
                </div>
            </fieldset>
            <div id="panel_buttons"><input type="submit" class="button v2" cmd="skd/terminal_create" value="Добавить терминал"  validate="form"></div><br>
        </form>
        </div><br>
        <?
    }

    function panel_terminal_list()
    {
        $terminals = SKD()->get_list_terminals();
        $i=0; ?>
        <table class="basic fz_small auto">
            <tr>
                <th>№</th>
                <th>Зона доступа</th>
                <th>Турникет</th>
                <th>ID</th>
                <th>IP</th>
                <th>Версия ПО</th>
                <th>Карточка турникета</th>
            </tr>
            <? foreach ($terminals as $terminal) {
                $i++;?>
                <tr>
                    <td><?echo $i;?></td>
                    <td><?echo SKD()->get_full_zone_path($terminal['parent'])?></td>
                    <td><?echo $terminal['obj_name']?></td>
                    <td><?echo $terminal['device_ID']?></td>
                    <td><?echo $terminal['ip']?></td>
                    <td><?echo $terminal['version']?></td>
                    <td><a href="/window/skd/setting/terminal/<?echo $terminal['pkey']?>/" class="new_window">Карточка</a></td>
                </tr>
            <?}?>
        </table><?
    }

}
?>
