<?php
include_once("c_skd.php");
class c_page_cab_skd_setting_zone_terminal extends c_page_cab_skd
{
    public $h1='Карточка зоны доступа' ;
    public $rec_zone ;

    function select_obj_info()
    {
        $cur_id=(_CUR_ID)? _CUR_ID:MEMBER()->id ;
        $this->rec_zone=SKD()->get_zone_by_pkey($cur_id) ;
        if (!$this->rec_zone['pkey']) $this->result=404 ;
        else $this->h1='Карточка турникетов зоны доступа "'.$this->rec_zone['obj_name'].'"' ;
    }

    function block_main()
    {
        $this->page_title() ;
        $this->panel_terminal_list() ;
    }

    function menu_config()
    {
        if (_CUR_ROOT_DIR_NAME=='cab') parent::menu_config() ;
        elseif ($this->rec_zone['pkey'])
        {
            $this->menu['/window/skd/setting/zone/'.$this->rec_zone['pkey'].'/']=array('title'=>'Карточка группы "'.$this->rec_zone['obj_name'].'"','_class'=>'fa fa-user-md') ;
            $this->menu['/window/skd/setting/zone/'.$this->rec_zone['pkey'].'/terminal/']=array('title'=>'Турникеты','_class'=>'fa fa-user-md') ;
        }
    }

    function second_menu_config()
    {}

    function panel_terminal_list()
    {
        $terminals = SKD()->get_list_terminals('parent='.$this->rec_zone['pkey']);
        $i=0; ?>
        <table class="basic fz_small auto">
        <tr>
            <th>№</th>
            <th>Зона доступа</th>
            <th>Турникет</th>
            <th>ID</th>
            <th>IP</th>
            <th>Версия ПО</th>
            <th>Карточка турникета</th>
        </tr>
        <? foreach ($terminals as $terminal) {
            $i++;?>
            <tr>
                <td><?echo $i;?></td>
                <td><?echo SKD()->get_full_zone_path($terminal['parent'])?></td>
                <td><?echo $terminal['obj_name']?></td>
                <td><?echo $terminal['device_ID']?></td>
                <td><?echo $terminal['ip']?></td>
                <td><?echo $terminal['version']?></td>
                <td><a href="/window/skd/setting/terminal/<?echo $terminal['pkey']?>/" class="new_window">Карточка</a></td>
            </tr>
        <?}?>
        </table><?
    }

}



?>