<?php
include_once(_DIR_TO_CLASS.'/c_page.php') ;
include_once(_DIR_TO_MODULES.'/m_skd.php');
class c_page_cab_skd extends c_page
{
    public $h1 = 'Конфигурация устройств СКД';


    function second_menu_config()
    {
        $this->second_menu['/cab/skd/']=array('title'=>'Зоны доступа') ;
        $this->second_menu['/cab/skd/terminals/']=array('title'=>'Терминалы турникета') ;
        $this->second_menu['/cab/skd/access_point/']=array('title'=>'Точки доступа') ;
    }

    function block_main()
    {
        $this->panel_group_create() ;
        $this->panel_terminal_list();
    }

    function get_list_terminals($pkey=1)
    {
        $res=execSQL('select * from obj_site_skd where clss=606 and parent='.$pkey) ;
        return($res) ;
    }

    function panel_group_create()
    {
        $this->page_title('Зоны доступа') ;
        $arr_groups=SKD()->get_list_zone() ;
        ?>
        <div id="panel_filter">
            <form id="sky-form_zone" class="sky-form">
                <input type="hidden" name="filter_dir" value="<?echo _CUR_REPORT_DIR?>">
                <fieldset>
                    <div class="row">
                        <section class="col col-4">
                            <label class="label">Родительская зона доступа</label>
                            <label class="select">
                                <select name="filter[zone_id]">
                                    <?if (_sizeof($arr_groups)) foreach($arr_groups as $id=>$rec){?><option value="<?echo $id?>"><?echo SKD()->get_full_zone_path($id) ?></option><?}?>
                                </select>
                            </label>
                        </section>
                        <section class="col col-3">
                            <label class="label">Название зоны доступа:</label>
                            <label class="input"><input type="text" data-required name="filter[name]" value="<?echo $this->filter['name']?>" autocomplete="off"></label>
                        </section>
                    </div>
                </fieldset>
                <div id="panel_buttons"><input type="submit" class="button v2" cmd="skd/zone_create" value="Добавить зону доступа"  validate="form"></div><br>
            </form>
        </div><br>
        <?
    }

    function panel_terminal_list()
    {
        $arr_groups=SKD()->get_list_zone() ;?>
        <table class="basic fz_small auto">
        <tr>
            <th>ID</th><th>Зона доступа</th><th width="250">Терминалы</th><th>Карточка зоны</th>
        </tr>
        <? if (_sizeof($arr_groups)) foreach ($arr_groups as $group) {?>
        <tr>
            <td><?echo $group['pkey']?></td>
            <td class="left"><?echo SKD()->get_full_zone_path($group['pkey']);?></td>
            <td class="left">
                <?
                $recs = $this->get_list_terminals($group['pkey']);
                foreach ($recs as $rec) echo '<p>'.$rec['obj_name'].'</p>';
                ?>
            </td>
            <td><a href="/window/skd/setting/zone/<?echo $group['pkey']?>/" class="new_window">Карточка</a></td>
        </tr>
    <?}?>
        </table><?
    }

}
?>
