<?php
include_once(_DIR_TO_CLASS . '/c_page.php');

class c_page_cab_send_report extends c_page
{
    public $h1 = 'Список отчетов';
    public $report_recs = [];
    public $formated_recs = [];

    function set_head_tags()
    {
        parent::set_head_tags();
        $this->HEAD['css'][] = _PATH_TO_EXT . '/send_report/style.css';
    }

    function second_menu_config()
    {
        $this->second_menu['/cab/send_report/'] = array('title' => 'Список отчетов');
        $this->second_menu['/cab/send_report/journal/'] = array('title' => 'Архив');
    }

    function block_main()
    {
        SEND_REPORT()->update_report_list();
        $this->page_title();
//        $this->button_panel();

        $this->report_recs = SEND_REPORT()->get_send_report_list();
//        damp_array($this->report_recs);
        $this->prepare_data();

        $this->view_report_list();
    }

    function button_panel()
    {
        ?>
        <div id="panel_hand_TO">
            <form class="sky-form no_box_shadow">
                <div class="left">
                    <button class="button v2" style="float: none; margin: 0;" cmd="send_report/update_report_list">Обновить список</button>
                </div>
            </form>
        </div>
        <?
    }

    function prepare_data()
    {
        $this->formated_recs=[];
        if (_sizeof($_SESSION['indx_report_section'])) {
            $temp_array = array_flip($_SESSION['indx_report_section']);
            foreach ($temp_array as $key=>$value) $this->formated_recs[$key]=[];
        }

        foreach ($this->report_recs as $report_rec) {
            $this->formated_recs[$report_rec['section_title']][]=$report_rec;
        }
    }

    function view_report_list()
    {
        $section_num = 0;
        include_once(_DIR_EXT.'/send_report/panel_send_report_td.php');
        ?>
        <table class="basic full send_report_list">
            <tr>
                <th>Отчет</th>
<!--                <th>Статус</th>-->
                <th>Класс</th>
                <th>Кол-во отправок</th>
                <th>Ближайшая отправка</th>
            </tr>
        <?
        foreach ($this->formated_recs as $section_name=>$section_recs) {
            $section_num++;
            ?>
            <tr class="section_name" id="section_num_<?echo $section_num?>">
                <td  class="left" colspan="4">
                    <?echo $section_name?>
                    <i class="fa fa-chevron-up"></i>
                </td>
            </tr>
            <?
            foreach ($section_recs as $section_rec) {
                $not_send_report = 0;
                $script_dir = $section_rec['script_dir'];
                $class_name = $section_rec['class_name'];
                if (file_exists(_DIR_EXT . '/' . $script_dir)) {
                    include_once(_DIR_EXT . '/' . $script_dir);
                    if (class_exists($class_name)) {
                        $report_obj = new $class_name();
                        if (is_object($report_obj)) {
                            $not_send_report = $report_obj->not_send_report;
                        }
                    }
                }
                if ($not_send_report == 0) {
                    ?>
                    <tr class="section_report section_num_<?echo $section_num?>" id="send_report_<?echo $section_rec['pkey']?>">
                        <?panel_send_report_td($section_rec)?>
                    </tr>
                <?
                }
            }
        }
        ?>
        </table>
        <script type="text/javascript">
            $j('tr.section_name').on('click',function () {
                $j('tr.' + this.id).toggle('hidden')
                $j(this).toggleClass('hide_section')
            })
        </script>
        <?
    }

}

?>