<?php
class report_cars_cards extends c_report
{
    var $title = 'Карточки автомобилей';
    var $filter = array();
    var $view_by_space_filter=1;

    var $arr_card_types=array(
        1=>'Бланки автомобилей (Гос.номер)',
        2=>'Бланки автомобилей (uid)'
    );

    function init($create_options=array())
    {}

    function setting($options=array())
    {
        $arr_orgs_ids = PERSONAL()->get_arr_orgs_to_cur_account();?>
        <div id="panel_filter">
        <form id="sky-form" class="sky-form">
            <input type="hidden" name="filter_dir" value="<?echo _CUR_CAB_DIR._CUR_REPORT.'/'?>">
            <input type="hidden" name="report_code" value="<?echo 'report_cars_cards';?>">
            <fieldset>
                <div class="row">
                    <?
                    $this->filter_section_select('card_type','Тип бланков:',2,$this->arr_card_types);
                    $this->filter_section_input_text('car','Гос.номер автомобиля:',2,array('auto_complete'=>"autocomplette_car_number_to")) ;
                    $this->filter_section_select_multiple('org_ids', 'Организация:', 3, $arr_orgs_ids);
                    ?>
                </div>
                <div class="row">
                    <section class="col col-2">
                        <label class="label">Размер карточек:</label>
                        <label class="radio"><input id="size_standart" type="radio" name="filter[size_card]" value="1" <?if ($this->filter['size_card']!=2) echo 'checked'?>><i></i>Стандартные</label>
                        <label class="radio"><input id="size_big" type="radio" name="filter[size_card]" value="2" <?if ($this->filter['size_card']==2) echo 'checked'?>><i></i>Большие</label>
                    </section>
                </div>
            </fieldset>
            <?$this->panel_buttons();?>
        </form>
        </div>
        <div class="alert">ВНИМАНИЕ! НЕ печататайте страницу, пока не будут загружены изображения всех QR-кодов</div><?
    }

    function create_usl_select_obj($_params,&$options)
    {
        $usl=array() ;

        if ($this->filter['car'])       $usl[]='car.obj_name="'.$this->filter['car'].'"';
        if ($this->filter['org_ids'])   $usl[]='relation._personal_org_id in ('.implode(',', array_keys($this->filter['org_ids'])).')';

        $usl_res=implode(' and ',$usl) ;
        return($usl_res) ;
    }

    function panel_info_filter()
    {
        $_str=array() ; $info=array() ; $title='' ;

        if ($this->filter['car'])                             $info['Автомобиль']='"'.$this->filter['car'].'"' ;
        if ($this->filter['org_ids'])                         $info['Организации'] = PERSONAL()->get_org_names_by_ids(array_keys($this->filter['org_ids']));

        if (_sizeof($info)) foreach($info as $title=>$value)   if (is_array($value)) $_str[]=$title.': <strong>'.implode(', ',$value).'</strong>' ; else $_str[]=$title.': <strong>'.$value.'</strong>' ;
        if (_sizeof($_str)) $title='<p class=center>'.implode(' ',$_str).'</p>' ;
        return $title ;
    }

    function get_cnt_items($usl,$options=array())
    {
        if ($usl) $usl=' and '.$usl;
        $query='select count(car.pkey)
                from '.TO()->table_car.' car
                left join view_relationcars relation
                     on car.pkey=relation.car_id
                where relation.pkey = (select max(pkey) from view_relationcars where car.pkey=car_id)';
        $cnt=execSQL_value($query.$usl,$options) ;
        return($cnt) ;
    }

    function get_items($usl,$options=array())
    {
        $limit=($options['limit'])? ' '.$options['limit']:'' ;
        if ($usl) $usl=' and '.$usl;
        $query='select car.*, relation._personal_name, relation._personal_org_name 
                from '.TO()->table_car.' car
                left join view_relationcars relation
                     on car.pkey=relation.car_id
                where relation.pkey = (select max(pkey) from view_relationcars where car.pkey=car_id)';
        $recs = execSQL($query.$usl.$limit,$options);
        return $recs;
    }

    function print_template_HTML($list_recs,$options=array())
    {?>
        <div id="report_cars_cards">
            <div id="list_items"><?
                $k=0 ;
                if (_sizeof($list_recs)) foreach($list_recs as $rec)
                {
                    $k++ ;
                    $this->panel_card($rec) ;
                    if ($k==9) {?> <div style="page-break-after:always; clear:both"></div><? $k=0 ;}
                }?>
            </div>
            <div class="clear"></div>
            <style type="text/css">
                div#list_items{font-family:Arial, Helvetica, sans-serif;font-size:12px;}
                div#list_items div.clear{clear:both;page-break-after: always;}
                div#list_items div.item{width:300px;height:191px;float:left;margin:5px 10px;border:1px solid gray;position:relative;overflow:hidden;page-break-inside:avoid;}
                div#list_items div.item.big{width:486px;height:375px;float:left;margin:5px 10px;border:1px solid gray;position:relative;overflow:hidden;page-break-inside:avoid;}
                div#list_items div.item h2{margin:10px 0 0 80px;padding:0;text-align:left;font-family:arial, helvetica, sans-serif;font-size:13px;text-transform:uppercase;}
                div#list_items div.item img.logo{position:absolute;top:10px;left:25px;}
                div#list_items div.item img.qrcode{width:157px;position:absolute;top:33px;left:1px;}
                div#list_items div.item img.qrcode.big{width:341px;position:absolute;top:33px;left:1px;}
                div#list_items div.item table{position:absolute;top:33px;right:16px;width:130px;table-layout:fixed;border-collapse:collapse;font-family:arial, helvetica, sans-serif;font-size:10px;}
                div#list_items div.item table tr td{text-align:left;vertical-align:top;padding:1px;border-bottom:1px solid gray;height:20px;}
                div#list_items div.item.personal{line-height:1.2em;}
                div#list_items div.item.personal table tr td{border-bottom:none;padding-bottom:5px;}
            </style>
        </div><?
    }

    function panel_card($rec)
    {?>
        <?if ($this->filter['size_card'] == 2) {
            ?><div class="item personal big"><?
        } else {
            ?><div class="item personal"><?
        }?>
            <h2>№ <?echo $rec['obj_name']?></h2>
            <img class="logo" src="<?echo _PATH_TO_SITE?>/images/logo.png" width="50">
            <?if ($this->filter['size_card']==2) {
                if ($this->filter['card_type']==1) {?><img class="qrcode big" src="<?echo _PATH_TO_SITE?>/services/qrcode/<?echo $rec['obj_name']?>/" /><?}
                else {?><img class="qrcode big" src="<?echo _PATH_TO_SITE?>/services/qrcode/<?echo $rec['uid']?>/" /><?}
            } else {
                if ($this->filter['card_type']==1) {?><img class="qrcode" src="<?echo _PATH_TO_SITE?>/services/qrcode/<?echo $rec['obj_name']?>/" /><?}
                else {?><img class="qrcode" src="<?echo _PATH_TO_SITE?>/services/qrcode/<?echo $rec['uid']?>/" /><?}
            }?>
            <table>
                <tr><td><strong>Модель: <? echo $rec['model']?></strong></td></tr>
                <tr><td><strong>Тип:</strong> <? echo $rec['type']?></td></tr>
            </table>
        </div>
        <?
    }

}
