<?
include_once('report_quiz_stats2.php');
class report_quiz_stats3 extends report_quiz_stats2
{
    var $title='Результаты контроля знаний - статистика - график' ;

    function prepare_data()
    {
        $usl_str='';
        if (MEMBER()->personal_viewer_name) $usl_str=' and personal_id in (select pkey from '.MEMBER()->personal_viewer_name.')' ;

        $arr_charts=[];

        $t = $this->time_from;
        while($t <= $this->time_to) {
            $ts = getdate($t) ;
            $t1 = $t ;
            $cur_month = mktime(0,0,0,$ts['mon'],1,$ts['year']) ;
            $arr_month[$cur_month] = get_month_year($cur_month,'month year') ;
            switch($this->filter['cnt_days']) {
                // период 180 дней, разбивка 30 дней
                case 2:
                    $t = mktime(0,0,0,$ts['mon'],$ts['mday']+30,$ts['year']) ;
                    $t2 = $t-1;
                    $i = (date('y', $t1) == date('y', $t2)
                        ? date('d.m', $t1).'-'.date('d.m\'y', $t2)
                        : date('d.m\'y', $t1).'-'.date('d.m\'y', $t2)
                    );
                    break  ;
                // периоды год и все время, разбивка по месяцам
                case 3:
                case 4:
                    $t = mktime(0,0,0,$ts['mon']+1,1,$ts['year']) ;
                    $t2 = $t-1;
                    $i = get_month_year($t1,'month year') ;
                    break ;
                // по дефолту выбран период 90 дней, разбивка по 10 дней
                case 1:
                default:
                    $t = mktime(0,0,0,$ts['mon'],$ts['mday'] + 10,$ts['year']);
                    $t2 = $t-1;
                    $i = (date('y', $t1) == date('y', $t2)
                        ? date('d.m', $t1).'-'.date('d.m\'y', $t2)
                        : date('d.m\'y', $t1).'-'.date('d.m\'y', $t2)
                    );
                    break ;
            }

            $usl = str_replace('not t3.parent is null', '', $this->usl_quiz_result);
            $usl = trim($usl);
            if($usl === 'and') {
                $usl = '';
            }
            if(strlen($usl) and strpos($usl, 'and') !== 0) {
                $usl = ' and '.$usl;
            } elseif(strlen($usl) and strpos($usl, 'and') === 0) {
                $usl = ' '.$usl;
            }

            $usl_last=($this->filter['answer_type'])? 'last=1 and  ':'' ;

            $arr_charts[htmlspecialchars($i)]['count_question'] = execSQL_value('select count(question_id) from view_quiz_result where '.$usl_last.' quiz_с_data>='.$t1.' and quiz_с_data<='.$t2.$usl.$usl_str);
            $arr_charts[htmlspecialchars($i)]['count_correct'] = execSQL_value('select sum(correct) from view_quiz_result where  '.$usl_last.'  quiz_с_data>='.$t1.' and quiz_с_data<='.$t2.$usl.$usl_str);
            $arr_charts[htmlspecialchars($i)]['k1'] = ($arr_charts[htmlspecialchars($i)]['count_question']) ? round($arr_charts[htmlspecialchars($i)]['count_correct'] / $arr_charts[htmlspecialchars($i)]['count_question'] * 100) : 0;
        }

        return $arr_charts;
    }

    function print_template_HTML($list_recs,$options=array())
    {
        $arr_result=$this->prepare_data();

        $this->create_stats_chart($arr_result,$options['chart_elem_id']);
    }

    function create_stats_chart($data,$elem_id) {
        if (!_sizeof($data)) return;
        $caption='График оценки знаний' ;

        $arr_labels=array_keys($data) ;
        ?>
        <script type="text/javascript">
            $j(document).ready(function(){
                FusionCharts.ready(function(){
                    var <?='js_'.$elem_id?> = new FusionCharts({
                        type: 'mscombidy2d',
                        renderAt: <?=$elem_id?>,
                        width: '100%',
                        height: '<?echo $this->height_graf?>',
                        dataFormat: 'json',
                        dataSource: {
                            "chart": {
                                "caption": "<?echo $caption?>",
                                "xAxisname": "Время",
                                "pYAxisName": "Кол-во вопросов/ответов",
                                "sYAxisName": "Уровень знаний, %",
                                //"numberPrefix": "",
                                "sNumberSuffix" : "%",
                                "sYAxisMaxValue" : "100",
                                "sYAxisMaxValue" : "100",

                                //Cosmetics
                                "paletteColors" : "#0075c2,#1aaf5d,#f2c500",
                                "baseFontColor" : "#333333",
                                "baseFont" : "Helvetica Neue,Arial",
                                "captionFontSize" : "14",
                                "subcaptionFontSize" : "14",
                                "subcaptionFontBold" : "0",
                                "showBorder" : "0",
                                "bgColor" : "#ffffff",
                                "showShadow" : "0",
                                "canvasBgColor" : "#ffffff",
                                "canvasBorderAlpha" : "0",
                                "divlineAlpha" : "100",
                                "divlineColor" : "#999999",
                                "divlineThickness" : "1",
                                "divLineIsDashed" : "1",
                                "divLineDashLen" : "1",
                                "divLineGapLen" : "1",
                                "usePlotGradientColor" : "0",
                                "showplotborder" : "0",
                                "showXAxisLine" : "1",
                                "xAxisLineThickness" : "1",
                                "xAxisLineColor" : "#999999",
                                "showAlternateHGridColor" : "0",
                                "showAlternateVGridColor" : "0",
                                "legendBgAlpha" : "0",
                                "legendBorderAlpha" : "0",
                                "legendShadow" : "0",
                                "legendItemFontSize" : "10",
                                "legendItemFontColor" : "#666666"
                            },
                            "categories":
                                [{
                                    "category": [ <?foreach($arr_labels as $label) echo '{ "label": "'.$label.'" },' ; ?>]
                                }],
                            "dataset":
                                [
                                    {
                                        "seriesName": "Задано вопросов",
                                        "showValues": "1",
                                        //"renderAs": "line",
                                        "data": [ <?foreach($data as $values) echo '{ "value" : "'.($values['count_question'] ? $values['count_question'] : 0).'" },'?>]
                                    },
                                    {
                                        "seriesName": "правильных ответов",
                                        //"parentYAxis": "S",
                                        //"renderAs": "line",
                                        "showValues": "1",
                                        "divlineThickness" : "1",
                                        "data": [<?foreach($data as $values) echo '{ "value" : "'.($values['count_correct'] ? $values['count_correct'] : 0).'" },'?>]
                                    },

                                    {
                                        "seriesName": "Уровень знаний, %",
                                        "parentYAxis": "S",
                                        "renderAs": "line",
                                        "showValues": "1",
                                        "divlineThickness" : "1",
                                        "data": [<?foreach($data as $values) echo '{ "value" : "'.($values['k1'] ? $values['k1'] : 0).'" },'?>]
                                    },



                                ]
                        }
                    });

                    <?='js_'.$elem_id?>.render();
                });
            });
        </script>
        <?
    }

}

?>
