<?php
class report_quiz_stats extends c_report
{
    var $title='Результаты контроля знаний - статистика' ;
    var $personal_id=0 ;
    var $event_id=0 ;
    var $cnt_days=array(0=>'90 дней',1=>'180 дней',2=>'1 год',3=>'все время') ;
    var $usl_time ;
    var $time_from ;
    var $usl_quiz_result ;
    var $use_fusioncharts=1;



    function init($crete_options=array())
    {    $cnt_day=($this->filter['cnt_days'])? (int)$this->filter['cnt_days']:0;
        $tt=getdate() ;
        $this->time_from=0 ;

        switch($cnt_day)
        { case 0: $this->time_from=mktime(0,0,0,$tt['mon'],$tt['mday']-90,$tt['year']);
            $this->usl_time='and t1.quiz_с_data>='.$this->time_from;
            break ;
            case 1: $this->time_from=mktime(0,0,0,$tt['mon'],$tt['mday']-180,$tt['year']);
                $this->usl_time='and t1.quiz_с_data>='.$this->time_from;
                break ;
            case 2: $this->time_from=mktime(0,0,0,$tt['mon'],$tt['mday'],$tt['year']-1) ;
                $this->usl_time='and t1.quiz_с_data>='.$this->time_from;
                break ;
            case 3: $this->usl_time='' ;
                break ;
        }

        $_usl=array() ;
//        $_usl[]='not t3.parent is null' ;
        if ($this->personal_id)    $_usl[]='personal_id='.$this->personal_id ;
        if ($this->event_id)       $_usl[]='event_id='.$this->event_id ;

        $this->usl_theme_select=(_sizeof($_usl))? implode(' and ',$_usl):'1' ;

        if ($this->filter['theme_id'])
        {   $questions_ids=[] ; $section_ids=[];
            if (!$this->filter['section_id']) $section_ids=execSQL_line('select pkey as id from quiz_themes where parent2='.$this->filter['theme_id'].' ') ;
            else {
                $section_level=execSQL_value('select level from quiz_themes where pkey='.$this->filter['section_id']);
                if ($section_level) {
                    $section_ids=execSQL_line('select pkey as id from quiz_themes where parent'.$section_level.'='.$this->filter['section_id'].' ') ;
                    if (!_sizeof($section_ids)) $section_ids=[$this->filter['section_id']];
                }
            }
            if (_sizeof($section_ids)) $questions_ids=execSQL_line('select pkey as id from quiz_questions where parent in ('.implode(',',$section_ids).')') ;
            if (_sizeof($questions_ids)) $_usl[]='question_id in ('.implode(',',$questions_ids).')';
        }
        if (_sizeof($this->filter['org_ids']))    $_usl[]='_org_id in ('.implode(',',array_keys($this->filter['org_ids'])).')' ;
        if (_sizeof($this->filter['otdel_ids']))  $_usl[]='_otdel_id in ('.implode(',',array_keys($this->filter['otdel_ids'])).')' ;

        $this->usl_quiz_result=(_sizeof($_usl))? implode(' and ',$_usl):'1' ;
    }

    function get_setting_arr()
    {
        list($arr_orgs_ids,$arr_otdel_ids,$arr_works_ids)=PERSONAL()->get_org_otdels_works_to_cur_account($this->filter) ;
        // получаем список всех ТЕМ вопросов, которые задавались сотруднику


        $parent_themes = execSQL('select t3.pkey,t3.parent,t3.parent2,t3.level,t3.obj_name 
                             from quiz_result t1 
                                        inner join quiz_questions t2 on t2.pkey=t1.question_id 
                                        inner join quiz_themes t3 on t3.pkey=t2.parent
                                        where '.$this->usl_theme_select.'
                                        group by t3.pkey
                                        order by t3.pkey
        ');

        $themes=execSQL('select pkey,obj_name,parent,level,parent2 from quiz_themes where level>0 order by level,parent');

        $themes=$this->hierarchy_array($themes);

        $max_level=0;
        foreach ($themes as $key=>&$theme) {
            if ($theme['level']>$max_level) $max_level=$theme['level'];
            if (_sizeof($parent_themes[$key])) { $theme['in_view']=true;}
        }

        if ($max_level>0) {
            for ($i=$max_level;$i>0;$i--) {
                foreach ($themes as $key=>$theme) {
                    if ($theme['level']!=$i) continue;
                    if (!$theme['in_view']) {
                        unset($themes[$key]);
                        continue;
                    }
                    if ($theme['parent']) {
                        $themes[$theme['parent']]['in_view']=true;
                    }
                }
            }
        }

        $arr_themes=array() ; $arr_themes_section=array() ;

        foreach ($themes as $key=>$theme) {
            if ($theme['level']==2) {
                $arr_themes[$key]=$theme['obj_name'] ;
//                $arr_themes_section[$rec['theme_id']][$rec['section_id']]=$rec['section_name'] ;
            } elseif ($theme['level']>2) {
                $arr_themes_section[$theme['parent2']][$key]=$this->empty_space($theme['level']).$theme['obj_name'] ;
        }
        }


//        $theme_recs=execSQL('select t4.pkey as theme_id,t4.obj_name as theme_name,
//                             t3.pkey as section_id,t3.obj_name as section_name
//                             from quiz_result t1
//                             inner join quiz_questions t2 on t2.pkey=t1.question_id
//                             left join quiz_themes t3 on t3.pkey=t2.parent
//                             left join quiz_themes t4 on t4.pkey=t3.parent2
//                             where '.$this->usl_theme_select.'
//                             group by t4.pkey,t3.pkey
//                             order by t4.indx,t3.indx
//                             ',0,1) ;
//        $arr_themes=array() ; $arr_themes_section=array() ;
//        if (_sizeof($theme_recs)) foreach($theme_recs as $rec)
//        {  $arr_themes[$rec['theme_id']]=$rec['theme_name'] ;
//            $arr_themes_section[$rec['theme_id']][$rec['section_id']]=$rec['section_name'] ;
//
//        }
        //damp_array($arr_themes);
        return [$arr_orgs_ids,$arr_otdel_ids,$arr_themes,$arr_themes_section];
    }

    function setting()
    {
//        list($arr_orgs_ids,$arr_otdel_ids,$arr_works_ids)=PERSONAL()->get_org_otdels_works_to_cur_account($this->filter) ;
//
//        $_usl=array() ;
//        $_usl[]='not t3.parent is null' ;
//        if ($this->personal_id)    $_usl[]='personal_id='.$this->personal_id ;
//        if ($this->event_id)       $_usl[]='event_id='.$this->event_id ;
//
//        $usl_theme_select=(_sizeof($_usl))? implode(' and ',$_usl):'1' ;
//
//        if ($this->filter['theme_id'])
//        {   $questions_ids=[] ;
//            if (!_sizeof($this->filter['section_ids'])) $section_ids=execSQL_line('select pkey as id from quiz_themes where parent2='.$this->filter['theme_id'].' ') ;
//            else                                       $section_ids=array_keys($this->filter['section_ids']) ;
//            if (_sizeof($section_ids)) $questions_ids=execSQL_line('select pkey as id from quiz_questions where parent in ('.implode(',',$section_ids).')') ;
//            if (_sizeof($questions_ids)) $_usl[]='question_id in ('.implode(',',$questions_ids).')';
//        }
//        if (_sizeof($this->filter['org_ids']))    $_usl[]='_org_id in ('.implode(',',array_keys($this->filter['org_ids'])).')' ;
//        if (_sizeof($this->filter['otdel_ids']))  $_usl[]='_otdel_id in ('.implode(',',array_keys($this->filter['otdel_ids'])).')' ;
//
//        $this->usl_quiz_result=(_sizeof($_usl))? implode(' and ',$_usl):'1' ;
//
//        // получаем список всех ТЕМ вопросов, которые задавались сотруднику
//        $theme_recs=execSQL('select t4.pkey as theme_id,t4.obj_name as theme_name,
//                             t3.pkey as section_id,t3.obj_name as section_name
//                             from quiz_result t1
//                             left join quiz_questions t2 on t2.pkey=t1.question_id
//                             left join quiz_themes t3 on t3.pkey=t2.parent
//                             left join quiz_themes t4 on t4.pkey=t3.parent2
//                             where '.$usl_theme_select.'
//                             group by t4.pkey,t3.pkey
//                             order by t4.indx,t3.indx
//                             ',0,1) ;
//        $arr_themes=array() ; $arr_themes_section=array() ;
//        if (_sizeof($theme_recs)) foreach($theme_recs as $rec)
//        {  $arr_themes[$rec['theme_id']]=$rec['theme_name'] ;
//            $arr_themes_section[$rec['theme_id']][$rec['section_id']]=$rec['section_name'] ;
//
//        }
        //damp_array($arr_themes);

        list($arr_orgs_ids,$arr_otdel_ids,$arr_themes,$arr_themes_section)=$this->get_setting_arr();

        $this->form_open() ;
        $this->row_open() ;
        $this->fieldset_open() ;
        $this->filter_section_select('theme_id','Тема КЗ:',2,$arr_themes) ;
        if ($this->filter['theme_id']) $this->filter_section_select_multiple('section_ids','Разделы КЗ:',4,$arr_themes_section[$this->filter['theme_id']]) ;
        if (!$this->personal_id) $this->filter_section_select_multiple('org_ids','Организация:',2,$arr_orgs_ids) ;
        if (!$this->personal_id) $this->filter_section_select_multiple('otdel_ids','Подразделение:',2,$arr_otdel_ids) ;
        //$this->filter_section_select('view_mode','Обзор:',2,$this->view_mode,array('nospace_element'=>1)) ;
        $this->filter_section_select('cnt_days','Обзор за:',2,$this->cnt_days,array('nospace_element')) ;
        $this->row_close() ;
        $this->panel_buttons();
        $this->fieldset_close() ;
        $this->form_close() ;
    }

    function get_arr_info_filters()
    { $info=parent::get_arr_info_filters() ;
        if ($this->filter['time_int'])                        $info['временной интервал']=$this->time_int[$this->filter['time_int']] ;
        if ($this->time_from)                                 $info['Анализ данных']='от '.date('d.m.Y',$this->time_from) ;
        else                                                  $info['Анализ данных']='за все время' ;
        if ($this->filter['theme_id'])                        $info['Тема КЗ']=QUIZ()->get_theme_name_by_id($this->filter['theme_id']);
        if (_sizeof($this->filter['section_ids']))             $info['Раздел КЗ']=QUIZ()->get_theme_name_by_ids(implode(',',array_keys($this->filter['section_ids'])));
        if (MEMBER()->setting['personal']['usl_select'])     $info[MEMBER()->setting['personal']['name']]=strip_tags(MEMBER()->setting['personal']['info_filter']);
        return $info ;
    }



    function get_cnt_items($usl,$options=array()){return(1) ;}

    function get_items($usl,$options=array()){return(array()) ;}

    function prepare_data()
    {
        $theme_ids=execSQL('select t3.parent as theme_id,min(t1.quiz_с_data) as time_from,max(t1.quiz_с_data) as time_to,count(distinct(t1.question_id)),t4.obj_name as theme_name 
                        from view_quiz_result t1 
                        left join quiz_questions t2 on t2.pkey=t1.question_id 
                        left join quiz_themes t3 on t3.pkey=t2.parent 
                        left join quiz_themes t4 on t4.pkey=t3.parent 
                        left join '.MEMBER()->personal_viewer_name.' tp on tp.pkey=t1.personal_id
                        where '.$this->usl_quiz_result.' '.$this->usl_time.' and not tp.pkey is null 
                        group by t3.parent',0,1) ;

        $theme_stats=execSQL('select t3.parent as theme_id,t3.pkey as section_id,sum(t1.correct) as sum_correct,count(t1.quiz_result_id) as cnt,t3.obj_name as section_name 
                          from view_quiz_result t1 
                          left join quiz_questions t2 on t2.pkey=t1.question_id
                          left join quiz_themes t3 on t3.pkey=t2.parent
                         left join '.MEMBER()->personal_viewer_name.' tp on tp.pkey=t1.personal_id
                          where '.$this->usl_quiz_result.' '.$this->usl_time.' and not tp.pkey is null 
                          group by t3.parent,t2.parent ',0,1) ;

        $learned_stats=execSQL('select t3.parent as theme_id,t3.pkey as section_id,sum(t1.re_ask_result) as sum_correct,count(t1.quiz_result_id) as cnt,t3.obj_name as section_name 
                          from view_quiz_learned t1 
                          left join quiz_questions t2 on t2.pkey=t1.question_id
                          left join quiz_themes t3 on t3.pkey=t2.parent
                          left join '.MEMBER()->personal_viewer_name.' tp on tp.pkey=t1.personal_id
                          where '.$this->usl_quiz_result.' '.$this->usl_time.' and not tp.pkey is null
                          group by t3.parent,t2.parent ',0,1) ;

        $theme_stats_full=execSQL('select t3.parent as theme_id,t2.parent as section_id,count(t2.pkey) as cnt 
                               from quiz_questions t2 
                               left join quiz_themes t3 on t3.pkey=t2.parent 
                               group by t3.parent,t2.parent',0,1) ;

        $arr_result=array() ;  $arr_learned=array() ;

        if (_sizeof($theme_stats)) foreach($theme_stats as $rec)
        {
            //    if ($rec['correct'])  { $arr_result[$rec['theme_id']]['cnt_questions_get_correct']+=$rec['cnt'] ;
//                $arr_result[$rec['theme_id']]['section_stats'][$rec['section_id']]['cnt_questions_get_correct']+=$rec['cnt'] ;
//            }
            $arr_result[$rec['theme_id']]['cnt_questions_get_correct']+=$rec['sum_correct'] ;
            $arr_result[$rec['theme_id']]['section_stats'][$rec['section_id']]['cnt_questions_get_correct']+=$rec['sum_correct'] ;
            $arr_result[$rec['theme_id']]['cnt_questions_get']+=$rec['cnt'] ;
            $arr_result[$rec['theme_id']]['section_stats'][$rec['section_id']]['cnt_questions_get']+=$rec['cnt'] ;
            $arr_result[$rec['theme_id']]['section_stats'][$rec['section_id']]['section_name']=$rec['section_name'] ;
        }

        if (_sizeof($learned_stats)) foreach ($learned_stats as $rec)
        {
            $arr_result[$rec['theme_id']]['cnt_learned_get_correct']+=$rec['sum_correct'] ;
            $arr_result[$rec['theme_id']]['section_stats'][$rec['section_id']]['cnt_learned_get_correct']+=$rec['sum_correct'] ;

            $arr_result[$rec['theme_id']]['cnt_learned_get']+=$rec['cnt'] ;
            $arr_result[$rec['theme_id']]['section_stats'][$rec['section_id']]['cnt_learned_get']+=$rec['cnt'] ;
        }

        if (_sizeof($theme_stats_full)) foreach($theme_stats_full as $rec)
        {
            if (isset($arr_result[$rec['theme_id']])) $arr_result[$rec['theme_id']]['cnt_questions']+=$rec['cnt'] ;
            if (isset($arr_result[$rec['theme_id']]['section_stats'][$rec['section_id']])) $arr_result[$rec['theme_id']]['section_stats'][$rec['section_id']]['cnt_questions']+=$rec['cnt'] ;
        }

        $this->calculate_data_proc($arr_result);

//        damp_array($arr_result);

        return [$theme_ids,$arr_result];
    }

    function calculate_data_proc(&$data_set)
    {
        foreach ($data_set as &$data) {
            $data['proc']=($data['cnt_questions_get'])? $data['cnt_questions_get_correct']/$data['cnt_questions_get']*100:0 ;
            $data['proc']=($data['proc']>=1)? round($data['proc']):round($data['proc'],1) ;

            if (!empty($data['cnt_learned_get'])) {
                $data['proc_learned']=$data['cnt_learned_get_correct']/$data['cnt_learned_get']*100 ;
                $data['proc_learned']=($data['proc_learned']>=1)? round($data['proc_learned']):round($data['proc_learned'],1) ;
            }

            if (is_array($data['section_stats']) and _sizeof($data['section_stats'])) {
                $this->calculate_data_proc($data['section_stats']);
            }
        }
    }

    function prepare_chart_data($theme_ids,$arr_result)
    {
        $arr=[];

        if (!$this->filter['theme_id']) {
            $arr['result']['caption']='Уровень знаний';
            $arr['learned']['caption']='Усваиваемость';
            foreach ($theme_ids as $theme_rec) {
                $arr['result']['category'][]=$theme_rec['theme_name'];
                $arr['result']['data'][]=$arr_result[$theme_rec['theme_id']]['proc'];
                $arr['learned']['category'][]=$theme_rec['theme_name'];
                $arr['learned']['data'][]=$arr_result[$theme_rec['theme_id']]['proc_learned'];
            }
        } else {
            foreach ($arr_result[$this->filter['theme_id']]['section_stats'] as $section_rec) {
                $arr['result']['category'][]=$section_rec['section_name'];
                $arr['result']['data'][]=$section_rec['proc'];
                $arr['learned']['category'][]=$section_rec['section_name'];
                $arr['learned']['data'][]=$section_rec['proc_learned'];
            }
        }

        return $arr;
    }

    function print_template_HTML($list_recs,$options=array())
    { $id=($options['id'])? 'id='.$options['id']:'' ;
        //$personal_id=($this->personal_id)? $this->personal_id:$this->filter['personal_id'] ;

        list($theme_ids,$arr_result)=$this->prepare_data();

        $chart_arr=$this->prepare_chart_data($theme_ids,$arr_result);

        $this->print_charts($chart_arr);
//        $this->print_charts2($chart_arr);

        ?><table class="report_inv basic fz_small full auto"<?echo $id?>>
        <tr><th>Тема/Раздел</th><th>Дата первого опроса</th><th>Дата последнего опроса</th><th>Число вопросов в теме/разделе</th><th>Число заданных вопросов</th>
            <th style="width:210px;">Процент правильных ответов</th>
            <th>Кол-во переспросов</th>
            <th>Процент усваиваемости</th>
            <!--<th>Процент покрытия темы/раздела</th>-->
        </tr><?
        if (_sizeof($theme_ids)) foreach($theme_ids as $rec)
        {
            $theme_id=$rec['theme_id'] ;

            ?><tr class=item style="background-color:rgba(0,80,170,0.76);color:white;">
            <td class="left"><?echo $rec['theme_name']?></td>
            <td class="center"><?echo date('d.m.Y H:i',$rec['time_from'])?></td>
            <td class="center"><?echo date('d.m.Y H:i',$rec['time_to'])?></td>
            <td class=""><?echo $arr_result[$theme_id]['cnt_questions']?></td>
            <td class=""><?echo $arr_result[$theme_id]['cnt_questions_get']?></td>
            <td class=""><?echo $arr_result[$theme_id]['proc']?>%</td>
            <td class=""><?echo $arr_result[$theme_id]['cnt_learned_get']?></td>
            <td class=""><?echo $arr_result[$theme_id]['proc_learned']?>%</td>
            </tr>
            <?
            if (_sizeof($arr_result[$theme_id]['section_stats'])) foreach($arr_result[$theme_id]['section_stats'] as $section_id=>$section_info)
            {
                ?>
                <tr>
                <td class="left"><?echo $section_info['section_name']?></td>
                <td></td>
                <td></td>
                <td><?echo $section_info['cnt_questions']?></td>
                <td><?echo $section_info['cnt_questions_get']?></td>
                <td>
                        <?echo $section_info['proc']?>%
                </td>
                <td><?echo $section_info['cnt_learned_get']?></td>
                <td>
                        <?if (isset($section_info['proc_learned'])) echo $section_info['proc_learned'].'%'?>
                </td>
                </tr>
                <?
            }
        }
        ?></table><?
    }

    function print_charts($arr) {
        ?>
        <div class="charts">
            <div id="radar_chart_1">Подождите, идет построение графика</div>
            <div id="radar_chart_2">Подождите, идет построение графика</div>
        </div>
        <style type="text/css">
            .charts{
                display:flex;
                margin:0 auto;
                width:100%;
            }
            .charts > div {
                width: 50%;
            }
        </style>
        <?

        $this->create_radar_chart($arr['result'],'radar_chart_1');
        $this->create_radar_chart($arr['learned'],'radar_chart_2');
    }

    function print_charts2($arr) {
        ?>
        <div class="charts">
            <div id="radar_chart_1">Подождите, идет построение графика</div>
        </div>
        <style type="text/css">
            /*.charts{*/
            /*    display:flex;*/
            /*    margin:0 auto;*/
            /*    width:100%;*/
            /*}*/
            /*.charts > div {*/
            /*    width: 50%;*/
            /*}*/
        </style>
        <?

        $this->create_radar_chart2($arr,'radar_chart_1');
    }

    function create_radar_chart($data,$elem_id) {
        if(!_sizeof($data)) return;
//        damp_array($data);
        ?>
        <script type="text/javascript">
            $j(document).ready(function() {
                let radar_chart = new FusionCharts({
                    type: 'radar',
                    renderAt: <?=$elem_id?>,
                    width: '100%',
                    height: '400',
                    dataFormat: 'json',
                    dataSource: {
                        "chart": {
                            "caption": "<?=$data['caption']?>",
                            "subCaption": "",
                            "theme": "fusion",
                            "showvalues": "0",
                            "numberSuffix": "%",
                            "plotfillalpha": "60",
                            "yAxisMaxValue": "100",
                            "yAxisMinValue": "100",
                            "showBorder" : "0",
                            "bgColor" : "#ffffff",
                        },
                        // Chart Data
                        categories: [
                            {
                                category: [ <? foreach ($data['category'] as $value) { echo '{"label": "'.$value.'"},';} ?>]
                            }
                        ],
                        dataset: [
                            {
                                seriesname: "",
                                color: "#2da5da",
                                data: [ <? foreach ($data['data'] as $value) { echo '{"value": "'.$value.'"},';} ?>]
                            }
                        ]
                    }
                });

                radar_chart.render();
            });
        </script>
        <?
    }

    function create_radar_chart2($data,$elem_id) {
        if(!_sizeof($data)) return;
//        damp_array($data);
        ?>
        <script type="text/javascript">
            $j(document).ready(function() {
                let radar_chart = new FusionCharts({
                    type: 'radar',
                    renderAt: <?=$elem_id?>,
                    width: '100%',
                    height: '400',
                    dataFormat: 'json',
                    dataSource: {
                        "chart": {
                            "caption": "",
                            "subCaption": "",
                            "theme": "fusion",
                            "showvalues": "0",
                            "numberSuffix": "%",
                            "plotfillalpha": "60",
                            "yAxisMaxValue": "100",
                            "yAxisMinValue": "100",
                            "showBorder" : "0",
                            "bgColor" : "#ffffff",
                        },
                        // Chart Data
                        categories: [
                            {
                                category: [ <? foreach ($data['result']['category'] as $value) { echo '{"label": "'.$value.'"},';} ?>]
                            }
                        ],
                        dataset: [
                            {
                                seriesname: "Уровень знаний",
                                // color: "#2da5da",
                                color: "#777700",
                                data: [ <? foreach ($data['result']['data'] as $value) { echo '{"value": "'.$value.'"},';} ?>]
                            },
                            {
                                seriesname: "Усваиваемость",
                                // color: "#777700",
                                color: "#0050AA",
                                data: [ <? foreach ($data['learned']['data'] as $value) { echo '{"value": "'.$value.'"},';} ?>]
                            }
                        ]
                    }
                });

                radar_chart.render();
            });
        </script>
        <?
    }

    /**
     * Blend two hexadecimal colours
     * specifying the fractional position.
     *
     * Example:
     *     // 10% along the gradient between #66cc00 and #cc2200
     *     blend_hex('66cc00', 'cc2200', 0.1); // "70bb00"
     */
    function blend_hex($from, $to, $pos = 0.5)
    {
        // 1. Grab RGB from each colour
        list($fr, $fg, $fb) = sscanf($from, '%2x%2x%2x');
        list($tr, $tg, $tb) = sscanf($to, '%2x%2x%2x');

        // 2. Calculate colour based on frational position
        $r = (int) ($fr - (($fr - $tr) * $pos));
        $g = (int) ($fg - (($fg - $tg) * $pos));
        $b = (int) ($fb - (($fb - $tb) * $pos));

        // 3. Format to 6-char HEX colour string
        return sprintf('%02x%02x%02x', $r, $g, $b);
    }

    function hierarchy_array($arr,$prev_parent=0) {
        $temp_arr=[];
        foreach ($arr as $key=>$value) {
            if ($value['parent']==$prev_parent) {
                $temp_arr[$key]=$value;
                $temp_arr2=$this->hierarchy_array($arr,$value['pkey']);
                if (_sizeof($temp_arr2)) $this->merge_arr($temp_arr,$temp_arr2);
            }
        }
        return $temp_arr;
    }

    function merge_arr(&$arr1,$arr2)
    {
        if (_sizeof($arr1)) {
            foreach ($arr2 as $key=>$value) {
                $arr1[$key]=$value;
            }
        } else {
            $arr1=$arr2;
        }

    }

    function empty_space($level) {
        $min=4;
        $result='';
        if ($level>=$min) {
            for ($i=$min;$i<=$level;$i++) {
                $result.='&nbsp;&nbsp;&nbsp;';
            }
        }
        return $result;
    }

}

?>
