<?php
class report_quiz_question_learned extends c_report
{
    var $title='Контроль знаний - вопрос - усваиваемость' ;
    var $cnt_days=array(0=>'90 дней',1=>'180 дней',2=>'1 год',3=>'все время') ;
    var $question_id=0 ;
    var $rec_question=[] ;
    var $usl_time ;
    var $time_from ;


function init($crete_options=array())
{
    $cnt_day=($this->filter['cnt_days'])? (int)$this->filter['cnt_days']:0;
    $tt=getdate() ;
    $this->time_from=0 ;

    switch($cnt_day)
    {
        case 0: $this->time_from=mktime(0,0,0,$tt['mon'],$tt['mday']-90,$tt['year']);
            $this->usl_time='t1.quiz_с_data>='.$this->time_from;
            break ;
        case 1: $this->time_from=mktime(0,0,0,$tt['mon'],$tt['mday']-180,$tt['year']);
            $this->usl_time='t1.quiz_с_data>='.$this->time_from;
            break ;
        case 2: $this->time_from=mktime(0,0,0,$tt['mon'],$tt['mday'],$tt['year']-1) ;
            $this->usl_time='t1.quiz_с_data>='.$this->time_from;
            break ;
        case 3: $this->usl_time='' ;
            break ;
    }

    if ($this->question_id) {
        $this->rec_question=QUIZ()->get_question_by_id($this->question_id) ;
    }
}

    function setting()
    {
        $this->form_open() ;
        $this->row_open() ;
        $this->fieldset_open() ;
              $this->filter_section_select('cnt_days','Обзор за:',2,$this->cnt_days,array('nospace_element')) ;
        $this->row_close() ;
        $this->panel_buttons();
        $this->fieldset_close() ;
        $this->form_close() ;
    }

    function get_arr_info_filters()
    {
        $info=parent::get_arr_info_filters() ;
        if ($this->filter['time_int'])                        $info['временной интервал']=$this->time_int[$this->filter['time_int']] ;
        if ($this->time_from)                                 $info['Анализ данных']='от '.date('d.m.Y',$this->time_from) ;
        else                                                  $info['Анализ данных']='за все время' ;
        if ($this->filter['theme_id'])                        $info['Тема КЗ']=QUIZ()->get_theme_name_by_id($this->filter['theme_id']);
        if (_sizeof($this->filter['section_ids']))             $info['Раздел КЗ']=QUIZ()->get_theme_name_by_ids(implode(',',array_keys($this->filter['section_ids'])));
        return $info ;
    }



    function get_cnt_items($usl,$options=array()){return(1) ;}

    function get_items($usl,$options=array()){return(array()) ;}

    function print_template_HTML()
    {
        $radarData=[]; $learned_stats=[];

        $learned_intime_stats=$this->get_intime_date();

        $this->intime_view_panel($learned_intime_stats);


    }

    function get_intime_date()
    {
        $this->filter['group_type']='1w';
        $questions_ids=[] ; $result=[];

        if (_sizeof($questions_ids)) $_usl[]='question_id='.$this->question_id;

        $dop_usl=(_sizeof($_usl))? ' and '.implode(' and ',$_usl):'' ;

        if ($this->time_from) {
            $tm=getdate($this->time_from);
        } else {
            $tf = execSQL_value('select min(quiz_с_data) from view_quiz_learned where 1'.$dop_usl);
            $tm=getdate($tf);
        }
        $time_from=mktime(0,0,0,$tm['mon'],$tm['mday'],$tm['year']) ;

        $tm=getdate();
        $time_to=mktime(0,0,0,$tm['mon'],$tm['mday']+1,$tm['year'])-1 ;

        $t=$time_from ;
        while($t<=$time_to)
        {   $ts=getdate($t) ;   $t1=$t ;
            $cur_month=mktime(0,0,0,$ts['mon'],1,$ts['year']) ;
            $arr_month[$cur_month]=get_month_year($cur_month,'month year') ;
            switch($this->filter['group_type'])
            {
                case '1d': $t=mktime(0,0,0,$ts['mon'],$ts['mday']+1,$ts['year']) ; $t2=$t-1; $i=get_month_year($t1,'day month') ; ; break  ;
                case '1w': $t=mktime(0,0,0,$ts['mon'],$ts['mday']+7,$ts['year']) ; $t2=$t-1; $i=date('d.m.Y',$t1).'-'.date('d.m.Y',$t2) ; break  ;
                case '1m': $t=mktime(0,0,0,$ts['mon']+1,1,$ts['year']) ; $t2=$t-1; $i=get_month_year($t1,'month year') ; break ;
            }

            $learned=execSQL_van('select count(re_ask_result) as re_ask_cnt,sum(re_ask_result) as re_ask_correct_cnt from view_quiz_learned where quiz_с_data>='.$t1.' and quiz_с_data<='.$t2.$dop_usl);
            $result[$i]['count_proc']=($learned['re_ask_cnt'])? round($learned['re_ask_correct_cnt']/$learned['re_ask_cnt']*100):0 ;
            $result[$i]['count_reask']=$learned['re_ask_cnt'];
        }

        return $result;
    }

    function intime_view_panel($result)
    {
        $caption='График оценки знаний' ;
        $t_now=time() ;

        $arr_month=array_keys($result) ;
        ?><div id="chart-container2">Подождите, идет построение графика</div>
        <script type="text/javascript">
            $j(document).ready(function(){
                FusionCharts.ready(function(){
                    var revenueChart2 = new FusionCharts({
                        type: 'zoomline',
                        renderAt: 'chart-container2',
                        width: '1000',
                        height: '400',
                        dataFormat: 'json',
                        dataSource: {
                            "chart": {
                                "caption": "<?echo $caption?>",
                                "xAxisname": "Время",
                                "sXAxisName": "Уровень знаний, %",
                                //"numberPrefix": "",
                                //"sNumberSuffix" : "",
                                //"sYAxisMaxValue" : "50",
                                //"sYAxisMaxValue" : "15",

                                //Cosmetics
                                "paletteColors" : "#0075c2,#1aaf5d,#f2c500",
                                "baseFontColor" : "#333333",
                                "baseFont" : "Helvetica Neue,Arial",
                                "captionFontSize" : "14",
                                "subcaptionFontSize" : "14",
                                "subcaptionFontBold" : "0",
                                "showBorder" : "0",
                                "bgColor" : "#ffffff",
                                "showShadow" : "0",
                                "canvasBgColor" : "#ffffff",
                                "canvasBorderAlpha" : "0",
                                "divlineAlpha" : "100",
                                "divlineColor" : "#999999",
                                "divlineThickness" : "1",
                                "divLineIsDashed" : "1",
                                "divLineDashLen" : "1",
                                "divLineGapLen" : "1",
                                "usePlotGradientColor" : "0",
                                "showplotborder" : "0",
                                "showXAxisLine" : "1",
                                "xAxisLineThickness" : "1",
                                "xAxisLineColor" : "#999999",
                                "showAlternateHGridColor" : "0",
                                "showAlternateVGridColor" : "0",
                                "legendBgAlpha" : "0",
                                "legendBorderAlpha" : "0",
                                "legendShadow" : "0",
                                "legendItemFontSize" : "10",
                                "legendItemFontColor" : "#666666"
                            },
                            "categories":
                                [{
                                    "category": [ <?foreach($arr_month as $date) echo '{ "label": "'.$date.'" },' ; ?>]
                                }],
                            "dataset":
                                [
                                    {      "seriesName": "Усваиваемость, %",
                                        "parentXAxis": "S",
                                        "renderAs": "line",
                                        "showValues": "1",
                                        "divlineThickness" : "1",
                                        "data": [ <?foreach($result as $t=>$res) if ($res['time']<$t_now) echo '{ "value" : "'.$res['count_proc'].'" },'?>]
                                    },
                                ]
                        }
                    });

                    revenueChart2.render();
                });
            }) ;
        </script>
        <style type="text/css">#chart-container2{margin:0 auto;width:1000px;}</style>
        <?
    }

    /**
     * Blend two hexadecimal colours
     * specifying the fractional position.
     *
     * Example:
     *     // 10% along the gradient between #66cc00 and #cc2200
     *     blend_hex('66cc00', 'cc2200', 0.1); // "70bb00"
     */
    function blend_hex($from, $to, $pos = 0.5)
    {
        // 1. Grab RGB from each colour
        list($fr, $fg, $fb) = sscanf($from, '%2x%2x%2x');
        list($tr, $tg, $tb) = sscanf($to, '%2x%2x%2x');

        // 2. Calculate colour based on frational position
        $r = (int) ($fr - (($fr - $tr) * $pos));
        $g = (int) ($fg - (($fg - $tg) * $pos));
        $b = (int) ($fb - (($fb - $tb) * $pos));

        // 3. Format to 6-char HEX colour string
        return sprintf('%02x%02x%02x', $r, $g, $b);
    }

}

?>
