<?php


function getBallFor($col_day){
    $TimeLineBall = [];
    $r = 0;
    while($r < $col_day){

        if($r < 1){
            $day = strtotime(date('d.m.Y', strtotime('-'.$r.' DAY')).'');
            //echo date('d.m.y H:i:s', $day).' ('.$day.')';
            //$allBall = execSQL('select pkey, c_data, work_id, answer_ball from post_shift_poll WHERE enabled=1 AND answer_ball > 0 AND c_data >= '.$day.''); // Должности их оценки по диапазонам


            $allBall = execSQL('select 
                                        t1.pkey,
                                        t1.c_data,
                                        t2.working,
                                        t1.answer_ball
                                        FROM post_shift_poll t1 
                                        LEFT JOIN view_personals t2 ON t1.personal_id = t2.pkey
                                        WHERE t2.clss=211 AND t2.enabled=1 AND t1.answer_ball > 0 AND t1.c_data >= '.$day.'
                            ');


        }else{
            $day = strtotime(date('d.m.Y', strtotime('-'.$r.' DAY')).'');
            $endDay = strtotime(date('d.m.Y', strtotime('-'.$r.' DAY')).', 23:59:59');

            // echo date('d.m.y H:i:s', $day).' - '.date('d.m.y H:i:s', $endDay);



            $allBall = execSQL('select 
                                        t1.pkey,
                                        t1.c_data,
                                        t2.working,
                                        t1.answer_ball
                                        FROM post_shift_poll t1 
                                        LEFT JOIN view_personals t2 ON t1.personal_id = t2.pkey
                                        WHERE t2.clss=211 AND t2.enabled=1 AND t1.answer_ball > 0 AND t1.c_data >= '.$day.' AND t1.c_data <= '.$endDay.'
                            ');

        }


        //print_r($allBall);

        //echo ' SUM BALL: '.count($allBall);
        //echo '<br>';
        array_push($TimeLineBall, $allBall);
        $r++;
    }

    //print_r($TimeLineBall);
    //echo '<br><br>';

    return $TimeLineBall;
} // Получаем массив баллов по дням



function getBallForFall($getBallFor, $working, $srBwork, $inPercent, $interval){

    //  print_r($getBallFor);
    //  echo '<br><br>';

    $ans = [];
    $r = 0;
    $mathHistory = [];
    while ($r < $interval){
        // Вот здесь пишем балл веса проблеммы
        $arrDat = getBallFall($getBallFor[$r], $working, $srBwork, $inPercent, $interval, $ans, $r, $mathHistory);
        array_push($ans, $arrDat[1]['ans']);
        array_push($mathHistory, $arrDat[0]);
        $r++;
    }
    return $ans;
} // Создаём массив баллов падения во времени



function quickSampling($getBallFor, $working, $srBwork){
    $H15 = 0;
    $H9 = 0;
    if (sizeof($getBallFor)) foreach ($getBallFor as $key => $value){
        if($value['working'] == $working){
            $H15++;
            if($value['answer_ball'] < $srBwork){
                $H9++;
            }
        }
    }
    $ret = [
        'H15' => $H15, // кол-во работников за день текущий
        'H9' => $H9, // кол-во баллов меньше среднего за день
    ];
    return $ret;
}



function in_accumulation($mathHistory){
    $A0 = 0;
    $A1 = 0;
    if (sizeof($mathHistory)) foreach ($mathHistory as $key => $value){
        $A0 = $A0 + $value['G9'];
        $A1 = $A1 + $value['B15'];
    }
    $return = [
        0 => $A0, // кол во всех поставленных баллов до текущего дня ниже среднего
        1 => $A1 // кол во всех поставленных баллов до текущего дня
    ];
    return $return;
}



function getBallFall($getBallFor, $working, $srBwork, $inPercent, $interval, $ans, $r, $mathHistory){


    // Собираем переменные для работы
    if($r == 0){
        $G9 = 0; // Кол-во баллов меньше среднего в колонке времени [Пред идущее]
        $G6 = 0; // Вес предидущей тревоги тревоги
        $G4 = 0; // Предидущее изменение накопления [Пред идущее]

        $Z1 = 0;
        $Z2 = 0;
    }else{
        $G9 = $mathHistory[$r - 1]['G9']; // Кол-во баллов меньше среднего в колонке времени [Пред идущее]
        $G6 = $mathHistory[$r - 1]['G6']; // Вес предидущей тревоги тревоги
        $G4 = $mathHistory[$r - 1]['G4']; // Предидущее изменение накопления [Пред идущее]
        $Z1 = $mathHistory[$r - 1]['Z2']; // < среднего сумма за всё время
        $Z2 = $mathHistory[$r - 1]['Z2']; // Кол-во работников за день до текущего дня
    }


    $H11 = $inPercent; // Общая доля процента ниже среднего (Всегда одно и тоже значение)
    $H15H9 = quickSampling($getBallFor, $working, $srBwork);
    $H15 = $H15H9['H15']; // Кол-во работников за день текущий *
    $H9 = $H15H9['H9']; // Кол-во баллов меньше среднего за день *

    if($H9 and $H15){
        $H5 = $H9 / $H15;
    }else{
        $H5 = 0;
    } // Доля меньше среднего

    $H7 = $H9 - $G9; // шт ниже среднего
    $A1 = in_accumulation($mathHistory); // Изменение накопления

    // Просуммированные значения
    $Z1 = $Z1 + $H9;
    $Z2 = $Z2 + $H15;

    /*
    if($A1[0] and $A1[1]){
        //$H4 = $A1[0] / $A1[1]; // Сумма баллов < среденго / сумма работников за всё время !!!!!!!!!!!!!! ОШИБКА 1
        $H4 = $Z1 / $Z2;
    }else{
        $H4 = 0;
    }*/

    if($Z1 and $Z2){
        $H4 = $Z1 / $Z2;
    }else{
        $H4 = 0;
    }

    // Изменение накопления


    // $warn = 0; // Текущая тревога ОШИБКА 2


    if($H5 > $H11) {
        if ($H7 + $G6 > 0) {
            $ansRT = $H7 + $G6;
        } else {
            $ansRT = round($H5 - $H11 * $H15, 0);
        }
    }else {
        if ($H4 > $G4) {
            if ($H7 + $G6 > 0) {
                $ansRT =  $H7 + $G6;
            }
        }
    }


    $return = [
        0 => [
            'G9' => $H9,
            'G6' => $ansRT,
            'G4' => $H4,
            'B15' => $H15H9['H15'],
            'Z1' => $Z1,
            'Z2' => $Z2
        ],
        1 => [
            'ans' => $ansRT
        ]
    ];

    return $return;
} // Собираем все плавающие данные и загоняем в формулу









/*
 *
 *  Дополнительные вычисления для таблицы
 */




function current_alarm($warnArr){
    $sum = 0;
    if (sizeof($warnArr)) foreach ($warnArr as $key => $value){
        if($value){
            $sum++;
        }else{
            break;
        }
    }

    if($sum){
        $ansver = $sum;
    }else{
        $ansver = '';
    }
    return $ansver;
}// Дней подряд текущей тревоги



function sumCurrent_alarm($warnArr){
    $sum = 0;
    if (sizeof($warnArr)) foreach ($warnArr as $key => $value){
        if($value){
            $sum = $sum + $value;
        }else{
            break;
        }
    }

    if($sum){
        $ansver = $sum;
    }else{
        $ansver = '';
    }
    return $ansver;
}// Сумма текущей тревоги



function amount_from($warnArr, $d_warn){
    $str = implode(",", $warnArr);

    $del = array(',,,', ',,',);
    $str = str_replace($del, "|", $str);
    $arr = explode("|", $str);

    $sum = 0;
    if (sizeof($arr)) foreach ($arr as $key => $value){
        $valueArr = explode(",", $value);
        $new_array = array_diff($valueArr, array(''));

        if(count($new_array) >= $d_warn){
            $sum = $sum + array_sum($new_array);
        }

    }

    if($sum){
        $ansver = $sum;
    }else{
        $ansver = '';
    }

    return $ansver;
}// Сумма Тревог от N дней подряд



function count_from($warnArr, $d_warn){
    $str = implode(",", $warnArr);

    $del = array(',,,', ',,',);
    $str = str_replace($del, "|", $str);
    $arr = explode("|", $str);

    $sum = 0;
    if (sizeof($arr)) foreach ($arr as $key => $value){
        $valueArr = explode(",", $value);
        $new_array = array_diff($valueArr, array(''));

        if(count($new_array) >= $d_warn){
            $sum++;
        }

    }

    if($sum){
        $ansver = $sum;
    }else{
        $ansver = '';
    }

    return $ansver;
}// Количество Тревог более N дней



// Комментарии отсутствуют на периоды "Тревоги более 2х дней"
// Сумма Тревог от 2х дней подряд без комментариев












