<?php
// сервис для сохранения файла титула 1 на диск и регистрации пакета
// далее делается парсинг и разбор пакета
// если водитель/авто не найден - сообщаем о ошибке
// проверка МО водителя и формирование ПЛ - на следующем этапе, отдельным заданием планировщика

include_once(_DIR_EXT.'/HTML/c_page_TXT.php') ;
class c_services_pl_put_titul_1 extends c_page_txt
{

	function check_access()
  { /*if (!$this->setting['no_check_access']) $result=ESMO_GATEWAY()->api_check_access() ;
    else $result=['status'=>'success','comment'=>''] ;

    //if ($result['client_id']) $this->client_id=$result['client_id'] ;
		if ($result['status']!='success') { $this->response_error($mode,array('code'=>$result['comment'],'ip'=>$_SERVER['REMOTE_ADDR'])) ; }
*/
	$result=ENGINE()->prepare_result(['error'=>0]) ;

    return($result) ;
  }

  function body()
  {	  ob_start() ;
	  $rec=[] ; $xml_size=0 ; $sign_size=0 ; $result=[] ;  $result_save_xml_file=0 ; $result_save_sign_file=0 ;
	  $rec['status']=1;
	  $rec['packet_mode']=1; // входящий
	  $rec['packet_type']=1; // титул 1
	  $rec['ip']=$_SERVER['REMOTE_ADDR'];
	  // регистрируем входящий пакет, создаем запись по пакету
	  $result_packet_register=PL()->packet_register($rec) ;
	  $packet_id=$result_packet_register['id'] ;
	  if (sizeof($_FILES))
	  {	  if (sizeof($_FILES['document']))
		  {
			  // сохраняем файл на диск
			  $file_name='titul_1_'.$packet_id.'.xml' ;
			  $file_dir=_DIR_TO_ROOT.'/public/pl_titul/'.$file_name ;
			  $result_save_xml_file=move_uploaded_file($_FILES['document']['tmp_name'],$file_dir) ;

			  // готовим данные для сохранения в базу
			  $rec=$this->parse_xml_packet_to_rec($file_dir) ;
			  //damp_array($rec);
			  if (sizeof($rec))
			  { $rec['xml_size']=$_FILES['document']['size'] ;
				$xml_size=$_FILES['document']['size'] ;
				PL()->packet_save($packet_id,$rec,['create_drivers'=>1]) ; // create_drivers - создать записи по водителямe
				//echo 'Данные по пакету сохранены<br>' ;

			  }
			  else $result=ENGINE()->prepare_result(['error'=>'source_error','comment'=>'error parsing XML doc']) ;

		  }
		  else $result=ENGINE()->prepare_result(['error'=>'source_error','comment'=>'not found document file']) ;

		  if (!$result['error'])
		  {
			if (sizeof($_FILES['signature']))
			  {
				  $file_name='titul_1_'.$packet_id.'.sign' ;
				  $file_dir=_DIR_TO_ROOT.'/public/pl_titul/'.$file_name ;
				  $result_save_sign_file=move_uploaded_file($_FILES['signature']['tmp_name'],$file_dir) ;

				  PL()->packet_save($packet_id,['sign_size'=>$_FILES['signature']['size']]) ;
				  $sign_size=$_FILES['signature']['size'] ;
			  }
			  else $result=ENGINE()->prepare_result(['error'=>'source_error','comment'=>'not found signature file']) ;
		 }
	  }
	  else $result=ENGINE()->prepare_result(['error'=>'source_error','comment'=>'not found FILES data']) ;

	  if ($result_save_xml_file and  $result_save_sign_file and $xml_size and $sign_size and !$result['error'])
	  {
		  // проверяем данные по сотруднику и авто в пакете
		  // если все ок - будет добавлена запись по путевому листу
		  $result=PL()->titul1_packet_parsing($packet_id) ;

	  }
	  //damp_array($_FILES);

	 $text=ob_get_clean() ;
	  //$result['files']=print_r($_FILES,1) ;
	 //echo $text ;
	 LOGS()->reg_log('put_titul1', $text) ;
	 if ($text) $result['debug']=$text ;
	 $this->response($result);
  }

  function parse_xml_packet_to_rec($fname)
  {
		$rec=[] ;
		$data = PL()->parse_xml_packet_to_array($fname) ;
		if ($data!=null)
		{
			$rec=[] ;
			$rec['file_uid']=$data['@attributes']['ИдФайл'] ;
			$rec['knd']=$data['Документ']['@attributes']['КНД'] ;

			// вариант с ПЛ на диапазон дат
			if (isset($data['Документ']['СодИнфСоб']['СрокПЛ']))
			{
				if (isset($data['Документ']['СодИнфСоб']['СрокПЛ']['@attributes']['ДатаНачИспПЛ']))
				{ $rec['titul_date_from']=strtotime($data['Документ']['СодИнфСоб']['СрокПЛ']['@attributes']['ДатаНачИспПЛ']) ;
				  $rec['titul_date_to']=strtotime($data['Документ']['СодИнфСоб']['СрокПЛ']['@attributes']['ДатаКонИспПЛ'].' 23:59:59') ;
				}
				else if (isset($data['Документ']['СодИнфСоб']['СрокПЛ']['@attributes']['ДатаИспПЛ']))
				{
					$rec['titul_date_from']=strtotime($data['Документ']['СодИнфСоб']['СрокПЛ']['@attributes']['ДатаИспПЛ']) ;
					$rec['titul_date_to']=strtotime($data['Документ']['СодИнфСоб']['СрокПЛ']['@attributes']['ДатаИспПЛ'].' 23:59:59') ;
				}
			}
			// вариант с ПЛ на одну дату
			else if (isset($data['Документ']['@attributes']['ДатИнфСоб']) and isset($data['Документ']['@attributes']['ВрИнфСоб']))
			{	$date=strtotime($data['Документ']['@attributes']['ДатИнфСоб'].' '.$data['Документ']['@attributes']['ВрИнфСоб']) ;
				$t=getdate($date) ;
				$rec['titul_date_from']=mktime(0,0,0,$t['mon'],$t['mday'],$t['year']) ;
				$rec['titul_date_to']=mktime(23,59,59,$t['mon'],$t['mday'],$t['year']) ;
				//damp_array($rec);
			}

			$rec['pl_number']=$data['Документ']['@attributes']['НомерПЛ'] ;
			$rec['trip_type']=$data['Документ']['@attributes']['ПризнНачРейс'] ;
			$rec['pl_uid']=$data['Документ']['СодИнфСоб']['@attributes']['УИД_ПЛ'] ;
			$rec['mo_type2_necessarily']=$data['Документ']['СодИнфСоб']['@attributes']['ОбМедОсмПосле'] ;
			$rec['pl_date']=strtotime($data['Документ']['СодИнфСоб']['СрокПЛ']['@attributes']['ДатаИспПЛ']) ;
			$rec['car_number']=$data['Документ']['СодИнфСоб']['СвТС']['ТС']['@attributes']['РегНомер'] ;
			if (isset($data['Документ']['СодИнфСоб']['СвВодит']['ВодитУд']))
			{
				$rec['drivers'][0]['driver_license_number']=$data['Документ']['СодИнфСоб']['СвВодит']['ВодитУд']['@attributes']['НомВУ'] ;
				$rec['drivers'][0]['driver_license_seria']=$data['Документ']['СодИнфСоб']['СвВодит']['ВодитУд']['@attributes']['СерВУ'] ;
				$rec['drivers'][0]['driver_license_data']=$data['Документ']['СодИнфСоб']['СвВодит']['ВодитУд']['@attributes']['ДатаВыдВУ'] ;
				$rec['drivers'][0]['driver_fio']=implode(' ',$data['Документ']['СодИнфСоб']['СвВодит']['ФИО']['@attributes']) ;
				$rec['drivers'][0]['driver_name1']=$data['Документ']['СодИнфСоб']['СвВодит']['ФИО']['@attributes']['Фамилия'] ;
				$rec['drivers'][0]['driver_name2']=$data['Документ']['СодИнфСоб']['СвВодит']['ФИО']['@attributes']['Имя'] ;
				$rec['drivers'][0]['driver_name3']=$data['Документ']['СодИнфСоб']['СвВодит']['ФИО']['@attributes']['Отчество'] ;
			}
			else if (isset($data['Документ']['СодИнфСоб']['СвВодит'][0])) foreach ($data['Документ']['СодИнфСоб']['СвВодит'] as $i=>$data_driver)
			{
				$rec['drivers'][$i]['driver_license_number']=$data_driver['ВодитУд']['@attributes']['НомВУ'] ;
				$rec['drivers'][$i]['driver_license_seria']=$data_driver['ВодитУд']['@attributes']['СерВУ'] ;
				$rec['drivers'][$i]['driver_license_data']=$data_driver['ВодитУд']['@attributes']['ДатаВыдВУ'] ;
				$rec['drivers'][$i]['driver_fio']=implode(' ',$data_driver['ФИО']['@attributes']) ;
				$rec['drivers'][$i]['driver_name1']=$data_driver['ФИО']['@attributes']['Фамилия'] ;
				$rec['drivers'][$i]['driver_name2']=$data_driver['ФИО']['@attributes']['Имя'] ;
				$rec['drivers'][$i]['driver_name3']=$data_driver['ФИО']['@attributes']['Отчество'] ;

			}
			//damp_array($data['Документ']['СодИнфСоб']);
			// получение данные по UID водителю через свободное поле
			if (isset($data['Документ']['СодИнфСоб']['ИнфПол']['ТекстИнф']['@attributes']))
				{	$dop_driver_info=$data['Документ']['СодИнфСоб']['ИнфПол']['ТекстИнф'] ;
					if ($dop_driver_info['@attributes']['Идентиф']=='Guid1') $rec['drivers'][0]['driver_uid']=$dop_driver_info['@attributes']['Значение'] ;
					if ($dop_driver_info['@attributes']['Идентиф']=='Guid2') $rec['drivers'][1]['driver_uid']=$dop_driver_info['@attributes']['Значение'] ;
				}
			if (isset($data['Документ']['СодИнфСоб']['ИнфПол']['ТекстИнф'])) foreach ($data['Документ']['СодИнфСоб']['ИнфПол']['ТекстИнф'] as $dop_driver_info)
				{
					if ($dop_driver_info['@attributes']['Идентиф']=='Guid1') $rec['drivers'][0]['driver_uid']=$dop_driver_info['@attributes']['Значение'] ;
					if ($dop_driver_info['@attributes']['Идентиф']=='Guid2') $rec['drivers'][1]['driver_uid']=$dop_driver_info['@attributes']['Значение'] ;
				}

		}
		return($rec) ;
	}


  function response($result,$options=[])
  {  header("Content-type: text/xml;") ;
	  //var_dump($result);
	   $imp = new DOMImplementation; // Creates an instance of the DOMImplementation class
	   $xml_doc = $imp->createDocument("",""); // Creates a DOMDocument instance
		 $xml_doc->encoding = 'windows-1251';
		 $xml_doc->formatOutput = true;
		 $xml = add_element($xml_doc,$xml_doc,'results','',array('date'=>date('Y-m-d H:i'))) ;
		 if (_sizeof($result)) foreach ($result as $item_name=>$item_attr)
		 {
			 if (is_array($item_attr))
			 { $item_value=($item_attr['value'])?:'' ;
			   unset($item_attr['value']) ;
			 }
			 else $item_value=$item_attr ;
			 $item = add_element($xml_doc,$xml,$item_name,$item_value,$item_attr) ;
			 //if (_sizeof($arr)) foreach($arr as $name=>$value)  if ($name!='uid') add_element($xml_doc,$item,$name,$value) ;
		 }
		 if ($options['debug']) add_element($xml_doc,$xml,'debug',$options['debug']) ;
		 echo $xml_doc->saveXML() ;
  }


}



?>
