<?php
class report_personals extends c_report
{
 var $title='Сотрудники' ;
 var $view_by_space_filter=1 ;
 var $allow_org_ids=1 ;
 var $usl_select_org='' ;
 var $allow_export_to_csv=1 ;
 var $group_ids=0 ;
 var $dop_props=array('OU'=>'Отложенное увольнение','FU'=>'Предстоящее увольнение','SM'=>'Совмещенцы','ALL'=>'Все действующие') ;
 var $no_use_account_usl_select=0 ;
 var $viewer_name='view_personals' ;
 var $select_field='fl.*' ;
 var $viewer_name_usl='' ;
 var $unions=[] ;
 var $left_join=[] ;
 var $debug=0 ;
 // опередение исходной области сотруднков
 // если для отчета задан personals_filter_reffer, то viewer_ids будет заполнен автоматически после  get_org_otdels_works_to_cur_account
 var $personals_filter_reffer=''; // reffer объекта, чьи фильтры надо использовать для определения исходной области сотрудников
 var $personals_filter_viewer=''; // вьювер IDS объекта, чьи фильтры надо использовать для определения исходной области сотрудников
 var $viewer_ids=''; // название вьювера, на основании сотрудников которого надо сделать отчет

 function init($create_options=array())
 { // если передано имя вьювера - просто готовим конструкцию для SQL. Передается либо в personals_filter_viewer либо в viewer_ids
   parent::init($create_options);
   //damp_array($this);
   if ($this->viewer_ids) PERSONALS_FILTER()->prepare_left_join_on_table($this->viewer_ids,$this->left_join) ;
   if ($this->personals_filter_viewer) PERSONALS_FILTER()->prepare_left_join_on_table($this->personals_filter_viewer,$this->left_join) ;
   // если передаен reffer фильтра, prepare_left_join_on_filter_reffer проверит есть ли готовый вьювер на эти условия
   // если нет - будет создана temp table
   // далее в left_join будет подготовлены фрагменты для SQL-запроса
   // и будет возвращено имя вьювера или временной таблицы
   if ($this->personals_filter_reffer) $this->personals_filter_viewer=PERSONALS_FILTER()->prepare_left_join_on_filter_reffer($this->personals_filter_reffer,$this->left_join,['debug'=>$this->debug]) ;
 }


 function setting($options=array())
 {   if (!is_array($options['disabled_filter'])) $options['disabled_filter']=array() ;
     if ($this->filter['reffer']) $this->personals_filter_reffer=$this->filter['reffer'] ;

     $arr_groups=ACCOUNTS()->get_arr_groups_to_cur_account() ;
     $options2=[] ;
     $options2['debug']=0 ;
     if ($this->personals_filter_viewer) $options2['viewer_ids']=$this->personals_filter_viewer ;
     list($arr_orgs_ids,$arr_otdel_ids,$arr_works_ids)=PERSONAL()->get_org_otdels_works_to_cur_account($this->filter,$options2) ;
     $form=new i_form;
     $form->form_open();
     if ($this->filter['ids']){?><input type=hidden name=filter[ids] value="(<?echo implode(';',array_keys($this->filter['ids']))?>)"><?}
     if ($this->filter['client_ids']){?><input type=hidden name=filter[client_ids] value="(<?echo implode(';',array_keys($this->filter['client_ids']))?>)"><?}
     if ($this->filter['client_id']){?><input type=hidden name=filter[client_id] value="<?echo $this->filter['client_id']?>"><?}
     $form->fieldset_open() ;
     $form->row_open() ;
     //$this->filter_section_select('reffer','REFFER:',2,$arr_reffers) ;
     $this->filter_section_select('group_id',$GLOBALS['LS_person_group_title'].':',2,$arr_groups) ;
     $this->filter_section_select_multiple('org_ids','Организация:',4,$arr_orgs_ids) ;
     $this->filter_section_select_multiple('otdel_ids','Подразделение:',4,$arr_otdel_ids) ;
     $this->filter_section_select_multiple('working_ids','Должность:',2,$arr_works_ids) ;
     $form->row_close_open() ;
     $this->filter_section_input_text('name','ФИО:',4,array('auto_complete'=>"autocomplette_personal_name")) ;
     $this->filter_section_input_text('propusk','Пропуск:',2) ;
     $this->filter_section_input_text('tab_number','Таб.номер:',2) ;
     $this->filter_section_input_text('uid','UID:',2) ;
     $this->filter_section_select('person_status','Дополнительный признак',2,$this->dop_props) ;
     $form->row_close_open() ;
     $this->filter_section_select_multiple('group_pers','Группа сотрудников:',2,_IL('IL_groups')->recs) ;
     $this->filter_section_select_multiple('group_medic','Группа по болезни:',3,_IL('IL_group_medic')->recs) ;
     $this->filter_section_input_text('age_from','Возраст, от:',2) ;
     $this->filter_section_input_text('age_to','Возраст, до:',2) ;
     $form->row_close() ;

     $form->fieldset_close();
     $this->panel_buttons();
     $form->form_close() ;
  }


 function setting_to_org($options=array())
 {   if (!is_array($options['disabled_filter'])) $options['disabled_filter']=array() ;

     $form=new i_form;
     $form->form_open();
     $form->fieldset_open() ;
     $form->row_open() ;
     //$this->filter_section_select_multiple('otdel_ids','Подразделение:',4,$arr_otdel_ids) ;
     //$this->filter_section_select_multiple('working_ids','Должность:',2,$arr_works_ids) ;
     //$form->row_close_open() ;
     $this->filter_section_input_text('name','ФИО:',4,array('auto_complete'=>"autocomplette_personal_name")) ;
     $this->filter_section_input_text('propusk','Пропуск:',2) ;
     $this->filter_section_input_text('tab_number','Таб.номер:',2) ;
     $this->filter_section_input_text('uid','UID:',2) ;
     $this->filter_section_select('person_status','Дополнительный признак',2,$this->dop_props) ;
     $form->row_close_open() ;
     $this->filter_section_select_multiple('group_pers','Группа сотрудников:',2,_IL('IL_groups')->recs) ;
     $this->filter_section_select_multiple('group_medic','Группа по болезни:',3,_IL('IL_group_medic')->recs) ;
     $this->filter_section_input_text('age_from','Возраст, от:',2) ;
     $this->filter_section_input_text('age_to','Возраст, до:',2) ;
     $form->row_close() ;

     $form->fieldset_close();
     $this->panel_buttons();
     $form->form_close() ;
  }

 function setting_org_otdel_works($options=array())
 {   if (!is_array($options['disabled_filter'])) $options['disabled_filter']=array() ;

     //$arr_orgs_ids=PERSONAL()->get_arr_orgs_to_cur_account('',array('view_disabled'=>$this->filter['status'])) ;
     //$GLOBALS['debug_db']=2 ;
     $options2=[] ;
     $options2['debug']=0 ;
     if ($this->personals_filter_reffer) $options2['filter_reffer']=$this->personals_filter_reffer ;
     if ($this->personals_filter_viewer) $options2['viewer_name']=$this->personals_filter_viewer ;
     list($arr_orgs_ids,$arr_otdel_ids,$arr_works_ids)=PERSONAL()->get_org_otdels_works_to_cur_account($this->filter,$options2) ;
     //$GLOBALS['debug_db']=0 ;

     $form=new i_form;
     $form->form_open();
     $form->fieldset_open() ;
     $form->row_open() ;
     $this->filter_section_select_multiple('org_ids','Организация:',4,$arr_orgs_ids) ;
     $this->filter_section_select_multiple('otdel_ids','Подразделение:',4,$arr_otdel_ids) ;
     $this->filter_section_select_multiple('working_ids','Должность:',2,$arr_works_ids) ;
     if ($options['show_filter_job_data']) $this->filter_section_input_text('job_data_from','Дата приема на работу, от:',2,array('class'=>'datepicker')) ;
     if ($options['show_filter_job_data']) $this->filter_section_input_text('job_data_to','Дата приема на работу, до:',2,array('class'=>'datepicker')) ;
     $form->row_close() ;

     $form->fieldset_close();
     $this->panel_buttons();
     $form->form_close() ;
  }

 function setting_small($options=array())
 {    // внимание! для не администратора тут только сам оператор
      ?><div id="panel_filter">
             <form id="sky-form" class="sky-form"><input type="hidden" name="filter_dir" value="<?echo _CUR_REPORT_DIR?>">
                  <fieldset>
                      <div class="row" id="person_info">
                           <section class="col col-2">
                               <label class="label">ФИО</label>
                               <label class="input">
                                    <input type="text" name="filter[name]" placeholder="" SetAutoComplete cmd="autocomplette_personal_name" value="<?echo $this->filter['name']?>">
                               </label>
                           </section>
                          <section class="col col-2">
                              <label class="label">Номер пропуска</label>
                              <label class="input">
                                  <input type="text" name="filter[propusk]" placeholder="" LANG="LAT" value="<?echo $this->filter['propusk']?>">
                              </label>
                          </section>
                          <section class="col col-2">
                              <label class="label">Должность</label>
                              <? $_usl=array() ;
                                 $_usl[]='clss=211' ;
                                 if ($this->filter['otdel_id']) $_usl[]='_otdel_id in ('.$this->filter['otdel_id'].')' ;
                                 $usl=implode(' and ',$_usl) ;
                                 $works_ids=execSQL_row('select distinct(working),1 from '.PERSONAL()->view_personal.' where '.$usl) ;
                              ?>
                              <label class="select">
                                  <select name="filter[working]" class="js-basic-multiple js-states form-control"><option></option>
                                     <?foreach(_IL('IL_works')->recs as $rec) if (!_sizeof($works_ids) or isset($works_ids[$rec['id']])) {?><option value="<?echo $rec['id']?>" <?if ($this->filter['working']==$rec['id']) echo 'selected'?>><?echo $rec['obj_name']?></option><?} ?>
                                  </select>
                              </label>
                          </section>
                          <section class="col col-2">
                              <label class="label">Смена</label>
                              <label class="select">
                                  <select name="filter[smena]"><option></option>
                                     <option value="cur" <?if ($this->filter['smena']=='cur') echo 'selected'?>>Текущая</option>
                                     <option value="prev" <?if ($this->filter['smena']=='prev') echo 'selected'?>>Предыдущая</option>
                                  </select>
                              </label>
                          </section>
                        </div>
                  </fieldset>
                  <?$this->panel_button_apply();?>
              </form>
       </div><br>
     <?
  }

function create_usl_select_obj($_params=array(),&$options=array())
  {   //$this->left_join=[] ;
      //$this->unions=[] ;

      //damp_array($this->filter);
      // условия для сотрудников по ФЛ и СО набираются одинаково для всех отчетов, где есть выбор по сотрудникам
      PERSONAL()->get_usl_select_FL($this->filter,$usl,$this->left_join,['no_use_account_usl_select'=>$this->no_use_account_usl_select,
                                                                         'filter_indx'=>$options['filter_indx']
                                                                        ]) ; // стандартные условия для отбора ФЛ + отбор по фильру аккаунта
      PERSONAL()->get_usl_select_SO($this->filter,$usl,$this->left_join) ; // стандартные условия для отбора СО

      // для вариантов, когда главная таблица сотрудников не obj_site_personals, возможно потрубется внести условие для ограничения выборки из этой таблицы
      // пример
      // viewer_name='view_event_personals'
      // viewer_name_usl=event_id=210
      if ($this->viewer_name_usl) $usl[]=$this->viewer_name_usl ;

      //damp_array($options);
      if ($options['debug'] or  $this->debug)
      {
          ?><strong>main table usl</strong><br><?  damp_array($usl,1,-1) ;
          if (_sizeof($this->left_join)) {?><strong>LEFT JOIN</strong><br><? damp_array($this->left_join,1,-1);}
          if (_sizeof($this->unions))    {?><strong>UNIONS</strong><br><? damp_array($this->unions,1,-1);}
      }

      // потом оставить тот вариант, что будет логичней
      $this->prepare_SQL_left_join() ;
      //list($this->join_table,$this->join_usl)=$this->prepare_SQL_left_join() ;



     if ($options['event_id'])
     {   $event_id=$options['event_id'] ;
         //echo 'event_id='.$event_id.'<br>' ;
         //$rec_event=EVENTS()->get_event_by_id($options['event_id']) ;
         // при отборе сотрудников на ПМО не учитываем региональность
         /*
         if ($rec_event['group_id'])
         { $event_group_id=$rec_event['group_id'] ;
           $chids_group=ACCOUNTS()->tree[$event_group_id]->get_list_child() ;
           $recs_orgs=execSQL('select pkey,obj_name from obj_site_personals where parent=1 and clss=207 and group_id in ('.$chids_group.') order by obj_name') ;
           //print_r($recs_orgs) ;
           if (_sizeof($recs_orgs)) $usl_so[]='parent2 in ('.implode(',',array_keys($recs_orgs)).')' ;
           else                    $usl_so[]='parent2=-1' ; // так не достатанься же ты никому
         } */

         // применяем собственные условия выборки мероприятия по СО и ФЛ (пока есть только во вводном инструктаже)
         $usl_so_event='' ; $usl_fl_event='' ;
         $obj_event=EVENTS()->get_event_obj_by_id($event_id) ;
         //damp_array($obj_event) ;
         if (method_exists($obj_event,'get_usl_select_workers')) $usl_so_event=$obj_event->get_usl_select_workers($event_id,$this->filter) ;
         if ($usl_so_event)  $usl[]=$usl_so_event ;
         if (method_exists($obj_event,'get_usl_select_personals')) $usl_fl_event=$obj_event->get_usl_select_personals($event_id,$this->filter) ;
         if ($usl_fl_event)  $usl[]=$usl_fl_event ;
     }

     //$this->prepare_SQL_left_join() ;
    $usl_res=(_sizeof($usl))? implode(' and ',$usl):'1' ;
     return($usl_res) ;
  }

 function get_arr_info_filters()
 { $info=parent::get_arr_info_filters() ;
   if ($this->fired==1)                                 $info['статус']='"уволенные"' ;
   if ($this->filter['status']==1)                      $info['статус']='"уволенные"' ;
   else if ($this->filter['status']==2)                 $info['статус']='"все"' ;
   if ($this->filter['person_status']=='OU')           $info['Отложенное увольнение']='Да' ;
   if ($this->filter['person_status']=='FU')           $info['Предстоящее увольнение']='Да' ;
   if ($this->filter['person_status']=='SM')           $info['Совмещенцы']='Да' ;
   if ($this->filter['person_status']=='ALL')           $info['Все действующие']='Да' ;
   if ($this->filter['ext']==1)                         $info['Доп.списки']='Да' ;

   // собственные условия отбора аккаунта применять не принятть при использовании отчена для формитрования условий отбора сотрудников в мероприятии
   if (!$this->no_use_account_usl_select)
   { if (MEMBER()->setting['personal']['usl_select'])     $info[MEMBER()->setting['personal']['name']]=strip_tags(MEMBER()->setting['personal']['info_filter']);
   }
   //damp_array(MEMBER()->setting['personal']) ;
   return $info ;
 }

    function get_count_sql($usl)
    { //damp_array($this);
        $sql=
           'select count(distinct(fl.pkey)) 
            from '.$this->viewer_name.' fl
            left join obj_site_workers so on so.personal_id=fl.pkey
           '.$this->join_table.' 
            where '.$usl.'
            '.$this->join_usl ;
        return ($sql);
    }

    // PERSONAL()->view_personal
    function get_cnt_items($usl,$options=array())
    { $options['debug']=$this->debug ;
      $cnt=execSQL_value($this->get_count_sql($usl),$options);
      return ($cnt);
    }

    // ВНИМАЕНИЕ! Обычная конструкция через view_personals left join obj_site_workers выдает по две записи одгого сотрудника при совмещении, что логично
    // вместо этого используется left join (select ....)
    function get_select_sql($usl)
    { $sql=
          'select fl.* 
           from '.$this->viewer_name.' fl
           left join obj_site_workers so on so.personal_id=fl.pkey
           '.$this->join_table.'           
           where '.$usl.'
           '.$this->join_usl.' 
           group by fl.pkey
           ' ;
        return ($sql);
    }

     function get_items($usl,$options=array())
     { $limit=($options['limit'])? ' '.$options['limit']:'' ;
       $order=($this->filter['order'])? ' order by '.$this->filter['order']:' order by fl.obj_name' ;
       $options['debug']=$this->debug ;
       $options['no_group']=1 ;
       $options['no_indx']=1 ;
       $list_rec=execSQL($this->get_select_sql($usl).$limit,$options) ;

       PERSONAL()->full_personals_SO_info($list_rec) ; // заполняем информацию по СО в записи по ФЛ
       PERSONAL()->full_personals_medic_groups($list_rec) ; // заполняем информацию по медгруппам в записи по ФЛ

       if (_sizeof($list_rec)) foreach($list_rec as $id=>$rec) PERSONAL()->prepare_public_info_to_personal($list_rec[$id],$options) ;
       return($list_rec) ;
     }

// шаблон - вывод ссылками без разделитея
  function print_template_HTML($list_recs,$options=array())
  { $id=($options['id'])? 'id='.$options['id']:'' ;
    ?><table class="list_personal_table_img basic fz_small full auto"<?echo $id?>>
        <tr><?if ($options['chech_check']){?><th>Выбор</th><?}?><th>ID</th><th>Пропуск</th><th>Фото</th><th>ФИО</th><th>Дата рождения</th><th>Возраст</th><th>Организация</th>
         <th>Подразделение</th>
         <th>Должность</th>
         <th>Группа сотрудников</th>
         <th>Группа по болезни</th>
        </tr><? ;
        if (_sizeof($list_recs)) foreach($list_recs as $rec)
        {   $rec['__href_window']='/window/personal/person/'.$rec['pkey'].'/' ;
            $img_href=img_clone($rec,'small');
            $img_href_relative = str_replace(_PATH_TO_SITE,'',$img_href);
            ?><tr class=item>
                <?if ($options['chech_check']){?><td><input type="checkbox" name="_check[]" value="<?echo $rec['_reffer']?>"></td><?}?>
                <td class="id"><?echo $rec['pkey']?></td>
                <td class="id"><?echo $rec['propusk']?><?if ($rec['demo_access']){?><div class="demo_access" title="Сотрудник может проходить неограниченное число МО"></div><?}?></td>
                <td class="img">
                    <div class="main_image" style="position:relative;">
                        <a  href="<?echo $rec['__href_window']?>" class="new_window" target="_blank" title="win_second"><img src="<?echo $img_href_relative?>"></a>
                        <? if ($GLOBALS['LS_faceid_view_info'] and function_exists('FACEID') and FACEID()->check_faceid_photo($rec['pkey'])) {?><img class="certificat_faceid" title="FaceID фото" src="/<?echo _CLASS_?>/ext/faceid/images/certificate.png" style="position:absolute;top:0;right:0;" width="16"><?}?>
                    </div>
                </td>
                <td class="left"><a href="<?echo $rec['__href_window']?>" class="new_window" target="_blank" title="win_second"><?echo $rec['obj_name']?></a>
                    <br><?echo '<span class="nowrap small">'.$rec['uid'].'</span>'?>
                    <?if (!$rec['enabled'])echo '<br><br><span class="red bold">УВОЛЕН</span> ('.date('d.m.Y H:i',$rec['fired_data']).')'?>
                    <?if ($rec['enabled'] and $rec['fired_data_pause']>0){?><div class="personal_fired_pause">Отложенное увольнение <span>до <?echo date('d.m.Y',$rec['fired_data_pause'])?></span></div><?}?>
                </td>
                <td class="dr"><?echo $rec['dr']?></td>
                <td class="age"><?echo $rec['age']?></td>
                <td class="left"><?echo $rec['_org_name']?>
                    <?
                        if ($rec['enabled'])echo '<div class="comment">с '.date('d.m.Y',$rec['_so'][0]['job_data']).'</div>' ;
                    ?>
                </td>
                <td class="left"><?echo $rec['_otdel_name']?></td>
                <td class="left"><?echo _IL('IL_works')->recs[$rec['working']]['obj_name']?>
                    <?if ($rec['working2']) echo '<br><strong>Совмещение: </strong>'._IL('IL_works')->recs[$rec['working2']]['obj_name']?>
                </td>
                <td><?if (_sizeof($rec['_groups_personal'])) echo implode('<br>',$rec['_groups_personal'])?></td>
                <td><?if (_sizeof($rec['_groups_medic'])) echo implode('<br>',$rec['_groups_medic'])?></td>
            </tr><?
        }
      ?></table><?
      //damp_array($rec) ;
  }


  function print_template_CSV($list_recs,$options=array())
  { $i=$options['from'] ;
    if (_sizeof($list_recs)) foreach($list_recs as $rec)
    {   $data=array() ;
        $data['№']=$i+1 ;
        $data['ID']=$rec['pkey']  ;
        $data['Пропуск']=$rec['propusk']  ;
        $data['GUID']=$rec['uid']  ;
        $data['ФИО']=$rec['obj_name']  ;
        $data['Дата рождения']=$rec['dr']  ;
        $data['Возраст']=$rec['age']  ;
        $data['Пол']=($rec['pol'])? 'Женский':'Мужской'  ;
        $data['Организация']=$rec['_org_name'] ;
        $data['Подразделение']=$rec['_otdel_name'] ;
        $data['Должность']= _IL('IL_works')->recs[$rec['working']]['obj_name'] ;
        $data['Уволен']=($rec['enabled'])? '':'Да' ;
        //if (sizeof(_IL('IL_groups')->recs)) foreach(_IL('IL_groups')->recs as $rec_group) $data[$rec_group['obj_name']]=($rec['_groups_personal'][$rec_group['id']])? 'Да':'' ;
        //if (sizeof(_IL('IL_group_medic')->recs)) foreach(_IL('IL_group_medic')->recs as $rec_group) $data[$rec_group['obj_name']]=($rec['_groups_medic'][$rec_group['id']])? 'Да':'' ;


        // вносим данные в csv
        $this->put_data_to_CSV($data,$i) ;
        $i++ ;
    }
  }



    function print_template_XML($list_recs,$options=array())
    { if (_sizeof($list_recs)) foreach($list_recs as $rec)
      {   $item=add_element($this->xml_doc,$this->xml,'item','',array('id'=>$rec['pkey'])) ;
          add_element($this->xml_doc,$item,'propusk',$rec['propusk']) ;
          add_element($this->xml_doc,$item,'tabnumber',$rec['tabnumber']) ;
          add_element($this->xml_doc,$item,'photo',($rec['_image_name'])? img_clone($rec,'source'):'') ;
          add_element($this->xml_doc,$item,'fio',$rec['obj_name']) ;
          add_element($this->xml_doc,$item,'uid',$rec['uid']) ;
          add_element($this->xml_doc,$item,'enabled',($rec['enabled'])? 1:0) ;
          add_element($this->xml_doc,$item,'dr',$rec['dr']) ;
          add_element($this->xml_doc,$item,'age',$rec['age']) ;
          add_element($this->xml_doc,$item,'pol',($rec['pol'])? 'Женский':'Мужской') ;
          add_element($this->xml_doc,$item,'phone',$rec['phone']) ;
          add_element($this->xml_doc,$item,'org_name',$rec['_org_name']) ;
          add_element($this->xml_doc,$item,'otdel_name',$rec['_otdel_name']) ;
          //add_element($this->xml_doc,$item,'org_id',$rec['_org_id']) ;
          //add_element($this->xml_doc,$item,'otdel_id',$rec['_otdel_id']) ;
          add_element($this->xml_doc,$item,'working',_IL('IL_works')->recs[$rec['working']]['obj_name']) ;
      }
    }

    function print_template_JSON($list_recs,$options=array())
       { $result=array() ;
         if (_sizeof($list_recs)) foreach($list_recs as $rec)
           $result[]=array('propusk'=>$rec['propusk'],
                           'photo'=>($rec['_image_name'])? img_clone($rec,'source'):'',
                           'fio'=>$rec['obj_name'],
                           'uid'=>$rec['uid'],
                           'enabled'=>($rec['enabled'])? 1:0,
                           'dr'=>$rec['dr'],
                           'age'=>$rec['age'],
                           'pol'=>($rec['pol'])? 'Женский':'Мужской',
                           'org_name'=>$rec['_org_name'],
                           'otdel_name'=>$rec['_otdel_name'],
                           'org_id'=>$rec['_org_id'],
                           'otdel_id'=>$rec['_otdel_id'],
                           'working'=>_IL('IL_works')->recs[$rec['working']]['obj_name']
                          ) ;
           $text_json_out=json_encode($result) ;
           // возвращает ответ устройству
           echo $text_json_out ;

       }

    function manual_tags_in()
    {
        ?><table class="basic fz_normal left">
                    <tr><td>uid</td><td>Уникальный идентификатор сотрудника</td></tr>
                    <tr><td>name</td><td>ФИО</td></tr>
                    <tr><td>org_id</td><td>ID организации</td></tr>
                    <tr><td>otdel_id</td><td>ID отдела</td></tr>
                    <tr><td>propusk</td><td>Номер пропуска</td></tr>
                    <tr><td>status</td><td>по умолчанию - только активные, 1 - уволенные, 2 - все</td></tr>
        </table><?
    }

    function manual_tags_out()
    {
        ?><table class="basic fz_normal left">
                    <tr><td>photo</td><td>url фото</td></tr>
                    <tr><td>fio</td><td>ФИО сотрудника</td></tr>
                    <tr><td>uid</td><td>Ваш уникальный идентификатор сотрудника.</td></tr>
                    <tr><td>fio</td><td>ФИО сотрудника</td></tr>
                    <tr><td>phone</td><td>Телефон сотрудника</td></tr>
                    <tr><td>propusk</td><td>Номер пропуска</td></tr>
                    <tr><td>tabnumber</td><td>Табельный номер</td></tr>
                    <tr><td>enabled</td><td>Состояние, 0 - заблокирован, 1-активный</td></tr>
                    <tr><td>dr</td><td>Дата рождения сотрудника, формат ДД.ММ.ГГГГ</td></tr>
                    <tr><td>pol</td><td>Пол сотрудника, 0=М, 1=Ж</td></tr>
                    <tr><td>org_name</td><td>Название организации сотрудника</td></tr>
                    <tr><td>otdel_name</td><td>Название подразделения организации</td></tr>
                    <tr><td>working</td><td>Должность</td></tr>
          </table><?
    }




}

?>
