<?php
include_once(_DIR_EXT.'/server/i_server.php') ;
class c_page_server_kt extends i_server
{
  public $autonom_mo = 0;

  function exec_operation($operation,$data_in,$options=[])
  {	 $data_out=array() ;
  	 switch($operation)
      { case 'power_on':            $data_out=$this->power_on($data_in) ; break ;
        case 'whois':               $data_out=$this->whois($data_in) ; break ;
        case 'check_access':        $data_out=$this->check_access_kt($data_in) ; break ;
        case 'examination_result':  $data_out=$this->examination_result_kt($data_in) ; break ;
        case 'check_update':        $data_out=$this->check_update($data_in) ; break ;
        case 'check_status':        $data_out=$this->virt_term_check_status($$data_in) ; break ;
      }
	  return($data_out) ;
  }

  function power_on($data)
   {
     $terminal_id=$data['args']['id']['terminal'] ;   $this->terminal_id=$terminal_id ;
     $terminal_ip=$_SERVER['REMOTE_ADDR'] ;
     if ($data['args']['terminal_type']=='virt') $terminal_ip=$data['args']['terminal_IP'] ;  // если терминал виртуальный, его IP адрес передается принудительно

     $_comment=array() ;

     $rec_terminal=DEVICE()->get_terminal_by_ip($terminal_ip,array('check_reboot'=>1)) ;
     $this->rec_terminal=$rec_terminal ;
     if (!$rec_terminal['pkey'])
     {   $_comment[]='<div class="red">Терминал с IP '.$terminal_ip.' не зарегистрирован в системе</div>' ;
         $rec_terminal=DEVICE()->get_terminal_by_id($terminal_id,array('check_reboot'=>1)) ;
     }
     if (!$rec_terminal['pkey']) $_comment[]='<div class="red">Терминал с ID '.$terminal_id.' не зарегистрирован в системе</div>' ;
     else
     { $group_setting=unserialize(execSQL_value('select settings from obj_site_skd where pkey="'.$rec_terminal['parent'].'"')) ;
       $timezone=($group_setting['timezone'])? $group_setting['timezone']:'Europe/Moscow' ;
       date_default_timezone_set($timezone) ;
     }


     $result['date'] = date('Y-m-d H:i:s');
     $result['args']['terminal_type']='mt' ;
     $result['args']['id']['terminal']=$terminal_id ;
     $result['args']['message']=($rec_terminal['pkey'])? 'success':'failure' ;
     $result['args']['data']['complex']=$GLOBALS['LS_setting_system_name'] ;

     $comment=(_sizeof($_comment))? implode('<br>',$_comment):'' ;

     LOGS()->reg_log('Включение терминала','Терминал '.$terminal_id.' ['.$terminal_ip.']: power_on => '.$result['args']['message'].$comment,
		     array('terminal_id'=>$terminal_id,'terminal_ip'=>$terminal_ip,'reffers'=>array($rec_terminal['_reffer']))) ;
     if ($rec_terminal['pkey'] and $rec_terminal['id']!=$terminal_id) { DEVICE()->terminal_save($rec_terminal['pkey'],array('id'=>$terminal_id)) ;   $rec_terminal['id']=$terminal_id ;  }
     if ($data['args']['id']['version'] and $rec_terminal['vers']!=$data['args']['id']['version'])  DEVICE()->terminal_save($rec_terminal['pkey'],array('vers'=>$data['args']['id']['version'])) ;
     DEVICE()->terminal_save($rec_terminal['pkey'],array('status'=>2)) ;    // устанавливаем состояние - готов к работе
     // отправляем уведомление операторам
     $xmpp_message=array() ;
     $xmpp_message['notife']='alert' ;
     $xmpp_message['notife_text']='Терминал '.$terminal_id.': включен' ;
     $xmpp_message['time']=date('d.m.y H:i:s') ; //  подгатавливаем массив информации по всем терминалам текущей группы
     $xmpp_message['from']='c_server::power_on' ;
     KT()->reg_monitor_mess($rec_terminal['zone_id'],$xmpp_message) ;

     // оправлем терминалу команду проверить статус, асинхронно
     DEVICE()->device_send_async_cmd($this->rec_terminal['pkey'],'check_status',array('pause'=>2,'reffers'=>array($rec_terminal['_reffer']))) ;

     return($result) ;
   }

   function whois($data)
   {
     $number=$data['args']['id']['number'] ;
     $terminal_id=$data['args']['id']['terminal']  ; $this->terminal_id=$terminal_id ;

     //$rec_member=KT()->get_personal_by_driving_tab_number($number) ;     set_time_point('get_personal_by_driver') ;
     //include_once(_DIR_EXT.'/aspmo_client/i_client.php') ;
     //$client=new c_client() ;
     if ($data['args']['id']['debug_db']) $GLOBALS['debug_db']=$data['args']['id']['debug_db'] ;
     ob_start() ;
     //$rec_member=PERSONAL()->whois_personal($number,array('dop_usl'=>'enabled=1')) ;  $this->personal_id=$rec_member['pkey'] ;
	 $options_whois=array('only_enabled'=>1,'dop_usl'=>'enabled=1') ;
     if (strpos($number,'#')!==false) $rec_member=PERSONAL()->whois_personal($number,$options_whois) ; // QR код будет сгенерирован на основе ВУ и номера авто
     else                             $rec_member=PERSONAL()->get_personal(array('propusk'=>$number,'tab_number'=>$number),array('only_enabled'=>1,'set_rules'=>1,'set_QR_code'=>$GLOBALS['LS_person_field_to_qrcode'],'dop_usl'=>'enabled=1')) ;
     //$this->personal_id=$rec_member['pkey'] ;

     $result['date'] = date('Y-m-d H:i:s');
     $result['args']['terminal_type']='mt' ;
     $result['args']['id']['terminal']=$terminal_id ;
     // 09.10.2015 если по whois был передан номер авто и номер прав - отправляем в user их обратно
     // это позволит  при check_access сформировать QR код на основе номер авто и номер прав
     $result['args']['id']['user']=($rec_member['_rec_car']['pkey'])? $rec_member['_rec_car']['obj_name'].'#'.$rec_member['driving']:$rec_member['propusk'] ;
     $result['args']['message']=($rec_member['pkey'])? 'success':'failure' ;
     //$result['args']['data']['reason']=($rec_member['pkey'])? '':'Сотрудник не найден' ; ;
     $result['args']['data']['reason']=$rec_member['_reason'] ;

     $result['args']['data']['user_name']=$rec_member['obj_name'] ;
     $result['args']['data']['user_ID']=$rec_member['pkey'] ;
     $result['args']['data']['user_propusk']=$rec_member['propusk'] ;
     $result['args']['data']['user_tab_number']=$rec_member['tab_number'] ;
     $result['args']['data']['user_driving']=$rec_member['driving'] ;
     $result['args']['data']['user_UUID']=$rec_member['uid'] ;
     $img_cont=(file_exists($rec_member['_image_dir']))? base64_encode(file_get_contents($rec_member['_image_dir'])):'' ;
     $result['args']['data']['photo']=$img_cont ;        set_time_point('photo') ;
     if ($rec_member['_qrcode_source']) $result['args']['data']['photo']=$rec_member['_qrcode_source'] ;

     LOGS()->reg_log('WHOIS','"'.$number.'"  => '.$rec_member['obj_name'].' ['.$rec_member['propusk'].']',array('member_id'=>$rec_member['pkey'],'terminal_id'=>$terminal_id)) ;
     if ($data['args']['id']['debug_db']) $GLOBALS['debug_db']=0;
     $text_debug=ob_get_clean()  ;
     if ($data['args']['id']['debug_db']) $result['args']['data']['debug_db']=$text_debug ;
       set_time_point('reg_log') ;
     return($result) ;
   }

  function check_access_kt(&$data)
  {
    ob_start() ;
    $terminal_id=$data['args']['id']['terminal'] ;  $this->terminal_id=$terminal_id ;
    $propusk_id=$data['args']['id']['user'] ;
    $result=array() ; $rec_member=array() ; $xmpp_message=array() ;  $view_mo_in_monitor=1 ; //  echo "LS_setting_monitor_view_only_success=".$GLOBALS['LS_setting_monitor_view_only_success'] ;
    // получаем инфу по терминалу
    $rec_terminal=DEVICE()->get_terminal_by_id($terminal_id,array('check_reboot'=>1)) ;
    if ($rec_terminal['pkey'])
    { $group_setting=unserialize(execSQL_value('select settings from obj_site_account where pkey="'.$rec_terminal['parent'].'"')) ;
      $timezone=($group_setting['timezone'])? $group_setting['timezone']:_DEFAULT_TIMEZONE ;
      date_default_timezone_set($timezone) ;
    }
    $terminal_name=$rec_terminal['obj_name'] ;
    // проверяем, что пропуск активен - поулчаем ифнорамцию по работнику
    if ($propusk_id)
    { $options_whois=array('only_enabled'=>1,'dop_usl'=>'enabled=1') ;
      if (strpos($propusk_id,'#')!==false) $rec_member=PERSONAL()->whois_personal($propusk_id,$options_whois) ; // QR код будет сгенерирован на основе ВУ и номера авто
      else                                 $rec_member=PERSONAL()->get_personal(array('propusk'=>$propusk_id,'tab_number'=>$propusk_id),array('only_enabled'=>1,'set_rules'=>0,'no_group'=>1,'set_QR_code'=>'propusk','dop_usl'=>'enabled=1')) ;
      $this->personal_id=$rec_member['pkey'] ;
    }

    $result['date'] = date('Y-m-d H:i:s');
    $result['args']['terminal_type']='mt' ;
    $result['args']['id']['terminal']=$terminal_id ;
    $result['args']['id']['user']=$rec_member['propusk'] ;
    $result['args']['data']['timeout']=$GLOBALS['LS_kt_setting_term_mess_view']*1000  ; // таймаут для выведенного сообщения в миллисекундах
    $result['args']['data']['timeout_mo']=$GLOBALS['LS_setting_kt_timeout'] ;



    // формируем запист по сесси МО с учетом реального оборудования, которые подключено к терминалу
    $member_id=$rec_member['pkey'] ;
    $res_session=array('terminal_id' =>$terminal_id,
                       'terminal_pkey' =>$rec_terminal['pkey'],
                       'member_id'   =>$member_id,
                       'zone_id'   =>$rec_terminal['parent'],
                       'alcotester'   =>1,
                       'message_terminal'=>'success'
                       );
    if ($rec_terminal['kt_type'])  $res_session['tk'] = $rec_terminal['kt_type']-1; //если терминал только предсменный или послесменный
    //$doctor_id=KT()->check_doctor($rec_terminal['parent'],array('debug'=>1)) ; // помещает информацию по допуску  в массив [__check]
    //if (!$GLOBALS['LS_mo_no_use_def_doctor']) $res_session['doctor_id']=$doctor_id ;

    if (isset($data['args']['exam_type'])) $res_session['tk'] = $data['args']['exam_type'];
    $mo_session_id=KT()->open_mo_session($res_session) ; // id записи по проведению МО ;
    $this->mo_id=$mo_session_id ;
    $this->mo_reffer=$mo_session_id.'.'.KT()->tkey ;

    // сохраняем фото авторизации
    if ($data['args']['photo']['auth']) $this->save_send_photo($data['args']['photo']['auth'],'/public/kt_photo/'.$mo_session_id.'_auth.jpg',array('img_rotare'=>0)) ;

    if ($member_id)
    {

        $result['args']['data']['user_name']=($GLOBALS['LS_hide_lastname_on_term'])? ENGINE()->hide_last_name($rec_member['obj_name']):$rec_member['obj_name'] ;


        $rec_member['mo_info']['mo_id']=$this->mo_id ;
        $rec_member['mo_info']['mo_reffer']=$this->mo_reffer ;
        $rec_member['mo_info']['terminal_id']=$this->terminal_id ;
        $rec_member['mo_info']['terminal_name']=$rec_terminal['obj_name'] ;
        $rec_member['mo_info']['group_name']=$rec_terminal['_group_name'] ;
        // проверяем допуск персонала, только для обычных терминалов
        KT()->check_personal_access($rec_member) ; // помещает информацию по допуску  в массив [__check]

       // если сотрудник допущен к МО
       if ($rec_member['__check']['result'])
       { $result['args']['id']['medexam']=$mo_session_id ;
         $result['args']['message']='success' ;
         $result['args']['comment']=$rec_member['__terminal_comment'] ;
         $result['args']['data']['alcotester']=1 ;
       }
       else // допуск к МО запрещен
       { $result['args']['message']='failure' ;

         // формируем текст, который будет выводиться на дисплей терминала
         $denited_info=(_sizeof($rec_member['__check_comment']))? implode('<br>',$rec_member['__check_comment']):'' ;
         if (!$denited_info) $denited_info=$_SESSION['ARR_mo_failed_status'][$rec_member['__reason']] ;
         $result['args']['data']['reason']=$denited_info  ; // свободный текст уведомления на дисплей

         // формируем текст уведомления на монитор дежурного врача
         $monitor_info=($denited_info)? $denited_info:$_SESSION['ARR_mo_failed_status'][$rec_member['__reason']] ;
         $xmpp_message['notife']='error' ;
         $xmpp_message['notife_text']=$terminal_name.', '.$rec_member['obj_name'].':'.$monitor_info;
         // формируем поля записи по МО
         $mo_data=array() ;
         $mo_data['status']=4 ;
         $mo_data['comment']=($rec_member['__reason'])? '':$denited_info ;
         $mo_data['reason']=$rec_member['__reason'] ;
         $mo_data['message_terminal']='failure' ;
         KT()->update_mo_session($mo_session_id,$mo_data) ;

         if ($rec_member['__go_doctor'])               $result['args']['data']['reason']='Для продолжения МО пройдите к врачу' ;
         elseif (isset($rec_member['__pause']))        $result['args']['data']['period']=$rec_member['__pause']  ;   // количество минут, через которое следует подойти
         else                                          $result['args']['data']['period']=$GLOBALS['LS_setting_auto_mo_interval']  ;   // количество минут, через которое следует подойти
         if ($result['args']['data']['period'])        $result['args']['data']['reason'].=' Пожалуйста, подойдите через '.$result['args']['data']['period'].' минут<br>' ;

         // сохраняем в логе
         if ($GLOBALS['LS_kt_logging_full']) LOGS()->reg_log('check_access','Авторизация - <span class=red>'.$denited_info.'</span>',array('terminal_id'=>$terminal_id,'member_id'=>$rec_member['pkey'],'data'=>array('Флаги проверок'=>$rec_member['__check'],'Комментарии проверок'=>$rec_member['__check_comment']))) ;

         if ($GLOBALS['LS_setting_monitor_view_only_success']) $view_mo_in_monitor=0 ;
       }
    }
    // пользватель не авторизован
    else
    {   $reason='' ;   $log_text='' ;
        $result['args']['message']='failure' ;
        //$result['args']['data']['period']=$GLOBALS['LS_setting_auto_mo_interval']  ;   // количество минут, через которое следует подойти
        $result['args']['data']['period']=0 ;
        $result['args']['data']['user_name']='Сотрудник' ;

        if (!$member_id)
        {   // сообщение для терминала
            $result['args']['data']['reason']='Идентификация не проведена, пожалуйста, обратитесь к врачу!'  ;   // свободный текст уведомления на дисплей
            // сообщение для лога
            $log_text='Пропуск "'.$propusk_id.'" не найден или заблокирован' ;
            // описание ошибки для записи в сессию МО
            $reason='noAutorize' ;
            // сообщение для оператора
            $xmpp_message['notife']='error' ;
            $xmpp_message['notife_text']='Терминал '.$terminal_name.': Идентификация не проведена, сотрудник направлен к фельдшеру.' ;
        }
        // сохраняем результат и ставим status 4 - осмотр не проводился
        // сохраняем результат и ставим status 4 - осмотр не проводился
        $mo_data=array() ;
        $mo_data['status']=4 ;
        $mo_data['comment']=$log_text ;
        $mo_data['reason']=$reason ;
        $mo_data['message_terminal']='failure' ;
        KT()->update_mo_session($mo_session_id,$mo_data) ;
        // сохраняем в логе
        if ($GLOBALS['LS_kt_logging_full']) LOGS()->reg_log('check_access',$log_text,array('terminal_id'=>$terminal_id,'member_id'=>$member_id,'mo_id'=>$mo_session_id)) ;

        // сохранем фото на диск
        if ($data['args']['photo']['auth']) $this->save_send_photo($data['args']['photo']['auth'],'/public/kt_photo/'.$mo_session_id.'_auth.jpg') ;

        if ($GLOBALS['LS_setting_monitor_view_only_success']) $view_mo_in_monitor=0 ;
    }

     // отправляем данные для уведомления и обновления таблицы
     // данные необходимо отправить всем АРМ текущей рабочей группы, кто имеет право получать уведомления
     $xmpp_message['terminal_status'][$rec_terminal['id']]=3 ; //DEVICE()->prepare_terminal_status_to_xmpp($rec_terminal['parent']) ; //  подгатавливаем массив информации по всем терминалам текущей группы
     $xmpp_message['time']=date('d.m.y H:i:s') ; //  подгатавливаем массив информации по всем терминалам текущей группы
     $xmpp_message['from']='c_server::check_access_kt' ;
     if ($view_mo_in_monitor) $xmpp_message['mo_tr_id']=$mo_session_id ;  ;
     if ($view_mo_in_monitor) $xmpp_message['mo_tr']=KT()->get_mo_session_view_table_tr($mo_session_id) ;  ;

     KT()->reg_monitor_mess($rec_terminal['parent'],$xmpp_message) ;
     $text=ob_get_clean() ;
     if ($text) $result['args']['data']['reason'].=$text ;
     return($result) ;
  }



   function examination_result_kt(&$data)
    {   // временный костыль
        $result=array() ; $xmpp_message=array() ;
        ob_start() ;
        $terminal_id=$data['args']['id']['terminal'] ;  $this->terminal_id=$terminal_id ;
        $propusk_id=$data['args']['id']['user'] ;
        $mo_session_id=$data['args']['id']['medexam']; // id сессии МО
        $rec_mo=KT()->get_mo_by_id($mo_session_id,array('no_public_info'=>1)) ; $this->mo_id=$rec_mo['pkey'] ;

        // формируем ответ
        $result['date'] = date('Y-m-d H:i:s');
        $result['args']['terminal_type']='mt' ;
        $result['args']['id']['terminal']=$terminal_id ;
        $result['args']['id']['user']=$propusk_id ;
        $result['args']['data']['timeout']=$GLOBALS['LS_kt_setting_term_mess_view']*1000  ; // таймаут для выведенного сообщения в миллисекундах
        $result['args']['data']['timeout_mo']=$GLOBALS['LS_setting_kt_timeout'] ;


        $rec_terminal=DEVICE()->get_terminal_by_id($terminal_id,array('check_reboot'=>1)) ;     set_time_point('get_terminal_by_id') ;
        $this->rec_terminal=$rec_terminal ;
        if ($rec_terminal['pkey'])
        { $group_setting=unserialize(execSQL_value('select settings from obj_site_skd where pkey="'.$rec_terminal['parent'].'"')) ;
          $timezone=($group_setting['timezone'])? $group_setting['timezone']:_DEFAULT_TIMEZONE ;
          date_default_timezone_set($timezone) ;
        }

        // проверяем, что пропуск активен - поулчаем ифнорамцию по работнику.
        // В  $rec_member['_rules'] будет внесена информация по критериям оценки сотрудника

        $rec_member=PERSONAL()->get_personal_by_id($rec_mo['member_id'],array('set_rules'=>0,'no_group'=>1)) ;   //set_time_point('get_personal_by_propusk') ;
        $this->personal_id=$rec_member['pkey'] ;
        $member_id=$rec_member['pkey'] ;

        // сохраняем данные измерений в запись МО
        $data_mo=array(   'e_data'=>time(),
                          'alko'=>($data['args']['data']['alcotester'])? 1:0,
                          'alko_value'=>($data['args']['data']['alcotester_value'])? $data['args']['data']['alcotester_value']:0,
                          'reason'=>$data['args']['data']['reason'],
                          'equipment'=>$data['args']['data']['equipment'],
                          'video'=>$data['args']['photo']['video']
                   ) ;

        if ($data['args']['data']['alcotester_calibration'])
        { $data_mo['reason']='alcotester_calibration' ;
	      DEVICE()->terminal_save($rec_terminal['pkey'],array('ext_info'=>array('alcotester_calibration'=>1))) ;


        }

        $res=KT()->update_mo_session($mo_session_id,$data_mo) ;

        // сохраняем фото начала МО
        if ($data['args']['photo']['alco']) $this->save_send_photo($data['args']['photo']['alco'],'/public/kt_photo/'.$mo_session_id.'_alco.jpg',array('img_rotare'=>0)) ;

        if ($member_id)
        {  // независимо от reason присланного терминалом, надо оценить результаты измерений
           $arr_result=array() ;
           $arr_result['a']=$data['args']['data']['alcotester'] ;
           $arr_result['a_value']=$data['args']['data']['alcotester_value'] ;

           // внимание!!! в $arr_result будут собраны результаты только тех измерений, которые поддерживает терминал
           // это важно, так как в KT()->get_mo_result_to_personal не будут оцениваться те измерения,
           // которые хотя и есть в правиле МО но нет в результатах от терминала
	       $rules_info=ESMO_RULES()->get_mo_rules_to_personal($rec_member) ;
           if ($this->autonom_mo) { $mo_result['status'] = 2; }
           else { $mo_result=KT()->get_mo_result_to_personal($rules_info['_rules'],$arr_result)  ; }

           // если осмотр был успешный
           if ($data['args']['message']=='success')
           {   $access=($mo_result['status']==2)? 1:0 ; // 2 = МО пройден, 3 - МО не пройден
               $comment=$mo_result['comment'] ;
               $mo_result['dopusk']=($access)? 1:2 ; // 1 - допуск получен, 2 - допуск не получен
               $mo_result['dopusk_time']=time() ;

	           $_dopusk_time_S=(float)$GLOBALS['LS_setting_auto_kt_allow_interval']*60 ; // срок действия меддопуска в секундах
	           $_nedopusk_time_S=(float)$GLOBALS['LS_setting_auto_kt_denited_interval']*60; // срок действия меддопуска в секундах
	           $time_dopusk_S=($access)?  $_dopusk_time_S:$_nedopusk_time_S ;


               $mo_result['dopusk_time_end']=time()+$time_dopusk_S ;
               // сохраняем данные измерений в запись МО
               KT()->update_mo_session($mo_session_id,$mo_result) ; // id записи по проведению МО

               if ($access) { $result['args']['message']='success' ;
                              $result['args']['data']['reason']='Контроль трезвости пройден';
                              // сохраняем в логе
                              LOGS()->reg_log('Окончание КТ','Пройден',array('terminal_id'=>$terminal_id,'member_id'=>$rec_member['pkey'],'mo_id'=>$mo_session_id)) ;
                            }
               else         { $result['args']['message']='failure' ;
                              if ($GLOBALS['LS_setting_mo_failed_mess_detailed']) $result['args']['data']['reason']=$comment ;
                              else                                                $result['args']['data']['reason']='контроль трезвости не пройден' ;
                              $result['args']['data']['reason'].='. Подойдите к врачу для прохожения МО' ;

                              // сообщение для оператора
                              $xmpp_message['notife']='error' ;
                              $xmpp_message['notife_text']='Терминал '.$terminal_id.', '.$rec_member['obj_name'].': контроль трезвости не пройден' ;
                              // сохраняем в логе
                              LOGS()->reg_log('Окончание КТ','Не пройден',array('terminal_id'=>$terminal_id,'member_id'=>$rec_member['pkey'],'mo_id'=>$mo_session_id)) ;
                              set_time_point('reg_log') ;
                            }
           }
           // failure – выход по таймауту
           else if ($data['args']['data']['reason']=='cancelTimeout')
           {  $comment='Превышено время отведенное на проведение КТ' ;
              $mo_result['error']=4 ;
              $mo_result['status']=3 ;
              KT()->update_mo_session($mo_session_id,$mo_result) ; // id записи по проведению МО
              // сообщение для оператора
              $xmpp_message['notife']='error' ;
              $xmpp_message['notife_text']='Терминал '.$terminal_id.', '.$rec_member['obj_name'].': '.$comment ;
              // сохраняем в логе
	          LOG_JSON('mo_session')->reg('Окончание МО по таймауту',$comment,array('terminal_id'=>$terminal_id,'member_id'=>$rec_member['pkey'],'mo_id'=>$mo_session_id)) ;

              $result['args']['message']='failure' ;
              $result['args']['data']['reason']=$comment ;

           }
           else //failure – МО окончен, отказ в доступе(причина указывается в параметре args.data.reason)
           { // ключевые поля для разспознования ощибки
             // args.data.reason
             // args.data.equipment
             // сохраняем данные измерений в запись МО
             $reason=$data['args']['data']['reason'] ;
             $device=$data['args']['data']['equipment'] ;
             $status=3 ;
             $comment=$_SESSION['ARR_mo_failed_status'][$reason] ;
             if ($device)  $comment.=', '.$_SESSION['ARR_mo_failed_dev'][$device] ;
             $reason_text=$comment ; // $reason - текст для вывода на экране терминала

             // не удалось провести измерение
             if ($reason=='equipmentError')
             { $reason_text.='Не удалось провести измерение, пожалуйста, попробуйте еще раз' ;
             }

             // неисправность устройства
             if ($reason=='equipmentFailure')  // неисправность устройства => сообщение клиенту занять другой терминал, терминал в перезагрузку, check_status, режим неисправности
             { $reason_text='Оборудование неисправно ('.$_SESSION['ARR_mo_failed_dev'][$device].'). Пройдите проверку на другом терминале.' ;
               // оправлем терминалу команду проверить статус, асинхронно
	           DEVICE()->device_send_async_cmd($this->rec_terminal['pkey'],'reboot',array('pause'=>5)) ;
               $status=4 ;
             }

             $mo_result['status']=$status ;

             KT()->update_mo_session($mo_session_id,$mo_result) ;

             $result['args']['message']='failure' ;
             $result['args']['data']['reason']=$reason_text ;
             // сообщение для оператора
             $xmpp_message['notife']='error' ;
             $xmpp_message['notife_text']='Терминал '.$terminal_id.', '.$rec_member['obj_name'].':  контроль трезвости не пройден: '.$comment ;
             // сохраняем в логе
             if ($GLOBALS['LS_kt_logging_full']) LOGS()->reg_log('Окончание медосмотра','Не пройден: '.$comment,array('terminal_id'=>$terminal_id,'member_id'=>$rec_member['pkey'],'mo_id'=>$mo_session_id)) ;
           }

           // отправляем данные для уведомления и обновления таблицы
           // данные необходимо отправить либо владельцу терминала, либо всем сотрудникам АСПМО, кто имеет право получать уведомления
            $xmpp_message['mo_tr_id']=$mo_session_id ;  ;
            $xmpp_message['mo_tr']=KT()->get_mo_session_view_table_tr($mo_session_id) ;  ;
            $xmpp_message['terminal_status'][$rec_terminal['id']]=2 ; // статус терминала 2 - готов к работе
            $xmpp_message['time']=date('d.m.y H:i:s') ; //  подгатавливаем массив информации по всем терминалам текущей группы
            $xmpp_message['from']='c_server::examination_result_kt' ;
            $xmpp_message['kt_dopusk']=$mo_result['dopusk'] ;

            KT()->reg_monitor_mess($rec_terminal['parent'],$xmpp_message) ;
        }
        //damp_array($xmpp_message,1,-1) ;
        $text=ob_get_clean() ;
        $result['args']['data']['reason'].=$text ;

        // инициируем событие
        ENGINE()->on_event('examination_result_kt',array('mo_id'=>$mo_session_id)) ;

        return($result) ;
    }

    function check_update($data)
    {
        $terminal_id=$data['args']['id']['terminal'] ; $this->terminal_id=$terminal_id ;
        $version=$data['args']['id']['version'] ;

        $arch = $data['args']['id']['arch'] ;
        switch ($arch) {
            case 'arm':
                $arch = '-arm';
                break;
            default:
                $arch = '';
        }

        $terminal=DEVICE()->get_terminal_by_id($terminal_id,array('check_reboot'=>1)) ;
        if ($terminal['pkey'])
        { $group_setting=unserialize(execSQL_value('select settings from obj_site_skd where pkey="'.$terminal['parent'].'"')) ;
          $timezone=($group_setting['timezone'])? $group_setting['timezone']:'Europe/Moscow' ;
          date_default_timezone_set($timezone) ;
        }
        $res = [];
        if ($terminal['pkey']) {
            if ($terminal['assigned_version'] && $version != $terminal['assigned_version']) {
                $res['version'] = $terminal['assigned_version'];
                $res['url'] = _PATH_TO_SITE.'/updates/esmo-'.$terminal['assigned_version'].$arch.'-installer';
            }
        }
        return $res;
    }

    function virt_term_check_status($data)
    {
       // формируем ответ
       $result['date'] = date('Y-m-d H:i:s');
       $result['message']='success' ;
       $result['args']['terminal_type']='kt' ;
       $result['args']['data']['video']='success' ;
       $result['args']['data']['tonometer']='success' ;
       $result['args']['data']['thermometer']='success' ;
       $result['args']['data']['alcotester']='success' ;
       $result['args']['data']['pupilometer']='success' ;
       $result['args']['ext_info']['comment']='response from c_server:virt_term_check_status' ;
	   $this->is_log_request=0 ; // не регистрируем данный запрос, так как он виртуальный и отвечать на самом деле должен терминал
       return($result) ;
    }



}
?>
