# Signature Pad

SignaturePad: A jQuery plugin for assisting in the creation of an HTML5 canvas based signature pad. Records the drawn signature in JSON for later regeneration.

• Dependencies: FlashCanvas/1.5, json2.js, jQuery/1.3.2+

---

## Quick Start

1. Include `jquery.signaturepad.css`, `flashcanvas.js`, `jquery.js`, `jquery.signaturepad.js`, `json2.js` in your HTML file
2. Create the HTML, [following the example](examples/accept-signature.html)
3. `$('.sigPad').signaturePad();`
4. Remember that [most things are configurable](documentation.md#options)

## Complete Documentation

#### [☛ Signature Pad Documentation](documentation.md)

## Examples

- [Accepting a Signature](examples/accept-signature.html)
- [Requiring a Drawn Signature](examples/require-drawn-signature.html)
- [Regenerating a Signature](examples/regenerate-signature.html)
- [Accepting Multiple Signatures](examples/accept-multiple-signatures.html)

## Demos

- [Accepting a Signature](https://thread-pond.github.io/signature-pad/examples/accept-signature.html)
- [Requiring a Drawn Signature](https://thread-pond.github.io/signature-pad/examples/require-drawn-signature.html)
- [Regenerating a Signature](https://thread-pond.github.io/signature-pad/examples/regenerate-signature.html)

## Converting to an Image

#### [☛ Converting to an image](documentation.md#converting-to-an-image)

---

## License

© 2014, Thomas J Bradley, <hey@thomasjbradley.ca>

Signature Pad is licensed under the [New BSD license](LICENSE).

All dependencies: jQuery, json2.js, and FlashCanvas retain their own licenses.
