<?
class image_print
{
    var $source ;
    var $width=180 ;
    var $height=270 ;
    var $back_color='ffffff' ;

    function __construct()
    {
        $this->source=imagecreatetruecolor($this->width,$this->height) ;
        imagefill($this->source,0,0,hexdec($this->back_color));
    }

    function put_text_to_center($text,$size,$y)
    {
        // First we create our bounding box
        $bbox = imageftbbox($size, 0, FONT_NAME, $text);
    
        // This is our cordinates for X and Y
        $x = $bbox[0] + (imagesx($this->source) / 2) - ($bbox[4] / 2) - 5;
        //$y = $bbox[1] + (imagesy($this->source) / 2) - ($bbox[5] / 2) - 5;
    
        imagefttext($this->source, $size, 0, $x, $y, FONT_COLOR, FONT_NAME, $text);
    }
    
    function show_line($y)
    {
        imageline ( $this->source , 10 , $y+2 , 170 , $y+2 , LINE_COLOR ) ;
    }
    
    
}

class image_print_result_MO extends image_print 
{ 
    var $rec_mo ;
    var $rec_account ;
    var $width=180 ;
    var $height=270 ;
    var $line_color='AAAAAA' ;
    var $font_color='000000' ;


    function __construct($rec_mo)
    { parent::__construct() ;
      $this->rec_mo=$rec_mo ;
      $this->rec_account=ACCOUNTS()->get_member_by_id($this->rec_mo['doctor_id']) ;

      define('FONT_COLOR',hexdec($this->font_color)) ;
      define('LINE_COLOR',hexdec($this->line_color)) ;
      define('FONT_NAME',_DIR_EXT.'/image_print/DejaVuSerif.ttf') ;
      define('FONT_SIZE_TITLE',10) ;
      define('FONT_SIZE_TEXT',7) ;
      define('FONT_SIZE_COMMENT',6) ;
    }
    
    function get_image_content()
    {   
        $this->put_text_to_center(PERSONAL()->get_name_by_id($this->rec_mo['personal_parent2']),FONT_SIZE_TEXT,20) ;
        $arr=explode(" ",$this->rec_mo['personal_name']) ;
        $this->put_text_to_center($arr[0],FONT_SIZE_TITLE,40) ; $this->show_line(40) ;
        $this->put_text_to_center($arr[1],FONT_SIZE_TITLE,55) ; $this->show_line(55) ;
        $this->put_text_to_center($arr[2],FONT_SIZE_TITLE,70) ; $this->show_line(70) ;
        $this->put_text_to_center('Прошел предрейсовый осмотр,',FONT_SIZE_TEXT,90) ;
        $this->put_text_to_center('к исполнению трудовых',FONT_SIZE_TEXT,100) ;
        $this->put_text_to_center('обязаностей допущен',FONT_SIZE_TEXT,110) ;
        imagefttext($this->source,FONT_SIZE_TEXT,0,10,130,FONT_COLOR,FONT_NAME,'Дата: '.date('d.m.Y').' Время: '.date('H:i:s')) ;
        $this->put_text_to_center('Фельдшер:',FONT_SIZE_TEXT,150) ;
        $arr=explode(" ",$this->rec_account['obj_name']) ;
        $this->put_text_to_center($arr[0],FONT_SIZE_TEXT,165) ;
        $this->put_text_to_center($arr[1],FONT_SIZE_TEXT,180) ;
        $this->put_text_to_center($arr[2],FONT_SIZE_TEXT,195) ;
        $this->put_text_to_center('Данные ЭП',FONT_SIZE_COMMENT,220) ;
        $this->put_text_to_center('Серийный номер:',FONT_SIZE_COMMENT,230) ;
        $this->put_text_to_center($this->rec_account['sert_id'],FONT_SIZE_COMMENT,240) ;
        $this->put_text_to_center('Удостоверяющий центр:',FONT_SIZE_COMMENT,250) ;
        $this->put_text_to_center($this->rec_account['sert_ud'],FONT_SIZE_COMMENT,260) ;
    
        $arr[]='Дата: '.date('d.m.Y').' Время: '.date('H:i:s')  ;
    
        ob_start() ;
        $res=imagepng($this->source);
        $text=ob_get_clean() ;
        return($text) ;
    }
}

class image_print_MO_sertificate_stamp extends image_print
{
    var $rec_mo ;
    var $rec_account ;
    var $width=323 ;
    var $height=165 ;
    var $line_color='AAAAAA' ;
    var $border_color='000000' ;
    var $font_color='000000' ;


    function __construct($rec_mo)
    { parent::__construct() ;
      $this->rec_mo=$rec_mo ;
      $this->rec_account=ACCOUNTS()->get_member_by_id($this->rec_mo['doctor_id']) ;
      //$this->rec_account=ACCOUNTS()->get_member_by_id(MEMBER()->id) ;

      define('FONT_COLOR',hexdec($this->font_color)) ;
      define('LINE_COLOR',hexdec($this->line_color)) ;
      define('FONT_NAME',_DIR_EXT.'/image_print/OldStandard-Regular.ttf') ;
      define('FONT_NAME_COMMENT',_DIR_EXT.'/image_print/FiraSansExtraCondensed-Regular.ttf') ;
      define('FONT_SIZE_TITLE',19) ;
      define('FONT_SIZE_TEXT',17) ;
      define('FONT_SIZE_TIME',12) ;
      define('FONT_SIZE_COMMENT',10) ;
    }

    function get_image_content()
    {   imageRectangle($this->source, 0, 0, $this->width - 1, $this->height - 1,$this->border_color);
	    $rec_group=ACCOUNTS()->get_group_by_id($this->rec_mo['group_id']) ;
	    $group_timezone=(isset($rec_group['_settings']['timezone']))? $rec_group['_settings']['timezone']:_DEFAULT_TIMEZONE ;
        //$group_timezone='Europe/Samara' ;

        $this->put_text_to_center($GLOBALS['LS_mo_org_name'],FONT_SIZE_TITLE,25) ;
        $this->put_text_to_center('Прошел предрейсовый осмотр,',FONT_SIZE_TEXT,50) ;
        $this->put_text_to_center('к исполнению трудовых',FONT_SIZE_TEXT,70) ;
        $this->put_text_to_center('обязаностей допущен',FONT_SIZE_TEXT,90) ;
        imagefttext($this->source,FONT_SIZE_TIME,0,10,110,FONT_COLOR,FONT_NAME,'Дата: '.ENGINE()->get_local_time($this->rec_mo['c_data'],$group_timezone,'d.m.Y')) ;
        imagefttext($this->source,FONT_SIZE_TIME,0,225,110,FONT_COLOR,FONT_NAME,'Время: '.ENGINE()->get_local_time($this->rec_mo['c_data'],$group_timezone,'H:i')) ;
        imagefttext($this->source,FONT_SIZE_TIME,0,10,125,FONT_COLOR,FONT_NAME,'Фельдшер: '.$this->rec_account['obj_name']) ;

	    imagefttext($this->source,FONT_SIZE_COMMENT,0,10,145,FONT_COLOR,FONT_NAME_COMMENT,'Данные ЭП: С/Н: '.$this->rec_account['certificate']['SerialNumber']) ;
	    imagefttext($this->source,FONT_SIZE_COMMENT,0,10,160,FONT_COLOR,FONT_NAME_COMMENT,'У/Ц: '.$this->rec_account['certificate']['Issuer']['CN']) ;

        ob_start() ;
        $res=imagepng($this->source);
        $text=ob_get_clean() ;
        return($text) ;
    }
}

?>