<?php
include_once("c_esmo_setting_terminal_card.php");
class c_page_cab_esmo_setting_terminal_card_errors_report extends c_page_cab_esmo_setting_terminal_card
{
    public $h1 = 'Карточка терминала - отчет по ошибкам' ;
    public $use_datepicker = 1;

    function set_default_time() {
        $cur_data_arr = getdate(time());
        $date_to = mktime(0,0,0, $cur_data_arr['mon'], $cur_data_arr['mday'], $cur_data_arr['year']);
        $date_from = $date_to - (60 * 60 * 24 * 30);

        if(!$this->filter['date_to']) {
            $this->filter['date_to'] = date('d.m.Y', $date_to);
        } else {
            if(strtotime($this->filter['date_to']) > $date_to) $this->filter['date_to'] = date('d.m.Y', $date_to);
        }

        if(!$this->filter['date_from']) {
            $this->filter['date_from'] = date('d.m.Y', $date_from);
        } else {
            if(strtotime($this->filter['date_from']) < $this->rec_terminal['c_data']) $this->filter['date_from'] = date('d.m.Y', $this->rec_terminal['c_data']);
        }
    }

    function settings_panel() {
//        damp_array($this->rec_terminal, 1, -1);

        $path_arr = explode('/', trim(_CUR_CAB_DIR, '/'));
        $path = '/';
        for($i = 0; $i <= _sizeof($path_arr); $i++) {
            if($path_arr[$i] == 'errors_report') {
                $path .= _CUR_ID.'/'.$path_arr[$i];
            } else {
                $path .= $path_arr[$i].'/';
            }
        }

        ?>
        <form class="sky-form no_box_shadow" id="sky-form">
            <input type="hidden" name="filter_dir" value="<?echo $path?>">
            <div class="row">
                <section class="col col-2">
                    <label class="label">От:</label>
                    <label class="input"><input type="text" name="filter[date_from]" class="datepicker" data-required value="<?echo $this->filter['date_from'];?>"></label>
                </section>
                <section class="col col-2">
                    <label class="label">До:</label>
                    <label class="input"><input type="text" name="filter[date_to]" class="datepicker" data-required value="<?echo $this->filter['date_to'];?>"></label>
                </section>
                <section class="col co1-2">
                    <button class="button v2" type="submit" cmd="set_filter" style="margin-top: 25px; margin-left: 0;">Показать</button>
                </section>
            </div>
        </form>
        <?
    }

    function prepare_data() {
        $result = [];

        $start_ts = strtotime($this->filter['date_from']);
        $end_ts = strtotime($this->filter['date_to']);

        $t = $start_ts;

        while($t <= $end_ts) {
            $t1 = $t;
            $t += 60 * 60 * 24;
            $t2 = $t - 1;

            $result[date('d.m.Y', $t1)]['mo_cnt'] = execSQL_value('select count(pkey) from obj_site_mo_session where terminal_pkey='._CUR_ID.' and status in (2,3) and c_data>='.$t1.' and c_data<='.$t2,0,1) ;
            $result[date('d.m.Y',$t1)]['equipmentFailure']=execSQL_row('select equipment,count(pkey) from obj_site_mo_session where terminal_pkey='._CUR_ID.' and reason="equipmentFailure" and (c_data>='.$t1.' and c_data<='.$t2.') group by equipment',0,1) ;
            $result[date('d.m.Y',$t1)]['equipmentError']=execSQL_row('select equipment,count(pkey) from obj_site_mo_session where terminal_pkey='._CUR_ID.' and reason="equipmentError" and (c_data>='.$t1.' and c_data<='.$t2.') group by equipment',0,1) ;
            $result[date('d.m.Y',$t1)]['cancelTimeout']=execSQL_row('select equipment,count(pkey) from obj_site_mo_session where terminal_pkey='._CUR_ID.' and reason="cancelTimeout" and (c_data>='.$t1.' and c_data<='.$t2.') group by equipment',0,1) ;
        }

        $all_devices = execSQL_line('select distinct(equipment) from obj_site_mo_session where terminal_pkey='._CUR_ID.' and (reason="equipmentFailure" or reason="equipmentError" or reason="cancelTimeout") and c_data>='.$start_ts.' and c_data<='.$end_ts.' order by equipment') ;
        $vers_history = execSQL_row('select c_data, vers
                                            from device_history 
                                            where terminal_pkey='._CUR_ID.'
                                            order by c_data');

//        $result = array_reverse($result);

        foreach ($result as $date => $val) {
            $cur_v = '';
            $time_s = strtotime($date);
            $ts_arr = getdate($time_s);
            $time_e = mktime(0,0,0,$ts_arr['mon'],$ts_arr['mday']+1,$ts_arr['year']) - 1;

            $result[$date]['time_s'] = $time_s;
            $result[$date]['time_e'] = $time_e;

            foreach ($vers_history as $v_date => $v) {
                if($v_date < $time_e) $cur_v = $v;
            }

            $result[$date]['ver'] = $cur_v;
        }

//        echo date('d.m.Y', $start_date).'<br>';
//        echo date('d.m.Y', $end_date).'<br>';

        $result = array_reverse($result);

//        damp_array($vers_history,1,-1);
//        damp_array($result,1,-1);

        return [$result, $all_devices];
    }

    function print_HTML() {
        list($result, $all_devices) = $this->prepare_data();
//        damp_array($result);
//        damp_array($all_devices);
        ?>
        <h2 class="center">Отчет по ошибкам терминала за период с <?echo $this->filter['date_from'];?> по <?echo $this->filter['date_to'];?></h2><br>

        <table class="basic auto fz_small" style="margin: 0 auto;">
            <tbody>
            <tr>
                <th rowspan="2">Дни</th>
                <th rowspan="2">Кол-во пройденных МО</th>
                <th colspan="<?echo _sizeof($all_devices)?>">Число неисправностей по устройствам</th>
                <th rowspan="2">Версия ПО терминала</th>
            </tr>
            <tr>
                <?foreach($all_devices as $device) {?>
                    <th><?echo $device?></th>
                <?}?>
            </tr>

            <?foreach ($result as $date => $rec) {
                ?>
                <tr>
                    <td><?echo $date;?></td>
                    <td><?echo $rec['mo_cnt'];?></td>

                    <?if(_sizeof($all_devices)) foreach($all_devices as $device) {?>
                        <td>
                            <?
                            echo '<a href="/cab/reports/report_mo_sess_tech/[terminal_id='.$this->rec_terminal['id'].',equipment='.$device.',equipmentFailure=1,time_from='.$rec['time_s'].',time_to='.$rec['time_e'].']/" class="blue" title="equipmentFailure" target=_BLANK>'.$rec['equipmentFailure'][$device].'</a> ' ;
                            echo '<a href="/cab/reports/report_mo_sess_tech/[terminal_id='.$this->rec_terminal['id'].',equipment='.$device.',equipmentError=1,time_from='.$rec['time_s'].',time_to='.$rec['time_e'].']/" class="red" title="equipmentError" target=_BLANK>'.$rec['equipmentError'][$device].'</a> ' ;
                            echo '<a href="/cab/reports/report_mo_sess_tech/[terminal_id='.$this->rec_terminal['id'].',equipment='.$device.',cancelTimeout=1,time_from='.$rec['time_s'].',time_to='.$rec['time_e'].']/" class="green" title="cancelTimeout" target=_BLANK>'.$rec['cancelTimeout'][$device].'</a> ' ;
                            ?>
                        </td>
                    <?} else {
                        echo '<td></td>';
                    };?>

                    <td>
                        <?
                        echo $rec['ver'];
                        ?>
                    </td>

                </tr>
            <?}?>
            </tbody>
        </table>
        <?
    }

    function block_main() {
        $this->page_title();

        $this->set_default_time();
        $this->settings_panel();
        $this->print_HTML();

    }



}
?>
