<?
// класс для импорта данных из файла XML во временную таблицу
// данные переносятся как есть, заголовки таблицы будут использованы как названия столбцов
class i_xml_to_db_import
{
  public $XML_fname ;
  public $XML ;
  public $table ;
  public $row_import ;
  public $session_uid ;
  public $XML_main_element = 'Person';


  var $db_debug=0;
  var $import_begin_time=0;

  var $arr_XLS_cols_names=array() ;   // массив - столбец XLS => заголовок
  var $arr_XLS_cols_DB=array() ;      // массив - столбец XLS => столбец БД
  var $append_row_count=500 ;

  var $def_field_size=256 ;

  function __construct($options=array())
  {
      if ($options['XML_main_element']) $this->XML_main_element=$options['XML_main_element'];
      $this->session_uid=($options['uid'])? $options['uid']:$_GET['uid'] ;
     if (!$this->session_uid) $this->session_uid=ENGINE()->generate_UID() ;
     $this->table='temp_import_'.$this->session_uid ;
  }

  function delete_temp_tables()
  {
     execSQL_update('drop table if exists '.$this->table) ;
  }


  function import()
  {  $result=array() ;
     if ($this->connect_SOURCE())
     { $this->parse_headers() ;
       $result=$this->create_temp_table() ;
       if (!$result['error'])
       { $this->parse_XML_to_temp_table() ;
       $result=array('success'=>1) ;
     }
     }
     else
     {
         $result=array('error'=>'XML is not valid','descr'=>'Некорректная структура XML') ;
     }
     return($result) ;

  }

  // подключается к источнику данных и сохраняет XML контент в  SOAP_XML_content
  function connect_SOURCE()
    {   set_time_limit(0) ;
        //damp_array($this,1,-1) ;
        $XML_source=file_get_contents(_DIR_TO_ROOT.$this->XML_fname) ;
        //echo 'fname='._DIR_TO_ROOT.$this->XML_fname ;
        //echo 'len='.strlen($XML_source) ;
        $this->XML = new SimpleXMLElement($XML_source);
        if(is_object($this->XML)) return(1) ;
        else
        {   echo 'Не удалось открыть файл как XML<br>' ;
            return(0) ;
        }
    }

    // получаем заголовки XLS файла и сохраняем в массив
    function parse_headers()
    {
        $XML_main_element=$this->XML_main_element;
        if (is_object($this->XML))
        {  foreach ($this->XML->$XML_main_element as $item)
           { foreach($item as $key=>$value)
             {
                 $this->arr_XLS_cols_names[$key]=$key ;  // первая строка - заголовки
                 $this->arr_XLS_cols_DB[$key]=$this->check_db_fields_names($key) ;  // первая строка - заголовки

             }
           }
        }
        //damp_array($this->arr_XLS_cols_names,1,-1) ;
        //damp_array($this->arr_XLS_cols_DB,1,-1) ;
        $this->flog_append('parse_XML_headers') ;
    }

    // создаем временную таблицу на основе данных из xls файла - как есть
   function create_temp_table()
   {   execSQL_update('DROP TABLE  IF EXISTS '.$this->table) ;
       $arr_fields=array() ;
       if (_sizeof($this->arr_XLS_cols_DB)) foreach($this->arr_XLS_cols_DB as $fname) $arr_fields[]=$fname.' text NULL' ;
       if (_sizeof($arr_fields))
       { $sql='CREATE TABLE  '.$this->table.' (ai_key int(11) auto_increment,primary key (ai_key),'.implode(',',$arr_fields).') ENGINE = InnoDB DEFAULT CHARSET=utf8' ;
       execSQL_update($sql,array('debug'=>0)) ;
       echo 'Создана временная таблица для размещения данных из XML файла<br>' ;
         $result=array('success'=>1) ;
       }
       else
       { echo 'Недостаточо исходных данных для создания временной таблицы<br>' ;
         $result=array('error'=>'XML is space','descr'=>'Недостаточо исходных данных для создания временной таблицы') ;
       }
       return($result) ;

   }

   // переносим данные из ИСТОЧНИКА в таблицу soap_xml_block в формате "как есть"
   function parse_XML_to_temp_table()
   {   $this->flog_append('parse_xls_to_temp_table start') ;
       $XML_main_element=$this->XML_main_element;
       ?>Переносим данные в во временную таблицу<br><?
       if (is_object($this->XML))
       {
           $this->flog_append('XML parser начинаем читать данные файла') ;
           $row=0 ;  $row_all=_sizeof($this->XML->$XML_main_element) ;
           if (_sizeof($this->XML->$XML_main_element)) foreach ($this->XML->$XML_main_element as $item)
           { $arr_item=(array)$item ;
             $data=array() ;
             // необходимо идти по заранее подготовлено списоку столбцов, так как в объекте могут быть не все поля
             if (_sizeof($this->arr_XLS_cols_DB)) foreach($this->arr_XLS_cols_DB as $fname)
             {   $data[$fname]=$arr_item[$fname] ;
                 if ($fname=='Images_url' and $item->Images_url and _sizeof($item->Images_url->children())) foreach($item->Images_url->children() as $name=>$value)
                                        { $data['Images_url']=(string)$value  ;
                                          $arr_img_names[]=basename((string)$value) ;
                                        }
             }
             $row++ ;
             //damp_array($data) ;
             multiSQL_insert($this->table)->append($data) ;
             $this->flog_append('прочитана строка '.$row.' из '.$row_all) ;
           }
           multiSQL_insert($this->table)->flush() ;

           echo 'Прочитано строк файла XML: <strong>'.$row.'</strong><br>' ;
           echo 'Cохранено строк с данными: <strong>'.$row_all.'</strong></br>' ;

           $this->flog_append('all read line: '.$row_all) ;
           $this->row_import=$row ;
       }
       else $this->flog_append('Не удалось прочитать XLS файл') ;
       $this->flog_append('parse_xls_to_temp_table end') ;
    }

    function insert_arr_to_db_temp($table_fields,$arr)
    {   $sql='REPLACE INTO '.$this->table.' ('.$table_fields.') VALUES '.implode(', ',$arr).';' ;
        execSQL_update($sql,array('debug'=>0)) ;
    }

    function check_db_fields_names($text)
    {  $text=trim($text) ;
       $text=stripslashes($text) ;
       $text=strip_tags($text) ;
       $text=translit($text) ;
       //$text=iconv('utf-8','ASCII//TRANSLIT',$text) ;
       // удаляем вредные символы

       $text=str_replace(array("\\",'/','"',"'",'`',',','.','+','?','&','#','%','<','>','-','(',')','=','!','[',']',':'),'',$text) ;
       $text=trim($text) ;
       // заменяем подряд следующие пробелы ( в том числе переносы строк и табуляторы) на символ-заменитель пробела
       $text=preg_replace('/\s+/','_',$text) ;
       $text=preg_replace('/\-+/','_',$text) ;
       //echo  $text.'<br>' ;

       return($text) ;
    }


    function flog_append($text)
    {
      FILE_LOG()->append($text);
    }

}

?>
