<?php
// входной скрипт для URL https://dev.kvzrm.ru/services/esmo_gateway/upload_persons/
// внимание! по умолчанию сервис возвращает структурированный ответ по выполенными операциям
// для просмотра лога импорта надо либо передать опцию show_log, либо после приема сервиса достать лог из файла _DIR_TO_ROOT.'/logs/import_trace_'.$arr_result['session_uid'].'.html'
include_once(_DIR_EXT.'/esmo_gateway/i_personal_import.php') ;
class c_services_esmo_gateway_upload_persons extends i_personal_import
{
  var $table_xml;
  var $db_debug=0;
  var $import_begin_time=0;
  var $read_only=0;
  var $full_update=0;
  var $read_block_stats=array() ;
  var $view_result_mode=0 ;

  // список полей, которые будут проверяться на изменения при импорте ФЛ
  // нужен только для выявления изменений!
  var $arr_FL_fields=array('ФИО'=>'obj_name',
                           'ДР'=>'dr',
                           'Пол'=>'pol',
                           'Адрес'=>'adres',
                           'Таб.номер'=>'tab_number',
                           'СНИЛС'=>'snils',
                           'Состояние'=>'enabled',
                           'Пропуск'=>'propusk',
                           'ВУ'=>'driving',
                           'Разрешение на работу'=>'permit',
                           'Лицензия на работу'=>'PersonLicense',
                           'Дата медстравки'=>'s_medspravka',
                           'Телефон'=>'phone',
                           'Опасная работа'=>'danger',
                           'full_access'=>'full_access',
                           'Тип печати наряда'=>'print_order_type',
                           'URL для печати наряда'=>'print_order_URL',
                           'Время начала действия печати наряда'=>'print_order_time_from',
                           'Время окончания действия печати наряда'=>'print_order_time_to',
                           //'Images_url'=>'Images_url',
                           //'Image_name'=>'Image_name',
                           //'Стаж'=>'stazh',
                           //'Стаж послений'=>'stazh_last',
          ) ;


	    function defined_vars()
	    {  define('ORG_NAME','org_name') ;
	       define('OTDEL_NAME','otdel_name') ;
	       define('OTDEL_NAME2','otdel_name2') ;
	       define('OTDEL_NAME3','otdel_name3') ;
	       define('WORK_NAME','work_name') ;
	       define('UID_FL','uid') ;
	       define('UID_SO','uid') ;
	       define('VZ','vz') ;
	       define('DR','dr') ;
	       define('DU',$this->source_fnames['du']['code']) ;
	       define('POL','pol') ;
	       define('MAIN_WORK_NAME','main') ;
	    }

	  function exec()
	  { FILE_LOG()->append('VIEW_SOURCE: '.(($this->view_source)? 'ON':'OFF')) ;
	    FILE_LOG()->append('READ_ONLY: '.(($this->read_only)? 'ON':'OFF')) ;
	    FILE_LOG()->append('FULL_UPDATE: '.(($this->full_update)? 'YES':'NO')) ;
        $error='' ; $result=array() ;

	    // проверка IP
	    if (!$GLOBALS['LS_gate_extended_server_ip']) { $error='access_denied for '.$_SERVER['REMOTE_ADDR'] ; $this->view_result_mode=1 ; }
	    else
	    {   $arr_ips=explode(',',$GLOBALS['LS_gate_extended_server_ip']) ;
	    	foreach($arr_ips as $i=>$ip) $arr_ips[$i]=trim($ip) ;
	    	if (!in_array($_SERVER['REMOTE_ADDR'],$arr_ips)) { $error='access_denied for '.$_SERVER['REMOTE_ADDR'] ; $this->view_result_mode=1 ; }
	    }

	    if ($error=='')
        {   ob_start() ;
            if (!$this->setting['upload_fname'])
            { $XML_cont = file_get_contents("php://input");
              if (!$XML_cont) $XML_cont=file_get_contents(_DIR_EXT.'/esmo_gateway/demo/'.$_GET['check_file']) ;
              $temp_fdir=hide_server_dir(_TEMP_DIR.$this->session_uid.'.xml') ;
              file_put_contents(_DIR_TO_ROOT.$temp_fdir,$XML_cont) ;
              echo 'XML данные сохранены во временном файле: <a href="'.$temp_fdir.'" target="blank">'.$temp_fdir.'</a><br>' ;
              $this->setting['upload_fname']=$temp_fdir ;
              $this->view_result_mode=1 ;
            }

            // переносим данные XLS во временную таблицу
            include_once(_DIR_EXT.'/esmo_gateway/i_xml_to_db_import.php') ;
            $XML_to_DB = new i_xml_to_db_import(array('session_uid'=>$this->session_uid)) ;
            $XML_to_DB->XML_fname=$this->setting['upload_fname'] ;  // /temp/0_a34d0deb97e04aa9409668dddf7666f6.xlsx
            $res=$XML_to_DB->import() ;
            if ($this->setting['view_source'])
           {  ?><h2>Прочитанный файл XLS, первые 10 строк с данными</h2><?
              $recs=execSQL('select * from '.$XML_to_DB->table.' limit 10') ;
              print_2x_arr($recs) ;
           }
           elseif ($res['success'])
                  {
                      $this->table_xml=$XML_to_DB->table ;
                      $this->defined_vars() ;
                      $this->create_temp_tables() ;  // создаем стандартные таблицы ФЛ и СО (используется метод из i_personal_import)
                      $this->parse_XML_DB_to_table_fl() ;
                      $this->parse_XML_DB_to_table_so() ;
                      $this->sync_TEMP_DB_ESMO() ;
                      $this->sync_workings_persons() ;
                      $this->sync_images_to_upload() ;
                      $result=$this->import_result ;

                      $this->delete_temp_tables() ;


                      //$stats=execSQL_row('select enabled,count(pkey) from obj_site_personals where clss=211 group by enabled') ;
                      //$stats_img1=execSQL_value('select count(pkey) from obj_site_personals where _image_name!=""') ;
                      //$stats_img2=execSQL_value('select count(pkey) from obj_site_personals where upl_img!=""') ;

                      $result['person_count']=$XML_to_DB->row_import ;
                      $result['person_update']=$this->fz_update;
                      $result['person_adding']=$this->fz_create ;
                      //$result['person_enabled']=($stats[1])? $stats[1]:0 ;
                      //$result['person_disabled']=($stats[0])? $stats[0]:0 ;
                      //$result['strusture_add']=$personal_import->org_otdel_create ;
                      //$result['img_exist']=$stats_img1 ;
                      //$result['img_to_upload']=$stats_img2 ;
                      //$result['img_to_delete']=$cnt_img_to_delete ;
                      $result['session_uid']=$this->session_uid ;
                  }

            $XML_to_DB->delete_temp_tables() ;

            adding_rec_to_table('obj_site_post_log',array('obj_name'=>'upload_persons','IP'=>$_SERVER['REMOTE_ADDR'],'result'=>$result,'session_uid'=>$this->session_uid,'clss'=>362),array('debug'=>0)) ;

            $text=ENGINE()->get_html_doc_content(ob_get_clean()) ;
            $trace_fname='import_trace_'.$this->session_uid.'.html' ;
            LOGS()->reg_file_log($trace_fname,$text,array('no_append_time'=>1)) ;
        }

		if (!$this->view_result_mode) echo $text ;
		else
        {   ob_clean() ; // чистим все отправленно е ранее
            if (_sizeof($result)) foreach($result as $key=>$value) echo $key.'='.$value."\n" ;
            if ($error) echo $error ;
        }

		return($result) ;

	  }


	  // тут происходит постобрабтка данных из XML файла
	  // так как в временную таблицы данные были загружены как есть
	  // теперь их надо перенести в таблицы ФЛ и СО в допустимом для импорта виде
	  function parse_XML_DB_to_table_fl()
	  { echo '<strong>Формируем промежуточную таблицу ФЛ</strong><br>' ;
	  	$recs=execSQL('select * from '.$this->table_xml,0,1) ;
	      if (_sizeof($recs)) foreach($recs as $rec)
	      {   $uid=($rec['Uuid'])? $rec['Uuid']:$rec['uid'] ;
	          $data=array('uid'=>$uid,
	                      'obj_name'=>(isset($rec['Name']))? $rec['Name']:null,
	                      'phone'=>(isset($rec['Phone']))? $rec['Phone']:null,
	                      'dr'=>(isset($rec['Dr']))? $rec['Dr']:null,
	                      'age'=>(isset($rec['Dr']))?  ENGINE()->get_age_by_dr($rec['dr']):null,
	                      'propusk'=>(isset($rec['Propusk']))? $rec['Propusk']:null,
	                      'tab_number'=>(isset($rec['TabNumber']))? $rec['TabNumber']:null,
	                      'permit'=>(isset($rec['Permit']))? str_replace(' ','',$rec['Permit']):null ,
	                      'driving'=>(isset($rec['DriverLicense']))? str_replace(' ','',$rec['DriverLicense']):null, // надо удалить все пробелы из строки  $driving=str_replace(' ','',$driving) ;,
	                      'PersonLicense'=>(isset($rec['PersonLicense']))? str_replace(' ','',$rec['PersonLicense']):null,
	                      's_medspravka'=>(isset($rec['DateMedSpravka']))? (int)(($rec['DateMedSpravka'])? strtotime($rec['DateMedSpravka']):0):null,
	                      'pol'=>(isset($rec['Pol']))? (($rec['Pol']=='М' or $rec['Pol']=='М')? 0:1):null,
	                      'adres'=>(isset($rec['Adres']))? $rec['Adres']:null,
	                      'danger'=>(isset($rec['boolean']))? (($rec['boolean'] == '1' or $rec['boolean'] == 'True' or $rec['boolean']== 'true')? 1:0):null,
	                      'full_access'=>(isset($rec['FullAccess']))? (($rec['FullAccess'])? 1:0):null,
	                      'enabled'=>($rec['Fired'])? 0:1,
	                      'Images_url'=>(isset($rec['Images_url']))?  $rec['Images_url']:null,
	                      'Image_name'=>(isset($rec['Images_url']))? basename($rec['Images_url']):null,
                          'org_name'=>(isset($rec['Org']))? $rec['Org']:null,
                          'print_order_type'=>(isset($rec['PrintOrderType']))? $rec['PrintOrderType']:null,
                          'print_order_URL'=>(isset($rec['URLForPrintOrder']))? $rec['URLForPrintOrder']:null,
                          'print_order_time_from'=>(isset($rec['PrintOrderTimeFrom']))? strtotime($rec['PrintOrderTimeFrom']):null,
                          'print_order_time_to'=>(isset($rec['PrintOrderTimeTo']))? strtotime($rec['PrintOrderTimeTo']):null,
	                   ) ;
	          if ($uid!="") multiSQL_insert($this->table_fz)->append($data) ;
	          else if (!$uid) echo '<div class="red">Отсутствует UID ФЛ ['.$rec['Name'].']</div>' ;
	          //else if (!$rec['Org']) echo '<div class="red">В исходных данных отсутствует организация [UID '.$rec['UID'].']</div>' ;

	      }
	       multiSQL_insert($this->table_fz)->flush() ;
	  }

	  function parse_XML_DB_to_table_so()
	  {  echo '<strong>Формируем промежуточную таблицу СО</strong><br>' ;
	  	 $recs=execSQL('select * from '.$this->table_xml,0,1) ;
	      if (_sizeof($recs)) foreach($recs as $rec)
	      {   $uid=($rec['Uuid'])? $rec['Uuid']:$rec['uid'] ;
	          $data=array('uid'=>$uid,
	                      'obj_name'=>(isset($rec['Name']))? $rec['Name']:null,
	                      'org_name'=>(isset($rec['Org']))? $rec['Org']:null,
	                      'otdel_name'=>(isset($rec['Structure']))? $rec['Structure']:null,
	                      'work_name'=>(isset($rec['Working']))? $rec['Working']:null,
	                      'is_main'=>1,
			              'enabled'=>($rec['Fired'])? 0:1, //  для блокировки создания новых СО при передачи данных по уволенному сотруднику
			              'fired_data'=>($rec['Fired'])? time():0,   // дата увольнения для существующих сотрудников
	                      'vz'=>'main', // дублирование поля  is_main, но пока оставим
	                   ) ;
	          if ($uid!="") multiSQL_insert($this->table_so)->append($data) ;
	          else if (!$uid) echo '<div class="red">Отсутствует UID СО ['.$rec['Name'].']</div>' ;
	          //else if (!$rec['Org']) echo '<div class="red">В исходных данных отсутствует организация [UID'.$rec['UID'].']</div>' ;
	      }
	       multiSQL_insert($this->table_so)->flush() ;
	  }

}



?>
