<?php
class report_esmo_config extends c_report
{
 var $title='Отчет конфигурация ЭСМО' ;
 var $view_by_space_filter=1 ;
 var $allow_org_ids=1 ;
 var $usl_select_org='' ;
 var $show_on_page_peports=0 ;

  function full_level_info($id,&$child_ids,&$recs_db,&$data)
  {
      $rec=$recs_db[$id] ;//echo '----<br>'.print_r($rec,true).'<br>------<br>' ;
      switch($rec['clss'])
      { case 1:    $node=array('item'=>'workgroup','db_id'=>$id,'name'=>$rec['obj_name'])  ; break ;   // рабочая группа
        case 203:  $node=array('item'=>'terminal',
                               'name'=>$rec['obj_name'],
                               'terminal_id'=>$rec['id'],
                               'terminal_type'=>$rec['terminal_type'],
                               'virtual'=>($rec['virt'])? 1:0,
                               'version'=>$rec['vers'],
                               'profil'=>$rec['profil'],
                               'terminal_status'=>$_SESSION['ARR_terminal_status'][$rec['status']],
                               'devices_status'=>array('video'=>$rec['video'],
                                                       'tonometer'=>$rec['tonometer'],
                                                       'thermometer'=>$rec['thermometer'],
                                                       'alcotester'=>$rec['alcotester'],
                                                       'pupilometer'=>$rec['pupilometer']
                               )

                              )  ;
                    if ($rec['devices']) $node['devices']=unserialize($rec['devices']) ;
                    $node['db_id']=$id ;
                    break ;   // Медицинский терминал
        case 205:  $node=array('item'=>'arm','db_id'=>$id,'name'=>$rec['obj_name'],'IP'=>$rec['ip'])  ; break ;   // АРМ
        case 206:  $node=array('item'=>'workgroup','db_id'=>$id,'name'=>$rec['obj_name'])  ; break ;   // рабочая группа
        //case 210:  $node=array('id'=>$id,'name'=>$rec['obj_name'])  ; break ; // аккаунт
      }

      //echo '_sizeof($child_ids)='._sizeof($child_ids).'<br>' ;
      if (_sizeof($child_ids)) foreach($child_ids as $child_id=>$child_ids2) $this->full_level_info($child_id,$child_ids2,$recs_db,$node) ;

      switch($rec['clss'])
      { case 1:    $data[$id]=$node ; break ;   // рабочая группа
        case 203:  $data[$id]=$node  ; break ;  // Медицинский терминал
        case 205:  $data[$id]=$node  ; break ;        // АРМ
        case 206:  $data[$id]=$node  ; break ;  // рабочая группа
        //case 210:  $data['arm'][$id]=$node  ; break ;
      }

  }

  function prepare_result()
  {
      $data=array() ;

      $recs_db=execSQL('select * from obj_site_account where clss not in (210) order by parent,obj_name') ;
      $recs_db2=$recs_db ;
      convert_list_to_tree($recs_db2,$arr_tree) ;   //damp_array($arr_tree) ;
      //$data['groups']=array() ;
      if (_sizeof($arr_tree)) foreach($arr_tree as $id=>$child_ids) $this->full_level_info($id,$child_ids,$recs_db,$data) ;
      //damp_array($data,1,-1) ;

      //$arr_groups=execSQL('select pkey,parent,obj_name from obj_site_account where clss in (1,206) and parent=0',2) ;




      return($data) ;
  }


  function view_as_HTML($options=array())
  {
      $result=$this->prepare_result() ;
      damp_array($result,1,-1) ;
      ?><link rel="stylesheet" type="text/css" href="/class_v.201809111628.work/style.css" charset="utf-8"><?
  }

  function view_as_JSON($options=array())
  { header('Content-Type: application/json');
    //header('Content-Disposition: attachment;filename="esmo_config.json"');
    //header('Cache-Control: max-age=0');
    $result=$this->prepare_result() ;
    $text_json_out=json_encode($result) ;
    echo $text_json_out ;
  }

  function print_template_XML($list_recs,$options=array())
           { //damp_array($list_recs) ;
             //print_r($list_recs) ; trace() ;
             if (_sizeof($list_recs)) foreach($list_recs as $rec)
             {   $item=add_element($this->xml_doc,$this->xml,'item','',array('id'=>$rec['pkey'])) ;
                 add_element($this->xml_doc,$item,'fio',$rec['member_name']) ;
                 add_element($this->xml_doc,$item,'dr',$rec['member_dr']) ;
                 add_element($this->xml_doc,$item,'time_MO',$rec['_data']) ;
                 add_element($this->xml_doc,$item,'time_dopusk_end',$rec['_data_dopusk_end']) ;
                 add_element($this->xml_doc,$item,'mo_id',$rec['pkey']) ;
                 add_element($this->xml_doc,$item,'doctor_comment',$rec['doctor_comment']) ;
                 add_element($this->xml_doc,$item,'mo_result_id',$rec['status']) ;
                 add_element($this->xml_doc,$item,'mo_result_text',$rec['_status_name']) ;
                 add_element($this->xml_doc,$item,'mo_dopusk_id',$rec['dopusk']) ;
                 add_element($this->xml_doc,$item,'mo_dopusk_text',$rec['_dopusk_name_full']) ;
                 add_element($this->xml_doc,$item,'time_now',date('d.m.Y H:i:s')) ;
                 add_element($this->xml_doc,$item,'terminal_name',$rec['terminal_name']) ;
                 add_element($this->xml_doc,$item,'question',$rec['_question']) ;
                 add_element($this->xml_doc,$item,'alko',$rec['_alko']) ;
                 add_element($this->xml_doc,$item,'systolic',$rec['_systolic']) ;
                 add_element($this->xml_doc,$item,'diastolic',$rec['_diastolic']) ;
                 add_element($this->xml_doc,$item,'pulse',$rec['_pulse']) ;
                 add_element($this->xml_doc,$item,'temperature',$rec['temperature']) ;
                 add_element($this->xml_doc,$item,'tk',$rec['tk']+1) ;
             }
           }


  function view_as_XML($options=array())
    { $imp = new DOMImplementation; // Creates an instance of the DOMImplementation class
      $this->xml_doc = $imp->createDocument("",""); // Creates a DOMDocument instance
      $this->xml_doc->encoding = 'utf-8';
      $this->xml_doc->formatOutput = true;
      $this->xml = add_element($this->xml_doc,$this->xml_doc,'xml_doc','',array('date'=>date('Y-m-d H:i'))) ;

      $this->add_server($this->xml) ;
      $this->add_esmo($this->xml) ;
      $this->add_timezone($this->xml) ;
      $this->add_workgroups($this->xml) ;
      if ($GLOBALS['_SETTING']['modules']['skd']) $this->add_skd($this->xml) ;

      header("Content-type: text/xml;charset=UTF-8") ;
      if (!$_GET['debug']) header('Content-Disposition: attachment;filename="esmo_config.xml"');
      if (!$_GET['debug']) header('Cache-Control: max-age=0');
      echo $this->xml_doc->saveXML() ;
    }

    function add_esmo($xml_node)
    {  $esmo_item=add_element($this->xml_doc,$xml_node,'ESMOsoftware','') ;
       if (_sizeof($GLOBALS['_SETTING']['dist'])) foreach($GLOBALS['_SETTING']['dist']  as $title=>$value) add_element($this->xml_doc,$esmo_item,$title,$value) ;
       if (_sizeof($GLOBALS['_SETTING']['modules'])) foreach($GLOBALS['_SETTING']['modules']  as $modul=>$enabled) if ($enabled) add_element($this->xml_doc,$esmo_item,'modul',$modul) ;
       if (_sizeof($GLOBALS['_SETTING']['modules_local'])) foreach($GLOBALS['_SETTING']['modules_local']  as $modul=>$enabled) if ($enabled) add_element($this->xml_doc,$esmo_item,'modul',$modul) ;
       if (_sizeof($GLOBALS['_SETTING']['plugins'])) foreach($GLOBALS['_SETTING']['plugins']  as $plugins=>$enabled) if ($enabled) add_element($this->xml_doc,$esmo_item,'plugins',$plugins) ;
       if (_sizeof($GLOBALS['_SETTING']['plugins_local'])) foreach($GLOBALS['_SETTING']['plugins_local']  as $plugins=>$enabled) if ($enabled) add_element($this->xml_doc,$esmo_item,'plugins',$plugins) ;
    }

    function add_timezone($xml_node)
    {
        add_element($this->xml_doc,$xml_node,'timezone',date_default_timezone_get()) ;
    }

    function add_server($xml_node)
    {
        $attr=array('name'=>$_SERVER['SERVER_NAME'],
                    'IP'=>$_SERVER['SERVER_ADDR'],
                    'port'=>$_SERVER['SERVER_PORT'],
                    'host_root'=>$_SERVER['DOCUMENT_ROOT'],
                    ) ;

        $disk_info=ENGINE()->server_get_disk_free_info() ;
        $processor_info=ENGINE()->server_get_processor_info() ;
        $memory_info=ENGINE()->server_get_memory_info() ;
        $LAMP_info=ENGINE()->server_get_LAMP_info() ;

        $server_item=add_element($this->xml_doc,$xml_node,'server','',$attr) ;
        $soft_item=add_element($this->xml_doc,$server_item,'soft') ;
        add_element($this->xml_doc,$soft_item,'os',ENGINE()->server_get_OS_info()) ;
        add_element($this->xml_doc,$soft_item,'server',$LAMP_info['server']) ;
        add_element($this->xml_doc,$soft_item,'php',$LAMP_info['php']) ;
        add_element($this->xml_doc,$soft_item,'db',$LAMP_info['db']) ;
        add_element($this->xml_doc,$server_item,'processor','',array('count'=>$processor_info['processor'],'model'=>$processor_info['model name'])) ;
        $memory_item=add_element($this->xml_doc,$server_item,'memory','') ;
        add_element($this->xml_doc,$memory_item,'MemTotal',$memory_info['MemTotal']) ;
        add_element($this->xml_doc,$memory_item,'MemFree',$memory_info['MemFree']) ;
        $disk_item=add_element($this->xml_doc,$server_item,'disk','') ;
        if (_sizeof($disk_info)) foreach($disk_info as $item)  add_element($this->xml_doc,$disk_item,'volume','',$item) ;
    }

    function add_skd($xml_node)
    { $recs_db=execSQL('select * from obj_site_skd order by parent,obj_name') ;
      $recs_db2=$recs_db ;
      convert_list_to_tree($recs_db2,$arr_tree) ;
      if (_sizeof($arr_tree)) foreach($arr_tree as $id=>$child_ids) $this->add_zone_item($id,$child_ids,$recs_db,$xml_node) ;
    }

    function add_workgroups($xml_node)
    { $recs_db=execSQL('select * from obj_site_account where clss not in (210) order by parent,obj_name') ;
      $recs_db2=$recs_db ;
      convert_list_to_tree($recs_db2,$arr_tree) ;
      if (_sizeof($arr_tree)) foreach($arr_tree as $id=>$child_ids) $this->add_workgroup_item($id,$child_ids,$recs_db,$xml_node) ;
    }
    function add_workgroups_ELMA($xml_node)
    { $recs_db=execSQL('select * from obj_site_account where clss not in (210) order by parent,obj_name') ;

      $list_groups=TREE('obj_site_account')->get_list_strukture('clss in (1,206)',function($rec){return($rec['obj_name']);},0) ;
      if (_sizeof($list_groups)) foreach($list_groups as $id=>$name)$recs_db[$id]['obj_name']=$name ;

      $arr_parents=group_by_field('parent',$recs_db,'pkey') ;

      if (_sizeof($list_groups)) foreach($list_groups as $id=>$name)
      {   $child_ids=array()  ;
          if (_sizeof($arr_parents[$id])) foreach($arr_parents[$id] as $rec_child) $child_ids[$rec_child['pkey']]=array() ;
          $this->add_workgroup_item($id,$child_ids,$recs_db,$xml_node,'workgroup_ELMA') ;
      }
    }


   function add_workgroup_item($id,&$child_ids,&$recs_db,$xml_node,$workgroup_tag_name='workgroup')
   {   //trace() ;
       $item=null ;
       $rec=$recs_db[$id] ;
       switch($rec['clss'])
       { // рабочая группа
         case 1:
         case 206:  $setting=($rec['settings'])? unserialize($rec['settings']):array() ;
                    $timezone=($setting['timezone'])? $setting['timezone']:_DEFAULT_TIMEZONE ;
                    $item=add_element($this->xml_doc,$xml_node,$workgroup_tag_name,'',array('name'=>$rec['obj_name'],'timezone'=>$timezone,'db_id'=>$id) ) ;
                    break ;
         // Медицинский терминал
         case 203:  $attr=array('terminal_id'=>$rec['id'],
                                'terminal_type'=>$rec['terminal_type'],
                                'name'=>$rec['obj_name'],
                                'IP'=>$rec['ip'],
                                'virtual'=>($rec['virt'])? 1:0,
                                'version'=>$rec['vers'],
                                'db_id'=>$id,
                                'workgroup_id'=>$rec['parent']
                                )  ;
                    $item=add_element($this->xml_doc,$xml_node,'terminal','',$attr) ;
                    add_element($this->xml_doc,$item,'profil',_IL('IL_term_prof')->recs[$rec['profil']]['obj_name'],array('id'=>$rec['profil'])) ;

                    $item_status=add_element($this->xml_doc,$item,'devices_status','') ;
                    add_element($this->xml_doc,$item_status,'video',$rec['video']) ;
                    add_element($this->xml_doc,$item_status,'tonometer',$rec['tonometer']) ;
                    add_element($this->xml_doc,$item_status,'thermometer',$rec['thermometer']) ;
                    add_element($this->xml_doc,$item_status,'alcotester',$rec['alcotester']) ;
                    add_element($this->xml_doc,$item_status,'pupilometer',$rec['pupilometer']) ;
                    if ($rec['devices'])
                    { $devices=unserialize($rec['devices']) ;
                      if (_sizeof($devices))
                      { $item_devices=add_element($this->xml_doc,$item,'devices','') ;
                        foreach($devices as $dev_code=>$rec_dev) add_element($this->xml_doc,$item_devices,$dev_code,'',$rec_dev) ;
                      }
                    }
                    if ($rec['ext_info'])
                    { $ext_info=unserialize($rec['ext_info']) ;
                      if ($ext_info['alcotester_calibration']) add_element($this->xml_doc,$item,'alcotester_calibration',1) ;
                    }

                    break ;
         // АРМ
         case 205:  $item=add_element($this->xml_doc,$xml_node,'arm','',array('name'=>$rec['obj_name'],'IP'=>$rec['ip'],'db_id'=>$id) ) ;
                    break ;
       }
       if ($item and _sizeof($child_ids)) foreach($child_ids as $child_id=>$child_ids2) $this->add_workgroup_item($child_id,$child_ids2,$recs_db,$item,$workgroup_tag_name) ;

   }

   function add_zone_item($id,&$child_ids,&$recs_db,$xml_node)
   {   $item=null ;
       $rec=$recs_db[$id] ;

       switch($rec['clss'])
       { // рабочая группа
         case 1:
         case 600:  $item=add_element($this->xml_doc,$xml_node,'zone','',array('name'=>$rec['obj_name'],'db_id'=>$id) ) ;
                    $recs_device=execSQL('select * from obj_site_device where zone_id='.$rec['pkey']) ;
                    if (_sizeof($recs_device)) foreach($recs_device as $rec_dev) switch($rec_dev['clss'])
                    { // Терминал контроля трезвости
                      case 241:  $attr=array('terminal_id'=>$rec_dev['id'],
                                            'terminal_type'=>$rec_dev['terminal_type'],
                                            'name'=>$rec_dev['obj_name'],
                                            'IP'=>$rec_dev['ip'],
                                            'virtual'=>($rec_dev['virt'])? 1:0,
                                            'version'=>$rec_dev['vers'],
                                            'db_id'=>$id,
                                            'zone_id'=>$rec_dev['zone_id']
                                            )  ;
                                $terminal_item=add_element($this->xml_doc,$item,'terminal','',$attr) ;
                                $item_status=add_element($this->xml_doc,$terminal_item,'devices_status','') ;
                                add_element($this->xml_doc,$item_status,'video',$rec_dev['video']) ;
                                add_element($this->xml_doc,$item_status,'alcotester',$rec_dev['alcotester']) ;
                                if ($rec_dev['devices'])
                                { $devices=unserialize($rec_dev['devices']) ;
                                  if (_sizeof($devices['devices']))
                                  { $item_devices=add_element($this->xml_doc,$terminal_item,'devices','') ;
                                    foreach($devices['devices'] as $dev_code=>$rec_dev) add_element($this->xml_doc,$item_devices,$dev_code,'',$rec_dev) ;
                                  }
                                }
                                if ($rec_dev['ext_info'])
                                { $ext_info=unserialize($rec_dev['ext_info']) ;
                                  if ($ext_info['alcotester_calibration']) add_element($this->xml_doc,$terminal_item,'alcotester_calibration',1) ;
                                }

                                break ;

                    }


                    break ;

         // АРМ
         case 205:  $item=add_element($this->xml_doc,$xml_node,'arm','',array('name'=>$rec['obj_name'],'IP'=>$rec['ip'],'db_id'=>$id) ) ;
                    break ;
       }
       if ($item and _sizeof($child_ids)) foreach($child_ids as $child_id=>$child_ids2) $this->add_zone_item($child_id,$child_ids2,$recs_db,$item) ;

   }



}

?>
