
// сохранение параметров текщего сертификата в аккаунте
function ESMO_save_cur_certificate_params(cert_uid,ajax_params)
{
    var canAsync = !!cadesplugin.CreateObjectAsync;
    if (canAsync) {include_async_code().then(function (){return ESMO_save_cur_certificate_params_Async(cert_uid,ajax_params);});}
}

// сделано на основе функции /AddOns/cryptopro/js_2.1.0/async_code.js  SignCadesBES_Async_File
function ESMO_save_cur_certificate_params_Async(cert_uid,ajax_params)
{
    cadesplugin.async_spawn(function*(arg)
    {

          cert_uid=arg[0];
          console.log('cert_uid: '+cert_uid) ;
          var thumbprint = cert_uid.split(" ").reverse().join("").replace(/\s/g, "").toUpperCase();

          try
          {     var oStore = yield cadesplugin.CreateObjectAsync("CAdESCOM.Store");
                if (!oStore) { alert("store failed");
                               return;
                             }
                yield oStore.Open();
          }
          catch (ex)
          {
               alert("Ошибка при открытии хранилища: " + cadesplugin.getLastError(ex));
               return;
          }

          var certCnt;
          var certs;

          try {   certs = yield oStore.Certificates;
                  certCnt = yield certs.Count;
              }
          catch (ex)
              {
                   var errormes = document.getElementById("boxdiv").style.display = '';
                   return;
               }

          if(certCnt == 0)
          {
               var errormes = document.getElementById("boxdiv").style.display = '';
               return;
          }

           var all_certs = yield oStore.Certificates;
           var oCerts = yield all_certs.Find(cadesplugin.CAPICOM_CERTIFICATE_FIND_SHA1_HASH, thumbprint);
           console.log(oCerts);
           if (oCerts.Count == 0)
           { alert("Certificate not found");
             return;
           }
           certificate = yield oCerts.Item(1);
           console.log(certificate);

        var params=arg[1] ;
        params.cert={} ;
        var Adjust = new CertificateAdjuster();
        var pubKey = yield certificate.PublicKey();
        var algo = yield pubKey.Algorithm;
        var fAlgoName = yield algo.FriendlyName;
        var oPrivateKey = yield certificate.PrivateKey;
        var sProviderName = yield oPrivateKey.ProviderName;
        var Validator = yield certificate.IsValid();

        params.cert.sert_id=yield certificate.SerialNumber ;
        params.cert.SerialNumber=yield certificate.SerialNumber ;
        params.cert.Thumbprint=yield certificate.Thumbprint ;
        params.cert.SubjectName=yield certificate.SubjectName ;
        params.cert.IssuerName=Adjust.GetIssuer(yield certificate.IssuerName) ;
        params.cert.ValidFromDate=Adjust.GetCertDate(yield certificate.ValidFromDate);
        params.cert.ValidToDate=Adjust.GetCertDate(yield certificate.ValidToDate);
        params.cert.version=yield certificate.Version;
        params.cert.algorithm=fAlgoName;
        params.cert.provname=sProviderName;
        params.cert.IsValid=yield Validator.Result;;
        params.cert.HasPrivateKey=yield certificate.HasPrivateKey() ;

        console.log(params.cert) ;

        yield oStore.Close();
        send_ajax_request(params) ;
        $j('button#exec_sign').attr('cert_id',params.cert.Thumbprint) ;
        $j('button#exec_sign').show() ;

    }, cert_uid,ajax_params); //cadesplugin.async_spawn
}
