<?php
include_once(_DIR_TO_MODULES.'/engine/i_backgroup_process.php') ;
class i_mo_import extends i_backgroup_process_exec
{
    function import_temp_table_into_db($file)
    {
        $result=array();
        if ($file) {
            //проверяем наличие группы и критерия "Автономные МО"
            $criterion = AUTONOMOUS_TERMINALS()->rules_create();
            //если все ок - пишем медосмотры
            $result['relation_count'] = 0; //считаем количество обработанных строк
            $result['relation_adding'] = 0; //считаем количество добавленных строк
            foreach ($file as $rec) {
                //если сотрудник не найден, создаем нового loading_mo_from_file => true
                $rec_personal = PERSONAL()->get_personal_by_propusk($rec['user'], ['loading_mo_from_file' => true]);
                $result['comment'][] = 'Найден сотрудник '.$rec_personal['obj_name'];

                $mo = AUTONOMOUS_TERMINALS()->search_mo($rec);
                if ($mo) {
                    if ($rec['terminal_type'] == 'kt') $mo_id = $this->save_result_kt($rec); //контроль трезвости
                    else $mo_id = $this->save_result_mt($rec, $criterion); //медицинский терминал
                    $result['relation_adding']++;
                    $result['comment'][] = 'Результат медосмотра №'.$mo_id.' сохранен';
                } else $result['comment'][] = 'Медосмотр уже существует';
                $result['relation_count']++;
            }
            $result['comment'][] = 'Импорт данных завершен';
        }
        return $result;
    }

    function save_result_kt($rec)
    {
        include_once(_DIR_EXT.'/kt/c_server_kt.php');
        $server_kt = new c_page_server_kt();
        $server_kt->autonom_mo = 1;
        $data = array();
        $data['args']['id']['terminal'] = $rec['terminal_id'];
        $data['args']['id']['user'] = $rec['user'];
        $data['args']['photo']['auth'] = $rec['photo_auth'];
        $data['args']['exam_type'] = (int)$rec['exam_type'];
        $server_kt->exec_operation('check_access',$data);
        $mo_id = $server_kt->mo_id;
        $data['args']['id']['medexam'] = $mo_id;
        $data['args']['data']['alcotester'] = $rec['alcotester'];
        $data['args']['data']['alcotester_value'] = $rec['alcotester_value'];
        $data['args']['data']['reason'] = $rec['reason'];
        $data['args']['data']['equipment'] = $rec['equipment'];
        $data['args']['photo']['alco'] = $rec['photo_alco'];
        $data['args']['message'] = $rec['message'];
        $data['args']['data']['signature'] = $rec['signature'];
        $server_kt->exec_operation('examination_result',$data);

        // сохраняем данные измерений в запись МО
        $date = date_create($rec['date']);
        $datetime_mo = date_timestamp_get($date);

        $_dopusk_time_S=(float)$GLOBALS['LS_setting_auto_kt_allow_interval']*60 ; // срок действия меддопуска в секундах
        $_nedopusk_time_S=(float)$GLOBALS['LS_setting_auto_kt_denited_interval']*60; // срок действия меддопуска в секундах
        $time_dopusk_S=($data['args']['message'] == "success")?  $_dopusk_time_S:$_nedopusk_time_S ;

        $dopusk_time=$datetime_mo+$time_dopusk_S ;

        $data_mo=array(
            'e_data'=>$datetime_mo,
            'c_data'=>$datetime_mo,
            'r_data'=>$datetime_mo,
            'message_terminal'=>$rec['message'],
            'dopusk_time'=>$datetime_mo,
            'dopusk_time_end'=>$dopusk_time
        );
        KT()->update_mo_session($mo_id,$data_mo) ;

        return $mo_id;
    }

    function save_result_mt($rec,$criterion)
    {
        include_once(_DIR_EXT.'/aspmo_server/c_server.php');
        $server_mo = new c_page_server();
        $server_mo->autonom_mo = 1;
        $data=array();
        $data['args']['id']['terminal'] = $rec['terminal_id'];
        $data['args']['id']['user'] = $rec['user'];
        $data['args']['photo']['auth'] = $rec['photo_auth'];
        $server_mo->check_access($data);

        $mo_id = $server_mo->session_id;
        $data['args']['terminal_type'] = $rec['terminal_type'];
        $data['args']['id']['medexam'] = $mo_id;
        $data['args']['data']['thermometer'] = $rec['thermometer'];
        $data['args']['data']['alcotester_value'] = $rec['alcotester_value'];
        $data['args']['data']['tonometer_systolic'] = $rec['tonometer_systolic'];
        $data['args']['data']['tonometer_diastolic'] = $rec['tonometer_diastolic'];
        $data['args']['data']['pulse'] = $rec['pulse'];
        $data['args']['data']['alcotester'] = $rec['alcotester'];
        $data['args']['data']['question'] = $rec['question'];
        $data['args']['data']['reason'] = $rec['reason'];
        $data['args']['data']['equipment'] = $rec['equipment'];
        $data['args']['photo']['alco'] = $rec['photo_alco'];
        $data['args']['data']['question'] = $rec['question'];
        if ($rec['video']) $data['args']['photo']['video'] = $rec['video'];
        if ($rec['exam_type']) $data['args']['exam_type'] = $rec['exam_type'];
        if ($rec['schulte_time']) $data['args']['data']['schulte_time'] = $rec['schulte_time'];
        if ($rec['schulte_errors']) $data['args']['data']['schulte_errors'] = $rec['schulte_errors'];
        if ($rec['pp_code']) $data['esmo_out']['pp_code'] = $rec['pp_code'];
        if ($rec['result_check_narko']) $data['esmo_out']['result_check_narko'] = $rec['result_check_narko'];
        if ($rec['schulte_time']) $data['args']['data']['schulte_time'] = $rec['schulte_time'];
        if ($rec['schulte_errors']) $data['args']['data']['schulte_errors'] = $rec['schulte_errors'];
        $data['args']['message'] = $rec['message'];
        $data['args']['data']['signature'] = $rec['signature'];
        $data['args']['exam_type'] = (int)$rec['exam_type']+1; //почему то потом считывается $data['args']['exam_type']-1
        $server_mo->examination_result($data);

        // сохраняем данные измерений в запись МО
        $date = date_create($rec['date']);
        $datetime_mo = date_timestamp_get($date);

        $_dopusk_time_S=(float)$GLOBALS['LS_setting_auto_mo_allow_interval']*60 ; // срок действия меддопуска в секундах
        $_nedopusk_time_S=(float)$GLOBALS['LS_setting_auto_mo_denited_interval']*60; // срок действия меддопуска в секундах
        $time_dopusk_S=($data['args']['message'] == "success")?  $_dopusk_time_S:$_nedopusk_time_S ;

        $dopusk_time=$datetime_mo+$time_dopusk_S ;

        $data_mo=array(
            'e_data'=>$datetime_mo,
            'c_data'=>$datetime_mo,
            'r_data'=>$datetime_mo,
            'message_terminal'=>$rec['message'],
            'dopusk_time'=>$datetime_mo,
            'dopusk_time_end'=>$dopusk_time
        );
        ESMO()->update_mo_session($mo_id,$data_mo) ;

        return $mo_id;
    }

    function show()
    { // для красивого вывода стилей
        ob_start() ;

        $result=$this->exec() ;

        $text=ob_get_clean() ;
        /// далее в вывод не должно выходить ничего лишнего!!!
        ob_start() ;
        file_put_contents(_DIR_TO_ROOT.$this->page_output,$text) ;
        $text2=ob_get_clean() ;
        if ($this->view_result_as_html) $this->show_result_as_html($result) ;
        else echo $text ;
        FILE_LOG()->append('END') ;
    }
}
