<?php
include_once(_DIR_EXT.'/HTML/c_page_TXT.php') ;
class c_page_cab_setting_terminal_update_upload extends c_page_TXT {
    function body() {
        if (count($_FILES) === 0 || !isset($_FILES['file'])) {
            return $this->errorResponse('Не удалось загрузить файл. Проверьте настройки максимального размера файла');
        }

        $filenameRe = '/^esmo\-(\d+\.\d+\.\d+([A-Za-z0-9]+)?)\-([A-Za-z0-9]+)?\-?installer$/';
        $file = $_FILES['file'];

        if (!preg_match($filenameRe, $file['name'])) {
            return $this->errorResponse('Загруженный файл не содержит обновления для терминала');
        }
        if (!$this->checkSignature($file['tmp_name'])) {
            return $this->errorResponse('Ошибка проверки цифровой подписи файла обновления');
        }

        if (!move_uploaded_file($file['tmp_name'], _DIR_TO_ROOT.'/updates/'.$file['name'])) {
            return $this->errorResponse('Не удалось сохранить файл обновления. Проверьте права на запись в каталог обновлений');
        }

        return $this->successResponse();
    }

    function successResponse() {
        $_SESSION['upload_success'] = true;
        echo json_encode([
            'message' => 'success',
        ], JSON_UNESCAPED_UNICODE);
    }

    function errorResponse($message) {
        $_SESSION['upload_success'] = false;
        $_SESSION['upload_error'] = $message;

        echo json_encode([
            'message' => 'failure',
            'reason' => $message,
            'files' => $_FILES,
        ], JSON_UNESCAPED_UNICODE);
    }

    function checkSignature($filename) {
        return true;
    }
}
