<?php
// сервис загружает файл-архив с обновлением на сервер в фоновом режиме.
// После загрузки вызывается модальное окно с фоновым процессом на сервис c_services_aspmo_setting_upload_zip.php
include_once(_DIR_EXT . '/HTML/c_page_JSON.php');
class c_services_aspmo_setting_upload_update_locals extends c_page_JSON
{
    function show()
    {
        $res = array();
        ob_start();
        if (_sizeof($_FILES)) $res = $this->upload_zip();
        $res['report'] = ob_get_clean();
        $this->output_JSON($res);
    }

    function upload_zip()
    {
        $result = array();
        if (_sizeof($_FILES))
        {
            foreach ($_FILES as $file_info)
            { ?><strong>Загружаем файл "<? echo $file_info['name'] ?>"</strong><br><?
                $fname = safe_file_names($file_info['name']);
                $target_fname = _DIR_TO_ROOT . '/updates/' . $fname;
                if (!is_dir(_DIR_TO_ROOT . '/updates/')) mkdir(_DIR_TO_ROOT . '/updates/');
                if (!is_dir(_DIR_TO_ROOT . '/updates/')) echo 'Не удалось создать временный каталог для распаковки архива. Проверьте права на ' . _DIR_TO_ROOT;

                if (is_uploaded_file($file_info['tmp_name']))
                {  if (stripos($file_info['name'], 'json') !== false)
                  {  if (move_uploaded_file($file_info['tmp_name'], $target_fname))
                     {
                        echo '<div class="green">Файл успешно сохранен в <strong>'.hide_server_dir($target_fname).'</strong></div>';
                        $result['file_name'][] = $fname;

                        echo 'Переносим загрузженный файл локализации в библиотеку:<br>' ;
                        $arr=explode('.',basename($target_fname)) ;
                        $arr2=explode('_',$arr[0]) ;
                        $lang_code=$arr2[1] ;
                        $result['lang_code'] = $lang_code;
                        //damp_array($arr);
                        //$coll_name=$arr[0].'_upload_'.date('d_m_Y_H_i_s').'.'.$arr[1] ;
                        rename($target_fname,_DIR_EXT.'/locals/collections/'.basename($target_fname)) ;
                        echo 'Активируем новый файл локализации:<br>' ;
                    }
                     else
                     { echo '<div class="red">Не удалось сохранить загруженный файл в ' . hide_server_dir($target_fname) . '</div>';
                       damp_array($file_info, 1, -1);
                       echo 'Права на директорию <strong>/updates/</strong>: <span style="font-size:22px;">' . $this->show_perms_info(fileperms(_DIR_TO_ROOT . '/updates/')) . '</span>';
                       $result['status'] = 'error';
                     }
                   }
                   else
                   {   echo '<div class="red">Загруженный файл не является файлом экпорта локализации: ' . $file_info['name'] . '</div>';
                       damp_array($file_info, 1, -1);
                       $result['status'] = 'error';
                   }
                }
                else
                {
                    echo '<div class="red">Не удалось получить файл из временного хранилища ' . $file_info['tmp_name'] . '</div>';
                    damp_array($file_info, 1, -1);
                    $result['status'] = 'error';
                }

            }


        }
        $result['status'] = 'ok';
        return ($result);
    }



function show_perms_info($perms)
{
    switch ($perms & 0xF000) {
        case 0xC000: // сокет
            $info = 's';
            break;
        case 0xA000: // символическая ссылка
            $info = 'l';
            break;
        case 0x8000: // обычный
            $info = 'r';
            break;
        case 0x6000: // файл блочного устройства
            $info = 'b';
            break;
        case 0x4000: // каталог
            $info = 'd';
            break;
        case 0x2000: // файл символьного устройства
            $info = 'c';
            break;
        case 0x1000: // FIFO канал
            $info = 'p';
            break;
        default: // неизвестный
            $info = 'u';
    }

    // Владелец
    $info .= (($perms & 0x0100) ? 'r' : '-');
    $info .= (($perms & 0x0080) ? 'w' : '-');
    $info .= (($perms & 0x0040) ?
        (($perms & 0x0800) ? 's' : 'x') :
        (($perms & 0x0800) ? 'S' : '-'));

    // Группа
    $info .= (($perms & 0x0020) ? 'r' : '-');
    $info .= (($perms & 0x0010) ? 'w' : '-');
    $info .= (($perms & 0x0008) ?
        (($perms & 0x0400) ? 's' : 'x') :
        (($perms & 0x0400) ? 'S' : '-'));

    // Мир
    $info .= (($perms & 0x0004) ? 'r' : '-');
    $info .= (($perms & 0x0002) ? 'w' : '-');
    $info .= (($perms & 0x0001) ?
        (($perms & 0x0200) ? 't' : 'x') :
        (($perms & 0x0200) ? 'T' : '-'));

    return $info;

}


}
