<?php
class c_services_server
{ public $terminal_id ;
  public $personal_id ;
  public $session_id ;
  public $seans_id ;
  public $mo_reffer ;
  public $rec_terminal ;
  public $is_log_request=1 ;
  public $JSON_source='' ;
  public $result_stream='output' ;
  public $data_in=array() ;
  public $data_out=array() ;
  public $operation=array() ;
  public $reason='' ;
  public $request_UID='' ;
  public $log_fname='trace' ;

  // прием команды от терминала
  function __construct($options=array())
  { set_time_point('start SERVER') ;  //return ;
    $this->ft=time() ;
    $this->operation=($options['operation'])? $options['operation']:$_GET['operation'] ;

  	if ($options['data_in']) $this->data_in=$options['data_in'] ;
  	else
  	{ // приходит команда "pupilometer_video" - сохраняем видео с ПП во временный файл и формируем искуственную структуру data_in
  	  if ($this->operation=='pupilometer_video')
      {  	 $fname='pp_video_'.$_POST['medexam'].'.mp4' ;
		 $cnt=move_uploaded_file($_FILES['video']['tmp_name'],_TEMP_DIR.'/'.$fname) ;
		 $this->data_in=array('pp_video_fname'=>$fname,'size_in'=>$_FILES['video']['size'],'size_save'=>$cnt,'medexam'=>$_POST['medexam']) ;
      }
  	  // иначе стандартная операция получения data_in из входного потока
      else
      { set_time_point('get INPUT') ;
        $this->JSON_source = file_get_contents("php://input");
	  $this->data_in=$this->load_json_utf8($this->JSON_source) ;
	  set_time_point('load_json_utf8') ;
      }
    }


  	$this->request_UID=ENGINE()->generate_UID() ;

  }

   function init($options=array())
   {
     $this->on_send_header_before() ;
   }

   function on_send_header_before()
   {
      header("Content-type: text/html;charset=UTF-8");
   }

    // стандартная функция для вызова страницы
  function show(&$options=array())
  { $this->body($options) ;
  }

  function body(&$options=array())
  { $GLOBALS['stack_sql_stats']=1 ;
    $t1=fixed_time()  ;$size2=0 ;

    //mysqli_query($GLOBALS['DB_LINK'],"SET AUTOCOMMIT=0");
    //mysqli_query($GLOBALS['DB_LINK'],"START TRANSACTION");

    ob_start() ;
    $size1=strlen($this->JSON_source) ;
    if (is_array($this->data_in) and _sizeof($this->data_in))
    {  LOG_JSON('mo_session')->reg('Обращение к серверу с терминала',$this->operation,array('data'=>$this->data_in)) ;
       // вызываем обработчик события получания команды сервером
       ENGINE()->on_event_by_pointer('server_operation_exec',$this->operation,$this->data_in,$this->data_out) ;
       // если $this->data_out пустой - работаем по стандартной схеме
       if (!_sizeof($this->data_out)) switch($this->operation)
        { case 'power_on':            if ($this->data_in['args']['terminal_type']!='pp') $this->data_out=$this->power_on($this->data_in) ;
                                      else $this->data_out=$this->power_on_printpost($this->data_in) ; break ;
          case 'whois':               $this->data_out=$this->whois($this->data_in) ; break ;
          case 'check_access':        if ($this->data_in['args']['terminal_type']!='pp') $this->data_out=$this->check_access($this->data_in) ;
                                      else $this->data_out=$this->check_access_printpost($this->data_in) ; break ;
          case 'examination_result':  $this->data_out=$this->examination_result($this->data_in) ; break ;
          case 'send_data':           $this->data_out=$this->HR_send_data($this->data_in) ; break ;
          case 'check_update':        $this->data_out=$this->check_update($this->data_in) ; break ;
          // команды для виртуального терминала
          case 'check_status':        $this->data_out=$this->virt_term_check_status($this->data_in) ; break ;
          case 'pupilometer_video':   $this->data_out=$this->pupilometer_video($this->data_in) ; break ;
        }
      LOG_JSON('mo_session')->reg('Ответ сервера',$this->operation,array('data'=>$this->data_out)) ;
      set_time_point('operation EXEC')  ;
    }
    else if ($this->operation=='ping') { $this->data_out=array() ; $this->is_log_request=0 ; }
    else $this->data_out['error']='not_valid_JSON_scructure' ;

    // удаляем служебное поле для обмена
	unset($this->data_out['esmo_out']) ;

    if ($GLOBALS['LS_debug_mode'] and $this->JSON_source!="")
    { if ($this->session_id) LOGS()->reg_file_log($this->operation.'_'.$this->session_id.'.html',$this->JSON_source,array('no_append_time'=>1)) ;
      else              LOGS()->reg_file_log($this->operation,$this->JSON_source) ;

      //if ($this->session_id) LOGS()->reg_file_log($this->operation.'_'.$this->session_id.'_out.json',json_encode($this->data_out),array('no_append_time'=>1)) ;


    }

    // сквозная запись хода МО через несколько МО
    if ($GLOBALS['LS_mo_logging_full'])
    {  $log_fname=($this->session_id)? $this->log_fname.'_'.$this->session_id:$this->log_fname.'_'.ENGINE()->generate_UID() ;
       LOG_JSON('mo_session')->flush($log_fname,array('reg_log'=>0,'comment'=>'Запрос с терминала ['.$this->operation.']'));
       if ($this->rec_terminal['virt']) $this->data_out['args']['data']['log_fname']=$log_fname ;
    }

    $t2=fixed_time($t1) ;
    $debug=ob_get_clean() ; // весь вывод в debug и стереть, если включена опция LS_trace_term будет сохранен в логе обмена

    if (is_array($this->data_out))
    { $text_json_out=json_encode($this->data_out) ;
      $size2=strlen($text_json_out) ;
      // возвращает ответ устройству
      if ($this->result_stream=='output') echo $text_json_out ;
      ob_end_flush() ; // отправляем все данные обратно
    }


    // регистрируем запрос
    if ($this->is_log_request and $GLOBALS['LS_trace_term'])
    {	$text_json_in=(is_array($this->data_in) and _sizeof($this->data_in))? json_encode($this->data_in,JSON_UNESCAPED_UNICODE):'' ;
        $text_json_out=(is_array($this->data_out) and _sizeof($this->data_out))? json_encode($this->data_out,JSON_UNESCAPED_UNICODE):'' ;

        if ($this->data_in['date'])
         { $tt=strtotime($this->data_in['date']) ;
           $temp=$this->ft-$tt ;
         }

        LOGS()->log_request($_SERVER['REMOTE_ADDR'],$_SERVER['SERVER_ADDR'],$this->operation,$text_json_in,$text_json_out,array('terminal_id'=>$this->terminal_id,
                                                                                                         'personal_id'=>$this->personal_id,
                                                                                                         'mo_id'=>$this->session_id,
                                                                                                         'size1'=>$size1,
                                                                                                         'size2'=>$size2,
                                                                                                         'time_exec'=>$t2,
                                                                                                         'request_UID'=>$this->request_UID,
                                                                                                         'request_debug'=>$debug,
                                                                                                         'req_type'=>0,
                                                                                                         'temp'=>$temp,
                                                                                                         'req_url'=>$_SERVER['REQUEST_SCHEME'].'://'.$_SERVER['SERVER_ADDR'].$_SERVER['REQUEST_URI']
        )) ;
    }


    $GLOBALS['obj_info']['obj_name']=$this->rec_terminal['_group_name'].', term ID '.$this->rec_terminal['id'] ;
    //mysqli_query($GLOBALS['DB_LINK'],"COMMIT");
  }

  function load_json_utf8($content_str)
    {  $bom = chr(0xEF).chr(0xBB).chr(0xBF);
        if(substr_compare($bom, $content_str, 0, strlen($bom)) == 0) $content_str = substr($content_str, strlen($bom));
        return json_decode($content_str,true);
    }

    function ping($data)
    {
        $result=array() ;
        return($result) ;

    }


  function power_on($data)
   { ob_start() ;
     $terminal_id=$data['args']['id']['terminal'] ;
     $terminal_ip=$_SERVER['REMOTE_ADDR'] ;
     if ($data['args']['terminal_type']=='virt') $terminal_ip=$data['args']['terminal_IP'] ;  // если терминал виртуальный, его IP адрес передается принудительно
	 $this->rec_terminal=array() ;
     $_comment=array() ;  $create_result=array() ;
     if ($terminal_id!=2000) // все терминалы 2000 всегда добавляются в заблокированные терминалы
     {  //$this->rec_terminal=DEVICE()->get_terminal_by_ip($terminal_ip,array('check_reboot'=>1,'check_multipule_device'=>1)) ;
         $this->rec_terminal=DEVICE()->get_terminal_by_id($terminal_id,array('check_reboot'=>1)) ;
	     if ($this->rec_terminal['virt'])
	     {
		     $_comment[]='<div class="red">Виртуальный терминал, получение записи с базы по ID</div>' ;
		     $this->rec_terminal=DEVICE()->get_terminal_by_id($terminal_id,array('check_reboot'=>1,'debug'=>1)) ;
	     }
	     elseif (!$this->rec_terminal['pkey'])
	     {   $_comment[]='<div class="red">Терминал с IP '.$terminal_ip.' не зарегистрирован в системе</div>' ;
		     $this->rec_terminal=DEVICE()->get_terminal_by_id($terminal_id,array('check_reboot'=>1)) ;
	     }
     }
     if (!$this->rec_terminal['pkey'])
     {  $terminal_id=execSQL_value('select max(id) from obj_site_account where clss=203') ;
        if (!$terminal_id) $terminal_id=0 ;
	    $terminal_id++ ;
     	$create_result=ESMO()->terminal_create(array('group_id'=>1,'name'=>'МТ '.$terminal_id,'id'=>$terminal_id,'ip'=>$_SERVER['REMOTE_ADDR'],'enabled'=>0,'profil'=>1,'terminal_type'=>$data['args']['terminal_type'])) ;
     	//damp_array($create_result) ;

     	if ($create_result['pkey']) { $_comment[]='<div class="green">Терминал с ID '.$terminal_id.' добавлен в систему</div>' ;
	                                  $this->rec_terminal=DEVICE()->get_terminal_by_pkey($create_result['pkey'],array('debug'=>0)) ;
	                                }
     	else                        $_comment[]='<div class="red">Не удалось добавить терминал - '.$create_result['error'].'</div>' ;
     }

	 if ($this->rec_terminal['pkey'])
     { $group_setting=unserialize(execSQL_value('select settings from obj_site_account where pkey="'.$this->rec_terminal['parent'].'"')) ;
       $timezone=($group_setting['timezone'])? $group_setting['timezone']:'Europe/Moscow' ;
       date_default_timezone_set($timezone) ;
     }


     $result['date'] = date('Y-m-d H:i:s');
     $result['args']['terminal_type']=$this->rec_terminal['terminal_type'] ;
     $result['args']['id']['terminal']=$terminal_id ;
     $result['args']['message']='success' ; // только success иначе теринал будет досить сервер
     $result['args']['data']['complex']=$GLOBALS['LS_setting_system_name'] ;
     $result['args']['data']['terminal_pkey']=$this->rec_terminal['pkey'] ;
     //$result['args']['data']['terminal_rec']=$this->rec_terminal ;

     // отправляем информацию по типу терминала и входному URL
     $result['settings']['terminal']['type']=$this->rec_terminal['terminal_type'];
     $result['settings']['network']['remote_endpoint']=$this->rec_terminal['settings']['remote_endpoint'] ;
     $result['settings']['question']=($this->rec_terminal['settings']['question'])? true:false;
     $result['settings']['signature']['enabled']=($this->rec_terminal['settings']['signature'])? true:false;

     $comment=(_sizeof($_comment))? implode('',$_comment):'' ;

	 //damp_array($this->rec_terminal) ;
     if ($this->rec_terminal['pkey'] and $this->rec_terminal['id'])
     {
     	  // сохраняем все текущие данные терминала, а там модуль сам разберется что изменилось и что в итоге надо сохранять
	     $terminal_data=array(//'id'=>$terminal_id,
			                  //'ip'=>$terminal_ip,
			                  'status'=>2,
			                  'vers'=>$data['args']['id']['version'],
			                  'ext_info'=>array(),
			                  'devices'=>$data['args']['devices'],
			     ) ;

	     // дергаем обработчик события, если будет принято решение по терминалу, в result будет задано значение $result['args']['data']['active']
       ENGINE()->on_event_by_pointer('server_power_on_before_save_status',$terminal_data,$result) ;


       DEVICE()->terminal_save($this->rec_terminal['pkey'],$terminal_data,array('debug'=>2)) ;
	     DEVICE()->terminal_save_chech_status($this->rec_terminal['pkey'],$data['args']['status']) ;

       $this->rec_terminal=DEVICE()->get_terminal_by_id($this->rec_terminal['id'])  ;
       // если решения по статусу терминала еще нет - работаем стандартно
       if (!isset($result['args']['data']['active']))
       {
	     if ($this->rec_terminal['enabled'])
	     { // проверяем активность врача - в группе должен быть один текущий врач
		     $doctor_id=ESMO()->check_doctor($this->rec_terminal['parent']) ; // помещает информацию по допуску  в массив [__check]
		     if ($doctor_id)
		     { //DEVICE()->terminal_save($this->rec_terminal['pkey'],array('status'=>2)) ;    // устанавливаем состояние - готов к работе
		       // отправляем уведомление операторам
		       $xmpp_message=array() ;
		       $xmpp_message['notife']='alert' ;
		       $xmpp_message['notife_text']='Терминал '.$terminal_id.': включен' ;
		       $xmpp_message['terminal_status']=ESMO()->prepare_terminal_status_to_xmpp($this->rec_terminal['parent']) ; //  подгатавливаем массив информации по всем терминалам текущей группы

		       $xmpp_message['time']=date('d.m.y H:i:s') ; //  подгатавливаем массив информации по всем терминалам текущей группы
		       $xmpp_message['from']='c_server::power_on' ;

		       //ESMO()->send_XMPP_message_from_terminal($terminal_id,$xmpp_message) ;   // данные необходимо отправить всем АРМ текущей рабочей группы, кто имеет право получать уведомления
		       //IO()->send_async_cmd('send_xmpp_mess',array('terminal_id'=>$terminal_id,'params'=>serialize($xmpp_message))) ;
		       ESMO()->reg_monitor_mess($this->rec_terminal['parent'],$xmpp_message) ;

			   $result['args']['data']['active']=true ;

		       // оправлем терминалу команду проверить статус, асинхронно
				       //DEVICE()->device_send_async_cmd($this->rec_terminal['pkey'],'check_status',array('pause'=>2,'reffers'=>array($this->rec_terminal['_reffer']))) ;


		       //update_rec_in_table('obj_site_account',array('temp'=>0),'pkey='.$this->rec_terminal['pkey']) ;
		     }
		     else
		     {   echo '<div class="red">Не найдено ни одного активного доктора, переводим терминал в сон</div>';
			     //DEVICE()->device_send_async_cmd($this->rec_terminal['pkey'],'set_sleep',array('pause'=>5)) ;
			     $result['args']['data']['active']=false ;
		     }
	     }
	     else
	     {
		     echo '<div class="red">Терминал заблокирован</div>';
	     }
       }

     } else echo '<div class="red">В записи ЭСМО отсутствует ID терминала</div>';

     $text=ob_get_clean() ;
	 LOGS()->reg_log('Включение терминала','Терминал '.$terminal_id.' ['.$terminal_ip.']: '.$comment.'<br>'.$text,array('terminal_id'=>$terminal_id,'terminal_ip'=>$terminal_ip,'reffers'=>array($this->rec_terminal['_reffer']))) ;
	 $this->terminal_id=$terminal_id ;
     return($result) ;
   }

   function whois($data)
   {
     $number=trim($data['args']['id']['number']) ;
     $terminal_id=$data['args']['id']['terminal']  ; $this->terminal_id=$terminal_id ;

     //$rec_member=ESMO()->get_personal_by_driving_tab_number($number) ;     set_time_point('get_personal_by_driver') ;
     //include_once(_DIR_EXT.'/aspmo_client/i_client.php') ;
     //$client=new c_client() ;
     if ($data['args']['id']['debug_db']) $GLOBALS['debug_db']=$data['args']['id']['debug_db'] ;
     ob_start() ;
     //$rec_member=PERSONAL()->whois_personal($number,array('dop_usl'=>'enabled=1')) ;  $this->personal_id=$rec_member['pkey'] ;
	 $options_whois=array('only_enabled'=>1,'dop_usl'=>'enabled=1') ;
	 if ($number)
	 { if (strpos($number,'#')!==false) $rec_member=PERSONAL()->whois_personal($number,$options_whois) ; // QR код будет сгенерирован на основе ВУ и номера авто
     else                             $rec_member=PERSONAL()->get_personal(array('propusk'=>$number,'tab_number'=>$number),array('only_enabled'=>1,'set_rules'=>1,'set_QR_code'=>$GLOBALS['LS_person_field_to_qrcode'],'dop_usl'=>'enabled=1')) ;
	 }
     //$this->personal_id=$rec_member['pkey'] ;

     $result['date'] = date('Y-m-d H:i:s');
     $result['args']['terminal_type']='mt' ;
     $result['args']['id']['terminal']=$terminal_id ;
     // 09.10.2015 если по whois был передан номер авто и номер прав - отправляем в user их обратно
     // это позволит  при check_access сформировать QR код на основе номер авто и номер прав
     $result['args']['id']['user']=($rec_member['_rec_car']['pkey'])? $rec_member['_rec_car']['obj_name'].'#'.$rec_member['driving']:$rec_member['propusk'] ;
     $result['args']['message']=($rec_member['pkey'])? 'success':'failure' ;
     //$result['args']['data']['reason']=($rec_member['pkey'])? '':'Сотрудник не найден' ; ;
     $result['args']['data']['reason']=$rec_member['_reason'] ;

     $result['args']['data']['user_name']=$rec_member['obj_name'] ;
     $result['args']['data']['user_ID']=$rec_member['pkey'] ;
     $result['args']['data']['user_propusk']=$rec_member['propusk'] ;
     $result['args']['data']['user_tab_number']=$rec_member['tab_number'] ;
     $result['args']['data']['user_driving']=$rec_member['driving'] ;
     $result['args']['data']['user_UUID']=$rec_member['uid'] ;
     $img_cont=(file_exists($rec_member['_image_dir']))? base64_encode(file_get_contents($rec_member['_image_dir'])):'' ;
     $result['args']['data']['photo']=$img_cont ;        set_time_point('photo') ;
     if ($rec_member['_qrcode_source']) $result['args']['data']['photo']=$rec_member['_qrcode_source'] ;

     //ENGINE()->on_event_by_pointer('server_whois_success',$result) ;
     if ($GLOBALS['LS_hello_enabled']) $result['args']['data']['greetings']=ESMO()->get_greetings_for_terminal($rec_member) ;


     //LOGS()->reg_log('WHOIS','"'.$number.'"  => '.$rec_member['obj_name'].' ['.$rec_member['propusk'].']',array('member_id'=>$rec_member['pkey'],'terminal_id'=>$terminal_id)) ;
     if ($data['args']['id']['debug_db']) $GLOBALS['debug_db']=0;
     $text_debug=ob_get_clean()  ;
     if ($data['args']['id']['debug_db']) $result['args']['data']['debug_db']=$text_debug ;
       set_time_point('reg_log') ;
     return($result) ;
   }

  function check_access(&$data){}

   var $arr_mo_reason ; // массив текстовые кодов ошибок с МО
   function examination_result(&$data){return([]);}

    function send_ticket_to_term($mo_session_id,&$result)
    {
        $rec_mo=ESMO()->get_mo_by_id_now($mo_session_id) ;

        $allow_mo_types=explode(',',$GLOBALS['LS_mo_success_send_ticket_to_term_mo_type']) ;
        $tk=$rec_mo['tk'] ;
        if ($rec_mo['tkm']) $tk+=3 ;
        if (array_search($tk,$allow_mo_types)===false)
        {
            ob_start() ;
            echo 'Печать талона отклонена по причине несоответствия типа осмотра - '.ESMO()->ARR_mo_tk_type[$tk].' ['.$tk.']<br>' ;
            echo 'Разрешенные типы МО: '.$GLOBALS['LS_mo_success_send_ticket_to_term_mo_type'].'<br>';
            $text=ob_get_clean() ;
            LOG_JSON()->reg('send_ticket_to_term',$text) ;
            return ;
        }

        $result['args']['data']['print_job']=$this->generate_print_job($rec_mo) ;
        //$result['args']['data']['reason']='МО пройден'  ; // зачем оно тут? затирет МО пройден Хорошей смены, Сергей Владиславович

        if ($GLOBALS['LS_terminal_ticket_printer_type']!=1)
        {   include(_DIR_EXT.'/image_print/i_image_print.php') ;
         $IM = new image_print_result_MO($rec_mo) ;
         $img_cont=$IM->get_image_content() ;
         $result['args']['data']['print_job']['image']='data:image/png;base64,'.base64_encode($img_cont);
         $img_dir=ESMO()->get_mo_img_dir_by_id($mo_session_id,'dir','ticket.png',array('check_directory'=>1,'no_check_exist_file'=>1)) ;
         file_put_contents($img_dir,$img_cont) ;
        }
        else { $result['args']['data']['print_job']['image']=null; }
    }


    function save_send_photo(&$data,$img_name,$options=array())
    { $arr=explode(';',$data) ; // ([0] => data:image/png [1] => base64,iVBOR......==)
      if (_sizeof($arr)==1) $img_string=base64_decode($data) ;  //echo $img_string ;
      else
      { $arr2=explode(',',$arr[1]) ; // ([0] => base64 [1] => iVBOR......==)
        $img_string=base64_decode($arr2[1]) ;
      }
      $img_dir=$img_name ;
      file_put_contents(_DIR_TO_ROOT.$img_dir,$img_string) ;

      // коррекция изображения с аклотестера
      if ($options['img_rotare']) ENGINE()->rotare_image(_DIR_TO_ROOT.$img_dir,_DIR_TO_ROOT.$img_dir,$options['img_rotare']) ;

      $data="<img width=150 zoom src='"._MAIN_PROTOCOL._MAIN_DOMAIN.$img_dir."'>" ; // ддя сохранения в журнале
    }

    function save_send_video(&$data,$video_name)
    { $img_string=base64_decode($data) ;  //echo $img_string ;
      $img_dir='/public/mo_video/'.$video_name ;
      file_put_contents(_DIR_TO_ROOT.$img_dir,$img_string) ;
      //$data="<img width=150 zoom src='"._MAIN_PROTOCOL._MAIN_DOMAIN.$img_dir."'>" ; // ддя сохранения в журнале
      $data=_MAIN_PROTOCOL._MAIN_DOMAIN.$img_dir."'" ; // ддя сохранения в журнале
    }

    function check_update($data)
    {
        $terminal_id=$data['args']['id']['terminal'] ; $this->terminal_id=$terminal_id ;
        $version=$data['args']['id']['version'] ;

        $arch = $data['args']['id']['arch'] ;
        switch ($arch) {
            case 'arm':
                $arch = '-arm';
                break;
            default:
                $arch = '';
        }

        $terminal=ESMO()->get_terminal_by_id($terminal_id,array('check_reboot'=>1)) ;
        if ($terminal['pkey'])
        { $group_setting=unserialize(execSQL_value('select settings from obj_site_account where pkey="'.$terminal['parent'].'"')) ;
          $timezone=($group_setting['timezone'])? $group_setting['timezone']:'Europe/Moscow' ;
          date_default_timezone_set($timezone) ;
        }
        $res = [];
        if ($terminal['pkey']) {
            if ($terminal['assigned_version'] && $version != $terminal['assigned_version']) {
                $res['version'] = $terminal['assigned_version'];
                $res['url'] = _PATH_TO_SITE.'/updates/esmo-'.$terminal['assigned_version'].$arch.'-installer';
            }
        }
        return $res;
    }

    function HR_send_data($data)
    {
       // формируем ответ
       $result['date'] = date('Y-m-d H:i:s');
       $result['message']='success' ;
       $result['retry']='false' ;

       if (_sizeof($data['items'])) foreach($data['items'] as $i=>$rec)
       { $result['items'][$i]['person_id']=$rec['person_id'] ;
         $result['items'][$i]['result']='success' ;
         $result['items'][$i]['fail_description']='' ;
       }
       return($result) ;
    }

    function virt_term_check_status($data)
    {
       // формируем ответ
       $result['date'] = date('Y-m-d H:i:s');
       $result['message']='success' ;
       $result['args']['terminal_type']='mt' ;
       $result['args']['data']['video']='success' ;
       $result['args']['data']['tonometer']='success' ;
       $result['args']['data']['thermometer']='success' ;
       $result['args']['data']['alcotester']='success' ;
       $result['args']['data']['pupilometer']='success' ;
       $result['args']['ext_info']['comment']='response from c_server:virt_term_check_status' ;
	   $this->is_log_request=0 ; // не регистрируем данный запрос, так как он виртуальный и отвечать на самом деле должен терминал
       return($result) ;
    }
    function pupilometer_video($data)
    {
       // формируем ответ
       $result['date'] = date('Y-m-d H:i:s');
       $result['message']='success' ;
	   //$this->is_log_request=0 ; // не регистрируем данный запрос, так как он виртуальный и отвечать на самом деле должен терминал

       return($result) ;
    }

    function power_on_printpost($data) {

        $device_id=$data['args']['id']['terminal'] ;
        $device_ip=$_SERVER['REMOTE_ADDR'] ;
        $this->rec_terminal=array() ;
        $_comment=array() ; $create_result=array() ;

        $this->rec_terminal=DEVICE()->get_terminal_by_ip($device_ip,array('check_reboot'=>1,'check_multipule_device'=>1)) ;
        if (!$this->rec_terminal['pkey'])
        {   $_comment[]='<div class="red">Устройство с IP '.$device_ip.' не зарегистрировано в системе</div>' ;
            $this->rec_terminal=DEVICE()->get_terminal_by_id($device_id,array('check_reboot'=>1)) ;
        }

        if (!$this->rec_terminal['pkey'])
        {  $device_id=execSQL_value('select max(id) from obj_site_device') ;
            if (!$device_id) $device_id=0 ;
            $device_id++ ;
            $create_result=DEVICE()->terminal_create(array('group_id'=>1,'name'=>'Пост печати '.$device_id,'id'=>$device_id,'ip'=>$_SERVER['REMOTE_ADDR'],'terminal_type'=>$data['args']['terminal_type'],'clss'=>242)) ;
            //damp_array($create_result) ;

            if ($create_result['pkey']) { $_comment[]='<div class="green">Устройство с ID '.$device_id.' добавлено в систему</div>' ;
                $this->rec_terminal=DEVICE()->get_terminal_by_pkey($create_result['pkey'],array('debug'=>0)) ;
            }
            else                        $_comment[]='<div class="red">Не удалось добавить устройство - '.$create_result['error'].'</div>' ;
        }

        if ($this->rec_terminal['pkey'])
        { $group_setting=unserialize(execSQL_value('select settings from obj_site_account where pkey="'.$this->rec_terminal['parent'].'"')) ;
            $timezone=($group_setting['timezone'])? $group_setting['timezone']:'Europe/Moscow' ;
            date_default_timezone_set($timezone) ;
        }

        $result['date'] = date('Y-m-d H:i:s');
        $result['args']['terminal_type']='pp' ;
        $result['args']['id']['terminal']=$device_id ;
        $result['args']['message']='success' ; // только success иначе теринал будет досить сервер
        $result['args']['data']['complex']=$GLOBALS['LS_setting_system_name'] ;

        $comment=(_sizeof($_comment))? implode('',$_comment):'' ;

        if ($this->rec_terminal['pkey'] and $this->rec_terminal['id'])
        {
            // сохраняем все текущие данные терминала, а там модуль сам разберется что изменилось и что в итоге надо сохранять
            $terminal_data=array('id'=>$device_id,
                'ip'=>$device_ip,
                'status'=>2,
                'vers'=>$data['args']['id']['version'],
                'ext_info'=>array(),
                'devices'=>$data['args']['devices'],
            ) ;

            DEVICE()->terminal_save($this->rec_terminal['pkey'],$terminal_data,array('debug'=>2)) ;

            if ($this->rec_terminal['enabled']) {
                DEVICE()->device_send_async_cmd($this->rec_terminal['pkey'],'check_status',array('pause'=>2,'reffers'=>array($this->rec_terminal['_reffer']))) ;
            }

            if (!$this->rec_terminal['enabled'])
            {
                echo '<div class="red">Устройство заблокировано</div>';
            }

        } else echo '<div class="red">В записи ЭСМО отсутствует ID устройства</div>';

        $text=ob_get_clean() ;
        LOGS()->reg_log('Включение устройства','Терминал '.$device_id.' ['.$device_ip.']: '.$comment.'<br>'.$text,array('device_id'=>$device_id,'device_ip'=>$device_ip,'reffers'=>array($this->rec_terminal['_reffer']))) ;
        $this->terminal_id=$device_id ;
        return($result) ;
    }

    function check_access_printpost($data) {
        ob_start() ;
        $terminal_id=$data['args']['id']['terminal'] ;  $this->terminal_id=$terminal_id ;
        $propusk_id=$data['args']['id']['user'] ;
        $result=array() ; $rec_member=array() ;
        $rec_terminal=DEVICE()->get_terminal_by_id($terminal_id,array('check_reboot'=>1)) ;
        $this->rec_terminal=$rec_terminal ;
        if ($rec_terminal['pkey'])
        { $group_setting=unserialize(execSQL_value('select settings from obj_site_account where pkey="'.$rec_terminal['parent'].'"')) ;
            $timezone=($group_setting['timezone'])? $group_setting['timezone']:_DEFAULT_TIMEZONE ;
            date_default_timezone_set($timezone) ;
        }
        if ($propusk_id)
        { $options_whois=array('only_enabled'=>1,'dop_usl'=>'enabled=1') ;
            if (strpos($propusk_id,'#')!==false) $rec_member=PERSONAL()->whois_personal($propusk_id,$options_whois) ; // QR код будет сгенерирован на основе ВУ и номера авто
            else                                 $rec_member=PERSONAL()->get_personal(array('propusk'=>$propusk_id,'tab_number'=>$propusk_id),array('only_enabled'=>1,'set_rules'=>1,'set_QR_code'=>$GLOBALS['LS_person_field_to_qrcode'],'dop_usl'=>'enabled=1')) ;
            $this->personal_id=$rec_member['pkey'] ;
        }

        $result['date'] = date('Y-m-d H:i:s');
        $result['args']['terminal_type']='pp' ;
        $result['args']['message']='failure' ;
        $result['args']['id']['terminal']=$terminal_id ;
        $result['args']['id']['user']=$rec_member['propusk'] ;

        if ($rec_member['pkey']) {
            $rec_mo=ESMO()->check_active_dopusk($rec_member['pkey'],array('dopusk'=>1,'debug'=>0,'no_check_tk'=>$GLOBALS['LS_post_print_tk_1'])) ;
            if ($rec_mo['pkey'])
            {
                $result['args']['data']['print_job']=$this->generate_print_job($rec_mo) ;
                $result['args']['data']['reason']='МО пройден'  ;
            }
            else
            {
                $result['args']['data']['reason']='МО не пройден'  ;

            }
        } else {
            $result['args']['data']['reason']='Идентификация не проведена!'  ;
        }
        $text=ob_get_clean() ;
        return($result) ;
    }

    function generate_print_job($rec_mo)
    {
        if ($GLOBALS['LS_terminal_ticket_license_date']) $license_date = explode(',',$GLOBALS['LS_terminal_ticket_license_date']);
        else $license_date=[0=>'',1=>''];
        $rec_doctor=ACCOUNTS()->get_member_by_id($rec_mo['doctor_id']) ;
        $group_rec = ACCOUNTS()->get_group_by_id($rec_mo['group_id']);

        $result['exam_session_id']= (int) $rec_mo['pkey'];
        $result['created_at']= (int) $rec_mo['dopusk_time'];
        $result['timezone']= ($group_rec['_settings']['timezone'])?:_DEFAULT_TIMEZONE;
        // LS_terminal_ticket_org_namen - Печатать название организации сотрудника на талоне, Если настройка выключена, будет использовано название организации, проводящей МО, из настройки LS_mo_org_name
        $result['organisation_name']=(($GLOBALS['LS_terminal_ticket_org_name']) ? ($rec_mo['_org_name']) : ($GLOBALS['LS_mo_org_name']));
        $result['division_name']='';
        $result['employee_position_name']='';
        $result['employee_fullname']=$rec_mo['member_name'];
        $result['employee_pass_number']='';
        $result['personnel_number']='';

        $result['user_job_title']=($rec_doctor['working'])?:'Фельдшер';
        $result['user_fullname']=$rec_mo['_doctor_name_small'];
        $result['user_position']=addslashes(($rec_doctor['working'])?:'Фельдшер');

        $result['message']=$GLOBALS['LS_term_ticket_text_tk'.$rec_mo['tk']];

        $result['medical_organisation_name']=(($GLOBALS['LS_terminal_ticket_org_name']) ? $rec_mo['_org_name'] : $GLOBALS['LS_mo_org_name']);
        $result['medical_organisation_license_number']=$GLOBALS['LS_terminal_ticket_license_number'];
        $result['medical_organisation_license_date']=$license_date[0];
        $result['medical_organisation_license_valid_to']=((stripos($license_date[1],'бессрочно')===false)?$license_date[1]:null);

        $result['cert_thumbprint']=$rec_doctor['certificate']['SerialNumber'];
        $result['cert_issuer_name']=$rec_doctor['certificate']['IssuerName'];
        $result['cert_valid_from']=$rec_doctor['certificate']['ValidFromDate'];
        $result['cert_valid_to']=$rec_doctor['certificate']['ValidToDate'];

        $result['lic_info']=$GLOBALS['LS_terminal_ticket_license_number'].' '.$GLOBALS['LS_terminal_ticket_license_date'];
        $result['image']=null;

        return($result) ;

    }

    // подтверждение авторизации с сервера на терминале
    // токен передается в открытом виде при показе во фрейме окна настроект терминала:
    // https://192.168.1.60:9022/?token=1234567
    // терминал берет этот токен и отправляет на сервер запрос на его актуальность
    // сервер должен подтвержить, что терминал прислал выбранный им токен
    function check_token($data_in)
    {
        $data_out=[] ;
        $data_out['args']['data']['token_correct']=true ;
        return($data_out) ;
    }

}
?>
