<?php
$__functions['init'][]='_skd_site_vars' ;
$__functions['boot_site'][]='_skd_site_boot' ;

function SKD() {
    if (isset($_SESSION['skd_system'])){
        return($_SESSION['skd_system']);
    } else {
        $_SESSION['skd_system']=new c_skd_system();
        return($_SESSION['skd_system']);
    }
} ;



function _skd_site_vars()
{   // роли модуля

    $_SESSION['init_options']['skd']['debug']=0 ;
	//$_SESSION['init_options']['skd']['patch_mode']='TREE_NAME' ;
    $_SESSION['init_options']['skd']['patch_mode']='NAME' ;
	$_SESSION['init_options']['skd']['root_dir']	='/cab/skd/' ;
    $_SESSION['init_options']['skd']['clss_items']='601,606' ;
    //$_SESSION['init_options']['skd']['usl_show_items']='enabled=1 and _enabled=1' ;
    $_SESSION['init_options']['skd']['usl_show_items']='_enabled=1' ; // показываем всех сотрудников, уволенных и действующих
    $_SESSION['init_options']['skd']['tree_fields']='*' ;


    // определяем условия для формирование дерева
    $_SESSION['init_options']['skd']['tree']['debug']=0 ;
    $_SESSION['init_options']['skd']['tree']['clss']='600' ;
	$_SESSION['init_options']['skd']['tree']['include_space_section']=1 ;
    $_SESSION['init_options']['skd']['tree']['order_by']='indx' ;
    $_SESSION['init_options']['skd']['tree']['get_count_by_clss']=0 ;

    $_SESSION['ARR_type_skd_gate']=array( 1=>'Турникет',
                                          2=>'Дверь',
                                          3=>'Шлагбаум',
                                          4=>'Терминал весовой',
                                          5=>'Весы'
                                          ) ;

    $_SESSION['ARR_access_type']  =array( 0=>'Вход',
                                          1=>'Выход',
                                          2=>'Выход Охранник'  // выход по со сдачей разового пропуска через охранника
                                          ) ;

    $_SESSION['ARR_access_type2']  =array(0=>'Задается в контроллере',
                                          1=>'Вход',
                                          2=>'Выход'
                                          ) ;

    // опции показа рабочих групп в интерфейсе
    $_SESSION['ARR_wg_status']    =array( 0=>'Показывать',
                                          1=>'Показывать, не выбирать',
                                          2=>'Не показывать'
                                          ) ;

    // опции показа рабочих групп в интерфейсе
    $_SESSION['ARR_evt_type']     =array( 1=>'check_access',
                                          2=>'pass',
                                          3=>'barrier_open',
                                          4=>'barrier_close',
                                          5=>'barrier_open2',
                                          6=>'barrier_close2',
                                          7=>'barrier_cancel',
                                          8=>'check_access_security'
                                          ) ;

    $_SESSION['ARR_result']       =array( 0=>'Запрет',
                                          1=>'Успешно'
                                          ) ;


    // тип пропуска
    $_SESSION['ARR_pass']=        array(  1=>array('type'=>'разовый пропуск',                   'clss'=>500,'small'=>'РП',      'code'=>'one',  'pref'=>'v',    'table'=>'obj_site_pass_van',   'icon'=>''),
                                          2=>array('type'=>'временный пропуск',                 'clss'=>501,'small'=>'ВП',      'code'=>'time', 'pref'=>'t',    'table'=>'obj_site_pass_time',  'icon'=>''),
                                          3=>array('type'=>'постоянный пропуск',                'clss'=>508,'small'=>'ПП',      'code'=>'static',               'table'=>'obj_site_pass_static','icon'=>''),
                                          4=>array('type'=>'разовый пропуск на автомобиль',     'clss'=>500,'small'=>'РП-А',     'code'=>'',     'pref'=>'v',    'table'=>'obj_site_pass_van',    'icon'=>'fa-car'),
                                          5=>array('type'=>'временный пропуск на автомобиль',   'clss'=>507,'small'=>'ВП-А',     'code'=>'',     'pref'=>'t',    'table'=>'obj_site_pass_time',  'icon'=>'fa-car'),
                                          //6=>'постоянный пропуск на автомобиль',
                                          7=>array('type'=>'разовый пропуск ТМЦ (посетитель)',  'clss'=>500,'small'=>'ТМЦ-С',   'code'=>'',     'pref'=>'v',    'table'=>'obj_site_pass_van',   'icon'=>'fa-suitcase'),
                                          8=>array('type'=>'Пропуск ТМЦ (сотрудник)',           'clss'=>502,'small'=>'ТМЦ',     'code'=>'',     'pref'=>'m',    'table'=>'obj_site_pass_tmc',   'icon'=>'fa-suitcase'),
                                          9=>array('type'=>'Пропуск ТМЦ (автомобиль, разовый)',  'clss'=>502,'small'=>'ТМЦ-АР',   'code'=>'',     'pref'=>'m',    'table'=>'obj_site_pass_tmc',    'icon'=>''),
                                          10=>array('type'=>'Пропуск ТМЦ (автомобиль, временный)','clss'=>502,'small'=>'ТМЦ-АВ',   'code'=>'',     'pref'=>'m',    'table'=>'obj_site_pass_tmc',    'icon'=>''),
                                          11=>array('type'=>'Пропуск ТМЦ (автомобиль, многоразовый)','clss'=>502,'small'=>'ТМЦ-АМ',   'code'=>'',     'pref'=>'m',    'table'=>'obj_site_pass_tmc',    'icon'=>''),
                                          //98=>'врешнее управление', // турникет открыт охранником
                                          //99=>'аварийный пропуск' // аварийнрое открытие турникета, будем получать только события прохода без пропуска
                                          ) ;

    // тип пропуска
    $_SESSION['ARR_pass_type']=    array( 1=>'разовый пропуск',
                                          2=>'временный пропуск',
                                          3=>'постоянный пропуск',
                                          4=>'разовый пропуск на автомобиль',
                                          5=>'временный пропуск на автомобиль',
                                          //6=>'постоянный пропуск на автомобиль',
                                          7=>'разовый пропуск ТМЦ (посетитель)',
                                          8=>'пропуск ТМЦ (сотрудник)',
                                          9=>'пропуск ТМЦ на автомобиль (разовый)',
                                          10=>'пропуск ТМЦ на автомобиль (временный)',
                                          11=>'пропуск ТМЦ на автомобиль (многоразовый)',
                                          //98=>'врешнее управление', // турникет открыт охранником
                                          //99=>'аварийный пропуск' // аварийнрое открытие турникета, будем получать только события прохода без пропуска
                                          ) ;

    // иконка типа пропуска
    $_SESSION['ARR_pass_icon']=    array( 1=>'',
                                          2=>'',
                                          3=>'',
                                          4=>'fa-car',
                                          5=>'fa-car',
                                          6=>'fa-car',
                                          7=>'fa-suitcase',
                                          8=>'fa-suitcase',
                                          98=>'', // турникет открыт охранником
                                          99=>'' // аварийнрое открытие турникета, будем получать только события прохода без пропуска
                                          ) ;

    $_SESSION['ARR_pass_type_small']= array( 1=>'РП',
                                             2=>'ВП',
                                             3=>'ПП',
                                             4=>'РП-А',
                                             5=>'ВП-А',
                                             6=>'ПП-А',
                                             7=>'ТМЦ',
                                             8=>'ТМЦ-С',
                                             9=>'ТМЦ-AР',
                                             10=>'ТМЦ-AВ',
                                             11=>'ТМЦ-AМ'
                                          ) ;

    $_SESSION['ARR_pass_type_code']= array( 1=>'one',
                                          2=>'time',
                                          3=>'stat',
                                          4=>'-', // турникет открыт охранником
                                          5=>'-' // аварийнрое открытие турникета, будем получать только события прохода без пропуска
                                          ) ;

    $_SESSION['ARR_device_name_small']= array( 601=>'турн.',
                                               602=>'охр.',
                                               606=>'терминал.'
                                          ) ;

	$_SESSION['ARR_access_denited_type']  =array( 1=>'Пропуск не найден',
                                                  2=>'Пропуск заблокирован',
                                                  3=>'Объект не найден',
                                                  4=>'Доступ запрещен',
                                                  5=>'Доступ запрещен. Выявлен алкоголь при контроле трезвости',
                                                  6=>'Доступ запрещен. Не пройден контроль трезвости',
                                                  7=>'Пропуск просрочен',
                                                  8=>'Пропуск уже использован',
                                                  9=>'Пропуск еще не использован',
                                                  10=>'Пропуск сдан, посетитель уже вышел',
                                                  11=>'Пропуск ТМЦ сдан, автомобиль уже выехал',
                                                  12=>'Пропуск сдан',
                                                  13=>'Пропуск еще не использован',
                                                  14=>'Выход по разовым пропускам через охранника',
                                                  15=>'Выход по временным пропускам через турникет',
                                                  16=>'Запрет двойного прохода (на вход)',
                                                  17=>'Запрет двойного прохода (на выход)',
                                                  18=>'Пропуск по автомобильным пропускам только через шлагбаум',
                                                  19=>'Доступ запрещен (Ошибка зоны)'
                                                ) ;

    //Тип медиасервера
    $_SESSION['ARR_mediaserver_type'] = array (0 => 'v1',1 => 'v2');

    $_SESSION['ARR_monitoring_type']= array(    0=>'HTML',
        1=>'WS'
    ) ;

}

function _skd_site_boot($options)
{
  create_system_modul_obj('skd',$options) ;
}


class c_skd_system  extends c_system_catalog
{   public $dir_to_personal_van_time_image ;

    public $table_zone;
    public $table_gate_events;
    public $view_gate_events;
    public $view_pass_events;

    public $mediaserver_table;
    public $mediaserver_cameras_table;
    public $mediaserver_connection_table;

     function __construct(array $create_options = array())
     {
         $this->table_name ='obj_site_skd' ;
         $this->table_zone ='obj_site_skd' ;
         $this->table_gate_events ='obj_site_gate_events' ;
         $this->view_gate_events ='view_gate_events' ;
         $this->view_pass_events ='view_pass_events' ;

         $this->mediaserver_table='obj_site_mediaservers';
         $this->mediaserver_cameras_table='obj_site_mediaserver_cameras';
         $this->mediaserver_connection_table='obj_site_mediaserver_camera_connect';

         parent::__construct($create_options);

         $this->system_title ='Контроль доступа';

         ENGINE()->reg_ext('skd','СКУД') ;
         ENGINE()->reg_ext('mediaservers','Медиасервер') ;

         set_time_point('Создание объекта <strong>skd_system</strong>') ;
     }

    function declare_menu_items_2($page)
    {
        /*$page->menu['/cab/mediaservers/']=array('title'=>'Медиасервера','class'=>'fa fa-video-camera',
            'items'=>array('/cab/mediaservers/'=>'Медиасервера',
                '/cab/mediaservers/cameras/'=>'Камеры',
                '/cab/mediaservers/connection/'=>'Привязка'
            )
        ) ;*/
    }

    function declare_menu_items_3($page)
    {
        $page->menu['/cab/skd/']=array('title'=>'СКУД') ;
        //$page->menu['/cab/reports/report_gate_events/']=array('title'=>'Проходы','class'=>'fa fa-exchange-alt') ;

    }

    function get_list_zone($parent=1,$clss='')
    { if (!$clss) $clss='600' ;
      $res=execSQL('select * from '.$this->table_zone.' where clss=600 and enabled=1 order by indx') ;
      return($res) ;
    }

    function get_arr_devices($parent=1,$clss='')
    { if (!$clss) $clss='600' ;
      $res=execSQL('select * from '.$this->table_zone.' where clss in (601,602,606) and enabled=1 and (device_ID>0 or turn_id>0) order by indx') ;
      return($res) ;
    }

    function get_list_terminals($usl='')
    {
        if ($usl) $usl = ' and '.$usl;
        $res=execSQL('select * from obj_site_skd where clss=606'.$usl) ;
        return($res) ;
    }

    function get_access_point()
    {
        $res=execSQL('select * from obj_site_skd where clss=601') ;
        return($res) ;
    }

    function get_zone_by_pkey($pkey)
    {
        $res=execSQL_van('select * from '.$this->table_zone.' where clss in (600) and enabled=1 and pkey='.$pkey.' order by indx') ;
        return($res) ;
    }

    // возвращает разрашение/запрет доступа на остновании строки, зашитой в QR-код
    function get_access_by_skippass($turn_rec,$skip_str,$access_type,$options=array())
    {  ob_start() ;
       $access=array() ;
       $access['skip_source']=$skip_str ;
       $pass_type=substr($skip_str,0,1) ;  // первый символ - тип пропуска
       //$pass_number=str_replace($pass_type,'',$skip_str) ;  // на удаление, так как заменяет все вхождения, а не только первое
       $pass_number=substr($skip_str,1,strlen($skip_str)-1) ;  // остальные символы - номер пропуска
       $access['skip_letter']=$pass_type ;
       $access['skip_number']=$pass_number ;
       $access['result']=0 ;
       $pass_type=strtolower($pass_type) ;
       switch($pass_type)
       {
//         case 'v':  $this->check_access_to_van_pass($turn_rec,$pass_number,$access_type,$access,$options) ; break ;
//         case 't':  $this->check_access_to_temporary_pass($turn_rec,$pass_number,$access_type,$access,$options) ; break ;
//         case 'c':  $this->check_access_to_temporary_pass_car($turn_rec,$pass_number,$access_type,$access,$options) ; break ;
//         case 'd':  $this->check_access_to_van_tmc($turn_rec,$pass_number,$access_type,$access,$options) ; break ;
         default:   if (!isset($options['reader']) or $options['reader']=='hid' or $options['reader']=='ws') $this->check_access_to_static_pass($turn_rec,$skip_str,$access_type,$access,$options) ; break ;
       }
       if (!$access['pass_id']) $access['denited_info']='Пропуск "'.$skip_str.'" не существует' ;
       $text=ob_get_clean() ;
       echo $text;
       $reffers=array() ;
       if ($turn_rec['_reffer']) $reffers[]=$turn_rec['_reffer'] ;
       if ($access['pass_reffer']) $reffers[]=$access['pass_reffer'] ;
       if ($access['object_reffer']) $reffers[]=$access['object_reffer'] ;
       //if (!$access['success'] and $options['no_check_skip_to_access']!='PASS') LOGS()->reg_log('get_access_by_skippass',$text,array('data'=>$access,'reffers'=>$reffers),1) ;
       return($access) ;
    }

    // возвращает разрашение/запрет доступа на остновании строки, зашитой в QR-код
     function get_access_by_skippass2($turn_rec,$skip_str,$access_type,$options=array())
     {  ob_start() ;
        $result=array() ;
        $result['skip_source']=$skip_str ;
        $pass_type=substr($skip_str,0,1) ;  // первый символ - тип пропуска
        $pass_number=substr($skip_str,1,strlen($skip_str)-1) ;  // остальные символы - номер пропуска
        $result['skip_letter']=$pass_type ;
        $result['skip_number']=$pass_number ;
        $result['result']=0 ;
        $pass_type=strtolower($pass_type) ;
        // HID пропуска проверяем по отдельному алгоритму
        if ($options['reader']=='hid') $this->check_access_to_static_pass($turn_rec,$skip_str,$access_type,$result,$options) ;
        // QR пропуска
        else
        {  $rec_pass=array() ;
           switch($pass_type)
            { case 'v':  $rec_pass=BP()->get_pass_one_by_uid($pass_number,$options) ; break ;
              case 't':  $rec_pass=BP()->get_pass_time_by_uid($pass_number,$options) ; break ;
              case 'c':  $rec_pass=BP()->get_pass_car_time_by_uid($pass_number,$options) ; break ;
              case 'd':  $rec_pass=BP()->get_pass_one_tmc_by_uid($pass_number,$options) ; break ;
            }
           $this->copy_info_from_skip_to_result($rec_pass,$result,$options) ;
           if (!$options['no_check_skip_to_access']) $this->check_skip_to_access($rec_pass,$turn_rec,$access_type,$result,$options) ;
           else echo 'Проверка прав доступа не проводилась: '.$options['no_check_skip_to_access'].'<br>' ;
        }
        if (!$result['pass_id']) $result['denited_info']='Пропуск "'.$skip_str.'" не существует' ;
        $text=ob_get_clean() ;
        $reffers=array() ;
        if ($turn_rec['_reffer']) $reffers[]=$turn_rec['_reffer'] ;
        if ($result['pass_reffer']) $reffers[]=$result['pass_reffer'] ;
        if ($result['object_reffer']) $reffers[]=$result['object_reffer'] ;
        //if (!$result['success'] and $options['no_check_skip_to_access']!='PASS') LOGS()->reg_log('get_access_by_skippass',$text,array('data'=>$result,'reffers'=>$reffers)) ;
        return($result) ;
     }

    //12345678901
    //99 999 999 999
    function generate_skippass($skip_id,$type,$zone='',$time_from=0,$time_to=0)
    { $skip_str='' ;
      switch($type)
      {  case 'van_time':  $arr[]='v' ; break ;
         case 'temporary': $arr[]='t' ; break ;
         case 'temp_car': $arr[]='c' ; break ;
         case 'van_tmc': $arr[]='d' ; break ;
      }
      $arr[]=$skip_id ;
      //$arr[]=sprintf("%'011d",$skip_id); ;
      //if ($zone) $arr[]=$zone ;
      //if ($time_from) $arr[]=$time_from ;
      //if ($time_to)   $arr[]=$time_to ;
      $skip_str=implode('',$arr) ;
      return($skip_str) ;
    }

    function generate_qr_code($clss,$uid)
    { switch($clss)
      {  case 500:
         case 'van_time':   $arr[]='v' ; break ;
         case 501:
         case 'temporary':  $arr[]='t' ; break ;
         case 502:          $arr[]='d' ; break ;
         case 507:
         case 'temp_car':   $arr[]='c' ; break ;
      }
      $arr[]=sprintf ("%010d",$uid);
      $skip_str=implode('',$arr) ;
      return($skip_str) ;
    }

    // проверка разового пропуска
    // $skip_id     : id пропуска
    // $access_type : 0 - запрос разрешения на вход, 1 - запрос разрешения на выход
    function check_access_to_van_pass($rec_turn,$skip_id,$access_type,&$result,$options=array())
    { $rec_pass=BP()->get_pass_one_by_uid($skip_id,$options) ;
      $this->copy_info_from_skip_to_result($rec_pass,$result,$options) ;
      if (!$options['no_check_skip_to_access']) $this->check_skip_to_access($rec_pass,$rec_turn,$access_type,$result,$options) ;
      else echo 'Проверка прав доступа не проводилась: '.$options['no_check_skip_to_access'].'<br>' ;
    }

    // проверка временного пропуска
    function check_access_to_temporary_pass($rec_turn,$skip_id,$access_type,&$result,$options=array())
    { $rec_pass=BP()->get_pass_time_by_uid($skip_id,$options) ;
      $this->copy_info_from_skip_to_result($rec_pass,$result,$options) ;
      if (!$options['no_check_skip_to_access']) $this->check_skip_to_access($rec_pass,$rec_turn,$access_type,$result,$options) ;
      else echo 'Проверка прав доступа не проводилась: '.$options['no_check_skip_to_access'].'<br>' ;
    }

    // проверка временного пропуска
    function check_access_to_temporary_pass_car($rec_turn,$skip_id,$access_type,&$result,$options=array())
    { $rec_pass=BP()->get_pass_car_time_by_uid($skip_id,$options) ;
      $this->copy_info_from_skip_to_result($rec_pass,$result,$options) ;
      if (!$options['no_check_skip_to_access']) $this->check_skip_to_access($rec_pass,$rec_turn,$access_type,$result,$options) ;
      else echo 'Проверка прав доступа не проводилась: '.$options['no_check_skip_to_access'].'<br>' ;
    }

    // проверка разового пропуска
    // $skip_id     : id пропуска
    // $access_type : 0 - запрос разрешения на вход, 1 - запрос разрешения на выход
    function check_access_to_van_tmc($rec_turn,$skip_id,$access_type,&$result,$options=array())
    { $rec_pass=BP()->get_pass_one_tmc_by_uid($skip_id,$options) ;
      $this->copy_info_from_skip_to_result($rec_pass,$result,$options) ;
      if (!$options['no_check_skip_to_access']) $this->check_skip_to_access($rec_pass,$rec_turn,$access_type,$result,$options) ;
      else echo 'Проверка прав доступа не проводилась: '.$options['no_check_skip_to_access'].'<br>' ;
    }


    // статусы состояния сессии шлагбаума
    // 1: сессия не собрана
    // 2: сессия собрана, ожидается открытие шлагбаума
    // 3: шлагбаум открыт
    // 6: приложен пропуск охранника для аварийного открытия
    // 7: аварийное открытие шлагбаума
    function check_session_barrer($rec_pass,$rec_turn,$fname,&$result,$options=array())
    { // если превышено время сессии - удаляем еэ
      if ($_SESSION['turn_sess']['end']<time() and $_SESSION['turn_sess']['status']!=7 and $_SESSION['turn_sess']['status']!=3)
      {   //LOGS()->reg_log('turn_trace','Превышено время сессии шлагбаума, сессия [status='.$_SESSION['turn_sess']['status'].'] закрыта',array('terminal_id'=>$rec_turn['id']));
          //$result['extra_info']['event_url']='https://10.133.16.226/public/default_barrier_page.html' ;
          $_SESSION['turn_sess']=array() ;
      }
      // если не задано время сесии - задаем время окончания
      if (!$_SESSION['turn_sess']['status'])
      { $_SESSION['turn_sess']['status']=1 ;
        $_SESSION['turn_sess']['uid']=md5(uniqid(rand(),true))  ;
        $_SESSION['turn_sess']['uid']=adding_rec_to_table('obj_site_gate_session',array('parent'=>1,'indx'=>1,'clss'=>617)) ;
        execSQL_update('update obj_site_gate_session set obj_name=pkey where pkey='.$_SESSION['turn_sess']['uid']) ;
      }

      if (!$_SESSION['turn_sess']['end'])
      {  //LOGS()->reg_log('turn_trace','Открывем сесиию шлагбаума',array('terminal_id'=>$rec_turn['id']));
         $_SESSION['turn_sess']['end']=time()+60 ;
      } else $_SESSION['turn_sess']['end']=time()+60 ;


      // информационные поля для отладки
      $_SESSION['turn_sess']['end_time']=date('d.m.Y H:i:s',$_SESSION['turn_sess']['end']) ;
      $_SESSION['turn_sess']['cur_time']=date('d.m.Y H:i:s') ;
      // если шлагбаум открыт аварийно - не обрабатывать другие пропуска
      if ($_SESSION['turn_sess']['status']==7)
      {
          $result['extra_info']['session']=$_SESSION['turn_sess']  ;
          $result['extra_info']['event_url']='https://10.133.16.226/public/default_barrier_status_7.html' ;
          return ;
      }

        if ($_SESSION['turn_sess']['status']==7) return ;

      if ($_SESSION['turn_sess']['status']==3)
      {
          $result['extra_info']['session']=$_SESSION['turn_sess']  ;
          $result['extra_info']['event_url']='https://10.133.16.226/public/default_barrier_status_3.html' ;
          return ;
      }

        if ($_SESSION['turn_sess']['status']==3) return ;

      // пока сессия не собрана, сохраняем в сессии ID пропуска в поле соответствующего пропуска
      if ($_SESSION['turn_sess']['status']<2)
      { $_SESSION['turn_sess'][$fname]['pass_id']=$rec_pass['pkey'] ;
        $_SESSION['turn_sess'][$fname]['pass_reffer']=$rec_pass['_reffer'] ;
        $_SESSION['turn_sess'][$fname]['pass_type_id']=$rec_pass['type'] ;
        $_SESSION['turn_sess'][$fname]['object_name']=$result['object_name'] ;
        $_SESSION['turn_sess'][$fname]['object_id']=$result['object_id'] ;
        $_SESSION['turn_sess'][$fname]['object_reffer']=$result['object_reffer'] ;
        $_SESSION['turn_sess'][$fname]['access']=($result['success'])? 1:0 ; ;
        // пропуска, в которых идут два объекта
        if ($fname=='tmc')
        {   $_SESSION['turn_sess'][$fname]['object_name']=$rec_pass['__name'] ;
            $_SESSION['turn_sess'][$fname]['object_id']=$rec_pass['pkey'] ;

            if ($rec_pass['_driver']['pkey'])
            {   $_SESSION['turn_sess']['driver']['pass_id']=$rec_pass['pkey'] ;
                $_SESSION['turn_sess']['driver']['pass_reffer']=$rec_pass['_reffer'] ;
                $_SESSION['turn_sess']['driver']['pass_type_id']=$rec_pass['type'] ;
                $_SESSION['turn_sess']['driver']['object_name']=$rec_pass['_driver']['obj_name'] ;
                $_SESSION['turn_sess']['driver']['object_id']=$rec_pass['_driver']['pkey'] ;
                $_SESSION['turn_sess']['driver']['object_reffer']=$rec_pass['_driver']['_reffer'] ;
                $_SESSION['turn_sess']['driver']['access']=($result['success'])? 1:0 ;
                //$_SESSION['turn_sess']['driver']['no_reg_event_pass']=1 ;
            }
            if ($rec_pass['_car']['pkey'])
            {   $_SESSION['turn_sess']['car']['pass_id']=$rec_pass['pkey'] ;
                $_SESSION['turn_sess']['car']['pass_reffer']=$rec_pass['_reffer'] ;
                $_SESSION['turn_sess']['car']['pass_type_id']=$rec_pass['type'] ;
                $_SESSION['turn_sess']['car']['object_name']=$rec_pass['_car']['obj_name'] ;
                $_SESSION['turn_sess']['car']['object_id']=$rec_pass['_car']['pkey'] ;
                $_SESSION['turn_sess']['car']['object_reffer']=$rec_pass['_car']['_reffer'] ;
                $_SESSION['turn_sess']['car']['access']=($result['success'])? 1:0 ; ;
                //$_SESSION['turn_sess']['car']['no_reg_event_pass']=1 ;
            }

        }

        // пропуска, в которых идут два объекта
        if ($fname=='one_car')
        {   $_SESSION['turn_sess'][$fname]['object_name']=$rec_pass['__name'] ;
            $_SESSION['turn_sess'][$fname]['object_id']=$rec_pass['pkey'] ;

            if ($rec_pass['_person']['pkey'])
            {   $_SESSION['turn_sess']['driver']['pass_id']=$rec_pass['pkey'] ;
                $_SESSION['turn_sess']['driver']['pass_reffer']=$rec_pass['_reffer'] ;
                $_SESSION['turn_sess']['driver']['pass_type_id']=$rec_pass['type'] ;
                $_SESSION['turn_sess']['driver']['object_name']=$rec_pass['_person']['obj_name'] ;
                $_SESSION['turn_sess']['driver']['object_id']=$rec_pass['_person']['pkey'] ;
                $_SESSION['turn_sess']['driver']['object_reffer']=$rec_pass['_person']['_reffer'] ;
                $_SESSION['turn_sess']['driver']['access']=($result['success'])? 1:0 ;
                //$_SESSION['turn_sess']['driver']['no_reg_event_pass']=1 ;
            }
            if ($rec_pass['_car']['pkey'])
            {   $_SESSION['turn_sess']['car']['pass_id']=$rec_pass['pkey'] ;
                $_SESSION['turn_sess']['car']['pass_reffer']=$rec_pass['_reffer'] ;
                $_SESSION['turn_sess']['car']['pass_type_id']=$rec_pass['type'] ;
                $_SESSION['turn_sess']['car']['object_name']=$rec_pass['_car']['obj_name'] ;
                $_SESSION['turn_sess']['car']['object_id']=$rec_pass['_car']['pkey'] ;
                $_SESSION['turn_sess']['car']['object_reffer']=$rec_pass['_car']['_reffer'] ;
                $_SESSION['turn_sess']['car']['access']=($result['success'])? 1:0 ; ;
                //$_SESSION['turn_sess']['car']['no_reg_event_pass']=1 ;
            }

        }

      }



      // проверяем что в сессии собрано все три участника - автомобиль, водитель и охранник
      if ($_SESSION['turn_sess']['car']['access'] and $_SESSION['turn_sess']['driver']['access']  and $_SESSION['turn_sess']['security']['access'])
      { $_SESSION['turn_sess']['status']=2 ;
        $result['extra_info']['action_text']='Нажмите кнопку открытия шлагбаума' ;
        $result['extra_info']['event_info']='Сессия собрана, отправлено разрешение на открытие шлагбаума' ;
        //$result['success']=1 ;
        $result['extra_info']['session']=$_SESSION['turn_sess']  ;
        //$_SESSION['turn_sess']=array() ; //
      }
      // аварийное открытие шлагбаума
      elseif(!_sizeof($_SESSION['turn_sess']['car']) and !_sizeof($_SESSION['turn_sess']['driver']) and $_SESSION['turn_sess']['security']['access'])
      { $result['extra_info']['action_text']='Аварийное открытие шлагбаума' ;
        $result['extra_info']['event_info']='Первым приложен пропуск охранника, аварийное открытие шлагбаума' ;
        $result['extra_info']['event_url']='https://10.133.16.226/public/default_barrier_status_6.html' ;
        //$result['success']=1 ;
        $_SESSION['turn_sess']['status']=6 ;  //
        $result['extra_info']['session']=$_SESSION['turn_sess']  ;
      }
      else
      { $_SESSION['turn_sess']['status']=1 ;
        if (!$_SESSION['turn_sess']['car']['access']) $result['extra_info']['action_text']='Приложите пропуск автомобиля' ;
        elseif (!$_SESSION['turn_sess']['driver']['access']) $result['extra_info']['action_text']='Приложите пропуск водителя' ;
        elseif (!$_SESSION['turn_sess']['security']['access']) $result['extra_info']['action_text']='Приложите пропуск охранника' ;
        $result['extra_info']['session']=$_SESSION['turn_sess']  ;
        //$result['success']=0 ;
      }

    }

    // проверка постоянного пропуска
    // надо сдеать проверку по базе HR и по базе iNet
    function check_access_to_static_pass($rec_turn,$skip_id,$access_type,&$result,$options=array())
    { //$result['skip_id']=$skip_id ;
      $result['pass_id']=0 ; //$skip_id ;
      $result['success']=0 ;
      $rec_pass=PERSONAL()->get_pass_static_by_number($skip_id,array('debug'=>$options['debug'])) ; //damp_array($rec_pass,1,-1) ;
      //if (!$rec_pass['pkey'] and _USE_iNET_DB) $rec_pass=$this->get_pass_static_by_id_from_iNet($skip_id,array('debug'=>2)) ;

      $this->copy_info_from_skip_to_result($rec_pass,$result) ;
      $this->check_skip_to_access($rec_pass,$rec_turn,$access_type,$result) ;
      $result['pass_type_id']=3 ; // постоянный пропуск
      $result['pass_type']='permanent' ; // постоянный пропуск
    }

    // копируем инфрмацию из разового, временного, постоянного пропуска в результат по допуску сотрудника
    function copy_info_from_skip_to_result($rec_pass,&$result,$options=array())
    { if (!$rec_pass['pkey']) return ;
      $result['pass_id']=$rec_pass['pkey'] ;
      $pass_type_id=$rec_pass['type'] ; $pass_type='' ;
      if ($rec_pass['clss']==500)       { $pass_type='onetime' ;
                                          if ($pass_type_id==4)  $pass_type='one_car' ;
                                        }
      else if ($rec_pass['clss']==501)  { $pass_type='temporary' ; }
      else if ($rec_pass['clss']==507)  { $pass_type='temp_car' ; }
      else if ($rec_pass['clss']==502)  { $pass_type='tmc' ; }
      $result['pass_clss']=$rec_pass['clss'];
      $result['pass_type']=$pass_type;
      $result['pass_type_id']=$pass_type_id ;
      $result['pass_status']=$rec_pass['status'] ;
      $result['pass_reffer']=$rec_pass['_reffer'] ;
      $result['date_from']=date('Y-m-d H:i:s',$rec_pass['time_from']) ;
      $result['date_to']=date('Y-m-d H:i:s',$rec_pass['time_to']) ;
      $result['time_from']=$rec_pass['time_from'] ;
      $result['time_to']=$rec_pass['time_to'] ;
      $result['last_update']=date('Y-m-d H:i:s',$rec_pass['r_data']) ;
      $result['inside']=$rec_pass['inside'] ;
      $result['allow_zones']=$rec_pass['_allow_zones'] ;
      $result['allow_points']=$rec_pass['_allow_points'] ;
      /*if ($rec_pass['_person']['pkey'])
       {  $result['personal']['pkey']=$rec_pass['_person']['pkey'] ;
          $result['personal']['obj_name']=$rec_pass['_person']['obj_name'] ;
          $result['personal']['_reffer']=$rec_pass['_person']['_reffer'] ;
          if ($rec_pass['_person']['_image_name']) $result['personal']['_image_dir']=$this->dir_to_personal_van_time_image.'400/'.$rec_pass['_person']['_image_name'] ;
       }*/
      if ($rec_pass['_object_id'])
       {  $result['object_id']=$rec_pass['_object_id'] ;
          $result['object_name']=$rec_pass['_object_name'] ;
          $result['object_reffer']=$rec_pass['_object_reffer'] ;
          if ($rec_pass['_object_image']) $result['object_image']=$rec_pass['_object_image'];
       }

      }

/*
 *
    // тип пропуска
    $_SESSION['ARR_pass']=        array(  1=>array('type'=>'разовый пропуск',                   'clss'=>500,'small'=>'РП',      'code'=>'one',  'pref'=>'v',    'table'=>'obj_site_pass_van',   'icon'=>''),
                                          2=>array('type'=>'временный пропуск',                 'clss'=>501,'small'=>'ВП',      'code'=>'time', 'pref'=>'t',    'table'=>'obj_site_pass_time',  'icon'=>''),
                                          //3=>array('type'=>'постоянный пропуск','clss'=>0,'small'=>'ПП','code'=>'static','table'=>'obj_site_pass_static','icon'=>''),
                                          4=>array('type'=>'разовый пропуск на автомобиль',     'clss'=>500,'small'=>'РП-А',     'code'=>'',     'pref'=>'v',    'table'=>'obj_site_pass_van',    'icon'=>'fa-car'),
                                          5=>array('type'=>'временный пропуск на автомобиль',   'clss'=>507,'small'=>'ВП-А',     'code'=>'',     'pref'=>'t',    'table'=>'obj_site_pass_time',  'icon'=>'fa-car'),
                                          //6=>'постоянный пропуск на автомобиль',
                                          7=>array('type'=>'разовый пропуск ТМЦ (посетитель)',  'clss'=>500,'small'=>'ТМЦ-С',   'code'=>'',     'pref'=>'v',    'table'=>'obj_site_pass_van',   'icon'=>'fa-suitcase'),
                                          8=>array('type'=>'Пропуск ТМЦ (сотрудник)',           'clss'=>502,'small'=>'ТМЦ',     'code'=>'',     'pref'=>'m',    'table'=>'obj_site_pass_tmc',   'icon'=>'fa-suitcase'),
                                          9=>array('type'=>'Пропуск ТМЦ (автомобиль, разовый)',  'clss'=>502,'small'=>'ТМЦ-АР',   'code'=>'',     'pref'=>'m',    'table'=>'obj_site_pass_tmc',    'icon'=>''),
                                          10=>array('type'=>'Пропуск ТМЦ (автомобиль, временный)','clss'=>502,'small'=>'ТМЦ-АВ',   'code'=>'',     'pref'=>'m',    'table'=>'obj_site_pass_tmc',    'icon'=>''),
                                          11=>array('type'=>'Пропуск ТМЦ (автомобиль, многоразовый)','clss'=>502,'small'=>'ТМЦ-АМ',   'code'=>'',     'pref'=>'m',    'table'=>'obj_site_pass_tmc',    'icon'=>''),
                                          //98=>'врешнее управление', // турникет открыт охранником
                                          //99=>'аварийный пропуск' // аварийнрое открытие турникета, будем получать только события прохода без пропуска
                                          ) ;
 */

    // проверка пропуска на доступ
    function check_skip_to_access($rec_pass,$rec_turn,$access_type,&$result,$options=array())
    { ob_start() ;
      $check_zone=0 ;
      if (!is_array($rec_turn['_allow_zones'])) $rec_turn['_allow_zones']=array() ;
      if (!is_array($rec_pass['_allow_zones'])) $rec_pass['_allow_zones']=array() ;
      $_title=array() ; $object_name='' ; $access_type_name='' ;  $pass_type_name=$_SESSION['ARR_pass'][$result['pass_type_id']]['type'] ;
      switch($result['pass_type_id'])
      { case 1: $object_name='Посетитель' ;  $check_zone=($access_type==0)? 1:0 ;  break ;
        case 2: $object_name='Посетитель' ; $check_zone=($access_type==0)? 1:0 ; break ;
        case 3: $object_name='Сотрудник' ;$check_zone=($access_type==0)? 0:0 ; $check_ME=($access_type==0)? 1:0 ; break ; // TODO - 1:0 - отключена проверка зоны на входе
        case 4: $object_name='Автомобиль' ; $check_zone=($access_type==0)? 1:1 ; break ;
        case 5: $object_name='Автомобиль' ; $check_zone=($access_type==0)? 1:1 ; break ;
        case 6: $object_name='Автомобиль' ; $check_zone=($access_type==0)? 1:1 ; break ;
        case 7: $object_name='ТМЦ' ; $check_zone=1 ; break ;
        case 8: $object_name='ТМЦ' ;$check_zone=1 ;  break ;
        case 9: $object_name='ТМЦ' ; $check_zone=1 ; break ;
        case 10: $object_name='ТМЦ' ; $check_zone=1 ; break ;
        case 11: $object_name='ТМЦ' ; $check_zone=1 ; break ;
      }
      $_title[]=$pass_type_name ;
      $result['pass_type_name']=$pass_type_name ;
      $result['pass_enabled']=$rec_pass['enabled'] ;
      $result['object_type_name']=$object_name ;
      // направление входы-выхода для людей
      if (array_search($result['pass_type_id'],array(1,2,3))) switch($access_type)
      { case 0: $access_type_name='Вход' ; break ;
        case 1: $access_type_name='Выход через турникет' ; break ;
        case 2: $access_type_name='Выход через охранника' ; break ;
      }
      // направление входа-выхода для авто
      else if (array_search($result['pass_type_id'],array(4,5,6))) switch($access_type)
      { case 0: $access_type_name='Въезд ' ; break ;
        case 1: $access_type_name='Выезд ' ; break ;
        //case 2: $_title[]='Выход через охранника<br>' ; break ;
      }
      if ($access_type_name) $_title[]=$access_type_name.' ' ;
      $result['access_type_name']=$access_type_name ;

//      if ($result['object_id']) $result_alco=$this->check_tkt($result['object_id']) ; else  $result_alco=3 ;

      echo implode(', ',$_title).'<br>' ;

      if (!$rec_pass['pkey'])                                                               { $result['denited_code']=1 ;  echo 'pass_id=0<br>' ; }
      elseif (!$rec_pass['enabled'])                                                        { $result['denited_code']=2 ;  echo 'enabled=0<br>' ; }
      elseif (!$rec_pass['_object_id'])                                                     { $result['denited_code']=3 ;  $result['denited_info']=$object_name.' не найден' ; echo '_object_id указавает на несуществущий ID<br>' ; }
      elseif ($rec_pass['_object_in_black_list'])                                           { $result['denited_code']=4 ;  echo $object_name.' в черном списке<br>' ; }
      elseif ($result_alco==2)                                                              { $result['denited_code']=5 ;  echo $object_name.' Выявлен алкоголь при контроле трезвости<br>' ; }
      elseif ($result_alco==3)                                                              { $result['denited_code']=6 ;  echo $object_name.' Не пройден контроль трезвости<br>' ; }
      // при проходе через турникет проверяем срок действия пропуска
      elseif (($access_type==0 or $access_type==1) and !($rec_pass['time_from']<time() and time()<$rec_pass['time_to'])) { $result['denited_code']=7 ;    echo $access_type_name.' и НЕ ('.date('d.m.Y H:i:s',$rec_pass['time_from']).' < '.date('d.m.Y H:i:s',time()).' < '.date('d.m.Y H:i:s',$rec_pass['time_time']).')<br>' ; }
      // не пускаем через вход турникета уже использованные разовые пропуска
      elseif($result['pass_type_id']==1 and $access_type==0 and $rec_pass['status']>3)      { $result['denited_code']=8 ;   echo 'Разовый пропуск, Вход, Статус > 3 [Использован]<br>' ; }
      elseif($result['pass_type_id']==9 and $access_type==0 and $rec_pass['status']>3)      { $result['denited_code']=8 ;   echo 'Разовый пропуск ТМЦ, Вход, Статус > 3 [Использован]<br>' ; }
      // не пускаем через охранника пропуска, у которых не было ни одного check_access
      elseif($result['pass_type_id']==1 and $access_type==2 and !$rec_pass['time_auth'])     { $result['denited_code']=9 ;    echo 'Разовый пропуск, Выход через охранника, Статус = 3 [Выдан]<br>' ; }
      // не пускаем через охранника уже погашенные разовые и временные пропуска
      elseif($result['pass_type_id']==1 and $access_type==2 and $rec_pass['time_out']>0)     { $result['denited_code']=10;  $result['denited_info']='Пропуск сдан, посетитель уже вышел'.(($rec_pass['time_check'])? ', '.date('d.m.Y H:i:s',$rec_pass['time_check']):'') ;  echo 'Разовый пропуск, Выход через охранника, Статус = 5 [Сдал, вышел]<br>' ; }
      elseif($result['pass_type_id']==1 and $rec_pass['status']==5)                          { $result['denited_code']=10 ;  $result['denited_info']='Пропуск сдан, посетитель уже вышел'.(($rec_pass['time_out'])? ', '.date('d.m.Y H:i:s',$rec_pass['time_out']):'') ;  echo 'Разовый пропуск, Выход через турникет, Статус = 5 [Сдал, вышел]<br>' ; }
      elseif($result['pass_type_id']==9 and $rec_pass['status']==5)                          { $result['denited_code']=11 ; $result['denited_info']='Пропуск ТМЦ сдан, автомобиль уже выехал'.(($rec_pass['time_out'])? ', '.date('d.m.Y H:i:s',$rec_pass['time_out']):'') ;  echo 'Разовый пропуск, Выход через турникет, Статус = 5 [Сдал, вышел]<br>' ; }
      elseif($result['pass_type_id']==2 and $rec_pass['status']==5)                         { $result['denited_code']=12 ; $result['denited_info']='Пропуск сдан'.(($rec_pass['time_check'])? ', '.date('d.m.Y H:i:s',$rec_pass['time_check']):'') ;  echo 'Временный пропуск, Выход через охранника, Статус = 5[Сдал]<br>' ; }
      // не пускаем через охранника еще использованные разовые пропуска
      elseif($result['pass_type_id']==1 and $access_type==2 and $rec_pass['status']<3)      { $result['denited_code']=13 ; echo 'Разовый пропуск, Выход через охранника, Статус < 3 [Использован]<br>' ; }
      // не выпускаем по разовым пропускам через турникет
      elseif($result['pass_type_id']==1 and $access_type==1 and !$rec_turn['allow_one'])    { $result['denited_code']=14 ;  echo 'Разовый пропуск, Выход через турникет<br>' ; }
      // не выпускаем по временным пропускам через охранника
      elseif($result['pass_type_id']==2 and $access_type==2)                                { $result['denited_code']=15 ;  echo 'Временный пропуск, Выход через охранника<br>' ; }
      // временно не пускаем по постоянным пропускам
      // TODO- отключено для 141
      //elseif($result['pass_type_id']==3)                                                    { $result['denited_info']='Проход по постоянным пропускам ' ;  echo 'Постоянный пропуск<br>' ; }

      // проверяем  inside при входе/выходе на временных пропусках
      elseif($rec_turn['check_dp'] and $result['pass_type_id']>1 and $access_type==0 and $rec_pass['inside']==1 and !$rec_pass['_person']['_ext_info']['allow_control_barrier'])  { $result['denited_code']=16 ;  echo 'Временный пропуск, двойной проход (вход)<br>' ; }
      elseif($rec_turn['check_dp'] and $result['pass_type_id']>1 and $access_type==1 and $rec_pass['inside']==0 and !$rec_pass['_person']['_ext_info']['allow_control_barrier'])  { $result['denited_code']=17 ;  echo 'Временный пропуск, двойной проход (выход)<br>' ; }
      //
      elseif(($result['pass_type_id']==4 or $result['pass_type_id']==5 or $result['pass_type_id']==6 or $result['pass_type_id']==9 or $result['pass_type_id']==10 or $result['pass_type_id']==11) and  $rec_turn['type']!=3) { $result['denited_code']=18 ;  echo 'Пропуск на автомобиль, проезд не через шлагбаум<br>' ; }
      // при входе через турникет проверяем зону доступа
      elseif($check_zone /*$result['pass_type_id']!=3 and $access_type==0*/ and (!_sizeof(array_intersect($rec_turn['_allow_zones'],$rec_pass['_allow_zones'])) or !_sizeof($rec_pass['_allow_zones'])))
      {
          $result['denited_code']=19 ; ;
          // если доступ все еще разрешен, проверяем по зоне доступа
          echo 'Направление прохода - '.(($access_type)? 'Выход':'Вход').'<br>' ;
          echo '<strong>inside:</strong>'.$rec_pass['inside'].'<br>' ;
          echo '<strong>Зоны турникета</strong>' ;

          $info=array() ;
          if (_sizeof($rec_turn['_allow_zones'])) foreach($rec_turn['_allow_zones'] as $zone_id) $info[$zone_id]=SKD()->get_full_zone_path($zone_id) ;
          damp_array($info,1,-1) ;
                  echo '<strong>Точки прохода пропуска</strong><br>' ;
                  damp_array($rec_pass['_allow_points'],1,-1)  ;
                  echo '<strong>Зоны пропуска</strong><br>' ;
          $info=array() ;
          if (_sizeof($rec_pass['_allow_zones'])) foreach($rec_pass['_allow_zones'] as $zone_id) $info[$zone_id]=SKD()->get_full_zone_path($zone_id) ;
          damp_array($info,1,-1) ;
          echo '<strong>Пересечение массивов</strong>' ;
          $res2=array_intersect($rec_turn['_allow_zones'],$rec_pass['_allow_zones']) ;
          $info=array() ;
          if (_sizeof($res2))
          { foreach($res2 as $zone_id) $info[$zone_id]=SKD()->get_full_zone_path($zone_id) ;
            damp_array($info,1,-1) ;
          } else echo '<div class=red>Зоны не пересекаются</div>' ;
      }
      elseif ($check_ME) {
          $personal_rec = PERSONAL()->get_personal_by_id($rec_pass['personal_id'],['no_public_info'=>1]);
          damp_array($rec_pass);
          if (!$personal_rec['full_access']) {
              $rec_mo=ESMO()->check_active_dopusk($rec_pass['personal_id'],array('dopusk'=>1,'debug'=>0)) ;
              if (!$rec_mo['pkey']) {
                  $result['denited_code']=20 ;
                  $result['denited_info']='Не пройден МО';
                  //$rec_quiz=execSQL_value('select result from kbs_quiz_results where mo_id='.$rec_mo['pkey']) ;
                  //if ($rec_quiz['pkey'] and $rec_quiz['result']==2)
                  //{  $result['denited_code']=20 ;
                  //   $result['denited_info']='Не пройден МО';
                  //
                  //}
              }
          }
      }

	  if ($result['denited_code'] and !$result['denited_info']) $result['denited_info']=$_SESSION['ARR_access_denited_type'][$result['denited_code']] ;

      if (!$result['denited_code']) $result['success']=1 ;

      if ($result['denited_info']) echo '<div class=red>'.$result['denited_info'].'</div>' ; else echo '<div class=green>OK</div>' ;
        echo 'pass_type_id='.$result['pass_type_id'].'<br>' ;
        echo 'access_type='.$access_type.'<br>' ;
        echo 'inside='.$rec_pass['inside'].'<br>' ;
        echo 'check_zone='.$check_zone.'<br>' ;
      $text=ob_get_clean() ;
      if (!$result['success'] or _IS_SYSTEM_IP or 1)
          LOGS()->reg_log('check_skip_to_access',$text,array('_data'=>$result,'reffers'=>$rec_pass['_reffers']),1) ;
    }

    // проверка на контроль трезвости
    function check_tkt($personal_id)
    { $rec=execSQL_van('select * from obj_site_kt_session where member_id='.$personal_id.' and dopusk in (1,2) and dopusk_time_end>'.time().' order by pkey desc limit 1',2) ;
      if (!$rec['pkey']) return(3) ;
      elseif ($rec['dopusk']==2) return(2) ;
      else return(1) ;
    }

    function is_allow_control_barrier($rec_pass)
    { ob_start() ;
      if
      (  !$rec_pass['_person']['_ext_info']['denited_control_barrier'] and
         ((isset($rec_pass['_person']['_ext_info']['allow_control_barrier']) and $rec_pass['_person']['_ext_info']['allow_control_barrier']==1)  or
          (isset($rec_pass['_person']['_org_ext_info']['allow_control_barrier']) and $rec_pass['_person']['_org_ext_info']['allow_control_barrier']==1)
         )
      ) $result=1 ;
      else $result=0 ;
      damp_array($rec_pass['_person']['_ext_info'],1,-1) ;
      damp_array($rec_pass['_person']['_org_ext_info'],1,-1) ;
      $text=ob_get_clean() ;
      //LOGS()->reg_log('is_allow_control_barrier',$text,array()) ;
      return($result) ;
    }

    function get_gate_events($options=array())
    { $arr=array() ; $_usl=array() ;
//      $_usl[]='t1.clss=612' ; //оптимизация запросов к obj_site_gate_events во всей таблице только один класс 612
      $usl_select=implode(' and ',$_usl) ;
      if ($usl_select)  $usl_select='where '.$usl_select;
      $recs=execSQL('select t1.*,t2.device_ID as _turn_id,t3.obj_name as _personal_name,t4.obj_name as _person_name
                     from '.$this->table_gate_events.' t1
                     left join obj_site_skd t2 on t2.pkey=t1.device_id
                     left join obj_site_personals t3 on t3.pkey=t1.personal_id
                     left join obj_site_persons t4 on t4.pkey=t1.personal_id
                      '.$usl_select.' order by t1.pkey desc limit 50') ;
      $stats=array() ;
      if (_sizeof($recs)) foreach($recs as $rec)
      {// if ($rec[''])

      }
      return(array($recs,$stats)) ;
    }

    function get_gate_event_by_id($id,$options=array())
    { $rec=execSQL_van('select t1.*,t2.device_ID as _turn_id,t3.obj_name as _personal_name
                     from '.$this->table_gate_events.' t1
                     left join obj_site_skd t2 on t2.pkey=t1.device_id
                     left join obj_site_personals t3 on t3.pkey=t1.personal_id
                     where t1.pkey='.$id,$options['debug']) ;

      $rec['_pass_name']=$_SESSION['ARR_pass_type'][$rec['pass_type']].' № '.$rec['pass_id'] ;
      return($rec) ;
    }

    function reg_gate_events($params,$options=array())
    { $params['clss']=612 ;
      if (isset($params['session_uid']))
      { $uid=$params['session_uid'] ;
        $id=execSQL_value('select pkey from obj_site_gate_session where obj_name="'.$uid.'"') ;
        if (!$id) $id=adding_rec_to_table('obj_site_gate_session',array('obj_name'=>$uid,'parent'=>1,'indx'=>1,'clss'=>617)) ;
        $params['session_id']=$id ;
        unset($params['session_uid']) ;
      }
      $id=adding_rec_to_table($this->table_gate_events,$params,array('no_auto_indx'=>1)) ;

      return($id) ;
    }

    // фиксируем в разовом пропуске зону и направление прохода
    function pass_one_fixed_skip($pass_id,$event_id,$access_type,$options=array())
    { ob_start() ;
      // вход
      if (!$access_type)
      { $res=update_rec_in_table(BP()->table_pass_one,array('status'=>4,'event_id_in'=>$event_id,'inside'=>1,'time_in'=>time()),'pkey='.$pass_id) ;
        damp_array($res,1,-1) ;
      }
      // эта функция на выход может вызвана только через охранника
      // доработано, что на выход разовый пропуск может и через турникет, если у него стоил галка "разрешить выход по разовым пропускам"
      else
      {   $event_id_out=$event_id ;
          update_rec_in_table(BP()->table_pass_one,array('event_id_out'=>$event_id_out,'inside'=>0,'time_out'=>time(),'status'=>5),'pkey='.$pass_id) ;
          // вписываем в событие входа id события выхода
          $id_event_in=execSQL_value('select event_id_in from '.BP()->table_pass_one.' where pkey='.$pass_id) ;
          //списываем в событие входа id события выхода
          if ($id_event_in) update_rec_in_table(SKD()->table_gate_events,array('evt_out_time'=>time(),'evt_out_id'=>$event_id_out,'evt_out_zone'=>$options['zone_id'],'evt_out_dev'=>$options['device_id']),'pkey='.$id_event_in)  ;

          //списываем в событие выхода id события входа       view_gate_trackingview_gate_tracking
          if ($id_event_in) update_rec_in_table(SKD()->table_gate_events,array('evt_out_id'=>$id_event_in),'pkey='.$event_id_out)  ;
      }

      $text=ob_get_clean() ;
      //LOGS()->reg_log('pass_one_fixed_skip',$pass_id.' - '.$event_id.'<br>'.$text,$options) ;
    }

    // фиксируем в разовом пропуске зону и направление прохода
    function pass_one_tmc_fixed_skip($pass_id,$event_id,$access_type,$options=array())
    { ob_start() ;
      // вход
      if (!$access_type)
      { $res=update_rec_in_table(BP()->table_pass_tmc,array('status'=>4,'event_id_in'=>$event_id,'inside'=>1,'time_in'=>time()),'pkey='.$pass_id) ;
        damp_array($res,1,-1) ;
      }
      // эта функция на выход может вызвана только через охранника
      // доработано, что на выход разовый пропуск может и через турникет, если у него стоил галка "разрешить выход по разовым пропускам"
      else
      {   $event_id_out=$event_id ;
          //$cur_pass_status=execSQL_value('select status from obj_site_pass_tmc where pkey='.$pass_id) ;
          //if ($cur_pass_status==4)
          {   update_rec_in_table(BP()->table_pass_tmc,array('event_id_out'=>$event_id_out,'inside'=>0,'time_out'=>time(),'status'=>5,'time_ho'=>time()),'pkey='.$pass_id) ;
              // вписываем в событие входа id события выхода
              $id_event_in=execSQL_value('select event_id_in from '.BP()->table_pass_tmc.' where pkey='.$pass_id) ;
              //списываем в событие входа id события выхода
              if ($id_event_in) update_rec_in_table(SKD()->table_gate_events,array('evt_out_time'=>time(),'evt_out_id'=>$event_id_out,'evt_out_zone'=>$options['zone_id'],'evt_out_dev'=>$options['device_id']),'pkey='.$id_event_in)  ;
              //списываем в событие выхода id события входа
              if ($id_event_in) update_rec_in_table(SKD()->table_gate_events,array('evt_out_id'=>$id_event_in),'pkey='.$event_id_out)  ;
          }
      }

      $text=ob_get_clean() ;
      //LOGS()->reg_log('pass_tmc_one_fixed_skip',$pass_id.' - '.$event_id.'<br>'.$text,$options) ;
    }

    function send_tracking_email($person_reffer,$event_text,$options=array())
    { list($person_id,$person_tkey)=explode('.',$person_reffer) ;
      if ($person_tkey!=283) return ;
      $recs=execSQL('select t1.pkey,t1.account_id,t2.email,t2.obj_name 
                     from obj_site_gate_tracking t1, obj_site_account t2 
                     where t1.person_id="'.$person_id.'" and t2.pkey=t1.account_id') ;
      if (_sizeof($recs))
      { foreach($recs as $rec)
          { ob_start() ;
            MAILS()->send_html_mail($rec['email'],'Уведомление о проходе','Дата: '.date('d.m.Y H:i').'<br>'.$event_text,array('reg_events'=>1,'debug'=>1)) ;
            //echo 'send email to '.$rec['email'].':<br>'.'Дата: '.date('d.m.Y H:i').'<br>'.$event_text.'<br>' ;
            $text=ob_get_clean() ;
            $account_reffer=$rec['account_id'].'.52' ;
            LOGS()->reg_log('send_tracking_email',$text,array('reffers'=>array($person_reffer,$account_reffer))) ;
          }
      }
      //MAILS()->send_html_mail('gorev1961@list.ru','Уведомление о проходе','Дата: '.date('d.m.Y H:i').'<br>'.$event_text,array('reg_events'=>0,'debug'=>0)) ;
    }

    // фиксируем в разовом пропуске зону и направление прохода
    function pass_time_fixed_skip($pass_id,$event_id,$access_type,$options=array())
    { ob_start() ;
      // вход
      if (!$access_type)
      { $res=update_rec_in_table(BP()->table_pass_time,array('event_id_in'=>$event_id,'inside'=>1),'pkey='.$pass_id) ;
        //damp_array($res,1,-1) ;
        if (isset($options['object_reffer']))
        {  ob_start() ;
           list($pkey,$tkey)=explode('.',$options['object_reffer']) ;
           if ($tkey and is_object(_DOT($tkey))) $res=update_rec_in_table($tkey,array('inside'=>1),'pkey='.$pkey,array('debug'=>1)) ;
           $text=ob_get_clean() ;
           //LOGS()->reg_log('set_inside',$text) ;

        }
      }
      // выход
      else
      { $event_id_out=$event_id ;
        //echo 'сохраняем в пропуске id события выхода: '.$event_id_out.'<br>' ;
        update_rec_in_table(BP()->table_pass_time,array('event_id_out'=>$event_id_out,'inside'=>0),'pkey='.$pass_id,array('debug'=>0)) ;  // сохраняем в пропуске время выхода
        // сохраняем поле inside в объекте пропуска

        if (isset($options['object_reffer']))
          {  ob_start() ;
             list($pkey,$tkey)=explode('.',$options['object_reffer']) ;
             if ($tkey and is_object(_DOT($tkey))) $res=update_rec_in_table($tkey,array('inside'=>0),'pkey='.$pkey,array('debug'=>1)) ;
             $text=ob_get_clean() ;
             //LOGS()->reg_log('set_inside',$text) ;
          }

        // вписываем в событие входа id события выхода
        $id_event_in=execSQL_value('select event_id_in from '.BP()->table_pass_time.' where pkey='.$pass_id,0) ;
        //echo 'получили из пропуска id ['.$pass_id.'] событие входа event_id_in: '.$id_event_in.'<br>' ;

        //echo 'вписываем в событие входа ['.$id_event_in.'] id события выхода: '.$event_id_out.'<br>' ;
        if ($id_event_in) update_rec_in_table(SKD()->table_gate_events,array('evt_out_time'=>time(),'evt_out_id'=>$event_id_out,'evt_out_zone'=>$options['zone_id'],'evt_out_dev'=>$options['device_id']),'pkey='.$id_event_in,array('debug'=>0))  ;

        //echo 'вписываем в событие выхода ['.$event_id_out.'] id события входа: '.$id_event_in.'<br>' ;
        if ($id_event_in) update_rec_in_table(SKD()->table_gate_events,array('evt_out_id'=>$id_event_in),'pkey='.$event_id_out,array('debug'=>0))  ;
      }
      $text=ob_get_clean() ;
      //LOGS()->reg_log('pass_time_fixed_skip',$text,$options) ;
    }

    // вывод строки по проходу в монитор
    function get_mo_session_view_table_tr($gate_event_id)
    {  ob_start() ;
       $rec_event=$this->get_gate_event_by_id($gate_event_id) ;
       include_once(_DIR_EXT.'/tracking/list_gate_events.php') ;
       list_gate_events_tr($rec_event) ;
       return(ob_get_clean()) ;
    }

    // формирование HTML, которое потом будет сохранено как карточка события
    // пока карточки сохраняются в БД, возвращаем руезультат
    // как только будет на терминалах режим HTML - переделать в прямое сохранение HTML файла
    function get_event_card($group_id,$gate_event_id,$access=array(),$terminal_type=0,$options=array())
    {  ob_start() ;
       $rec_event=$this->get_gate_event_by_id($gate_event_id) ;
       if ($options['use_template']) $template_name=$options['use_template'] ;
       else switch($rec_event['pass_type'])
       { case 1:
         case 2:
         case 3:  $template_name='event_card_person' ;break ;
         case 4:
         case 5:
         case 6:  $template_name='event_card_car' ; break ;
         default: $template_name='event_card' ;
       }
       // для устройств "Шлагбаум" надо отдавать HTML страницу со стилями а не блок
       $mode=($terminal_type==3)? 'HTML':'panel';
       // подключаем шаблон и выводим его
        include_once(_DIR_EXT.'/tracking/'.$mode.'_'.$template_name.'.php') ;
        $func_name=$mode.'_'.$template_name ;
        $func_name($rec_event,$access) ;

        $html_event_card=ob_get_clean() ;
        //$event_fname='evt_'.$group_id.'_'.$gate_event_id.'.html' ;
        //$cnt=file_put_contents(_TEMP_DIR.'monitor/'.$event_fname,$html_event_card) ;

        return($html_event_card) ;
    }

   // получаем информацию по номеру пропуска из базы  iNet
   function get_pass_static_by_id_from_iNet($pass_id)
   {  include_once(_DIR_TO_ENGINE.'/c_db_mssql.php') ;
      $pass_id_hex=dechex($pass_id)  ;
      //$rec=DB_MSSQL()->execSQL('select * from CardTextView where CardText="'.$pass_id.'"',array('no_indx'=>1,'debug'=>2)) ;
      $rec=DB_MSSQL()->execSQL('select * from CardTextView where CardNumber=dbo.HexToBinary("'.$pass_id_hex.'")',array('no_indx'=>1,'debug'=>0)) ;

      $result=$rec[0] ;
      if (_sizeof($rec[0]))
      {  $rec_person=DB_MSSQL()->execSQL('select * from RptIndividuals where IndividualNdx="'.$rec[0]['IndivNdx'].'"',array('no_indx'=>1,'debug'=>0)) ;
         $result['pkey']=$pass_id ;
         $result['_person']=$rec_person[0] ;
         $result['_person']['pkey']=$result['_person']['IndividualNdx'] ;
         $result['_person']['obj_name']=$result['_person']['LastName'].' '.$result['_person']['FirstName'] ;
         $result['time_from']=strtotime($result['_person']['TempStart']) ;
         $result['time_to']=strtotime($result['_person']['TempStop']) ;
         $result['enabled']=($result['Disabled'])? 0:1 ;
         $result['r_data']=$result['time_from'] ;
      }

      return($result) ;
     // t1.TempStop>"2015-11-26"
     // t1.TempStop>"2015-11-26"
   }

//==============================================================================================================================
//
//  турникеты
//
//==============================================================================================================================

function get_full_zone_path($zone_id,$to_level=0)
{
  if (is_object(SKD()->tree[$zone_id])) return(implode(' / ',SKD()->tree[$zone_id]->get_arr_parent_name(array('to_level'=>$to_level)))) ;
  else return(SKD()->tree) ;
}

// получение информации по устройству на основе его ID
function get_device_by_pkey($id,$options=array())
{ $rec=execSQL_van('select * from obj_site_skd where pkey="'.$id.'" and clss in (601,602,606) and enabled=1') ;
  if ($rec['pkey'])
  {   if ($options['check_reboot'] and $rec['reboot'])
      { reboot_engine() ;
        execSQL_update('update obj_site_skd set reboot=0 where pkey='.$rec['pkey']) ;
      }
      //$this->prepare_public_info_to_terminal($rec,$options) ;
      $rec['_adres']=implode(' / ',SKD()->tree[$rec['parent']]->get_arr_parent_name(array('to_level'=>1))) ;
      $rec['_allow_zones']=SKD()->tree[$rec['parent']]->get_arr_child() ;
      $rec['_controller_in_id']=($rec['in_out_reverse'])? $rec['cont2_ID']:$rec['cont1_ID'] ;
      $rec['_controller_out_id']=($rec['in_out_reverse'])? $rec['cont1_ID']:$rec['cont2_ID'] ;
  }
  return($rec);
}
// получение информации по устройству на основе его ID
function get_device_by_id($id,$options=array())
{ $rec=execSQL_van('select * from obj_site_skd where device_ID="'.$id.'" and clss in (601,602,606,241) and enabled=1') ;
  if ($rec['pkey'])
  {   if ($options['check_reboot'] and $rec['reboot'])
      { reboot_engine() ;
        execSQL_update('update obj_site_skd set reboot=0 where pkey='.$rec['pkey']) ;
      }
      //$this->prepare_public_info_to_terminal($rec,$options) ;
      $rec['_adres']=implode(' / ',SKD()->tree[$rec['parent']]->get_arr_parent_name(array('to_level'=>1))) ;
      $rec['_allow_zones']=SKD()->tree[$rec['parent']]->get_arr_child() ;
      $rec['_controller_in_id']=($rec['in_out_reverse'])? $rec['cont2_ID']:$rec['cont1_ID'] ;
      $rec['_controller_out_id']=($rec['in_out_reverse'])? $rec['cont1_ID']:$rec['cont2_ID'] ;
      $rec['in_zone_id']=$rec['parent'.($rec['level']-1)] ;
      $rec['out_zone_id']=$rec['parent'.($rec['level']-2)] ;

  }
  return($rec);
}

// получаем инфу по точке прохода: зону доступа, направление прохода, опции
// данные могут прийти как от терминала=точка прохода (старые версии, где к терминалу подключен один турникет)
// так и от терминала, к которому подкючены несколько турникетов (возможно, в разных зонах)
// в этом случае надо по controller найти точку прохода, привязанную к данному терминалу, и уже по этой точке прохода
// определить направление и зону доступа
function get_passage_point($terminal_id,$options=array())
{
    $rec_terminal=execSQL_van('select * from obj_site_skd where device_ID="'.$terminal_id.'" and clss in (601,602,606) and enabled=1') ;
    if ($rec_terminal['pkey'])
    {
        if ($options['check_reboot'] and $rec_terminal['reboot'])
        {
            reboot_engine() ;
            execSQL_update('update obj_site_skd set reboot=0 where pkey='.$rec_terminal['pkey']) ;
        }
        if ($rec_terminal['clss']==606)
        {
            if (isset($rec_terminal['emergency_open_type'])) $emergency_open_type=$rec_terminal['emergency_open_type']; else $emergency_open_type=0;
            if (isset($rec_terminal['create_self_monitor_group'])) $create_self_monitor_group=$rec_terminal['create_self_monitor_group']; else $create_self_monitor_group=0;
            if ($options['zone_name']) $rec_terminal_601=execSQL_van('select * from obj_site_skd where clss=601 and terminal_id='.$terminal_id.' and zone_name="'.$options['zone_name'].'"  and enabled=1') ;
            if ($options['controller'] and !_sizeof($rec_terminal_601)) $rec_terminal_601=execSQL_van('select * from obj_site_skd where clss=601 and terminal_id='.$terminal_id.' and controller_id='.$options['controller'].'  and enabled=1') ;
            if (!_sizeof($rec_terminal_601))
                LOGS()->reg_log('get_passage_point','Не передан CONTROLLER_ID или ZONE_NAME для терминала '.$terminal_id) ;
            else
            {
                $rec_terminal=$rec_terminal_601;
                $rec_terminal['emergency_open_type']=$emergency_open_type;
                $rec_terminal['create_self_monitor_group']=$create_self_monitor_group;
            }
        }

        //$this->prepare_public_info_to_terminal($rec_terminal,$options) ;
        $rec_terminal['_adres']=implode(' / ',SKD()->tree[$rec_terminal['parent']]->get_arr_parent_name(array('to_level'=>1))) ;
        $rec_terminal['_allow_zones']=SKD()->tree[$rec_terminal['parent']]->get_arr_child() ;
        $rec_terminal['_controller_in_id']=($rec_terminal['in_out_reverse'])? $rec_terminal['cont2_ID']:$rec_terminal['cont1_ID'] ;
        $rec_terminal['_controller_out_id']=($rec_terminal['in_out_reverse'])? $rec_terminal['cont1_ID']:$rec_terminal['cont2_ID'] ;
        $rec_terminal['in_zone_id']=$rec_terminal['parent'.($rec_terminal['level']-1)] ;
        $rec_terminal['out_zone_id']=$rec_terminal['parent'.($rec_terminal['level']-2)] ;

    }
    return($rec_terminal);
}
//  получение информации по устройству на основе его IP
function get_device_by_IP($IP,$options=array())
{ $rec=execSQL_van('select * from obj_site_skd where ip="'.$IP.'" and clss in (601,602,606) and enabled=1') ;
  if ($rec['pkey'])
  {   $rec['_adres']=implode(' / ',SKD()->tree[$rec['parent']]->get_arr_parent_name(array('to_level'=>1))) ;
      $rec['_allow_zones']=SKD()->tree[$rec['parent']]->get_arr_child() ;
  }
  return($rec);
}

function get_arr_turn_ID_by_zone($zone_id)
{  $arr=execSQL_line('select device_ID from obj_site_skd where parent in("'.$this->tree[$zone_id]->get_list_child().'") and clss in (601,606) and enabled=1 order by indx') ;
   return($arr) ;
}

function turn_save($pkey,$rec)
{  $rec_turn=execSQL_van('select * from obj_site_skd where pkey="'.$pkey.'" and clss in (601,606)') ;
   $res=0 ;
   if ($rec_turn['pkey']) { $res=update_rec_in_table('obj_site_skd',$rec,'pkey='.$pkey) ;
                                if (_sizeof($rec)) foreach($rec as $id=>$value) if ($rec_turn[$id]!=$value) $log[]=$id.': '.$rec_turn[$id].' => '.$value ;
                                //if (_sizeof($log)) LOGS()->reg_log('Изменение данных турникета',implode('<br>',$log),array('terminal'=>$rec_turn)) ;
                              }
   return($res) ;
}

//==============================================================================================================================
//
//  РМ охранника
//
//==============================================================================================================================

// получение информации по прсоналу АСПМО
function get_bp_name_by_id($id)
{ $name=execSQL_value('select obj_name from obj_site_skd where pkey="'.$id.'" and clss=604') ;
  return($name);
}

// получение информации по прсоналу АСПМО
function get_ARM_by_IP($IP,$options=array())
{ $rec=execSQL_van('select * from obj_site_skd where IP="'.$IP.'" and clss=602 and enabled=1') ;
  if ($rec['pkey'])
  {   if ($options['check_reboot'] and $rec['reboot'])
      { reboot_engine() ;
        execSQL_update('update obj_site_skd set reboot=0 where pkey='.$rec['pkey']) ;
      }
      //$this->prepare_public_info_to_terminal($rec,$options) ;
  }
  return($rec);
}

function get_ARM_by_uid($uid,$options=array())
{ $rec=execSQL_van('select t1.pkey as arm_id,t1.obj_name as arm_name,t2.pkey as bp_id,t2.obj_name as bp_name,t3.pkey as zone_id,t3.obj_name as zone_name
                    from obj_site_skd t1
                    left join obj_site_skd t2 on t2.pkey=t1.parent
                    left join obj_site_skd t3 on t3.pkey=t2.parent
                    where t1.UID="'.$uid.'" and t1.clss=605 and t1.enabled=1') ;
  if ($rec['arm_id']) execSQL_update('update obj_site_skd set URL="'._CUR_PAGE_DIR.'",ip="'.IP.'" where pkey='.$rec['arm_id']) ;
  return($rec);
}


//==============================================================================================================================
//
//  получение статистики по заданному интервалу времени
//
//==============================================================================================================================

  function get_stats($t1,$t2)
  { $stats=array() ;
    //echo date('d.m.Y H:i:s',$t1).'<br>' ;
    //echo date('d.m.Y H:i:s',$t2).'<br>' ;

    // число поданных заявок на разовые пропуска
    //$recs=execSQL('select * from view_req_one_persons where enabled=1 and time_from>='.$t1.' and time_to<='.$t2) ;
    $recs=execSQL('select * from view_req_one_persons where enabled=1 and time_from>='.$t1.' and time_to<='.$t2) ;
    if (_sizeof($recs)) foreach($recs as $rec) $stats['req_one'][$rec['person_status']]++ ;

    // число выданных разовых пропусков
    //$recs=execSQL('select * from '.BP()->table_pass_one.' where enabled=1 and time_from>='.$t1.' and time_to<='.$t2) ;
    $recs=execSQL('select * from '.BP()->table_pass_one.' where enabled=1 and time_from>='.$t1.' and time_to<='.$t2) ;
    if (_sizeof($recs)) foreach($recs as $rec) $stats['pass_one'][$rec['status']]++ ;

    // число выданных временных пропусков
    //$recs=execSQL('select * from '.BP()->table_pass_time.' where enabled=1 and c_data>='.$t1.' and c_data<='.$t2) ;
    $recs=execSQL('select * from '.BP()->table_pass_time.' where enabled=1 and c_data>='.$t1.' and c_data<='.$t2) ;
    if (_sizeof($recs)) foreach($recs as $rec) $stats['pass_time'][$rec['status']]++ ;

    // проходы по разовым пропускам
    //$recs=execSQL_row('select access_type,count(pkey) from obj_site_gate_events where enabled=1 and c_data>='.$t1.' and c_data<='.$t2.' and pass_type=1 and result=1 and evt_type=2 group by access_type') ;
    $recs=execSQL_row('select access_type,count(pkey) from view_gate_events_all where enabled=1 and c_data>='.$t1.' and c_data<='.$t2.' and pass_type=1 and result=1 and evt_type=2 group by access_type') ;
    //damp_array($recs);
    $stats['skip_one_in']=$recs[0] ;
    $stats['skip_one_out']=$recs[1] ;

    // проходы по временным пропускам
    //$recs=execSQL_row('select access_type,count(pkey) from obj_site_gate_events where enabled=1 and c_data>='.$t1.' and c_data<='.$t2.' and pass_type=2  and evt_type=2 group by access_type') ;
    $recs=execSQL_row('select access_type,count(pkey) from view_gate_events_all where enabled=1 and c_data>='.$t1.' and c_data<='.$t2.' and pass_type=2  and evt_type=2 group by access_type') ;
    $stats['skip_time_in']=$recs[0] ;
    $stats['skip_time_out']=$recs[1] ;

    // посещения по разовым пропускам
    //'result'=>2,'event'=>2,'pass_type'=>1,
    // $usl[]='evt_type=2' ;
    // $usl[]='(access_type=0 or (access_type=1 and evt_out_id is null))' ;
    // $usl[]='result=1' ;
    //
//    $value=execSQL_value('select count(pkey) from view_gate_events_all
//                        where enabled=1 and
//                        c_data>='.$t1.' and c_data<='.$t2.' and
//                        pass_type=1 and /* разовые пропуска */
//                        evt_type=2 and  /* проходы */
//                        result=1 and    /* успешные */
//                        (access_type=0 or (access_type=1 and evt_out_id is null)) /* запись по входу или запись по выходу, если не было входа*/
//                      ') ;
    $value=execSQL_value('select count(pkey) from view_gate_events_all
                        where enabled=1 and
                        c_data>='.$t1.' and c_data<='.$t2.' and
                        pass_type=1 and /* разовые пропуска */
                        evt_type=2 and  /* проходы */
                        result=1 and    /* успешные */
                        (access_type=0 or (access_type=1 and evt_out_id is null)) /* запись по входу или запись по выходу, если не было входа*/
                      ') ;
    $stats['skip_one_all']=$value ;


    return($stats) ;

  }

  // отправляем уведомление о модерации посетителей
  // старая система с автоматической отправкой уведомлений
  // id сотрудников для согласования брались из зоны доступа
  function send_req_moderation_email($zone_id,$req_id,$arr_pers_to_moderation)
  { $html='' ; $text_mail_debug='';
    ob_start() ;
    $recs_moderator=$this->get_recs_moderator_to_zone($zone_id) ;
    $rec_req=BP()->get_req_one_by_id($req_id) ;

    if (_sizeof($recs_moderator)) foreach($recs_moderator as $rec)
    { if (!$rec['UID'])
        { $rec['UID']=md5(uniqid(rand(),true)) ;
          update_rec_in_table(SKD()->table_zone,array('UID'=>$rec['UID']),'pkey='. $rec['pkey'].' and clss=603',array('no_update_rdata'=>1)) ; // no_update_rdata: иначе работает некорректно, так как обновлятся значение r_data и обновление происходит всегда
        }
      $html='<h3>Добрый день, '.$rec['obj_name'].'!</h3><br>
             <p>Поступила новая заявка № '.$req_id.' на разовый пропуск, требующая Вашего согласования:</p>
             <ul>'.implode('<br>',$arr_pers_to_moderation).'</ul>
             <p><strong>Цель визита</strong></p>
             <p>'.$rec_req['comment'].'</p>
             <p>Разрешить или запретить посещение Вы можете на странице <a href="'._PATH_TO_SITE.'/portal/req_one/moderate/'.$req_id.'/'.$rec['UID'].'.html">согласовании заявки</a></p>
             <br>
             <br>
             <p>С уважением, Служба автоматического оповещения ЭСМО-СКД.</p>
             ' ;
      ob_start() ;
      MAILS()->send_mail($rec['email'],'Согласование заявок на разовые пропуска',$html,array('reg_events'=>1,'debug'=>0));
      $text_mail_debug=ob_get_clean()  ;
    }
    $text=ob_get_clean() ;
    $req_reffer=$req_id.'.324' ;
    //LOGS()->reg_log('send_req_moderation_email',$text_mail_debug.'<br>'.$html.'<br>'.$text,array('reffers'=>array($req_reffer))) ;
    LOGS()->reg_log('Отправка заявки на согласование','<ul>'.implode('',$arr_pers_to_moderation).'</ul>'.$text,array('reffers'=>array(MEMBER()->reffer,$req_reffer))) ;
  }

  // отправляем уведомление о модерации РП  конктетному сотруднику
  // вызывается через AJAX со страницы согласования заявок на разовые пропуска https://10.133.16.226/cab/bp/req/one/to_moderate/
  // $req_id - номер заявки
  // $moderator_id - id персонала, кому будет отправлена заявка на модерацию
  function send_req_moderation_email2($req_id,$moderator_id)
  { $html='' ; $text_mail_debug='';
    ob_start() ;
    $rec_req=BP()->get_req_one_by_id($req_id) ;
    $rec_moderator=PERSONAL()->get_personal_by_id($moderator_id) ;

    $arr_pers_to_moderation=array() ;
    if (_sizeof($rec_req['_persons'])) foreach($rec_req['_persons'] as $rec_person) $arr_pers_to_moderation[]='<li>'.$rec_person['obj_name'].'</li>' ;

    if (!$rec_moderator['uid'])
    { $rec_moderator['uid']=md5(uniqid(rand(),true)) ;
      update_rec_in_table(PERSONAL()->table_name,array('uid'=>$rec_moderator['uid']),'pkey='. $rec_moderator['pkey'].' and clss=211',array('no_update_rdata'=>1)) ; // no_update_rdata: иначе работает некорректно, так как обновлятся значение r_data и обновление происходит всегда
    }

      $req_title='разовый пропуск' ;
      if ($rec_req['tmc']) $req_title='разовый пропуск на ТМЦ' ;
      if ($rec_req['car_number']) $req_title='разовый пропуск на автомобиль' ;

      $html='<h3>Добрый день, '.$rec_moderator['obj_name'].'!</h3><br>
             <p>Поступила новая заявка № '.$req_id.' на '.$req_title.', требующая Вашего согласования:</p>
             <ul>'.implode('',$arr_pers_to_moderation).'</ul>
             <p><strong>Цель визита</strong></p>
             <p>'.$rec_req['comment'].'</p>
             <p>Разрешить или запретить посещение Вы можете на странице <a href="'._PATH_TO_SITE.'/portal/req_one/moderate/'.$req_id.'/'.$rec_moderator['uid'].'.html">согласовании заявки</a></p>
             <br>
             <br>
             <p>С уважением, Служба автоматического оповещения ЭСМО-СКД.</p>
             ' ;
      ob_start() ;
      MAILS()->send_mail($rec_moderator['email'],'Согласование заявок на разовые пропуска',$html,array('reg_events'=>1,'debug'=>0));
      $text_mail_debug=ob_get_clean()  ;


    update_rec_in_table('obj_site_request_pass',array('status'=>1),'pkey='.$req_id) ; // 1 - заявка отправлена на согласование

    // сохраняем в справочнике, куда следует человек = ID модератора
    // чтобы в следующий раз его имя подтягивалось автоматически
    $rec_mod=$this->get_rec_of_mod_zone_persons($rec_req) ;
    if (!$rec_mod) $this->insert_to_mod_zone_persons($rec_req,$moderator_id) ;
    else           $this->update_mod_zone_persons($rec_mod['pkey'],$moderator_id) ;


    $text=ob_get_clean() ;
    LOGS()->reg_log('Отправка заявки на согласование','<a href="'._PATH_TO_SITE.'/portal/req_one/moderate/'.$req_id.'/'.$rec_moderator['uid'].'.html" target=_blank>ссылка на согласование</a><br><ul>'.implode('',$arr_pers_to_moderation).'</ul>'.$text,array('reffers'=>array(MEMBER()->reffer,$rec_moderator['_reffer'],$rec_req['_reffer']))) ;
    return(1);
  }

  function update_mod_zone_persons($id,$moderator_id)
  {
      update_rec_in_table('obj_site_mod_zone_persons',array('personal_id'=>$moderator_id),'pkey='.$id) ;
  }

  function insert_to_mod_zone_persons($rec_req,$moderator_id)
  {
     adding_rec_to_table('obj_site_mod_zone_persons',array('clss'=>616,
                                                           'zone_id'=>$rec_req['to_zone_id'],
                                                           'org_name'=>$rec_req['to_org_name'],
                                                           'org_id'=>$rec_req['to_org_id'],
                                                           'otdel_id'=>$rec_req['to_otdel_id'],
                                                           'personal_id'=>$moderator_id
                                                           )) ;
  }

  function  get_rec_of_mod_zone_persons($rec_req)
  {  if ($rec_req['to_org_id'] and $rec_req['to_otdel_id']) $_usl[]='org_id='.$rec_req['to_org_id'].' and otdel_id='.$rec_req['to_otdel_id'] ;
     else                                                   $_usl[]='org_name="'.addslashes($rec_req['to_org_name']).'"' ;
     $usl=implode(' and ',$_usl) ;
     $rec=execSQL_van('select t1.pkey,t1.zone_id,t1.org_name,t1.org_id,t1.otdel_id,t1.personal_id,t2.obj_name as personal_name from obj_site_mod_zone_persons t1 left join obj_site_personals t2 on t2.pkey=t1.personal_id where '.$usl) ;
     return($rec) ;
  }

/*
$_SESSION['descr_clss'][616]['fields']['zone_id']=array('type'=>'int(11)') ;
$_SESSION['descr_clss'][616]['fields']['org_id']=array('type'=>'int(11)') ;
$_SESSION['descr_clss'][616]['fields']['otdel_id']=array('type'=>'int(11)') ;
$_SESSION['descr_clss'][616]['fields']['org_name']=array('type'=>'varchar(255)') ;
$_SESSION['descr_clss'][616]['fields']['personal_id']=array('type'=>'int(11)') ;
*/

  function check_zone_to_moderation($id)
  {  $ids=$this->tree[$id]->get_list_parent($id) ;
     $res=execSQL_value('select max(pass_moderation) from '.$this->table_zone.' where pkey in ('.$ids.')') ;
     return(($res)? 1:0) ;
  }


  function get_recs_moderator_to_zone($id)
  {   $ids=$this->tree[$id]->get_list_parent($id) ;
      $recs=execSQL('select pkey,obj_name,email,UID from '.SKD()->table_zone.' where parent in ('.$ids.') and clss=603 and enabled=1 order by indx') ;
      return($recs) ;
  }


 function zone_create($form_data)
 { $id_exist=execSQL_value('select pkey from '.$this->table_zone.' where obj_name="'.$form_data['name'].'" and clss=600 and parent='.$form_data['zone_id']) ;
   if ($id_exist)  return(array('error'=>'Зона доступа уже зарегистрирована в системе')) ;

   $data=array() ;
   $data['clss']=600 ;
   $data['parent']=$form_data['zone_id'] ;
   $data['obj_name']=$form_data['name'] ;
   $this->full_parent_levels_to_rec($data['parent'],$data) ;

   $id=adding_rec_to_table('obj_site_skd',$data) ;
   $result['info']='Зона доступа успешно добавлена, ID='.$id ;
   $result['id']=$id ;
   $result['reffer']=$id.'.'._DOT('obj_site_skd')->pkey ;
   LOGS()->reg_log('Конфигурация устройств СКД','Добавление зоны доступа "'.$form_data['name'].'" в зону '.SKD()->get_full_zone_path($form_data['zone_id']),array('reffers'=>array($result['reffer']))) ;
        return($result) ;
    }

    function zone_edit($form_data)
    {
        $old_name = execSQL_value('select obj_name from '.$this->table_zone.' where pkey='.$form_data['id']);
        $res=execSQL_update('update '.$this->table_zone.' set obj_name="'.$form_data['name'].'", parent="'.$form_data['parent'].'" where pkey='.$form_data['id']);
        if ($res) $result['info']='Зона доступа успешно изменена, ID='.$form_data['id'] ;
        $result['reffer']=$form_data['id'].'.'._DOT('obj_site_skd')->pkey ;
        LOGS()->reg_log('Конфигурация устройств СКД','Переименовали зону доступа "'.$old_name.'" в зону доступа "'.$form_data['name'].'"',array('reffers'=>array($result['reffer']))) ;
        return $result;
    }

    function zone_delete($pkey)
    {
        $rec_terminal=execSQL('select * from '.$this->table_zone.' where pkey='.$pkey) ;
        $res = execSQL_update('delete from '.$this->table_zone.' where pkey='.$pkey) ;
        if ($res) $result['info']='Зона доступа успешно удалена, ID='.$rec_terminal['id'] ;
        $result['reffer']=$pkey.'.'._DOT('obj_site_skd')->pkey ;
        LOGS()->reg_log('Конфигурация устройств СКД','Удалили зону доступа "'.$rec_terminal['obj_name'].'"',array('reffers'=>array($result['reffer']))) ;
    }

	// заполняет поля parent1,parent3,parent3... для item
 function full_parent_levels_to_rec($parent,&$data)
 {  $rec_parent_section=execSQL_van('select pkey,level,parent,parent1,parent2,parent3,parent4,parent5,parent6,parent7,parent8,parent9 from obj_site_skd where pkey='.$parent) ;
    if ($rec_parent_section['level']) for ($i=1;$i<$rec_parent_section['level'];$i++)  $data['parent'.$i]=$rec_parent_section['parent'.$i] ;
    else $data['parent1']=1 ;
    $data['level']=$rec_parent_section['level']+1 ;
    $data['parent'.$rec_parent_section['level']]=$data['parent'] ;
 }

 function on_event_examination_result($options=array()) {
    $rec_mo=ESMO()->get_mo_by_id($options['mo_id']) ;

    if ($rec_mo['dopusk']==1) {
        $person_rec=PERSONAL()->get_personal_by_id($rec_mo['member_id']);
        if ($person_rec['pkey']) {

        }
    } elseif ($rec_mo['dopusk']==2) {
        $person_rec=PERSONAL()->get_personal_by_id($rec_mo['member_id']);
        if ($person_rec['pkey']) {

        }
    }
 }

 function send_message_to_redis($pass,$timeout) {
     if ($pass and $timeout) {
         try
         {
             $redis = new Redis();
             $redis->connect($GLOBALS['LS_redis_skd_host'],$GLOBALS['LS_redis_skd_port']);
             if ($GLOBALS['LS_redis_skd_password']) $redis->auth($GLOBALS['LS_redis_skd_password']);
             $redis->set($pass,json_encode(['1']),$timeout);
         }
         catch(RedisException $e)
         {
             //exit('Connect error');
         }
     }
 }

 function delete_key_from_redis($pass) {
     if ($pass) {
         try
         {
             $redis = new Redis();
             $redis->connect($GLOBALS['LS_redis_skd_host'],$GLOBALS['LS_redis_skd_port']);
             if ($GLOBALS['LS_redis_skd_password']) $redis->auth($GLOBALS['LS_redis_skd_password']);
             $redis->del($pass);
         }
         catch(RedisException $e)
         {
             //exit('Connect error');
         }
     }
 }

    function terminal_create($form_data)
    {
        $id_exist = execSQL_value('select pkey from ' . $this->table_name . ' where clss=606 and device_ID="' . $form_data['id'] . '"');
        if ($id_exist) return (array('error' => 'Терминал с данным ID уже зарегистрирован в системе'));

        $id_exist = execSQL_value('select pkey from ' . $this->table_name . ' where clss=606 and ip="' . $form_data['ip'] . '"');
        if ($id_exist) return (array('error' => 'Терминал с данным IP уже зарегистрирован в системе'));

        $data = array();
        $data['clss'] = 606;
        $data['parent'] = $form_data['zone_id'];
        $data['obj_name'] = $form_data['name'];
        $data['device_ID'] = $form_data['id'];
        $data['ip'] = $form_data['ip'];
        $data['version'] = $form_data['version'];
//        $this->full_parent_levels_to_rec($data['parent'],$data) ;
        $id = adding_rec_to_table('obj_site_skd', $data);
        $result['info'] = 'Турникет успешно добавлен, ID=' . $id;
        $result['id'] = $id;
        $result['reffer'] = $id . '.' . _DOT('obj_site_skd')->pkey;
        LOGS()->reg_log('Конфигурация устройств СКД', 'Добавление турникета "' . $form_data['name'] . '" в зону ' . SKD()->get_full_zone_path($form_data['zone_id']), array('reffers' => array($result['reffer'])));
        return ($result);
    }

    function terminal_edit($form_data)
    {
        $old_data = execSQL_van('select obj_name,device_ID,ip from ' . $this->table_name . ' where pkey=' . $form_data['id']);
        if ($old_data['device_ID'] != $form_data['terminal_id']) {
            $id_exist = execSQL_value('select pkey from ' . $this->table_name . ' where clss=606 and device_ID="' . $form_data['terminal_id'] . '"');
            if ($id_exist) return (array('error' => 'Турникет с данным ID уже зарегистрирован в системе'));
        }
        if ($old_data['ip'] != $form_data['ip']) {
            $id_exist = execSQL_value('select pkey from ' . $this->table_name . ' where clss=606 and ip="' . $form_data['ip'] . '"');
            if ($id_exist) return (array('error' => 'Турникет с данным IP уже зарегистрирован в системе'));
        }

        $res = execSQL_update('update ' . $this->table_name . ' set obj_name="' . $form_data['name'] . '", device_ID=' . $form_data['terminal_id'] . ', ip="' . $form_data['ip'] . '", parent=' . $form_data['parent'] . ' where pkey=' . $form_data['id']);
        execSQL_update('update ' . $this->table_name . ' set terminal_ID=' . $form_data['terminal_id'] . ' where terminal_ID=' . $old_data['device_ID']);

        if ($res) $result['info'] = 'Турникет успешно изменен, ID=' . $form_data['id'];
        $result['reffer'] = $form_data['id'] . '.' . _DOT('obj_site_skd')->pkey;
        LOGS()->reg_log('Конфигурация устройств СКД', 'Изменения в терминале №' . $form_data['id'] .
            ' name: "' . $old_data['obj_name'] . '" => "' . $form_data['name'] .
            '"; device_ID: "' . $old_data['device_ID'] . '" => "' . $form_data['terminal_id'] .
            '"; ip: "' . $old_data['ip'] . '" => "' . $form_data['ip'] .'"', array('reffers' => array($result['reffer'])));
        return $result;
    }

    function terminal_delete($pkey)
    {
        $rec_terminal=execSQL('select * from '.$this->table_name.' where pkey='.$pkey) ;
        $res = execSQL_update('delete from '.$this->table_name.' where pkey='.$pkey) ;
        if ($res) $result['info']='Турникет/точка досутпа успешно удален, ID='.$rec_terminal['id'] ;
        $result['reffer']=$pkey.'.'._DOT('obj_site_skd')->pkey ;
        LOGS()->reg_log('Конфигурация устройств СКД','Удалили терминал/точку доступа "'.$rec_terminal['obj_name'].'"',array('reffers'=>array($result['reffer']))) ;
    }

    function access_point_create($form_data)
    {
        $data = array();
        $zone = ($form_data['zone'] == 'zone0') ? 'Вход' : 'Выход';
        $data['obj_name'] = $form_data['name'] . '/' . $zone;
        $id_exist = execSQL_value('select pkey from ' . $this->table_name . ' where obj_name="' . $data['obj_name'] . '" and clss=601 and parent=' . $form_data['terminal']);
        if ($id_exist) return (array('error' => 'Точка доступа уже зарегистрирована в системе'));

        $id_exist = execSQL_van('select pkey,obj_name,parent,device_ID from ' . $this->table_name . ' where pkey="' . $form_data['terminal'] . '"');
        $data['parent'] = $id_exist['parent'];
        $data['terminal_ID'] = $id_exist['device_ID'];
        $data['clss'] = 601;
        $data['zone_name'] = $form_data['zone'];
        $data['access'] = ($form_data['zone'] == 'zone0') ? 1 : 2;
        $data['med_group_id'] = $form_data['med_group'];
//        $this->full_parent_levels_to_rec($data['parent'],$data) ;
        $id = adding_rec_to_table('obj_site_skd', $data);
        $result['info'] = 'Точка доступа успешно добавлена, ID=' . $id;
        $result['id'] = $id;
        $result['reffer'] = $id . '.' . _DOT('obj_site_skd')->pkey;
        LOGS()->reg_log('Конфигурация устройств СКД', 'Добавление точки доступа "' . $form_data['name'] . '" в зону ' . SKD()->get_full_zone_path($id_exist['parent']), array('reffers' => array($result['reffer'])));
        return ($result);
    }

    function access_point_edit($form_data)
    {
        $old_data = execSQL_van('select pkey,obj_name,zone_name from ' . $this->table_name . ' where pkey=' . $form_data['id']);
        $access = ($form_data['zone'] == 'zone0') ? 1 : 2;
        $zone = ($form_data['zone'] == 'zone0') ? 'Вход' : 'Выход';
        $data['obj_name'] = $form_data['name'] . '/' . $zone;
        $res = execSQL_update('update ' . $this->table_name . ' set obj_name="' . $data['obj_name'] . '", zone_name="' . $form_data['zone'] . '", access=' . $access . ', med_group_id=' . $form_data['med_group'] . ', parent=' . $form_data['parent'] . ' where pkey=' . $form_data['id']);
        if ($res) $result['info'] = 'Точка доступа успешно изменена, ID=' . $form_data['id'];
        $result['reffer'] = $form_data['id'] . '.' . _DOT('obj_site_skd')->pkey;
        LOGS()->reg_log('Конфигурация устройств СКД', 'Изменения точки доступа №' . $form_data['id'] .
            ' name: "' . $old_data['obj_name'] . '" => "' . $data['obj_name'] .
            '"; zone_name: "' . $old_data['zone_name'] . '" => "' . $form_data['zone'] . '"', array('reffers' => array($result['reffer'])));
        return $result;
    }

}



?>
