<?php
$__functions['init'][]='_print_order_site_vars' ;
$__functions['boot_site'][]='_print_order_site_boot' ;

function PRINT_ORDER() {
  if (isset($_SESSION['print_order_system'])) {
    return($_SESSION['print_order_system']);
  } else {
    $_SESSION['print_order_system']=new c_print_order_system();
    return($_SESSION['print_order_system']);
  }
}


function _print_order_site_vars()
{
    $_SESSION['init_options']['print_order']['debug']=0 ;
}

function _print_order_site_boot($options)
{
  create_system_modul_obj('print_order',$options) ;

}


class c_print_order_system
{
    public $type_table='print_order_types';
    public $test_file_folder='/storage/print_order/';
    public $pathToSaveFiles = _TEMP_DIR;
    public $print_order_setting=[
        'enable_stamp'=>[
            'title'=>'Печатать штамп',
            'values'=>[
                1=>'Да',
                0=>'Нет',
            ]
        ],
        'stamp_on_page'=>[
            'title'=>'Штамп на странице',
            'active_if'=>'enable_stamp',
        ],
        'stamp_X'=>[
            'title'=>'Смещение штампа по X',
            'active_if'=>'enable_stamp',
        ],
        'stamp_Y'=>[
            'title'=>'Смещение штампа по Y',
            'active_if'=>'enable_stamp',
        ],
        'stamp_resize'=>[
            'title'=>'Увеличить штамп в N раз',
            'active_if'=>'enable_stamp',
        ],
        'stamp_rotate_degrees'=>[
            'title'=>'Повернуть штамп на угол',
            'active_if'=>'enable_stamp',
        ],
        'type_of_get_PDF'=>[
            'title'=>'PDF для печати',
            'values'=>[
                'common'=>'С общего URL',
                'own'=>'С собственного URL',
            ]
        ],
        'consider_time'=>[
            'title'=>'Учитывать срок действия наряда',
            'values'=>[
                1=>'Да',
                0=>'Нет',
            ]
        ],
        'common_URL'=>[
            'title'=>'Общий URL',
            'active_if'=>[
                'name'=>'type_of_get_PDF',
                'value'=>'common',
            ],
        ],
    ];

    function __construct($create_options=array())
    {
	    ENGINE()->reg_ext('print_order','Печать нарядов')  ;
    }

    function declare_menu_items_3($page)
    {
        $page->menu['/cab/print_order/']=array('title'=>'Печать нарядов',
            'class'=>'fa fa-print'
        ) ;
    }

    function get_print_order_by_pkey($pkey) {
        $result=[];
        if ((int) $pkey) {
            $result=execSQL_van('select * from '.PRINT_ORDER()->type_table.' where pkey='.$pkey);
            if (_sizeof($result)) $result['_ext_info']=unserialize($result['ext_info']);
        }
        return $result;
    }

    function get_print_order_by_id($id) {
        $result=[];
        if ((int) $id) {
            $result=execSQL_van('select * from '.PRINT_ORDER()->type_table.' where type='.$id);
            if (_sizeof($result)) $result['_ext_info']=unserialize($result['ext_info']);
        }
        return $result;
    }

    //добавление штампа на изображение
    function put_stamp_on_image($path_to_image,$rec_mo,$print_order_data) {
        if (file_exists($path_to_image) and _sizeof($rec_mo) and _sizeof($print_order_data)) {
            include_once(_DIR_EXT.'/image_print/i_image_print.php') ;
            if (class_exists('image_print_MO_sertificate_stamp_for_order')) {
                //формируем штамп о МО
                $IM = new image_print_MO_sertificate_stamp_for_order($rec_mo);
                $stamp_content = $IM->get_image_content();
                $stamp_image_path=$this->pathToSaveFiles.('temp_'.md5(rand(1,100000))).'.png';
                file_put_contents($stamp_image_path,$stamp_content);
                $stamp_image = new Imagick($stamp_image_path);
                if ($print_order_data['stamp_resize']) {
                    //ограничиваем увеличение изображения больше чем в 10 раз (скрипт вылетает если указано очень большое значение)
                    if ($print_order_data['stamp_resize']>10) $print_order_data['stamp_resize']=10;
                    $stamp_image->adaptiveResizeImage(round($stamp_image->getImageWidth()*$print_order_data['stamp_resize']),round($stamp_image->getImageHeight()*$print_order_data['stamp_resize']));
                }
                if ($print_order_data['stamp_rotate_degrees']) $stamp_image->rotateImage(new ImagickPixel('none'), $print_order_data['stamp_rotate_degrees']);

                $background_image = new Imagick($path_to_image);

                //объединеям с иходным изображением
                $background_image->setImageColorspace($stamp_image->getImageColorspace() );
                $background_image->compositeImage($stamp_image, $stamp_image->getImageCompose(), $print_order_data['stamp_X'], $print_order_data['stamp_Y']);
                $background_image->writeImage($path_to_image); //replace original background

                $stamp_image->destroy();
                $background_image->destroy();
            }
        }
    }

    //проверка персоны на возможность печати наряда
    function check_print_order($rec_person) {
        if ($rec_person['print_order_type']) {
            $print_order_rec=$this->get_print_order_by_id($rec_person['print_order_type']);
            if (_sizeof($print_order_rec)) {
                if ($print_order_rec['_ext_info']['consider_time']) {
                    if (time()<$rec_person['print_order_time_from'] or time()>$rec_person['print_order_time_to']) return [false,['Не началось/завершилось время действия наряда сотрудника']];
                }
                switch ($print_order_rec['_ext_info']['type_of_get_PDF']) {
                    case 'common':
                        if (!$print_order_rec['_ext_info']['common_URL']) return [false,['Не указан общий URL']];
                        break;
                    case 'own':
                        if (!$rec_person['print_order_URL']) return [false,['Не указан URL файла сотрудника']];
                        break;
                }
                return [true,[]];
            } else {
                return [false,['У сотрудника указан не существующий тип наряда: '.$rec_person['print_order_type']]];
            }
        } else {
            return [false,['Не указан тип наряда сотрудника']];
        }
    }

    //получает файл для печати наряда и добавляет на него штамп
    function combine_print_order_images($rec_person,$rec_mo,$options=[]) {
        $files=[]; $file_URL=''; $fname='';
        if ($rec_person['print_order_type']) {
            //проверка и получение описание типа печати наряда
            $cur_print_order = $this->get_print_order_by_id($rec_person['print_order_type']);

            //получение URL документа для печати
            if ($options['test_file_path'])  {
                $fname=_DIR_TO_ROOT.$options['test_file_path'];
            } else {
                switch ($cur_print_order['_ext_info']['type_of_get_PDF']) {
                    case 'common':
                        if ($cur_print_order['_ext_info']['common_URL']) {
                            $file_URL=$cur_print_order['_ext_info']['common_URL'].$rec_person['uid'].'.pdf';
                        }
                        break;
                    case 'own':
                        $file_URL=$rec_person['print_order_URL'];
                        break;
                }
            }

            //получение и обработка файла
            if (_sizeof($cur_print_order) and $file_URL) {
                //получение файла
                $fname=mb_str_replace('://','',$file_URL);
                $fname=$this->pathToSaveFiles.safe_file_names($fname) ;
                $result=IO()->doPut_v2($file_URL, '', '') ;
                if ($result['status']==200) {
                    file_put_contents($fname,$result['content']);
                    unset($result);
                }
            }

            if ($fname) $files=$this->convert_uploaded_file_to_jpg($fname);

            if ($options['copy_files_to_print_order_dir'] and _sizeof($files)) {
                foreach ($files['file_name'] as $image_name) {
                    if (copy(PRINT_ORDER()->pathToSaveFiles.$image_name,_DIR_TO_ROOT.PRINT_ORDER()->test_file_folder.$image_name)) {
                        $image_info[]=getimagesize(_DIR_TO_ROOT.PRINT_ORDER()->test_file_folder.$image_name);
                    }
                }
            }

            if (_sizeof($files['file_name'])) {
                //если удалось преобразовать исходный файл, то проверяем нужен ли штамп
                if ($cur_print_order['_ext_info']['enable_stamp'] and ((int) $cur_print_order['_ext_info']['stamp_on_page']>=0)) {
                    //если штамп включен и указана страница для штампа
                    if ($cur_print_order['_ext_info']['stamp_on_page']<=_sizeof($files['file_name'])) {
                        //если указанная страница для штампа есть в списке файлов
                        PRINT_ORDER()->put_stamp_on_image(_DIR_TO_ROOT.'/temp/'.$files['file_name'][$cur_print_order['_ext_info']['stamp_on_page']],$rec_mo,$cur_print_order['_ext_info']);
                    }
                }
            }
        }
        return $files;
    }

    function convert_uploaded_file_to_jpg($fname) {
        $files=[];
        if (mime_content_type($fname)=='application/pdf') {
            //если файл PDF преобразовываем его в JPG
            $saved_file_name=basename($fname) ;
            $images = new Imagick();
            $images->setResolution(300,300);
            $images->readImage($fname);
            if (_sizeof($images)) {
                foreach ($images as $i=>$image) {
                    $saved_img_file_name=$saved_file_name.'_page_'.$i.'.jpg' ;
                    $saved_img_file_dir=$this->pathToSaveFiles.$saved_file_name.'_page_'.$i.'.jpg' ;
                    $image->setImageFormat("jpg");
                    $image->writeImage($saved_img_file_dir);
                    $files['file_name'][]=$saved_img_file_name ;
                }
            } else echo 'Не удалось открыть PDF для преобразования<br>' ;
        } elseif (mime_content_type($fname)=='image/jpg') {
            $files['file_name'][]=$fname  ;
        }
        return $files;
    }

    function view_print_order_images($files,$options=[]) {
        if (_sizeof($files)) {
            foreach ($files as $i=>$file_name) {
                ?>
                <img class="preview_image <?if ($options['img_class']) echo $options['img_class']?>" <?if ($options['set_img_id']) echo 'id="order_page_'.$i.'"';?> src="<?echo _PATH_TO_SITE.'/temp/'.$file_name?>">
                <?
            }
        }
    }

}



?>
