<?php

//$__functions['init'][]='_pl_site_vars' ;
$__functions['boot_site'][]='_pl_site_boot' ;


function _pl_site_boot($options)
{
    create_system_modul_obj('pl',$options) ;
}

function PL() {if (is_object($GLOBALS['pl_system_new'])) return($GLOBALS['pl_system_new']);$GLOBALS['pl_system_new']=new c_pl_system();return($GLOBALS['pl_system_new']);} ;

/*
function PL()
{
    if (isset($GLOBALS['pl_system'])) return ($GLOBALS['pl_system']);
    $GLOBALS['pl_system'] = new c_pl_system();
    return ($GLOBALS['pl_system']);
}*/


class c_pl_system
{
    var $modul_name = 'Путевой лист';
    var $modul_abbr = 'ПЛ';
    var $modul_descr = 'Электронный документооборот по путевому листу';

    var $arr_packet_titul_status=
        [ 1=> // пакет с титул 1
                           [1=>'Пакет получен',
                            2=>'Пакет принят',
                            3=>'Подготовлен ответ титул 2, ожидается подпись пакета ответа',
                            4=>'Подготовлен ответ титул 2 и подпись',
                            5=>'Ответ титул2 отдан по запросу',
                            6=>'Пакет отклонен',
                            7=>'Пакет просрочен',
                           ],
         2=> // пакет с титул 2
                           [1=>'Ожидает МО',
                            2=>'Ожидает ЭЦП',
                            3=>'Ожидает вручения',
                            4=>'Вручен',
                            7=>'Пакет просрочен',
                           ],
         5=> // пакет с титул 5
                          [1=>'Пакет получен',
                           2=>'Пакет принят',
                           6=>'Пакет отклонен',
                           7=>'Пакет просрочен',
                          ],

         6=> // пакет с титул 2
                           [1=>'Ожидает МО',
                            2=>'Ожидает ЭЦП',
                            3=>'Ожидает вручения',
                            4=>'Вручен',
                            7=>'Пакет просрочен',
                           ]
        ] ;

    var $arr_packet_titul_status_color=
        [ 1=> // пакет с титул 1
                           [1=>'Пакет получен',
                            2=>'Пакет принят',
                            3=>'Подготовлен ответ титул 2, ожидается подпись пакета ответа',
                            4=>'Подготовлен ответ титул 2 и подпись',
                            5=>'Ответ титул2 отдан по запросу',
                            6=>'Пакет отклонен',
                            7=>'<span class=red>Пакет просрочен</span>',
                           ],
         2=> // пакет с титул 2
                           [1=>'Ожидает МО',
                            2=>'Ожидает ЭЦП',
                            3=>'Ожидает вручения',
                            4=>'Вручен',
                            7=>'<span class=red>Пакет просрочен</span>',
                           ],
         5=> // пакет с титул 5
                          [1=>'Пакет получен',
                           2=>'Пакет принят',
                           6=>'Пакет отклонен',
                           7=>'<span class=red>Пакет просрочен</span>',
                          ],

         6=> // пакет с титул 2
                           [1=>'Ожидает МО',
                            2=>'Ожидает ЭЦП',
                            3=>'Ожидает вручения',
                            4=>'Вручен',
                            7=>'<span class=red>Пакет просрочен</span>',
                           ]
        ] ;

    var $arr_packet_mode= [ 1=>'Входящий',
                            2=>'Исходящий',
                           ] ;

    var $arr_packet_type= [ 1=>'Титул 1',
                            2=>'Титул 2',
                            //3=>'Титул 3',
                            //4=>'Титул 4',
                            5=>'Титул 5',
                            6=>'Титул 6',
                           ] ;

    var $arr_packet_error=[ 1=>'Водитель не найден',
                            2=>'Авто не найден',
                            3=>'МО не пройден',
                           ] ;

    var $arr_status=[       1=>'Пакет получен',
                            2=>'Пакет обработан',
                            3=>'Подготовлен ответ',
                            4=>'Ответ отправлен',
                           ] ;

    function __construct()
    {
        ENGINE()->reg_ext('pl','Путевой лист') ;
    }

    function install()
    {
        include_once('m_pl_admin.php');
        _pl_install_modul(1);
    }

    function declare_menu_items_1($page)
    { // только для клиента

        $menu = array('title' => 'Путевой лист',
            'class' => 'fa fa-car',
            //'allow_access_to_rol' => 8,
            'items' => array('/cab/pl/' => 'Путевой лист')
        );

        //if (MEMBER()->rol == 1) $page->menu['/cab/moduls/']['items']['/cab/pl/'] = $menu;
        //else
        $page->menu['/cab/pl/'] = $menu;

    }

    function declare_menu_items_4($page)
    {
        //$page->menu['/cab/setting/']['items']['/cab/cryptopro/']='Криптопро' ;
    }

    function save_temp_setting($setting)
    {
        $session_uid=ENGINE()->generate_UID() ;
        SETUP()->save_json_setting('/temp/register_session_'.$session_uid.'.json',$setting);
        return($session_uid) ;

    }

    function load_temp_setting($session_uid)
    {
        $setting=[] ;
        if ($session_uid!='0' and $session_uid!="") $setting=SETUP()->load_json_setting('/temp/register_session_'.$session_uid.'.json') ;
        return($setting) ;
    }


    function client_create($form_data)
    {
        include_once('i_pl_client.php') ;
        $result=\esmo\pl\i_pl_client::create($form_data) ;
        return($result) ;
    }

    function get_client_by_id($id)
    {
        $rec=ESMO_FR()->get_client_by_id($id) ;
        //include_once('i_pl_client.php') ;
        //$rec=\esmo\pl\i_pl_client::get_rec_by_id($id) ;
        $this->prepare_public_info_to_client($rec) ;
        return($rec) ;
    }

    function prepare_public_info_to_client(&$rec)
    {
        $rec['__href']='/cab/pl/clients/card/'.$rec['pkey'].'/' ;
    }

    function prepare_ext_info_client(&$rec)
    {
        // получаем объект из json, так как ранее данные по организации получаем из ddata.ru в виде объекта
        $rec['_ext_info']=json_decode($rec['ext_info'],true) ;
    }

    function get_packet_by_id($id)
    {
        include_once(_DIR_TO_MODULES.'/pl/i_pl_packets.php') ;
        $rec=\esmo\pl\i_pl_packets::get_rec_by_id($id) ;
        if ($rec['pkey'])
        {
            $rec['drivers']=\esmo\pl\i_pl_packet_driver::get_recs_by_packet_id($id) ;
        }

        return($rec) ;
    }
    function packet_register($data,$options=[])
    {
        $packet_data=$data ;
        unset($packet_data['drivers']) ;
        $result_packet_create=\esmo\pl\i_pl_packets::create($packet_data) ;
        if ($result_packet_create['result'])
        { if (_sizeof($data['drivers'])) foreach ($data['drivers'] as $driver)
          {   //damp_array($options);
              $driver_data=$driver ;
              $driver_data['packet_id']=$result_packet_create['id'] ;
              $result_driver=\esmo\pl\i_pl_packet_driver::create($driver_data) ;
              $result_packet_create['drivers'][]=$result_driver['id'] ;
           }
        }
        return($result_packet_create) ;
    }

    function packet_save($packet_id,$data,$options=[])
    {
        $packet_data=$data ;
        unset($packet_data['drivers']) ;
        $result=\esmo\pl\i_pl_packets::save($packet_id,$packet_data) ;
        if ($result['result'])
        { if (_sizeof($data['drivers'])) foreach ($data['drivers'] as $pkey=>$driver)
          {   //damp_array($options);
              $driver_data=$driver ;
              if ($options['create_drivers'])
              { $driver_data['packet_id']=$packet_id ;
                //damp_array($driver_data,'$driver_data!!!');
                $result_driver=\esmo\pl\i_pl_packet_driver::create($driver_data) ;
                //damp_array($result_driver);
                //if ($result_driver['debug']) echo $result_driver['debug'].'<br>' ;

                $result['drivers'][]=$result_driver['id'] ;
              }
              else
              { \esmo\pl\i_pl_packet_driver::save($pkey,$driver_data,['packet_id'=>$packet_id]) ;
                $result['drivers'][]=$driver['pkey'] ;
              }

          }
        }
        return($result) ;
    }

    // регистрируем ПЛ на основании титула 1, если ПЛ остуствует в БД
    // если присутствует - ничего не делаем
    function put_list_register($packet_id)
    {
        include_once(_DIR_TO_MODULES.'/pl/i_pl_put_list.php') ;
        $rec_packet=$this->get_packet_by_id($packet_id) ;

        $rec_pl=\esmo\pl\i_pl_put_list::get_rec_by_uid($rec_packet['pl_uid']) ;
        if (!$rec_pl['pkey'])
        {  $data=['number'=>$rec_packet['pl_number'],
                  'uid'=>$rec_packet['pl_uid'],
                  'date'=>$rec_packet['pl_date'],
                  //'driver_id'=>$rec_packet['driver_id'],
                  'car_id'=>$rec_packet['car_id'],
                  'packet_titul1_id'=>$packet_id,
                 ] ;
            $result=\esmo\pl\i_pl_put_list::create($data) ;
            $pl_id=$result['id'] ;

        }
        else
        { \esmo\pl\i_pl_put_list::save($rec_pl['pkey'],['packet_titul1_id'=>$packet_id]) ;
          $pl_id=$rec_pl['pkey'] ;
        }
        return($pl_id) ;

    }

    function put_list_save($pl_id,$data)
    {
        include_once(_DIR_TO_MODULES.'/pl/i_pl_put_list.php') ;
        \esmo\pl\i_pl_put_list::save($pl_id,$data) ;
    }

    function get_driver_by_fio($fio)
    {
        $rec_driver=execSQL_van('select * from obj_site_personals where obj_name="'.trim($fio).'" and enabled=1 and clss=211') ;
        return($rec_driver) ;
    }

    function get_driver_by_license($seria,$number,$date)
    {   $rec_driver=[] ;
        $t=strtotime($date);
        if ($seria and $number and $t)
    {
        $rec_driver=execSQL_van('select * from obj_site_personals where driving="'.trim($seria).' '.trim($number).'" and driving_date='.strtotime($date).' and enabled=1 and clss=211') ;
        }
        return($rec_driver) ;
    }

    function get_driver_by_uid($uid)
    {   $rec_driver=[] ;
        if ($uid)
        {
            $rec_driver=execSQL_van('select * from obj_site_personals where uid="'.$uid.'" and enabled=1 and clss=211') ;
        }
        return($rec_driver) ;
    }

    function get_car_by_number($fio)
    {
        $rec_driver=execSQL_van('select * from obj_site_personals where obj_name="'.trim($fio).'" and enabled=1 and clss=211') ;
        return($rec_driver) ;
    }

    // генерируем имя типа
    // ON_PTLSSOBTS_2AE107EE4B9-CC1F-4039-8AFC-3FA6E47B8A48_2AE107EE4B9-CC1F-4039-8AFC-3FA6E47B8A48_2AE107EE4B9-CC1F-4039-8AFC-3FA6E47B8A48_2AE107EE4B9-CC1F-4039-8AFC-3FA6E47B8A48_0_20230616_5012988b-a0b8-4893-92c9-2a9b7061bcb3
    function generate_titul_file_name()
    {
        $name=ENGINE()->generate_UID() ;
        return($name);
    }

    function get_file_dir_by_packet_id($titul_id,$packet_id,$ext='xml')
    {
        $file_name='titul_'.$titul_id.'_'.$packet_id.'.'.$ext ;
        $file_dir=_DIR_TO_ROOT.'/public/pl_titul/'.$file_name ;
        return($file_dir) ;
    }

    function parse_xml_packet_to_array($fname)
    {   $data=null ;
        $XML_source = file_get_contents($fname);
        $obj_xml=simplexml_load_string($XML_source) ;
        if ($obj_xml!==false) $data = json_decode(json_encode((array) $obj_xml), true);
        return($data) ;
    }

    // обработка входящего сохраненного пакета с титул 1
    // сопоставляет водителя по ФИО
    // сопоставляет авто по номеру
    function tituls1_parsing()
    {
        $recs_packets=execSQL('select * from pl_packets where packet_type=1 and status=1') ;
        $results=[] ;
        if (sizeof($recs_packets)) foreach ($recs_packets as $recs_packet)
        {
            $results[]=$this->titul1_packet_parsing($recs_packet['pkey']) ;
        }
        print_2x_arr($results);
    }

    function titul1_packet_parsing($packet_id,$options=[])
    {
       $result=[] ; $rec_driver_esmo=[] ; $rec_car=[] ; $errors=[] ;
       $rec_packet=$this->get_packet_by_id($packet_id) ;
       //print_2x_arr([$rec_packet]);

       if (sizeof($rec_packet['drivers'])) foreach ($rec_packet['drivers'] as $id=>$driver_data)
       {   //print_2x_arr([$driver_data]);
           if ($driver_data['driver_uid']) $rec_driver_esmo=$this->get_driver_by_uid($driver_data['driver_uid']) ;
           elseif ($driver_data['driver_license_seria'] and $driver_data['driver_license_number'] and $driver_data['driver_license_data']) $rec_driver_esmo=$this->get_driver_by_license($driver_data['driver_license_seria'],$driver_data['driver_license_number'],$driver_data['driver_license_data']) ;
           //print_2x_arr([$rec_driver_esmo]);
           // если водитель найден - берем с базы ЭСМО только его ID
           if ($rec_driver_esmo['pkey']) $rec_packet['drivers'][$id]['driver_id']=$rec_driver_esmo['pkey'];
           else if ($driver_data['driver_uid']) $errors['driver_not_found'][]=$driver_data['driver_fio'].' UID '.$driver_data['driver_uid'] ;
           else $errors['driver_not_found'][]=$driver_data['driver_fio'].' ВУ '.$driver_data['driver_license_seria'].' '.$driver_data['driver_license_number'].', дата выдачи '.$driver_data['driver_license_data'] ;
           //damp_array($errors);
       }
       else $errors['driver_not_found'][]='отсутствует информация по водителю';

       // если водитель не найден, пишем в пакет ошибку
       if (sizeof($errors))
       { $comment=implode(';',$errors['driver_not_found']) ;
         //echo 'comment='.$comment.'<br>' ;
         $this->packet_save($packet_id, ['error'=>1,'status'=>6,'comment'=>$errors]) ; // error=1 - водитель не найдень, 6 - пакет отклонен
         $result=ENGINE()->prepare_result(['error'=>'driver_not_found','comment'=>$comment,'packet_id'=>$packet_id]) ;
       }
       else
       {
           $data=[] ;
           $data['car_id']=0;
           $data['status']=2; // 2 - пакет принят,
           if (sizeof($rec_packet['drivers'])) foreach ($rec_packet['drivers'] as $id=>$rec_driver)
           { $data['drivers'][$rec_driver['pkey']]=['driver_uid'=>$rec_driver['driver_uid'],
                                                    'driver_id'=>$rec_driver['driver_id'],
                                                    'driver_fio'=>$rec_driver['driver_fio'],
                                                    'driver_name1'=>$rec_driver['driver_name1'],
                                                    'driver_name2'=>$rec_driver['driver_name2'],
                                                    'driver_name3'=>$rec_driver['driver_name3'],
                                                    'driver_license_seria'=>$rec_driver['driver_license_seria'],
                                                    'driver_license_number'=>$rec_driver['driver_license_number'],
                                                    'driver_license_data'=>$rec_driver['driver_license_data'],
                                                   ] ;
           }
           //damp_array($data);
           $this->packet_save($packet_id, $data) ;

           // если все успешно - создаем новую запись по ПЛ, если она еще не создана
       	   $pl_id=PL()->put_list_register($packet_id) ;

           // сразу создаем пакет titul2, который будет ожидать МО
           if (sizeof($data['drivers'])) foreach ($data['drivers'] as $id=>$rec_driver) $result_packet_register=$this->titul2_create($packet_id,$pl_id,[$rec_driver]) ;
           $packet_titul2_id=$result_packet_register['id'] ;


           $result=ENGINE()->prepare_result(['packet_id'=>$packet_id]) ;

       }
       return($result) ;
    }

    function titul2_create($titul1_packet_id,$pl_id,$data_drivers)
    {
        $rec_packet=$this->get_packet_by_id($titul1_packet_id) ;
        $rec_pl=$this->get_put_list_by_id($pl_id) ;
        $rec_packet_titul2=[] ;
        $rec_packet_titul2['status']=1;
        $rec_packet_titul2['titul1_id']=$rec_packet['pkey'];
        $rec_packet_titul2['packet_mode']=2; // исходящий пакет
        $rec_packet_titul2['packet_type']=2; // титул2
        $rec_packet_titul2['titul_date_from']=$rec_packet['titul_date_from'];
        $rec_packet_titul2['titul_date_to']=$rec_packet['titul_date_to'];
        $rec_packet_titul2['ip']=$_SERVER['SERVER_ADDR'];
        $rec_packet_titul2['file_uid']=$this->generate_titul2_file_uid($rec_packet['file_uid']) ;
        $rec_packet_titul2['pl_id']=$pl_id;
        $rec_packet_titul2['pl_number']=$rec_packet['pl_number'];
        $rec_packet_titul2['pl_uid']=$rec_packet['pl_uid'];
        $rec_packet_titul2['pl_date']=$rec_packet['pl_date'];
        $rec_packet_titul2['car_number']=$rec_packet['car_number'];
        $rec_packet_titul2['drivers']=$data_drivers;
        //$rec_packet_titul2['driver_license_number']=$rec_packet['driver_license_number'];
        //$rec_packet_titul2['driver_license_seria']=$rec_packet['driver_license_seria'];
        //$rec_packet_titul2['driver_fio']=$rec_packet['driver_fio'];
        //$rec_packet_titul2['driver_id']=$rec_packet['driver_id'];
        $rec_packet_titul2['car_id']=$rec_packet['car_id'];
        // регистрируем ответный пакет - будем использовать его id в имени файла
        $result_packet_register=$this->packet_register($rec_packet_titul2,['create_drivers'=>1]) ;
        // статус титул 1 больше не меняем, так как дальше титул 2 живет самостоятельно
        // сохраняем в пакете id ответного пакета с титулом 2
        $this->put_list_save($pl_id, ['packet_titul2_id'=>$result_packet_register['id']]) ;
        return($result_packet_register) ;
    }

    // ставим статус 7 у титулов 2,6 в статусах 1,2 но с просроченным titul_date_to
    function titul_check_status_7()
    {
        execSQL_update('update pl_packets
                        set status=7
                        where packet_type in (2,6) and status in (1,2) and titul_date_to>0 and titul_date_to<'.time()) ;

    }

		// задание планировщика
	  // 1. Отбираем все пакеты 2/6 в статусах 1/2 	и проверяем актуальность МО для них
	  // 2. Отправляем все пакеты, для которые задано mo_id - на подпись

    function titul_check_mo_send_to_sign()
    {   // тип пакета - титул 1
        // статус пакета 1 - принят, ждем МО
        // packet_titul2_id=0 - титул2 еще не сформирован
        ?><h1>Проверка МО для титулов</h1><?
        $recs_packets=execSQL('select pk.*,dr.mo_id
                               from pl_packets pk
                               left join pl_packet_driver dr on dr.packet_id=pk.pkey
                               where pk.packet_type in (2,6) and pk.status in (1,2)
			                   			 order by pk.pkey desc
			    ') ;
       echo 'Найдено <strong>'.sizeof($recs_packets).'</strong> пакетов титул 2,6 в статусе 1,2<br>' ;
        $results=[] ;
				// ищем все титулы, которые
				// - ожидают МО
				// - МО найдено, но титул еще не подписан
				// проверяется актуальность МО для этих титулов. МО может быть как назначен титулу, так и сброшен у титула, если
        if (sizeof($recs_packets)) $results=$this->packet_check_mo_union($recs_packets) ;
        ///damp_array($results);

        ?><h1>Отправка титулов на подпись (только для титулов, фельдшера которых сейчас на смене)</h1><?
        // отправляем на подпись только те пакеты, фельдшера которых сейчас на смене
		   	$recs_packets=$this->get_packets_to_sign() ;
         echo 'Найдено <strong>'.sizeof($recs_packets).'</strong> пакетов титул 2,6 в статусе 2 по фельдшерам на смене<br>' ;
			   $arr=[] ;
				 if (sizeof($recs_packets)) foreach ($recs_packets as $rec) $arr[$rec['group_name']][$rec['doctor_name']]++ ;
				 if (sizeof($recs_packets)) $results=$this->packet_send_xml_to_sign($recs_packets) ;
    }

	function get_packets_to_sign($options=[])
	{
			$packet_id=(int)$_POST['packet_id'];
			$_usl=[] ;
			$_usl[]='dr.mo_id>0' ;
			if ($options['group_id']) $_usl[]='dr.mo_group_id='.$options['group_id'] ;
			if ($options['doctor_id']) $_usl[]='dr.mo_doctor_id='.$options['doctor_id'] ;
			if ($options['packet_id']) $_usl[]='pk.pkey='.$packet_id ;

			$_usl[]='not pk.pkey is null' ;
			$_usl[]='pk.packet_type in (2,6)' ;
			$_usl[]='pk.status in (1,2)' ;
			//$_usl[]='((dr.mo_id>0 and acc.time_login>0 and acc.time_logout=0) or dr.mo_id=0 or dr.mo_id is null)' ;

			$usl_select=(sizeof($_usl))? implode(' and ', $_usl):'false' ;

		$recs_packets=execSQL('select pk.*,
		       											  dr.pkey as driver_id,dr.mo_id,dr.mo_date as mo_c_data,dr.mo_doctor_id as dr_doctor_id,
		                              acc.pkey as doctor_id,acc.obj_name as doctor_name,
		                              grp.pkey as group_id,grp.obj_name as group_name
		                              from pl_packet_driver dr
		                              left join pl_packets pk on pk.pkey=dr.packet_id
		                              left join obj_site_account acc on acc.pkey=dr.mo_doctor_id
		                              left join obj_site_account grp on grp.pkey=dr.mo_group_id
		                              where '.$usl_select.'
		                           	  order by pk.pkey desc
		       			    ') ;
			return($recs_packets) ;
	}



    function titul_check_sign()
    {   // тип пакета - титул 2
        sleep(3) ; // ждем 3 сек чтобы пакеты, отправленные на подпись после titul2_check_mo успели подписаться фельдщером
        // статус пакета - отправлен на подпись
        //$recs_packets=execSQL('select * from pl_packets where packet_type in (2,6) and status=2',2) ;
        $recs_packets=execSQL('select t1.*
                               from pl_packets t1
                               where t1.packet_type in (2,6) and t1.status=2') ;

        $results=[] ;
        if (sizeof($recs_packets)) foreach ($recs_packets as $recs_packet)
        {
            $results[]=$this->titul_packet_check_sign($recs_packet['pkey']) ;
        }
        print_2x_arr($results);
    }

    function get_put_list_by_id($pl_id)
    {
        include_once(_DIR_TO_MODULES.'/pl/i_pl_put_list.php') ;
        $rec=\esmo\pl\i_pl_put_list::get_rec_by_id($pl_id) ;
        return($rec) ;
    }

    function get_put_list_by_uid($pl_uid)
    {
        include_once(_DIR_TO_MODULES.'/pl/i_pl_put_list.php') ;
        $rec=\esmo\pl\i_pl_put_list::get_rec_by_uid($pl_uid) ;
        return($rec) ;
    }

    //обработка входящего пакета титул5
    function titul5_packet_parsing($packet_id,$options=[])
    {
       $result=[] ; $rec_driver=[] ; $rec_car=[] ;
       $rec_packet_titul5=$this->get_packet_by_id($packet_id) ;
       $pl_id=$rec_packet_titul5['pl_id'] ;
       $rec_pl=$this->get_put_list_by_id($pl_id) ;


       $data=[] ;
       $data['status']=2; // 2 - пакет принят,
       //damp_array($data);
       $this->packet_save($packet_id, $data) ;
       $this->put_list_save($pl_id, ['packet_titul5_id'=>$packet_id]) ;

       $recs_titul_drivers=execSQL('select * from pl_packet_driver where packet_id='.$rec_pl['packet_titul1_id']) ;
       if (sizeof($recs_titul_drivers)) foreach ($recs_titul_drivers as $rec_titul_driver)
       {
           $rec_titul_driver['packet_id']=$packet_id ;
           \esmo\pl\i_pl_packet_driver::create($rec_titul_driver) ;

           // сразу на каждого водителя создаем титул 6
           $this->titul6_create($rec_packet_titul5,$rec_titul_driver) ;

       }


       // сразу создаем пакет titul6, который будет ожидать послесменнное МО
       //$result_packet6_register=$this->titul6_create($rec_packet_titul5) ;

       $result=ENGINE()->prepare_result(['packet_id'=>$packet_id]) ;
       return($result) ;
    }

    // создаем запись по пакету титул6 на основе пакета титул5
    function titul6_create($rec_packet_titul5,$rec_titul_driver)
    {
        $rec_packet_titul=[] ;
        $rec_packet_titul['status']=1;
        $rec_packet_titul['pl_id']=$rec_packet_titul5['pl_id'];
        $rec_packet_titul['titul1_id']=$rec_packet_titul5['pkey'];
        $rec_packet_titul['packet_mode']=2; // исходящий пакет
        $rec_packet_titul['packet_type']=6; // титул2
        $rec_packet_titul['titul_date_from']=$rec_packet_titul5['titul_date_from'];
        $rec_packet_titul['titul_date_to']=$rec_packet_titul5['titul_date_to'];
        $rec_packet_titul['file_uid']=$this->generate_titul6_file_uid($rec_packet_titul5['file_uid']) ;
        $rec_packet_titul['ip']=$_SERVER['SERVER_ADDR'];
        $result_packet_register=$this->packet_register($rec_packet_titul) ;
        $this->put_list_save($rec_packet_titul5['pl_id'], ['packet_titul6_id'=>$result_packet_register['id']]) ;

        //$rec_pl=$this->get_put_list_by_id($rec_packet_titul5['pl_id']) ;
        //$recs_titul_drivers=execSQL('select * from pl_packet_driver where packet_id='.$rec_pl['packet_titul1_id']) ;
        //if (sizeof($recs_titul_drivers)) foreach ($recs_titul_drivers as $rec_titul_driver)
        //{
           $rec_titul_driver['packet_id']=$result_packet_register['id'] ;
           \esmo\pl\i_pl_packet_driver::create($rec_titul_driver) ;
        //}

        return($result_packet_register) ;
    }


    function get_mo_to_packets($recs_packets)
    {
        $arr_packet_ids=[] ;
        //print_2x_arr($recs_packets);
        if (sizeof($recs_packets)) foreach ($recs_packets as $rec_packet) $arr_packet_ids[]=$rec_packet['pkey'];
        $driver_ids=execSQL_line('select distinct(driver_id) from pl_packet_driver where packet_id in ('.implode(',',$arr_packet_ids).') and driver_id>0') ;
        // 2 и 6-й титулы всегда по одному водителю в титуле
        $recs_packet_drivers=execSQL('select packet_id,driver_id,mo_id,driver_license_number,driver_license_seria,driver_license_data,driver_name1,driver_name2,driver_name3,pkey from pl_packet_driver where packet_id in ('.implode(',',$arr_packet_ids).')') ;
        $days_stats=execSQL_van('select min(titul_date_from) as from_date,max(titul_date_to) as to_date from pl_packets where pkey in ('.implode(',',$arr_packet_ids).')') ;

        //damp_array($days_stats);
        // получаем все МО водителей от начала текущей даты или срок действия допуска больше начала текущей даты
				//
        $recs_mo=execSQL('select t1.pkey,t1.c_data,t1.member_id,t1.member_name,t1.doctor_id,t1.dopusk,t1.dopusk_time,t1.dopusk_time_end,t1.tk,t1.group_id,t1.doctor_id,t1.group_name,t2.obj_name as doctor_name
                         from '.ESMO()->view_mo_session_now.' t1
                         left join obj_site_account t2 on t2.pkey=t1.doctor_id
                         left join obj_site_account t3 on t3.pkey=t1.group_id
                         where (t1.c_data>='.$days_stats['from_date'].' or t1.dopusk_time_end>='.$days_stats['from_date'].')
                         and t1.member_id in ('.implode(',',$driver_ids).')
                         order by t1.pkey,t1.member_id
                         ') ;
        // получаем массив последних МО сотрудников
        $arr_last_mo=[] ;
        foreach ($recs_mo as $rec) $arr_last_mo[$rec['member_id']]=$rec ;
        $result=[] ; $errors=[] ; $arr_recs_mo=[] ; $drivers_data=[] ;
        if (sizeof($recs_packets)) foreach ($recs_packets as $rec_packet)
        {   //echo 'Пакет ID <strong>'.$rec_packet['pkey'].'</strong>, срок действия от <strong>'.date('d.m.Y',$rec_packet['titul_date_from']).'</strong> до <strong>'.date('d.m.Y',$rec_packet['titul_date_to']).'</strong><br>' ;

            $packet_id=$rec_packet['pkey'] ;
            $driver_id=$recs_packet_drivers[$packet_id]['driver_id'] ;
            $last_mo_data=(isset($arr_last_mo[$driver_id]))? $arr_last_mo[$driver_id]:[] ;
            //echo 'Водитель ID <strong>'.$driver_id.'</strong><br>' ;

            $text_error='' ;
            if (!sizeof($last_mo_data)) $text_error='МО не найден' ;
            else if ($last_mo_data['dopusk']!=1)  $text_error='Последний МО ID '.$last_mo_data['pkey'].', отсутствует допуск' ;
            else if ($rec_packet['packet_type']==2 and $last_mo_data['tk']==1) $text_error='Последний МО ID '.$last_mo_data['pkey'].', неверный тип (НЕ предрейсовый)' ;
            else if ($rec_packet['packet_type']==6 and $last_mo_data['tk']!=1) $text_error='Последний МО ID '.$last_mo_data['pkey'].', неверный тип (НЕ послерейсовый)' ;
            else if ($rec_packet['titul_date_from']>$last_mo_data['dopusk_time_end']) $text_error='Последний МО ID '.$last_mo_data['pkey'].', допуск окончен '.date('d.m.Y',$last_mo_data['dopusk_time_end']).' до начала срока действия титула '.date('d.m.Y',$rec_packet['titul_date_from']) ;
            else if ($rec_packet['titul_date_to'] and $rec_packet['titul_date_to']<$last_mo_data['c_data']) $text_error='Последний МО ID '.$last_mo_data['pkey'].', дата МО '.date('d.m.Y',$last_mo_data['c_data']).' после окончания действия титула '.date('d.m.Y',$rec_packet['titul_date_to']) ;

            $result[$rec_packet['pkey']]=$last_mo_data ;
            $result[$rec_packet['pkey']]['errors']=$text_error ;

        }
        return($result) ;
    }

 		// функция запроса МО сразу по всем водителям
    // 1. проходим по всем пакетам в статусе 1 (ожидают МО)
    // 2. находим все МО из пакетов водителей за период от минимальной даты пакета в наборе
    // 3. если МО не найден, но у пакета статус 2 - ошибку не ставим, так как просто МО ушло из оперативной таблицы
    // 4. если МО найден, и оно не подходит для титула - ставим ошибку, обновляем ID MO у водителя
    function packet_check_mo_union($recs_packets,$options=[])
    {
        $arr_packet_ids=[] ;
        //print_2x_arr($recs_packets);
        if (sizeof($recs_packets)) foreach ($recs_packets as $rec_packet) $arr_packet_ids[]=$rec_packet['pkey'];
        $driver_ids=execSQL_line('select distinct(driver_id) from pl_packet_driver where packet_id in ('.implode(',',$arr_packet_ids).')') ;
        // 2 и 6-й титулы всегда по одному водителю в титуле
        $recs_packet_drivers=execSQL('select packet_id,driver_id,mo_id,driver_license_number,driver_license_seria,driver_license_data,driver_name1,driver_name2,driver_name3,pkey from pl_packet_driver where packet_id in ('.implode(',',$arr_packet_ids).')') ;
        $days_stats=execSQL_van('select min(titul_date_from) as from_date,max(titul_date_to) as to_date from pl_packets where pkey in ('.implode(',',$arr_packet_ids).')') ;

        //damp_array($days_stats);
        // получаем все МО водителей от начала текущей даты или срок действия допуска больше начала текущей даты
        echo 'получаем все МО водителей от '.date('d.m.Y H:i',$days_stats['from_date']).'<br>' ;
        $recs_mo=execSQL('select pkey,c_data,member_id,doctor_id,dopusk,dopusk_time,dopusk_time_end,tk,group_id,doctor_id
                         from '.ESMO()->table_mo_sessions_now.'
                         where (c_data>='.$days_stats['from_date'].' or dopusk_time_end>='.$days_stats['from_date'].') and tk=0
                         and member_id in ('.implode(',',$driver_ids).')
                         order by pkey,member_id
                         ',['debug'=>0]) ;
				// на случай, если в пакетах есть уже записи по МО, которые уже ушли из оперативной таблицы - загрузим их отдельно
			  $arr_old_mo=[] ;
			  if (sizeof($recs_packets)) foreach ($recs_packets as $rec_packet) if ($rec_packet['mo_id'] and !isset($recs_mo[$rec_packet['mo_id']])) $arr_old_mo[$rec_packet['pkey']]=$rec_packet['mo_id'] ;
				if (sizeof($arr_old_mo))
				{
					$recs_mo_old=execSQL('select pkey,c_data,member_id,doctor_id,dopusk,dopusk_time,dopusk_time_end,tk,group_id,doctor_id
													 		  from '.ESMO()->table_mo_sessions.'
													 			where pkey in ('.implode(',',$arr_old_mo).') and tk=0
													 		  order by pkey,member_id
													 ',['debug'=>0]) ;
					if (sizeof($recs_mo_old)) foreach ($recs_mo_old as $id=>$rec_mo_old) $recs_mo[$id]=$recs_mo_old ;
				}


        // получаем массив последних МО сотрудников
        $arr_last_mo=[] ;
        foreach ($recs_mo as $rec) $arr_last_mo[$rec['member_id']]=$rec ;
        //damp_array($arr_last_mo);

        // имеем:
        // - массив МО водителей из ПЛ
        // - массив водителей

        $results=[] ;
        $i=1 ;
				//print_2x_arr($recs_packets);
        if (sizeof($recs_packets)) foreach ($recs_packets as $rec_packet)
        {
            $i++ ;
            $result=[] ;

            $packet_id=$rec_packet['pkey'] ;
            $driver_id=$recs_packet_drivers[$packet_id]['driver_id'] ;
            $last_mo_data=(isset($arr_last_mo[$driver_id]))? $arr_last_mo[$driver_id]:[] ;
            \esmo\pl\i_pl_log::reg($packet_id, 'Последний МО водителя',['mo_id'=>$last_mo_data['pkey'],'check_repeat'=>1]);

            echo '<hr>'.$i.'. Пакет ID <strong>'.$rec_packet['pkey'].'</strong>, срок действия от <strong>'.date('d.m.Y',$rec_packet['titul_date_from']).'</strong> до <strong>'.date('d.m.Y',$rec_packet['titul_date_to']).'</strong>, Водитель ID <strong>'.$driver_id.'</strong><br>' ;

            $text_error='' ;
            if (!sizeof($last_mo_data))
            {
                if ($rec_packet['status']!=2) $text_error='МО не найден' ;
            }
            else if ($last_mo_data['dopusk']!=1)  $text_error='Последний МО ID '.$last_mo_data['pkey'].', отсутствует допуск' ;
            else if ($rec_packet['packet_type']==2 and $last_mo_data['tk']==1) $text_error='Последний МО ID '.$last_mo_data['pkey'].', неверный тип (НЕ предрейсовый)' ;
            else if ($rec_packet['packet_type']==6 and $last_mo_data['tk']!=1) $text_error='Последний МО ID '.$last_mo_data['pkey'].', неверный тип (НЕ послерейсовый)' ;
            else if ($rec_packet['titul_date_from']>$last_mo_data['dopusk_time_end']) $text_error='Последний МО ID '.$last_mo_data['pkey'].', допуск окончен '.date('d.m.Y',$last_mo_data['dopusk_time_end']).' до начала срока действия титула '.date('d.m.Y',$rec_packet['titul_date_from']) ;
            //else if ($rec_packet['titul_date_to']<$last_mo_data['c_data']) $text_error='Последний МО ID '.$last_mo_data['pkey'].', дата МО '.date('d.m.Y',$last_mo_data['c_data']).' после окончания действия титула '.date('d.m.Y',$rec_packet['titul_date_to']) ;
            else if ($rec_packet['titul_date_to']<time()) $text_error='Пакет просрочен, срок действия титула по '.date('d.m.Y',$rec_packet['titul_date_to']) ;

            if ($text_error)
            { \esmo\pl\i_pl_log::reg($packet_id, $text_error,['mo_id'=>$last_mo_data['pkey'],'check_repeat'=>1]);
							$drivers_data=[] ; // // удаляем запись по МО из записи по водителю
							$drivers_data[$recs_packet_drivers[$packet_id]['pkey']]=['mo_id'=>0,
																																			 'mo_date'=>0,
																																			 'mo_doctor_id'=>0,
																																			 'mo_group_id'=>0,
																																			] ;
							$packet_status=($rec_packet['titul_date_to']<time())? 7:1 ;
							$this->packet_save($packet_id, ['error'=>3,
                                              'status'=>$packet_status,
                                              'comment'=>[$text_error],
																							'drivers'=>$drivers_data
                                             ]
                                ) ;
              echo 'Поиск МО: <span class="red">'.$text_error.'</span><br>' ;
							// надо удалить пакет, который, возможно, был создан ранее
							$titul_fname=$this->get_file_dir_by_packet_id($rec_packet['packet_type'],$packet_id) ;
							if (file_exists($titul_fname)) unlink($titul_fname);
            }
            else if ($last_mo_data['pkey']) // если МО найден - формируем XML ответ - титул 2
            {     echo 'Подходящий последний МО водителя: <span class="green">ID '.$last_mo_data['pkey'].' от '.date('d.m.Y',$last_mo_data['c_data']).'</span><br>' ;
                  \esmo\pl\i_pl_log::reg($packet_id, 'Найдено МО водителя',['mo_id'=>$last_mo_data['pkey'],'check_repeat'=>1]);
                  $titul_fname=$this->get_file_dir_by_packet_id($rec_packet['packet_type'],$packet_id) ;
                  $prev_mo_id=$recs_packet_drivers[$packet_id]['mo_id'] ; // берем ранее сохраненный id MO - если с прошлого раза не подписался
                  if (!$prev_mo_id) $prev_mo_id=0 ;
                  echo 'Для водителя ID <strong>'.$driver_id.'</strong> найден МО ID <strong>'.$last_mo_data['pkey'].'</strong><br>' ;
                  if ($last_mo_data['pkey']!=$prev_mo_id or $rec_packet['status']!=2)
                  {   $drivers_data=[] ; // будет сохранено в записи по водителю
                      $drivers_data[$recs_packet_drivers[$packet_id]['pkey']]=['mo_id'=>$last_mo_data['pkey'],
																																							 'mo_date'=>$last_mo_data['c_data'],
																																							 'mo_doctor_id'=>$last_mo_data['doctor_id'],
																																							 'mo_group_id'=>$last_mo_data['group_id'],
																																							] ;

                      $this->packet_save($packet_id, ['status'=>2, // мо найден, пакет отправлен на подпись
                                                      'error'=>0,
                                                      'drivers'=>$drivers_data
                                                   ]
                                     ) ;

                      if ($rec_packet['packet_type']==2) $this->put_list_save($rec_packet['pl_id'], ['mo1_id'=>$last_mo_data['pkey']]) ;
                      if ($rec_packet['packet_type']==6) $this->put_list_save($rec_packet['pl_id'], ['mo2_id'=>$last_mo_data['pkey']]) ;

                      echo '<div class=green>Обновлены данные по статусу и МО пакета</div>' ;
                  }
		  						else echo 'Обновление статусу или МО пакета не требуется<br>' ;


                  $result=ENGINE()->prepare_result(['comment'=>'Титул '.$rec_packet['packet_type'].' найдено МО ','packet_id'=>$rec_packet['pkey']]) ;
              }
             $results[]=$result ;
        }

        return($results) ;
    }

    // функция запроса МО сразу по всем водителям
	    // при наличии МО с действующим пропуском - подготавливает XML титул 2 и отправляет его на подпись фельдшеру
	    // пакет с титулом 2 уже зарегистрирован ранее, при приеме пакета с титул1
	    // 2-й и 6-й титул - один водитель в титуле
	    // более не используется
    function packet_send_xml_to_sign($recs_packets,$options=[])
    {	  ?><strong>Отправляем пакет титула на подпись, передан список из <?echo sizeof($recs_packets)?> МО</strong><br><?
        $arr_packet_ids=[] ;
        //print_2x_arr($recs_packets);
        if (sizeof($recs_packets)) foreach ($recs_packets as $rec_packet) $arr_packet_ids[]=$rec_packet['pkey'];
        // 2 и 6-й титулы всегда по одному водителю в титуле
        $recs_packet_drivers=execSQL('select packet_id,driver_id,mo_id,driver_license_number,driver_license_seria,driver_license_data,driver_name1,driver_name2,driver_name3,pkey
                                      from pl_packet_driver
                                      where packet_id in ('.implode(',',$arr_packet_ids).')') ;


				//print_2x_arr($recs_packets);
			  $arr_active_doctors=execSQL('select pkey,obj_name,group_id from obj_site_account where rol=2 and smena=1') ;
				$arr_active_doctors_by_group_id=[] ;
				if (sizeof($arr_active_doctors)) foreach ($arr_active_doctors as $rec) $arr_active_doctors_by_group_id[$rec['group_id']]=$rec;


        $results=[] ; $stats_send_mess=[] ;
        $i=1 ;
        if (sizeof($recs_packets)) foreach ($recs_packets as $rec_packet)
        {   echo '<hr>'.$i.'. Пакет ID <strong>'.$rec_packet['pkey'].'</strong>, срок действия от <strong>'.date('d.m.Y',$rec_packet['titul_date_from']).'</strong> до <strong>'.date('d.m.Y',$rec_packet['titul_date_to']).'</strong><br>' ;
            $i++ ;


            $packet_id=$rec_packet['pkey'] ;
            $driver_id=$recs_packet_drivers[$packet_id]['driver_id'] ;
            $last_mo_data=['c_data'=>$rec_packet['mo_c_data'],
                           'group_id'=>$rec_packet['group_id'],
                           'group_name'=>$rec_packet['group_name'],
                           'doctor_id'=>$rec_packet['doctor_id'],
                           'doctor_name'=>$rec_packet['doctor_name'],
                           ];
						$doctor_id=(int)$rec_packet['doctor_id'] ;
						$group_id=(int)$rec_packet['group_id'] ;

						$is_doctor_change=false;
						if ($GLOBALS['LS_pl_allow_active_doctor_sign_all'] and !isset($arr_active_doctors[$doctor_id]))
							{
								echo 'Заменям доктора в титуле<br>' ;
								$last_mo_data['doctor_id']=$arr_active_doctors_by_group_id[$group_id]['pkey'] ;
								$last_mo_data['doctor_name']=$arr_active_doctors_by_group_id[$group_id]['obj_name'] ;
								$rec_packet['doctor_id']=$last_mo_data['doctor_id'] ;
								$is_doctor_change=true ;
							}

            //\esmo\pl\i_pl_log::reg($packet_id, 'Последний МО водителя',['mo_id'=>$last_mo_data['pkey'],'check_repeat'=>1]);
            echo 'Водитель ID <strong>'.$driver_id.'</strong><br>' ;
						// ОТПРАВЛЯЕМ ПАКЕТ ТОЛЬКО АКТИВНОМУ ДОКТОРУ
						if (isset($arr_active_doctors[(int)$rec_packet['doctor_id']]))
            {     $titul_fname=$this->get_file_dir_by_packet_id($rec_packet['packet_type'],$packet_id) ;
                  $mo_id=$recs_packet_drivers[$packet_id]['mo_id'] ; // берем ранее сохраненный id MO - если с прошлого раза не подписался
                  echo 'Для водителя ID <strong>'.$driver_id.'</strong> найден МО ID <strong>'.$mo_id.'</strong><br>' ;
                  if (!file_exists($titul_fname) or $is_doctor_change)
                  {   echo "Будет сформирован XML титула<br>" ;
                      $xml_cont='' ;
                      if ($rec_packet['packet_type']==2) $xml_cont=$this->prepare_titul2_xml($rec_packet,$recs_packet_drivers[$packet_id],$last_mo_data) ;
                      if ($rec_packet['packet_type']==6) $xml_cont=$this->prepare_titul6_xml($rec_packet,$recs_packet_drivers[$packet_id],$last_mo_data) ;

                      if ($options['test']) {?><textarea style="width:100%;height:500px;"><?echo iconv('windows-1251', 'utf-8', $xml_cont) ?></textarea><?}
                      echo '<div class="green">Сохраняем XML в файл: '.hide_server_dir($titul_fname).'</div>' ;
                      $len=file_put_contents($titul_fname, $xml_cont) ;
                      \esmo\pl\i_pl_log::reg($packet_id, 'Подготовлен XML титула, '.$len.' байт');

                  }
                  else
                  { echo '<div class="green">Формирование нового титула не требуется</div>' ;
                    \esmo\pl\i_pl_log::reg($packet_id, 'Используем подтовленную ранее XML',['check_repeat'=>1]);
                    echo 'Получаем XML из файла: '.hide_server_dir($titul_fname).'<br>' ;
                    $xml_cont=file_get_contents($titul_fname);
                  }

                  // отправляем данные на подпись
                  // подпись выполняется асинхронно через РМ фельдшера
                  // как только будет сохранен файл подписи
                  // задание планировщика его увидит и поставит статус 4 - подпись готова
                  // отправляем на подпись полученное сообщение
                  // будет пройден только первый эдемент массива $rec_mo или делать через each
								  if ($stats_send_mess[$last_mo_data['doctor_id']]<200)
                  {
                      echo 'Отправляем пакет на подпись в группу <strong>'.$last_mo_data['group_name'].'</strong> ID '.$last_mo_data['group_id'].', доктору <strong>'.$last_mo_data['doctor_name'].'</strong> ID '.$last_mo_data['doctor_id'].'<br>' ;
                      //$rec_group=ACCOUNTS()->get_group_by_id($rec_mo['group_id'])

                      $result_send=$this->send_to_sign_xml_mess($packet_id,$xml_cont,$last_mo_data['group_id'],$last_mo_data['doctor_id'],$options) ;
                      if ($result_send['status']==204)
                      { $stats_send_mess[$last_mo_data['doctor_id']]++ ;

                          \esmo\pl\i_pl_log::reg($packet_id, 'Пакет отправлен на подпись',['group_id'=>$last_mo_data['group_id'],'doctor_id'=>$last_mo_data['doctor_id']]) ;
                          // uid подписи надо сохранить в пакете титулом2 так как подписывается ответ титул2
                          // status=2: Пакет отправлен на подпись

                          $this->packet_save($packet_id, ['status'=>2, // мо найден, пакет отправлен на подпись
                                                          'error'=>0,
                                                          'obj_name'=>'',
                                                          'xml_size'=>mb_strlen($xml_cont),
                                                          'xml_md'=>md5($xml_cont),
                                                         ]
                                             ) ;
                      }
                  }
                  else
                  { echo 'Превышен лимит отправки пакетов фельдшеру на подпись<br>' ;

                  }

                  $result=ENGINE()->prepare_result(['comment'=>'Титул '.$rec_packet['packet_type'].' сформрован и отправлен на подпись','packet_id'=>$rec_packet['pkey']]) ;
              }
					  else $result=ENGINE()->prepare_result(['comment'=>'Титул '.$rec_packet['packet_type'].' не отправлен - фельдшер отсутствует','packet_id'=>$rec_packet['pkey']]) ;
            $results[]=$result ;


        }

        //damp_array($stats_send_mess);
        return($results) ;
    }


    function titul_packet_check_sign($packet_id,$options=[])
    {   $result=[] ;
        $rec_packet=$this->get_packet_by_id($packet_id) ;
        $sign_uid='packet_xml_'.$packet_id ;
        $temp_sign_fname=_TEMP_DIR.'data_'.$sign_uid.'.data.sig' ;
				if (file_exists($temp_sign_fname))
					{ if ($options['debug']) echo 'Подпись подготовлена<br>' ;
						\esmo\pl\i_pl_log::reg($packet_id, 'Обнаружена подпись пакета');
						$sign_content=file_get_contents($temp_sign_fname) ;
						// подпись в файле будет храниться в бинарном виде
						$sign_content_bin=base64_decode($sign_content) ;
						// переносим подпись в директорию с титулами
						$titul2_sign_fname=$this->get_file_dir_by_packet_id($rec_packet['packet_type'],$rec_packet['pkey'],'sign') ;
						if ($options['debug']) echo $titul2_sign_fname ;
						file_put_contents($titul2_sign_fname, $sign_content_bin) ;
						if (file_exists($titul2_sign_fname))
						{   // добавляем проверку md5 подписанного файла
								$titul_fname=$this->get_file_dir_by_packet_id($rec_packet['packet_type'],$packet_id) ;
								$md5=md5_file($titul_fname);
								if ($rec_packet['xml_md']==$md5)
								{
												\esmo\pl\i_pl_log::reg($packet_id, 'MD5 пакета не изменилось');

										$sign_content_size=filesize($titul2_sign_fname) ;
										// status=3: Исходящий пакет - подписан
										$this->packet_save($packet_id, ['status'=>3,'sign_size'=>$sign_content_size]) ;
										//  status=4: Входящий пакет - Подготовлен ответ титул 2 и подпись
										// стутус титул 1 не меняем, так как возникает дублирование статусов связанных титулов
										//$this->packet_save($rec_packet['titul1_id'], ['status'=>4]) ;
										$result=ENGINE()->prepare_result(['comment'=>'Титул 2 подписан','packet_id'=>$rec_packet['pkey']]) ;
								}
								else
								{ \esmo\pl\i_pl_log::reg($packet_id, 'Изменилась MD5 пакета, подпись отклонена');

									$result=ENGINE()->prepare_result(['error'=>'error_packet_md5',
																										'comment'=>'Изменилась MD5 пакета, подпись отклонена',
																										'packet_id'=>$rec_packet['pkey']]) ;

								}
						}
						else $result=ENGINE()->prepare_result(['error'=>'error_move_file_sign','comment'=>'Не удалось пеместить файл подписи в '.$titul2_sign_fname,'packet_id'=>$rec_packet['pkey']]) ;
					}
				else
					{ $result=ENGINE()->prepare_result(['error'=>'sign_not_found','comment'=>'Подпись не найдена','packet_id'=>$rec_packet['pkey']]) ;
						echo 'Файл '.$temp_sign_fname.' не найден<br>' ;
					}
        return($result) ;
    }

    private $recs_doctor_account=[] ;
    private $recs_doctor_group=[] ;
    private $recs_med_org=[] ;

    // $recs_mo -в ключе pkey записи driver в пакете
    // столько записей, сколько водителей имеют МО
    function prepare_titul2_xml($rec_packet_titul2,$rec_driver,$last_mo_data)
      {  ob_start() ;
         $rec_packet_titul1=$this->get_packet_by_id($rec_packet_titul2['titul1_id'])  ;
    	 $imp = new DOMImplementation; // Creates an instance of the DOMImplementation class
    	 $xml_doc = $imp->createDocument("",""); // Creates a DOMDocument instance
    	 $xml_doc->encoding = 'windows-1251';
    	 $xml_doc->formatOutput = true;
         $attr=[  'ИдФайл'=>$rec_packet_titul2['file_uid'],	// Содержит (повторяет) имя сформированного файла (без расширения)
    			  'ВерсПрог'=>'БИБЛИОТЕКАЭЛЕКТРОННЫХДОКУМЕНТОВДЕМО 1.9.',
    			  'ВерсФорм'=>'5.01'
    			] ;
    	 $file = add_element($xml_doc,$xml_doc,'Файл','',$attr) ;

    	 // Путевой лист, информация о результате предсменного, предрейсового медицинского осмотра (Документ)
    	 $attr=[	'КНД'=>'1110381', // Код документа по КНД
    				'ДатИнфМО'=>date('d.m.Y'), // Дата в формате ДД.ММ.ГГГГ
    				'ВрИнфМО'=>date('H:i:s') // Время в формате ЧЧ:ММ:СС
    		   ] ;
    	 $doc = add_element($xml_doc,$file,'Документ','',$attr) ;

         // получаем файл подписи титупа1
         $sign_fname=$this->get_file_dir_by_packet_id(1,$rec_packet_titul2['titul1_id'],'sign') ;
         $sign_content=file_get_contents($sign_fname) ;

    	 // Идентификация файла обмена информации об обстоятельствах и особенностиях рейса (ИдИнфСоб)
    	 $attr=['ИдФайлИнфСоб'=>$rec_packet_titul1['file_uid'], // Содержит (повторяет) имя файла обмена информации об обстоятельствах и особенностиях рейса
    			'ДатФайлИнфСоб'=>date('d.m.Y',$rec_packet_titul1['titul_date_from']), // Указывается (повторяет) значение <ДатИнфСоб>, указанное в файле обмена информации об обстоятельствах и особенностиях рейса
    			'ВрФайлИнфСоб'=>date('H:i:s',$rec_packet_titul1['titul_date_from']), // Указывается (повторяет) значение <ВрИнфСоб>, указанное в файле обмена информации об обстоятельствах и особенностиях рейса
    			'ЭП'=>base64_encode($sign_content) // Электронная подпись файла обмена информации об обстоятельствах и особенностиях рейса - Представляется в кодировке Base64
    		   ] ;
    	 add_element($xml_doc,$doc,'ИдИнфСоб','',$attr) ;

    	 // Содержание путевого листа, информация о результате предсменного, предрейсового медицинского осмотра (СодИнфМО)
    	 $attr=['УИД_ПЛ'=>$rec_packet_titul1['pl_uid'],
    			'ВидМО'=>2, // 1 – предсменный, 2 – предрейсовый
    		   ] ;
    	 $sod_inf_mo = add_element($xml_doc,$doc,'СодИнфМО','',$attr) ;


         // Сведения о медицинской организации и медицинском работнике, состоящем в штате медицинской организации
         /*<СвМедОрг НаимМедОрг="ОБЩЕСТВО С ОГРАНИЧЕННОЙ ОТВЕТСТВЕННОСТЬЮ &quot;ЛИНИЯ МЕДКОНТРОЛЯ&quot;" Должн="Медицинская сестра">
                 <ФИО Фамилия="Былжыева" Имя="Дамира" Отчество="Шербаевна"/>
                 <ЛицензМО Сер="Л041" Ном="01137-77/00355183" ДатВыд="27.07.2020" Срок="15.10.2086"/>
               </СвМедОрг>*/
         $doctor_id=$last_mo_data['doctor_id'] ;

         // кеширование данных по докторам, группам, мед.организациям
         if (!isset($this->recs_doctor_account[$doctor_id])) $this->recs_doctor_account[$doctor_id]=ACCOUNTS()->get_account_by_id($doctor_id) ;
         $rec_doctor_account=$this->recs_doctor_account[$doctor_id] ;
         $group_id=$rec_doctor_account['parent'] ;
         if (!isset($this->recs_doctor_group[$group_id])) $this->recs_doctor_group[$group_id]=ACCOUNTS()->get_group_by_id($group_id) ;
         $doctor_group=$this->recs_doctor_group[$group_id] ;
         $med_org_id=($doctor_group['med_org_id'])?:$GLOBALS['LS_pl_med_org_def_id'] ;
         if (!isset($this->recs_med_org[$med_org_id])) $this->recs_med_org[$med_org_id]=ESMO()->get_med_org_by_id($med_org_id) ;
         $rec_med_org=$this->recs_med_org[$med_org_id] ;

                  $attr=['НаимМедОрг'=>$rec_med_org['obj_name'],
                'Должн'=>$rec_doctor_account['working'],
                        ] ;
                  $sv_med_org = add_element($xml_doc,$sod_inf_mo,'СвМедОрг','',$attr) ;

         $doctor_fio=($rec_doctor_account['contact_name'])?:$rec_doctor_account['obj_name'] ;
                  $arr_fio=explode(' ', $doctor_fio) ;
                 $arr_fio=array_slice($arr_fio,-3,3) ;
         $attr=['Фамилия'=>$arr_fio[0],'Имя'=>$arr_fio[1]] ;
          if ($arr_fio[2]) $attr['Отчество']=$arr_fio[2] ;
          add_element($xml_doc,$sv_med_org,'ФИО','',$attr) ;

          $attr=['Сер'=>$rec_med_org['license_seria'],
                 'Ном'=>$rec_med_org['license_number'],
                 'ДатВыд'=>date('d.m.Y',$rec_med_org['license_data_from']),
                 'Срок'=>date('d.m.Y',$rec_med_org['license_data_to']),
               ] ;
          add_element($xml_doc,$sv_med_org,'ЛицензМО','',$attr) ;


    	 // Сведения о медицинском работнике, состоящем в штате юридического лица или индивидуального предпринимателя, осуществляющего деятельность по перевозке пассажиров и багажа, грузов (СвМедРаб)
    	 /*$sv_med_rab = add_element($xml_doc,$sod_inf_mo,'СвМедРаб','') ;

         $arr_fio=explode(' ', $rec_doctor_account['obj_name']) ;
    	 $attr=['Фамилия'=>$arr_fio[0],
    			'Имя'=>$arr_fio[1],
    			'Отчество'=>$arr_fio[2],
    		   ] ;
    	 add_element($xml_doc,$sv_med_rab,'ФИО','',$attr) ;

    	 $attr=['Сер'=>'54563',
    			'Ном'=>'4545454',
    			'ДатВыд'=>'02.02.2020',
    			'Срок'=>'03.03.2030',
    		   ] ;
    	 add_element($xml_doc,$sv_med_rab,'ЛицензМО','',$attr) ;
    	 */

    	 // Сведения о результате предсменного, предрейсового медицинского осмотра водителем (водителями) (СвМОПред)
         $attr=['ДатВрПрМО'=>date('d.m.Y',$last_mo_data['c_data']).'T'.date('H:i:s',$last_mo_data['c_data']).'+03:00', // Дата и время проведения предсменного, предрейсового медицинского осмотра в формате ДД.ММ.ГГГГТЧЧ:ММ:СС±ЧЧ:ММ, где Т – разделитель даты и времени; ±ЧЧ:ММ  – разница с UTC в часах, минутах
    			'НалКоорТочВрПрМО'=>'1', // Применение координации точного времени (UTC) в типовом элементе ДатаВремяВЗТип, 0 – UTC не указан, 1 – UTC указан
    			'ОтметМОПред'=>'Прошел предсменный медицинский осмотр, к исполнению трудовых обязанностей допущен', // Отметка о результате проведения предсменного, предрейсового медицинского осмотра
    		   ] ;
    	 $sv_mo_pred = add_element($xml_doc,$sod_inf_mo,'СвМОПред','',$attr) ;

    	 // Сведения о водителе транспортного средства (СвВодит)
    	 $sv_vodit=add_element($xml_doc,$sv_mo_pred,'СвВодит','') ;
             $attr=['НомВУ'=>$rec_driver['driver_license_number'], // Номер водительского удостоверения
                    'СерВУ'=>$rec_driver['driver_license_seria'], // Серия водительского удостоверения
                    'ДатаВыдВУ'=>$rec_driver['driver_license_data'], // Дата выдачи водительского удостоверения, Дата в формате ДД.ММ.ГГГГ
    	   ] ;
    	 add_element($xml_doc,$sv_vodit,'ВодитУд','',$attr) ;
    	 $attr=['Фамилия'=>$rec_driver['driver_name1'],'Имя'=>$rec_driver['driver_name2']] ;
         if ($rec_driver['driver_name3']) $attr['Отчество']=$rec_driver['driver_name3'] ;
    	 add_element($xml_doc,$sv_vodit,'ФИО','',$attr) ;


         // Сведения о лице, подписывающем информацию отправителя в электронной форме (ПодписантТип)
         $attr=['Должн'=>$rec_doctor_account['working'], // Должность
    			'ТипПодпис'=>'1', // Тип подписи, 1 – усиленная квалифицированная электронная подпись, 2 – простая электронная подпись, 3 – усиленная неквалифицированная электронная подпись
    			'СпосПодтПолном'=>'1', // Способ подтверждения полномочий на подписание документа, 1 – в соответствии с данными, содержащимися в электронной подписи, 2 – в соответствии с электронной доверенностью в машиночитаемой форме, представленной посредством ее включения в пакет электронных документов, 3 – в соответствии с электронной доверенностью в машиночитаемой форме, хранение которой осуществляется в информационной системе, при этом сведения о них указаны в электронном документе, 4 – в соответствии с электронной доверенностью в машиночитаемой форме, хранение которой осуществляется в информационной системе, при этом сведения о них передаются способом, отличным от указания в электронном документе, 5 – в соответствии с доверенностью в форме документа на бумажном носителе , 6 – любое иное
    		   ] ;
    	 $podp_info_mo = add_element($xml_doc,$doc,'ПодпИнфМО','',$attr) ;

         $doctor_fio=($rec_doctor_account['contact_name'])?:$rec_doctor_account['obj_name'] ;
                 $arr_fio=explode(' ', $doctor_fio) ;
                 $arr_fio=array_slice($arr_fio,-3,3) ;
         $attr=['Фамилия'=>$arr_fio[0],'Имя'=>$arr_fio[1]] ;
         if ($arr_fio[2]) $attr['Отчество']=$arr_fio[2] ;
    	 add_element($xml_doc,$podp_info_mo,'ФИО','',$attr) ;

        $text_debug=ob_get_clean() ;
        LOG_JSON()->reg('prepare_titul2_xml', $text_debug) ;
        //LOGS()->reg_log('prepare_titul2_xml', $text_debug) ;

        ob_start() ;
    	echo $xml_doc->saveXML() ;
    	$text=ob_get_clean() ;
    	return($text) ;
      }

    function prepare_titul6_xml($rec_packet_titul6,$rec_driver,$last_mo_data)
      {  ob_start() ;
         $rec_pl=$this->get_put_list_by_id($rec_packet_titul6['pl_id'])  ;
         $rec_packet_titul5=$this->get_packet_by_id($rec_pl['packet_titul5_id'])  ;  // получаем запись по пакету5 по данным из ПЛ
             //damp_array($rec_packet_titul5);
             //damp_array($rec_packet_titul6);
             //damp_array($recs_mo);

    	 $imp = new DOMImplementation; // Creates an instance of the DOMImplementation class
    	 $xml_doc = $imp->createDocument("",""); // Creates a DOMDocument instance
    	 $xml_doc->encoding = 'windows-1251';
    	 $xml_doc->formatOutput = true;
         $attr=[  'ИдФайл'=>$rec_packet_titul6['file_uid'],	// Содержит (повторяет) имя сформированного файла (без расширения)
    			  'ВерсПрог'=>'БИБЛИОТЕКАЭЛЕКТРОННЫХДОКУМЕНТОВДЕМО 1.9.',
    			  'ВерсФорм'=>'5.01'
    			] ;
    	 $file = add_element($xml_doc,$xml_doc,'Файл','',$attr) ;

    	 // Путевой лист, информация о результате предсменного, предрейсового медицинского осмотра (Документ)
    	 $attr=[	'КНД'=>'1110385', // Код документа по КНД
    				'ДатИнфМО'=>date('d.m.Y'), // Дата в формате ДД.ММ.ГГГГ
    				'ВрИнфМО'=>date('H:i:s') // Время в формате ЧЧ:ММ:СС
    		   ] ;
    	 $doc = add_element($xml_doc,$file,'Документ','',$attr) ;

         // получаем файл подписи титупа1
         $xml_fname=$this->get_file_dir_by_packet_id(5,$rec_pl['packet_titul5_id'],'xml') ;
         $data = PL()->parse_xml_packet_to_array($xml_fname) ;
         // unset($data['Документ']['@attributes']['ВрИнфЗаезд']) ;
         $sign_fname=$this->get_file_dir_by_packet_id(5,$rec_pl['packet_titul5_id'],'sign') ;
         $sign_content=file_get_contents($sign_fname) ;



    	 // Идентификация файла обмена информации об обстоятельствах и особенностиях рейса (ИдИнфСоб)
    	 $attr=['ИдФайлИнфЗаезд'=>$rec_packet_titul5['file_uid'], // Содержит (повторяет) имя файла обмена информации об обстоятельствах и особенностиях рейса
                'ДатФайлИнфЗаезд'=>date('d.m.Y',$rec_packet_titul5['titul_date_from']), // Указывается (повторяет) значение <ДатИнфСоб>, указанное в файле обмена информации об обстоятельствах и особенностиях рейса
    			'ВрФайлИнфЗаезд'=>$data['Документ']['@attributes']['ВрИнфЗаезд'], // Указывается (повторяет) значение <ВрИнфСоб>, указанное в файле обмена информации об обстоятельствах и особенностиях рейса
    			'ЭП'=>base64_encode($sign_content) // Электронная подпись файла обмена информации об обстоятельствах и особенностиях рейса - Представляется в кодировке Base64
    		   ] ;
    	 add_element($xml_doc,$doc,'ИдИнфЗаезд','',$attr) ;

    	 // Содержание путевого листа, информация о результате предсменного, предрейсового медицинского осмотра (СодИнфМО)
    	 $attr=['УИД_ПЛ'=>$rec_pl['uid'],
    			'ВидМО'=>2, // 1 – предсменный, 2 – предрейсовый
    		   ] ;
    	 $sod_inf_mo = add_element($xml_doc,$doc,'СодИнфМО','',$attr) ;

         $rec_med_org=ESMO()->get_med_org_by_id(1) ;

         // Сведения о медицинской организации и медицинском работнике, состоящем в штате медицинской организации
         /*<СвМедОрг НаимМедОрг="ОБЩЕСТВО С ОГРАНИЧЕННОЙ ОТВЕТСТВЕННОСТЬЮ &quot;ЛИНИЯ МЕДКОНТРОЛЯ&quot;" Должн="Медицинская сестра">
                 <ФИО Фамилия="Былжыева" Имя="Дамира" Отчество="Шербаевна"/>
                 <ЛицензМО Сер="Л041" Ном="01137-77/00355183" ДатВыд="27.07.2020" Срок="15.10.2086"/>
               </СвМедОрг>*/
         $doctor_id=$last_mo_data['doctor_id'] ;

          // кеширование данных по докторам, группам, мед.организациям
        if (!isset($this->recs_doctor_account[$doctor_id])) $this->recs_doctor_account[$doctor_id]=ACCOUNTS()->get_account_by_id($doctor_id) ;
        $rec_doctor_account=$this->recs_doctor_account[$doctor_id] ;
        $group_id=$rec_doctor_account['parent'] ;
        if (!isset($this->recs_doctor_group[$group_id])) $this->recs_doctor_group[$group_id]=ACCOUNTS()->get_group_by_id($group_id) ;
        $doctor_group=$this->recs_doctor_group[$group_id] ;
        $med_org_id=($doctor_group['med_org_id'])?:$GLOBALS['LS_pl_med_org_def_id'] ;
        if (!isset($this->recs_med_org[$med_org_id])) $this->recs_med_org[$med_org_id]=ESMO()->get_med_org_by_id($med_org_id) ;
        $rec_med_org=$this->recs_med_org[$med_org_id] ;

          $attr=['НаимМедОрг'=>$rec_med_org['obj_name'],
               'Должн'=>$rec_doctor_account['working'],
             	] ;
          $sv_med_org = add_element($xml_doc,$sod_inf_mo,'СвМедОрг','',$attr) ;

        $doctor_fio=($rec_doctor_account['contact_name'])?:$rec_doctor_account['obj_name'] ;
                $arr_fio=explode(' ', $doctor_fio) ;
                $arr_fio=array_slice($arr_fio,-3,3) ;
        $attr=['Фамилия'=>$arr_fio[0],'Имя'=>$arr_fio[1]] ;
                 if ($arr_fio[2]) $attr['Отчество']=$arr_fio[2] ;
          add_element($xml_doc,$sv_med_org,'ФИО','',$attr) ;

          $attr=['Сер'=>$rec_med_org['license_seria'],
                 'Ном'=>$rec_med_org['license_number'],
                 'ДатВыд'=>date('d.m.Y',$rec_med_org['license_data_from']),
                 'Срок'=>date('d.m.Y',$rec_med_org['license_data_to']),
               ] ;
          add_element($xml_doc,$sv_med_org,'ЛицензМО','',$attr) ;

    	 // Сведения о медицинском работнике, состоящем в штате юридического лица или индивидуального предпринимателя, осуществляющего деятельность по перевозке пассажиров и багажа, грузов (СвМедРаб)
    	 /*$sv_med_rab = add_element($xml_doc,$sod_inf_mo,'СвМедРаб','') ;

         $arr_fio=explode(' ', $rec_doctor_account['obj_name']) ;
    	 $attr=['Фамилия'=>$arr_fio[0],
    			'Имя'=>$arr_fio[1],
    			'Отчество'=>$arr_fio[2],
    		   ] ;
    	 add_element($xml_doc,$sv_med_rab,'ФИО','',$attr) ;

    	 $attr=['Сер'=>'54563',
    			'Ном'=>'4545454',
    			'ДатВыд'=>'02.02.2020',
    			'Срок'=>'03.03.2030',
    		   ] ;
    	 add_element($xml_doc,$sv_med_rab,'ЛицензМО','',$attr) ;
    	 */
    	 // Сведения о результате предсменного, предрейсового медицинского осмотра водителем (водителями) (СвМОПред)
         $attr=['ДатВрПрМО'=>date('d.m.Y',$last_mo_data['c_data']).'T'.date('H:i:s',$last_mo_data['c_data']).'+03:00', // Дата и время проведения предсменного, предрейсового медицинского осмотра в формате ДД.ММ.ГГГГТЧЧ:ММ:СС±ЧЧ:ММ, где Т – разделитель даты и времени; ±ЧЧ:ММ  – разница с UTC в часах, минутах
    			'НалКоорТочВрПрМО'=>'1', // Применение координации точного времени (UTC) в типовом элементе ДатаВремяВЗТип, 0 – UTC не указан, 1 – UTC указан
    			'ОтметМОПосл'=>'Прошел послерейсовый медицинский осмотр', // Отметка о результате проведения предсменного, предрейсового медицинского осмотра
    		   ] ;
    	 $sv_mo_pred = add_element($xml_doc,$sod_inf_mo,'СвМОПосл','',$attr) ;

    	 // Сведения о водителе транспортного средства (СвВодит)
    	 $sv_vodit=add_element($xml_doc,$sv_mo_pred,'СвВодит','') ;
                 $attr=['НомВУ'=>$rec_driver['driver_license_number'], // Номер водительского удостоверения
                        'СерВУ'=>$rec_driver['driver_license_seria'], // Серия водительского удостоверения
                        'ДатаВыдВУ'=>$rec_driver['driver_license_data'], // Дата выдачи водительского удостоверения, Дата в формате ДД.ММ.ГГГГ
    	   ] ;
    	 add_element($xml_doc,$sv_vodit,'ВодитУд','',$attr) ;
         $attr=['Фамилия'=>$rec_driver['driver_name1'],'Имя'=>$rec_driver['driver_name2']] ;
         if ($rec_driver['driver_name3']) $attr['Отчество']=$rec_driver['driver_name3'] ;
    	 add_element($xml_doc,$sv_vodit,'ФИО','',$attr) ;

         // Сведения о лице, подписывающем информацию отправителя в электронной форме (ПодписантТип)
         $attr=['Должн'=>$rec_doctor_account['working'], // Должность
    			'ТипПодпис'=>'1', // Тип подписи, 1 – усиленная квалифицированная электронная подпись, 2 – простая электронная подпись, 3 – усиленная неквалифицированная электронная подпись
    			'СпосПодтПолном'=>'1', // Способ подтверждения полномочий на подписание документа, 1 – в соответствии с данными, содержащимися в электронной подписи, 2 – в соответствии с электронной доверенностью в машиночитаемой форме, представленной посредством ее включения в пакет электронных документов, 3 – в соответствии с электронной доверенностью в машиночитаемой форме, хранение которой осуществляется в информационной системе, при этом сведения о них указаны в электронном документе, 4 – в соответствии с электронной доверенностью в машиночитаемой форме, хранение которой осуществляется в информационной системе, при этом сведения о них передаются способом, отличным от указания в электронном документе, 5 – в соответствии с доверенностью в форме документа на бумажном носителе , 6 – любое иное
    		   ] ;
    	 $podp_info_mo = add_element($xml_doc,$doc,'ПодпИнфМО','',$attr) ;

         $doctor_fio=($rec_doctor_account['contact_name'])?:$rec_doctor_account['obj_name'] ;
         $arr_fio=explode(' ', $doctor_fio) ;
         $arr_fio=array_slice($arr_fio,-3,3) ;

         $attr=['Фамилия'=>$arr_fio[0],'Имя'=>$arr_fio[1]] ;
         if ($arr_fio[2]) $attr['Отчество']=$arr_fio[2] ;
    	 add_element($xml_doc,$podp_info_mo,'ФИО','',$attr) ;

            $text_debug=ob_get_clean() ;
        LOG_JSON()->reg('prepare_titul6_xml', $text_debug) ;
        //LOGS()->reg_log('prepare_titul6_xml', $text_debug) ;
            ob_start() ;
    	echo $xml_doc->saveXML() ;
    	$text=ob_get_clean() ;
    	return($text) ;
      }

    // отправка xml-данных на подпись
    // TODO doctor_id=3
    // TODO group_id=5
     function send_to_sign_xml_mess($packet_id,$xml_mess,$group_id,$doctor_id,$options=[])
     {
			 $sign_uid='packet_xml_'.$packet_id ;
   	  if ($options['debug']) echo  'Отправляем данные на подпись<br>' ;
			$type=($options['message_type'])?:'data_to_sign_pl' ;
   	  $message = ['type'=>'data_to_sign_pl',
   				  'uid'=>ENGINE()->generate_UID(), // uid где-то затирается, используем uid2
   				  'packet_id'=>$packet_id,
   				  'uid2'=>$sign_uid,
   				  'content'=>base64_encode($xml_mess),
   				  'doctor_id'=>$doctor_id,
   				  'date'=>date('d.m.Y H:i:s'),
   				  'notife_of_data'=>'XML-пакет'
   				 ];

      if ($options['debug']) damp_array($message,1,-1);
   	  $result=\cab\system\i_ws::send_mess_to_WS([(string)$group_id],$message);
      if ($options['debug']) damp_array($result,1,-1);
      return($result);
     }

     function parse_titul1_file_uid($file_uid)
     {
        $arr=explode('_',$file_uid) ;
        //damp_array($arr);
        $result['perfix']=$arr[0].'_'.$arr[1] ;
        $result['med_org_uid']=$arr[2] ;
        $result['tech_org_uid']=$arr[3] ;
        $result['odometr_uid']=$arr[4] ;
        $result['dispatcher_uid']=$arr[5] ;
        $result['other_reciever']=$arr[6] ;
        $result['date']=$arr[7] ;
        $result['file_uid']=$arr[8] ;
        //damp_array($result);
        return($result) ;
     }
     function parse_titul5_file_uid($file_uid)
     {
        $arr=explode('_',$file_uid) ;
        //damp_array($arr);
        $result['perfix']=$arr[0].'_'.$arr[1] ;
        $result['dispatcher_uid']=$arr[2] ;
        $result['med_org_uid']=$arr[3] ;
        $result['odometr_uid']=$arr[4] ;
        $result['other_reciever']=$arr[5] ;
        $result['date']=$arr[6] ;
        $result['file_uid']=$arr[7] ;
        //damp_array($result);
        return($result) ;
     }

     function generate_titul2_file_uid($titul1_file_uid,$options=[])
     { ob_start() ;
        $titul1_file_info=$this->parse_titul1_file_uid($titul1_file_uid) ;
        ?><strong>titul 1 file name: <?echo $titul1_file_uid?></strong><br><?
        damp_array($titul1_file_info,1,-1);
        $result['perfix']='ON_PTLSPRMO' ;
        $result['dispatcher_uid']=$titul1_file_info['dispatcher_uid'] ;
        $result['tech_org_uid']=$titul1_file_info['tech_org_uid'] ;
        $result['med_org_uid']=$titul1_file_info['med_org_uid'] ;
        $result['date']=date('Ymd') ;
        $result['file_uid']=$this->get_file_uid() ;
        $file_uid=implode('_',$result) ;
        ?><strong>titul 2 file name <?echo $file_uid?></strong><br><?
        damp_array($result,1,-1);
        $text=ob_get_clean() ;
        if ($options['debug']) echo $text ;
        //LOGS()->reg_log('generate_titul2_file_uid', $text) ;
        return($file_uid) ;
     }

     function generate_titul6_file_uid($titul5_file_uid)
     { ob_start() ;
        $titul5_file_info=$this->parse_titul5_file_uid($titul5_file_uid) ;
        ?><strong>titul 5 file uid</strong><br><?
        damp_array($titul5_file_info,1,-1);
        $result['perfix']='ON_PTLSPOSMO' ;
        $result['dispatcher_uid']=$titul5_file_info['dispatcher_uid'] ;
        $result['med_org_uid']=$titul5_file_info['med_org_uid'] ;
        $result['date']=date('Ymd') ;
        $result['file_uid']=$this->get_file_uid() ; //$titul5_file_info['file_uid'] ;
        ?><strong>titul 6 file uid</strong><br><?
        damp_array($result,1,-1);
        $file_uid=implode('_',$result) ;
        echo 'file_uid='.$file_uid.'<br>' ;
        $text=ob_get_clean() ;
        LOGS()->reg_log('generate_titul6_file_uid', $text) ;
        return($file_uid) ;
     }

     // генерирует UID типа
     // 40532e33-2264-4f7d-bfa9-30510ba282d1
     // df76926c-7530-481e-bd5f-8619a53d5acd
     function get_file_uid()
     {
       $arr=[] ;
       $arr[]=mb_substr(ENGINE()->generate_UID(),0,8) ;
       $arr[]=mb_substr(ENGINE()->generate_UID(),0,4) ;
       $arr[]=mb_substr(ENGINE()->generate_UID(),0,4) ;
       $arr[]=mb_substr(ENGINE()->generate_UID(),0,4) ;
       $arr[]=mb_substr(ENGINE()->generate_UID(),0,12) ;
       return(implode('-',$arr)) ;
     }



}


?>
