<?
namespace esmo\pl;
use i_db_object;
class i_pl_packet_driver extends i_db_object
{
    static $table_name = 'pl_packet_driver';
    static $table_title = 'ПЛ - водители титула';

    static $clss = 785;
    static $class_descr=['name'=>'ПЛ - водители титула',
                         'parent'=>0,
                         'fields'=>['packet_id'=>['type'=>'int(11)','index'=>'packet_id'],
                                    'driver_license_number'=>'varchar(32)',
                            		'driver_license_seria'=>'varchar(32)',
                            		'driver_license_data'=>'varchar(12)',
                            		'driver_fio'=>'varchar(256)',
                            		'driver_name1'=>'varchar(256)',
                            		'driver_name2'=>'varchar(256)',
                            		'driver_name3'=>'varchar(256)',
                            		'driver_uid'=>'varchar(256)',
                            		'driver_id'=>'int',
                            		'pl_id'=>'int',
                            		'mo_id'=>'int',
                                   ],

        				] ;

    public static function prepare_rec_by_form($form_data)
	{	 //trace() ;
		 //damp_array($form_data,'i_pl_packet_driver::prepare_rec_by_form::$form_data');
		 $data=[];
		 $data['clss']=static::$clss;
		 $data['indx']=0;
		 if (isset($form_data['packet_id'])) $data['packet_id']=$form_data['packet_id'];
		 if (isset($form_data['driver_license_number'])) $data['driver_license_number']=($form_data['driver_license_number']) ?: '';
		 if (isset($form_data['driver_license_seria'])) $data['driver_license_seria']=($form_data['driver_license_seria']) ?: '';
		 if (isset($form_data['driver_license_data'])) $data['driver_license_data']=($form_data['driver_license_data']) ?: '';
		 if (isset($form_data['driver_fio'])) $data['driver_fio']=($form_data['driver_fio']) ?: '';
		 if (isset($form_data['driver_name1'])) $data['driver_name1']=($form_data['driver_name1']) ?: '';
		 if (isset($form_data['driver_name2'])) $data['driver_name2']=($form_data['driver_name2']) ?: '';
		 if (isset($form_data['driver_name3'])) $data['driver_name3']=($form_data['driver_name3']) ?: '';
		 if (isset($form_data['driver_uid'])) $data['driver_uid']=($form_data['driver_uid']) ?: '';
		 if (isset($form_data['driver_id'])) $data['driver_id']=($form_data['driver_id']) ?: '';
		 if (isset($form_data['pl_id'])) $data['pl_id']=($form_data['pl_id']) ?: 0;
		 if (isset($form_data['mo_id'])) $data['mo_id']=($form_data['mo_id']) ?: 0;
		 if (isset($form_data['mo_date'])) $data['mo_date']=($form_data['mo_date']) ?: 0;
		 if (isset($form_data['mo_doctor_id'])) $data['mo_doctor_id']=($form_data['mo_doctor_id']) ?: 0;
		 if (isset($form_data['mo_group_id'])) $data['mo_group_id']=($form_data['mo_group_id']) ?: 0;
		 return ($data);
	 }

	public static function get_recs_by_packet_id($packet_id)
	{
		$recs=execSQL('select * from pl_packet_driver where packet_id='.$packet_id);
		return($recs) ;
	}

	//\esmo\pl\i_pl_log::reg($result_packet_create['id'], 'Регистрация водителя пакета, ID '.$result_driver['id']);

	public static function create($form_data,$options=[])
	{
	   $result=parent::create($form_data,$options) ;
	   if ($result['result']) \esmo\pl\i_pl_log::reg($form_data['packet_id'], 'Регистрация водителя',['personal_id'=>$form_data['driver_id']]);
	   else \esmo\pl\i_pl_log::reg(0, 'Ошибка регистрации водителя');
	   return($result);
	}

	public static function save($pkey,$form_data,$options=[])
	{
	   $options['check_changes']=1 ;
	   $result=parent::save($pkey,$form_data,$options) ;
	   if ($result['result'] and sizeof($result['changes']))
	   {   $rec=static::get_rec_by_id($pkey) ;
		   \esmo\pl\i_pl_log::reg($options['packet_id'], 'Изменение записи водителя',['personal_id'=>$rec['driver_id'],'changes'=>$result['changes']]);
	   }
	   else if (!$result['result']) \esmo\pl\i_pl_log::reg(0, 'Ошибка изменения записи водителя');

	   else
	   {
		   $result['status']='success';
		   $result['result']=true;
		   $result['message']='Сохранено';
		   $result['changes']='Сохранено';
	   }
	   return($result);
	}

}

?>
