<?php
$__functions['init'][]='_mine_site_vars' ;
$__functions['boot_site'][]='_mine_site_boot' ;

function mine() {return($_SESSION['mine_system']);$_SESSION['mine_system']=new c_mine_system();return($_SESSION['mine_system']);} ;


function _mine_site_vars()
{   // роли модуля
    $_SESSION['ARR_lamp_events']=array(
        0=>'Лампа принята',
        1=>'Лампа выдана'
    ) ;

    //статус лампы
    $_SESSION['ARR_lamp_status']=array(
        0=>'Принята',
        1=>'Выдана'
    ) ;
}

function _mine_site_boot($options)
{
    create_system_modul_obj('mine',$options) ;

}


class c_mine_system
{
    public $table_bill ;
    public $mine_list ;
    public $checks_table;
    public $lamp_table_events;
    public $lamp_table;

    function __construct($create_options=array())
    {
        $this->checks_table='obj_'.SITE_CODE.'_rml_checks' ;
        $this->lamp_table_events='obj_'.SITE_CODE.'_rml_lamp_events' ;
        $this->lamp_table='obj_'.SITE_CODE.'_rml_lamp' ;
        ENGINE()->reg_ext('aspmo_rml','РМЛ') ;
    }

    function declare_menu_items_2($page)
    { // только для клиента

        $page->menu['/cab/rml/']=array('title'=>'РМЛ',
                                     'class'=>'fa fa-user-md',
                                     'allow_access_to_rol'=>8,
                                     'items'=>array('/cab/rml/'=>'Рабочее место ламповщика')
                                    ) ;

    }

    function check_pass($pass) {
        $result=[
            'data'=>[
                'value'=>$pass
            ]
        ];
        if ($GLOBALS['LS_lamp_search_pass_as_lamp'] and ($GLOBALS['LS_max_lamp_length']>=strlen($pass))) {
            //передан номер лампы
            $result['type']='lamp';
            $rec_lamp=$this->get_lamp_by_number($pass);
            $result['data']['lamp']=$rec_lamp;
            if (_sizeof($rec_lamp)) {
                if ($rec_lamp['status']==1) {
                    //принять лампу
                    $result['event']['action']='lamp_accept';
                    $result['data']['lamp_last_event']=MINE()->get_lamp_event_by_id($rec_lamp['last_event_id']);
                    if ($result['data']['lamp_last_event']['personal_id']) $result['data']['person']=PERSONAL()->get_personal_by_id($result['data']['lamp_last_event']['personal_id']);
                } elseif ($rec_lamp['status']==0) {
                    //сообщение лампа свободна
                    //предложить выдать лампу последнему сдавшему ее?
                    $result['event']['action']='lamp_free';
                    $result['event']['error']='lamp_free';
                }
            } else {
                //лампа не найдена в системе
                $result['error']['text']='Лампа № '.$pass.' не найдена';
            }
        } else {
            //ищем персону по пропуску
            $result['type']='pass';

            $rec_personal=PERSONAL()->get_personal_by_propusk($this->translit_pass_number($pass)) ;
            if ($rec_personal['pkey']) {
                //проверка последнего события сотрудника
                $result['data']['person']=$rec_personal;
                $last_lamp_event=MINE()->check_last_lamp_for_person($rec_personal['pkey']);
                $result['data']['lamp_last_event']=$last_lamp_event;
                // получение записи лампы
                if ($last_lamp_event['lamp_id']) $lamp_rec=MINE()->get_lamp_by_id($last_lamp_event['lamp_id']); else $lamp_rec=[];
                $result['data']['lamp']=$lamp_rec;

                if (!$last_lamp_event['event_type']) {
                    //у сотрудника нет лампы на руках
                    //проверяем
                    $rec_mo=ESMO()->check_active_dopusk($rec_personal['pkey']) ;
                    $result['data']['mo']=$rec_mo;
                    if ($rec_mo['pkey'] and $rec_mo['dopusk']==1) {
                        //МО пройден
                        $result['event']['action']='give_lamp';
                    } else {
                        //МО не пройден
                        $result['event']['error']='mo';
                    }
                } elseif ($last_lamp_event['event_type']==1) {
                    //лампа у сотрудника
                    $result['event']['action']='lamp_accept';
                }
            } else {
                //сотрудник не найден
        //            echo 'сотрудник не найден '.$pass;
                $result['error']['text']='Пропуск "'.$pass.'" не найден';
            }
        }
        return $result;
    }

    function get_lamp_by_number($number,$options=array()) {
        if (!$options['group_id']) $group_id=MEMBER()->cur_group_id; else $group_id=$options['group_id'];
        $lamp=execSQL_van('select * from '.$this->lamp_table.' where group_id='.$group_id.' and obj_name="'.$number.'"');
        return $lamp;
    }

    function get_lamp_by_id($id) {
        $result=execSQL_van('select * from '.$this->lamp_table.' where pkey='.$id);
        return $result;
    }

    function get_lamp_number_by_id($id) {
        $result=execSQL_value('select obj_name from '.$this->lamp_table.' where pkey='.$id);
        return $result;
    }

    function check_last_lamp_for_person($person_id,$lamp_id=0) {
        if ($person_id) {
            $usl_array=[];
            $usl_array[]='personal_id='.$person_id;
            $usl_array[]='group_id='.MEMBER()->cur_group_id;
            if ($lamp_id) $usl_array[]='lamp_id='.$lamp_id;
            $last_lamp_action=execSQL_van('select * from '.$this->lamp_table_events.' where '.implode(' and ',$usl_array).' order by pkey desc limit 1');
            if (_sizeof($last_lamp_action)) {
                return $last_lamp_action;
            } else {
                return [];
            }
        }
    }

    function get_lamp_event_by_id($id) {
        $result=execSQL_van('select * from '.$this->lamp_table_events.' where pkey='.$id);
        return $result;
    }

    function give_lamp($personal_id,$mo_id,$lamp_number,$options=[]) {
        $rec_lamp=$this->get_lamp_by_number($lamp_number,$options);
        //обновляем статус лампы - выдана
        if (_sizeof($rec_lamp)) {
            if ($rec_lamp['status']==1) {
                //лампа уже выдана
                return false;
            }
            update_rec_in_table($this->lamp_table,array('status'=>1),'pkey='.$rec_lamp['pkey'],array('debug'=>0)) ;
            $lamp_id=$rec_lamp['pkey'];
        } else {
            $lamp_data=[
                'clss'=>268,
                'obj_name'=>$lamp_number,
                'group_id'=>($options['group_id'])?$options['group_id']:MEMBER()->cur_group_id,
                'status'=>1
            ];
            $lamp_id=adding_rec_to_table($this->lamp_table,$lamp_data,array('no_auto_indx'=>1));
        }

        //сохраняем событие по лампе
        $data=[
            'clss'=>267,
            'personal_id'=>$personal_id,
            'mo_id'=>$mo_id,
            'account_id'=>($options['member_id'])?$options['member_id']:MEMBER()->id,
            'lamp_id'=>$lamp_id,
            'event_type'=>1,
            'group_id'=>($options['group_id'])?$options['group_id']:MEMBER()->cur_group_id,
        ];
        if ($options['data_create']) $data['c_data']=$options['data_create'];
        $event_id=adding_rec_to_table($this->lamp_table_events,$data,array('no_auto_indx'=>1));
        update_rec_in_table($this->lamp_table,array('last_event_id'=>$event_id),'pkey='.$lamp_id,array('debug'=>0)) ;
        return true;
    }

    function accept_lamp($personal_id,$lamp_id,$options=[]) {
        $rec_lamp=$this->get_lamp_by_id($lamp_id);
        if (_sizeof($rec_lamp)) {
            //обновляем статус лампы
//            execSQL_update('update '.$this->lamp_table.' set status=0 where pkey='.$lamp_id);
//            update_rec_in_table($this->lamp_table,array('status'=>0),'pkey='.$lamp_id,array('debug'=>0)) ;
            //сохраняем событие по лампе
            $data=[
                'clss'=>267,
                'personal_id'=>$personal_id,
                'account_id'=>($options['member_id'])?$options['member_id']:MEMBER()->id,
                'lamp_id'=>$lamp_id,
                'event_type'=>0,
                'group_id'=>($options['group_id'])?$options['group_id']:MEMBER()->cur_group_id,
            ];
            if ($options['data_create']) $data['c_data']=$options['data_create'];
            $event_id=adding_rec_to_table($this->lamp_table_events,$data,array('no_auto_indx'=>1));
            update_rec_in_table($this->lamp_table,array('status'=>0,'last_event_id'=>$event_id),'pkey='.$lamp_id,array('debug'=>0)) ;
        }
    }

    function create_check_lamp_rec($propusk,$rec_personal=array()) {
        if ($propusk and $rec_personal['pkey']) {
            $data=[
                'clss'=>266,'parent'=>1,'obj_name'=>$propusk,'account_id'=>MEMBER()->id,'group_id'=>MEMBER()->cur_group_id,'personal_id'=>$rec_personal['pkey']
            ];
            $id=adding_rec_to_table($this->checks_table,$data,array('no_auto_indx'=>1));
            return $id;
        }
    }

    function get_lamp_count($options=array()) {
        if (!$options['group_id']) $group_id=MEMBER()->cur_group_id; else $group_id=$options['group_id'];
        $cnt=execSQL_value('select count(pkey) from '.$this->lamp_table.' where group_id='.$group_id.' and status=1');
        return $cnt;
    }

    function translit_pass_number($text)
    {
        $text=trim($text);
        if(preg_match("/[А-я]/", $text)) {
            $trans = [
                'Ф'=>'A', 'И'=>'B', 'С'=>'C', 'В'=>'D', 'У'=>'E', 'А'=>'F', 'Е'=>'T', 'М'=>'V',
                'ф'=>'a', 'и'=>'b', 'с'=>'c', 'в'=>'d', 'у'=>'e', 'а'=>'f', 'е'=>'t', 'м'=>'v',
            ];
            $result=strtr($text, $trans);
        } else {
            $result=$text;
        }
        return $result;
    }

    function get_lamp_accounts()
    {
        return execSQL('select t1.account_id,t2.obj_name
                                    from (select distinct(account_id) from '.$this->lamp_table_events.') t1
                                    left join '.ACCOUNTS()->table_account.' t2 on t1.account_id=t2.pkey
                         ');
    }
}
?>
