<?php
define('_events_DIR',_DIR_TO_ROOT.'/event/') ;
define('_events_PATH',_PATH_TO_SITE.'/event/') ;

$__functions['init'][]='_event_site_vars' ;
$__functions['boot_site'][]='_event_site_boot' ;

function EVENTS() {
  if (isset($_SESSION['event_system'])) {
    return($_SESSION['event_system']);
  } else {
    $_SESSION['event_system']=new c_event_system();
    return($_SESSION['event_system']);
  }
}

function _event_site_vars()
{

  $_SESSION['ARR_events_status']=array(//0=>'',
                                       //1=>'Неактивно',
                                       //2=>'Подготовка',
                                       //3=>'Планируется',
                                       //4=>'Активно',
                                       5=>'Архив',
                                    ) ;


  $_SESSION['ARR_events_type']=array  (0=>'',
                                       1=>'ПМО',
                                       2=>'Инструктаж',
                                       3=>'Лекция',
                                       4=>'Обучение',
                                       5=>'Практика',
                                       6=>'Выдача документа'
                                    ) ;

  $_SESSION['ARR_events_mode']=array  (0=>'',
                                       1=>'Разовое',
                                       2=>'Ежедневное',
                                       3=>'Ежемесячное',
                                       4=>'Ежеквартальное',
                                       5=>'Ежегодное',
                                       6=>'Постоянное'
                                    ) ;

  $_SESSION['ARR_events_alert']=array  (0=>'нет',
                                       1=>'за 3 дня',
                                       2=>'за 1 неделю',
                                       3=>'за 2 недели',
                                       4=>'за 1 месяц',
                                       5=>'за 3 месяца'
                                    ) ;

}

function _event_site_boot($options)
{
  create_system_modul_obj('event',$options) ;

}


class c_event_system  extends c_system
{  var $modul_name='Мероприятия' ;
  var $modul_descr='' ;

    public $table_events ;
    public $report_obj ;
    public $ARR_emo_group_names ;

    function __construct($create_options=array())
    { $this->table_name ='obj_'.SITE_CODE.'_events_schedule' ;
      $this->table_events ='obj_'.SITE_CODE.'_events_schedule' ;
      $this->system_title ='События';
      parent::__construct($create_options) ;
      //$this->pages_info=array() ;

      ENGINE()->reg_ext('event','Мероприятия') ;


	  ENGINE()->reg_ext('esmo_magnit_pmo','ПМО') ;
      ENGINE()->reg_ext('esmo_magnit_instruction','Инструктажи') ;
      ENGINE()->reg_ext('events_docs','Выдача документов') ;
      ENGINE()->reg_ext('events','Мероприятия') ;
      ENGINE()->reg_ext('events_meeting','Собрания') ;

      //регистрируем документы
      set_time_point('Создание объекта <strong>events_system</strong>') ;
    }

    function declare_menu_items_2($page)
      {

          $page->menu['/cab/events/']=array('title'=>'Мероприятия',
                                             'class'=>'fas fa-puzzle-piece',
                                             //'items'=>array('/cab/events/'=>array('title'=>'Документы','class'=>'fa fa-book')

                                             //              )
                                             ) ;
      }

    //==========================================================================================================================================================================
    // РАБОТА  С мероприятиями, событиями
    //==========================================================================================================================================================================





    function get_end_data($start_data,$interval=array())
    {  $res=0 ;
       if (is_int($start_data)) $start_data=date('d.m.Y H:i:s',$start_data) ;
       $date = new DateTime($start_data);
       $int=null ;
       if (isset($interval['d'])) $int=new DateInterval('P'.$interval['d'].'D') ;
       if (isset($interval['m'])) $int=new DateInterval('P'.$interval['m'].'M') ;
       if (is_object($int))
       { $date->add($int);
         $res=$date->getTimestamp() ;
       }
       LOGS()->reg_log('get_end_data','$start_data='.$start_data.' '.print_r($interval,true).' end_data='.date('d.m.Y H:i:s',$res)) ;
       return($res) ;
    }

    // создаем мероприятие
    // $event_ext: esmo_magnit_pmo/i_event_pmo
    //             events_opo/i_event_opo
    function create_event($event_ext)
    {  $result=[] ;
       $obj_event=$this->get_event_obj_by_ext($event_ext) ;
       if (!$obj_event->error)
         { $obj_event->default_settings['ext']=$event_ext ;
           $result['id']=$this->reg_event($obj_event->default_settings) ;
           $result['window_url']=$obj_event->url_page_event_card.$result['id'].'/edit/step1/' ;
           $result['success']=1 ;
         }
       else
       {
          $result['success']=0 ;
          $result['error']=$obj_event->error ;
       }
       return($result) ;
    }

    function reg_event($params)
     { $data['clss']=222 ;
       $data['enabled']=0 ; // enabled=1 только после заполнения всех данных по мероприятию
       $data['status']=1 ;
       $data['group_id']=(int)(($params['group_id'])? $params['group_id']:MEMBER()->cur_group_id) ;
	   if ($params['name']) $data['obj_name']=$params['name'] ;
       if ($params['type']) $data['type']=$params['type'] ;
       if ($params['ext']) $data['ext']=$params['ext'] ;
       if ($params['status']) $data['status']=$params['status'] ;
       if ($params['dyn_pass']) $data['dyn_pass']=$params['dyn_pass'] ;
       $reffer=adding_rec_to_table('obj_site_events_schedule',$data,array('return_reffer'=>1)) ;
       LOGS()->reg_log('Регистрация мероприятия','',array('reffer'=>$reffer)) ;
       list($id,$tkey)=explode('.',$reffer) ;
       $this->save_events($id,$params) ; // сохраняем ext_info
       return($id) ;
     }

    function save_events($event_id,$params)
    {   $rec_event=$this->get_event_by_id($event_id) ;
        //damp_array($params) ;
        $data=array() ;

        if (isset($params['active'])) $data['enabled']=$params['active'] ;
        if (isset($params['enabled'])) $data['enabled']=$params['enabled'] ;
        if ($params['name']) $data['obj_name']=$params['name'] ;
        if ($params['mode']) $data['mode']=$params['mode'] ;
        if ($params['type']) $data['type']=$params['type'] ;
        if ($params['dyn_pass']) $data['dyn_pass']=$params['dyn_pass'] ;
        if ($params['alert_from']) $data['alert_from']=ENGINE()->strtotime($params['alert_from']) ;
        if ($params['alert_to']) $data['alert_to']=ENGINE()->strtotime($params['alert_to'],['default_His'=>'23:59:59']) ;
        if (isset($params['block_from'])) $data['block_from']=($params['block_from'])? ENGINE()->strtotime($params['block_from']):0 ;
        if ($params['block_to']) $data['block_to']=ENGINE()->strtotime($params['block_to'],['default_His'=>'23:59:59']) ;
        if ($params['data_from']) $data['date_from']=ENGINE()->strtotime($params['data_from']) ;
        if ($params['date_from']) $data['date_from']=ENGINE()->strtotime($params['date_from']) ;
        if ($params['data_to']) $data['date_to']=ENGINE()->strtotime($params['data_to'],['default_His'=>'23:59:59']) ;
        if ($params['date_from']) $data['date_from']=ENGINE()->strtotime($params['date_from']) ;
        if ($params['date_to']) $data['date_to']=ENGINE()->strtotime($params['date_to'],['default_His'=>'23:59:59']) ;
        if ($params['group_id']) $data['group_id']=$params['group_id'];
        if ($params['viewer_name']) $data['viewer_name']=$params['viewer_name'];
        if ($params['account_id']) $data['account_id']=$params['account_id'] ;
        if (isset($params['arhive']))
        { if ($params['arhive']==1) $data['status']=5;
          if ($params['arhive']==0) $data['status']=1;
        }
        if ($params['doc_code'])
        { $data['doc_code']=$params['doc_code'];
          if (!$data['obj_name']) $data['obj_name']=ENGINE()->docs_list[$data['doc_code']]['name'] ;
        }
        if ($params['alert']>0)
        {  $data['alert']=$params['alert'] ;
          // вычисляем срок начала уведомлений о мероприятии
          $date = new DateTime($params['data_from']);
          $int=null ;
          switch($params['alert'])
          { case 1: $int=new DateInterval('P3D') ; break ;
            case 2: $int=new DateInterval('P7D') ; break ;
            case 3: $int=new DateInterval('P14D') ; break ;
            case 4: $int=new DateInterval('P1M') ; break ;
            case 5: $int=new DateInterval('P3M') ; break ;
          }
          if (is_object($int))
          { $date->sub($int);
            $data['date_alert']=$date->getTimestamp() ;
          }
        }
        //if (isset($params['filter_json']))            $data['filter']=$params['filter_json'] ;
        if (isset($params['info_filter']))            $data['info_filter']=$params['info_filter'] ;
        if (isset($params['viewer_name']))            $data['viewer_name']=$params['viewer_name'] ;

        $ext_info=$rec_event['_ext_info'] ;
        //damp_array($params) ;
        // !!! $params['group_ids'] - массив, $ext_info['group_ids'] - строка
        if (isset($params['group_ids']))              $ext_info['group_ids']=implode(',',$params['group_ids']) ;
        if (isset($params['mo_tk']))              $ext_info['mo_tk']=implode(',',$params['mo_tk']) ;
        if ($params['atp_ids'])                $ext_info['atp_ids']=implode(',',$params['atp_ids']) ;
        if ($params['rc_ids'])                 $ext_info['rc_ids']=implode(',',$params['rc_ids']) ;
        if ($params['working'])                $ext_info['working']=implode(',',$params['working']) ;
        if ($params['group_pers'])             $ext_info['group_pers']=implode(',',$params['group_pers']) ;
        if ($params['group_medic'])            $ext_info['group_medic']=implode(',',$params['group_medic']) ;
        if ($params['age_from'])               $ext_info['age_from']=$params['age_from'] ;
        if ($params['age_to'])                 $ext_info['age_to']=$params['age_to'] ;
        if ($params['use_docs'])               $ext_info['use_docs']=$params['use_docs'] ;
        if ($params['message1'])               $ext_info['message1']=$params['message1'] ;
        if ($params['message2'])               $ext_info['message2']=$params['message2'] ;
        if ($params['period_to_status_1'])     $ext_info['period_to_status_1']=$params['period_to_status_1'] ;
        if ($params['period_to_status_2'])     $ext_info['period_to_status_2']=$params['period_to_status_2'] ;
        if ($params['period_to_status_3'])     $ext_info['period_to_status_3']=$params['period_to_status_3'] ;
        if ($params['period_to_status_4'])     $ext_info['period_to_status_4']=$params['period_to_status_4'] ;
        if ($params['period_to_status_5'])     $ext_info['period_to_status_5']=$params['period_to_status_5'] ;
        if ($params['period_to_status_6'])     $ext_info['period_to_status_6']=$params['period_to_status_6'] ;
        if ($params['period_to_status_7'])     $ext_info['period_to_status_7']=$params['period_to_status_7'] ;
        if ($params['select_personals'])     $ext_info['select_personals']=$params['select_personals'] ;
        if ($params['local_usl_select'])       $ext_info['local_usl_select']=($params['local_usl_select']==1)? 1:0 ;
        if (isset($params['deadline_day']))           $ext_info['deadline_day']=($params['deadline_day'])?:0 ;
        if (isset($params['day_delay']))               $ext_info['day_delay']=($params['day_delay'])?:0 ;
        if (isset($params['view_from_day']))           $ext_info['view_from_day']=($params['view_from_day'])?:0 ;
        if (isset($params['popisant_persons'])) $ext_info['popisant_persons']=$params['popisant_persons'] ;
        // если передан флаг собственных условий отбора сотрудников и он сброшен
        // надо 1. вьвер мероприятия должен отдавать всех активных сотрудников
        //
        if (isset($params['local_usl_select']) and ($params['local_usl_select']==2 or !$params['local_usl_select']))
        { $data['viewer_name']='view_personals_active' ;
          // удаляем записи по филтрам из personals_filter
          PERSONALS_FILTER()->delete_rec_of_personals_filter($rec_event['_reffer']);
        }


        if ($params['local_themes'])            $ext_info['local_themes']=($params['local_themes']==1)? 1:0 ;
        if ($params['auto_status_2'])           $ext_info['auto_status_2']=$params['auto_status_2'] ;
        if ($params['auto_status_3'])           $ext_info['auto_status_3']=$params['auto_status_3'] ;
        if (isset($params['block_pmo_end']))           $ext_info['block_pmo_end']=$params['block_pmo_end'] ;
        if ($params['close_period'])           $ext_info['close_period']=$params['close_period'] ;
        if ($params['close_status'])           $ext_info['close_status']=$params['close_status'] ;
        if (isset($params['sanction']['block_mo']))   $ext_info['block_mo']=($params['sanction']['block_mo'])? 1:0 ;
        if ($params['sanction']['block_pl'])   $ext_info['block_pl']=1 ;
        if ($params['sanction']['block_to'])   $ext_info['block_to']=1 ;
        // старая схема хранения информации по сотрудникам мероприятия
        // переводим в новый формат
        if ($ext_info['filter'] and !_sizeof($ext_info['personals']))
        {   $ext_info['personals'][]=['filter'=>$ext_info['filter'],'info_filter'=>$ext_info['info_filter']] ;
            $ext_info['filter']='' ;
            $ext_info['usl_select']='' ;
            $ext_info['info_filter']='' ;
        }
        // если данные для сохранения передаены в старом формате, сохраняем сразу в старом формате
        if ($params['filter'])
        {   //$ext_info['personals']=[] ;
            $ext_info['personals'][]=['filter'=>$params['filter'],'info_filter'=>$params['info_filter']] ;
        }
        // новая схема хранения инфоомации по сотрудникам мероприятия
        if (isset($params['personals']))
        {   //$ext_info['personals']=[] ;
            $ext_info['personals'][]=$params['personals'] ;
        }
        // удаление условия отбора сотрудников
        if (isset($params['personals_filter_item_remove']))
        {   // если передаем значение >0  - это индекс элемента в новом формате
            if ($params['personals_filter_item_remove']) unset($ext_info['personals'][$params['personals_filter_item_remove']-1]);
            // инача удаляем значение в старом формате
            else
            {   $ext_info['filter']='' ;
                $ext_info['usl_select']='' ;
                $ext_info['info_filter']='' ;
            }
        }
        if (isset($params['themes_ids']))            $ext_info['themes_ids']=$params['themes_ids'] ;
        if (isset($params['groups_ids']))            $ext_info['groups_ids']=$params['groups_ids'] ;
        if ($params['event_docs'])                  $ext_info['event_docs']=$params['event_docs'] ;
        if ($params['level'])                       $ext_info['level']=$params['level'] ;
        if ($params['mo_type'])                     $ext_info['mo_type']=$params['mo_type'] ;
        if ($params['pmo_len'])                  $ext_info['pmo_len']=$params['pmo_len'] ;
        if ($params['pmo_len_union'])                  $ext_info['pmo_len_union']=$params['pmo_len_union'] ;
        if ($params['pmo_before'])              $ext_info['pmo_before']=$params['pmo_before'] ;
        if (isset($params['covid_before']))              $ext_info['covid_before']=$params['covid_before'] ;
        if (isset($params['covid_before2']))              $ext_info['covid_before2']=$params['covid_before2'] ;
        if ($params['date_from_to_orgs'])              $ext_info['date_from_to_orgs']=$params['date_from_to_orgs'] ;
        if ($params['emails_to_orgs'])              $ext_info['emails_to_orgs']=$params['emails_to_orgs'] ;
        if ($params['adres_to_orgs'])              $ext_info['adres_to_orgs']=$params['adres_to_orgs'] ;
        if ($params['name_to_orgs'])              $ext_info['name_to_orgs']=$params['name_to_orgs'] ;
        if ($params['mo_content_mode'])              $ext_info['mo_content_mode']=$params['mo_content_mode'] ;
        if ($params['select_content_mode'])              $ext_info['select_content_mode']=$params['select_content_mode'] ;
        if ($params['full_content_mode'])              $ext_info['full_content_mode']=$params['full_content_mode'] ;
        if ($params['persons_ids_ext'])              $ext_info['persons_ids_ext']=$params['persons_ids_ext'] ;
if ($params['moment'])              $ext_info['moment']=$params['moment'] ;
        if ($params['method'])              $ext_info['method']=$params['method'] ;
        if ($params['question_count'])              $ext_info['question_count']=$params['question_count'] ;
        if ($params['put_mode'])              $ext_info['put_mode']=$params['put_mode'] ;
        //if ($params['mo_tk'])              $ext_info['mo_tk']=$params['mo_tk'] ;
        if (isset($params['allow_days']))               $ext_info['allow_days']=$params['allow_days'] ;

        // !! лучще сделать json_encode чем потом будеи serialize

        //мероприятие ПФО
        if ($params['pfo_before'])              $ext_info['pfo_before']=$params['pfo_before'] ;
        if ($params['pfo_len'])                  {
            $ext_info['pfo_len']=$params['pfo_len'] ;
            if ($params['pfo_len'] == 1) {
                $ext_info['block_mo'] = 0;
                if (_sizeof($ext_info['list_tests1'])) foreach ($ext_info['list_tests1'] as $id=>$test) if ($test!=1 && $test!=8) unset($ext_info['list_tests1'][$id]);
                if (!_sizeof($ext_info['list_tests1'])) $ext_info['list_tests1']=[1,8];
            } else $ext_info['method_send_event']=3 ;
        }

        if ($params['method_send_event']){ //проверяем способ доведения (почта, терминал, лк)
            $ext_info['method_send_event']=$params['method_send_event'] ;
            if ( $params['method_send_event'] == 2) { //терминал
                if (isset($params['allow_days']))              $ext_info['allow_days']=$params['allow_days'] ;
                if (isset($params['full_content_mode']))              $ext_info['full_content_mode']=$params['full_content_mode'] ;
                if ($params['list_tests1'])              {
                    //если назначены ВСР и СЗМР, тест ВСР должен обязательно идти первым (нужно для одновременного прохождения)
                    if (in_array(1,$params['list_tests1']) && in_array(8,$params['list_tests1'])) {
                        $szmr = array_search(8,$params['list_tests1']);
                        unset($params['list_tests1'][$szmr]);
                        array_unshift($params['list_tests1'],8);
                    }
                    $ext_info['list_tests1']=$params['list_tests1'] ;
                }
            } else if ( $params['method_send_event'] == 3){ //виртуальный терминал
                if ($params['list_tests1'])              $ext_info['list_tests1']=$params['list_tests1'] ;
                $ext_info['allow_days'] = 0;
            }
        }
        $data['dyn_pass']=0;

        $data['ext_info']=$ext_info ;
        //damp_array($data) ;

        update_rec_in_table('obj_site_events_schedule',$data,'pkey='.$event_id,array('debug'=>0)) ;

        // удаляем кеш БД - там старые данные
        unset($GLOBALS['db_cashe']['obj_site_events_schedule'][$event_id]) ;
        LOGS()->reg_log('events_change','',array('data'=>$params,'reffers'=>array($rec_event['_reffer']))) ;

          // проверяем правильность задания  LS_esmo_ag_event
		$LS_esmo_ag_event=execSQL_value('select pkey from obj_site_events_schedule where ext="events_docs/i_event_docs" and doc_code="napravlenie" order by pkey limit 1') ;
		if ($GLOBALS['LS_esmo_ag_event']!=$LS_esmo_ag_event) update_site_setting('LS_esmo_ag_event',$LS_esmo_ag_event) ;
		// проверяем правильность задания  LS_esmo_intro_id
		$LS_esmo_intro_id=execSQL_value('select pkey from obj_site_events_schedule where ext="esmo_intro/i_event_docs_intro" order by pkey limit 1') ;
		if ($GLOBALS['LS_esmo_intro_id']!=$LS_esmo_intro_id) update_site_setting('LS_esmo_intro_id',$LS_esmo_intro_id) ;
    }

    function get_event_by_id($id,$options=array())
    { if (isset($GLOBALS['db_cashe']['obj_site_events_schedule'][$id])) $rec=$GLOBALS['db_cashe']['obj_site_events_schedule'][$id] ;
      else
    { $rec=execSQL_van('select * from obj_site_events_schedule where pkey='.$id) ;
        $GLOBALS['db_cashe']['obj_site_events_schedule'][$id]=$rec ;
      }
      if ($rec['pkey']) $this->prepare_public_info_to_event($rec,$options) ;
      return($rec) ;
    }

    /* НЕ ИСПОЛЬЗУЕТСЯ
    function get_event_obj($value)
    {   if (is_int($value)) $rec_event=EVENTS()->get_event_by_id($value) ;
        else                $rec_event=$value ;
    	$event_ext=$rec_event['ext'] ;
    	if (file_exists(_DIR_EXT.'/'.$event_ext.'.php'))
         { include_once(_DIR_EXT.'/'.$event_ext.'.php') ;
           list($ext,$class)=explode('/',$event_ext) ;
           if (class_exists($class))
           { $obj_event=new $class() ;
	         $obj_event->rec_event=$rec_event ;
	         $obj_event->script_dir=hide_server_dir(_DIR_EXT.'/'.$event_ext.'.php') ;
	         $obj_event->class_name=$class ;
           }
           else $obj_event=(object) array('error' => '<strong>'.$event_ext.'</strong> - не найден класс события '.$class.'<br>');
         } else $obj_event=(object) array('error' => '<strong>'.$event_ext.'</strong> - не найден класс события '._DIR_EXT.'/'.$event_ext.'.php<br>');
        return($obj_event) ;
    }*/

    // // добавлен учет локального класса
    function get_event_obj_by_ext($event_ext,$options=[])
    {   $fdir='' ; $is_local=0 ;
        list($ext,$class_name)=explode('/',$event_ext) ;
        $script_name=$class_name.'.php' ;
    	if (isset($GLOBALS['_SETTING']['ext_local'][$ext]) and file_exists(_DIR_EXT_LOCAL.'/'.$ext.'/'.$script_name))  { $fdir=_DIR_EXT_LOCAL.'/'.$ext.'/'.$script_name ; $is_local=1 ; }
	    elseif (file_exists(_DIR_EXT.'/'.$ext.'/'.$script_name))    $fdir=_DIR_EXT.'/'.$ext.'/'.$script_name ;
    	//echo '$fdir='.$fdir.'<br>';
	    if ($fdir)
         { include_once($fdir) ;
           // сначала ищем функцию класса, например EVENT_OPO - это посволит не создавть объект мероприятия несколько раз, если он уже был создан ранее в рамках текущего сеанса
           $func_name=strtoupper(mb_substr($class_name,2,strlen($class_name)-2)) ;
           if (function_exists($func_name)) $obj_event=$func_name($options) ;
           else if (class_exists($class_name)) $obj_event=new $class_name($options) ;
           else $obj_event=(object) array('error' => '<strong>'.$event_ext.'</strong> - не найден класс события '.$class_name.'<br>');
         } else $obj_event=(object) array('error' => '<strong>'.$event_ext.'</strong> - не найден класс события '.hide_server_dir($fdir).'<br>');
        $obj_event->is_local=$is_local ;
        return($obj_event) ;
    }

    function get_event_obj_by_id($id)
    {   if ($id)
        { $ext=(isset($GLOBALS['db_cashe']['obj_site_events_schedule'][$id]))? $GLOBALS['db_cashe']['obj_site_events_schedule'][$id]['ext']:execSQL_value('select ext from obj_site_events_schedule where pkey='.$id) ;
          $obj_event=$this->get_event_obj_by_ext($ext);
        } else  $obj_event=null ;
	    return($obj_event) ;
    }

    // возвращает экземляр события, которое отвечает за выдачу/прием указанного типа докуента
    // добавлен учет локального класса
    function get_event_obj_by_doc_type($doc_code)
    { //damp_array(REPORTS()->docs_list[$doc_code]);

      $doc_script=REPORTS()->docs_list[$doc_code]['script_dir']; // events_opo/doc_zakluchenie_opo.php echo '$doc_script='.$doc_script.'<br>' ;
      list($ext,$script_name)=explode('/',$doc_script) ;
      if (isset($GLOBALS['_SETTING']['ext_local'][$ext]) and file_exists(_DIR_EXT_LOCAL.'/'.$ext.'/'.$script_name)) $dir_doc_script=_DIR_EXT_LOCAL.'/'.$ext.'/'.$script_name ;
      else $dir_doc_script=_DIR_EXT.'/'.$ext.'/'.$script_name ; //
      // $dir_doc_script = /var/opt/esmo/esmo-server/www/magnit.kvzrm.ru/local_v.202105196387.magnit/ext/events_opo/doc_zakluchenie_opo.php
      //echo '$dir_doc_script='.$dir_doc_script.'<br>' ;

      $doc_class=REPORTS()->docs_list[$doc_code]['class_name'];
      include_once($dir_doc_script) ;
      if (class_exists($doc_class))
      { $doc_obj=new $doc_class() ;
        // если документ связан с мероприятием, в $dir_doc_script документа будет задан код мероприятия
        // $doc_obj->event_obj_class='events_opo/i_event_opo'  ;
        if (isset($doc_obj->event_obj_class) and $doc_obj->event_obj_class!="")
        { $event_ext=$doc_obj->event_obj_class ; // events_opo/i_event_opo
          //echo '$event_ext='.$event_ext.'<br>' ;
          $obj_event=$this->get_event_obj_by_ext($event_ext) ;
          $obj_event->event_ext=$event_ext ;
        } else $obj_event=(object) array('error' => 'В документе <strong>'.hide_server_dir($dir_doc_script).'</strong> - не определено поле "event_obj_class"<br>');
      } else $obj_event=(object) array('error' => 'Не найден класс документа <strong>'.$doc_class.'</strong><br>');
        return($obj_event) ;
    }


    function prepare_public_info_to_event(&$rec,$options=array())
    {  if (!$rec['ext']) $rec['ext']='esmo_magnit_pmo/i_event_pmo' ;

       if ($rec['ext_info']) $rec['_ext_info']=unserialize($rec['ext_info']) ;
       if ($rec['_ext_info']===false) $rec['_ext_info']=json_decode($rec['ext_info'],1) ;

       $obj_event=(isset($options['event_obj']) and is_object($options['event_obj']))? $options['event_obj']:$this->get_event_obj_by_ext($rec['ext'],['rec_event'=>$rec]) ;

       if ($obj_event->error) { $rec['error']=$obj_event->error ; if (MEMBER()->rol==1) echo $obj_event->error ; return ;}

       $rec['__href']=$obj_event->get_url_event_card($rec['pkey'])  ;
       $rec['__type_name']=$obj_event->name ;
       if (!$rec['obj_name']) $rec['obj_name']=$obj_event->name.' ID '.$rec['pkey'] ;
       $rec['__href_name']='<a href="'.$rec['__href'].'" class="new_window" target="_blank" title="window_event">'.$rec['obj_name'].'</a>' ;


       if (!$rec['viewer_name']) $rec['viewer_name']='view_personals_active' ; //viewer_name

       $rec['_ext_info']['_group_ids']=array() ;
       if ($rec['_ext_info']['group_ids'])
       {   $arr=explode(',',$rec['_ext_info']['group_ids']) ;
           if (!$GLOBALS['ARR_esmo_group_names']) $GLOBALS['ARR_esmo_group_names']=execSQL_row('select pkey,obj_name,clss from obj_site_account where clss in (206,1)') ;
           if (_sizeof($arr)) foreach($arr as $id) if (isset($GLOBALS['ARR_esmo_group_names'][$id])) $rec['_ext_info']['_group_ids'][]=$GLOBALS['ARR_esmo_group_names'][$id] ;
       }
       else $rec['_ext_info']['_group_ids'][]='Все группы' ;
       $rec['_group_ids']=(_sizeof($rec['_ext_info']['_group_ids']))? implode('<br>',$rec['_ext_info']['_group_ids']):'все группы' ;

       if ($rec['_ext_info']['atp_ids'] or $rec['_ext_info']['rc_ids'])
       {   $arr1=explode(',',$rec['_ext_info']['atp_ids']) ;
           $arr2=explode(',',$rec['_ext_info']['rc_ids']) ;
           $arr=array_merge($arr1,$arr2) ;
           if (!$GLOBALS['ARR_org_names']) $GLOBALS['ARR_org_names']=execSQL('select * from obj_site_personals where parent=1 and clss=207 order by obj_name') ;
           if (_sizeof($arr)) foreach($arr as $id)  $rec['_ext_info']['_orgs_ids'][]=$GLOBALS['ARR_org_names'][$id]['obj_name'] ;
           //damp_array($rec['_ext_info']['_orgs_ids']) ;
           if (_sizeof($rec['_ext_info']['_orgs_ids']))   $rec['_ext_info']['_person_filter']['Организация']=implode('<br>',$rec['_ext_info']['_orgs_ids']) ;
           //damp_array($rec['_ext_info']['_person_filter']) ;
       }
        //$recs_orgs=execSQL('select * from obj_site_personals where parent=1 and clss=207 order by obj_name') ;
       //$rec['_member_name']=ACCOUNTS()->get_member_name_by_id($rec['member_id'])  ;
       //$rec['_date_create']=date('d.m.Y H:i',$rec['c_data']) ;
       //$rec['_date_podpis']=($rec['sign_data'])? date('d.m.Y H:i',$rec['sign_data']):'-' ;
       //$rec['_source']='<span class="nowrap">'.(($rec['account_upload'])? '<i class="fa fa-user" aria-hidden="true"></i> '.$rec['_account_upload_name']:'<i class="fa fa-envelope-o" aria-hidden="true"></i> '.$rec['source']).'</span>';
	    $arr_status=array() ;
        if ($rec['status']==5) $arr_status[]='<span class="blue">АРХИВ</span>' ;
        else
        { $arr_status[]=($rec['enabled'])? '<span class="green">Включено</span>':'<span class="red">Выключено</span>' ;

          $time_status='<div class="green">Срок мероприятия наступил</div>' ;
          if ($rec['date_from'] and time()<$rec['date_from']) $time_status='<div class="red">Срок мероприятия еще не наступил</div>' ;
          if ($rec['date_to'] and time()>$rec['date_to'])     $time_status='<div class="red">Срок мероприятия уже вышел</div>';
          if (!$rec['date_from'] and !$rec['date_to'])  $time_status='' ;
          $rec['_time_status']=$time_status ;
        }

        // добавить статусы на основе срока действия мероприятия и текущего времени

        //$arr_status[]=($rec['enabled'])? '<span class=green>Включено</span>':'<span class=red>Выключено</span>' ;
	    $rec['_status']=implode('<br>',$arr_status) ;

        if ($rec['date_from'] and !$rec['date_to']) $rec['_date_from_to']='c '.date('d.m.Y',$rec['date_from']) ;
        if (!$rec['date_from'] and $rec['date_to']) $rec['_date_from_to']='по '.date('d.m.Y',$rec['date_to']) ;
        if ($rec['date_from'] and $rec['date_to'])  $rec['_date_from_to']='c '.date('d.m.Y',$rec['date_from']).' по '.date('d.m.Y',$rec['date_to']) ;

        $tt=getdate() ;
        $day=$tt['mday'] ;
        $ff=$day%2 ;

        if ($rec['_ext_info']['allow_days']==1) $rec['_day_status']=($ff)? '<div class="green">Показ по нечетным дням</div>':'<div class="red">Показ по нечетным дням</div>';
        if ($rec['_ext_info']['allow_days']==2) $rec['_day_status']=(!$ff)? '<div class="green">Показ по четным дням</div>':'<div class="red">Показ по четным дням</div>';
        if (!$rec['_ext_info']['moment']) $rec['_ext_info']['moment']=2 ;

        if ($rec['mode']) $rec['_mode']=$_SESSION['ARR_events_mode'][$rec['mode']] ;


        if (method_exists($obj_event,'prepare_public_info_to_event')) $obj_event->prepare_public_info_to_event($rec,$options) ;


    }

    // обновляет список учасников мероприятия (obj_site_events_pass) на основе данных вьювера мероприятия
    function update_event_personals($event_id,$options=array())
    { $rec_event=$this->get_event_by_id($event_id) ;
      //$this->update_event_viewer($rec_event) ;
      //$temp_viewer_name=PERSONALS_FILTER()->get_viewer_name_by_filter_reffer($rec_event['_reffer']) ;
      // берем уникальные значения, так как вьювер будет возвращать дубликаты ID для совмещенцев - устарело
      // новый вьювер возвращает уникальные значения
      $personals_ids=execSQL_line('select pkey from '.$rec_event['viewer_name']) ;
      $result=$this->add_personals_to_event($event_id,$personals_ids,$options) ;
      return($result) ;
    }

    // обновляет список учасников мероприятия (obj_site_events_pass) на основе переданных ID сотрудников
    function add_personals_to_event($event_id,$personals_ids,$options=array())
    {  if (!is_array($personals_ids)) $personals_ids=array($personals_ids) ;
       echo 'Передано обновление участия: <strong>'._sizeof($personals_ids).'</strong> ID сотрудников<br>' ;
        if (_sizeof($personals_ids)<10) echo implode(', ',$personals_ids).'<br><br>' ;
       $rec_event=$this->get_event_by_id($event_id) ;
       $obj_event=$this->get_event_obj_by_id($event_id) ;
       $result=array('repair'=>0,'remove'=>0,'exist'=>0,'repeat'=>0,'add'=>0) ;
       // проверяем, кто уже добавлен
	   $exist_ids=execSQL_row('select personal_id,status from obj_site_events_pass where event_id='.$event_id.' and enabled=1') ;
	   $cnt_before=_sizeof($exist_ids) ;
       FILE_LOG()->append('На текущий момент в мероприятии состоит: <strong>'.$cnt_before.'</strong> enabled сотрудников') ;
       echo 'На текущий момент в мероприятии состоит: <strong>'.$cnt_before.'</strong> enabled сотрудников<br>' ;
       if (_sizeof($exist_ids)<10) echo implode(', ',array_keys($exist_ids)).'<br><br>' ;

	   $remove_ids=execSQL_row('select personal_id,status from obj_site_events_pass where event_id='.$event_id.' and enabled=0') ;
       $cnt_before_disabled=_sizeof($remove_ids) ;
       FILE_LOG()->append('На текущий момент в мероприятии состоит: <strong>'.$cnt_before_disabled.'</strong> disabled сотрудников') ;
       echo 'На текущий момент в мероприятии состоит: <strong>'.$cnt_before_disabled.'</strong> disabled сотрудников<br>' ;
       if (_sizeof($remove_ids)<10) echo implode(', ',array_keys($remove_ids)).'<br><br>' ;

	   $row=0 ; $cnt_to_add=_sizeof($personals_ids)-_sizeof($exist_ids) ;  $result['remove']=0 ; $result['add']=0 ;$result['exist']=0 ;$result['repeat']=0 ;

       foreach($personals_ids as $i=>$personal_id)
       { // если сотрудник уже участвуеб в мероприятии
         if (isset($exist_ids[$personal_id]))
         {  $result['exist']++ ;
            if ($options['show_status']) echo $personal_id.' - уже состоит в мероприятии со статусом '.$exist_ids[$personal_id].'<br>' ;
            // если передан внешний статус и текущий статус отличается от внешнего - меняем статус
            if ($options['ext_status'] and $options['ext_status']!=$exist_ids[$personal_id])
            {
                EVENTS()->set_event_personal_data($event_id,$personal_id,array('status'=>$options['ext_status'],'enabled'=>1),'Установлен внешний статус',array('old_status'=>$exist_ids[$personal_id],'ignore_not_change_status'=>1)) ;
                if ($options['ext_status']==7)  PERSONAL()->messages_personal_close($personal_id,$rec_event['ext'],['event_id'=>$rec_event['pkey']]) ;
            }
            unset($exist_ids[$personal_id]) ; // удаляем сотрудника из списка. В итоге в списке остануться только те, кого нет на добавление - их будем удалять
         }
         // если будем восстанавливать сотрудника в мероприятии
         elseif (isset($remove_ids[$personal_id]))
         { // восстанавливаем сотрудника в мероприятии
            // вводный инструктаж перед восстановлением сотрудника должен проверить, не изменилась ли у него организация
            if (method_exists($obj_event,'personal_pass_repair')) $result['repair']+=$obj_event->personal_pass_repair($event_id,$personal_id,['ext_status'=>$options['ext_status']]) ;
            else
            {   $last_status=$remove_ids[$personal_id] ;
                $new_status=$last_status ;
                if ($options['ext_status']) $new_status=$options['ext_status'] ;
                echo $personal_id.' - восстановлен в мероприятии со статусом '.$new_status.'<br>' ;
                FILE_LOG()->append($personal_id.' - будет восстановлен в мероприятии со статусом '.$new_status) ;
                EVENTS()->set_event_personal_data($event_id,$personal_id,array('status'=>$new_status,'enabled'=>1),'Восстановлен в мероприятии',array('old_status'=>$last_status,'ignore_not_change_status'=>1)) ;
                // активируем сообщения
                $rec_pass=execSQL_van('select * from obj_site_events_pass where event_id='.$event_id.' and personal_id='.$personal_id) ;
                if ($rec_pass['mess_id']) PERSONAL()->message_personal_enabled($rec_pass['mess_id']) ;
                // поиск сообщений по source_pkey и source_tkey
                $mess_ids=execSQL_line('select pkey from obj_site_personal_mess where source_pkey='.$rec_pass['pkey'].' and source_tkey='.$rec_pass['tkey'].' and status!=4') ;
                if (_sizeof($mess_ids)) foreach($mess_ids as $mess_id) PERSONAL()->message_personal_enabled($mess_id) ;
                $result['repair']++ ;
                }

         }
         // если сотрудник ранее не участвавал в мероприятии
         else
         {
           $status=($options['status'])?:1 ;
           if ($options['ext_status']) $status=$options['ext_status'] ; // внешний статус передается через опцию ext_status
           $parent=($options['ext_status'])?2:1 ; // если был установлен внешний статус parent=2
           echo $personal_id.' - будет добавлен в мероприятии со статусом '.$status.'<br>' ;
	       $data=array('clss'=>223,
                       'event_id'=>$event_id,
                       'personal_id'=>$personal_id,
                       'account_id'=>(MEMBER()->id)? MEMBER()->id:0,
                       'status'=>(int)$status,
                       'r_data'=>time(),
                       'c_data'=>time(),
                       'enabled'=>1,
	                   'parent'=>$parent,
			           'data_from'=>0,
			           'data_to'=>0
	                                                            ) ;
	       if ($options['data_from']) $data['data_from']=(int)$options['data_from'] ;
	       if ($options['data_to'])   $data['data_to']=(int)$options['data_to'] ;

	       $row++ ;
           if (!$rec_event['dyn_pass']) multiSQL_insert('obj_site_events_pass')->append($data,'Добавлено '.$row.' сотрудников из '.$cnt_to_add) ;

           $result['add']++ ;
         }

         // на второй круг - опция передается только из i_event_pmo вместе со списоком сотрудников, кому положено на второй круг
         if ($options['pass_repeat'])
         { $row++ ;
           EVENTS()->set_event_personal_data($event_id,$personal_id,array('status'=>1,'fname'=>'','time_print'=>0,'mess_id'=>0,'result'=>0,'doc_id'=>0,'group_id'=>0,'close_data'=>0,'scan_id'=>0,'block_data'=>0),'Подлежит повторному прохождению по истечению срока действия') ;
	       FILE_LOG()->append('Повторное направление на мероприятия - '.$row.' сотрудников из '.$cnt_to_add) ;
	       echo $personal_id.' - будет повторно направлен на мероприятии со статусом 1<br>' ;
	       $result['repeat']++ ;
	       unset($exist_ids[$personal_id]) ;
         }


         //if ($result['add']>4) break ;
       }
	   multiSQL_insert('obj_site_events_pass')->flush(1,'Добавлено '.$row.' сотрудников из '.$cnt_to_add) ;

       if ($options['remove_outer'])
       { FILE_LOG()->append('Удаление из мероприятия - '._sizeof($exist_ids).' сотрудников') ;
         echo 'Подлежат удалению из мероприятия <strong>'._sizeof($exist_ids).'</strong> сотрудников<br>' ;
         $i=1 ;
       	 if (_sizeof($exist_ids)) foreach($exist_ids as $personal_id=>$status)
         {	echo $personal_id.' - будет удален из мероприятия со статусом '.$status.'<br>' ;
            FILE_LOG()->append($personal_id.' - будет удален из мероприятия со статусом '.$status) ;
            $this->delete_personal_from_event($event_id,$personal_id,array('cnt_all'=>_sizeof($exist_ids),'cur_pos'=>$i)) ;
         	$i++ ;
         	$result['remove']++ ;
         }

       }

        echo '--------------------------------------------------------------<br>' ;
	    echo 'Состояло в мероприятии: <strong>'.$cnt_before.'</strong> сотрудников <br>' ;
	    echo 'Добавлены в мероприятие:  <strong>'.$result['add'].'</strong> сотрудников <br>' ;
	    echo 'Восстановлены в мероприятии:  <strong>'.$result['repair'].'</strong> сотрудников <br>' ;
	    echo 'Повторно направлены:  <strong>'.$result['repeat'].'</strong> сотрудников <br>' ;
		echo 'Удалены из мероприятия:  <strong>'.$result['remove'].'</strong> сотрудников <br>' ;


       return($result) ;
    }



    function add_personal_to_event($event_id,$personal_id,$status=1,$options=[])
    {  $account_id=(MEMBER()->id)?:0 ;
	   $data=['clss'=>223,
              'event_id'=>$event_id,
              'personal_id'=>$personal_id,
              'account_id'=>$account_id,
              'status'=>$status
             ];
       if ($options['c_data']) $data['c_data']=$options['c_data'];
       $res=adding_rec_to_table('obj_site_events_pass',$data,['return_reffer'=>1,'debug'=>0]) ;
       return($res) ;
    }

    function delete_personal_from_event($event_id,$personal_id,$options=array())
    {   $recs=execSQL('select * from obj_site_events_pass where event_id='.$event_id.' and personal_id='.$personal_id) ;
        if (_sizeof($recs)) foreach($recs as $rec)
        { if ($rec['mess_id']) PERSONAL()->message_personal_disabled($rec['mess_id']) ;
          // поиск сообщений по source_pkey и source_tkey
          $mess_ids=execSQL_line('select pkey from obj_site_personal_mess where source_pkey='.$rec['pkey'].' and source_tkey='.$rec['tkey'].' and status!=4') ;
          if (_sizeof($mess_ids)) foreach($mess_ids as $mess_id) PERSONAL()->message_personal_disabled($mess_id) ;
          execSQL_update('update obj_site_events_pass set enabled=0 where pkey='.$rec['pkey']) ;
          EVENTS()->set_event_personal_data($event_id,$personal_id,array('status'=>$rec['status']),'Сотрудник удален из мероприятия',array('old_status'=>$rec['status'],'ignore_not_change_status'=>1)) ;

          // через опции  cnt_all и cur_pos передается информация о текущем отправке сообщений при отправке большого числа сообщений
	      $count_stats=($options['cnt_all'] and $options['cur_pos'])? '('.$options['cur_pos'].' из '.$options['cnt_all'].')':'' ;
	      FILE_LOG()->append('Удаление из мероприятия - сотрудник ID '.$personal_id.' '.$count_stats) ;
        }


    }

    function set_personals_status($event_id,$personals_ids,$status)
    {
       if (!is_array($personals_ids)) $usl_select_personal=($personals_ids=='all')? '':' and personal_id='.$personals_ids ;
       else                           $usl_select_personal=' and personal_id in ('.implode(',',$personals_ids).')' ;
       execSQL_update('update obj_site_events_pass set status='.$status.' where event_id='.$event_id.$usl_select_personal,array('debug'=>0)) ;
    }

    function set_personal_status($event_id,$personal_id,$status)
    {
       execSQL_update('update obj_site_events_pass set status='.$status.' where event_id='.$event_id.' and personal_id='.$personal_id) ;
    }

    function set_event_personal_data($event_id,$personal_id,$data,$comment='',$options=array())
    {  $old_rec=array() ;
	   $old_status=($options['old_status'])? $options['old_status']:0 ;
       if (isset($data['status']) and !$old_status)
       {
       	  //$old_rec=execSQL_van('select pkey,status from obj_site_events_pass where event_id='.$event_id.' and personal_id='.$personal_id) ;
       	  $old_status=execSQL_value('select status from obj_site_events_pass where event_id='.$event_id.' and personal_id='.$personal_id) ;
       }

       update_rec_in_table('obj_site_events_pass',$data,'event_id='.$event_id.' and personal_id='.$personal_id,array('debug'=>0)) ;
	   echo 'Изменен статус участия в мероприятии ID <strong>'.$event_id.'</strong> сотрудник ID <strong>'.$personal_id.'</strong>, статус: <strong>'.$old_status.' => '.$data['status'].'</strong><br>' ;
       if (isset($data['status']) and ($data['status']!=$old_status or $options['ignore_not_change_status']))
       {  $rec_personal=PERSONAL()->get_personal_by_id($personal_id,array('no_public_info'=>1))  ;
          $rec_workers=PERSONAL()->get_main_second_workers_by_personal_id($personal_id)  ; // ролучаем список всех должносей сотрудника
       	 $data=array('clss'=>224,
		                                                        //'parent'=>($old_rec['pkey'])? $old_rec['pkey']:0,
		                                                        'obj_name'=>$comment,
		                                                        'indx'=>1,
		                                                        //'status_old'=>($old_rec['status'])? $old_rec['status']:0,
		                                                        'status_old'=>($old_status)? $old_status:0,
		                                                        'status_new'=>$data['status'],
                                                                 'c_data'=>($options['c_data'])?:time(),
		                                                        'event_id'=>$event_id,
                                                                 'personal_id'=>$personal_id,
		                                                        'doc_id'=>($data['doc_id'])? $data['doc_id']:0,
		                                                        'scan_id'=>($data['scan_id'])? $data['scan_id']:0,
		                                                        'data_from'=>($data['data_from'])? $data['data_from']:0,
		                                                        'data_to'=>($data['data_to'])? $data['data_to']:0,
		                                                        'group_id'=>($data['group_id'])? $data['group_id']:0,
		                                                        'person_name'=>$rec_personal['obj_name'],
		                                                        'person_org'=>$rec_workers['union']['_org_name'],
		                                                        'person_otdel'=>$rec_workers['union']['_otdel_name'],
		                                                        'person_working'=>$rec_workers['union']['_work_name'],
                                                                'account_id'=>($data['account_id'])? $data['account_id']:0,
                      ) ;
         if (!$options['read_only']) adding_rec_to_table('obj_site_events_pass_status',$data,array('no_return_id'=>1,'debug'=>0)) ;
         else echo 'adding_rec_to_table obj_site_events_pass: '.print_r($data,true).'<br>' ;
       }
    }

    function set_event_personal_data_by_id($id,$data,$comment='')
    {  $rec_pass=execSQL_van('select pkey,status,event_id,personal_id from obj_site_events_pass where pkey='.$id) ;
       $options['old_status']=$rec_pass['status'] ;
       if ($rec_pass['pkey']) $this->set_event_personal_data($rec_pass['event_id'],$rec_pass['personal_id'],$data,$comment,$options) ;
    }

    function create_lession_to_event($event_id,$theme_ids,$options=array())
    {   $count_theme=_sizeof($theme_ids) ;
    	$free_theme_name='' ; $recs_themes=array() ;
    	if (isset($theme_ids['free']))
	    {  $free_theme_name=$options['free_thema'] ;
	       unset($theme_ids['free']) ;
	    }
	    //damp_array($theme_ids,1,-1) ;
      $account_id=(MEMBER()->id)?:0;
      $group_id=(MEMBER()->cur_group_id)?:0;
       if (_sizeof($theme_ids)) $recs_themes=$this->get_themes_of_events($event_id,$theme_ids) ;
       if ($count_theme>1) { $theme_id=0 ; $rec_theme=array('obj_name'=>'Несколько тем') ; }
       elseif ($free_theme_name)  { $theme_id=0 ; $rec_theme=array('obj_name'=>$free_theme_name) ; }
       else	{ list($theme_id,$rec_theme)=each($recs_themes) ; }
       $data=array('clss'=>226,'event_id'=>$event_id,'theme_id'=>$theme_id,'account_id'=>$account_id,'group_id'=>$group_id,'status'=>1,'obj_name'=>$rec_theme['obj_name'])  ;
       if ($options['guest_info']) $data['guest_info']=$options['guest_info'] ;
       $lession_id=adding_rec_to_table('obj_site_lession',$data,array('return_reffer'=>0)) ;
       if (_sizeof($recs_themes)) foreach($recs_themes as $recs_theme) adding_rec_to_table('obj_site_lession_themes',array('clss'=>228,'event_id'=>$event_id,'parent'=>$lession_id,'theme_id'=>$recs_theme['pkey'],'account_id'=>$account_id,'status'=>1,'obj_name'=>$recs_theme['obj_name']),array('return_reffer'=>0)) ;
       if ($free_theme_name) adding_rec_to_table('obj_site_lession_themes',array('clss'=>228,'event_id'=>$event_id,'parent'=>$lession_id,'theme_id'=>0,'account_id'=>$account_id,'status'=>1,'obj_name'=>$free_theme_name),array('return_reffer'=>0)) ;
       return($lession_id) ;
    }

    function get_lession_by_id($id)
    { $rec=execSQL_van('select t1.*,t2.obj_name as account_name,t3.obj_name as group_name
                        from obj_site_lession t1 
                        left join obj_site_account t2 on t2.pkey=t1.account_id
                        left join obj_site_account t3 on t3.pkey=t1.group_id
                        where t1.pkey='.$id.'') ;
      if ($rec['pkey']) $this->prepare_public_info_to_lession($rec) ;
      return($rec) ;
    }

    function prepare_public_info_to_lession(&$rec,$options=array())
    {  $rec['__href']='/window/esmo_magnit_instruction/lession/'.$rec['pkey'].'/' ;
    }

    // регистрация сотрудника на занятии
    // personal lession status=1
    // personal event status=4
    function reg_personal_in_event($event_id,$personal_id,$status)
    {
       $data=['clss'=>227,
              'parent'=>1,
              'event_id'=>$event_id,
              'personal_id'=>$personal_id,
              'status'=>$status] ;

       $id=adding_rec_to_table('obj_site_events_pass',$data,array()) ;
       return($id) ;
    }

    // регистрация сотрудника на занятии
    // personal lession status=1
    // personal event status=4
    function reg_personal_in_lession($event_id,$lession_id,$personal_id)
    {
       $id=adding_rec_to_table('obj_site_lession_persons',array('clss'=>227,'parent'=>$lession_id,'event_id'=>$event_id,'personal_id'=>$personal_id,'account_id'=>MEMBER()->id,'status'=>1),array('return_reffer'=>0)) ;
       // в участии по мероприятию не надо отслеживать статусы прохождения занятия
       //EVENTS()->set_event_personal_data($event_id,$personal_id,array('status'=>4),'Сотрудник зарегистрировался на занятии') ;
       return($id) ;
    }

    // отмена регистрации сотрудника на заняттт
    // personal event status=3
    function lession_personal_unregister($event_id,$lession_id,$personal_id)
    {
      execSQL_update('delete from obj_site_lession_persons where parent='.$lession_id.' and personal_id='.$personal_id) ;
	  // в участии по мероприятию не надо отслеживать статусы прохождения занятия
      //EVENTS()->set_event_personal_data($event_id,$personal_id,array('status'=>3),'Сотрудник удален с занятия') ;
    }

    // начало заняти
    // personal lession status 1=>2
    // personal event status 4=>5
    function start_lession($lession_id)
    {  $rec_lession=$this->get_lession_by_id($lession_id);
	   // получаем всех сотрудников, которые зарегистрированы на занятие
       $personal_ids=execSQL_line('select personal_id from obj_site_lession_persons where parent='.$lession_id.' and status=1') ;
       if (_sizeof($personal_ids))
       { $data=array('status'=>3) ;
       $data['time_to']=0 ;
       if (!$rec_lession['time_from']) $data['time_from']=time() ;
       update_rec_in_table('obj_site_lession',$data,'pkey='.$lession_id) ;
       // переводим слушателей в мероприятии из статуса 4 [Прибыл на инструктаж] в статус 5 [Проходит инструктаж]
       //if (_sizeof($personal_ids)) foreach($personal_ids as $personal_id) EVENTS()->set_event_personal_data($rec_lession['event_id'],$personal_id,array('status'=>5),'Сотрудник начал прохождение инструктажа') ;
       // переводим слушателей в занятии из статуса 1 [Прибыл на занятие] в статус 2 [Занятие начато]
       update_rec_in_table('obj_site_lession_persons',array('status'=>2),'parent='.$lession_id.' and status=1',array('debug'=>0)) ;
	     $result['result']='success' ;
       }
	   else $result['error']='Занятие не может быть начато если на занятие не зарегистрировано ни одного сотрудника' ;
       return($result) ;
    }

    function cancel_lession($lession_id)
    {  $rec_lession=$this->get_lession_by_id($lession_id);
	   $data=array('status'=>6) ;
	   $data['time_to']=time() ;
	   update_rec_in_table('obj_site_lession',$data,'pkey='.$lession_id) ;

	   // получаем всех сотрудников, которые зарегистрированы на занятие
       $personal_ids=execSQL_line('select personal_id from obj_site_lession_persons where parent='.$lession_id.' and status=1') ;
       if (_sizeof($personal_ids))
       { // переводим слушателей в занятии в статус 6 [Занятие отменено]
	     update_rec_in_table('obj_site_lession_persons',array('status'=>6),'parent='.$lession_id.'',array('debug'=>0)) ;
	     $result['result']='success' ;
       }
	    $result['result']='success' ;
       return($result) ;
    }

    // окончание занятия
    // personal lession status 2=>3
    // personal event status =5

	//1=>'Зарегистрирован в занятии',
    //2=>'Учавствует в занятии',
    //3=>'Занятие прослушано',
    //4=>'Сотрудник расписался'
    function stop_lession($lession_id)
    {  update_rec_in_table('obj_site_lession',array('status'=>4,'time_to'=>time()),'pkey='.$lession_id,array('debug'=>0)) ;
       // участники переводятся в статус 4 только после подписи участия в лекции
       // просто после окончания занятия - статус 3
       update_rec_in_table('obj_site_lession_persons',array('status'=>3),'parent='.$lession_id) ;
    }

    // закрытие занятия после подписи ведомости
	// все, кто не расписался - удаляются из список занятия
    function close_lession($lession_id)
    {  update_rec_in_table('obj_site_lession',array('status'=>5),'pkey='.$lession_id,array('debug'=>0)) ;
       // статус участников занятия определяется их подписью в занятиии
	   // больше никаких варианттов изменить их статус нет
       ob_start() ;

       // если в мероприятии стоит настроена отсровчка блокировки МО при несдаче инструктажа - необходимо тем, кто не расписался,
       $rec_lession=EVENTS()->get_lession_by_id($lession_id) ;
       $rec_event=EVENTS()->get_event_by_id($rec_lession['event_id']) ;
       //damp_array($rec_event);
       // подвинуть срок блокировки
	   $recs_personals_lession=execSQL('select * from view_lession_personals where lession_id='.$lession_id.' and lession_status=3',2) ;
	   if (_sizeof($recs_personals_lession)) foreach($recs_personals_lession as $rec_personal_lession)
	   {  // нужно получить запись по участию в мероприятии, так как сообщение привязано к нему
          $rec_pass=EVENTS()->get_event_pass($rec_personal_lession['event_id'],$rec_personal_lession['personal_id']);
          print_2x_arr([$rec_pass]);
          // проверяем, если у сотрудника сообщение по этому мероприятию в активном статусе
          $recs_mess=PERSONAL()->get_active_mess_to_personal($rec_personal_lession['personal_id'],['view_blocked'=>1,'source_pkey'=>$rec_pass['pkey']]) ;
          print_2x_arr($recs_mess);
          // и если у сообщения есть время блокировки
          if (sizeof($recs_mess)) foreach($recs_mess as $rec_mess) if ($rec_mess['block_from'] or ($rec_mess['block_to'] and $rec_mess['block_to']>time()))
          { // проверяем что по этому сообщению еще не было сдвига сроков
            $check_event=execSQL_value('select pkey from obj_site_mo_log where obj_name="Автоматический перенос блокировки" and reffer1="'.$rec_mess['_reffer'].'" and personal_id='.$rec_personal_lession['personal_id'],2) ;
            if (!$check_event)
            {
                // добавляем заданное число дней к дате блокировки, независимо, наступила она или нет
                $cnt=$rec_event['_ext_info']['day_delay'] ;
                echo 'Добавляем сотруднику ID '.$rec_mess['personal_id'].' <strong>'.$cnt.'</strong> дней в сообщение ID '.$rec_mess['pkey'].'<br>' ;
                PERSONAL()->message_personal_add_day($rec_mess['pkey'],$rec_event['_ext_info']['day_delay'],['no_reg_log'=>1]) ;

                LOGS()->reg_log('Автоматический перенос блокировки',$rec_mess['obj_name'],array('personal_id'=>$rec_mess['personal_id'],
                                                                                                'reffers'=>array($rec_mess['_reffer'],
                                                                                                $rec_mess['_personal_reffer']
                                                                                                ))) ;
            }
          }
		 // если получал зачеты по другим занятиям - ставим статус прошел инструктаж частично [6]
		 //$new_status=($rec_personal['cnt_other'])? 6:3 ;
		 //update_rec_in_table('obj_site_events_pass',array('status'=>$new_status),'event_id='.$rec_personal['event_id'].' and personal_id='.$rec_personal['personal_id'],array('debug'=>2)) ;
	   }

       /*
       // необходимо вернуть статус человека, что он не присутствовал на этом занятии
	   $recs_personals=execSQL('select personal_id,parent as lession_id,event_id,
								(select count(pkey)
								 from obj_site_lession_persons t2
								 where t2.event_id=t1.event_id and t2.personal_id=t1.personal_id and t2.parent!=t1.parent and t2.status=4)  as cnt_other
								 from obj_site_lession_persons t1
								 where status<4 and parent='.$lession_id,2) ;
	   if (_sizeof($recs_personals)) foreach($recs_personals as $rec_personal)
	   { // если человек не получал зачеты по другим занятиям - ставим статус Уведомлен [3]
		 // если получал зачеты по другим занятиям - ставим статус прошел инструктаж частично [6]
		 $new_status=($rec_personal['cnt_other'])? 6:3 ;
		 update_rec_in_table('obj_site_events_pass',array('status'=>$new_status),'event_id='.$rec_personal['event_id'].' and personal_id='.$rec_personal['personal_id'],array('debug'=>2)) ;
	   }
       */
       $text=ob_get_clean() ;
       LOGS()->reg_log('close_lession',$lession_id,['save_to_file'=>$text]) ;
    }




    // роспись за занятие
    // personal lession status 3=>4
    // personal event status 5 => 6 или 7
	//  6=>'Инструктаж пройден частично',
	//  7=>'Инструктаж пройден'
    function lession_personal_sign($event_id,$lession_id,$personal_id,$sign_fname='',$options=array())
    {   ob_start() ;
    	$rec_personal=PERSONAL()->get_personal_by_id($personal_id,array('no_public_info'=>1)) ;
        // ставим в этом занятии статус 4 - расписался
        update_rec_in_table('obj_site_lession_persons',array('status'=>4,
		                                                     'sign_fname'=>$sign_fname,
		                                                     'lession_org_id'=>$rec_personal['_org_id'],
		                                                     'lession_otdel_id'=>$rec_personal['_otdel_id'],
		                                                     'lession_work_id'=>$rec_personal['working']
                                                            ),'parent='.$lession_id.' and personal_id='.$personal_id) ;

        $theme_space=array() ;
        if (!$options['no_check_sign_themes'])
        { // получаем список всех тем занятий, по которым у него статус 4
        $theme_status4=execSQL_line('select theme_id from obj_site_lession_themes t1 where event_id='.$event_id.' and parent in (select distinct(parent) from obj_site_lession_persons where event_id='.$event_id.' and personal_id='.$personal_id.' and status=4)',2)  ;
        // получаем список всех тем инструктажа
          $theme_all=execSQL_line('select pkey from obj_site_events_themes where parent='.$event_id,2)  ;
        $theme_space=array_diff($theme_all,$theme_status4) ;
          print_r($theme_space) ;
        }

	    $rec_event_pass=execSQL_van('select pkey,personal_id,status from obj_site_events_pass where event_id='.$event_id.' and personal_id='.$personal_id) ;
	    if ($rec_event_pass['pkey'])
	    {    //echo 'Непрослушанные темы: '.print_r($theme_space,true).'<br>' ;
        if ($options['no_check_sign_themes'] or !_sizeof($theme_space))
        { // статус участия в занятии - 7=>'Инструктаж пройден'
            $group_id=(MEMBER()->cur_group_id)?:0 ;
	          EVENTS()->set_event_personal_data($event_id,$personal_id,array('status'=>7,'group_id'=>$group_id),'Сотрудник прослушал все темы') ;
                                     // закрываем все сообщения о необходимости пройти инструктаж
                $this->event_pass_close_messages($rec_event_pass['_reffer'],array('comment'=>'Сотрудник прослушал все темы, закрываем все сообщения')) ;
                //$recs_mess_old=PERSONAL()->get_messages_by_reffer($rec_event_pass['_reffer']) ;
                //echo '$recs_mess_old='.print_r(array_keys($recs_mess_old),true).'<br>' ;
                //if (_sizeof($recs_mess_old)) foreach($recs_mess_old as $rec_mess_old) if ($rec_mess_old['pkey'] and $rec_mess_old['status']<4) PERSONAL()->message_personal_close($rec_mess_old['pkey'],array('comment'=>'Сотрудник расписался за занятие')) ;
                                   }
        else
        { // статус участия в занятии - 6=>'Инструктаж пройден частично',
		         EVENTS()->set_event_personal_data($event_id,$personal_id,array('status'=>6,'group_id'=>MEMBER()->cur_group_id),'Сотрудник прослушал частично темы') ;
	                                 // если предыдущий статус был не 6, закрываем сообщение о необходимости пройти инструктаж и отправляем новое сообщение о необходимости завершить прохождение
	                                 if ($rec_event_pass['status']!=6)
             { $this->event_pass_close_messages($rec_event_pass['_reffer'],array('comment'=>'Сотрудник прошел первое занятие, закрываем сообщения № 1')) ;
               //$recs_mess_old=PERSONAL()->get_messages_by_reffer($rec_event_pass['_reffer']) ;
               //echo '$recs_mess_old='.print_r(array_keys($recs_mess_old),true).'<br>' ;
               //if (_sizeof($recs_mess_old)) foreach($recs_mess_old as $rec_mess_old) if ($rec_mess_old['pkey'] and $rec_mess_old['status']<4) PERSONAL()->message_personal_close($rec_mess_old['pkey'],array('comment'=>'Сотрудник расписался за занятие')) ;
	                                 // отправляем сообщение о необходимости завершить прохождение инструктажа
	                                 $obj_event=EVENTS()->get_event_obj_by_id($event_id) ;
	                                 $rec_event=EVENTS()->get_event_by_id($event_id) ;

	                                 $mess_rec_new=$obj_event->prepare_message($rec_event,$rec_event_pass,$rec_event['_ext_info']['message2'])  ;
                $mess_reffer=PERSONAL()->message_personal_create($mess_rec_new,array('comment'=>'Сотрудник прошел первое занятие, отправляем сообщение № 2')) ;
				                       // фиксируем в записи по человеку в событии ID отправленого ему сообщения
				                       list($mess_id,$mess_tkey)=explode('.',$mess_reffer) ;
				                       EVENTS()->set_event_personal_data($rec_event['pkey'],$personal_id,array('mess_id'=>$mess_id),'Отправлено сообшение о необходимости завершения прохождения инструктажа') ;
	                                 }
	                                // else echo 'Повторная отправка сообщения о необходимости завершить прохожение инструктажа не требуется<br>' ;
                                   }
	    }
        //damp_array($theme_space,1,-1) ;
	    //$rec_event_pass=execSQL_van('select pkey,personal_id,status from obj_site_events_pass where event_id='.$event_id.' and personal_id='.$personal_id,2) ;
        $text=ob_get_clean() ;
	//    echo $text ;
        //LOGS()->reg_log('lession_personal_sign',$text) ;
	    ENGINE()->on_event('lession_personal_sign',array('event_id'=>$event_id,'lession_id'=>$lession_id,'personal_id'=>$personal_id)) ;
    }

    function event_pass_close_messages($pass_reffer,$options=array())
    {   if (!isset($options['comment'])) $options['comment']='' ;
        if (!isset($options['read_only'])) $options['read_only']=0 ;
        $arr_closed_mess_ids=array() ;
        $recs_mess_old=PERSONAL()->get_messages_by_reffer($pass_reffer) ;
        //echo '$recs_mess_old='.print_r(array_keys($recs_mess_old),true).'<br>' ;
        if (_sizeof($recs_mess_old)) foreach($recs_mess_old as $rec_mess_old) if ($rec_mess_old['pkey'] and $rec_mess_old['status']!=4)
        { if (!$options['read_only']) PERSONAL()->message_personal_close($rec_mess_old['pkey'],array('comment'=>$options['comment'])) ;
          $arr_closed_mess_ids[]=$rec_mess_old['pkey'] ;
        }
        return($arr_closed_mess_ids) ;

    }


    function event_theme_create($event_id,$data)
    {  $data['clss']=225 ;
       $data['parent']=$event_id ;
       $data['account_id']=MEMBER()->id ;
       $id=adding_rec_to_table('obj_site_events_themes',$data,array('debug'=>2)) ;
       return($id) ;

    }

    function event_theme_save($theme_id,$data)
    {
        update_rec_in_table('obj_site_events_themes',$data,'pkey='.$theme_id,array('debug'=>2)) ;
    }

    function get_themes_of_events($event_id,$theme_ids=0)
    {  $usl[]='clss=225' ;
       $usl[]='parent='.$event_id ;
       if ($theme_ids) $usl[]='pkey in ('.implode(',',$theme_ids).')' ;
       $recs=execSQL('select * from obj_site_events_themes where '.implode(' and ',$usl).' order by indx') ;
       return($recs) ;
    }

    function get_themes_of_lession($lession_id)
    {  $usl[]='clss=228' ;
       $usl[]='parent='.$lession_id ;
       $recs=execSQL('select * from obj_site_lession_themes where '.implode(' and ',$usl).' order by indx') ;
       return($recs) ;
    }

    function event_theme_delete($event_id,$arr_theme_ids)
    {
       execSQL_update('delete from obj_site_events_themes where pkey in ('.implode(',',$arr_theme_ids).') and clss=225') ;
    }

    function get_event_personal_rec($event_id,$personal_id)
    {
       $rec_event_to_personal=execSQL_van('select * from view_event_personals where event_id='.$event_id.' and personal_id='.$personal_id) ;
       return($rec_event_to_personal) ;
    }

    function get_event_pass($event_id,$personal_id)
    {
       $rec_event_to_personal=execSQL_van('select * from obj_site_events_pass where event_id='.$event_id.' and personal_id='.$personal_id) ;
       return($rec_event_to_personal) ;
    }

    function get_event_personal_rec_by_pass_id($event_pass_id)
    {
       $rec_event_to_personal=execSQL_van('select * from view_event_personals where event_person_id='.$event_pass_id) ;
       return($rec_event_to_personal) ;
    }

    function get_event_pass_by_pass_id($event_pass_id)
    {
       $rec_event_to_personal=execSQL_van('select * from obj_site_events_pass where pkey='.$event_pass_id) ;
       return($rec_event_to_personal) ;
    }

    function get_event_pass_by_id($event_pass_id)
    {
       $rec_event_to_personal=execSQL_van('select * from obj_site_events_pass where pkey='.$event_pass_id) ;
       return($rec_event_to_personal) ;
    }

    function get_event_pass_doc_by_id($event_pass_id)
    {
       $rec_event_to_personal=execSQL_van('select * from view_event_personals_docs where event_pass_id='.$event_pass_id) ;
       return($rec_event_to_personal) ;
    }

    function get_active_events_to_personal($personal_id,$options=array())
    {  $recs=execSQL('select * from obj_site_events_pass where personal_id='.$personal_id.' and alert_text!=""',$options) ;
       return($recs) ;
    }

    // временно оставляем $cur_group_id для обеспечения совместимости с первой версией
    // функция считает число сотрудников по статусам в таблице obj_site_events_pass
    // для мероприятий с dyn event pass, котрудники которые подлежат мероприятию, подсчитаны не будут
    function get_event_personals_status($event_id,$options=array())
    {   $rec_event=$this->get_event_by_id($event_id) ;
        $_usl=array() ;
        $_usl[]='pass.enabled=1' ; // только по действующим участникам мероприятия
        $_usl[]='pass.status>0' ; // только по действующим сотрудникам
	    if ($options['usl']) $_usl[]=$options['usl'] ; // дополнительное условие для отбора по статусу
        if ($options['only_fired']) $_usl[]='fl.fired_data>0' ;
        if ($options['only_active']) $_usl[]='(fl.fired_data=0 or fl.fired_data is null)' ;
        if ($options['pass_status_usl']) $_usl[]='pass.status'.$options['status_usl'] ;

        $_usl[]='pass.event_id='.$rec_event['pkey'] ; // только по действующим сотрудникам
        $_usl[]='so.enabled=1 and so.fired_data_pause=0' ;
        $_usl[]='not tvp.pkey is null' ; // только по действующим сотрудникам
        $_usl[]='not fl.pkey is null' ; // только по действующим сотрудникам
        $_usl[]='not so.pkey is null' ; // только по действующим сотрудникам

        $personal_viewer=($options['no_use_account_usl_select'])? 'view_personals_active':MEMBER()->personal_viewer_name ;
        //$usl_in=(_sizeof($_usl_in))? ' and '.implode("\n and \n",$_usl_in):'' ;

        $group_by=($options['group_by'])? $options['group_by']:'pass.status' ;
        $order_by=$group_by ;


        $usl=implode(' and ',$_usl) ;
        // !!! left join obj_site_personals fl - нужно, так как в условиях будет nd (fl.fired_data=0 or fl.fired_data is null)
        // count(distinct(pass.pkey)) - если использовать, будут мешать дубликаты в pass
        $arr=execSQL_row('select pass.status,count(distinct(fl.pkey)) 
                          from obj_site_events_pass pass
                          left join '.$personal_viewer.' tvp on tvp.pkey=pass.personal_id 
                          left join obj_site_personals fl on fl.pkey=pass.personal_id
                          left join obj_site_workers so on so.personal_id=pass.personal_id 
                          where '.$usl.' 
                          group by '.$group_by.' 
                          order by '.$order_by) ;

        if ($rec_event['dyn_pass'])
        {   // надо получить число сотрудиков через вьювер мероприятия. во вьювере только поля pkey
            $cnt_all=execSQL_value('select count(pkey) from '.$rec_event['viewer_name']) ;
            if (_sizeof($arr)) foreach($arr as $status=>$cnt) if ($status>1) $cnt_all-=$cnt ;
            $arr[1]=$cnt_all ;
        }
        //$arr['all']=array_sum($arr) ;
        return($arr) ;
    }

    // временно оставляем $cur_group_id для обеспечения совместимости с первой версией
    // функция считает число сотрудников по статусам в таблице obj_site_events_pass
    // для мероприятий с dyn event pass, котрудники которые подлежат мероприятию, подсчитаны не будут
    function get_event_org_personals_status($event_id,$options=array())
    {   $rec_event=$this->get_event_by_id($event_id) ;
        $_usl=array() ;
        $_usl[]='pass.enabled=1' ; // только по действующим участникам мероприятия
        $_usl[]='pass.status>0' ; // только по действующим сотрудникам
	    if ($options['usl']) $_usl[]=$options['usl'] ; // дополнительное условие для отбора по статусу
        if ($options['only_fired']) $_usl[]='fl.fired_data>0' ;
        if ($options['only_active']) $_usl[]='(fl.fired_data=0 or fl.fired_data is null)' ;
        if ($options['pass_status_usl']) $_usl[]='pass.status'.$options['status_usl'] ;

        $_usl[]='pass.event_id='.$rec_event['pkey'] ; // только по действующим сотрудникам
        $_usl[]='so.enabled=1 and so.fired_data_pause=0' ;
        $_usl[]='not tvp.pkey is null' ; // только по действующим сотрудникам
        $_usl[]='not fl.pkey is null' ; // только по действующим сотрудникам

        $personal_viewer=($options['no_use_account_usl_select'])? 'view_personals_active':MEMBER()->personal_viewer_name ;
        //$usl_in=(_sizeof($_usl_in))? ' and '.implode("\n and \n",$_usl_in):'' ;

        $group_by=($options['group_by'])? $options['group_by']:'pass.status' ;
        $order_by=$group_by ;


        $usl=implode(' and ',$_usl) ;
        // !!! left join obj_site_personals fl - нужно, так как в условиях будет nd (fl.fired_data=0 or fl.fired_data is null)
        $arr=execSQL('select so.parent2,pass.status,org.obj_name as org_name,count(distinct(pass.pkey)) as cnt 
                          from obj_site_events_pass pass
                          left join '.$personal_viewer.' tvp on tvp.pkey=pass.personal_id 
                          left join obj_site_personals fl on fl.pkey=pass.personal_id
                          left join obj_site_workers so on so.personal_id=pass.personal_id 
                          left join obj_site_personals org on org.pkey=so.parent2 
                          where '.$usl.' 
                          group by so.parent2,pass.status 
                          order by org.obj_name',0,1) ;

        /*if ($rec_event['dyn_pass'])
        {   // надо получить число сотрудиков через вьювер мероприятия. во вьювере только поля pkey
            $cnt_all=execSQL_value('select count(pkey) from '.$rec_event['viewer_name']) ;
            if (_sizeof($arr)) foreach($arr as $status=>$cnt) if ($status>1) $cnt_all-=$cnt ;
            $arr[1]=$cnt_all ;
        }*/
        //$arr['all']=array_sum($arr) ;
        $res=[] ;
        if (_sizeof($arr)) foreach($arr as $rec) $res[$rec['org_name']][$rec['status']]=$rec['cnt'] ;

        return($res) ;
    }

	// проверяем темы занятия $lession_id - если занятие, соедржит хотя бы одну тему, по которой у сотрудника нет зачета - вернуть число тем без зачета
	// если все темы занятия уже зачтены - вернуть 0
    function check_personal_lession_themes($event_id,$lession_id,$personal_id,$options=array())
    {   $lesssin_theme_ids=execSQL_row('select theme_id,1 from obj_site_lession_themes where parent='.$lession_id) ;
        //print_r($lesssin_theme_ids) ;
        // получем список тем, по которым у сотрудника зачет
        $personal_lession_ids=execSQL('select t1.parent as lession_id,t1.status,t2.theme_id 
                                    from obj_site_lession_persons t1
                                    left join obj_site_lession_themes t2 on t2.parent=t1.parent  
                                    where t1.event_id='.$event_id.' and t1.personal_id='.$personal_id.' and t1.status=4',0,1) ;
        //print_r($personal_lession_ids) ;
	    //if ($options['debug']) print_2x_arr($personal_lession_ids) ;
        // проходим по списку зачтенных тем и убираем эти темы из списка тем текущего занятия
        if (_sizeof($personal_lession_ids)) foreach($personal_lession_ids as $rec_theme_4) if (isset($lesssin_theme_ids[$rec_theme_4['theme_id']])) unset($lesssin_theme_ids[$rec_theme_4['theme_id']]) ;
        //print_r($lesssin_theme_ids) ;

        return(_sizeof($lesssin_theme_ids)) ;

    }


      // обрабочик события подписи документа
      // если документ - направление в здавпункт - отправить пользователю сообщение о необходимоти сдачи документа в ПДД

       function on_event_save_doc_signature($options=array())
       { //damp_array($options,1,-1) ;
         $rec_doc=(_sizeof($options['rec_doc']))? $options['rec_doc']:array() ;
         $personal_id=($rec_doc['personal_id'])? $rec_doc['personal_id']:0 ;
         if ($rec_doc['pkey'] and $personal_id)// and $options['rec_doc']['report_code']=='napravlenie')
         {  ob_start() ;
            // ищем мероприятие по выдаче документов того типа, который был подписан
            $recs_event_docs=execSQL('select * from '.$this->table_events.' where clss=222 and doc_code="'.$options['rec_doc']['report_code'].'" and enabled=1 and status=1') ;
            if (_sizeof($recs_event_docs)) foreach($recs_event_docs as $rec)
            { $obj_event=$this->get_event_obj_by_ext($rec['ext']) ;
              // ищем для данного сотрудника открытое участие в мероприятиии
              // class_v.esmo/ext/events_docs/i_event_docs.php::get_last_event_pass_to_personal
              $last_open_event_rec=$obj_event->get_last_event_pass_to_personal($rec['pkey'],$personal_id) ;
              if (!$last_open_event_rec['pkey'])
              {   echo 'Регистрируем выдачу документа в мероприятии "'.$rec['obj_name'].'"<br>' ;
                  $event_pass_reffer=$obj_event->add_personal_to_event($rec['pkey'],$personal_id,$rec_doc['pkey']) ;
                  list($pkey,$tkey)=explode('.',$event_pass_reffer) ;
                  DOCS()->update_doc($rec_doc['pkey'],array('source_obj'=>$rec['ext'],'source_pkey'=>$pkey,'source_tkey'=>$tkey,'event_pass_type'=>1)) ;
              }
              else
              { echo 'Данный документ уже зарегистрирован в мероприятии "'.$rec['obj_name'].'"<br>' ;
                DOCS()->update_doc($rec_doc['pkey'],array('source_obj'=>$rec['ext'],
                                                          'source_pkey'=>$last_open_event_rec['pkey'],
                                                          'source_tkey'=>$last_open_event_rec['tkey'],
                                                          'event_pass_type'=>5
                )
                ) ;
                // для обновления всех нужной информации добавляем сотрудника в мероприятие - необходимая информация будет обновлена
                $obj_event->add_personal_to_event($rec['pkey'],$personal_id,$rec_doc['pkey']) ;
              }
            }
            $text=ob_get_clean() ;
            LOGS()->reg_log('on_event_save_doc_signature',$text,array('personal_id'=>$options['rec_doc']['personal_id'],'mo_id'=>$options['rec_doc']['mo_id'],
                    'reffers'=>array($options['rec_doc']['_reffer'])
                    )) ;
         }

         // закрываем занятие при подписи документа
	   // ищем мероприятие, с которым связан документ и вызываем его метод on_event_save_doc_signature
       // на текущий момент метод on_event_save_doc_signature есть только в i_event_meeting (собрание)
       // остальные мероприятия работают по старинке
	   $obj_event=$this->get_event_obj_by_ext($rec_doc['source_obj']) ;
         //var_dump($obj_event) ;
	   if ($obj_event!=null and is_object($obj_event) and method_exists($obj_event,'on_event_save_doc_signature')) $obj_event->on_event_save_doc_signature($options) ;
	   else
	   {     // старый вариант закрытия занятия
	     ob_start() ;
         $lession_id=($rec_doc['lession_id'])? $rec_doc['lession_id']:0 ;
         if ($rec_doc['pkey'] and $lession_id)
         {  $rec_lession=EVENTS()->get_lession_by_id($lession_id) ;
            if ($rec_lession['pkey'] and $rec_lession['status']==4) $this->close_lession($lession_id)  ;
         }
         $text=ob_get_clean() ;
         LOGS()->reg_log('on_event_save_doc_signature2',$text) ;
       }
       }


	function CRON_events_update_personals_status()
   { ob_start()  ;
     $_usl=array() ;
	 $_usl[]='clss=222' ;
	 $_usl[]='enabled=1' ;
	 $_usl[]='status!=5' ; // не в архиве
	 $_usl[]='ext!="events_docs/i_event_docs"' ; // не мероприятие по приему документов
	 // сроки мероприятия
	 $_usl2=array() ;
	 $_usl2[]='(date_from>0 and date_to>0 and date_from <'.time().' and date_to >'.time().')' ; // задан срон начала и окончания мероприятия и текущее время внутри диапазона
	 $_usl2[]='((date_from=0 or date_from is null) and date_to>0 and date_to >'.time().')' ; // не задан срок начала, срок окончания еще не наступн
	 $_usl2[]='((date_to=0 or date_to is null) and date_from>0 and date_from <'.time().')' ; // не задан срок окончания, срок начала уже наступил
	 $_usl2[]='((date_to=0 or date_to is null) and (date_from=0 or date_from is null))' ; // не задан срок окончания, ни срок начала
	 $_usl[]='('.implode(' or ',$_usl2).')' ;
	 $usl=implode(' and ',$_usl) ;
     $recs_events=execSQL('select * from obj_site_events_schedule  where '.$usl.' order by pkey desc') ;
     //echo 'Будет проверено '._sizeof($recs_events).' мероприятий<br>' ;
     FILE_LOG()->append('Будет проверено '._sizeof($recs_events).' мероприятий',1) ;
     //$GLOBALS['debug_db']=1 ;
     $i=0 ;
     if (_sizeof($recs_events)) foreach($recs_events as $rec_event)
     { $this->prepare_public_info_to_event($rec_event) ;
       $obj_event=EVENTS()->get_event_obj_by_ext($rec_event['ext']) ;
       //$filter_info=PERSONALS_FILTER()->get_personals_filter_info_to_item($rec_event['_reffer']);
       FILE_LOG()->append($rec_event['obj_name'].' ['.$obj_event->name.'], ID '.$rec_event['pkey']) ;
       echo '<h3 style="background-color:green;color:white;">'.$rec_event['obj_name'].' ['.$obj_event->name.']</h3>' ;
       FILE_LOG()->append('Код типа мероприятия '.$rec_event['ext'].'') ;
       echo 'Код типа мероприятия: <strong>'.$rec_event['ext'].'</strong><br>' ;
       echo 'Срок действия мероприятия: <strong>'.(($rec_event['date_from'])? date('d.m.Y',$rec_event['date_from']):' - ').'...'.(($rec_event['date_to'])? date('d.m.Y',$rec_event['date_to']):' - ').'</strong><br>' ;
       if (isset($rec_event['_ext_info']['select_personals']) and $rec_event['_ext_info']['select_personals']==2) echo '<div class=green>Список сотрудников мероприятия загружен из XLS, обновление списка участников не требуется</div>' ;
       else
       {    //echo 'Отбор сотрудников:<br>' ; damp_array($filter_info,1,-1);
           //damp_array($rec_event['_ext_info']) ;
           if (is_object($obj_event))
           { // обновляет список учасников мероприятия (obj_site_events_pass) на основе данных вьювера мероприятия
             $result=$this->update_event_personals($rec_event['pkey']) ;
             // проверяем пе
             $result=$obj_event->update_personal_status_1($rec_event['pkey']) ;
           }
       }

       echo 'Уже добавлено в мероприятие: <strong>'.$result['exist'].'</strong><br>'  ;
       echo 'Добавлено новых сотрудников: <strong>'.$result['add'].'</strong><br>'  ;
       echo 'Удалено из мероприятия: <strong>'.$result['remove'].'</strong><br>'  ;

       FILE_LOG()->append('Уже добавлено в мероприятие '.$result['exist'].'') ;
       FILE_LOG()->append('Добавлено новых сотрудников '.$result['add'].'') ;
       FILE_LOG()->append('Удалено из мероприятия '.$result['remove'].'') ;

       $i++ ;// if ($i==5) break ;
     }
     $text=ob_get_clean() ;
     LOGS()->reg_log('CRON_events_update_personals_status',$text) ;
     echo $text ;
       }

	// обработчик события подписи при инструктаже
   function on_event_lession_personal_sign($options=array())
   {  $personal_id=$options['personal_id'] ;
      if ($personal_id) PERSONAL()->personal_fired_pause_cancel($personal_id) ;
   }

   function check_dublikate_message()
   {
	   // получаем ID инструктажей
	   ob_start() ;   $recs=array() ;
       $events_ids=execSQL_line('select pkey from obj_site_events_schedule where ext like "esmo_magnit_instruction/i_event_instruction%"') ;
       if (_sizeof($events_ids)) $recs=execSQL('select personal_id,event_id,count(pkey) as cnt from obj_site_events_pass where event_id in ('.implode(',',$events_ids).') group by personal_id,event_id having cnt>1') ;
       if (_sizeof($recs))
       {  echo '<h2>Обнаружено дублирование сообщений сотрудникам в инструктажах</h2><br>' ;
       	  print_2x_arr($recs) ;
       	  $this->delete_dublicate_message() ;
       }
	   $text=ob_get_clean() ;
	   if (_sizeof($recs))
	   {   $mail_options = array('no_asyns_send_mail' => 1,'debug' => 1,'reg_events' => 1);
		   $mail_options['cc']['dikalov_va@magnit.ru']='dikalov_va@magnit.ru' ;
		   MAILS()->send_mail('olifirov_ar@magnit.ru','Автоматическое уведомление ЭСМО',$text,$mail_options);
	   }


   }

function delete_dublicate_message()
	 {
	     // получаем ID инструктажей
		 $recs=array() ;
	     $events_ids=execSQL_line('select pkey from obj_site_events_schedule where pkey=97 and  enabled=1 and ext like "esmo_magnit_instruction/i_event_%"') ;
	     echo 'Будет проверено '._sizeof($events_ids).' мероприятий<br>' ;
	     //if (_sizeof($events_ids)) $recs=execSQL('select event_id,personal_id,count(pkey) as cnt from obj_site_events_pass where event_id in ('.implode(',',$events_ids).') group by event_id,personal_id having cnt>1') ;
	     if (_sizeof($events_ids)) $recs=execSQL('select t2.event_id,t1.personal_id,t1.obj_name,count(t1.pkey) as cnt 
                                                 from obj_site_personal_mess t1
                                                 left join obj_site_events_pass t2 on t2.pkey=t1.source_pkey 
                                                 where t2.event_id in ('.implode(',',$events_ids).') 
                                                 group by t2.event_id,t1.personal_id,t1.obj_name 
                                                 having cnt>1
						 order by t1.c_data desc
						limit 100
',1,1) ;

	     if (_sizeof($recs))
	     { ob_start() ;
	       //print_2x_arr($recs) ;
	       foreach($recs as $rec)
		     { $rec_personal=PERSONAL()->get_personal_by_id($rec['personal_id']) ;
		       ?><strong><? echo $rec_personal['obj_name'].'</strong> ['.$rec['personal_id'].'] - '.$rec['cnt'].' messages in event '.$rec['event_id'].'<br>' ;
		       $recs_events_pass=execSQL('select * from obj_site_events_pass where event_id='.$rec['event_id'].' and personal_id='.$rec['personal_id']) ;
		       if (_sizeof($recs_events_pass))
		           {   echo 'Ищем все отправленные сообщения по мероприятию ID '.$rec['event_id'].'<br>' ;

		       //$arr_pass_ids=execSQL_line('select pkey from obj_site_events_pass where event_id='.$rec['event_id'].' and personal_id='.$rec['personal_id']) ;
                       //$recs_pass_mess=execSQL('select * from obj_site_personal_mess where personal_id='.$rec['personal_id'].' and source_pkey in ('.implode(',',$arr_pass_ids).') order by c_data') ;

			$arr_pass_recs=execSQL('select pkey,c_data,r_data,status from obj_site_events_pass where event_id='.$rec['event_id'].' and personal_id='.$rec['personal_id']) ;
                       $recs_pass_mess=execSQL('select * from obj_site_personal_mess where personal_id='.$rec['personal_id'].' and source_pkey in ('.implode(',',array_keys($arr_pass_recs)).') order by c_data') ;


			$last_mess_c_data=0 ;  $last_mess_id=0 ; $arr_mess=array() ;$arr_mess2=array() ;
                       if (_sizeof($recs_pass_mess)) foreach($recs_pass_mess as $rec_mess)
                       { $int=$rec_mess['c_data']-$last_mess_c_data ;
                         if (!$last_mess_id) $last_mess_id=$rec_mess['pkey'] ;
                         if ($int>60)
                         { $last_mess_c_data=$rec_mess['c_data'] ;
                           $last_mess_id=$rec_mess['pkey'] ;
                         }
                         $arr_mess[$last_mess_id][$rec_mess['status']][$rec_mess['pkey']]=date('d.m.Y H:i:s',$rec_mess['c_data']) ;
                       }

		       print_2x_arr($arr_pass_recs) ;
                       damp_array($arr_mess,1,-1) ;


                       $main_mess_id2=0 ;
		               // ищем сообщение в статусе 4 его надо оставить, если нет таких - оставим первое
		               if (_sizeof($arr_mess)) foreach($arr_mess as $arr_dubl_mess_by_status)
                       {  //if (isset($arr_dubl_mess_by_status))
                          // требуется оставить только одно сообщение из всех дубликатов со наибольшим статусом
                          $main_mess_id=0 ; $main_mess_status=0 ;
                          if (_sizeof($arr_dubl_mess_by_status)) foreach($arr_dubl_mess_by_status as $status=>$arr_dubl_mess) foreach($arr_dubl_mess as $mess_id=>$mess_data)
                          {
                              if ($status>$main_mess_status)
                              { $main_mess_id=$mess_id ;
                                $main_mess_status=$status ;
		                   }
		                       }
                          echo '$main_mess_id='.$main_mess_id.', status='.$main_mess_status.'<br>' ;
                          if (_sizeof($arr_dubl_mess_by_status)) foreach($arr_dubl_mess_by_status as $status=>$arr_dubl_mess) foreach($arr_dubl_mess as $mess_id=>$mess_data) if ($main_mess_id!=$mess_id)
                          {
                              //execSQL_update('delete from obj_site_personal_mess where pkey='.$mess_id) ;
                              echo 'delete message id='.$mess_id.'<br>' ;
		                       }
		                   }
		           }
		     }
		   $text=ob_get_clean() ;
		   echo $text  ;
		   LOGS()->reg_log('Работа утилиты','Инструктажи - убрать дубликаты сообщений',array('save_to_file'=>$text)) ;
	     }
	     else echo 'Дублирующихся сообщений не найдено<br>' ;
	     return(_sizeof($recs)) ;
	 }

	function delete_dublicate_message_old()
	 {
	     // получаем ID инструктажей
		 $recs=array() ;
	     $events_ids=execSQL_line('select pkey from obj_site_events_schedule where ext like "esmo_magnit_instruction/i_event_%" and enabled=1') ;
	     echo 'Будет проверено '._sizeof($events_ids).' мероприятий<br>' ;
	     //if (_sizeof($events_ids)) $recs=execSQL('select event_id,personal_id,count(pkey) as cnt from obj_site_events_pass where event_id in ('.implode(',',$events_ids).') group by event_id,personal_id having cnt>1') ;
         $now=getdate() ;
         $from=mktime($now['hours'],$now['minutes'],0,$now['mon'],$now['mday']-7,$now['year']);

	     if (_sizeof($events_ids)) $recs=execSQL('select t2.event_id,t1.personal_id,t3.obj_name as personal_name,t1.obj_name,count(t1.pkey) as cnt 
                                                 from obj_site_personal_mess t1
                                                 left join obj_site_events_pass t2 on t2.pkey=t1.source_pkey 
                                                 left join obj_site_personals t3 on t3.pkey=t1.personal_id
                                                 where t2.event_id in ('.implode(',',$events_ids).') and t1.c_data>='.$from.' 
                                                 group by t2.event_id,t1.personal_id,t1.obj_name 
                                                 having cnt>1',1,1) ;

         // получаем все статусы и сообщения сотрудников
         $arr_event_ids=[] ; $arr_personal_ids=[] ;
         if (_sizeof($recs)) foreach ($recs as $rec)
         { $arr_personal_ids[]=$rec['personal_id'];
           $arr_event_ids[]=$rec['personal_id'];
         }
         //$recs_events_pass=execSQL('select * from ')

	     if (_sizeof($recs))
	     { ob_start() ;
	       print_2x_arr($recs) ;
	       foreach($recs as $rec)
		     { ?><hr><strong><? echo $rec['personal_name'].'</strong> ['.$rec['personal_id'].'] - '.$rec['cnt'].' messages in event '.$rec['event_id'].'<br>' ;
		       $recs_events_pass=execSQL('select pkey,c_data,r_data,status from obj_site_events_pass where event_id='.$rec['event_id'].' and personal_id='.$rec['personal_id'].' order by pkey') ;
		       if (_sizeof($recs_events_pass)>1)
               {
                   // есть дубликаты участия в мероприятии, надо сначала удалить их
                   $arr_pass_status=[] ;
                   $i=0 ;
                   $pass_main=0 ;
                   foreach ($recs_events_pass as $rec_pass)
                   {
                        $arr_pass_status[$rec_pass['status']]++ ;
                        if (!$i) $pass_main=$rec_pass['pkey'] ;
                        $i++ ;

                   }
                  //damp_array($arr_pass_status);

                   if (sizeof($arr_pass_status)==1)
                   {
                       echo 'У сотрудника все статусы одинаковы, можно соединять pass<br>' ;
                       foreach ($recs_events_pass as $rec_pass) if ($rec_pass['pkey']!=$pass_main)
                       {   echo 'Сообщения - source_pkey:'.$rec_pass['pkey'].' => '.$pass_main.'<br>' ;
                           execSQL_update('update obj_site_personal_mess set source_pkey='.$pass_main.' where personal_id='.$rec['personal_id'].' and source_pkey='.$rec_pass['pkey']) ;
                           echo 'pass - delete:'.$rec_pass['pkey'].'<br>' ;
                           execSQL_update('delete from obj_site_events_pass where pkey='.$rec_pass['pkey'].' and personal_id='.$rec['personal_id']) ;
                       }
                   }
                   else echo '<div class="red">Разные статусы дубликатов участия в мероприятии</div>' ;

               }
		       elseif (_sizeof($recs_events_pass))
		           {   echo 'Ищем все отправленные сообщения по мероприятию ID '.$rec['event_id'].'<br>' ;
		               $recs_pass_mess=execSQL('select * from obj_site_personal_mess where personal_id='.$rec['personal_id'].' and source_pkey in ('.implode(',',array_keys($recs_events_pass)).') order by c_data') ;
                       $last_mess_c_data=0 ;  $last_mess_id=0 ; $arr_mess=array() ;$arr_mess2=array() ;
                       if (_sizeof($recs_pass_mess)) foreach($recs_pass_mess as $rec_mess)
                       { $int=$rec_mess['c_data']-$last_mess_c_data ;
                         if (!$last_mess_id) $last_mess_id=$rec_mess['pkey'] ;
                         if ($int>60)
                         { $last_mess_c_data=$rec_mess['c_data'] ;
                           $last_mess_id=$rec_mess['pkey'] ;
                         }
                         $arr_mess[$last_mess_id][$rec_mess['status']][$rec_mess['pkey']]=date('d.m.Y H:i:s',$rec_mess['c_data']) ;
                       }

                       damp_array($recs_events_pass,1,-1) ;
                       damp_array($arr_mess,1,-1) ;


                       $main_mess_id2=0 ;
		               // ищем сообщение в статусе 4 его надо оставить, если нет таких - оставим первое
		               if (_sizeof($arr_mess)) foreach($arr_mess as $arr_dubl_mess_by_status)
                       {  //if (isset($arr_dubl_mess_by_status))
                          // требуется оставить только одно сообщение из всех дубликатов со наибольшим статусом
                          $main_mess_id=0 ; $main_mess_status=0 ;
                          if (_sizeof($arr_dubl_mess_by_status)) foreach($arr_dubl_mess_by_status as $status=>$arr_dubl_mess) foreach($arr_dubl_mess as $mess_id=>$mess_data)
                          {
                              if ($status>$main_mess_status)
                              { $main_mess_id=$mess_id ;
                                $main_mess_status=$status ;
		                      }
		                  }
                          echo '$main_mess_id='.$main_mess_id.', status='.$main_mess_status.'<br>' ;

                          if (_sizeof($arr_dubl_mess_by_status)) foreach($arr_dubl_mess_by_status as $status=>$arr_dubl_mess) foreach($arr_dubl_mess as $mess_id=>$mess_data) if ($main_mess_id!=$mess_id)
                          {
                              //execSQL_update('delete from obj_site_personal_mess where pkey='.$mess_id) ;
                              echo '<div class="red">delete message id='.$mess_id.'</div>' ;
                          }
                       }
		           }
		     }
		   $text=ob_get_clean() ;
		   echo $text  ;
		   LOGS()->reg_log('Работа утилиты','Инструктажи - убрать дубликаты сообщений',array('save_to_file'=>$text)) ;
	     }
	     else echo 'Дублирующихся сообщений не найдено<br>' ;
	     return(_sizeof($recs)) ;
	 }

	    // утилита для поиска дубликатов мероприятий по выдаче направлений по АГ
   function check_dublicate_event_napravlenie()
   {
	   $recs_events=execSQL('select * from obj_site_events_schedule where ext="events_docs/i_event_docs" and doc_code="napravlenie" order by pkey',0,1) ;
       $main_event=$recs_events[0]  ;   $event_id=$main_event['pkey'] ;
       if (_sizeof($recs_events)>1)
       {   echo 'Найдены дубликаты мероприятия по выдаче направлений по АГ<br>' ;
           echo '<strong>Проверяем корректность выданных документов</strong><br>' ;
           $recs_docs=execSQL('select t1.*,t2.event_id as event_id2
                               from obj_site_docs t1
                               left join obj_site_events_pass t2 on t2.pkey=t1. source_pkey 
                               where t1. source_obj="events_docs/i_event_docs" and  t2.event_id!='.$event_id) ;
           if (_sizeof($recs_docs)) foreach($recs_docs as $rec_doc)
           { execSQL_update('update obj_site_events_pass set event_id='.$event_id.' where pkey='.$rec_doc['source_pkey'],array('debug'=>0)) ;
             echo 'Перепривязка участия в мероприятии: '.$rec_doc['event_id2'].' => '.$event_id.'<br>' ;
           }
           echo '<strong>Проверяем корректность отправленных сообщений</strong><br>' ;
           $recs_mess=execSQL('select t1.*,t2.event_id as event_id2 
                           from obj_site_personal_mess t1
                           left join obj_site_events_pass t2 on t2.pkey=t1. source_pkey 
                           where t1. source_obj="events_docs/i_event_docs" and  t2.event_id!='.$event_id) ;
           if (_sizeof($recs_mess)) foreach($recs_mess as $rec_mess)
           { execSQL_update('update obj_site_events_pass set event_id='.$event_id.' where pkey='.$rec_mess['source_pkey'],array('debug'=>0)) ;
             echo 'Перепривязка участия в мероприятии: '.$rec_mess['event_id2'].' => '.$event_id.'<br>' ;
           }

           if (_sizeof($recs_events)) foreach($recs_events as $i=>$rec_event) if ($i)
           {  execSQL_update('delete from obj_site_events_schedule where pkey='.$rec_event['pkey'],array('debug'=>0)) ;
              echo 'Удалено мероприятие ID='.$rec_event['pkey'].'<br>' ;
           }
       }
   }

   // проверяем участие сотрудника в мероприятиях, работающих не по сообщениям (установлен флаг dyn_pass в записи по мероприятию)
   // - контроль знаний
   // - доведение контента
   // - опросы


   // сначала получаем список мероприятий, условия которых подходят под текущее место (время, тип терминала)
   // найдя подходящие мероприятия, по каждому мероприятию получаем контент мероприятия, который занимает свободное место в сесиии МО
   // важно, чтобы места распределялись именно тут, так как можно выстроить ранжирование мероприятий по важности (например опросы важнее контроля знаний)


   function on_event_server_check_access_success(&$session_info,&$result)
   { $data_in=['session_info'=>$session_info,'result'=>$result] ;
     $uid=ENGINE()->save_temp_setting($data_in) ;
     ob_start() ;
     ?><strong>Выполяем обработку события "check_access_success" модулем EVENT()</strong><br><?
     echo 'Входящие параметры сохранены во временный файл '.$uid.'<br>' ;
     $event_union=[] ;
     // получаем список мероприятий c динамическим списком сотрудников
	 // сортировка мероприятий - по рейтингу и дате создания. Чем раньше создано, тем главнее
	 $recs_events=execSQL('select * from obj_site_events_schedule where enabled=1  and status<5 and dyn_pass=1 and date_from<='.time().' and date_to>='.time().' order by pkey desc') ;
	 echo 'Найдено <strong>'._sizeof($recs_events).'</strong> активных мероприятия<br>' ;
	 $recs_events_by_ext=[] ;
	 // будем рассмотривать мероприятия разного типа отдельно. Сначала контроль знаний, потом - опросы, потом - медиаконтент
	 if (_sizeof($recs_events)) foreach($recs_events as $rec_event)
     {   EVENTS()->prepare_public_info_to_event($rec_event) ;
         $recs_events_by_ext[$rec_event['ext']][$rec_event['pkey']]=$rec_event ;
     }

	 $rec_personal=execSQL_van('select * from obj_site_personals where pkey='.$session_info['personal_id']) ;

	 // 1. удаляем из списка все мероприятия, куда не входит данный сотрудник.
	 // В случае специального КЗ (когда условие отбора задается в темах/разделах КЗ) необходимо найти тему, которую сотрудник еще не проходил, если задано его участие в нескольких темах
	 // Если все темы пройдены поставить флаг
	 // Если ни по одной из тем сотрудник не попадает в КЗ - помечаем мероприятие

	 // ранжируем мероприятия по важности, проверяя сначаа контроль знаний, затем опросы, потом доведение контента
	 // добавляем в объединенный список только те  мероприятия, в которых учасвствует сотрудник

	 $events_quiz=$recs_events_by_ext['events_quiz/i_event_quiz'] ;
	 echo '<br>Проверяем  мероприятия <strong>Контроль Знаний</strong> - <strong>'._sizeof($events_quiz).'</strong> шт.<br>' ;
	 if (_sizeof($events_quiz))
	 {  // если есть мероприятия по доведению контента, производим формирование для сотрудника очереди вопросов. Если вопросы для сотрудника есть - добавл
  	    include(_DIR_TO_MODULES.'/quiz/i_quiz_logic.php') ;
        $obj_quiz_logic=new i_quiz_logic() ;
        $obj_quiz_logic->rec_personal=$rec_personal ;
        $arr_quelle=$obj_quiz_logic->get_personal_questions_quelle(['check_result'=>0]) ;
        if ($arr_quelle['quiestion_ids'])
        {  foreach($events_quiz as $rec_event) //if (!$rec_event['event_is_link_to_theme'])
          {  // надо добавить проверку собствееных условий отбора сотрудников
             // если их нет - добавляетм мероприятия в очередь
             // если есть - проверяем, подходит ли сотрудник для данного мероприятия, если да - мероприятие в очередь, если нет - игнор

             //echo 'Мероприятие "<strong>'.$rec_event['obj_name'].'</strong>"  - проверка условия отбора сотрудников для раздела темы КЗ' ;
             //$res=$this->check_select_filter_to_personal($rec_theme['filter'],$rec_personal,array('ssss'=>1)) ;
             //$ball_allow=$res['ball'] ;
             //$ball_allow=4 ;
             //if ($ball_allow)
             {   $rec_event_theme=$rec_event ;
                 //$rec_event_theme['theme_id']=$rec_theme['pkey'] ;
                 //$rec_event_theme['theme_name']=$rec_theme['obj_name'] ;
                 //$rec_event_theme['filter']=$rec_theme['filter'] ;
                 //$rec_event_theme['info_filter']=$rec_theme['info_filter'] ;
                 //$rec_event_theme['ball']=$ball_allow ;
                 $rec_event_theme['quiestion_ids']=$arr_quelle['quiestion_ids'] ;
                 $event_union[]=$rec_event_theme ;
                 //echo ' - <span class=green>Сотрудник входит в условия отбора, мероприятие добавлено в список с баллом <strong>'.$ball_allow.'</strong></span>, совпадение по '.implode(',',$res['info']).'<br>' ;
                 //echo ' - <span class=green>Сотрудник входит в условия отбора, мероприятие добавлено в список с баллом <strong>'.$ball_allow.'</strong></span>, будут заданы вопросы '.$arr_quelle['quiestion_ids'].'<br>' ;
             } //else echo ' - <span class=red>Сотрудник не входит в условия отбора, мероприятие отклонено</span><br>' ;
             // пока рассчитываем только на одно мероприятие, до уточнения концепции
             //break ;
          }
        } else echo '<div class=green>Вопросов по КЗ не сформировано</div>' ;
        }

	 //$events_poll=$recs_events_by_ext['events_poll/i_event_poll'] ;

	 // сделать по аналогии с quiz
	 /*echo '<br>Проверяем  мероприятия <strong>Опросы</strong> - <strong>'._sizeof($events_poll).'</strong> шт.<br>' ;
	 if (_sizeof($events_poll)) foreach($events_poll as $rec_poll_event) if (!$session_info['content_view']['during_systolic'])
	 // если свободно место в сессии для опроса - делаем запрос на сессию опроса
	 {
	     $options['question_count']=($rec_poll_event['_ext_info']['question_count'])? $rec_poll_event['_ext_info']['question_count']:2 ;
	     $options['event_id']=$rec_poll_event['pkey'];
	     $res=POLL()->poll_session_open($rec_personal,$session_info,$options) ;
	     if ($res['session_id'])
         { $session_info['content_view']['during_systolic']=$res['session_id'] ;
           echo '<div class=green>В текущей сессии заборонирована позиция <strong>during_systolic</strong></div>' ;
           // формируем данные для терминала для загрузкт фрема опроса
           $result['args']['data']['media_content']['during_systolic']['frame_src']=$res['session_frame_url'] ;
           $result['args']['data']['media_content']['during_systolic']['length']=$res['session_length'] ;
         } else echo '<div class=green>Вопросов по опросам не сформировано</div>' ;
	 } else echo '<div class=red>Позиция during_systolic уже занята</div>' ;
     */

	 $events_media=$recs_events_by_ext['events_media/i_event_media'] ;
	 echo '<br>Проверяем  мероприятия <strong>Доведение медиаконтента</strong> - <strong>'._sizeof($events_media).'</strong> шт.<br>' ;
	 if (_sizeof($events_media)) foreach($events_media as $rec_event)
	 {
	    $res=$this->check_select_filter_to_personal($rec_event['filter'],$rec_personal) ;
	    $ball_allow=$res['ball'] ;
        if ($ball_allow or 1)
        {   $rec_event['ball']=$ball_allow ;
            $event_union[]=$rec_event ;
        }

	 }

	 //print_2x_arr($event_union);
	 //print_2x_arr($recs_events_by_ext);

	 $debug_status=array() ;

	 echo 'Итого для сотрудника найдено <strong>'._sizeof($event_union).'</strong> мероприятия, в которых он дожен участвовать<br>' ;
	 if (_sizeof($event_union)) foreach($event_union as $rec_event)
	 {  $event_id=$rec_event['pkey'] ;
	    $personal_id=$session_info['personal_id'] ;
	    $prev_session_info=$session_info ;
	 	// Активных мероприятий может быть много, точек показа - всего три
	 	// необходимо внедрить систему рейтингов для правильной очередности показа
		//echo 'Проверяем мероприятие <strong>"'.$rec_event['obj_name'].'"</strong> [ID '.$event_id.']<br>' ;

		$debug_status[$event_id]['name']=$rec_event['obj_name'] ;
		$debug_status[$event_id]['type']=$rec_event['ext'] ;

		$ext_info=unserialize($rec_event['ext_info']) ;
		$rec_event['_ext_info']=$ext_info ;
		//echo 'Параметры мероприятия:<br>' ; damp_array($ext_info,1,-1) ;

        //$allow_by_usl_select=EVENTS()->check_event_by_to_personal_by_usl_select($rec_event,$personal_id,$debug_status) ;
        $allow_by_group=EVENTS()->check_event_by_group_id($rec_event,$session_info['group_id'],$debug_status) ;
        $allow_by_day=EVENTS()->check_event_by_day($rec_event,$debug_status) ;
        $allow_by_pass_status=EVENTS()->check_event_by_to_personal_by_pass_status($rec_event,$personal_id,$debug_status) ;



		//if ($session_info['personal_demo_access']) $allow_by_person=1;

		// пока самый простой случай - один показ контента
		//if ($rec_event_pass['pkey'] and ($rec_personal['demo_access'] or !$rec_event_pass['event_pass_id'] or $rec_event_pass['event_pass_status']==1)) // требуется довести контент
		ob_start() ;
		if ($allow_by_group and $allow_by_day and $allow_by_pass_status)
		{ echo '<div class="green">Мероприятие допущено для участия в сессии</div>' ;
		  // создаем событие участия в мероприятии
		  $obj_event=$this->get_event_obj_by_ext($rec_event['ext']) ;
		  // регистрируем участие сотрудника в мероприятии
		  // регистрация возможна только на незанятие места (after_auth,during_systolic,before_sign)
          // также тут будет вписано записи в таблицу media_content_view
		  $obj_event->register_personal_pass($rec_event,$session_info,$result) ;
		  //  если удалось зарегистрировать участие в мероприятие
		  }
		else echo '<div class="green">Мероприятие отклонено</div>' ;
		$text=ob_get_clean() ;
		$debug_status[$event_id]['register_personal_pass']['text']=$text ;

		// проверяем изменения мест показа контента
		if ($session_info['content_view']['after_auth']!=$prev_session_info['content_view']['after_auth']) $debug_status[$event_id]['content_view'][]='after_auth' ;
		if ($session_info['content_view']['during_systolic']!=$prev_session_info['content_view']['during_systolic']) $debug_status[$event_id]['content_view'][]='during_systolic' ;
		if ($session_info['content_view']['before_sign']!=$prev_session_info['content_view']['before_sign']) $debug_status[$event_id]['content_view'][]='before_sign' ;

		// проверяем что еще есть свободные позиции для показа медиаконтента, если свобных мест нет - больше не проверяем мероприятия
		if ($session_info['content_view']['after_auth'] and $session_info['content_view']['during_systolic'] and $session_info['content_view']['before_sign'])
			{   echo '<div class="red">Свободных мест для размещения медиаконтента больше нет, перебор мероприятий прерван</div>' ;
				break ;
			  }
			  }
	 else echo 'Нет актальных мероприятий доставки контента<br>' ;

	 ?><table class="basic fz_small full auto">
	        <tr><th>ID</th>
	            <th>Наименование</th>
	            <th>1. Проверка по статусу участия в мероприятии</th>
	            <th>2. Проверка по группе терминала</th>
	            <th>3. Проверка по расписанию мероприятия</th>
	            <th>Регистрация участника мероприятия</th>
	            <th>Бронирование места доведения контента</th>
            </tr>
            <? if (_sizeof($debug_status)) foreach ($debug_status as $event_id => $info)
            {
                ?><tr>
                                <td><?echo $event_id?></td>
                                <td><?echo $info['name'].'<br>'.$info['type']?></td>
                                <td><?echo $info['check_pass_status']['text']?></td>
                                <td><?echo $info['check_group_ids']['text']?></td>
                                <td><?echo $info['check_day']['text']?></td>
                                <td><?echo $info['register_personal_pass']['text']?></td>
                                <td><?echo (_sizeof($info['content_view']))? implode('<br>',$info['content_view']):''?></td>
                  </tr>
                <?
            }

            ?>
       </table>
       <?


	 if (_sizeof($result['args']['data']['media_content']))
	 {  echo '<strong>Сформировано тело запроса по медиаконтенту</strong><br>' ;
	    damp_array($result['args']['data']['media_content'],1,-1)  ;
	 }
	 if (_sizeof($result['args']['data']['quiz'])) echo '<strong>Сформировано тело запроса по контролю знаний</strong>: '.$result['args']['data']['quiz'].'<br>' ;

	 $text=ob_get_clean() ;
	 if ($session_info['debug']) echo $text ;
	 LOG_JSON('mo_session')->reg('on_event_server_check_access_success',$text,array()) ;

   }

   // проверяем соответствие сотрудника в $rec_personal, фильтру
   // соответствия нет - ball =0
   // чем выше степерь соответствия, тем выше балл
    function check_select_filter_to_personal($filter,$rec_personal,$options=array())
       {
        $ball=0 ; $balls_info=array() ;
        $arr_filter=(!is_array($filter))? json_decode($filter,true):$filter ; //damp_array($arr_filter,1,-1);
        unset($arr_filter['section_id']) ;
        // проверяем число совпадений сотрудкника с заданными фильтрами, как только сотрудник не попадает в фильтр, баллы должны обнуляться
        if (_sizeof($arr_filter)) foreach($arr_filter as $key=>$values)
        {   $block=1 ;
            //echo '$key='.$key.'<br>' ; echo '$values='.print_r($values,true).'<br>' ;
            switch($key)
            { // проверяем организацию сотрудника. по умолчания ставим block=1, если будет найдено хотябы одно соответствие block=0
              // но если после проверки одного из фильтров  $block останется равным 1 - значит по этому параметру совпедаения не было и ball=0
              case 'org_ids':     if (_sizeof($values)) foreach($values as $org_id=>$temp)      if ($rec_personal['parent2']==$org_id) { $block=0;  $ball=$ball+2 ;$balls_info[]='Организация'  ;}break ;
              case 'otdel_ids':   if (_sizeof($values)) foreach($values as $otdel_id=>$temp)    if ($rec_personal['parent3']==$otdel_id or $rec_personal['parent4']==$otdel_id or $rec_personal['parent5']==$otdel_id or $rec_personal['parent6']==$otdel_id) {$block=0;  $ball=$ball+3 ;$balls_info[]='Подразделение'  ;}break ;
              case 'working_ids': if (_sizeof($values)) foreach($values as $workings_id=>$temp) if ($rec_personal['working']==$workings_id) { $block=0; $ball=$ball+4 ; $balls_info[]='Должность'  ; } break ;

              // на группу добавть 5 баллов
            }
            // если сотрудник не прошел хотябы по одному из параметров фильтра - убираем баллы и далее не проверяем
            //echo 'block='.$block.'<br>' ;
            if ($block) {$ball=0; break ;}
        }
        if ($options['ssss'])
            { if (!isset($arr_filter['org_ids']) and !_sizeof($arr_filter['org_ids']) and
                  !isset($arr_filter['otdel_ids']) and !_sizeof($arr_filter['otdel_ids']) and
                  !isset($arr_filter['working_ids']) and !_sizeof($arr_filter['working_ids'])
              ) $ball++ ; $balls_info[]='Все сотрудники'  ;

            }
        return(['ball'=>$ball,'info'=>$balls_info]) ;
     }

     function check_event_by_to_personal_by_usl_select($rec_event,$personal_id,&$debug_status)
     {  $event_id=$rec_event['pkey'] ;
        $rec_personal=execSQL_van('select * from obj_site_personals where pkey='.$personal_id) ;
        $recs_workers=execSQL('select * from obj_site_workers where personal_id='.$personal_id) ;
        ob_start() ;
        // проверяем, привязано ли это мероприятие к теме проверки знаний
        $check_themes=execSQL('select * from quiz_themes where event_id='.$rec_event['pkey'],2) ;
        if (_sizeof($check_themes))
        { $check_rasdels=execSQL('select * from quiz_themes where parent in ('.implode(',',array_keys($check_themes)).')',2) ;
          // две проблемы
          // 1. Найти, какая тема из всех тем для сотрудника самая актуальная (сотрудник попадает туда по максмальному числу совпадаений)
          // 2. Не проверять темы, которые он уже прослушал

          $balls=[] ;$balls_info=[] ;
          if (_sizeof($check_rasdels)) foreach($check_rasdels as $rasdel_id=>$rec_rasdel)
          { echo 'Проверяем раздел: '.$rec_rasdel['obj_name'].'<br>' ;
            $balls[$rasdel_id]=0 ;$balls_info[$rasdel_id]=[] ;
            $arr_filter=json_decode($rec_rasdel['filter'],true) ;
            //damp_array($arr_filter);
            // проверяем число совпадений сотрудкника с заданными фильтрами
            if (_sizeof($arr_filter)) foreach($arr_filter as $key=>$values)
            switch($key)
            { // проверяем организацию сотрудника
              case 'org_ids':   if (_sizeof($values)) foreach($values as $org_id=>$temp) if ($rec_personal['parent2']==$org_id) {$balls[$rasdel_id]++ ;$balls_info[$rasdel_id][]='Организация'  ;}break ;
              case 'otdel_ids': break ;
              case 'working_ids': if (_sizeof($values)) foreach($values as $workings_id=>$temp) if ($rec_personal['working']==$workings_id) { $balls[$rasdel_id]++ ; $balls_info[$rasdel_id][]='Должность'  ; } break ;
            }

          }
          damp_array($balls,1,-1);
          damp_array($balls_info,1,-1);
          // находим раздел, который получил максимальное кол-во баллов
          $ball_max=0 ; $section_max=0 ;
          if (_sizeof($balls)) foreach($balls as $section_id=>$ball) if ($ball>$ball_max) {$ball_max=$ball; $section_max=$section_id ; }
          echo 'Определена наиболее актукальный раздел для проверки, ID: '.$section_max.'<br>' ;


        }

        $usl_select=($rec_event['_ext_info']['usl_select'])? $rec_event['_ext_info']['usl_select']:'clss=211 and enabled=1' ;
        echo 'Параметры мероприятия [usl_select]: <strong>'.$usl_select.'</strong></br>' ;
        // проверяем попадает ли сотрудник в текущие мероприятие и не прошел ли он его уже
        $personal_use=execSQL_value('select pkey from view_personals where pkey='.$personal_id.' and '.$usl_select) ;
        $allow_by_usl_select=($personal_use)? 1:0 ;
        echo 'Допуск по условию отбора сотрудников: '.(($allow_by_usl_select)? '<span class="green">Разрешено</span>':'<span class="red">Запрещено</span>').'</br>' ;
        $text=ob_get_clean() ;
        $debug_status[$event_id]['check_usl_select']['text']=$text ;
        $debug_status[$event_id]['check_usl_select']['status']=$allow_by_usl_select ;
        return($allow_by_usl_select) ;
       }

     function check_event_by_group_id($rec_event,$term_group_id2,&$debug_status)
      { $event_id=$rec_event['pkey'] ;
        ob_start() ;
        if ($rec_event['_ext_info']['group_ids'])
        {   echo 'Параметры мероприятия [group_ids]: <strong>'.$rec_event['_ext_info']['group_ids'].'</strong></br>' ;
            // собираем список всех дочерних групп для  group_ids
            $arr_ids=explode(',',$rec_event['_ext_info']['group_ids']) ;  $arr_groups=array() ;//$arr_groups2=array() ;
            if (_sizeof($arr_ids)) foreach($arr_ids as $group_id)
               { if (isset(ACCOUNTS()->tree[$group_id]))
                   { $arr=ACCOUNTS()->tree[$group_id]->get_arr_child() ;
                     $arr_groups=array_merge($arr_groups,$arr) ;
                     //$arr_groups2=$arr_groups+$arr ;
                   } else echo '<div class="red">not set group id '.$group_id.' in ACCOUNTS tree</div>' ;
               } else echo '<div class="red">array $arr_ids is space</div>' ;
            // в массиве  $arr_groups будет список всех групп где разрешено проводить показ контента
            //echo '<strong>arr_groups over merge:</strong> ' ; damp_array($arr_groups,1,-1) ;
               //echo '<strong>arr_groups over append:</strong> '  ; damp_array($arr_groups2,1,-1) ;
               echo 'Дочерние группы терминалов: <strong>'.implode(',',$arr_groups).'</strong></br>' ;
               echo 'Группа терминала: <strong>'.$term_group_id2.'</strong><br>' ;
            $allow_by_group=(in_array($term_group_id2,$arr_groups))? 1:0 ;
        }
        else
        {   echo 'Условия по <strong>group_ids</strong> не задано</br>' ;
            $allow_by_group=1 ;
        }
        echo 'Допуск по группе терминала: '.(($allow_by_group)? '<span class="green">Разрешено</span>':'<span class="red">Запрещено</span>').'</br>' ;
        $text=ob_get_clean() ;
        $debug_status[$event_id]['check_group_ids']['text']=$text ;
        $debug_status[$event_id]['check_group_ids']['status']=$allow_by_group ;
        return($allow_by_group) ;
     }

     function check_event_by_day($rec_event,&$debug_status)
     {  $event_id=$rec_event['pkey'] ;
        // 1. Проверяем условие работы мероприятия по дням
        ob_start() ;
          if ($rec_event['_ext_info']['allow_days'])
          {  echo 'Параметры мероприятия [allow_days]: <strong>'.$rec_event['_ext_info']['allow_days'].'</strong></br>' ;
             $tt=getdate() ;
             $day=$tt['mday'] ;
             $allow_by_day=0 ;
             $ff=$day%2 ;
             switch($rec_event['_ext_info']['allow_days'])
             { case 1: if ($ff) { $allow_by_day=1 ; echo $day.'  - число нечетное и выбран показ по нечетным дням<br>' ; }
                       else echo $day.'  - число четное, но выбран показ по нечетным дням<br>' ;
                       break ;
                 case 2: if (!$ff) { $allow_by_day=1 ; echo $day.'  - число четное и выбран показ по четным дням<br>' ; }
                       else echo $day.'  - число нечетное, а выбран показ по четным дням<br>' ;
                       break ;
             }
          }
          else
          { $allow_by_day=1 ;
            echo 'Условия по <strong>allow_days</strong> не задано</br>' ;
          }
          echo 'Допуск по расписанию: '.(($allow_by_day)? '<span class="green">Разрешено</span>':'<span class="red">Запрещено</span>').'</br>' ;
        $text=ob_get_clean() ;
        $debug_status[$event_id]['check_day']['text']=$text ;
        $debug_status[$event_id]['check_day']['status']=$allow_by_day ;
        return($allow_by_day) ;
     }

      function check_event_by_to_personal_by_pass_status($rec_event,$personal_id,&$debug_status)
      { $event_id=$rec_event['pkey'] ;
       ob_start() ;
        // проверяем не прошел ли сотрудник текущие мероприятие
        $rec_event_pass=execSQL_van('select * from obj_site_events_pass where personal_id='.$personal_id.' and event_id='.$event_id) ;

        if (!$rec_event_pass['status']) $rec_event_pass['status']=0 ;
        if (!$rec_event_pass['status']) echo 'Сотрудник еще не учавствовал в мероприяии<br>' ;
        else echo 'Текущий статус участника: <strong>'.$rec_event_pass['status'].'</strong><br>' ;
        $allow_by_pass_status=($rec_event_pass['status']<3)? 1:0 ;
        echo 'Допуск по статусу участия в мероприятии: '.(($allow_by_pass_status)? '<span class="green">Разрешено</span>':'<span class="red">Запрещено</span>').'</br>' ;
   	  $text=ob_get_clean() ;
        $debug_status[$event_id]['check_pass_status']['text']=$text ;
        $debug_status[$event_id]['check_pass_status']['status']=$allow_by_pass_status ;
        return($allow_by_pass_status) ;
     }

     function on_event_server_check_access_success_view_debug_status($debug_status)
     {
         ?><table class="basic fz_small full auto">
            <tr><th>ID</th>
                <th>Наименование</th>
                <th>1. Проверка по группе терминала</th>
                <th>2. Проверка по расписанию мероприятия</th>
                <th>3. Проверка по условию отбора сотрудников</th>
                <th>4. Проверка по статусу участия в мероприятии</th>
                <th>Регистрация участника мероприятия</th>
                <th>Бронирование места доведения контента</th>
               </tr>
               <? if (_sizeof($debug_status)) foreach ($debug_status as $event_id => $info)
       {
                   ?><tr>
                                   <td><?echo $event_id?></td>
                                   <td><?echo $info['name']?></td>
                                   <td><?echo $info['check_group_ids']['text']?></td>
                                   <td><?echo $info['check_day']['text']?></td>
                                   <td><?echo $info['check_usl_select']['text']?></td>
                                   <td><?echo $info['check_pass_status']['text']?></td>
                                   <td><?echo $info['register_personal_pass']['text']?></td>
                                   <td><?echo (_sizeof($info['content_view']))? implode('<br>',$info['content_view']):''?></td>
                     </tr>
                   <?
               }

               ?>
          </table>
        <?
     }

   function on_event_server_examination_result_success(&$session_info,&$data)
   {   if (!function_exists('MEDIA_CONTENT')) return ;
       }


   function update_events_viewers()
    { $recs_events=execSQL('select * from obj_site_events_schedule where clss=222 and enabled=1 and status!=5') ;
      // кешируем содержимое таблицы для исключения разовых запросов в дальшейм
      $GLOBALS['db_cashe']['obj_site_events_schedule']=$recs_events ;
        FILE_LOG()->append('Проверка вьюверов мероприятий - '._sizeof($recs_events).' шт.') ;
      ?><h3><?echo 'Проверка вьюверов мероприятий - '._sizeof($recs_events).' шт.'?></h3><?
      if (_sizeof($recs_events)) foreach($recs_events as $rec) $this->update_event_viewer($rec,['no_save_rec_event'=>1]) ;
    }

	// единая функия для обновления вьювера мероприятия, для правильной передачи опция
	function update_event_viewer($rec_event,$options=array())
	{
		$viewer_name='view_personals_event_'.$rec_event['pkey'];

		if(!isset($options['no_filter_is_space'])) $options['no_filter_is_space']=1; // если не заданы фильтры, никого не выбираем
		if(!isset($options['read_only'])) $options['read_only']=0;
		if(!isset($options['view_viewer_sql'])) $options['view_viewer_sql']=0;
		if(!isset($options['debug'])) $options['debug']=0;
		if(!isset($options['check_count'])) $options['check_count']=0;

		// создает вьювер на основании условий отбора сотрудников
		// $name - название вьювера
		// $filter_set - json_decode поле $ext_info из personals_filters
		$filter_set=PERSONALS_FILTER()->get_personals_filter_to_item($rec_event['_reffer']);

		$options['event_id']=$rec_event['pkey']; // опция для report_personals
        $options['create_viewer']=1 ;  // create_viewer or create_ids_table
		$info_filter=PERSONALS_FILTER()->create_viewer_personals_by_filter_set($viewer_name,$filter_set,$options);

		if (!$options['no_save_rec_event'])
		{ $data=[];
		$data['info_filter']=$info_filter;
		$data['viewer_name']=$viewer_name;
		//damp_array($data,1,-1);
		EVENTS()->save_events($rec_event['pkey'],$data);
	}
	}

   function event_check_existst_table($rec_event)
   {
      $result=[] ;
      if ($rec_event['viewer_name'])
      {  $res=execSQL_line('SHOW TABLES  LIKE "'.$rec_event['viewer_name'].'"') ;
         if (!_sizeof($res)) $result['error']='Таблица   '.$rec_event['viewer_name'].' не существует<br>' ;
      } else $result['error']='Для мероприятия  '.$rec_event['obj_name'].' не задано имя целевой таблицы<br>' ;
      return($result) ;

   }

   function on_event_personal_medic_group_change($data)
   {  // проверяем срок действия ПМО для этого сотрудника
      $personal_id=$data['personal_id'] ;
      if ($personal_id and $GLOBALS['LS_esmo_PMO_event'])
      {   $rec_event=$this->get_event_by_id($GLOBALS['LS_esmo_PMO_event']) ;
          $obj_event=$this->get_event_obj_by_id($GLOBALS['LS_esmo_PMO_event']) ;
          $obj_event->check_pmo_len_for_status_7_8($rec_event,['personal_id'=>$personal_id]) ;
      }
   }

  function on_event_get_active_mess_to_personal($personal_id,&$rec_mess_exists,$options=[])
    {
       if ($GLOBALS['LS_esmo_PMO_event'])
       { // удаляем текущие сообщения
         if (sizeof($rec_mess_exists)) foreach($rec_mess_exists as $id=>$rec) if ($rec['source_obj']=='esmo_magnit_pmo/i_event_pmo') unset($rec_mess_exists[$id]) ;
         // и формируем новые на основе текущего статуса сотрудника
         $rec_pass=execSQL_van('select * from obj_site_events_pass where event_id='.$GLOBALS['LS_esmo_PMO_event'].' and personal_id='.$personal_id.' and enabled=1') ;
         //$rec_pass=EVENTS()->get_event_pass($GLOBALS['LS_esmo_PMO_event'],$personal_id)  ;
         if ($rec_pass['pkey'])
         {
            include_once(_DIR_EXT.'/esmo_magnit_pmo/i_event_pmo.php') ;
            $virt_mess=EVENT_PMO()->prepare_message_to_personal($rec_pass) ;
            if (sizeof($virt_mess)) $rec_mess_exists[]=$virt_mess ;
             }

         }
       /* плагин сам формирует свои сообщения
        * if ($GLOBALS['LS_esmo_OPO_event'])
       { // удаляем текущие сообщения
         if (sizeof($rec_mess_exists)) foreach($rec_mess_exists as $id=>$rec) if ($rec['source_obj']=='events_opo/i_event_opo') unset($rec_mess_exists[$id]) ;
         // и формируем новые на основе текущего статуса сотрудника
         $rec_pass=execSQL_van('select * from obj_site_events_pass where event_id='.$GLOBALS['LS_esmo_OPO_event'].' and personal_id='.$personal_id.' and enabled=1') ;
         if ($rec_pass['pkey'])
         {
            include_once(_DIR_EXT.'/events_opo/i_event_opo.php') ;
            $virt_mess=EVENT_OPO()->prepare_message_to_personal($rec_pass) ;
            if (sizeof($virt_mess)) $rec_mess_exists[]=$virt_mess ;
		 }

 	   }*/
       //print_2x_arr($rec_mess_exists);

    }

    function check_pass_dubl_to_delete($event_id)
      {
          ?><h2>obj_site_events_pass:</h2><?
              $arr_dubl=execSQL('select personal_id,min(pkey) as last_id,count(pkey) as cnt from obj_site_events_pass where event_id='.$event_id.' group by personal_id having cnt>1 order by cnt desc') ;
              if (sizeof($arr_dubl))
              {   echo 'Найдено <strong>'.sizeof($arr_dubl).'</strong> дубликата по участию в мероприятии<br>' ;
                  foreach ($arr_dubl as $rec_dubl)
                  {  ?><h2>Сотрудник ID <?echo $rec_dubl['personal_id']?></h2><?
                     $recs_pass=execSQL('select * from obj_site_events_pass where event_id='.$event_id.' and personal_id='.$rec_dubl['personal_id']) ;
                     print_2x_arr($recs_pass);
                     $last_id=$rec_dubl['last_id'] ;
                     foreach ($recs_pass as $rec_pass) if ($rec_pass['fname'] or $rec_pass['scan_id'] or $rec_pass['data_from'] or $rec_pass['data_to']) $last_id=$rec_dubl['last_id'] ;
                     echo 'Будет оставлена запись ID='.$last_id.'<br>' ;
                     if ($_POST['cmd']=='delete_dubl')
                     { $result=execSQL_update('delete from obj_site_events_pass where pkey in ('.implode(',',array_keys($recs_pass)).') and pkey!='.$last_id,['return_result'=>1]) ;
                       damp_array($result,1,-1);
                     }
                  }
                  ?><button class="v1" cmd="delete_dubl">Удалить дубликаты</button><?
              }
              else echo 'Дубликаты отсутствуют<br>' ;
      }


}



?>
