<?php

$__functions['init'][]='_esmo_ruda_site_vars' ;
$__functions['boot_site'][]='_esmo_ruda_site_boot' ;
include('i_rabbit_ruda.php') ;
include('i_hard_ids.php') ;
include_once(_DIR_TO_ENGINE.'/c_db_mysql.php') ;

function ESMO_RUDA() {
  if (isset($_SESSION['esmo_ruda_system'])) {
    return($_SESSION['esmo_ruda_system']);
  } else {
    $_SESSION['esmo_ruda_system']=new c_esmo_ruda_system();
    return($_SESSION['esmo_ruda_system']);
  }
}


function _esmo_ruda_site_vars()
{
    $_SESSION['init_options']['esmo_ruda']['debug']=0 ;
}

function _esmo_ruda_site_boot($options)
{
  create_system_modul_obj('esmo_ruda',$options) ;

}


class c_esmo_ruda_system
{
	var $usl_select_zone_to_routers ;
    function __construct($create_options=array())
    {
	   ENGINE()->reg_ext('esmo_ruda','Весовая')  ;
	   ENGINE()->reg_ext('rabbit','Rabbit')  ;
	   // ENGINE()->reg_ext('events_esmo_ruda','Контроль знаний - мероприятия')  ;
	   $this->usl_select_zone_to_routers='(clss in (600) or (clss=601 and type=4) or (clss=601 and type=3 and virt=1))' ;

    }


	function declare_menu_items_1($page)
       {
           $page->menu['/cab/esmo_ruda/']=array('title'=>'ЭСМО РУДА') ;
           $page->menu['/cab/esmo_gateway_weigher/']['title']='Интеграция весовая';
           $page->menu['/cab/esmo_ruda/emu_1c/catalog_pers/']=array('title'=>'ЭСМО Эмуляция') ;
           $page->menu['/cab/esmo_ruda/debug/1/']=array('title'=>'ЭСМО РУДА Отладка') ;
           $page->menu['/cab/esmo_ruda/rabbit_read/']=array('title'=>'RABBIT READ','class_item'=>'v2','attr_item'=>'cmd="rabbit/kanal_read"') ;
           $page->menu['/cab/esmo_ruda/debug/rabbit/']=array('title'=>'RABBIT LOG') ;
       }

    // прием пакетов rabbit
    // вызывается через планировщик один раз в минуту
    // в дальнейшем должен работать в виде самостоятельного процесса
    function rabbit_kanal_read()
    {  $arr=RABBIT_RUDA()->rabbit_kanal_read() ;
       return($arr) ;
    }

    // обработчик события приема пакета из раббита
    // вызывается независимо от способа приема пакета
    function on_event_rabbit_packet_received($data)
   	{   $result=array() ;
   	    //ob_start() ;
   	    $props=$data['props'] ; // свойства сообщения
   	    $mess=$data['mess'] ; // тело сообщения
   		if (_sizeof($mess) and isset($props['type'])) switch($props['type'])
   		{ case 'card_person':     $this->card_person_received($mess,$props) ; break ;
   		  case 'card_car':        $this->card_car_received($mess,$props) ; break ;
          case 'card_task':       $this->card_task_received($mess) ; break ;
   		  case 'card_request_line': $result=$this->card_request_received($mess) ;  // в позициях заявки передается информация по заявке
                                    $result=$this->request_content_received($mess,$props) ; break ;
   		  case 'trip_point':      $result=$this->trip_point_received($mess,$props) ; break ;
   		  case 'request_card':    $result=$this->request_card($mess) ; break ;
          default:			  	  $result['error_text']=$props['type'] ;
                                  $result['error_code']='unknown_theme' ;
   		}
   		else if (!$props['type'])
        {
            $result['error_text']='Не задана тема пакета' ;
            $result['error_code']='not_set_theme' ;
        }
   		//$text=ob_get_clean() ;
   		//echo $text ;
        // тут ничего не логгируем, все будет сохранено в логе раббита
   		//if (!$result['no_log_on_event_rabbit_packet_received']) LOGS()->reg_log('on_event_rabbit_packet_received',$text,array('data'=>$data)) ;
        //if ($text) $result['debug']=$text ;
        return($result) ;
   	}


    //============================================================================================================================================================================
   	//
   	// Работа с маршрутами
   	//
   	//============================================================================================================================================================================

	function route_create($name,$arr_points)
	 { $result=array();
	   $rec['clss']=800 ;
	   $rec['parent']=1 ;
	   $rec['obj_name']=$name ;
	   $route_id=adding_rec_to_table('car_routers',$rec) ;
	   LOGS()->reg_log('esmo_ruda_edit','Добавлен новый маршрут:'.$rec['obj_name']) ;
	   $this->route_create_points($route_id,1,$arr_points[1]) ;
	   $this->route_create_points($route_id,2,$arr_points[2]) ;
	   $result['result']='success' ;
	   return(array('result'=>'success')) ;
	 }

	function route_create_points($route_id,$type,$arr_points)
	{ execSQL_update('delete from car_routers_points where parent='.$route_id.' and type='.$type) ;
	  $list_zones=TREE('obj_site_skd')->get_list_strukture('(clss in (600) or (clss=601 and type=4) or (clss=601 and type=3 and virt=1))');
	  if (_sizeof($arr_points)) foreach($arr_points as $point_id)
	  { $rec['clss']=801 ;
	    $rec['parent']=$route_id ;
	    $rec['obj_name']=$list_zones[$point_id] ;
	    $rec['type']=$type ;
	    $rec['point_id']=$point_id ;
	    adding_rec_to_table('car_routers_points',$rec) ;
	  }
	}

	function route_save($route_id,$rec,$arr_points)
	{ //LOGS()->reg_log('route_save',$route_id,array('data'=>$rec)) ;
	  update_rec_in_table('car_routers',$rec,'pkey='.$route_id) ;
	  //$this->route_create_points($route_id,1,$arr_points[1]) ;
      //$this->route_create_points($route_id,2,$arr_points[2]) ;
	  $result['result']='success' ;
      return(array('result'=>'success')) ;
	}

	function get_route_by_id($id,$options=array())
	{ $rec=execSQL_van('select * from car_routers where pkey='.$id) ;
	  if ($rec['pkey']) $this->prepare_public_info_to_route($rec,$options) ;
	  return($rec) ;
	}

	function get_route_name_by_id($id,$options=array())
	{ $name=execSQL_value('select obj_name from car_routers where pkey='.$id) ;
	  return($name) ;
	}

	function prepare_public_info_to_route(&$rec,$options=array())
	{  $rec['__href']='/cab/esmo_ruda/route_card/'.$rec['pkey'].'/' ;
	   if ($options['get_points'])
	   {  $_usl[]='t1.parent='.$rec['pkey'] ;
	      if ($options['type']) $_usl[]='t1.type='.$options['type'] ;
	      $usl=implode(' and ',$_usl) ;
	      $recs_points=execSQL('select t1.pkey,t1.obj_name,t1.type,t1.point_id,
                               t3.obj_name as zone_name,t3.pkey as zone_id
                               from car_routers_points t1
                               left join obj_site_skd t2 on t2.pkey=t1.point_id
                               left join obj_site_skd t3 on t3.pkey=t2.parent
                               where '.$usl.' order by t1.indx') ;
	      //$recs_points=execSQL('select * from car_routers_points where '.$usl.' order by indx') ;
		  if (_sizeof($recs_points)) foreach($recs_points as $rec_point)
		  { $rec['points'][$rec_point['type']][$rec_point['pkey']]=$rec_point ;
		    $rec['points_info'][$rec_point['type']][$rec_point['pkey']]=$rec_point['obj_name'] ;
		  }
	   }
	   if ($options['get_points_id'])
	   {  $_usl[]='parent='.$rec['pkey'] ;
	      if ($options['type']) $_usl[]='type='.$options['type'] ;
	      $usl=implode(' and ',$_usl) ;
	      $recs_points=execSQL('select pkey,obj_name,type,point_id from car_routers_points where '.$usl.' order by indx') ;
		  if (_sizeof($recs_points)) foreach($recs_points as $rec_point)
		  { $rec['points'][$rec_point['type']][$rec_point['pkey']]=$rec_point['point_id'] ;
		    $rec['points_info'][$rec_point['type']][$rec_point['pkey']]=$rec_point['obj_name'] ;
		  }
	   }
	}

    function get_route_points($route_id,$options=array())
       {   $_usl=array() ;
           $_usl[]='parent='.$route_id ;
           $_usl[]='type=1' ;
           if ($options['exclude']) $_usl[]='not obj_name like "%'.$options['exclude'].'%"' ;
           $usl=implode(' and ',$_usl) ;
           //$arr_route_points=execSQL('select * from car_routers_points where '.$usl.' order by indx',2) ;
           $arr_route_points=execSQL_row('select pkey,obj_name from car_routers_points where '.$usl.' order by indx') ;
           if ($options['small_name'])
           { if (_sizeof($arr_route_points)) foreach($arr_route_points as $id=>$name)
               { $arr=explode('/',$name) ;
                 $name=$arr[_sizeof($arr)-1] ;
                 $arr_route_points[$id]=$name ;
               }

           }

           return($arr_route_points) ;
       }


    //============================================================================================================================================================================
   	//
   	// Смена водителя
   	//
   	//============================================================================================================================================================================

	function get_smena_by_id($id,$options=array())
	{ $rec=execSQL_van('select * from view_car_smena where pkey='.$id) ;
	  if ($rec['pkey']) $this->prepare_public_info_to_smena($rec,$options) ;
	  return($rec) ;
	}

	function get_smena_trips($id,$options=array())
	{ $trip_recs=execSQL('select * from car_trip where smena_id='.$id.' and wn>0 order by pkey') ;
	  return($trip_recs) ;
	}

    // возвращает последнуюю открытую смену водителя
   	// !!! закрытие смен должно происходить автоматически по расписанию
   	// прошло 12 часов с открытия смены - смена должна закрыться автоматически
   	function get_open_driver_smena($person_id,$car_id,$route_id)
   	{ $time_from=time()-60*60*12 ;
   	  echo 'Возвращаем открытую смену водителя ('.date('d.m.Y H:i',$time_from).')<br>' ;
   	  $_usl[]='person_id='.$person_id ;
   	  $_usl[]='car_id='.$car_id ;
   	  $_usl[]='route_id='.$route_id ;
   	  $_usl[]='status=1';
   	  $_usl[]='c_data>'.$time_from ; //  смена должны быть открыта не позднее 12 часов назад
   	  $usl=implode(' and ',$_usl) ;
   	  $rec=execSQL_van('select * from car_smena where '.$usl.' order by pkey desc limit 1') ;
   	  return($rec) ;
   	}

   	// возвращает последнуюю открытую смену водителя
   	// !!! закрытие смен должно происходить автоматически по расписанию
   	// прошло 12 часов с открытия смены - смена должна закрыться автоматически
   	function get_open_driver_smena_id_by_tmc_pass_id($pass_id)
   	{ $_usl[]='pass_id='.$pass_id ;
   	  //$_usl[]='car_id='.$car_id ;
   	  //$_usl[]='route_id='.$route_id ;
   	  //$_usl[]='status=1';
   	  //$_usl[]='c_data>'.$time_from ; //  смена должны быть открыта не позднее 12 часов назад
   	  $usl=implode(' and ',$_usl) ;
   	  $smena_id=execSQL_value('select pkey from car_smena where '.$usl.' order by pkey desc limit 1') ;
   	  return($smena_id) ;
   	}

   	// возвращает последнуюю открытую смену водителя
   	// !!! закрытие смен должно происходить автоматически по расписанию
   	// прошло 12 часов с открытия смены - смена должна закрыться автоматически
   	function get_open_driver_smena_by_id($id)
   	{ $_usl[]='pkey='.$id ;
   	  $usl=implode(' and ',$_usl) ;
   	  $rec=execSQL_van('select * from car_smena where '.$usl.' order by pkey desc limit 1') ;
   	  return($rec) ;
   	}

   	// начинает новую смену водителя
   	function create_smena($data,$route_id,$now=0)
   	{   echo 'Начинаем новую смену водителя<br>' ;

        $request_id=0 ; $task_id=0 ;  $pass_id=$data['session']['tmc_pass_id'] ;
        // ищем официальную заявку на поездку водителя
        $rec_request=execSQL_van('select * from view_ruda_request_line where pass_id='.$pass_id.' limit 1') ;
        if ($rec_request['pkey'])
        { $request_id=$rec_request['parent'] ;
          $task_id=$rec_request['task_id'] ;
          $person_id=$rec_request['person_id'] ;
          $person_name=$rec_request['driver_name'] ;
          $car_id=$rec_request['car_id'] ;
          $car_number=$rec_request['car_number'] ;
        }
        else
        { // временно, до запрета левых водил берем соответвие ID персон скуда и руды из таблицы
          // после запросе $person_id и $car_id надо брать сразу из карточка заявки
          $person_id=($data['session']['driver_id'])? execSQL_value('select pkey from drivers where skd_id='.$data['session']['driver_id']):0  ;
          $car_id=($data['session']['car_id'])? execSQL_value('select pkey from obj_site_cars where skd_id='.$data['session']['car_id']):0  ;
          $person_name=$data['session']['driver_name'];
          $car_number=$data['session']['car_name'];

        }


   	    if (!$now) $now=time() ;
   		$rec=array(  'clss'=>807,
   		             'indx'=>1,
   		             'c_data'=>$now,
   					 'pass_id'=>$pass_id,
   					 'pass_type'=>$data['session']['tmc_pass_type'],
   					 'pass_name'=>$data['session']['tmc_pass_name'],
                     'person_id'=>$person_id,
                     'skd_person_id'=>$data['session']['driver_id'],
                     'person_name'=>$person_name,
                     'car_id'=>$car_id,
                     'skd_car_id'=>$data['session']['car_id'],
                     'car_name'=>$car_number,
                     'route_id'=>$route_id,
                     'request_id'=>$request_id,
                     'task_id'=>$task_id,
                     'status'=>1,
                     't_start'=>$now,
                     't_end'=>$now,
                     'trip_count'=>0,
   					) ;
   		//damp_array($rec,1,-1) ;
   		$smena_id=adding_rec_to_table('car_smena',$rec) ;
   		return($smena_id) ;
   	}


	function prepare_public_info_to_smena(&$rec,$options=array())
	{  $rec['__href']='/window/esmo_ruda/smena/card/'.$rec['pkey'].'/' ;
/*	   if ($options['get_points'])
	   {  $recs_points=execSQL('select pkey,obj_name,type,point_id from car_routers_points where parent='.$rec['pkey'].' order by indx') ;
		  if (_sizeof($recs_points)) foreach($recs_points as $rec_point)
		  { $rec['points'][$rec_point['type']][]=$rec_point ;
		    $rec['points_info'][$rec_point['type']][]=$rec_point['obj_name'] ;
		  }
	   }
*/
	}

	function check_smena_time()
	{	$now=getdate() ;
		$t=mktime($now['hours']-12,$now['minutes'],$now['seconds'],$now['mon'],$now['mday'],$now['year']);
		$recs=execSQL('select * from car_smena where t_start<'.$t.' and status=1') ;
		if (_sizeof($recs))
        {   echo 'Будет завершено <strong>'._sizeof($recs).'</strong> смен</br>' ;
            foreach($recs as $rec) $this->smena_update($rec['pkey'],array('status'=>2)) ;
        }
	}

	function smena_update($id,$data)
	{  $rec=execSQL_van('select * from car_smena where pkey='.$id) ;
	   if ($rec['pkey'])
	   {  $arr_changes=array() ; $data_to_save=array() ;
    	  if (isset($data['status']) and $data['status']!=$rec['status']) { $arr_changes['Статус']=$rec['status'].' => '.$data['status'] ; $data_to_save['status']=$data['status'] ; }
    	  if (isset($data['wt']) and $data['wt']!=$rec['wt']) { $arr_changes['Вес тары']=$rec['wt'].' => '.$data['wt'] ; $data_to_save['wt']=$data['wt'] ; }
    	  if (isset($data['wn']) and $data['wn']!=$rec['wn']) { $arr_changes['Вес нетто']=$rec['wn'].' => '.$data['wn'] ; $data_to_save['wn']=$data['wn'] ; }
    	  if (isset($data['trip_count']) and $data['trip_count']!=$rec['trip_count']) { $arr_changes['Число рейсов']=$rec['trip_count'].' => '.$data['trip_count'] ; $data_to_save['trip_count']=$data['trip_count'] ; }
    	  if (isset($data['t_end']) and $data['t_end']!=$rec['t_end']) { $arr_changes['Время окончания']=date('d.m.Y H:i:s',$rec['t_end']).' => '.date('d.m.Y H:i:s',$data['t_end']) ; $data_to_save['t_end']=$data['t_end'] ; }
    	  if (_sizeof($arr_changes))
    	  { //echo 'Обновляем данные по смене:' ;
    	    //damp_array($data_to_save,1,-1) ;
    	    $res=update_rec_in_table('car_smena',$data_to_save,'pkey='.$id,array('debug'=>0)) ;
    	    //damp_array($res,1,-1) ;
    	    //LOGS()->reg_log('smena_change','',array('data'=>$arr_changes,'reffers'=>$rec['_reffer'])) ;
    	  }
	   }
	}

    //============================================================================================================================================================================
   	//
   	// Рейс водителя
   	//
   	//============================================================================================================================================================================

    // ищем открытый рейс водителя
   	// рейс автоматически открывается когда фиксится первая точка маршрута,
   	// и автоматически закрывается когда фиксится последняя точука маршрута
   	function get_open_driver_trip_id($smena_id)
   	{
   		$trip_id=execSQL_value('select pkey from car_trip where smena_id='.$smena_id.' and status=1') ;
   		return($trip_id) ;
   	}

   	function get_trip_by_id($id,$options=array())
   	{
   		$rec_trip=execSQL_van('select * from view_car_trip where pkey='.$id) ;
        if ($rec_trip['pkey']) $this->prepare_public_info_to_trip($rec_trip,$options) ;
   		return($rec_trip) ;
   	}

    function prepare_public_info_to_trip(&$rec,$options=array())
   	{  $rec['__href']='/cab/esmo_ruda/trip/card/'.$rec['pkey'].'/' ;
   	   if ($options['get_points'])
   	   {  $rec['points']=execSQL('select * from car_trip_recs where parent='.$rec['pkey'].' order by indx') ;
   	   }
   	}


   	function create_driver_trip($smena_id,$now=0)
   	{   echo 'Начинаем новый рейс водителя<br>' ;
   	    // считаем число уже завершенных вейсов в данной смене
        if (!$now) $now=time() ;
   		$last_trip_count=execSQL_value('select count(pkey) from car_trip where smena_id='.$smena_id.' and status=2 and c_data<='.$now) ;
   		$last_trip_count++ ;

   		$rec=array(  'clss'=>804,
                        'c_data'=>$now,
                        'obj_name'=>'',
                        'indx'=>$last_trip_count,
                        'smena_id'=>$smena_id,
                        'status'=>1,
                        'num'=>$last_trip_count,
                        't_start'=>$now,
                        't_end'=>$now,
   					) ;

   		//damp_array($rec,1,-1) ;
   		$trip_id=adding_rec_to_table('car_trip',$rec) ;
        $trip_count=execSQL_value('select count(pkey) from car_trip where smena_id='.$smena_id) ;
   		$this->smena_update($smena_id,array('trip_count'=>$trip_count)) ;
   		return($trip_id) ;
   	}

    function get_trip_point_by_id($id)
    {
        $rec=execSQL_van('select * from car_trip_recs where pkey='.$id) ;
        return($rec) ;
    }

    function trip_close($trip_id)
    {   update_rec_in_table('car_trip',array('status'=>2),'pkey='.$trip_id) ;
        $rec_trip=$this->get_trip_by_id($trip_id,array('get_points'=>1)) ;
        // если поедка выполнена в рамках задачи - отправлям уведомление в oracle
        if ($rec_trip['task_header_id']) RABBIT_RUDA()->send_trip($rec_trip,array('test'=>0)) ;
        else                             LOGS()->reg_log('test','зевершение рейса ID '.$trip_id.', без задачи, не уведомляем') ;
    }

    function trip_confirmed($trip_id,$options=array())
    {   update_rec_in_table('car_trip',array('confirmed'=>1,'confirmed_account_id'=>MEMBER()->id,'confirmed_time'=>time()),'pkey='.$trip_id) ;
        $rec_trip=$this->get_trip_by_id($trip_id,array('get_points'=>1)) ;
        // если поедка выполнена в рамках задачи - отправлям уведомление в oracle
        if ($rec_trip['task_header_id']) RABBIT_RUDA()->send_trip_confirmed($rec_trip,array('test'=>$options['test'])) ;
        else                             LOGS()->reg_log('test','зевершение рейса ID '.$trip_id.', без задачи, не уведомляем') ;
    }

    //============================================================================================================================================================================
  	//
  	// Обработка события прохождения точки маршрута из ЭСМО СКУД
  	//
  	//============================================================================================================================================================================

    // регистрируем проход через точку маршрута
	function trip_point_received($data,$mess_props=array())
	{ if (!$data['access_type']) $data['access_type']=0 ; $logs=array() ;
	  $result=array() ;   $trip_id=0 ; $smena_id=0 ;  $t_start=time() ;
	  //if ($data['session']['driver_pass_type']!=14) { $result['error']='Неверный тип пропуска<br>' ; return($result) ; }
	  ob_start() ;
	  $logs[time()]['Получен пакет']['data']=$data ;
	  echo '<h2>'.date('d.m.Y H:i:s').': <strong>Получен пакет</strong></h2>' ;
      LOG_JSON('trip_log')->reg('Получен пакет','',array('data'=>$data)) ;
      damp_array($data,1,-1) ;
      $pass_id=$data['session']['tmc_pass_id'] ;
	  // ищем в заявках 1С заявку на передаенный пропуск. В заявке будет указан маршрут
	  $rec_request=execSQL_van('select * from view_ruda_request_line where pass_id='.$pass_id) ;
      if ($rec_request['pkey']) $route_id=$rec_request['route_id'] ;
      else                      $route_id=get_route_id_by_pass($data) ;
      // если не не заявки на данный пропуск - получаем $route_id на основании зон доступа пропуска
      // но это захардкоренный способ и при добавлении новых маршрутов работать не будет
      // предполагается что далее будут проходить учет только водители по маршрутным листам и для левых водил маршруты строится не будут

	  // важное дополнение
      // для запросов приходящих с терминалов ЭСМО РУДА уже известна точка point_id - это весовая
      // для запросов приходящик с терминалов СКУД - надо определить point_id через массив соответствий
	  $point_id=($data['device']['point_id'])? $data['device']['point_id']:get_point_id_by_zone_and_access_type($data['device']['zone_id'],$data['access_type']) ;
      if (!$point_id) echo '<div class="red">Не удалось определить точку маршрута для '.$data['device']['zone_id'].'/'.$data['access_type'].' - '.$data['device']['adres'].' '.$data['device']['name'].'</div>' ;

	  $now=strtotime($data['session']['now']) ;

	  // ищем открытую смену водителя
	  if ($rec_request['pkey'] or $route_id)
	  { $smena_id=$this->get_open_driver_smena_id_by_tmc_pass_id($pass_id) ;
	    if (!$smena_id) $smena_id=$this->create_smena($data,$route_id,$now) ;
		if (!$smena_id) { $result['error']='Не удалось получить запись по смене<br>' ; return($result) ; }
		$result['smena_id']=$smena_id ;
	    // ищем открытый рейс водителя
		$trip_id=$this->get_open_driver_trip_id($smena_id) ;
		if (!$trip_id) $trip_id=$this->create_driver_trip($smena_id,$now) ;
		if (!$trip_id) { $result['error']='Не удалось получить запись по рейсу<br>' ; return($result) ; }

		// сохраняем точку маршрута в смене/рейсе
		// передано id устройства, через которое прошел водитель

        // проверяем что этой сессии шлагбаума еще не было
        $check_dubl_session=($data['session']['session_uid'])? execSQL_value('select pkey from car_trip_recs where session_uid="'.$data['session']['session_uid'].'"',2):0 ;
        if (!$check_dubl_session)
        { $result['trip_point_pkey']=$this->fixed_trip_point( $smena_id,
                                                            $trip_id,
                                                            $route_id,
                                                            $point_id,
                                                            $now,
                                                            $data['device']['zone_id'],
                                                            $data['session']['weight'],
                                                            $data['session']['comment'],
                                                            $mess_props['message_id'],
                                                            $data['session']['session_uid']
                                            ) ;
           echo '<span class="green">Добавлена точка рейса</span>: '.$smena_id.' / '.$trip_id.' / '.$point_id.'<br>' ;
        }
        else echo '<span class="green">Пропущена точка рейса</span>: '.$smena_id.' / '.$trip_id.' / '.$point_id.' - двойное прикладывание/открытие<br>' ;
        $result['trip_id']=$trip_id ;


		// обновляем вес в поездке для весовых
		if ($data['session']['weight'])
        {   //$this->trip_point_update_weight($trip_id,$data['session']['weight']) ;
            $this->update_trip_weight($trip_id) ;
        }
	  }
	  else echo $result['result']='<span class="red">Отказ в регистрации точки рейса</span><br>' ;

	  $result['route_id']=$route_id ;
	  $result['no_show_result_data']=1 ;  // не показывать массив result в логе обмена rabbit
      $result['no_log_on_event_rabbit_packet_received']=1 ;  // не логгировать данные в обработчике событий
	  $text=ob_get_clean() ;
	  if ($trip_id)
      { // лог для пакета раббита
        echo '<span class="green">Добавлена точка рейса</span>: '.$smena_id.' / '.$trip_id.' / '.$point_id.' ' ;
        LOG_JSON('trip_log')->reg('Добавлена точка рейса',$smena_id.' / '.$trip_id.' / '.$point_id.'<br>'.$text) ;
        $fname=LOG_JSON('trip_log')->flush('trip_log_'.$trip_id,array('reg_log'=>0)) ;
        echo ' <a href="'.$fname.'" target="_blank">Лог</a>' ;

      }
      else
      { $fname=$this->trip_reg_file_log(ENGINE()->generate_UID(),$text) ;
        echo '<span class="red">Отказ в регистрации точки рейса</span> ' ;
        echo '<a href="'.$fname.'" target="_blank">Лог</a>' ;
        //LOGS()->reg_log('trip_point',$text,array('data'=>$data)) ; - логгируется в логе раббота, тут избыточно
      }
      //echo $text ;
	  return($result) ;
	}

	function trip_reg_file_log($trip_id,$text)
    {
        $fname=LOGS()->reg_file_log('trip_log_'.$trip_id.'.html',$text,array('append_to_file'=>1,'no_append_time'=>1)) ;
        return($fname) ;
    }

    // регистрируем вес в точке маршрута
	function trip_point_update_weight($id,$weight)
	{ if (!$id) return ;
	  ob_start() ;
	  update_rec_in_table('car_trip_recs',array('weight'=>$weight),'pkey='.$id,array('debug'=>0)) ;
	  $trip_id=execSQL_value('select parent from car_trip_recs where pkey='.$id) ;
	  // обновляем вес в поездке для весовых
	  if ($trip_id>0) $this->update_trip_weight($trip_id) ;
	  $text=ob_get_clean() ;
	  LOG_JSON('trip_log')->reg('Взвешивание','Задан вес для рейса '.$trip_id.'/'.$id.': '.$weight.$text) ;
	}

    // регистрируем вес в точке маршрута
	function trip_point_update_weight_by_data($id,$data=array(),$comment='')
	{ if (!$id) return ;
	  ob_start() ;
	  update_rec_in_table('car_trip_recs',$data,'pkey='.$id,array('debug'=>0)) ;
	  $trip_id=execSQL_value('select parent from car_trip_recs where pkey='.$id) ;
	  // обновляем вес в поездке для весовых
	  if ($trip_id>0) $this->update_trip_weight($trip_id) ;
	  $text=ob_get_clean() ;
      LOG_JSON('trip_log')->reg($comment,'Задан вес для рейса '.$trip_id.'/'.$id.': '.$data['wt'].'/'.$data['wb'].'/'.$data['wn'].$text) ;
	}

	function fixed_trip_point($smena_id,&$trip_id,$route_id,$point_id,$now,$zone_id,$weight=0,$comment='',$message_id='',$session_uid='')
	{  ob_start() ;
	   echo '$smena_id='.$smena_id.'<br>' ;
	   echo '$trip_id='.$trip_id.'<br>' ;
	   echo '$point_id='.$point_id.'<br>' ;
	   echo '$zone_id='.$zone_id.'<br>' ;
        // в первую очередь проверка, что это не повторно первая точка маршрута
       /*$first_point_rec=execSQL_van('select * from car_trip_recs where parent='.$trip_id.' and indx=1') ;
       if ($first_point_rec['point_id']==$point_id)
       {  echo 'Обнаружена повторная первая точка маршрута<br>' ;
          echo 'Завершаем рейс '.$trip_id.'<br>' ;
          $this->trip_close($trip_id) ;
          $trip_id=$this->create_driver_trip($smena_id,$now) ;
       } */

	  // получаем последнюю пройденную точку поездки
      $recs_routers_points=execSQL('select * from car_routers_points where parent='.$route_id.' and type=1 order by indx',2,1) ;
      $last_trip_point_rec=execSQL_van('select * from car_trip_recs where parent='.$trip_id.' order by pkey',2) ;
      echo 'получаем последнюю пройденную точку рейса:<br>' ;
	  $last_trip_point=execSQL_value('select max(point_pkey) from car_trip_recs where parent='.$trip_id.' and point_pkey>0',2) ;
	  if (!$last_trip_point) $last_trip_point=0 ;
	  echo '$last_trip_point='.$last_trip_point.'<br>' ;

	  // получаем все точки машрута
	  //$recs_routers_points_all=execSQL('select * from car_routers_points where parent='.$route_id.' and type=1 order by indx') ;

      echo 'получаем точки маршрута после текущей точки:<br>' ;
	  $recs_routers_points=execSQL('select * from car_routers_points where parent='.$route_id.' and type=1 and pkey>='.$last_trip_point.' order by indx',2,1) ;
	  // необходимо вычислить ID текущей точки поездки
	  $point_pkey=0 ;
	  foreach($recs_routers_points as $i=>$rec_route_point)
	  { // если этой точка маршрута еще нет в уже пройденных точках - фиксим её и выходим
	    if (/*!isset($recs_trip_points_prev[$rec_route_point['pkey']]) and */$rec_route_point['point_id']==$point_id)
	    { $point_pkey=$rec_route_point['pkey'] ;
	      // если фиксируем последную точку маршрута - закрываем рейс
	      if ($i==_sizeof($recs_routers_points)-1)
          {   echo 'Зафиксировали последюю точку маршрута - закрываем рейс<br>' ;
              $this->trip_close($trip_id) ;

          }
	      break ;
	    }
	  }
	  // если точка в текущем маршруте рейсаа не найдена и это не весовая, а шлагбаум (есть session_uid)
	  if (!$point_pkey and $session_uid)
      {
          // если эта точка присутвует в списке точке маршрута - значит была пропущена последняя точка и надо начинать рейс заново
          $point_route_next_trip=execSQL_value('select pkey from car_routers_points where parent='.$route_id.' and type=1 and point_id='.$point_id.' limit 1',2,1) ;
          if ($point_route_next_trip)
          {  // надо закрыть текущий рейс
              echo 'Зафиксировали новую точку следующего рейса - закрываем тукущий рейс<br>' ;
              $this->trip_close($trip_id) ;
              // открыть новый
              echo 'Открываем новый рейс<br>' ;
              $trip_id=$this->create_driver_trip($smena_id,$now) ;
          }
      }

	  // добавляем точку маршрута в историю поездки
      echo 'Добавляем очередную точку рейса:<br>' ;
	  $rec_point=array('clss'=>805,
		               'c_data'=>$now,
	                   'parent'=>$trip_id,
	                   'zone_id'=>$zone_id,
	                   'point_id'=>$point_id,
	                   'point_pkey'=>$point_pkey,
	                   'weight'=>($weight)? $weight:0,
	                   'comment'=>($comment)? $comment:'',
	                   'message_id'=>($message_id)? $message_id:'',
	                   'session_uid'=>($session_uid)? $session_uid:''
	                  ) ;
	  damp_array($rec_point,1,-1) ;
	  $id=adding_rec_to_table('car_trip_recs',$rec_point) ;

	  // вписываем в рейс в окончание время очередной точки
      echo 'вписываем в окончание рейса время очередной точки <br>' ;
      update_rec_in_table('car_trip',array('t_end'=>$now),'pkey='.$trip_id) ;
	  // вписываем в смену в окончание время очередной точки
      $this->smena_update($smena_id,array('t_end'=>$now)) ;
      $text=ob_get_clean() ;
      LOG_JSON('trip_log')->reg('Добавление точка рейса',$text) ;
      return($id) ;
	}

	// использовалась временно при отладке
	/*function check_exists_weight($data)
	{  //  смотрим последюю точку текущего рейса сотрудника
		$result=array() ;
		ob_start() ;
	   $now=strtotime($data['session']['now']) ;
	   $rec_last_trip_point=execSQL_van('select t1.parent,t1.c_data,
		                 t2.person_id,t2.car_id
		                 from car_trip_recs t1
		                 left join car_trip t2 on t2.pkey=t1.parent
		                 where t2.person_id='.$data['session']['driver_id'].' and t2.car_id='.$data['session']['car_id'].' order by t1.pkey desc limit 1') ;
	   // ищем в старой таблице точку взвешивания между текущей и прошлым рейсом
		if ($rec_last_trip_point['c_data'])
		{   echo 'Ищем взвешивание между <strong>'.date('d.m.Y H:i:s',$rec_last_trip_point['c_data']).'</strong> и <strong>'.date('d.m.Y H:i:s',$now).'</strong><br>' ;
			$recs_weight=execSQL('select t1.parent,t1.c_data,t1.weight,
		                 t2.person_id,t2.car_id
		                 from car_trip_recs_copy2 t1
		                 left join car_trip_copy2 t2 on t2.pkey=t1.parent
		                 where t2.person_id='.$data['session']['driver_id'].'
		                   and t2.car_id='.$data['session']['car_id'].'
		                   and t1.c_data>='.$rec_last_trip_point['c_data'].'
		                   and t1.c_data<='.$now.'
		                   and t1.weight>0
		                   ') ;
			// если взвешивание найдено - регистриуем его в системе через стандартную процедуру
			if (_sizeof($recs_weight))
			{ echo 'Найдено взвешивание: ' ;
			  print_2x_arr($recs_weight) ;
			}
			if (_sizeof($recs_weight)) foreach($recs_weight as $rec_weight)
			{
				$rec_rabbit=array('type'=>'trip_point',
				                  'device'=>array('zone_id'=>777,
				                  ),
		                         'access_type'=>0,
		                         'session'=>array('tmc_pass_id'=>$data['session']['tmc_pass_id'],
		                                          'driver_id'=>$data['session']['driver_id'],
		                                          'car_id'=>$data['session']['car_id'],
		                                          'driver_name'=>$data['session']['driver_name'],
		                                          'car_name'=>$data['session']['car_name'],
		                                          'weight'=>$rec_weight['weight'],
		                                          'now'=>date('d.m.Y H:i:s',$rec_weight['c_data'])
		                                          ),
		                         'PDP'=>$data['PDP']
		                         );
				damp_array($rec_rabbit,1,-1) ;
				$result=$this->trip_point_received($rec_rabbit) ;
				damp_array($result,1,-1) ;
			}
		}
		$text=ob_get_clean() ;
		//if (_sizeof($result)) LOGS()->reg_log('check_exists_weight',$text) ;



	}  */

	// обновление веса рейса на основании постующих данных
	function update_trip_weight($trip_id)
    { ob_start() ; //$GLOBALS['debug_db']=2 ;
      echo 'trip_id='.$trip_id.'<br>' ;
      $smena_id=execSQL_value('select smena_id from car_trip where pkey='.$trip_id) ;
      $debug=0 ;
      // получаем последние данные по текущему рейсу, по всем точкам
      $wt=execSQL_value('select wt from car_trip_recs where parent='.$trip_id.' and wt>0 order by pkey desc',2) ;
      $wb=execSQL_value('select wb from car_trip_recs where parent='.$trip_id.' and wb>0 order by pkey desc',2) ;
      $wn=execSQL_value('select wn from car_trip_recs where parent='.$trip_id.' and wn>0 order by pkey desc',2) ;
      // если тара не задана - получаем тару из тары рейса или смены
      if (!$wt) $wt=execSQL_value('select wt from car_trip where pkey='.$trip_id.' and wt>0',2) ;
      if (!$wt) $wt=execSQL_value('select wt from car_smena where pkey='.$smena_id.' and wt>0',2) ;


      if ($wn==0 and $wb>0 and $wt>0) $wn=$wb-$wt ;
      if ($wt==0 and $wb>0 and $wn>0) $wt=$wb-$wn ;
      if ($wb==0 and $wn>0 and $wt>0) $wb=$wn+$wt ;
      echo 'wt='.$wt.'<br>' ;
      echo 'wb='.$wb.'<br>' ;
      echo 'wn='.$wn.'<br>' ;

      update_rec_in_table('car_trip',array('wt'=>$wt,'wb'=>$wb,'wn'=>$wn),'pkey='.$trip_id,array('debug'=>2))  ;

      $sum_wn=execSQL_value('select sum(wn) from car_trip where smena_id='.$smena_id.' and wn>0') ;
      $this->smena_update($smena_id,array('wt'=>$wt,'wn'=>$sum_wn)) ;
	  //$GLOBALS['debug_db']=0 ;
      $text=ob_get_clean() ;  //echo $text ;
      //LOGS()->reg_log('update_trip_weight',$text) ;
    }

	// обновление веса рейса на основании постующих данных
	function update_trip_weight_old($trip_id)
    { ob_start() ; //$GLOBALS['debug_db']=2 ;
      echo 'trip_id='.$trip_id.'<br>' ;
      $debug=0 ;
      // получаем все точки в текущем рейсе, в которых производилось взвешивание
      $arr_w=execSQL_line('select weight from car_trip_recs where parent='.$trip_id.' and weight>0 order by weight') ;
      ?><h3>arr_w</h3><?
      damp_array($arr_w,1,-1) ;
      $smena_id=execSQL_value('select smena_id from car_trip where pkey='.$trip_id) ;
      echo 'smena_id='.$smena_id.'<br>' ;
      // если только одно измерение - то ищем вес тары в прошлой поездке
      if (_sizeof($arr_w)<2)
      {  echo 'Менее двух значение, ищем старые записи по весу<br>' ;
      	 // 1. смотрим вес тары в записи по смене
	     $wt=execSQL_value('select wt from car_smena where pkey='.$smena_id) ;
      	 if ($wt>0)
         {  echo 'Вес тары найден в записи по смене: '.$wt.'<br>' ;
         	if ($arr_w[0]>$wt)
            { $arr_w[1]=$arr_w[0] ;
	          $arr_w[0]=$wt ;
            }
         	else $arr_w[1]=$wt ;  // первое измерение было брутто, в смене был брутто, сейчас получили нетто
         }
      	 else
         { echo 'ищем вес тары в рейсах смены<br>' ;
           // необхдимо добавить учет смены - чтобы искалось толкько в предыдущих поездках ТЕКУЩУЙ смены
	       $wt=execSQL_value('select wt from car_trip where smena_id='.$smena_id.' and wt>0 order by pkey desc') ;
		   if ($wt>0)
	       {  echo 'Вес тары найден в записи по рейсу: '.$wt.'<br>' ;
	       	  if ($arr_w[0]>$wt)
	          { $arr_w[1]=$arr_w[0] ;
	       	    $arr_w[0]=$wt ;
	          }
	          else $arr_w[1]=$wt ; // первое измерение было брутто, в смене был брутто, сейчас получили нетто
	       }
         }
	     ?><h3>arr_w</h3><?
         damp_array($arr_w,1,-1) ;
      }

      $data=array() ;
      if ($arr_w[0]) $data['wt']=$arr_w[0]  ;
      if ($arr_w[1]) $data['wb']=$arr_w[1]  ;
      if ($arr_w[1] and $arr_w[0]) $data['wn']=$arr_w[1]-$arr_w[0]  ;
	  ?><h3>save data:</h3><?
      damp_array($data,1,-1) ;

      update_rec_in_table('car_trip',$data,'pkey='.$trip_id)  ;
      $sum_wn=execSQL_value('select sum(wn) from car_trip where smena_id='.$smena_id.' and wn>0') ;
      $this->smena_update($smena_id,array('wt'=>$arr_w[0],'wn'=>$sum_wn)) ;
	  //$GLOBALS['debug_db']=0 ;
      $text=ob_get_clean() ;
      LOGS()->reg_log('update_trip_weight',$text) ;
    }

	//============================================================================================================================================================================
	//
	// прием карточки сотрудника
	//
	//============================================================================================================================================================================
    //res_2019_04_19_18_26_56__obj_site_persons
	function card_person_received($data,$props)
	{ $id=execSQL_value('select pkey from drivers where uid_1c="'.$data['uid'].'"') ;
	  if ($id) $this->card_person_update($id,$data) ;
	  else     $id=$this->card_person_append($data) ;
	  $this->check_driver_propusk($id,array('send_pass_confirmation'=>1,'correlation_id'=>$props['message_id'])) ;
	}

	function card_person_update($id,$data)
	{ if (!_sizeof($GLOBALS['recs_drivers'])) $GLOBALS['recs_drivers']=execSQL('select * from drivers') ;
	  $rec=$GLOBALS['recs_drivers'][$id] ;
	  $arr_changes=array() ; $data_to_save=array() ;
	  if (isset($data['skd_id']) and $data['skd_id']!=$rec['skd_id']) { $arr_changes['skd_id']=$rec['skd_id'].' => '.$data['skd_id'] ; $data_to_save['skd_id']=$data['skd_id'] ; }
	  if (isset($data['name']) and $data['name']!="" and $data['name']!=$rec['obj_name']) { $arr_changes['ФИО']=$rec['obj_name'].' => '.$data['name'] ; $data_to_save['obj_name']=$data['name'] ; }
	  if (isset($data['dr']) and $data['dr']!=$rec['dr']) { $arr_changes['Дата рождения']=$rec['dr'].' => '.$data['dr'] ; $data_to_save['dr']=$data['dr'] ; }
	  if (isset($data['company']) and $data['company']!=$rec['company']) { $arr_changes['Организация']=$rec['company'].' => '.$data['company'] ; $data_to_save['company']=$data['company'] ; }
	  if (isset($data['department']) and $data['department']!=$rec['department']) { $arr_changes['Подразделение']=$rec['department'].' => '.$data['department'] ; $data_to_save['department']=$data['depоrtment'] ; }
	  if (isset($data['Office']) and $data['Office']!=$rec['Office']) { $arr_changes['Должность']=$rec['Office'].' => '.$data['Office'] ; $data_to_save['workers']=$data['Office'] ; }
	  if (_sizeof($arr_changes))
	  { update_rec_in_table('drivers',$data_to_save,'pkey='.$id) ;
	    unset($arr_changes['skd_id']) ;
        if (_sizeof($arr_changes)) LOGS()->reg_log('driver_change',$data['uid'],array('data'=>$arr_changes,'reffer'=>$rec['_reffer'])) ;
	  }
	}

	function card_person_append($data)
	{ $data_to_save=array() ;  $arr=array() ;
	  $data_to_save['parent']=1 ;
	  $data_to_save['indx']=1 ;
	  $data_to_save['clss']=808 ;
	  $data_to_save['obj_name']=$data['name'] ;
	  //if ($data['name1']) $arr[]=$data['name1'] ;
	  //if ($data['name2']) $arr[]=$data['name2'] ;
	  //if ($data['name3']) $arr[]=$data['name3'] ;
      //if (_sizeof($arr)) $data_to_save['obj_name']=implode(',',$arr) ;
	  $data_to_save['dr']=$data['birthday'] ;
	  $data_to_save['company']=$data['company'] ;
	  $data_to_save['department']=$data['department'] ;
	  $data_to_save['workers']=$data['Office'] ;
	  $data_to_save['uid_1c']=$data['uid'] ;
	  $data_to_save['pol']=($data['pol']=='Женский')? 2:1 ;
	  $data_to_save['skd_id']=($data['skd_id'])? $data['skd_id']:0 ;

	  $id=adding_rec_to_table('drivers',$data_to_save) ;
	  LOGS()->reg_log('driver_append',$data['uid'],array('data'=>$data)) ;
	  return($id) ;
	}

	// проверка наличия постоянного пропуска для субьекта
    // drivers - таблица водителей, переданных из 1с
	function check_driver_propusk($driver_id,$options=array())
    {
       $rec_driver=execSQL_van('select * from drivers where pkey='.$driver_id) ;
       // если водитель еще не связан с посетителем в СКУД - делаем попытку связать их
       if (!$rec_driver['skd_id']) $rec_driver['skd_id']=$this->exec_link_drivers_to_skud_person($rec_driver) ;
       // получаем информацию по пропуску текущего водителя
       if ($rec_driver['skd_id']) $rec_pass=$this->exec_req_to_skud_by_pass_info($rec_driver['skd_id']) ;
       else $rec_pass=array('pass_status'=>'person_unknown') ;
       // отправляем в 1С квитанцию-подтверждение о пропуске сотрудника
       if ($options['send_pass_confirmation']) RABBIT_RUDA()->send_person_pass($rec_driver,$rec_pass,$options) ;

       return($rec_pass) ;
    }

    // ищем в СКУД запись по ФИО+ДР сотрудника, если находим точное соответствие - связыываем
    function exec_link_drivers_to_skud_person($rec_driver)
    {
        $result=0 ;
        $url='/services/pass_tmc_route/link_driver/' ;
        $res=IO()->doPut_v2($GLOBALS['_SETTING']['srv_skd']['protokol'].'://',$GLOBALS['_SETTING']['srv_skd']['host'],$url,'',json_encode($rec_driver),array('log_request'=>1,'cmd'=>'get_pass')) ;
        if ($res['status']==200)
        { $response=json_decode($res['content'],1) ;
          if ($response['skd_id']) $this->card_person_update($rec_driver['pkey'],array('skd_id'=>$response['skd_id'])) ;
          $result=$response['skd_id'];
        }


       return($result) ;
    }

    // ищем в СКУД запись по ФИО+ДР сотрудника, если находим точное соответствие - связыываем
    function exec_link_cars_to_skud_car($rec_car)
    {
        $result=0 ;
        $url='/services/pass_tmc_route/link_car/' ;
        $res=IO()->doPut_v2($GLOBALS['_SETTING']['srv_skd']['protokol'].'://',$GLOBALS['_SETTING']['srv_skd']['host'],$url,'',json_encode($rec_car),array('log_request'=>1,'cmd'=>'get_pass')) ;
        if ($res['status']==200)
        { $response=json_decode($res['content'],1) ;
          if ($response['skd_id']) $this->card_car_update($rec_car['pkey'],array('skd_id'=>$response['skd_id'])) ;
          $result=$response['skd_id'];
        }


       return($result) ;
    }

    function exec_req_to_skud_by_pass_info($person_id)
    {  $rec_person=DB_MYSQL('srv_skd')->execSQL_van('select pkey,obj_name,enabled,black_list from  obj_site_persons where pkey='.$person_id.'') ;
       $rec_pass=DB_MYSQL('srv_skd')->execSQL_van('select pkey as pass_id,type,c_data,enabled,time_from,time_to,status,person_VS_id,person_fio,person_company,person_working from  obj_site_pass_time where person_VS_id='.$person_id.' and status in (3,4)') ;
       if ($rec_pass['pass_id']) $rec_pass['PDP']=DB_MYSQL('srv_skd')->execSQL_line('select zone_id from obj_site_pdp where pass_id='.$rec_pass['pass_id'].' and pass_type='.$rec_pass['type']) ;
       if (!$rec_person['pkey'])                $rec_pass['pass_status']='person_unknown' ;
       elseif ($rec_person['black_list'])       $rec_pass['pass_status']='person_is_blocked' ;
       elseif (!$rec_person['enabled'])         $rec_pass['pass_status']='person_is_blocked' ;
       elseif (!$rec_pass['pass_id'])           $rec_pass['pass_status']='no_pass' ;
       elseif (!$rec_pass['enabled'])           $rec_pass['pass_status']='pass_is_blocked' ;
       elseif ($rec_pass['time_from']>time())   $rec_pass['pass_status']='pass_validity_expired' ;
       elseif ($rec_pass['time_to']<time())     $rec_pass['pass_status']='pass_validity_expired' ;
       else                                     $rec_pass['pass_status']='pass_valid' ;
       return($rec_pass) ;
    }

	//============================================================================================================================================================================
	//
	// прием карточки авто
	//
	//============================================================================================================================================================================

	function card_car_received($data,$props)
	{ $id=execSQL_value('select pkey from obj_site_cars where uid_1c="'.$data['uid'].'"') ;
	  if ($id) $this->card_car_update($id,$data) ;
	  else     $this->card_car_append($data) ;
      $this->check_car_propusk($id,array('send_pass_confirmation'=>1,'correlation_id'=>$props['message_id'])) ;
	}

	function card_car_update($id,$data)
	{ if (!_sizeof($GLOBALS['recs_car'])) $GLOBALS['recs_car']=execSQL('select * from obj_site_cars') ;
      $rec=$GLOBALS['recs_car'][$id] ;
	  $arr_changes=array() ; $data_to_save=array() ;
	  if (isset($data['skd_id']) and $data['skd_id']!=$rec['skd_id']) { $arr_changes['skd_id']=$rec['skd_id'].' => '.$data['skd_id'] ; $data_to_save['skd_id']=$data['skd_id'] ; }
	  if (isset($data['name']) and $data['name']!=$rec['obj_name']) { $arr_changes['ФИО']=$rec['obj_name'].' => '.$data['number'] ; $data_to_save['obj_name']=$data['number'] ; }
	  if (isset($data['model']) and $data['model']!=$rec['model']) { $arr_changes['Дата рождения']=$rec['model'].' => '.$data['model'] ; $data_to_save['model']=$data['model'] ; }
	  if (isset($data['skd_id']) and $data['skd_id']!=$rec['skd_id']) { $arr_changes['skd_id']=$rec['skd_id'].' => '.$data['skd_id'] ; $data_to_save['skd_id']=$data['skd_id'] ; }
	  if (_sizeof($arr_changes))
	  { update_rec_in_table('obj_site_cars',$data_to_save,'pkey='.$id) ;
        unset($arr_changes['skd_id']) ;
        if (_sizeof($arr_changes)) LOGS()->reg_log('car_change',$data['uid'],array('data'=>$arr_changes,'reffer'=>$rec['_reffer'])) ;

	  }
	}

	function card_car_append($data)
	{ $data_to_save=array() ;
	  $data_to_save['obj_name']=str_replace(' ','',$data['number']) ;
	  $data_to_save['model']=$data['model'] ;
	  $data_to_save['uid_1c']=$data['uid'] ;
      $data_to_save['skd_id']=($data['skd_id'])? $data['skd_id']:0 ;

	  $id=adding_rec_to_table('obj_site_cars',$data_to_save) ;
	  LOGS()->reg_log('car_append',$data['uid']) ;
	  return($id) ;
	}

    // проверка наличия постоянного пропуска для субьекта
    // drivers - таблица водителей, переданных из 1с
    function check_car_propusk($car_id,$options=array())
    {
       $rec_car=execSQL_van('select * from obj_site_cars where pkey='.$car_id) ;
       // если водитель еще не связан с посетителем в СКУД - делаем попытку связать их
       if (!$rec_car['skd_id']) $rec_car['skd_id']=$this->exec_link_cars_to_skud_car($rec_car) ;
       // получаем информацию по пропуску текущего водителя
       if ($rec_car['skd_id']) $rec_pass=$this->exec_req_to_skud_by_pass_car_info($rec_car['skd_id']) ;
       else $rec_pass=array('pass_status'=>'car_unknown') ;
       // отправляем в 1С квитанцию-подтверждение о пропуске сотрудника
       if ($options['send_pass_confirmation']) RABBIT_RUDA()->send_car_pass($rec_car,$rec_pass,$options) ;

       return($rec_pass) ;
    }

    // ищем в СКУД запись по ФИО+ДР сотрудника, если находим точное соответствие - связыываем
    function exec_link_car_to_skud_car($rec_car)
    {
       return(0) ;
    }

    function exec_req_to_skud_by_pass_car_info($car_id)
    {  $rec_car=DB_MYSQL('srv_skd')->execSQL_van('select pkey,obj_name,enabled from  obj_site_cars where pkey='.$car_id.'') ;
       $rec_pass=DB_MYSQL('srv_skd')->execSQL_van('select pkey as pass_id,type,c_data,enabled,time_from,time_to,status,person_VS_id,person_fio,person_company,person_working from  obj_site_pass_time where car_id='.$car_id.' and status in (3,4)') ;
       if ($rec_pass['pass_id']) $rec_pass['PDP']=DB_MYSQL('srv_skd')->execSQL_line('select zone_id from obj_site_pdp where pass_id='.$rec_pass['pass_id'].' and pass_type='.$rec_pass['type']) ;
       if (!$rec_car['pkey'])                $rec_pass['pass_status']='car_unknown' ;
       //elseif ($rec_car['black_list'])       $rec_pass['pass_status']='car_is_blocked' ;
       elseif (!$rec_car['enabled'])         $rec_pass['pass_status']='car_is_blocked' ;
       elseif (!$rec_pass['pass_id'])           $rec_pass['pass_status']='no_pass' ;
       elseif (!$rec_pass['enabled'])           $rec_pass['pass_status']='pass_is_blocked' ;
       elseif ($rec_pass['time_from']>time())   $rec_pass['pass_status']='pass_validity_expired' ;
       elseif ($rec_pass['time_to']<time())     $rec_pass['pass_status']='pass_validity_expired' ;
       else                                     $rec_pass['pass_status']='pass_valid' ;
       return($rec_pass) ;
    }




	//============================================================================================================================================================================
	//
	// прием карточки задачи
	//
	//============================================================================================================================================================================

    function get_task_by_uid($id,$options=array())
   	{
   		$rec_task=execSQL_van('select * from ruda_task where task_uid='.$id) ;
        //if ($rec_trip['pkey']) $this->prepare_public_info_to_trip($rec_trip,$options) ;
   		return($rec_task) ;
   	}

    function get_task_by_id($id,$options=array())
   	{
   		$rec_task=execSQL_van('select * from view_task where pkey='.$id) ;
        if ($rec_task['pkey']) $this->prepare_public_info_to_task($rec_task,$options) ;
   		return($rec_task) ;
   	}

   	function prepare_public_info_to_task(&$rec,$options=array())
    {
        $rec['__href']='/window/esmo_ruda/task_card/'.$rec['pkey'].'/' ;
    }


	function card_task_received($data)
	{ $id=execSQL_value('select pkey from ruda_task where task_uid="'.$data['task_id'].'"') ;
	  if ($id) $this->card_task_update($id,$data) ;
	  else $this->card_task_append($data) ;
	}

	function card_task_update($id,$data)
	{ $rec=execSQL_van('select * from ruda_task where pkey="'.$id.'"') ;
	  $arr_changes=array() ; $data_to_save=array() ;
      if (isset($data['status_code_line'])) $data['status_code_line']=trim($data['status_code_line']) ;
      if (isset($data['status_code_line']) and $data['status_code_line']!=$rec['status_code_line']) { $arr_changes['Статус']=$rec['status_code_line'].' => '.$data['status_code_line'] ; $data_to_save['status_code_line']=$data['status_code_line'] ; $data_to_save['status']=($data['status_code_line']=='OPEN')? 1:2 ;}
	  if (isset($data['invoice_id']) and $data['invoice_id']!=$rec['invoice_id']) { $arr_changes['Номер накладной']=$rec['invoice_id'].' => '.$data['invoice_id'] ; $data_to_save['invoice_id']=$data['invoice_id'] ; }
	  if (isset($data['route_id']) and $data['route_id']!=$rec['route_id']) { $arr_changes['ID маршрута']=$rec['route_id'].' => '.$data['route_id'] ; $data_to_save['route_id']=$data['route_id'] ; }
	  if (isset($data['value']) and $data['value']!=$rec['value']) { $arr_changes['Объем перевозки']=$rec['value'].' => '.$data['value'] ; $data_to_save['value']=$data['value'] ; }
	  if (isset($data['header_id']) and $data['header_id']!=$rec['header_id']) { $arr_changes['header_id']=$rec['header_id'].' => '.$data['header_id'] ; $data_to_save['header_id']=$data['header_id'] ; }
	  if (isset($data['line_id']) and $data['line_id']!=$rec['line_id']) { $arr_changes['line_id']=$rec['line_id'].' => '.$data['line_id'] ; $data_to_save['line_id']=$data['line_id'] ; }
	  if (isset($data['ver_ord']) and $data['ver_ord']!=$rec['ver_ord']) { $arr_changes['ver_ord']=$rec['ver_ord'].' => '.$data['ver_ord'] ; $data_to_save['ver_ord']=$data['ver_ord'] ; }
	  if (isset($data['order_number']) and $data['order_number']!=$rec['order_number']) { $arr_changes['order_number']=$rec['order_number'].' => '.$data['order_number'] ; $data_to_save['order_number']=$data['order_number'] ; }
	  // $rec['time_from'], $rec['time_to'] - unixtime
      // $data['data_from'], $data['data_to'] - 10.08.2019
	  $time_from=strtotime($data['data_from']) ;
	  $time_to=strtotime($data['data_to']) ;
	  if (isset($data['data_from']) and $time_from!=$rec['time_from']) { $arr_changes['Срок действия, от']=date('d.m.Y H:i',$rec['time_from']).' => '.date('d.m.Y H:i',$time_from) ; $data_to_save['time_from']=$time_from ; }
	  if (isset($data['data_to']) and $time_to!=$rec['time_to'])     { $arr_changes['Срок действия, до']=date('d.m.Y H:i',$rec['time_to']).' => '.date('d.m.Y H:i',$time_to) ; $data_to_save['time_to']=$time_to ; }
	  if (_sizeof($arr_changes))
	  { update_rec_in_table('ruda_task',$data_to_save,'pkey='.$id) ;
	    LOGS()->reg_log('task_change',$id,array('data'=>$arr_changes,'reffer'=>$rec['_reffer'])) ;
	  }
	  if (_sizeof($arr_changes))
      { echo 'Обновлена задача '.$data['task_id'].'<br>' ;
	    damp_array($arr_changes,1,-1) ;
      }
	  else   echo 'Задача '.$data['task_id'].' - измений не обнаружено' ;
	}

	function card_task_append($data)
	{ $data_to_save=array() ;
	  $data_to_save['clss']=801 ;
	  $data_to_save['task_uid']=$data['task_id'] ;
	  $data_to_save['invoice_id']=$data['invoice_id'] ;
	  $data_to_save['route_id']=$data['route_id'] ;
	  $data_to_save['time_from']=strtotime($data['data_from']) ;
	  $data_to_save['time_to']=strtotime($data['data_to']) ;
	  $data_to_save['value']=$data['value'] ;
      $data_to_save['header_id']=$data['header_id'] ;
      $data_to_save['line_id']=$data['line_id'] ;
      $data_to_save['status_code_line']=$data['status_code_line'] ;
      $data_to_save['status']=($data['status_code_line']=='OPEN')? 1:2 ;
      $data_to_save['ver_ord']=$data['ver_ord'] ;
      $data_to_save['order_number']=$data['order_number'] ;

	  //damp_array($data_to_save,1,-1) ;

	  $reffer=adding_rec_to_table('ruda_task',$data_to_save,array('return_reffer'=>1)) ;
	  LOGS()->reg_log('task_append',$data['task_id'],array('reffer'=>$reffer)) ;
	  echo 'Добавлена задача '.$data['task_id'].'<br>' ;
	}

	//============================================================================================================================================================================
	//
	// прием карточки заявки
	//
	//============================================================================================================================================================================

 	function get_request_by_id($id,$options=array())
 	{ $rec=execSQL_van('select * from ruda_request where pkey='.$id) ;
 	  if ($rec['pkey']) $this->prepare_public_info_to_request($rec,$options) ;
 	  return($rec) ;
 	}

 	function prepare_public_info_to_request(&$rec,$options=array())
 	{  $rec['__href']='/window/esmo_ruda/task_card/'.$rec['task_id'].'/request/'.$rec['pkey'].'/' ;
 	   if ($options['get_recs'])
 	   {  $rec['recs']=execSQL('select t1.pkey,t1.obj_name,t1.person_id,t1.car_id,t1.time_from,t1.time_to,t1.url_pdf_doc,t1.pass_id,t1.status,t1.comment,
                                t2.obj_name as person_name,t2.uid_1c as person_uid_1c,t2.skd_id as person_skd_id,
                                t3.obj_name as car_number,t3.model as car_model,t3.uid_1c as car_uid_1c,t3.skd_id as car_skd_id
 								from ruda_request_recs t1 
 								left join drivers t2 on t2.pkey=t1.person_id 
 								left join obj_site_cars t3 on t3.pkey=t1.car_id 
 								where t1.parent='.$rec['pkey'].' order by t1.indx') ;
 	   }
 	}

	function card_request_received($data)
	{ $result=array() ;
	  $id=execSQL_value('select pkey from ruda_request where request_id="'.$data['request_id'].'"') ;
	  if ($id) $result=$this->card_request_update($id,$data) ;
	  else $result['req_id']=$this->card_request_append($data) ;
	  return($result) ;
	}

	function card_request_update($id,$data)
	{ $result=array() ;
	  $rec=execSQL_van('select * from ruda_request where request_id="'.$data['request_id'].'"') ;
	  $arr_changes=array() ; $data_to_save=array() ;
	  $arr_name=explode('от',$data['request_name']) ;
	  $request_name=trim(str_replace('Заявка','',$arr_name[0])) ;
	  // задача не может быть изменена
	  //if (isset($data['task_id']) and $data['task_id']!=$rec['task_id_id']) { $arr_changes['ID задачи']=$rec['task_id'].' => '.$data['task_id'] ; $data_to_save['task_id']=$data['task_id'] ; }
	  if (isset($data['url_pdf_doc']) and $data['url_pdf_doc']!=$rec['url_pdf_doc']) { $arr_changes['URL пропусков']=$rec['url_pdf_doc'].' => '.$data['url_pdf_doc'] ; $data_to_save['url_pdf_doc']=$data['url_pdf_doc'] ; }
	  if ($request_name!=$rec['obj_name']) { $arr_changes['Наименование заявки']=$rec['obj_name'].' => '.$request_name ; $data_to_save['obj_name']=$request_name ; }
	  if (_sizeof($arr_changes))
	  { update_rec_in_table('ruda_request',$data_to_save,'pkey='.$id) ;
	    LOGS()->reg_log('request_change',$data['uid'],array('data'=>$arr_changes)) ;
		//echo 'Обновлена заявка '.$data['request_id'].'<br>' ;
        $result['status']='success' ;
	  }
      return($result) ;
	}

	function card_request_append($data,$options=array())
	{ $id=0 ;
	  $task_id=trim(str_replace(' ','',$data['task_id'])) ;
      $arr_name=explode('от',$data['request_name']) ;
      $request_name=trim(str_replace('Заявка','',$arr_name[0])) ;
	  $rec_task=$this->get_task_by_uid($task_id) ;
	  if ($rec_task['pkey'])
      {   $data_to_save=array() ;
          $data_to_save['clss']=801 ;
          $data_to_save['obj_name']=$request_name ;
          $data_to_save['request_id']=$data['request_id'] ;
          $data_to_save['task_id']=$rec_task['pkey'] ;
          $data_to_save['line_id']=$data['line_id'] ;
          $data_to_save['time_from']=strtotime($data['data_from']) ;
          $data_to_save['time_to']=strtotime($data['data_to']) ;
          if ($options['account_id']) $data_to_save['account_id']=$options['account_id'] ;
          //damp_array($data_to_save,1,-1) ;
          $id=adding_rec_to_table('ruda_request',$data_to_save) ;
          //LOGS()->reg_log('request_append',$data['uid']) ;
          echo 'Добавлена заявка '.$data['request_id'].'<br>' ;
      }
	  else echo '<div class="red">Передан несуществущий ID задания: '.$data['task_id'].'</div>' ;
	  return($id) ;
	}

	//============================================================================================================================================================================
	//
	// прием позиции карточки заявки
	//
	//============================================================================================================================================================================

	// предусмотреть возможность удаления позиций заявки!
	// редактирования позиции не предусмотрен
	function request_content_received($data,$props)
	{ if ($data['remove']) $result=$this->request_content_remove($data) ;
	  else $result=$this->request_content_append($data,$props) ;
	  return($result) ;
	}

	function request_content_remove($data)
	{ $rec_req=execSQL_van('select * from ruda_request where request_id="'.$data['request_id'].'"') ;
	  $rec_person=execSQL_van('select * from drivers where uid_1c="'.$data['uid_person'].'"') ;
	  $rec_car=execSQL_van('select * from obj_site_cars where uid_1c="'.$data['uid'].'"') ;
	  if ($rec_req['pkey'] and $rec_person['pkey'] and $rec_car['pkey'])
	  {  $cnt=execSQL_update('delete from ruda_request_recs where parent='.$rec_req['pkey'].' and person_id='.$rec_person['pkey'].' and car_id='.$rec_car['pkey']) ;
	     if ($cnt) $result['status']='remove_success'  ;
	     else      $result['status']='not_found'  ;
	  }
	  else $result['status']='not_found'  ;
	  LOGS()->reg_log('request_content_remove','',array('data'=>$result)) ;
	  return($result) ;
	}

	// добавлени позиции заявки
    // !!! проверка на валидность временных пропусков водителя и авто производиться на стороне СКУД, непосредственно перед созданием маршрутного листа
    // эта логика перенесена в СКУД, чтобы не было возможности создать МЛ при некорректных исходных данных
	function request_content_append($data,$props)
	{ //ob_start() ;
	  /*$id=execSQL_value('select pkey from ruda_request where request_id="'.$data['request_id'].'"') ;
	  // если первая строка новой заявки - создаем новую заявку. Но по логике заявка уже будет создана
	  if (!$id) $id=$this->card_request_append($data) ;*/
      $result=array() ;
      $result['correlation_id']=($props['message_id'])? $props['message_id']:0 ;
      $result['request_id']=$data['request_id'] ;
      $result['line_id']=$data['line_id'] ;
	  $rec_req=execSQL_van('select * from ruda_request where request_id="'.$data['request_id'].'"') ;
      $request_id=($rec_req['pkey'])? $rec_req['pkey']:0 ;
      $rec_person=execSQL_van('select * from drivers where uid_1c="'.$data['person_id'].'"') ;
      $rec_car=execSQL_van('select * from obj_site_cars where uid_1c="'.$data['car_id'].'"') ;
      $task_id=trim(str_replace(' ','',$data['task_id'])) ;
      $rec_task=$this->get_task_by_uid($task_id) ;
      if (!$data['task_id'] or !$rec_task['pkey'])
      {   $result['status']='failed' ;
          $result['comment']='task_id_not_found' ;
          echo '<div class="red">Задача '.$data['task_id'].' не найдена - добавление позиции заблокировано</div>' ;
      }
      if (!$request_id)
      {   $result['status']='failed' ;
          $result['comment']='request_unknown' ;
          echo '<div class="red">Заявка '.$data['request_id'].' не найдена - добавление позиции заблокировано</div>' ;
      }
      if (!$rec_person['pkey'])
      {   $result['status']='failed' ;
          $result['comment']='person_unknown' ;
          echo '<div class="red">Водитель '.$data['person_id'].' не найден - добавление позиции заблокировано</div>' ;
      }
      if (!$rec_car['pkey'])
      {   $result['status']='failed' ;
          $result['comment']='car_unknown' ;
          echo '<div class="red">Автомобиль '.$data['car_id'].' не найден - добавление позиции заблокировано</div>' ;
      }
	  if (!$result['status'] and $request_id>0 and $rec_person['pkey']>0 and $rec_car['pkey']>0)
      {   // позиция будет добавлена в базу, если это не повтор
          $line_id=execSQL_value('select pkey from ruda_request_recs where parent='.$request_id.' and car_id='.$rec_car['pkey'].' and person_id='.$rec_person['pkey']) ;
          if (!$line_id)
          { $data_to_save=array() ;
            $data_to_save['obj_name']=$data['request_name'] ;
            $data_to_save['parent']=$request_id ;
            $data_to_save['clss']=802 ;
            $data_to_save['task_id']=$rec_task['pkey'] ;
            $data_to_save['request_uid']=$data['request_id'] ;
            $data_to_save['person_id']=$rec_person['pkey'] ;
            $data_to_save['car_id']=$rec_car['pkey'] ;
            $data_to_save['line_id']=$data['line_id'] ;
            $data_to_save['time_from']=strtotime($data['data_from']) ;
            $data_to_save['time_to']=strtotime($data['data_to']) ;
            //damp_array($data_to_save,1,-1) ;
            //echo date('d.m.Y H:i:s',$data_to_save['time_from']).'<br>' ;
            //echo date('d.m.Y H:i:s',$data_to_save['time_to']).'<br>' ;
            $line_id=adding_rec_to_table('ruda_request_recs',$data_to_save) ;
            //LOGS()->reg_log('request_content_append',$data['uid']) ;
          }

          // делаем запрос на сервер СКД для создания пропуска
          $json_str='' ; //json_encode(array('request_id'=>))
          $res=IO()->doPut_v2($GLOBALS['_SETTING']['srv_skd']['protokol'].'://',$GLOBALS['_SETTING']['srv_skd']['host'],'/services/pass_tmc_route/ml/[request_id='.$request_id.',line_id='.$line_id.']/','',$json_str,array('log_request'=>1,'cmd'=>'create_pass_tmc_route')) ;
          if ($res['status']==200)
          { $result_req=json_decode($res['content'],1) ;
            $result['status']=$result_req['status'] ;
            $result['url_pdf_doc']=$result_req['doc_file_path'] ;
            $result['pass_id']=(isset($result_req['pass_id']))?  $result_req['pass_id']:$result_req['pass_ids'][0];
            $result['pass_name']=$result_req['pass_name'] ;
            $result['person_name']=$rec_person['obj_name'] ;
            $result['person_id']=$rec_person['uid_1c'] ;
            $result['car_number']=$rec_car['obj_name'] ;
            $result['car_id']=$rec_car['uid_1c'] ;
            $result['comment']=$result_req['comment'] ;
            //damp_array($res) ;
          }
          else
          {
              $result['status']='failed' ;
              $result['comment']='server_not_available' ;
          }
          update_rec_in_table('ruda_request_recs',array('url_pdf_doc'=>$result['url_pdf_doc'],
                                                        'pass_id'=>$result['pass_id'],
                                                        'status'=>$result['status'],
                                                        'comment'=>$result['comment']
                                                        ),'pkey='.$line_id) ;

          //damp_array($result,1,-1) ;
          // отправляем пакет в 1С с подтверждением приема позиции заявки и URL на PDF маршрутного листа
          // отправляем в 1С квитанцию-подтверждение о пропуске сотрудника

      }
      if ($result['correlation_id'])  RABBIT_RUDA()->send_card_request_line_receipt($result) ;
      //$text=ob_get_clean() ;
      //LOGS()->reg_log('request_content_append',$text) ;
      return($result) ;
	}

    //============================================================================================================================================================================
   	//
   	// отработка событий с терминала
   	//
   	//============================================================================================================================================================================

    // формирование HTML, которое потом будет сохранено как карточка события
    // пока карточки сохраняются в БД, возвращаем руезультат
    // как только будет на терминалах режим HTML - переделать в прямое сохранение HTML файла
    function get_event_card($group_id,$gate_event_id,$access=array(),$terminal_type=0,$options=array())
    {  ob_start() ;
        $rec_event=array() ;
       //$rec_event=$this->get_gate_event_by_id($gate_event_id) ;
       if ($options['use_template']) $template_name=$options['use_template'] ;
       /*else switch($rec_event['pass_type'])
       { case 1:
         case 2:
         case 3:  $template_name='event_card_person' ;break ;
         case 4:
         case 5:
         case 6:  $template_name='event_card_car' ; break ;
         default: $template_name='event_card' ;
       }     */
        $template_name='' ;
       // для устройств "Шлагбаум" надо отдавать HTML страницу со стилями а не блок
       $mode=($terminal_type==3)? 'HTML':'panel';
       // подключаем шаблон и выводим его
        //include_once(_DIR_EXT.'/tracking/'.$mode.'_'.$template_name.'.php') ;
        include_once(_DIR_EXT.'/tracking/HTML_event_card.php') ;
        //$func_name=$mode.'_'.$template_name ;
        HTML_event_card($rec_event,$access) ;

        $html_event_card=ob_get_clean() ;
        //$event_fname='evt_'.$group_id.'_'.$gate_event_id.'.html' ;
        //$cnt=file_put_contents(_TEMP_DIR.'monitor/'.$event_fname,$html_event_card) ;

        return($html_event_card) ;
    }

    function log_weight($data)
      {
      	 $id=adding_rec_to_table('log_weight',$data) ;
      	 return($id) ;
      }

     // оправка запроса на весы на основании пропуска
    function send_req_to_weigher($IP,$url,$ves_options,$point_id,$rec_pass,$process_uid)
    { $result=array() ;
      // фиксируем прохождение точки маршрута - весовая
      //if ($rec_pass['type']==14)
      { $rec_rabbit=array('type'=>'trip_point',
                        'device'=>array('point_id'=>$point_id,'zone_id'=>$point_id,
                       ),
                       'access_type'=>0,
                       'session'=>array('tmc_pass_id'=>$rec_pass['pkey'],
                                          'driver_id'=>$rec_pass['_driver']['pkey'],
                                          'car_id'=>$rec_pass['_car']['pkey'],
                                          'driver_name'=>$rec_pass['_driver']['obj_name'],
                                          'car_name'=>$rec_pass['_car']['obj_name'],
                                          'weight'=>0,
                                          'now'=>date('d.m.Y H:i:s')
                                          ),
                         'PDP'=>$rec_pass['PDP']
                         );

       LOG_JSON('check_access')->reg('Точка маршрута','Весовая, отправка пакета на trip_point_received',array('data'=>$rec_rabbit)) ;
       $rec_trip_point=$this->trip_point_received($rec_rabbit) ;
       LOG_JSON('check_access')->reg('Точка маршрута','Весовая, получена запись по точке маршрута',array('data'=>$rec_trip_point)) ;

      }

      list($from,$to)=get_route_from_to($rec_trip_point['route_id']) ;

      if (!$rec_trip_point['trip_point_pkey']) $rec_trip_point['trip_point_pkey']=1 ;
      if (!$rec_trip_point['trip_id']) $rec_trip_point['trip_id']=1 ;

      $req_data=array() ;
      if ($rec_trip_point['trip_point_pkey']) $req_data['id_request']=$rec_trip_point['trip_point_pkey'] ;
      if ($rec_trip_point['trip_id'])
      { $req_data['id_trip']=$rec_trip_point['trip_id'];
        $req_data['trip_number']=execSQL_value('select num from car_trip where pkey='.$rec_trip_point['trip_id']) ;
      }
      $req_data['driver_name']=$rec_pass['_driver']['obj_name'] ;
      $req_data['driver_org']=$rec_pass['_driver']['company'] ;
      $req_data['driver_work']=$rec_pass['_driver']['working'] ;
      $req_data['car_number']=str_replace(' ','',$rec_pass['_car']['obj_name']) ;
      $req_data['car_model']=$rec_pass['_car']['model'] ;
      $req_data['car_owner']=$rec_pass['_car']['_owner_name'] ;
      $req_data['cargo_type']='Руда' ;  // далее из маршрута
      $req_data['doc_num']=$rec_pass['_docs'] ;
      $req_data['path_from']=$from ;
      $req_data['path_to']=$to ;
      $req_data['server_date']=date('d.m.Y H:i') ;

      LOG_JSON('check_access')->reg('Запрос взвешивания','Подготовлен пакет',array('data'=>$req_data)) ;


      if ($ves_options['JSON_UNESCAPED_UNICODE']) $json_str=json_encode($req_data,JSON_UNESCAPED_UNICODE) ;
      else                                        $json_str=json_encode($req_data) ;

      // отправляем запрос на взвешивание
      //switch($IP)
      //{ case '10.203.13.46:8080':  $url='/ARM/weighing' ; break ;
      //  default:  $url='/services/set_weighting' ; break ;
      //}
      $ves_options['log_request']=1 ;
      $ves_options['cmd']='set_weighting' ;
      //$result=IO()->doPut_v2('http://',$IP,$url,'',$json_str,array('log_request'=>1,'cmd'=>'set_weighting','_content_type'=>'json')) ;
      $result=IO()->doPut_v2('http://',$IP,$url,'',$json_str,$ves_options) ;
      LOG_JSON('check_access')->reg('Запрос взвешивания','Результат запроса',array('data'=>$result)) ;

      if ($result['status']==200)
      {
          $data=json_decode($result['content'],1) ;
          LOG_JSON('check_access')->reg('Запрос взвешивания','Расширован ответ',array('data'=>$data)) ;
          update_rec_in_table('car_trip_recs',array('comment'=>$data['status']),'pkey='.$rec_trip_point['trip_point_pkey']) ;
          $status=strtolower($data['status']) ;
          if ($status=='inwork' or $status=='inWork')
          {  // запускаем асинхронный процесс взвештвания
              $url=_MAIN_PROTOCOL._MAIN_DOMAIN.'/services/esmo_gateway_weigher/get_weight/[ip='.$IP.',point_id='.$req_data['id_request'].',process_uid='.$process_uid.']/' ; //echo $url ;
              exec('bash -c "/usr/bin/wget -O /dev/null --no-check-certificate \"'.$url.'\" > /dev/null 2>&1 &"',$output);
              $result['status']='success' ;
              LOG_JSON('check_access')->reg('Запрос взвешивания','Запуск асинхронного процесса взвешивания в фоне: '.$url) ;
          }
          else
          {  // надо удалить точку маршрута, взвешивания не будет
             $result['status']='busy' ;
          }
      }
      else update_rec_in_table('car_trip_recs',array('comment'=>'Ошибка ответа АРМ весовой: '.$result['status']),'pkey='.$rec_trip_point['trip_point_pkey']) ;

      $result=array_merge($result,$rec_trip_point) ;
      return($result) ;
    }

    function format_tonn($value)
    {   $value=$value/1000 ;
        $text=($value)? '<span class="weight_value">'.number_format($value, 2, '.', ' ').'</span> т.':'' ;
        return $text ;

    }


    function request_card($data)
    {  $result=array() ;
       return($result);

    }

    function get_last_tara_by_request($trip_point_id)
    {   $w=0 ;
        $rec_trip_point=execSQL_van('select * from car_trip_recs where pkey='.$trip_point_id) ;
        $rec_trip=execSQL_van('select * from car_trip where pkey='.$rec_trip_point['parent']) ;
        if ($rec_trip['wt']>0) { $w=$rec_trip['wt'] ; echo '<strong>Вес тары получен из текущего рейса</strong><br>' ; }
        else if ($rec_trip['num']>1)
        {   $rec_trip=execSQL_van('select * from car_trip where smena_id='.$rec_trip['smena_id'].' and num='.($rec_trip['num']-1)) ;
            if ($rec_trip['wt']>0) { $w=$rec_trip['wt'] ; echo '<strong>Вес тары получен из прошлого рейса</strong><br>' ; }
            else
            {  $rec_smena=execSQL_van('select * from car_smena where pkey='.$rec_trip['smena_id'].'') ;
               if ($rec_smena['wt']>0) { $w=$rec_smena['wt'] ; echo '<strong>Вес тары получен из смены рейса</strong><br>' ; }
            }
        }
        return($w) ;
    }


    // проверка задач на выполенние 80%
    function send_notife_email_check_task()
        {  if (!$GLOBALS['LS_esmo_ruda_task_check_value'] or !$GLOBALS['LS_esmo_ruda_task_check_email']) return ;
           $recs_task=execSQL('select t1.*,
                               (select sum(wn)/1000 from car_smena where task_id=t1.pkey) as task_wn,
                               (select sum(wn)/(t1.value*10) from car_smena where task_id=t1.pkey) as task_proc
                               from ruda_task t1 
                               where status_code_line="OPEN"
                               having  task_proc>='.$GLOBALS['LS_esmo_ruda_task_check_value'].'
                             ') ;
           if (_sizeof($recs_task)) foreach($recs_task as $rec_task)
           {
              ob_start()
               ?>Задача <strong><?echo $rec_task['header_id']?></strong>, накладная <strong><?echo $rec_task['invoice_id']?></strong> выполнена на <strong><?echo round($rec_task['task_proc'])?> %</strong>
                <strong>Данные задачи:</strong><br>
                <table class="basic">
                    <tr><td>Накладная</td><td><?echo $rec_task['invoice_id']?></td></tr>
                    <tr><td>Срок задачи, от</td><td><?echo date('d.m.Y',$rec_task['time_from'])?></td></tr>
                    <tr><td>Срок задачи, до</td><td><?echo date('d.m.Y',$rec_task['time_to'])?></td></tr>
                    <tr><td>План перевозки</td><td><?echo $rec_task['value']?></td></tr>
                    <tr><td>Факт перевозки</td><td><?echo $rec_task['task_wn']?></td></tr>
                    <tr><td>%  закрытия задачт</td><td><?echo round($rec_task['task_proc'])?></td></tr>
                </table>
               <?
              $text=ob_get_clean() ;

              MAILS()->send_mail($GLOBALS['LS_esmo_ruda_task_check_email'],'Задача почти выполнена',$text) ;

              LOGS()->reg_log('email','Отправка email по выполению задачи',array()) ;
           }

        }



}



?>
