<?
include_once(_DIR_TO_ENGINE.'/c_system.php') ;
function RABBIT_RUDA() { if (!isset($GLOBALS['RABBIT_RUDA'])) $GLOBALS['RABBIT_RUDA']=new i_rabbit_ruda() ; return($GLOBALS['RABBIT_RUDA']); } ;

include(_DIR_EXT.'/rabbit/i_rabbit.php') ;
class i_rabbit_ruda extends SimpleReceiver
{
	// карта соответствий типа пакета и обмена/ключа маршрутизации при отправке в Rabbit
	var $map=array('route_point'=>'esmo.in/esmo.route_point', // точки маршрутов
				   'card_route'=>'esmo.in/esmo.card_route', // маршрут
				   'card_access_area'=>'esmo.in/esmo.card_access_area', // зоны доступа СКД
				   'card_person_pass'=>'esmo.in/esmo.card_car_pass', // пропуск сотрудника
				   'card_car_pass'=>'esmo.in/esmo.card_car_pass', // пропуск сотрудника
				   'card_request_line_receipt'=>'esmo.in/esmo.card_request_line_receipt', // подтверждение позиции заявки
				   'card_trip'=>'esmo.in/esmo.card_trip', // отправка карточки рейса
				   'card_trip_confirmed'=>'esmo.in/esmo.card_trip_confirmed', // отправка карточки рейса
				  ) ;

	// вызывается через планировщик - чтение очередей Rabbit
	function rabbit_kanal_read()
    {  $arr=array() ;
       $results['esmo.out.trip_points']=$this->read('rudaesmo','esmo.out.trip_points') ;   // СКД - точки проезда
       $results['esmo.out.card_tasks']=$this->read('rudaesmo','esmo.out.card_tasks') ;    //  задача
       $results['esmo.out.card_persons']=$this->read('rudaesmo','esmo.out.card_persons') ;  // сотрудники
       $results['esmo.out.card_car']=$this->read('rudaesmo','esmo.out.card_cars') ;     // автомобили
       $results['esmo.out.card_request_lines']=$this->read('rudaesmo','esmo.out.card_request_lines') ; // позиции заявок

       foreach($results as $type=>$res) if (_sizeof($res['mess'])) $arr[]=$type.': '._sizeof($res['mess']) ;

       //LOGS()->reg_log('rabbit_kanal_read',implode('<br>',$arr)) ;

       return($arr) ;
    }


	function send_to_quele($type,$data,$options=array())
	{   if (!$options['test']) list($exchange,$routing)=explode('/',$this->map[$type]) ;
	    else                   list($exchange,$routing)=explode('/',$GLOBALS['_SETTING']['rabbit']['test_queue']['out']) ;
	    $props=array('type'=>$type) ;
	    $vhost=$GLOBALS['_SETTING']['rabbit']['vhost'] ;
	    if (!$exchange) echo 'Не указан exchange для типа "'.$type.'"<br>' ;
	    else if (!$routing) echo 'Не указан routekey для типа "'.$type.'"<br>' ;
	    else $this->execute2($vhost,$exchange,$routing,$props,$data,$options) ;
	}

	// отправляем структуру СКД
	function send_skd_structure($options=array())
	 {  $list_zones=TREE('obj_site_skd')->get_list_strukture('clss in (600)') ;
	    foreach($list_zones as $id=>$name)
	    {
	        $data=array('zone_id'=>(int)$id,
	                    'zone_name'=>$name,
	                    'remove'=>(int)0
	                    ) ;

		    $this->send_to_quele('card_access_area',$data,$options) ;
	    }
	 }

	 // оправляем все точки маршрутов
	 function send_routes_points($options=array())
	 {
		$recs=execSQL('select distinct(t1.point_id),t1.obj_name,t2.parent as zone_id from car_routers_points t1 left join obj_site_skd t2 on t2.pkey=t1.point_id  order by t1.obj_name;') ;

		if (_sizeof($recs)) foreach($recs as $rec)
	    {
	        $data=array('point_id'=>(int)$rec['point_id'],
	                    'zone_id'=>(int)$rec['zone_id'],
	                    'point_name'=>$rec['obj_name'],
	                    'remove'=>(int)0
	                    ) ;

            $this->send_to_quele('route_point',$data,$options) ;
	    }
	 }

	 // отправляем маршрут
	 function send_route($route_id,$options=array())
	 {
		 $rec_route=ESMO_RUDA()->get_route_by_id($route_id,array('get_points_id'=>1,'type'=>1)) ;
	     if (!$rec_route['pkey']) return ;

	     $data=array('route_id'=>(int)$rec_route['pkey'],
	                 'route_name'=>$rec_route['obj_name'],
	                 'remove'=>(int)0
	                ) ;
	     foreach($rec_route['points'][1] as $id=>$point_id)   $data['trips'][(int)$id]=(int)$point_id ;

		 $this->send_to_quele('card_route',$data,$options) ;
	 }

	 // отправляем пропуск сотрудника
	 function send_person_pass($rec_driver,$rec_pass,$options=array())
	 {
	     $data=array('pass_id'=>(int)$rec_pass['pass_id'],
	                 'pass_status'=>$rec_pass['pass_status'],
	                 'person_uid'=>$rec_driver['uid_1c'],
	                 'person_id'=>(int)$rec_pass['person_VS_id'],
	                 'data_from'=>date('d.m.Y H:i:s',$rec_pass['time_from']),
	                 'data_to'=>date('d.m.Y H:i:s',$rec_pass['time_to']),
	                 'zones'=>$rec_pass['PDP'],
	                ) ;
	     if (isset($options['correlation_id'])) $data['correlation_id']=$options['correlation_id'] ;

	     switch($data['pass_status'])
	     { case 'pass_valid': $data['pass_status_text']='пропуск активен' ; break ;
		   case 'pass_validity_expired': $data['pass_status_text']='пропуск недействителен по срок действия' ; break ;
		   case 'pass_is_blocked': $data['pass_status_text']='пропуск заблокирован' ; break ;
		   case 'no_pass': $data['pass_status_text']='пропуск не найден' ; break ;
		   case 'person_unknown': $data['pass_status_text']='сотрудник не найден' ; break ;
		   case 'person_is_blocked': $data['pass_status_text']='сотрудник заблокирован' ; break ;
		   default:   $data['pass_status_text']=$data['pass_status'] ;
	     }

		 $this->send_to_quele('card_person_pass',$data,$options) ;
	 }

	 // отправляем пропуск авто
	 function send_car_pass($rec_car,$rec_pass,$options=array())
	 {
	     $data=array('pass_id'=>(int)$rec_pass['pass_id'],
	                 'pass_status'=>$rec_pass['pass_status'],
	                 'car_uid'=>$rec_car['uid_1c'],
	                 'car_id'=>(int)$rec_pass['car_id'],
	                 'data_from'=>date('d.m.Y H:i:s',$rec_pass['time_from']),
	                 'data_to'=>date('d.m.Y H:i:s',$rec_pass['time_to']),
	                 'zones'=>$rec_pass['PDP'],
	                ) ;
	     if (isset($options['correlation_id'])) $data['correlation_id']=$options['correlation_id'] ;

		 $this->send_to_quele('card_car_pass',$data,$options) ;
	 }

	 // отправляем подтверждение приема заявки
	 function send_card_request_line_receipt($result,$options=array())
	 {
	     $data=array('correlation_id'=>$result['correlation_id'],
	                 'status'=>$result['status'],
	                 'comment'=>$result['comment'],
	                 'request_id'=>$result['request_id'],
	                 'line_id'=>(int)$result['line_id'],
	                 'url_pdf_doc'=>$result['url_pdf_doc'],
	                 'pass_id'=>(int)$result['pass_id'],
	                 'pass_name'=>$result['pass_name'],
	                 'person_name'=>$result['person_name'],
	                 'person_id'=>$result['person_id'],
	                 'car_number'=>$result['car_number'],
	                 'car_id'=>$result['car_id']
	                ) ;

		 $this->send_to_quele('card_request_line_receipt',$data,$options) ;
	 }

	// отправка данных о рейсе в 1С
    function send_trip($rec_trip,$options=array())
    {
        $data=array('id'=>(int)$rec_trip['pkey'],
                    'shift_id'=>(int)$rec_trip['smena_id'],
                    'route_id'=>(int)$rec_trip['route_id'],
                    'trip_number'=>(int) $rec_trip['num'],
                    'person_uid'=>$rec_trip['person_uid'],
                    'car_uid'=>$rec_trip['car_uid'],
                    'car_number'=>$rec_trip['car_name'],
                    'cargo_weight'=>(float)$rec_trip['wn'],
                    'header_id'=>(int)$rec_trip['task_header_id'],
                    'line_id'=>(int)$rec_trip['task_line_id'],
		            'confirmed'=>(int)$rec_trip['confirmed']
                   ) ;
        if (_sizeof($rec_trip['points'])) foreach($rec_trip['points'] as $rec_point)
            //if ($rec_point['obj_name']!='Весовая')
            //$data['trip_points'][$rec_point['point_pkey']]=date('d.m.Y H:i:s',$rec_point['c_data']) ;
            $data['trip_points'][$rec_point['point_id']]=date('d.m.Y H:i:s',$rec_point['c_data']) ;

        $options['trip_id']=(int)$rec_trip['pkey'] ;

	    $this->send_to_quele('card_trip',$data,$options) ;
    }

	// отправка данных о рейсе в 1С
    function send_trip_confirmed($rec_trip,$options=array())
    {   $account_name=ACCOUNTS()->get_member_name_by_id($rec_trip['confirmed_account_id']) ;
        $data=array('id'=>(int)$rec_trip['pkey'],
                    'cargo_weight'=>(float)$rec_trip['wn'],
		            'confirmed_person'=>$account_name
                   ) ;
	    $this->send_to_quele('card_trip_confirmed',$data,$options) ;
    }
}

?>
