# Установка esmo-ws centOS

./esmo-ws install

# Перезапуск esmo-ws centOS

systemctl restart esmo-ws

# Описание esmo-ws.conf

```yaml
port: :9991                             - порт esmo-ws  
use_https: true                         - использовать ssl на esmo-ws  
ssl_ws:  
    path_to_key_file_name: null         - ssl key  
    path_to_cert_file_name: null        - ssl cert  
    path_to_ca_cert_file_name: null     - ssl ca cert 
remote_ws:  
    servers:  
    - ""                                - адреса связанных ws сервисов (может быть несколько), если обращение напрямую к ws, то необходимо указывать и порт (192.168.1.2:9991)  
    https: true                         - использовать ssl для связанных ws сервисов  
    endpoint: /ws_sendMessageFromWS     - url для отправки сообщений, если обращение напрямую к ws, то необходимо указать /sendMessageFromWS  
    require_valid_cert: false           - проверять сертификат при отправке сообщения  
check_authorization_ws_connect: false   - проверять авторизацию при подключении к ws  
```

# Пример конфига апача

```xml
    SSLProxyEngine on
#    SSLProxyVerify none
#    SSLProxyCheckPeerCN off
#    SSLProxyCheckPeerName off
#    SSLProxyCheckPeerExpire off
    ProxyPass /ws_connect wss://localhost:9991/ws
    ProxyPassReverse /ws_connect wss://localhost:9991/ws
    ProxyPass /ws_sendMessage https://localhost:9991/sendMessage
    ProxyPassReverse /ws_sendMessage https://localhost:9991/sendMessage
    ProxyPass /ws_sendMessageFromWS https://localhost:9991/sendMessageFromWS
    ProxyPassReverse /ws_sendMessageFromWS https://localhost:9991/sendMessageFromWS
```

Если используются самоподписанные сертификаты, то необходимо указать SSLProxyVerify none,SSLProxyCheckPeerCN off,SSLProxyCheckPeerName off и SSLProxyCheckPeerExpire .  

Если esmo-ws работает по http, то необходимо отключить SSLProxy, а wss:// и https:// заменить на ws:// и http://

        