<?php
include_once('c_skd.php') ;
include_once(_DIR_TO_MODULES.'/m_skd.php');
class c_page_cab_skd_access_point extends c_page_cab_skd
{
    public $h1 = 'Конфигурация устройств СКД';

    function block_main()
    {
        $this->panel_access_point_create();
        $this->panel_terminal_list();
    }

    function panel_access_point_create()
    {
        $this->page_title('Точки доступа') ;
        $arr_groups=SKD()->get_list_terminals() ;
        $med_groups=$this->get_med_groups();
        ?>
        <div id="panel_filter">
            <form id="sky-form_access_point" class="sky-form">
                <input type="hidden" name="filter_dir" value="<?echo _CUR_REPORT_DIR?>">
                <fieldset>
                    <div class="row">
                        <section class="col col-4">
                            <label class="label">Родительский терминал</label>
                            <label class="select">
                                <select name="filter[terminal]">
                                    <?if (_sizeof($arr_groups)) foreach($arr_groups as $id=>$rec){?><option value="<?echo $id?>"><?echo $rec['obj_name'] ?></option><?}?>
                                </select>
                            </label>
                        </section>
                        <section class="col col-3">
                            <label class="label">Название точки доступа:</label>
                            <label class="input"><input type="text" data-required name="filter[name]" value="<?echo $this->filter['name']?>" autocomplete="off"></label>
                        </section>
                        <section class="col col-3">
                            <label class="label">Рабочая группа:</label>
                            <label class="select">
                                <select name="filter[med_group]">
                                    <?if (_sizeof($med_groups)) foreach($med_groups as $rec){?><option value="<?echo $rec['pkey']?>"><?echo $rec['obj_name'] ?></option><?}?>
                                </select>
                            </label>
                        </section>
                        <section class="col col-2">
                            <label class="label">Зона:</label>
                            <label class="select">
                                <select name="filter[zone]">
                                    <option value="zone0" <?if($this->filter['zone']=='zone0') echo 'selected'?>>Вход</option>
                                    <option value="zone1" <?if($this->filter['zone']=='zone1') echo 'selected'?>>Выход</option>
                                </select>
                            </label>
                        </section>
                    </div>
                </fieldset>
                <div id="panel_buttons"><input type="submit" class="button v2" cmd="skd/access_point_create" value="Добавить точку доступа"  validate="form"></div><br>
            </form>
        </div><br> <?
    }

    function get_access_point_from_terminal($parent, $device_ID)
    {
        $recs = execSQL('select * from obj_site_skd where clss=601 and parent='.$parent.' and terminal_ID='.$device_ID);
        return $recs;
    }

    function get_med_groups()
    {
        $recs = execSQL('select pkey,obj_name from obj_site_account where clss=206');
        return $recs;
    }

    function panel_terminal_list()
    {
        $terminals = SKD()->get_list_terminals();
        $med_groups = $this->get_med_groups();
        $i=0; ?>
        <table class="basic fz_small auto">
        <tr>
            <th>№</th>
            <th>Турникет</th>
            <th>Точка доступа</th>
            <th>Зона</th>
            <th>Медицинская группа</th>
            <th>Карточка</th>
        </tr>
        <? foreach ($terminals as $terminal) {
            $access_point = $this->get_access_point_from_terminal($terminal['parent'],$terminal['device_ID']);
            if ($access_point) {
                $count = count($access_point);
                $keys = array_keys($access_point);
                $i++;?>
                <tr>
                    <td <?echo 'rowspan='.$count;?>><?echo $i;?></td>
                    <td <?echo 'rowspan='.$count;?>><?echo $terminal['obj_name']?></td>
                    <td><?echo $access_point[$keys[0]]['obj_name']?></td>
                    <td><?if ($access_point[$keys[0]]['zone_name'] == 'zone0') echo 'Вход'; else echo 'Выход';?></td>
                    <td><?if ($med_groups[$access_point[$keys[0]]['med_group_id']]) echo $med_groups[$access_point[$keys[0]]['med_group_id']]['obj_name']?></td>
                    <td><a href="/window/skd/setting/access_point/<?echo $access_point[$keys[0]]['pkey']?>/" class="new_window">Карточка</a></td>
                </tr>
                <?
                for($i=1;$i<$count;$i++){?>
                    <tr>
                        <td><?echo $access_point[$keys[$i]]['obj_name']?></td>
                        <td><?if ($access_point[$keys[$i]]['zone_name'] == 'zone0') echo 'Вход'; else echo 'Выход';?></td>
                        <td><?if ($med_groups[$access_point[$keys[$i]]['med_group_id']]) echo $med_groups[$access_point[$keys[1]]['med_group_id']]['obj_name']?></td>
                        <td><a href="/window/skd/setting/access_point/<?echo $access_point[$keys[$i]]['pkey']?>/" class="new_window">Карточка</a></td>
                    </tr>
                <?}
            }
        }?>
        </table><?
    }

}
?>
