<?php
include_once('c_send_report.php');

class c_page_cab_send_report_sender extends c_page_cab_send_report
{
//    public $h1 = 'sender_edit';

    public $h1 = 'Настройка отправки отчета';
    public $send_report = [];
    public $sender_rec = [];
    public $queue_recs = [];
    public $send_report_obj = [];
    public $use_datepicker=1;


    function select_obj_info()
    {
        if (_CUR_ID) {
            $this->sender_rec = SEND_REPORT()->get_sender_by_id(_CUR_ID);
            if (!_sizeof($this->sender_rec)) $this->result = 404;
//            $this->send_report = SEND_REPORT()->get_send_report_by_id($this->sender_rec['pkey']);
            $this->send_report = SEND_REPORT()->get_send_report_by_id($this->sender_rec['send_report_id']);
            $this->queue_recs = SEND_REPORT()->get_queue_by_sender_id($this->sender_rec['pkey']);
        }
    }

    function block_main()
    {
        $this->page_title('Настройка отправки отчета "'.$this->send_report['obj_name'].'"');
        SEND_REPORT()->breadcrumbs('/cab/send_report/report/'.$this->sender_rec['send_report_id'].'/', 'Вернуться к списку отправок');
//        damp_array($this->sender_rec);
//        damp_array($this->send_report);
//        damp_array($this->queue_recs);

        $this->panel_edit_sender();
    }

    function panel_tab_section($send_type,$name,$options=[])
    {
        $classArray=[];
        $classArray[]='section_label';
        if ($options['class']) $classArray[]=$options['class'];
        if (is_int($options['first']) and $options['first'] == $send_type) $classArray[]='first_tab';
        else if ($options['first']) $classArray[]='first_tab';
        if (!$options['visible']) $classArray[]='hidden';
        if ($this->sender_rec['send_type']==$send_type) $classArray[]='active';


        $class=implode(' ',$classArray);
        ?>
        <label class="<?=$class?>">
            <input type="radio" name="send_type" value="<?=$send_type?>" <?if ($this->sender_rec['send_type']==$send_type) echo 'checked'?> data-section-elem_id="<?=$options['section_elem_id']?>"><?=$name?>
        </label>
        <?
    }

    function panel_edit_sender() {
//        $obj_name = execSQL_value('select t3.obj_name from '.SEND_REPORT()->main_table.' t3 left join '.SEND_REPORT()->sender_table.' t2 on t2.send_report_id = t3.pkey where t2.pkey = '._CUR_ID);

        $script_dir = $this->send_report['script_dir'];
        $class_name = $this->send_report['class_name'];
        if (file_exists(_DIR_EXT . '/' . $script_dir)) {
            include_once(_DIR_EXT . '/' . $script_dir);
            if (class_exists($class_name)) {
                // выводит и устанавливает фильтры
                $report_obj = new $class_name;
            }
        }

        $section_active=[];
        if ($this->sender_rec['send_type']>=0 and $this->sender_rec['send_type']<=2) {
            $section_active['period']=true;
        } else {
            $section_active['cycle']=true;
        }
        $time_now = time();
        ?>
        <script>
            let array_day_time = [];
        </script>
        <form class="sky-form no_box_shadow">
            <input type="hidden" name="sender_id" value="<? echo $this->sender_rec['pkey'] ?>">
            <div id="send_options">
<!--            <p>Период цикла <span class="hint" data-hint="Выберите периодичность отправки отчетов"><i class="fa fa-question-circle"></i></span></p>-->
            <div class="tabs">
                <label class="type_section <?if ($section_active['period']) echo 'active';?>" data-label="period_label">Период</label>
                <?if (!$report_obj->send_type_only_period) {?><label class="type_section <?if ($section_active['cycle']) echo 'active';?>"  data-label="cycle_label">Цикл</label><?}?>
                <?
                if (!$report_obj->send_type_only_period) {
                    $this->panel_tab_section(0,'День',['visible'=>$section_active['period'],'first'=>true,'class'=>'period_label','section_elem_id'=>'period_day']);
                    $this->panel_tab_section(1,'Неделя',['visible'=>$section_active['period'],'class'=>'period_label','section_elem_id'=>'period_week']);
                    $this->panel_tab_section(2,'Месяц',['visible'=>$section_active['period'],'class'=>'period_label','section_elem_id'=>'period_month']);
                    $this->panel_tab_section(3, 'День', ['visible' => $section_active['cycle'], 'first' => true, 'class' => 'cycle_label', 'section_elem_id' => 'day']);
                    $this->panel_tab_section(4, 'Неделя', ['visible' => $section_active['cycle'], 'class' => 'cycle_label', 'section_elem_id' => 'week']);
                    $this->panel_tab_section(5, 'Месяц', ['visible' => $section_active['cycle'], 'class' => 'cycle_label', 'section_elem_id' => 'month']);
                } else { //если только период
                    //time_interval = array(1=>'Cутки',2=>'Неделя',3=>'Месяц');
                    reset($report_obj->time_interval); //на всякий случай скидываем указатель
                    $first = key($report_obj->time_interval)-1; //смотрим какой ключ первый
                    if ($first > $this->sender_rec['send_type']) $this->sender_rec['send_type'] = $first;
                    if (array_key_exists(1,$report_obj->time_interval)) $this->panel_tab_section(0,'День',['visible'=>$section_active['period'],'first'=>$first,'class'=>'period_label','section_elem_id'=>'period_day']);
                    if (array_key_exists(2,$report_obj->time_interval)) $this->panel_tab_section(1,'Неделя',['visible'=>$section_active['period'],'first'=>$first,'class'=>'period_label','section_elem_id'=>'period_week']);
                    if (array_key_exists(3,$report_obj->time_interval)) $this->panel_tab_section(2,'Месяц',['visible'=>$section_active['period'],'first'=>$first,'class'=>'period_label','section_elem_id'=>'period_month']);
                }
                ?>
            </div>
            <div class="tabcontent">
                <div id="send_name">
                    <p>Название отправки</p>
                    <input type="text" name="send_name" value="<? echo $this->sender_rec['send_name'] ?>">
                </div>
                <div id="period_day" class="w <?if ($this->sender_rec['send_type']!=0) echo 'hidden'?>">
                    <div>
                        <p>Время <span class="hint" data-hint="Выберите время для отправки отчетов."><i class="fa fa-question-circle"></i></span></p>
                        <?
                        if ((count($this->queue_recs)>0) && $this->sender_rec['send_type']==0){
                            foreach ($this->queue_recs as $rec){
                                $time = date('i:s',$rec['time_h_m']);
                                ?>
                                <input class="timepicker" type="time" name="period_day_time[]" value="<?echo $time ?>" >
                                <?
                            }
                        }
                        else {?>
                            <input class="timepicker" type="time" name="period_day_time[]" value="<?echo date('H:i',$time_now)?>" >
                        <?}?>
                    </div>
                </div>
                <div id="period_week" class="w <?if ($this->sender_rec['send_type']!=1) echo 'hidden'?>">
                    <div>
                        <p>Время <span class="hint" data-hint="Выберите время для отправки отчетов."><i class="fa fa-question-circle"></i></span></p>
                        <?
                        if ((count($this->queue_recs)>0) && $this->sender_rec['send_type']==1){
                            foreach ($this->queue_recs as $rec){
                                $time = date('i:s',$rec['time_h_m']);
                                ?>
                                <input class="timepicker" type="time" name="period_week_time[]" value="<?echo $time ?>" >
                                <?
                            }
                        }
                        else {?>
                            <input class="timepicker" type="time" name="period_week_time[]" value="<?echo date('H:i',$time_now)?>" >
                        <?}?>
                    </div>
                </div>
                <div id="period_month" class="w <?if ($this->sender_rec['send_type']!=2) echo 'hidden'?>">
                    <div>
                        <p>Время <span class="hint" data-hint="Выберите время для отправки отчетов."><i class="fa fa-question-circle"></i></span></p>
                        <?
                        if ((count($this->queue_recs)>0) && $this->sender_rec['send_type']==2){
                            foreach ($this->queue_recs as $rec){
                                $time = date('i:s',$rec['time_h_m']);
                                ?>
                                <input class="timepicker" type="time" name="period_month_time[]" value="<?echo $time ?>" >
                                <?
                            }
                        }
                        else {?>
                            <input class="timepicker" type="time" name="period_month_time[]" value="<?echo date('H:i',$time_now)?>" >
                        <?}?>
                    </div>
                </div>

                <div id="day" class="w <?if ($this->sender_rec['send_type']!=3) echo 'hidden'?> ">
                    <p>Время
                        <span class="hint" data-hint="Укажите время отправки отчетов.&#10;Вы можете получать несколько отчетов за день.&#10;Для добавления времени нажмите &#171;Добавить&#187;.&#10;Чтобы удалить время, нажмите &#171;Удалить&#187;">
                            <i class="fa fa-question-circle"></i></span>
                    </p>
                    <div>

                        <?
                        $array_day_time = [];
                        if ((count($this->queue_recs)>0) && $this->sender_rec['send_type']==3){
                            ?>
                        <div class="time_list">
                            <?
                            foreach ($this->queue_recs as $rec){
                            $time = date('i:s', $rec['time_h_m']);
                            array_push($array_day_time, $time);
                            ?>
                                <div class="time_row">
                                    <input class="" type="text" name="day_time[]" readonly value="<?
                                    echo $time ?>">
                                    <!--                                <img class="" src="/images/delete-2-24.png" title="Удалить">-->
                                    <a class="deltime" title="Удалить"><i class="fa fa-times"></i></a>
                                </div>
                                <?
                            }
                            ?>
                        </div>
                            <?
                        } else {
                            ?>
                            <div class="time_list hidden" >
                            </div>
                            <?
                        }
                            ?>
                        <div class="time_row time_row_last">
                            <input class="timepicker" type="time" value="<?echo date('H:i',$time_now)?>">
    <!--                        <img class="addtime" src="/images/delete-2-24.png" title="Добавить">-->
                            <a class="addtime" title="Добавить"><i class="fa fa-plus"></i></a>
                        </div>
                        <script>
                            array_day_time = <? echo json_encode($array_day_time)  ?>;
                        </script>
                    </div>
                </div>
                <div id="week" class="w <?if ($this->sender_rec['send_type']!=4) echo 'hidden'?> ">
                    <div>
                        <p>Дни недели <span class="hint" data-hint="Выберите дни недели для отправки отчетов.&#10;Для выбора нескольких дней зажмите Ctrl и выделите дни левой клавишей мыши">
                                <i class="fa fa-question-circle"></i></span></p>
                        <div>
                            <?
                            $array_week = [1=>'ПН',2=>'ВТ',3=>'СР',4=>'ЧТ',5=>'ПТ',6=>'СБ',7=>'ВС'];
                            for($i=1; $i<=7; $i++){
                                if ((count($this->queue_recs)>0) && $this->sender_rec['send_type']==4){
                                    foreach ($this->queue_recs as $rec){
                                        $send_days = unserialize($rec['send_days']);
                                        if(array_search($i, $send_days) > -1){
                                            $checked = 'checked';
                                            $selected='ui-selected';
                                        } else{
                                            $checked='';
                                            $selected='';
                                        }
                                        echo '<label class="cell_day '.$selected.'"><input type="checkbox" '.$checked.' name="week_days[]" value="'.$i.'"><span>'.$array_week[$i].'</span></label>';
                                    }
                                }
                                else{
                                    echo '<label class="cell_day"><input type="checkbox" name="week_days[]" value="'.$i.'"><span>'.$array_week[$i].'</span></label>';

                                }
                            }
                            ?>
                        </div>
                    </div>
                    <div>
                        <p>Время <span class="hint" data-hint="Выберите время для отправки отчетов."><i class="fa fa-question-circle"></i></span></p>
                        <?
                            if ((count($this->queue_recs)>0) && $this->sender_rec['send_type']==4){
                                foreach ($this->queue_recs as $rec){
                                    $time = date('i:s',$rec['time_h_m']);
                                    ?>
                                    <input class="timepicker" type="time" name="week_time[]" value="<?echo $time ?>" >
                                    <?
                                }
                            }
                            else {?>
                        <input class="timepicker" type="time" name="week_time[]" value="<?echo date('H:i',$time_now)?>" >
                        <?}?>
                    </div>
                </div>
                <div id="month" class="w <?if ($this->sender_rec['send_type']!=5) echo 'hidden'?>">
                    <div>
                        <p>Дни месяца <span class="hint" data-hint="Выберите дни месяца для отправки отчетов.&#10;Для выбора нескольких дней зажмите Ctrl и выделите дни левой клавишей мыши">
                                <i class="fa fa-question-circle"></i></span></p>
                        <div>
                            <?
                            for ($i=1; $i<=31; $i++){
                                if ((count($this->queue_recs)>0) && $this->sender_rec['send_type']==5){
                                    foreach ($this->queue_recs as $rec){
                                        $send_days = unserialize($rec['send_days']);
    //                                    (array_search($i, $send_days) > -1)? $checked = 'checked' : $checked='';
                                        if(array_search($i, $send_days) > -1){
                                            $checked = 'checked';
                                            $selected='ui-selected';
                                        } else{
                                            $checked='';
                                            $selected='';
                                        }
                                        echo '<label class="cell_day '.$selected.'"><input type="checkbox" '.$checked.' name="month_days[]" value="'.$i.'"><span>'.$i.'</span></label>';
                                    }
                                }
                                else{
                                    echo '<label class="cell_day"><input type="checkbox" name="month_days[]" value="'.$i.'"><span>'.$i.'</span></label>';
                                }

                            }
                            ?>
                        </div>
                    </div>
                    <div>
                        <p>Время <span class="hint" data-hint="Выберите дни недели для отправки отчетов.&#10;Для выбора нескольких дней зажмите Ctrl и выделите дни левой клавишей мыши">
                                <i class="fa fa-question-circle"></i></span></p>
                        <?
                        if ((count($this->queue_recs)>0) && $this->sender_rec['send_type']==5){
                            foreach ($this->queue_recs as $rec){
                                $time = date('i:s',$rec['time_h_m']);
                                ?>
                                <input class="timepicker" type="time" name="month_time[]" value="<?echo $time ?>" >
                                <?
                            }
                        }
                        else {?>
                            <input class="timepicker" type="time" name="month_time[]" value="<?echo date('H:i',$time_now)?>" >
                        <?}?>
                    </div>
                </div>


                <div id="email_block">

                    <p>E-mail <span class="hint" data-hint="Введите почту для получения отчетов и нажмите &#171;Добавить&#187;.&#10;Вы можете указать несколько почтовых ящиков.">
                            <i class="fa fa-question-circle"></i></span></p>
                    <?
                    if ($this->sender_rec['send_email']!=''){
                        $str_email = $this->sender_rec['send_email'];
                        ?>
                        <div class="email_list" >
                            <input hidden name="send_email" value="<? echo $str_email ?>">
                        <?
                        $arr_email = explode(',', $str_email);
                        foreach ($arr_email as $address){
                            ?>
                            <div><span><? echo $address ?></span>
                                <a class="delemail" title="Удалить"><i class="fa fa-times"></i></a>
                            </div>
                            <?
                        }
                        ?>
                        </div>
                        <div>
                            <input type="text" class="sender_email">
                            <a class="addemail" title="Добавить"><i class="fa fa-plus"></i></a>
                        </div>
                        <?
                    }
                    else {
                        ?>
                        <div class="email_list hidden" >
                            <input hidden name="send_email">

                        </div>
                        <div>
                            <input type="text" class="sender_email">
                            <a class="addemail" title="Добавить"><i class="fa fa-plus"></i></a>
                        </div>

                        <?
                    }
                    ?>
                </div>
            </div>
        </div>
            <button id="add" class="button v2" cmd="send_report/create_new_queue" validate="form"><?if (count($this->queue_recs)>0) echo 'Сохранить'; else echo 'Добавить'?></button>
        </form>
        <div class="filters">
                    <div id="panel_report_view">
                        <div class="inner">
            <?
            if ($this->sender_rec['send_status'] != 0){
                ?>
                <p>Фильтры отчета <span class="hint" data-hint="Выберите параметры для формирования отчета"><i class="fa fa-question-circle"></i></span></p>
                <?
                $filters = unserialize($this->sender_rec['filters']);
                if (file_exists(_DIR_EXT . '/' . $script_dir)) {
                    include_once(_DIR_EXT . '/' . $script_dir);
                    if (class_exists($class_name)) {
                        // выводит и устанавливает фильтры
                        $report_obj = new $class_name;
                        ob_start();
                        $report_obj->filter = $filters;
                        if ($filters != ''){
                            foreach ($filters as $key=>$filter){
                                if (is_array($filter)){
                                    $array = [];
                                    foreach ($filter as $item){
                                        $array[$item] = 1;
                                    }
                                    $report_obj->filter[$key] = $array;
                                }
                            }
                        }
//                        $report_obj->filter['dopusk'] = [1=>1,3=>3];
                        if ($report_obj->send_type_only_period) {
                            $report_obj->filter['time_interval'] = $this->sender_rec['send_type']+1; //записать в фильтр временной интервал
                        }
                        $report_obj->setting();
                        $html_setting = ob_get_clean();
                        $html_setting = preg_replace('/<div id="panel_buttons">(.*)<\/div>/i', '', $html_setting);
                        echo $html_setting;
                    }
                }
            }

            ?>
                        </div></div>
        </div>


        <script type="text/javascript">
            $j(document).ready(function()
            {

                $j('input.timepicker').timepicker($j.timepicker.regional["ru"]);

                $j('label.type_section').on('click',function () {
                    $j('.section_label').removeClass('active').addClass('hidden');
                    $j('label.type_section').removeClass('active');
                    $j(this).addClass('active')

                    $j('.section_label.' + $j(this).attr('data-label')).removeClass('hidden');

                    view_elem_data($j('.section_label.' + $j(this).attr('data-label')).first().children().first());
                });

                function view_elem_data(e) {
                    $j('[name=send_type]').removeAttr('checked');
                    $j(e).attr('checked', true);
                    $j(e).parent().addClass('active');
                    $j('.w').addClass('hidden');
                    $j('#' + $j(e).attr('data-section-elem_id')).removeClass('hidden');
                    if ($j('#selectInterval')) {
                        let value = $j('input[name=send_type][checked=checked]').attr('value');
                        let intVal = parseInt(value) +1;
                        $j('#selectInterval option[selected=selected]').removeAttr('selected');
                        $j('#selectInterval option[value='+intVal+']').attr('selected','selected');
                    }
                }

                //Переключение между периодами цикла
                $j('input[name=send_type]').on('click',function () {
                    $j('.section_label').removeClass('active');
                    view_elem_data(this);
                });

                //добавление времени для дня
                $j(document).on('click', '.addtime',function(){
                    // let this_parent = $j(this).parent().index('.time_row'); //index родительского элемента (div)
                    // console.log($j(this).prev().val());
                    if($j(this).prev().val() != ''){
                       let check = checkTime($j(this).prev().val());
                       if (check == false){
                          $j('.time_row_last').removeClass('message_empty').addClass('show_message'); //выводи сообщение
                          setTimeout(function(){$j('.time_row_last').removeClass('show_message')},3000); //скрываем сообщение через 3 сек
                       }
                       else {
                           let new_pos = sortTime($j(this).prev().val()); //новая позиция элемента
                           // let act_pos = $j(this).parent().index(); //текущая позиция элемента
                           console.log(new_pos);
                            if(new_pos == 0){
                                $j('.time_list').removeClass('hidden');
                                $j(this).removeClass('addtime').addClass('deltime').attr('title','Удалить').html('<i class="fa fa-times"></i>'); //меняем кнопку Добавить на Удалить
                                $j(this).prev().attr('type','text').attr('name','day_time[]').prop('readonly', true).off();
                                $j('.time_list').prepend($j('.time_row_last'));
                                $j(this).parent().removeClass('time_row_last');
                              // добавляем новый input ниже
                                $j('.time_list').after('<div class="time_row time_row_last"><input class="timepicker" type="time" value="<?echo date('H:i',$time_now)?>">'+'<a class="addtime"><i class="fa fa-plus"></i></a>'+'</div>');
                           }
                           else{
                                $j('.time_list').removeClass('hidden');
                                $j(this).removeClass('addtime').addClass('deltime').attr('title','Удалить').html('<i class="fa fa-times"></i>'); //меняем кнопку Добавить на Удалить
                                $j(this).prev().attr('type','text').attr('name','day_time[]').prop('readonly', true).off();
                                $j('.time_row_last').insertAfter('.time_list>div:eq('+ --new_pos +')');
                                $j(this).parent().removeClass('time_row_last');
                                // добавляем новый input ниже
                                $j('.time_list').after('<div class="time_row time_row_last"><input class="timepicker" type="time" value="<?echo date('H:i',$time_now)?>">'+'<a class="addtime"><i class="fa fa-plus"></i></a>'+'</div>');
                           }
                       }
                    }
                    else {
                       $j('.time_row_last').addClass('message_empty show_message'); //выводит сообщение
                       setTimeout(function(){$j('.time_row_last').removeClass('show_message')},3000); //скрываем сообщение через 3 сек
                    }
                })
                //удаление времени
                $j(document).on('click', '.deltime',function () {
                    // console.log($j(this).parent().index());
                    delTime($j(this).parent().index('.time_row'));
                })

                // выбор дня недели/месяца выделением
                $j('#week>div>div, #month>div>div').selectable({
                    filter: '.cell_day',
                    selecting: function (event, ui) {
                        // console.log(ui.selecting.style.cursor = 'pointer');
                    },
                    selected: function(event, ui){
                        // console.log(ui);
                        ui.selected.children[0].checked = true;
                    },
                    stop: function () {
                    },
                    unselected: function (event, ui){
                        ui.unselected.children[0].checked = false;
                    }
                });

                // Добавление почты в list
                $j('.addemail').on('click', function(){
                    let address = $j(this).prev().val().replace(/[^\S\r\n]+/g, ''); //улаляем все пробелы и табуляцию
                    console.log('"'+address+'"');
                    if(address == ''){
                        $j('#email_block>div:last').addClass('email_empty show_message'); //выводит сообщение
                        setTimeout(function(){$j('#email_block>div:last').removeClass('show_message')},3000); //скрываем сообщение через 3 сек
                        $j('.sender_email').focus();
                    }
                    else {
                        let arr_address = address.split(',');
                        arr_address.forEach(function(item, index, array) {
                            checkEmail(item);
                        })
                    }
                })
                //    удаление электронной почты
                $j(document).on('click','.delemail', function () {
                    let address = $j(this).prev().text();
                    let pos = $j('input[name=send_email]').val().indexOf(address);
                    let send_email = $j('input[name=send_email]').val();
                    (pos != 0)? send_email = $j('input[name=send_email]').val().replace(','+address, '')
                        : (address.length != send_email.length) ? send_email = $j('input[name=send_email]').val().replace(address+',', '')
                        : (send_email = $j('input[name=send_email]').val().replace(address, ''), $j('.email_list').addClass('hidden'));
                    $j('input[name=send_email]').val(send_email);
                    $j(this).parent().remove();
                })
            }) ;

            function checkTime(time){
                if( array_day_time.indexOf(time) < 0){
                    array_day_time.splice(1, 0, time);
                    return true;
                } else { return false; }
            }

            function sortTime(time){
                array_day_time.sort();
                console.log(array_day_time);
                return array_day_time.indexOf(time);
            }

            function delTime(act_pos){
                $j('.time_list>div:eq('+act_pos+')').remove();
                array_day_time.splice(act_pos, 1);
                // console.log(array_day_time.length);
                if (array_day_time.length == 0) $j('.time_list').addClass('hidden');
            }

            function checkEmail(address){
                let reg = /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9_](?:[a-zA-Z0-9_\-](?!\.)){0,61}[a-zA-Z0-9_-]?\.)+[a-zA-Z0-9_](?:[a-zA-Z0-9_\-](?!$)){0,61}[a-zA-Z0-9_]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/
                if (reg.test(address)){
                    if ($j('input[name=send_email]').val().indexOf(address, 0) < 0){
                        $j('.email_list').append('<div><span>'+address+'</span><a class="delemail" title="Удалить"><i class="fa fa-times"></i></a></div>');
                        ($j('input[name=send_email]').val() != '') ? $j('input[name=send_email]').val($j('input[name=send_email]').val() + ',' + address) : $j('input[name=send_email]').val(address);
                        // $j(this).prev().val('');
                        $j('.sender_email').val('').focus();
                        $j('.email_list').removeClass('hidden');
                    }
                    else {
                        $j('#email_block>div:last').removeClass('email_empty').addClass('show_message'); //выводит сообщение
                        setTimeout(function(){$j('#email_block>div:last').removeClass('show_message')},3000); //скрываем сообщение через 3 сек
                        $j('.sender_email').focus();
                    }
                }
                else {
                    $j('#email_block>div:last').addClass('email_incorrect show_message'); //выводит сообщение
                    setTimeout(function(){$j('#email_block>div:last').removeClass('show_message')},3000); //скрываем сообщение через 3 сек
                    $j('.sender_email').focus();
                }
            }

            // $j('#get_filter').insertBefore('#panel_buttons');
            $j('.filters').insertBefore('#add');
            $j('.filters fieldset').unwrap().unwrap();
            $j('#panel_buttons').remove();
            //$j('h1').append(' "<?// echo $obj_name; ?>//"');

            let now = new Date();
            let now_day = (now.getDate() < 10) ? '0' + now.getDate() : now.getDate();
            let now_month = (now.getMonth()+1 < 10) ? '0' + (now.getMonth()+1) : now.getMonth()+1;
            let now_year = now.getFullYear();
            $j('.datetimepicker').attr('disabled', true).val(now_day+'.'+now_month+'.'+now_year+' 00:00').removeAttr('name').css('opacity',0.6);
            $j('.datepicker').attr('disabled', true).val(now_day+'.'+now_month+'.'+now_year).removeAttr('name').css('opacity',0.6);
            $j('section.day_section').attr('disabled', true).css('opacity',0.6);
            $j('section.week_section').attr('disabled', true).css('opacity',0.6).find('select').removeAttr('name');
            $j('section.month_section').attr('disabled', true).css('opacity',0.6).find('select').removeAttr('name');
            $j('#selectInterval').parent().parent().addClass('hidden');
            $j('#selectInterval option[selected]').attr('selected','selected');
        </script>
        <?

    }
}

?>

