<?php
include_once('c_send_report.php');

class c_page_cab_send_report_report extends c_page_cab_send_report
{
    public $h1 = 'Список отправок отчета';
    public $send_report = [];
    public $send_report_obj = [];
    public $sender_recs = [];

    function select_obj_info()
    {
        if (_CUR_ID) {
            $this->send_report = SEND_REPORT()->get_send_report_by_id(_CUR_ID);
            if (!_sizeof($this->send_report)) $this->result=404;
            $this->sender_recs  = SEND_REPORT()->get_senders_by_send_report_id(_CUR_ID);
        }
    }

    function block_main()
    {
        $this->page_title('Список отправок отчета "'.$this->send_report['obj_name'].'"');
        $this->panel_create_new_sender();
        if (count($this->sender_recs)) $this->view_send_report_recipients_list();
        else $this->empty_sender();
    }

    function empty_sender(){
        ?>
        <div style="margin: 10px 0 0 20px; font-weight: bold">
            <p>Не добавлено ни одной отправки для отчета "<? echo $this->send_report['obj_name']; ?>"</p>
        </div>
        <?
    }

    function panel_create_new_sender()
    {
        ?>
        <div style="display: flex;">
            <?         SEND_REPORT()->breadcrumbs('/cab/send_report/', 'Вернуться к списку отчетов'); ?>
            <form class="sky-form no_box_shadow">
                <button class="button v2 left" send_report_id="<?echo $this->send_report['pkey']?>" cmd="send_report/create_new_sender">Создать новую</button>
            </form>
        </div>
        <?
    }

    function view_send_report_recipients_list()
    {
//        damp_array($this->send_report);
        ?>
        <table class="basic sender_edit send_report_queue">
            <tr>
                <th>№</th>
                <th>Тип отправки</th>
                <th>Вид</th>
                <th><span data-content="Фильтр" style="font-weight: normal;"><i class="fa fa-filter" style="color:black"></i></span></th>
<!--                <th>Название</th>-->
                <th>Получатели</th>
<!--                <th>Активных отправок</th>-->
                <th></th>
                <th></th>
            </tr>
                <?
                $index = 1;
                foreach ($this->sender_recs as $sender_rec) {
                    ?>
                    <tr class="<?
//                    switch ($sender_rec['send_type']) {
//                            case '0': echo 'type_day'; break;
//                            case '1': echo 'type_week'; break;
//                            case '2': echo 'type_month'; break;
//                        }
                    ?>" >
<!--                        <td><a href="/cab/send_report/sender/--><?//echo $sender_rec['pkey']?><!--/">--><?//echo $sender_rec['pkey']?><!--</a></td>-->
                        <td><? echo $index ?></td>
                        <td><div id="next_sender_<? echo $sender_rec['pkey']?>">
                                <?
                                if ($sender_rec['send_status'] == 0) echo SEND_REPORT()->sender_status[$sender_rec['send_status']];
                                else if ($sender_rec['send_on'] != 0 )echo SEND_REPORT()->sender_status[$sender_rec['send_status']].'<br><span class="next_sender">'.SEND_REPORT()->next_sender($sender_rec).'</span>';
                                else echo 'Отключен' ?></div>
                        <td class="<?
                            switch ($sender_rec['send_type']) {
                                    case '0'; case '3'; echo 'type_day'; break;
                                    case '1'; case '4'; echo 'type_week'; break;
                                    case '2'; case '5'; echo 'type_month'; break;
                            }
                        ?>">
                            <? switch ($sender_rec['send_type']) {
                                case '0': echo 'Период<br>День'; break;
                                case '1': echo 'Период<br>Неделя'; break;
                                case '2': echo 'Период<br>Месяц'; break;
                                case '3': echo 'Цикл<br>День'; break;
                                case '4': echo 'Цикл<br>Неделя'; break;
                                case '5': echo 'Цикл<br>Месяц'; break;
                            }
                            ?></td>
<!--                        <td>--><?// if ($sender_rec['filters'] != '') echo 'Настроен'; else echo '<span style="color:red;">Не настроен</span>'; ?><!--</td>-->
                        <td><? if ($sender_rec['filters'] != '') echo '<span data-content="Фильтр не настроен"><i class="fa fa-check"></i></span>'; else echo '<span data-content="Фильтр настроен"><i class="fa fa-times" style="color:#d00f0f;"></i></span>'; ?></td>
<!--                        <td>--><?// echo $sender_rec['send_name']?><!--</td>-->
<!--                        <td>--><?//echo $sender_rec['send_email']?><!--</td>-->
                        <td>
                            <div class="send_name">
                                <div><span><? if ($sender_rec['send_name'] != '') echo $sender_rec['send_name']?></span></div>
                                <div><?
                                    if ($sender_rec['send_email'] != ''){
                                    ?>
                                    <input hidden value="<? echo $sender_rec['send_email'] ?>">
                                    <a class="copy_email_list" data-content="Скопировать в буфер обмена">
                                        <i class="fa fa-files-o"></i></a>
                                    <div class="email_list"><?
                                            $arr_emails = explode(',', $sender_rec['send_email']);
                                            foreach ($arr_emails as $email){
                                                echo '<div><span>'.$email.'</span></div>';
                                            }
                                        }
                                    ?></div>
                                </div>
                            </div>
                        </td>
<!--                        <td>--><?//echo $sender_rec['cnt_queue']?><!--</td>-->
                        <td>
                            <div class="btn-cell">
                                    <div class="switch-btn <? if($sender_rec['send_on'] != 0 && $sender_rec['send_status'] != 0) echo 'switch-on' ?>"
                                         sender_key="<? echo  $sender_rec['pkey'] ?>"
                                         send_type="<? echo $sender_rec['send_type'] ?>"
                                         send_status="<? echo $sender_rec['send_status'] ?>"
                                         data-content="<? if ($sender_rec['send_status'] != 0){
                                             if ($sender_rec['send_on'] != 0) echo 'Выключить отправку'; else echo 'Включить отправку';
                                         } else echo 'Отчет не настроен'; ?>" >
                                    </div>

                                <? if ($sender_rec['send_status'] != 0) {?>
                                <a class="v2" sender_key="<? echo  $sender_rec['pkey'] ?>" data-content="Сформировать отчет&#10;и отправить получателям" cmd="send_report/test_report" send_email="<? echo $sender_rec['send_email'] ?>">
                                    <i class="fa fa-paper-plane"></i>
                                </a>
                                <?} else {
                                    ?><a data-content="Отчет не настроен"><i class="fa fa-paper-plane" style="color:#bfbfbf"></i></a> <?
                                }?>
                                <a href="/cab/send_report/sender/<?echo $sender_rec['pkey']?>/" data-content="Редактировать">
                                    <i class="fa fa-pencil-square-o"></i>
                                </a>
                            </div>
                        </td>
                        <td>
                            <a class="v2" index="<? echo $index++ ?>" sender_key="<? echo  $sender_rec['pkey'] ?>" data-content="Удалить" cmd="send_report/delete_sender" >
                                <i class="fa fa-trash-alt" style="color:#d00f0f"></i>
                            </a>
                        </td>
                    </tr>
                    <?
                }
                ?>
        </table>
        <script>
            $j('.copy_email_list').on('click', function () {
                let email_list = $j(this).prev().val();
                var tmp = $j('<input>');
                $j("body").append(tmp);
                tmp.val(email_list).select();
                document.execCommand("copy");
                tmp.remove();
                // $j(this).children('.copy_email_list_hint').text('Скопировано!');
                $j(this).attr('data-content','Cкопировано!');
            })

            $j('.copy_email_list').mouseenter(function () {
                $j(this).attr('data-content','Скопировать в буфер обмена');
                // $j(this).append('<div class="copy_email_list_hint">Скопировать в буфер обмена</div>');
                // $j(this).children('.copy_email_list_hint').show(200,'swing');
            })
            // $j('.copy_email_list').mouseleave(function () {
            //     // $j(this).children('.copy_email_list_hint').text('Скопировать в буфер обмена!');
            //     $j(this).children('.copy_email_list_hint').hide(200);
            //     $j(this).children('.copy_email_list_hint').remove();
            // })

            $j('.switch-btn').on('click',function () {
                if ($j(this).attr('send_status') != 0){
                    $j('#next_sender_'+$j(this).attr('sender_key')).html('<img id="load_gif" src="/images/loading5.gif">');
                    if ($j(this).hasClass('switch-on')){//off
                        $j(this).toggleClass('switch-on').attr('data-content','Включить отправку');
                        send_ajax_request({cmd:'send_report/on_off_sender',sender_key:$j(this).attr('sender_key'),send_on:0, send_status:$j(this).attr('send_status'), send_type:$j(this).attr('send_type')})
                    } else { //on
                        $j(this).toggleClass('switch-on').attr('data-content','Отключить отправку');
                        send_ajax_request({cmd:'send_report/on_off_sender',sender_key:$j(this).attr('sender_key'),send_on:1, send_status:$j(this).attr('send_status'), send_type:$j(this).attr('send_type')})
                    }
                }
            })
        </script>
        <?
    }



//    function view_setting()
//    {
//        if (SEND_REPORT()->include_report($this->send_report['script_dir'])) {
//            $this->send_report_obj = new $this->send_report['class_name']();
//            $this->send_report_obj->setting();
//        }
//    }


}

?>