<?php
class report_control_TO_entry extends c_report
{
    var $title='Журнал учета послерейсового ТО' ;
    var $filter=array() ;
    var $view_by_space_filter=1;

    function init($options=array())
    {
        if (!$this->filter['group_id']) $this->filter['group_id']=MEMBER()->cur_group_id ;
    }

    function setting()
    {
        $arr_accounts=ACCOUNTS()->get_list_members(array('group_id'=>MEMBER()->cur_group_id,'rol'=>'1,5')) ; ?>
        <div id="panel_filter">
            <form id="sky-form" class="sky-form"><input type="hidden" name="filter_dir" value="<?echo _CUR_REPORT_DIR?>">
                <fieldset>
                    <div class="row">
                        <?
                        $this->filter_section_input_text('name','ФИО водителя:',4,array('auto_complete'=>"autocomplette_personal_name")) ;
                        $this->filter_section_input_text('car','Гос.номер автомобиля:',2,array('auto_complete'=>"autocomplette_car_number_to")) ;
                        ?>
                    </div>
                    <div class="row">
                        <?
                        $this->filter_section_select('engineer', 'Допустил:', 2, $arr_accounts, array('space_element' => 1));
                        $this->filter_section_input_text('data_from','От:',2,array('class'=>'datetimepicker')) ;
                        $this->filter_section_input_text('data_to','До:',2,array('class'=>'datetimepicker')) ;
                        ?>
                    </div>
                </fieldset>
                <?$this->panel_buttons();?>
            </form>
        </div>
        <?
    }

    function panel_info_filter()
    {
        $_str=array() ; $info=array() ; $title='' ;

        if ($this->filter['name'])                            $info['Водитель']='"'.$this->filter['name'].'"' ;
        if ($this->filter['engineer'])                        $info['Допустил']=ACCOUNTS()->get_member_name_by_id($this->filter['engineer']);
        if ($this->filter['car'])                             $info['Автомобиль']='"'.$this->filter['car'].'"' ;
        if ($this->filter['data_from'])                       $info['c']=$this->filter['data_from'] ;
        if ($this->filter['data_to'])                         $info['по']=$this->filter['data_to'] ;
        if ($this->filter['time_from'])                       $info['c']=date('d.m.Y H:i',$this->filter['time_from']) ;
        if ($this->filter['time_to'])                         $info['по']=date('d.m.Y H:i',$this->filter['time_to']) ;

        if (_sizeof($info)) foreach($info as $title=>$value)   if (is_array($value)) $_str[]=$title.': <strong>'.implode(', ',$value).'</strong>' ; else $_str[]=$title.': <strong>'.$value.'</strong>' ;
        if (_sizeof($_str)) $title='<p class=center>'.implode(' ',$_str).'</p>' ;
        return $title ;
    }

    function create_usl_select_obj($_params,&$options)
    {
        $_usl[]='t1.clss=360';
        $_usl[]='t1.access_type=0'; //всегда на въезд
        if ($this->filter['name'])
        {   $arr_ids=execSQL_line('select pkey from obj_site_personals where clss=211 and obj_name like "%'.addslashes($this->filter['name']).'%"') ;
            if (_sizeof($arr_ids))  $_usl[]='t1.personal_id in ('.implode(',',$arr_ids).')' ;
            else                   $_usl[]='t1.personal_id=-1' ;
        }
        if ($this->filter['engineer'])
        {   $arr_ids=execSQL_line('select pkey from obj_site_account where clss=210 and pkey='.$this->filter['engineer']) ;
            if (_sizeof($arr_ids))  $_usl[]='t1.member_id in ('.implode(',',$arr_ids).')' ;
            else                   $_usl[]='t1.member_id=-1' ;
        }
        if ($this->filter['car'])       $_usl[]='t1.car_number="'.$this->filter['car'].'"';
        if ($this->filter['time_from']) $_usl[]='t1.c_data>='.$this->filter['time_from'] ;
        if ($this->filter['time_to'])   $_usl[]='t1.c_data<='.$this->filter['time_to'] ;
        if ($this->filter['data_from']) $_usl[]='t1.c_data>='.strtotime($this->filter['data_from']) ;
        if ($this->filter['data_to'])   {
            $arr=explode(' ',trim($this->filter['data_to'])) ;
            $time_to=(!$arr[1])? strtotime($this->filter['data_to'].' 23:59:59'):strtotime($this->filter['data_to']) ;
            $_usl[]='t1.c_data<='.$time_to ;
        }

        $usl=implode(' and ',$_usl) ;
        return($usl);
    }

    function get_cnt_items($usl, $options = array())
    {
        if ($usl) $usl=' where '.$usl;
        $cnt=execSQL_value('select count(t1.pkey) from obj_site_cars_to t1 '.$usl,$options['debug']);
        return $cnt;
    }

    function get_items($usl, $options = array())
    {
        $limit=($options['limit'])? ' '.$options['limit']:'' ;
        if ($usl) $usl=' where '.$usl;
        $recs = execSQL('select t1.*,t2.obj_name as engineer from obj_site_cars_to t1
                       left join '.ACCOUNTS()->table_account.' t2 on t2.pkey=t1.member_id'.$usl.$limit,$options);
        $all_info = $this->get_dop_information($recs);
        return $all_info;
    }

    function get_dop_information($recs)
    {
        foreach($recs as $i=>$rec)
        {
            if ($rec['status']==1) {
                $recs[$i]['_status']='Разрешен';
            } else if ($rec['status']==2) {
                $recs[$i]['_status']='Запрещен';
            } else {
                $recs[$i]['_status']='Не окончен';
            }
        }
        return($recs) ;
    }

    function print_template_HTML($list_recs,$options=array())
    {
        ?>
        <table class="basic fz_small full auto">
            <tr>
                <th>Марка, модель ТС</th>
                <th>Гос.номер</th>
                <th>ФИО водителя</th>
                <th>ФИО техника</th>
                <th>Дата/время</th>
                <th>Пробег</th>
                <th>Допуск в рейс</th>
                <th>Подпись водителя</th>
                <th>Подпись техника</th>
            </tr>
            <?
            foreach ($list_recs as $list_rec) {
                $check_params=json_decode($list_rec['result']);
                ?>
                <tr>
                    <td><?echo $list_rec['car_model']?></td>
                    <td><?echo $list_rec['car_number']?></td>
                    <td><?echo $list_rec['obj_name']?></td>
                    <td><?echo $list_rec['engineer']?></td>
                    <td><?echo date('d.m.Y H:i', $list_rec['c_data'])?></td>
                    <td><?echo $check_params->odometr?></td>
                    <td><?echo $list_rec['_status']?></td>
                    <td><?if($list_rec['sign_driver']){?><img src="/public/to_sign/<?echo $list_rec['sign_driver']?>" width="100"><?}?></td>
                    <td><?if($list_rec['sign_tech']){?><img src="/public/to_sign/<?echo $list_rec['sign_tech']?>" width="100"><?}?></td>
                </tr>
                <?
            }
            ?>
        </table>
        <style>
            th.table_number {width: 20px;}
        </style>
        <?
    }
}

?>
