<?php
include_once('report_quiz_question_rating.php');
class report_quiz_department_rating extends report_quiz_question_rating
{
    var $title='Контроль знаний - рейтинг подразделений' ;

    function prepare_data()
    {
        $order = '';
        if ($this->filter['question_order']==1) $order='desc';

        $having='';
        if (is_numeric($this->filter['question_count']) and $this->filter['question_count']>0) $having=' having cnt>='.$this->filter['question_count'];

        $usl_time='';
        if ($this->usl_quiz_result) $usl_time='and '.$this->usl_time;

        $recs = execSQL('select t4.department_id,t4.sum_correct,t4.cnt,round((sum_correct/t4.cnt * 100 ),2) as perc,t4.obj_name,t4.level
                               from (select t1.parent as department_id,sum(t1.'.$this->sql_variable['correct_column_name'].') as sum_correct,count(t1.quiz_result_id) as cnt,t5.obj_name,t5.level
                                    from '.$this->sql_variable['main_table'].' t1
                                      inner join obj_site_personals t5 on t5.pkey=t1.parent and t5.clss=208  
                                      left join quiz_questions t2 on t2.pkey=t1.question_id
                                      left join quiz_themes t3 on t3.pkey=t2.parent
                                      left join '.MEMBER()->personal_viewer_name.' tp on tp.pkey=t1.personal_id
                                      where '.$this->usl_quiz_result.' '.$usl_time.' and not tp.pkey is null
                                      group by t1.parent
                                        '.$having.'
                               ) t4
                           order by perc '.$order.'
                           limit '.$this->filter['question_limit'].'
        ');

        return $recs;
    }

    function table_view_panel($data=[],$options=[])
    {
        $table_class='basic auto';
        if (!$options['half_view_HTML']) $table_class=$table_class.' full';
        else $table_class=$table_class.' fz_small';
        if ($this->filter['question_order']) {
            $icon='<i class="fa fa-thumbs-up icon_best" title="Топ '.$this->filter['question_limit'].' лучших"></i>';
        } else {
            $icon='<i class="fa fa-thumbs-down icon_worst" title="Топ '.$this->filter['question_limit'].' худших"></i>';
        }
        if (_sizeof($data)) {
            ?>
            <table class="<?=$table_class?>">
                <tr>
                    <th style="width: 20px"><?=$icon?></th>
                    <th>Подразделение</th>
                    <th style="width: 50px"><?=$this->table_column_name['cnt']?></th>
                    <th style="width: 50px"><?=$this->table_column_name['perc']?></th>
                </tr>
                <?
                foreach ($data as $stats) {
                    ?>
                    <tr>
                        <td><?echo ++$i?></td>
                        <td class="left">
                            <a class="new_window" href="/window/personals/org/editor/<?=$stats['department_id']?>/"><?=$stats['obj_name']?></a>
                        </td>
                        <td><?=$stats['cnt']?></td>
                        <td><?=$stats['perc']?></td>
                    </tr>
                    <?
                }
                ?>
            </table>
            <?
        }
    }

}

?>
