<?php
include_once('c_print_order.php') ;
class c_page_cab_print_order_order extends c_page_cab_print_order
{
	public $h1='Настройка наряда' ;
	public $print_order_rec=[];

    function select_obj_info() {
        if (_CUR_ID) {
            $this->print_order_rec=PRINT_ORDER()->get_print_order_by_pkey(_CUR_ID);
        }
    }

    function set_head_tags() {
        parent::set_head_tags(); // TODO: Change the autogenerated stub
        $this->HEAD['js'][]=_PATH_TO_EXT.'/print_order/script.js' ;
        $this->HEAD['css'][]=_PATH_TO_EXT.'/print_order/style.css' ;
    }

    function block_main() {
        $this->page_title('Печать наряда') ;

        if (_sizeof($this->print_order_rec)) $this->view_print_order();
    }

    function view_print_order() {
        ?>
        <table id="print_order_edit">
            <colgroup><col id="c1"><col id="c2"></colgroup>
            <tr>
                <td class="preview_column">
                    <?$image_info=$this->preview_doc();?>
                </td>
                <td class="right_column">
                    <?$this->template_params($image_info)?>
                </td>
            </tr>
        </table>
        <?
    }

    function template_params($image_info) {
        $page_number_options=[]; $page_values=[]; $size_max_ratio=0; $size_min_ratio=0; $size_step=0;
        $cur_page_name=0;
        if ($this->print_order_rec['_ext_info']['stamp_on_page']) $cur_page_name=(int) $this->print_order_rec['_ext_info']['stamp_on_page'];

        if (_sizeof($image_info)) {
            foreach ($image_info as $page_number=>$page_data) {
                $page_number_options[$page_number]='Страница № '.($page_number+1);
                $page_values[$page_number]['width']=$page_data[0];
                $page_values[$page_number]['height']=$page_data[1];
            }
        }

        //TODO определение размера штампа
        $stamp_width=323;

        if (_sizeof($page_values[0])) {
            $size_max_ratio=round($page_values[0]['width']/$stamp_width);
            $size_min_ratio=0.2;
            $size_step=0.2;
        }

        ?>
        <div id="panel_filter_params">
            <form class="sky-form no_box_shadow">
                <label class="button" for="openFileButton" style="border-radius: 3px; float: left; margin: 0 0 10px 0;">Загрузить файл для настройки печати</label>
                <input id="openFileButton" type="file" hidden="true" name="test_file" onchange="if ($j(this)[0].value) $j('#sendFormButton').click();">
                <input type="submit" id="sendFormButton" class="button v2" cmd="print_order/save_print_order" print_order_id="<?echo $this->print_order_rec['pkey']?>" style="margin: 0 0 10px 0;" value="Сохранить">
                <table class="basic fz_small full left auto">
                    <tr>
                        <?$this->print_params_td('ID',$this->print_order_rec['type'],['element_class'=>'validate_number','name'=>'order_type','type'=>'text']);?>
                    </tr>
                    <tr>
                        <?$this->print_params_td('Наименование',$this->print_order_rec['obj_name'],['name'=>'obj_name','type'=>'text']);?>
                    </tr>
                    <tr>
                        <?$this->print_params_td('',$this->print_order_rec['_ext_info']['enable_stamp'],['name'=>'ext_info[enable_stamp]','type'=>'check_box','checkbox_title'=>'Печатать штамп','reload_img_on_change'=>1,'js_onChange'=>'togglePrintStamp(this);','tag_print_order_id'=>1]);?>
                    </tr>
                    <?if (!_sizeof($image_info)) {?>
                        <tr>
                            <td colspan="2" style="text-align: center;"><span class="red">Загрузите файл для настройки печати</span></td>
                        </tr>
                    <?} else {?>
                        <tr class="dependOnPrintStamp" <?if (!$this->print_order_rec['_ext_info']['enable_stamp']) echo 'hidden'?>>
                            <?$this->print_params_td('Штамп на странице №',$this->print_order_rec['_ext_info']['stamp_on_page'],['element_class'=>'validate_number','name'=>'ext_info[stamp_on_page]','type'=>'select','select_options'=>$page_number_options,'reload_img_on_change'=>1,'tag_print_order_id'=>1]);?>
                        </tr>
                        <tr class="dependOnPrintStamp" <?if (!$this->print_order_rec['_ext_info']['enable_stamp']) echo 'hidden'?>>
                            <?$this->print_params_td('X координата штампа',$this->print_order_rec['_ext_info']['stamp_X'],['name'=>'ext_info[stamp_X]','type'=>'range','min_range'=>0,'max_range'=>$page_values[$cur_page_name]['width'],'element_id'=>'set_stamp_width','reload_img_on_change'=>1]);?>
                        </tr>
                        <tr class="dependOnPrintStamp" <?if (!$this->print_order_rec['_ext_info']['enable_stamp']) echo 'hidden'?>>
                            <?$this->print_params_td('Y координата штампа',$this->print_order_rec['_ext_info']['stamp_Y'],['name'=>'ext_info[stamp_Y]','type'=>'range','min_range'=>0,'max_range'=>$page_values[$cur_page_name]['height'],'element_id'=>'set_stamp_height','reload_img_on_change'=>1]);?>
                        </tr>
                        <tr class="dependOnPrintStamp" <?if (!$this->print_order_rec['_ext_info']['enable_stamp']) echo 'hidden'?>>
                            <?$this->print_params_td('Увеличить штамп в N раз',$this->print_order_rec['_ext_info']['stamp_resize'],['name'=>'ext_info[stamp_resize]','type'=>'range','min_range'=>$size_min_ratio,'max_range'=>$size_max_ratio,'step_range'=>$size_step,'element_id'=>'set_stamp_resize','reload_img_on_change'=>1]);?>
                        </tr>
                        <tr class="dependOnPrintStamp" <?if (!$this->print_order_rec['_ext_info']['enable_stamp']) echo 'hidden'?>>
                            <?$this->print_params_td('Повернуть штамп на угол',$this->print_order_rec['_ext_info']['stamp_rotate_degrees'],['name'=>'ext_info[stamp_rotate_degrees]','type'=>'range','min_range'=>0,'max_range'=>360,'step_range'=>90,'element_id'=>'set_stamp_angle','show_value'=>1,'reload_img_on_change'=>1]);?>
                        </tr>
                        <tr class="dependOnPrintStamp" <?if (!$this->print_order_rec['_ext_info']['enable_stamp']) echo 'hidden'?>>
                            <?$this->print_params_td('PDF для печати',$this->print_order_rec['_ext_info']['type_of_get_PDF'],['element_id'=>'type_of_get_PDF','name'=>'ext_info[type_of_get_PDF]','type'=>'select','select_options'=>['common'=>'С общего URL','own'=>'С собственного URL']]);?>
                        </tr>
                        <tr class="dependOnPrintStamp" id="common_URL_tr" <?if ($this->print_order_rec['_ext_info']['type_of_get_PDF']=='own' or !$this->print_order_rec['_ext_info']['enable_stamp']) echo 'hidden'?>>
                            <?$this->print_params_td('Общий URL',$this->print_order_rec['_ext_info']['common_URL'],['colspan'=>3,'name'=>'ext_info[common_URL]','type'=>'text']);?>
                        </tr>
                        <tr class="dependOnPrintStamp" <?if (!$this->print_order_rec['_ext_info']['enable_stamp']) echo 'hidden'?>>
                            <?$this->print_params_td('',$this->print_order_rec['_ext_info']['consider_time'],['name'=>'ext_info[consider_time]','type'=>'check_box','checkbox_title'=>'Учитывать время действия']);?>
                        </tr>
                    <?}?>
                </table>
            </form>
        </div>
        <?
    }

    function print_params_td($th_name,$td_value,$options=[]) {
        ?>
        <th><?echo $th_name?></th>
        <td <?if ($options['colspan']) echo 'colspan="'.$options['colspan'].'"'?>>
            <?
            switch ($options['type']) {
                case 'check_box':
                    $this->param_td_checkBox($td_value,$options);
                    break;
                case 'select':
                    $this->param_td_select($td_value,$options);
                    break;
                case 'text':
                    $this->param_td_text($td_value,$options);
                    break;
                case 'range':
                    $this->param_td_range($td_value,$options);
                    break;
                case 'number':
                    $this->param_td_number($td_value,$options);
                    break;
                default:
                    echo $td_value;
            }
            ?>
        </td>
        <?
    }

    function param_td_checkBox($td_value,$options) {
        ?>
        <label class="checkbox">
            <input type="checkbox"
                <?if ($options['js_onChange']) echo 'onchange="'.$options['js_onChange'].'"'?>
                name="<?echo $options['name'] ?>"
                <?if ($options['tag_print_order_id']) echo 'print_order_id="'.$this->print_order_rec['pkey'].'"'?>
                value="1" <?if ($td_value) echo 'checked' ?>>
            <i></i><?echo $options['checkbox_title']?>
        </label>
        <?
    }

    function param_td_select($td_value,$options) {
        ?>
        <label class="select">
            <select <?if ($options['reload_img_on_change']) echo 'onchange="changeStampSelect(this)"';?>
                    class="full_str<?if ($options['element_class']) echo ' '.$options['element_class']?>"
                    <?if ($options['element_id']) echo 'id="'.$options['element_id'].'"'?>
                    name="<?echo $options['name']?>"
                    <?if ($options['tag_print_order_id']) echo 'print_order_id="'.$this->print_order_rec['pkey'].'"'?>
            >
                <?
                foreach ($options['select_options'] as $key=>$value) {
                    ?>
                    <option value="<?echo $key?>" <?if ($td_value==$key) echo 'selected'?>><?echo $value?></option>
                    <?
                }
                ?>
            </select>
            <i></i>
        </label>
        <?
    }

    function param_td_number($td_value,$options) {
        ?>
        <label class="input">
           <input type="number"
                  class="print_order_number"
                  name="<?echo $options['name']?>"
                  <?if ($options['id']) echo 'id="'.$options['id'].'"'?>
                  value="<?echo $td_value?>"
                  min="<?echo $options['min_range']?>"
                  max="<?echo $options['max_range']?>"
                  readonly
           >
        </label>
        <?
    }

    function param_td_text($td_value,$options) {
        ?>
        <label class="input">
            <input type="text" class="full_str<?if ($options['element_class']) echo ' '.$options['element_class']?>" name="<?echo $options['name']?>" <?if ($options['id']) echo 'id="'.$options['id'].'"'?> value="<?echo $td_value?>">
        </label>
        <?
    }

    function param_td_range($td_value,$options) {
        $onChange='';
        if ($options['show_value'] and $options['element_id']) $onChange='showChangeValue(this);'
        ?>
        <label class="range">
            <input type="range"
                   <?if ($options['element_id']) echo 'id="'.$options['element_id'].'"'?>
                   name="<?echo $options['name']?>"
                   min="<?echo $options['min_range']?>"
                   max="<?echo $options['max_range']?>"
                   <?if ($options['reload_img_on_change']) {echo 'print_order_id="'.$this->print_order_rec['pkey'].'"'; $onChange.=' changeStampSelect(this);';}?>
                   <?if ($onChange) echo 'onchange="'.$onChange.'"';?>
                   <?if ($options['step_range']) echo 'step="'.$options['step_range'].'"'?>
                   value="<?echo $td_value?>">
            <?if ($options['show_value'] and $options['element_id']) {
                ?>
                <span id="for_<?echo $options['element_id']?>"><?echo ($td_value)?$td_value:'0';?></span>
                <?
            }?>
        </label>
        <?
    }


    function preview_doc() {
        // отображает загруженный файл на странице
        // сохраняет изначальный настройки в файл file_order_Z.json
        // сохраняет каждую страницу в отдельный файл  file_order_Z_page_X.jpg
        $options=[]; $image_info=[];
        if ($this->print_order_rec['_ext_info']['test_file_path']) {
            $json_data_file=_DIR_TO_ROOT.PRINT_ORDER()->test_file_folder.'file_order_'.$this->print_order_rec['pkey'].'.json';
            file_put_contents($json_data_file,json_encode($this->print_order_rec['_ext_info']));

            $rec_mo=execSQL_van('select * from '.ESMO()->view_mo_session.' where dopusk=1 order by pkey desc limit 1');
            $options['test_file_path']=$this->print_order_rec['_ext_info']['test_file_path'];
            $options['copy_files_to_print_order_dir']=1;
            $images=PRINT_ORDER()->combine_print_order_images(['print_order_type'=>$this->print_order_rec['type']],$rec_mo,$options);
            if (_sizeof($images)) {
                foreach ($images['file_name'] as $image_name) {
                    $image_info[]=getimagesize(_DIR_TO_ROOT.PRINT_ORDER()->test_file_folder.$image_name);
                }
                PRINT_ORDER()->view_print_order_images($images['file_name'],['set_img_id'=>1,'img_class'=>'shadow']);
            } else {
                echo '<span class="red">Не удалось преобразовать загруженный файл</span>';
            }
        }
        return $image_info;
    }

}
?>
