<?
// работа фильтра $this->filter['cnt_days']
// период 180 дней, разбивка 30 дней
// периоды год и все время, разбивка по месяцам
// по дефолту выбран период 90 дней, разбивка по 10 дней
// var $cnt_days=array('1m'=>'1 месяц','3m'=>'3 месяца','6m'=>'16 месяцев','1y'=>'1 год','all'=>'все время') ;
class report_poll_stats3 extends c_report_graf
{
    var $title='Результаты контроля знаний - статистика - график' ;

    // подготовка данных для фильтра
    // var $cnt_days=array('1m'=>'1 месяц','3m'=>'3 месяца','6m'=>'16 месяцев','1y'=>'1 год','all'=>'все время') ;
    function get_fime_from_to_for_filter_cnt_days($cnt_days)
    { $tt=getdate() ;
      $time_from=0 ;
      $time_to = mktime(23,59,59,$tt['mon'],$tt['mday']+1,$tt['year']);
      switch($cnt_days)
      {   case '1m': $time_from=mktime(0,0,0,$tt['mon']-1,$tt['mday'],$tt['year']); break ;
          case '3m': $time_from=mktime(0,0,0,$tt['mon']-3,$tt['mday'],$tt['year']); break ;
          case '6m': $time_from=mktime(0,0,0,$tt['mon']-6,$tt['mday'],$tt['year']); break ;
          case '1y': $time_from=mktime(0,0,0,$tt['mon'],$tt['mday'],$tt['year']-1) ; break ;
          case 'all': $time_from=0 ; break ;
      }
      return([$time_from,$time_to]) ;
    }

    function get_arr_time_interval_for_filter_cnt_days($cnt_days)
    { if (!$cnt_days) $cnt_days='3m'; // по умолчанию значение 3 месяца - 90 дней
      list($time_from,$time_to)=$this->get_fime_from_to_for_filter_cnt_days($cnt_days) ;
      $t = $time_from; $arr=[] ;
      while($t <= $time_to)
      {
          $ts = getdate($t) ;
          $t1 = $t ;
          $cur_month = mktime(0,0,0,$ts['mon'],1,$ts['year']) ;
          $arr_month[$cur_month] = get_month_year($cur_month,'month year') ;
          $step=0 ;
          switch($cnt_days)
          {
              // период 180 дней, разбивка 30 дней
              case '6m':
                  $t = mktime(0,0,0,$ts['mon'],$ts['mday']+30,$ts['year']) ;
                  $t2 = $t-1;
                  $title = (date('y', $t1) == date('y', $t2)? date('d.m', $t1).'-'.date('d.m\'y', $t2):date('d.m\'y', $t1).'-'.date('d.m\'y', $t2));
                  $step='30d' ;
                  break  ;
              // периоды год и все время, разбивка по месяцам
              case '1y':
              case 'all':
                  $t = mktime(0,0,0,$ts['mon']+1,1,$ts['year']) ;
                  $t2 = $t-1;
                  $title = get_month_year($t1,'month year') ;
                  $step='1m' ;
                  break ;
              // по дефолту выбран период 90 дней, разбивка по 10 дней
              case '3m':
              case '1m':
              default:
                  $t = mktime(0,0,0,$ts['mon'],$ts['mday'] + 10,$ts['year']);
                  $t2 = $t-1;
                  $title = (date('y', $t1) == date('y', $t2)? date('d.m', $t1).'-'.date('d.m\'y', $t2): date('d.m\'y', $t1).'-'.date('d.m\'y', $t2));
                  $step='10d' ;
                  break ;
          }
          $arr[]=['cnt_days'=>$cnt_days,
                  'step'=>$step,
                  'from'=>$t1,
                  'to'=>$t2,
                  'from_text'=>date('d.m.Y H:i:s',$t1),
                  'to_text'=>date('d.m.Y H:i:s',$t2),
                  'title'=>$title,
                 ] ;


      }
      return($arr) ;
    }

    function prepare_data()
    {
        //if (MEMBER()->personal_viewer_name) $usl_str=' and personal_id in (select pkey from '.MEMBER()->personal_viewer_name.')' ;
        $data=[] ;
        $arr=$this->get_arr_time_interval_for_filter_cnt_days($this->filter['cnt_days']) ;
        //print_2x_arr($arr);
        if (_sizeof($arr)) foreach($arr as $rec)
        {
          $_usl=[] ;
          $_usl[]='poll_с_data>='.$rec['from'] ;
          $_usl[]='poll_с_data<='.$rec['to'] ;
          $usl=implode(' and ',$_usl) ;
          $data[htmlspecialchars($rec['title'])]['count_question'] = execSQL_value('select count(question_id) from view_poll_result where '.$usl);
        }
        return $data;
    }


    function print_template_HTML($list_recs,$options=array())
    {
        $data=$this->prepare_data() ;
        //print_2x_arr($data);
        $this->show_graf() ;
    }

    function show_graf()
    { ?><div id="<?echo $this->graf_div_id?>"></div>
         <script type="text/javascript">
            $j(document).ready(function(){
                FusionCharts.ready(function(){
                    var <?='js_'.$this->report_UID?> = new FusionCharts(
                        {
                        type: 'Column2D',
                        renderAt: '<? echo $this->graf_div_id?>',
                        width: '100%',
                        height: '<?echo $this->height_graf?>',
                        dataFormat: 'jsonurl', //'json', // dataSource будут подготвлены методом view_as_FusionCharts_JSON
                        dataSource: '/services/reports/json/poll/report_poll_stats3/[]/' // учесть возможность передачи параметров отчета скрипту
                        });

                    <?='js_'.$this->report_UID?>.render();
                });
            });
        </script>
        <?
    }

    function view_as_FusionCharts_JSON()
     {
         $data=$this->prepare_data() ;
         $arr=[] ;
         //if (_sizeof($data)) foreach($data as $title=>$rec) $arr[]='{"label":"'.$title.'","value":"'.$rec['count_question'].'"}';

         $arr_json=['chart'=>['caption'=>'Число сессии опросов',
                              //'subCaption'=>'In MMbbl = One Million barrels',
                              'xAxisName'=>'Дата',
                              'yAxisName'=>'Число сессий',
                              //'numberSuffix'=>'K',
                              //'theme'=>'fusion',
                              "showvalues"=>"0",
                              "numberSuffix"=>"%",
                              "plotfillalpha"=>"60",
                               "animation"=>"5",
                              "yAxisMaxValue"=>"100",
                              "yAxisMinValue"=>"100",
                              "showBorder"=>"0",
                              "bgColor"=>"#ffffff",
                              "palettecolors"=>"#0050aa"
                             ],
                    ] ;
         if (_sizeof($data)) foreach($data as $title=>$rec) $arr_json['data'][]=['label'=>$title,'value'=>$rec['count_question']];
         return($arr_json) ;
     }

}

?>
