<?php
include_once("c_pl.php");
class c_page_cab_pl_docs extends c_page_cab_pl
{
 public $h1='ПЛ - документация шлюза' ;

 function block_main()
 {
   //$this->page_title() ;
   ?>

     <h1>Работа с API шлюза <?echo _MAIN_DOMAIN?></h1>
     <p>Доступ к API разрешен только для авторизованных клиентов. Авторизация осуществляется через токен авторизации, который необходимо передать в заголоке запроса.</p>
     <p>Добавление нового клиента API производится на странице <a href="/cab/esmo_gateway/clients/" target="_blank">Клиенты API"</a>.</p>
     <p>При добавлении нового клиента необходимо указать тип авторизации "по токену", токен будет сгенерирован автоматически.<p>
     <p>При выполнении запроса токен передается в заголовке запроса: "Authorization: Token b73fc83d08eceffd872643c533685515"<p>
     <p>При обращении к API с неизвестным токеном, или при его отсутствии, будет сформирован ответ о отказе в доступе:</p>
     <pre data-enlighter-language="less">
&lt;?xml version="1.0" encoding="utf-8"?&gt;
    <error date="2024-02-09 10:47">
        <code>access_denied for 94.250.248.121</code>
        <ip>94.250.248.121</ip>
    </error>
    </pre>


     <br><br><h1>Отправка в ЭСМО XML-пакета с титул1 и подписью</h1>
           <strong>URL запроса:</strong>:  https://<?echo _MAIN_DOMAIN?>/services/pl/put_titul_1/<br>
           <strong>Тип содержимого: </strong>  multipart/form-data, в соответствии с правилами для составных MIME-данных в соответствии с RFC 2045. Сообщение multipart/form-data должно содержать две части, в первой части передается XML-файл, во втором - его подпись.<br>
           <strong>Статус ответа сервера:</strong>: 200<br>
           <strong>Формат ответа сервера:</strong>: XML<br>
           <strong>Пример ответа сервера:</strong>:<br>
         <?$content='<?xml version="1.0" encoding="windows-1251"?>
<results date="2024-02-26 12:03">
    <result>success</result>
</results>'?>
         <pre data-enlighter-language="less"><?echo ENGINE()->htmlentities_open_tag($content);?>
          </pre>

     <br><br><h1>Отправка в ЭСМО XML-пакета с титул5 и подписью</h1>
           <strong>URL запроса:</strong>:  https://<?echo _MAIN_DOMAIN?>/services/pl/put_titul_5/<br>
           <strong>Тип содержимого: </strong>  multipart/form-data, в соответствии с правилами для составных MIME-данных в соответствии с RFC 2045. Сообщение multipart/form-data должно содержать две части, в первой части передается XML-файл, во втором - его подпись.<br>
           <strong>Статус ответа сервера:</strong>: 200<br>
           <strong>Формат ответа сервера:</strong>: XML<br>
           <strong>Пример ответа сервера:</strong>:<br>
         <?$content='<?xml version="1.0" encoding="windows-1251"?>
<results date="2024-02-26 12:03">
    <result>success</result>
</results>'?>
         <pre data-enlighter-language="less"><?echo ENGINE()->htmlentities_open_tag($content);?>
          </pre>

     <br><br><h1>Получение из ЭСМО списка подготовленных к выдаче титул2 и титул6</h1>
           <strong>URL запроса:</strong>:  https://<?echo _MAIN_DOMAIN?>/services/pl/get_titul/<br>
           <strong>Статус ответа сервера:</strong>: 200<br>
           <strong>Формат ответа сервера:</strong>: XML<br>
           <strong>Пример ответа сервера:</strong>:<br>
         <?$content='<?xml version="1.0" encoding="utf-8"?>
 <packets date="2024-02-26 12:13">
   <packet id="23">
     <pl_uid>55117f51-2ed3-493b-b9ef-ce61f22c0adc</pl_uid>
     <file_uid>ON_PTLSSOBTS_2AE107EE4B9-CC1F-4039-8AFC-3FA6E47B8A48_2AE107EE4B9-CC1F-4039-8AFC-3FA6E47B8A48_2AE107EE4B9-CC1F-4039-8AFC-3FA6E47B8A48_2AE107EE4B9-CC1F-4039-8AFC-3FA6E47B8A48_0_20230616_5012988b-a0b8-4893-92c9-2a9b7061bcb3</file_uid>
     <download_packet_url>https://<?echo _MAIN_DOMAIN?>/services/pl/get_packet/23/</download_packet_url>
     <download_sign_url>https://<?echo _MAIN_DOMAIN?>/services/pl/get_packet_sign/23/</download_sign_url>
   </packet>
   <packet id="24">
     <pl_uid>55117f51-2ed3-493b-b9ef-ce61f22c0adc</pl_uid>
     <file_uid>ON_PTLSSOBTS_2AE107EE4B9-CC1F-4039-8AFC-3FA6E47B8A48_2AE107EE4B9-CC1F-4039-8AFC-3FA6E47B8A48_2AE107EE4B9-CC1F-4039-8AFC-3FA6E47B8A48_2AE107EE4B9-CC1F-4039-8AFC-3FA6E47B8A48_0_20230616_5012988b-a0b8-4893-92c9-2a9b7061bcb3</file_uid>
     <download_packet_url>https://<?echo _MAIN_DOMAIN?>/services/pl/get_packet/24/</download_packet_url>
     <download_sign_url>https://<?echo _MAIN_DOMAIN?>/services/pl/get_packet_sign/24/</download_sign_url>
   </packet>
 </packets>'?>
         <pre data-enlighter-language="less"><?echo ENGINE()->htmlentities_open_tag($content);?>
          </pre>
     <br><h2>Описание тегов XML</h2>
            <table class="basic fz_normal left">
                <tr><td>packets</td><td></td><td>Контейнер списка подготовленных пакетов титул2(6). Находиться в корне документа</td></tr>
                <tr><td>item</td><td></td><td>Контейнер описания пакета. Находиться в контейнере packets</td></tr>
                <tr><td>pl_uid</td><td>string(128)</td><td>UID путевого листа</td></tr>
                <tr><td>file_uid</td><td>string(256)</td><td>UID файла пакета титул1(5)</td></tr>
                <tr><td>download_packet_url</td><td>text</td><td>Ссылка на скачивание файла XML титул2(6)</td></tr>
                <tr><td>download_sign_url</td><td>text</td><td>Ссылка на скачивание файла подписи XML</td></tr>
            </table>


    <br><br><h1>Получение данных по медорганизации</h1>
      <strong>URL запроса:</strong>: https://<?echo _MAIN_DOMAIN?>/services/pl/get_med_orgs/<br>
      <strong>Статус ответа сервера:</strong>: 200<br>
      <strong>Формат ответа сервера:</strong>: XML<br>
      <strong>Пример ответа сервера:</strong>:<br>
     <pre data-enlighter-language="less">
         &lt;?xml version="1.0" encoding="utf-8"?&gt;
     &lt;report_med_orgs date="2024-02-09 10:20"&gt;
       &lt;item uid="5451dfcde8a1a41860d04e823ccefe23"&gt;
         &lt;name_short_with_opf&gt;ФГКУ ПОЛИКЛИНИКА № 5&lt;/name_short_with_opf&gt;
         &lt;name_full_with_opf&gt;ФЕДЕРАЛЬНОЕ ГОСУДАРСТВЕННОЕ КАЗЕННОЕ УЧРЕЖДЕНИЕ "ПОЛИКЛИНИКА № 5"&lt;/name_full_with_opf&gt;
         &lt;inn&gt;7719106792&lt;/inn&gt;
         &lt;kpp&gt;123-22-22&lt;/kpp&gt;
         &lt;ogrn&gt;1027739660080&lt;/ogrn&gt;
         &lt;email&gt;mail@mail.ru&lt;/email&gt;
         &lt;phone&gt;77166127222&lt;/phone&gt;
         &lt;adres1&gt;105264, г Москва, р-н Измайлово, ул 10-я Парковая, д 15А&lt;/adres1&gt;
         &lt;adres2&gt;105264, г Москва, р-н Измайлово, ул 10-я Парковая, д 15А&lt;/adres2&gt;
         &lt;license&gt;123-282&lt;/license&gt;
         &lt;license_data_from&gt;01.01.2024&lt;/license_data_from&gt;
         &lt;license_data_to&gt;01.01.2026&lt;/license_data_to&gt;
       &lt;/item&gt;
     &lt;/report_med_orgs&gt;
     </pre>
        <br><h2>Описание тегов XML</h2>
        <table class="basic fz_normal left">
            <tr><td>report_med_orgs</td><td></td><td>Контейнер списка медорганиазций. Находиться в корне документа</td></tr>
            <tr><td>item</td><td></td><td>Контейнер описания медорганиазции. Должен находиться в контейнере report_med_orgs</td></tr>
            <tr><td>name_short_with_opf</td><td>string(128)</td><td>Краткое наименование</td></tr>
            <tr><td>name_full_with_opf</td><td>string(256)</td><td>Полное наименование</td></tr>
            <tr><td>inn</td><td>string(12)</td><td>ИНН</td></tr>
            <tr><td>kpp</td><td>string(12)</td><td>КПП</td></tr>
            <tr><td>ogrn</td><td>string(12)</td><td>ОГРН</td></tr>
            <tr><td>email</td><td>string(256)</td><td>Email</td></tr>
            <tr><td>phone</td><td>string(11)</td><td>Телефон, только числа без знаков +,-,(,)</td></tr>
            <tr><td>adres1</td><td>string(256)</td><td>Адрес юридический</td></tr>
            <tr><td>adres2</td><td>string(256)</td><td>Адрес фактический</td></tr>
            <tr><td>license</td><td>string(256)</td><td>Серия, номер лицензии</td></tr>
            <tr><td>license_data_from</td><td>string(10)</td><td>Дата начала действия лицензии</td></tr>
            <tr><td>license_data_to</td><td>string(10)</td><td>Дата окончания действия лицензии</td></tr>
        </table>
     <?


    ?><br><br><h1>Получение данных по директору медорганизации</h1><?
    ?><strong>URL запроса:</strong>: https://<?echo _MAIN_DOMAIN?>/services/pl/get_med_director/<br>
      <strong>Статус ответа сервера:</strong>: 200<br>
      <strong>Формат ответа сервера:</strong>: XML<br>
      <strong>Пример ответа сервера:</strong>:<br>
    <pre data-enlighter-language="less">
    &lt;?xml version="1.0" encoding="utf-8"?&gt;
     &lt;report_med_directors date="2024-02-09 10:29"&gt;
       &lt;item uid=""&gt;
         &lt;org_uid&gt;5451dfcde8a1a41860d04e823ccefe23&lt;/org_uid&gt;
         &lt;org_uid_1c&gt;b4d04c97cb90e5e701786ddd87409ae0&lt;/org_uid_1c&gt;
         &lt;name&gt;Иванова Ольга Сергеевна&lt;/name&gt;
         &lt;inn&gt;7719106791&lt;/inn&gt;
         &lt;snils&gt;123-736-7173 77&lt;/snils&gt;
         &lt;job_title&gt;Директор&lt;/job_title&gt;
         &lt;date_birth&gt;01.12.1980&lt;/date_birth&gt;
         &lt;place_birth&gt;г.Москва&lt;/place_birth&gt;
         &lt;gender&gt;2&lt;/gender&gt;
         &lt;email&gt;women@ya.ru&lt;/email&gt;
         &lt;phone&gt;7976 7151212&lt;/phone&gt;
       &lt;/item&gt;
     &lt;/report_med_directors&gt;
     </pre>
        <br><h2>Описание тегов XML</h2>
        <table class="basic fz_normal left">
            <tr><td>report_med_directors</td><td></td><td>Контейнер списка директоров медорганиазций. Находиться в корне документа</td></tr>
            <tr><td>item</td><td></td><td>Контейнер описания директоров медорганиазции. Должен находиться в контейнере report_med_directors</td></tr>
            <tr><td>org_uid</td><td>string(128)</td><td>UID организации директора</td></tr>
            <tr><td>org_uid_1c</td><td>string(128)</td><td>UID 1С организации директора</td></tr>
            <tr><td>name</td><td>string(256)</td><td>ФИО</td></tr>
            <tr><td>inn</td><td>string(12)</td><td>ИНН</td></tr>
            <tr><td>snils</td><td>string(12)</td><td>СНИЛС</td></tr>
            <tr><td>job_title</td><td>string(256)</td><td>Должность</td></tr>
            <tr><td>date_birth</td><td>string(10)</td><td>Дата рождения</td></tr>
            <tr><td>place_birth</td><td>string(256)</td><td>Место рождения</td></tr>
            <tr><td>gender</td><td>int</td><td>Пол, 1-мужской, 2-женский</td></tr>
            <tr><td>email</td><td>string(256)</td><td>Email</td></tr>
            <tr><td>phone</td><td>string(11)</td><td>Телефон, только числа без знаков +,-,(,)</td></tr>
        </table>
     <?

    ?><br><br><h1>Задание UID 1C для медорганизации</h1><?
    ?><strong>URL запроса:</strong>: https://<?echo _MAIN_DOMAIN?>/services/pl/set_med_orgs_uid/<br>
      <strong>Метод запроса:</strong>: POST<br>
      <strong>Формат содержимого запроса:</strong>: XML<br>
      <strong>Статус ответа сервера:</strong>: 200<br>
      <strong>Формат ответа сервера:</strong>: XML<br>
      <strong>Пример запроса к серверу:</strong>:<br>
<pre data-enlighter-language="less">
     &lt;?xml version="1.0" encoding="utf-8"?&gt;
             <set_med_orgs_uid date="2024-02-09 00:07">
                 <item uid="5451dfcde8a1a41860d04e823ccefe23">
                 <uid_1c>fba2926f1829bf198d331dc8ef178cb0</uid_1c>
               </item>
             </set_med_orgs_uid>
     </pre>
     <br><h2>Описание тегов XML запроса</h2>
             <table class="basic fz_normal left">
                 <tr><td>set_med_orgs_uid</td><td></td><td>Контейнер списка соответствий UID. Находиться в корне документа</td></tr>
                 <tr><td>item</td><td></td><td>Контейнер соответствия UID. Должен находиться в контейнере report_med_directors</td></tr>
                 <tr><td>uid_1c</td><td>string(128)</td><td>UID 1С организации</td></tr>
             </table>

      <strong>Пример ответа сервера:</strong>:<br>
<pre data-enlighter-language="less">
     <result date="2024-02-09 11:08">success</result>
     </pre>
        <br><h2>Описание тегов XML</h2>
        <table class="basic fz_normal left">
            <tr><td>result</td><td></td><td>Контейнер результата операции. Находиться в корне документа</td></tr>
        </table>


     <br><br><br><br><br><br><br>



     <h1>Запросы проверок</h1>



     <h2>Отправить в ЭСМО 1-й титул (корректный)</h2>
     <h3>Описание</h3>
     <p>
         API-запрос предназначен для отправки титула 1, содержащего XML-файл и файл электронной подписи для проверки и регистрации на сервере. Данный API позволяет загрузить два файла: основной XML-документ с данными и связанный с ним файл подписи .sign.
     </p>
     <h3>URL</h3>
     <pre data-enlighter-language="less">POST /services/pl/put_titul_1/</pre>
     <h3>Параметры запроса</h3>
     Запрос отправляется методом POST и должен содержать два файла в формате multipart/form-data:

     document (обязательный): XML-файл, содержащий данные титула. Пример файла: 1.xml.
     signature (обязательный): файл с электронной подписью, которая соответствует XML-документу. Пример файла: 1.sign.

     <h3>Формат файла XML (document)</h3>


     <p>XML-документ должен включать такие ключевые атрибуты и элементы:</p>

     ИдФайл: уникальный идентификатор файла.<br>
     Документ: содержит основные данные титула, включая:
     КНД: код классификации документа.<br>
     ДатИнфСоб и ВрИнфСоб: дата и время формирования информации.<br>
     НомерПЛ: номер путевого листа.<br>
     СодИнфСоб: данные о содержании, включающие информацию о транспортном средстве, водителе и организации.<br>
     ФИО: ФИО директора.<br>
     <h3>Пример XML-файла (document)</h3>

     <pre data-enlighter-language="less">
&lt;?xml version="1.0" encoding="windows-1251"?&gt;
&lt;Файл ИдФайл="ON_PTLSSOBTS_2AE107EE4B9-CC1F-4039-8AFC-3FA6E47B8A48_0_20230616"&gt;
    &lt;Документ КНД="1110380" ДатИнфСоб="16.06.2023" ВрИнфСоб="17:17:18" НомерПЛ="00000000007"&gt;
        &lt;СодИнфСоб УИД_ПЛ="55117f51-2ed3-493b-b9ef-ce61f22c0add"&gt;
            &lt;СвТС&gt;
                &lt;ТС Тип="Грузовой" Марка="КамАЗ" Модель="6720" РегНомер="О123ОО"/&gt;
            &lt;/СвТС&gt;
            &lt;СвВодит&gt;
                &lt;ВодитУд НомВУ="301238" СерВУ="7708" ДатаВыдВУ="01.01.2021"/&gt;
                &lt;ФИО Фамилия="Журавков" Имя="Игорь" Отчество="Викторович"/&gt;
            &lt;/СвВодит&gt;
        &lt;/СодИнфСоб&gt;
        &lt;ПодпИнфСоб Должн="Директор"&gt;
            &lt;ФИО Фамилия="Гузеев" Имя="Александр" Отчество="Максимович"/&gt;
        &lt;/ПодпИнфСоб&gt;
    &lt;/Документ&gt;
&lt;/Файл&gt;

     </pre>
     <h3>Пример файла подписи (signature)</h3>
     <p>
         Файл 1.sign содержит электронную подпись XML-документа 1.xml, которая гарантирует целостность и подлинность передаваемых данных.
     </p>
     <h3>Пример файла подписи (signature)</h3>
     <pre data-enlighter-language="less">
POST /services/pl/put_titul_1/ HTTP/1.1
Host: <?echo _MAIN_DOMAIN?>
Content-Type: multipart/form-data; boundary=boundary123

--boundary123
Content-Disposition: form-data; name="document"; filename="1.xml"
Content-Type: application/xml

&lt;XML content from 1.xml&gt;
--boundary123
Content-Disposition: form-data; name="signature"; filename="1.sign"
Content-Type: application/octet-stream

&lt;Binary signature content from 1.sign&gt;
--boundary123--
     </pre>





     <h2>Отправить в ЭСМО 1-й титул (неиз.вод.)</h2>
     <h3>Описание</h3>
     <p>
         API-запрос предназначен для отправки титула 1 с неизвестным водителем. Запрос содержит XML-файл с данными о транспортном средстве, организации и водителе, а также файл электронной подписи для проверки и регистрации на сервере.
     </p>
     <h3>URL</h3>
     <pre data-enlighter-language="less">POST /services/pl/put_titul_1/</pre>

     <h3>Параметры запроса</h3>
     Запрос отправляется методом POST и должен содержать два файла в формате multipart/form-data:

     - **document** (обязательный): XML-файл, содержащий данные титула. Пример файла: 1_error.xml.
     - **signature** (обязательный): файл с электронной подписью, которая соответствует XML-документу. Пример файла: 1_error.sign.

     <h3>Формат файла XML (document)</h3>

     <p>XML-документ должен включать следующие ключевые атрибуты и элементы:</p>

     - **ИдФайл**: уникальный идентификатор файла.<br>
     - **Документ**: содержит основные данные титула, включая:<br>
     - **КНД**: код классификации документа.<br>
     - **ДатИнфСоб** и **ВрИнфСоб**: дата и время формирования информации.<br>
     - **НомерПЛ**: номер путевого листа.<br>
     - **СодИнфСоб**: данные о содержании, включающие информацию о транспортном средстве, водителе и организации.<br>
     - **ФИО**: ФИО директора.

     <h3>Пример XML-файла (document)</h3>

     <pre data-enlighter-language="less">
&lt;?xml version="1.0" encoding="WINDOWS-1251"?&gt;
&lt;Файл ИдФайл="titul_1_error" ВерсПрог="АстралЭПД" ВерсФорм="5.01"&gt;
    &lt;Документ КНД="1110380" ДатИнфСоб="05.03.2024" ВрИнфСоб="13:38:27" НомерПЛ="000042559" ДатаПЛ="05.03.2024" ПризнНачРейс="1"&gt;
        &lt;СодИнфСоб УИД_ПЛ="207eb257-8b64-4e7a-8da7-462b51bef0c4" ОбМедОсмПосле="1" ВидПрв="КП" ВидКП="РП" ВидСообщ="Г"&gt;
            &lt;СрокПЛ ПЛДень="1" ДатаИспПЛ="05.03.2024"/&gt;
            &lt;СвЛицПЛ ЛицоОфПЛ="С"&gt;
                &lt;ИдСв&gt;
                    &lt;СвЮЛУч НаимОрг="Общество с ограниченной ответственностью &quot;Структура&quot;" ИННЮЛ="9618412324" КПП="999901001" ОГРН="1284132584284"/&gt;
                &lt;/ИдСв&gt;
                &lt;Адрес&gt;
                    &lt;АдрРФ Индекс="353901" КодРегион="23" Город="Новороссийск г" Улица="Портовая ул" Дом="14"/&gt;
                &lt;/Адрес&gt;
                &lt;Контакт&gt;
                    &lt;Тлф&gt;+7 (343) 333-33-33&lt;/Тлф&gt;
                &lt;/Контакт&gt;
            &lt;/СвЛицПЛ&gt;
            &lt;СвТС&gt;
                &lt;ТС Тип="Грузовые автомобили" Марка="ФОРД" Модель="ФОРД-Транзит (фургон)" РегНомер="В460СХ799"/&gt;
            &lt;/СвТС&gt;
            &lt;СвВодит&gt;
                &lt;ВодитУд НомВУ="7706859968" СерВУ="7706" ДатаВыдВУ="27.02.2024"/&gt;
                &lt;ФИО Фамилия="Иванов" Имя="Иван" Отчество="Иванович"/&gt;
            &lt;/СвВодит&gt;
        &lt;/СодИнфСоб&gt;
        &lt;ПодпИнфСоб Должн="Директор" ТипПодпис="1" СпосПодтПолном="1"&gt;
            &lt;ФИО Фамилия="Структурная" Имя="Структура" Отчество="Тестовна"/&gt;
        &lt;/ПодпИнфСоб&gt;
    &lt;/Документ&gt;
&lt;/Файл&gt;
</pre>

     <h3>Пример файла подписи (signature)</h3>
     <p>
         Файл 1_error.sign содержит электронную подпись XML-документа 1_error.xml, которая гарантирует целостность и подлинность передаваемых данных.
     </p>

     <h3>Пример запроса</h3>
     <pre data-enlighter-language="less">
POST /services/pl/put_titul_1/ HTTP/1.1
Host: <?echo _MAIN_DOMAIN?>
Content-Type: multipart/form-data; boundary=boundary123

--boundary123
Content-Disposition: form-data; name="document"; filename="1_error.xml"
Content-Type: application/xml

&lt;XML content from 1_error.xml&gt;
--boundary123
Content-Disposition: form-data; name="signature"; filename="1_error.sign"
Content-Type: application/octet-stream

&lt;Binary signature content from 1_error.sign&gt;
--boundary123--
</pre>






     <h2>Отправить в ЭСМО 5-й титул</h2>
     <h3>Описание</h3>
     <p>
         API-запрос предназначен для отправки данных 5-го титула в ЭСМО. Запрос включает XML-файл с информацией о заезде, транспортном средстве, уполномоченном лице и водителе, а также файл электронной подписи для проверки и регистрации на сервере.
     </p>
     <h3>URL</h3>
     <pre data-enlighter-language="less">POST /services/pl/put_titul_5/</pre>

     <h3>Параметры запроса</h3>
     Запрос отправляется методом POST и должен содержать два файла в формате multipart/form-data:

     - **document** (обязательный): XML-файл, содержащий данные титула. Пример файла: 5_error.xml.
     - **signature** (обязательный): файл с электронной подписью, соответствующей XML-документу. Пример файла: 5_error.sign.

     <h3>Формат файла XML (document)</h3>
     <p>XML-документ должен включать следующие ключевые атрибуты и элементы:</p>

     - **ИдФайл**: уникальный идентификатор файла.<br>
     - **Документ**: содержит основные данные титула, включая:<br>
     - **КНД**: код классификации документа.<br>
     - **ДатИнфЗаезд** и **ВрИнфЗаезд**: дата и время формирования информации.<br>
     - **СодИнфЗаезд**: данные о заезде, включая информацию о транспортном средстве и уполномоченном лице.<br>
     - **ФИО**: ФИО уполномоченного лица.

     <h3>Пример XML-файла (document)</h3>
     <pre data-enlighter-language="less">
&lt;?xml version="1.0" encoding="WINDOWS-1251"?&gt;
&lt;Файл ИдФайл="titul_5_error" ВерсПрог="АстралЭПД" ВерсФорм="5.01"&gt;
    &lt;Документ КНД="1110384" ДатИнфЗаезд="07.03.2024" ВрИнфЗаезд="09:26:51"&gt;
        &lt;СодИнфЗаезд УИД_ПЛ="0ed3fe80-2e70-4d00-8f43-5047feaa9f4e" ПризнКонцРейс="1"&gt;
            &lt;СвОдомЗаезд ДатВрЗаезд="07.03.2024T09:26:49+03:00" НалКоорТочВрЗаезд="1" ОдомЗаезд="36000"/&gt;
            &lt;СвУплЛиц Должн="Медик"&gt;
                &lt;ФИО Фамилия="Вавилов" Имя="Сергей" Отчество="Сергеевич"/&gt;
            &lt;/СвУплЛиц&gt;
        &lt;/СодИнфЗаезд&gt;
        &lt;ПодпИнфЗаезд Должн="Уполномоченное лицо" ТипПодпис="1" СпосПодтПолном="1"&gt;
            &lt;ФИО Фамилия="Петров" Имя="Алексей" Отчество="Владимирович"/&gt;
        &lt;/ПодпИнфЗаезд&gt;
    &lt;/Документ&gt;
&lt;/Файл&gt;
</pre>

     <h3>Пример файла подписи (signature)</h3>
     <p>
         Файл 5_error.sign содержит электронную подпись XML-документа 5_error.xml, обеспечивающую целостность и подлинность передаваемых данных.
     </p>

     <h3>Пример запроса</h3>
     <pre data-enlighter-language="less">
POST /services/pl/put_titul_5/ HTTP/1.1
Host: <?echo _MAIN_DOMAIN?>
Content-Type: multipart/form-data; boundary=boundary123

--boundary123
Content-Disposition: form-data; name="document"; filename="5_error.xml"
Content-Type: application/xml

&lt;XML content from 5_error.xml&gt;
--boundary123
Content-Disposition: form-data; name="signature"; filename="5_error.sign"
Content-Type: application/octet-stream

&lt;Binary signature content from 5_error.sign&gt;
--boundary123--
</pre>




     <?

 }



}



?>
