<?
function CAR_IMPORT(){ if (!is_object($GLOBALS['CAR_IMPORT'])) $GLOBALS['CAR_IMPORT']=new i_car_import();return($GLOBALS['CAR_IMPORT']);}
include_once(_DIR_TO_MODULES.'/engine/i_backgroup_process.php') ;
class i_car_import  extends i_backgroup_process_exec
{
  var $db_debug=0;
  var $import_begin_time=0;
  var $read_only=0;
  var $full_update=0;
  var $import_result=array();

  var $table_car ;


  public $org_otdel_create=0 ;
  public $fz_create=0 ;
  public $fz_update=0 ;

  public $session_uid ;

  var $log_fname='' ;
  var $log_bash='' ;
  var $page_output='' ;
  var $view_source='' ;

  var $source_fname='' ;
  var $t_exec=0 ;

  // список полей, которые будут проверяться на изменения при импорте ФЛ
    var $arr_car_fields=array('Номер авто'=>'obj_name',
        'Модель'=>'model',
        'Тип авто'=>'type',
        'Дата покончания ОСАГО'=>'e_osago',
        'Дата покончания СТС'=>'e_sts',
        'Дата покончания ГТО'=>'e_gto',
    ) ;

  // при создании объекта в обычном режиме параметры передаюся через $options
  // при вызове в фоновом режиме - параметры передаются через POST
  function __construct($options=array())
  {  parent::__construct($options) ;

     $this->table_car='temp_import_car_'.$this->session_uid ;

     $this->read_only=($options['read_only'])? $options['read_only']:$_GET['read_only'] ;
     $this->view_source=($options['view_source'])? $options['view_source']:$_GET['view_source'] ;
     $this->full_update=($options['full_update'])? $options['full_update']:$_GET['full_update'] ;
     $this->source_fname=($options['source_fname'])? $options['source_fname']:$_GET['source_fname'] ;
     $this->log_fname=FILE_LOG($this->session_uid)->log_fname ;
     $this->page_output='/temp/result_page_'.$this->session_uid.'.html' ;
     $this->log_bash='/temp/log_bash_'.$this->session_uid.'.txt' ;
  }

  function delete_temp_tables()
  {
	 execSQL_update('drop table '.$this->table_car) ;
  }

  function connect_SOURCE($fname="")
  {
  }

  function defined_vars()
  {   define('ORG_NAME','org_name') ;
      define('UID_CAR','UID') ;
  }

 function create_temp_tables()
     {   FILE_LOG()->append('create_temp_tables: start') ;

         execSQL_update('DROP TABLE  IF EXISTS '.$this->table_car) ;

         //create_object_table(0,$this->table_fz,$this->table_fz,211)  ;
         //create_object_table(0,$this->table_so,$this->table_fz,212)  ;
         $arr_fields=array() ;
         $arr_fields[]='ai_key int(11) auto_increment' ;
         $arr_fields[]='uid varchar(128) DEFAULT ""' ;
         $arr_fields[]='model varchar(128) DEFAULT ""' ;
         $arr_fields[]='obj_name varchar(40) NULL' ;
         $arr_fields[]='type varchar(64) NULL' ;
         $arr_fields[]='e_osago int(11) NULL' ;
         $arr_fields[]='e_sts int(11) NULL' ;
         $arr_fields[]='e_gto int(11) NULL' ;
         $arr_fields[]='enabled int(1) DEFAULT 1' ;

         $arr_fields[]='org_id int(11) NULL' ;
         $arr_fields[]='car_id int(11) NULL' ;
         $arr_fields[]='org_name varchar(255) NULL' ; // нужно для блокировки создания записей при отстутствии поля Организация
         //
         //$arr_fields[]='work_status varchar(10) DEFAULT ""' ;
         $arr_fields[]='primary key (ai_key)' ;
         $arr_fields[]='key (uid)' ;
         $arr_fields[]='key (car_id)' ;
         $sql='CREATE TABLE  '.$this->table_car.' ('.implode(',',$arr_fields).') ENGINE = InnoDB DEFAULT CHARSET=utf8' ;
         execSQL_update($sql,array('debug'=>0)) ;

     FILE_LOG()->append('create_temp_tables: end') ;
 }

 // пересим данные из ИСТОЧНИКА в таблицу soap_xml_block в формате "как есть"
  function parse_SOURCe_gto_DB()
  {
  }

    // формируем на основании '.$this->table_so.' таблицу сотрудников уже с указателями на сушности ESMO
      function sync_TEMP_DB_ESMO()
      {  FILE_LOG()->append('sync_TEMP_DB_ESMO: start') ;
         $this->flog_append('Начинаем синхронизировать загруженные данные с таблицами ЭСМО [sync_TEMP_DB_ESMO]') ;
         $this->flog_append('Заполяем org_id в '.$this->table_car) ;
         $cnt=execSQL_update('update '.$this->table_car.' t1 set t1.org_id=(select t2.pkey from obj_site_personals t2 where t2.clss=207 and t2.obj_name=t1.'.ORG_NAME.' order by t2.pkey limit 1);') ;
         $this->flog_append('Заполяем org_id в '.$this->table_car.' - заполено '.$cnt.' строк') ;
         ?><strong>Анализ организаций</strong><br><?
         echo 'Записей с существующими организациями: <strong>'.$cnt.'</strong><br>';
         $recs=execSQL_line('select DISTINCT('.ORG_NAME.') from '.$this->table_car.' where (org_id=0 or org_id is null) and enabled=1') ;
         $this->flog_append('Найдено '._sizeof($recs).' новых организаций') ;
         $read_only_status=($this->read_only)? ' <span class="red">READ ONLY</span>':'' ;
         if (_sizeof($recs))
         { foreach($recs as $org_name)  if ($org_name)
           { if (!$this->read_only) PERSONAL()->create_org(array('obj_name'=>$org_name)) ;
             echo '<div class="green">Добавлена организация <strong>"'.$org_name.'"</strong>'.$read_only_status.'</div>' ;
             $this->flog_append('Добавлена организация:'.$org_name) ;
             $this->org_otdel_create++ ;
           }
           $this->flog_append('Заполяем org_id в '.$this->table_car) ;
           $cnt=execSQL_update('update '.$this->table_car.' t1 set t1.org_id=(select t2.pkey from obj_site_personals t2 where t2.clss=207 and t2.obj_name=t1.'.ORG_NAME.'  order by t2.pkey limit 1);') ;
           $this->flog_append('Заполяем org_id в '.$this->table_car.' - заполено '.$cnt.' строк') ;
           echo 'Обновлены  <strong>'.$cnt.'</strong> cтрок с новыми организациями<br>' ;
         }

         ?><strong>Анализ автомобилей</strong><br><?
      execSQL_update('update '.$this->table_car.' t1 set car_id=(select t2.pkey from obj_site_personals_cars t2 where t2.clss=363 and t2.uid=t1.uid limit 1) where (t1.car_id=0 or t1.car_id is null) and t1.uid!=""') ;
      $cnt=execSQL_value('select count(*) from '.$this->table_car.' where car_id>0') ;
          echo 'Автомобили, найдено записей по UID: <strong>'.$cnt.'</strong><br>';

          $recs=execSQL('select * from '.$this->table_car.' where car_id is null or car_id=0',0,1) ;
          if (_sizeof($recs))
          { foreach($recs as $i=>$rec) if ($rec['enabled'] /*and $rec['org_name'] */and $rec['obj_name'])
            { if (!$this->read_only) TO()->car_create($rec,array('use_multiinsert'=>0,'source_fname'=>$this->setting['upload_fname'])) ;
              $this->flog_append('Создан автомобиль, '.$i.' из '._sizeof($recs)) ;
              echo '<div class="green">Автомобиль, добавлена запись <strong>"'.$rec['obj_name'].'"</strong>'.$read_only_status.'</div>' ;
              $this->fz_create++ ;
            }
            //else if (!$rec['org_name'])  echo '<div class="red">Заблокировано добавление ФЛ для UID <strong>"'.$rec['uid'].'"</strong> - не задана организация</div>' ;
            else if (!$rec['obj_name'])  echo '<div class="red">Заблокировано добавление авто для UID <strong>"'.$rec['uid'].'"</strong> - не задано Гос. номер</div>' ;
            //multiSQL_insert(PERSONAL()->table_personal)->flush() ;
            $cnt=execSQL_update('update '.$this->table_car.' t1 set t1.car_id=(select t2.pkey from obj_site_personals_cars t2 where t2.clss=363 and t2.uid=t1.'.UID_CAR.' limit 1) where (t1.car_id=0 or t1.car_id is null)') ;
            echo 'Автомобили, связано записей между '.$this->table_car.' и obj_site_personals_cars по car_id: <strong>'.$cnt.'</strong><br>';
          }

          // ищем сотрудников с изменившимися реквизитами
          // внимание! проверить выборку при разных комбинациях fired_data, fired_data2, enabled, fired_data_pause
          // и при разных комбинациях статуса совмещения сотрудника (только основная, основная+совмещение, только совмещение)
          // и при разных комбинациях передачи данных ищ ЗУП (только основная, основная+совмещение, только совмещение)
          /// !!! ВНИМАНИЕ
          /// t1.fname!=t2.fname не будет сравнивать, если одно из полей = NULL

      // формируем набор полей, по которому будем изкать измения
      $arr1=array() ; $arr2=array() ;
      if (_sizeof($this->arr_car_fields))
      {   foreach($this->arr_car_fields as $fname)
          {  $arr1[]='t1.'.$fname.',t2.'.$fname.' as old_'.$fname ;
             $arr2[]='(not t1.'.$fname.' is null and t1.'.$fname.'!=t2.'.$fname.')' ;
          }
          $str1=implode(',',$arr1) ;
          $str2=implode(' or ',$arr2) ;



          $recs=execSQL('select t1.car_id,t1.uid,'.$str1.'
                   from '.$this->table_car.' t1
                   left join obj_site_personals_cars t2 on t2.pkey=t1.car_id
                                where '.$str2.' ',0,1) ;
          echo 'Автомобили, изменено записей: <strong>'._sizeof($recs).'</strong><br>';
          //if (_sizeof($recs)) print_2x_arr($recs) ;
          if (_sizeof($recs)) foreach($recs as $i=>$rec)
            {
                if (!$rec['enabled']) $rec['fired']=1 ; else $rec['fired']=0 ;
               $result=TO()->car_save($rec['car_id'],$rec,array('show_changes'=>1,'read_only'=>$this->read_only,'source_fname'=>$this->setting['upload_fname'])) ;
                if ($result['update'])
                {
                    echo '<div class="green">Автомобиль <strong>'.$rec['obj_name'].'</strong>, сохранены изменения ['.$rec['uid'].']'.$read_only_status.'</div>' ;
                  $this->fz_update++ ;
                }
                //print_r($result) ; echo '<br>' ;
                $this->flog_append('Изменены данные автомобиля, '.$i.' из '._sizeof($recs)) ;
            }
      } else echo '<div class="alert">НЕ ЗАДАН СПИСОК ПОЛЕЙ ДЛЯ КОНТРОЛЯ ИЗМЕНЕНИЙ ЗАПИСЯХ АВТО</div>'  ;

          // на данный момент уже все должны быть сопоставлены по UID
//          $cnt=execSQL_update('update '.$this->table_car.' t1 set t1.car_id=(select t2.pkey from obj_site_personals_cars t2 where t2.clss=363 and t2.uid=t1.'.UID_CAR.' limit 1);') ;

          FILE_LOG()->append('sync_TEMP_DB_ESMO: end') ;
      }

    function insert_arr_to_db($table_fields,$arr)
    {   $sql='REPLACE INTO '.$this->table_fz.' ('.$table_fields.') VALUES '.implode(', ',$arr).';' ;
        execSQL_update($sql,array('debug'=>0)) ;
        $sql='REPLACE INTO '.$this->table_so.' ('.$table_fields.') VALUES '.implode(', ',$arr).';' ;
        execSQL_update($sql,array('debug'=>0)) ;
    }

    function check_db_fields_names($text)
    {  $text=trim($text) ;
       $text=stripslashes($text) ;
       $text=strip_tags($text) ;
       $text=translit($text) ;
       //$text=iconv('utf-8','ASCII//TRANSLIT',$text) ;
       // удаляем вредные символы

       $text=str_replace(array("\\",'/','"',"'",'`',',','.','+','?','&','#','%','<','>','-','(',')','=','!','[',']',']'),'',$text) ;
       $text=trim($text) ;
       // заменяем подряд следующие пробелы ( в том числе переносы строк и табуляторы) на символ-заменитель пробела
       $text=preg_replace('/\s+/','_',$text) ;
       $text=preg_replace('/\-+/','_',$text) ;
       //echo  $text.'<br>' ;

       return($text) ;
    }

    function flog_append($text)
    {
      FILE_LOG()->append($text);
    }

}

class i_car_relationcars_import extends i_backgroup_process_exec
{
    var $db_debug=0;
    var $import_begin_time=0;
    var $read_only=0;
    var $full_update=0;
    var $import_result=array();

    var $table_relations ;

    public $session_uid ;
    public $relation_add=0;
    public $relation_disable=0;
    public $relation_update=0;
    public $relation_reject=0;

    var $log_fname='' ;
    var $log_bash='' ;
    var $page_output='' ;
    var $view_source='' ;

    var $source_fname='' ;
    var $t_exec=0 ;

    function __construct($options=array())
    {
        parent::__construct($options) ;

        $this->table_relations='temp_import_relations_'.$this->session_uid ;

        $this->read_only=($options['read_only'])? $options['read_only']:$_GET['read_only'] ;
        $this->view_source=($options['view_source'])? $options['view_source']:$_GET['view_source'] ;
        $this->full_update=($options['full_update'])? $options['full_update']:$_GET['full_update'] ;
        $this->source_fname=($options['source_fname'])? $options['source_fname']:$_GET['source_fname'] ;
        $this->log_fname=FILE_LOG($this->session_uid)->log_fname ;
        $this->page_output='/temp/result_page_'.$this->session_uid.'.html' ;
        $this->log_bash='/temp/log_bash_'.$this->session_uid.'.txt' ;
    }

    function create_temp_tables()
    {   FILE_LOG()->append('create_temp_tables: start') ;

        execSQL_update('DROP TABLE  IF EXISTS '.$this->table_relations) ;

        //create_object_table(0,$this->table_fz,$this->table_fz,211)  ;
        //create_object_table(0,$this->table_so,$this->table_fz,212)  ;
        $arr_fields=array() ;
        if (!$GLOBALS['LS_TO_use_relation_uid']) {
            $arr_fields[]='ai_key int(11) auto_increment' ;
        } else {
            $arr_fields[]='relation_uid varchar(128)' ;
            $arr_fields[]='relation_id int(11) NULL' ;
        }
        $arr_fields[]='personal_uid varchar(128) DEFAULT ""' ;
        $arr_fields[]='car_uid varchar(128) DEFAULT ""' ;
        $arr_fields[]='personal_id int(11) NULL' ;
        $arr_fields[]='car_id int(11) NULL' ;

        $arr_fields[]='time_from int(11) NULL' ;
        $arr_fields[]='time_to int(11) NULL' ;
        //
        //$arr_fields[]='work_status varchar(10) DEFAULT ""' ;
        if (!$GLOBALS['LS_TO_use_relation_uid']) {
            $arr_fields[]='primary key (ai_key)' ;
        } else {
            $arr_fields[]='primary key (relation_uid)' ;
        }
        $arr_fields[]='key (personal_uid)' ;
        $arr_fields[]='key (car_uid)' ;
        $arr_fields[]='key (personal_id)' ;
        $arr_fields[]='key (car_id)' ;
        $sql='CREATE TABLE  '.$this->table_relations.' ('.implode(',',$arr_fields).') ENGINE = InnoDB DEFAULT CHARSET=utf8' ;
        execSQL_update($sql,array('debug'=>0)) ;

        FILE_LOG()->append('create_temp_tables: end') ;
    }

    function delete_temp_tables()
    {
        execSQL_update('drop table '.$this->table_relations) ;
    }

    function sync_TEMP_DB_ESMO()
    {
        FILE_LOG()->append('sync_TEMP_DB_ESMO: start') ;
        $this->flog_append('Начинаем синхронизировать загруженные данные с таблицами ЭСМО [sync_TEMP_DB_ESMO]') ;
        $this->flog_append('Заполяем personal_id в '.$this->table_relations) ;
        $cnt=execSQL_update('update '.$this->table_relations.' t1 set t1.personal_id=(select t2.pkey from obj_site_personals t2 where t2.clss=211 and t2.uid=t1.personal_uid order by t2.pkey limit 1);') ;
        $this->flog_append('Заполяем personal_id в '.$this->table_relations.' - заполено '.$cnt.' строк') ;
        $this->flog_append('Заполяем car_id в '.$this->table_relations) ;
        $cnt=execSQL_update('update '.$this->table_relations.' t1 set t1.car_id=(select t2.pkey from obj_site_personals_cars t2 where t2.uid=t1.car_uid order by t2.pkey limit 1);') ;
        $this->flog_append('Заполяем car_id в '.$this->table_relations.' - заполено '.$cnt.' строк') ;
        if ($GLOBALS['LS_TO_use_relation_uid']) {
            $this->flog_append('Заполяем relation_id в '.$this->table_relations) ;
            $cnt=execSQL_update('update '.$this->table_relations.' t1 set t1.relation_id=(select t2.pkey from '.TO()->table_relation.' t2 where t2.relation_uid=t1.relation_uid order by t2.pkey limit 1);') ;
            $this->flog_append('Заполяем relation_id в '.$this->table_relations.' - заполено '.$cnt.' строк') ;
        }

        $temp_relations = execSQL('select * from '.$this->table_relations);
        echo '<strong>Анализ связей водитель-авто</strong><br>';
        foreach ($temp_relations as $temp_relation) {
            try {
                $this->check_relation($temp_relation);
            } catch (Exception $exception) {
                echo $exception->getMessage().'<br>';
                $this->relation_reject++;
                continue;
            }

            if ($GLOBALS['LS_TO_use_relation_uid']) {
                $this->analyze_with_relation_uid($temp_relation);
            } else {
                $this->analyze_without_relation_uid($temp_relation);
            }
        }

        if ($GLOBALS['LS_TO_use_relation_uid']) echo 'Изменено связей водитель-авто: '.$this->relation_update.'<br>';
        echo 'Деактивировано связей водитель-авто: '.$this->relation_disable.'<br>';
        echo 'Добавлено связей водитель-авто: '.$this->relation_add.'<br>';
        echo 'Отклонено связей водитель-авто: '.$this->relation_reject.'<br>';

        multiSQL_insert(TO()->table_relation)->flush() ;
    }

    function analyze_with_relation_uid($temp_relation)
    {
        //обновляем данные по записям для есть relation_id
        if ($temp_relation['relation_id']) {
            $old_relation = execSQL_van('select pkey,relation_uid,personal_id,car_id,time_from,time_to,active from '.TO()->table_relation.' where pkey='.$temp_relation['relation_id']);
            $data=[];
            if (time()<$temp_relation['time_to']) $data['active']=1; else $data['active']=0;
            if ($old_relation['personal_id']!=$temp_relation['personal_id']) $data['personal_id']=$temp_relation['personal_id'];
            if ($old_relation['car_id']!=$temp_relation['car_id']) $data['car_id']=$temp_relation['car_id'];
            if ($old_relation['time_from']!=$temp_relation['time_from']) $data['time_from']=$temp_relation['time_from'];
            if ($old_relation['time_to']!=$temp_relation['time_to']) $data['time_to']=$temp_relation['time_to'];
            if ($old_relation['active']==$data['active']) unset($data['active']);

            if (_sizeof($data)) {
                update_rec_in_table(TO()->table_relation,$data,'pkey='.$temp_relation['relation_id']);
                $this->relation_update++;
                if (!$data['active']) $this->relation_disable++;
            }
        //добавляем новые записи
        } else {
            $this->append_relation($temp_relation);
        }


    }

    function analyze_without_relation_uid($temp_relation)
    {
        $activeRelations = execSQL('select * from '.TO()->table_relation.' where active=1 and (personal_id='.$temp_relation['personal_id'].' or car_id='.$temp_relation['car_id'].')');

        if (_sizeof($activeRelations)) {
            $this->check_active_relation($activeRelations,$temp_relation);
        } else {
            $this->append_relation($temp_relation);
        }
    }

    function check_relation($relation)
    {
        if (!$relation['personal_id']) {
            throw new Exception('В системе не найден сотрудник с uid: '.$relation['personal_uid']);
        }
        if (!$relation['car_id']) {
            throw new Exception('В системе не найдено авто с uid: '.$relation['car_uid']);
        }
    }

    function append_relation($relation)
    {
        $data=[];
        if ($GLOBALS['LS_TO_use_relation_uid']) { $data['relation_uid']    =   $relation['relation_uid'];}
        $data['personal_id']    =   $relation['personal_id'];
        $data['car_id']         =   $relation['car_id'];
        $data['time_from']      =   $relation['time_from'];
        $data['time_to']        =   $relation['time_to'];
        $data['c_data']         =   time();
        $data['r_data']         =   time();
        $data['active']         =   1;
        multiSQL_insert(TO()->table_relation)->append($data) ;
        $this->relation_add++;
    }

    function check_active_relation($activeRelations,$relation)
    {
        foreach ($activeRelations as $activeRelation) {
            //если начало или конец действия новой связи входит в срок действия старой
            if (($activeRelation['time_from']<=$relation['time_from'] and $relation['time_from']<=$activeRelation['time_to']) or
                ($activeRelation['time_from']<=$relation['time_to'] and $relation['time_to']<=$activeRelation['time_to'])) {
                //то деактивируем старую связь
                update_rec_in_table(TO()->table_relation,['active'=>0],'pkey='.$activeRelation['pkey']);
                $this->relation_disable++;
            }
        }
        $this->append_relation($relation);
    }

    function parse_XML_DB_to_table_relations()
    {
        echo '<strong>Формируем промежуточную таблицу связей водитель-авто</strong><br>';
        $recs = execSQL('select * from ' . $this->table_xml, 0, 1);
        if (_sizeof($recs)) foreach ($recs as $rec) {
            $uid = $rec['uid'];
            $data = array('uid' => $uid,
                'obj_name' => (isset($rec['GosNumber'])) ? $rec['GosNumber'] : null,
                'model' => (isset($rec['Model'])) ? $rec['Model'] : null,
                'type' => (isset($rec['CarType'])) ? $rec['CarType'] : null,
                'e_osago' => (isset($rec['DateEndOSAGO'])) ? (int)(($rec['DateEndOSAGO']) ? strtotime($rec['DateEndOSAGO']) : 0) : null,
                'e_sts' => (isset($rec['DateEndSTS'])) ? (int)(($rec['DateEndSTS']) ? strtotime($rec['DateEndSTS']) : 0) : null,
                'e_gto' => (isset($rec['DateEndGTO'])) ? (int)(($rec['DateEndGTO']) ? strtotime($rec['DateEndGTO']) : 0) : null,
                'org_name' => (isset($rec['CarOwner'])) ? $rec['CarOwner'] : null,
            );
            if ($uid != "") multiSQL_insert($this->table_car)->append($data);
            else if (!$uid) echo '<div class="red">Отсутствует UID АВТО [' . $rec['GosNumber'] . ']</div>';
        }
        multiSQL_insert($this->table_car)->flush();
    }

    function flog_append($text)
    {
        FILE_LOG()->append($text);
    }

}

?>
