<?php
// скрипт импорта сотрудников из файла XML
// класс вызывается либо через /cab/esmo_gateway/upload_personals/new/
// либо через services/esmo_gateway/upload_persons_XLS/
include_once(_DIR_EXT.'/esmo_gateway/i_personal_import.php') ;
class c_services_esmo_gateway_upload_persons_XLS extends i_personal_import
{
  var $temp_file_ext='.xls' ;
  var $XLS_row_header=1 ;

  function exec()
  { $t1=fixed_time() ;  ob_start() ;
    FILE_LOG()->append('VIEW_SOURCE: '.(($this->setting['view_source'])? 'ON':'OFF')) ;
    FILE_LOG()->append('READ_ONLY: '.(($this->setting['read_only'])? 'ON':'OFF')) ;
    FILE_LOG()->append('FULL_UPDATE: '.(($this->setting['full_update'])? 'YES':'NO')) ;
    FILE_LOG()->append('VIEW STATUS: '.(($this->setting['view_status'])? 'YES':'NO')) ;
    $error='' ; $result=array() ;

	    // проверка разрешения доступа
   $access=$this->check_access() ;

   if ($access['status']=='success')
   { $this->setting['upload_fname']=$this->connect_SOURCE() ;
     if ($this->setting['upload_fname'] and file_exists(_DIR_TO_ROOT.$this->setting['upload_fname']))
     {   // переносим данные XLS во временную таблицу
        $source_DB=$this->upload_source_file_to_db() ;
        if ($source_DB->result['status']=='success')
          {   // переносим данные из таблицы файла в таблицу сотрудников
              $this->table_source=$source_DB->table ;
              $this->create_temp_tables() ;  // создаем стандартные таблицы ФЛ и СО (используется метод из i_personal_import)
              $this->parse_source_DB_to_table_fl() ;
              $this->parse_source_DB_to_table_so() ;
              $this->sync_TEMP_DB_ESMO() ;
              $this->sync_workings_persons() ;
              $this->delete_temp_tables() ;

              $result['row_read']=$source_DB->row_import ;
              $result['person_count']=$this->fz_read ;
              $result['person_update']=$this->fz_update;
              $result['person_adding']=$this->fz_create ;
              $result['session_uid']=$this->session_uid ;

              if ($this->view_source) $this->panel_view_source($source_DB) ;
          }
          else
          {   ?><div class="error red bold">Ошибка при парсинге источника данных: <?echo $source_DB->result['error'].', '.$source_DB->result['descr']?></div><?
              $error='source parsing error' ;
          }

        $source_DB->delete_temp_tables() ;
         adding_rec_to_table('obj_site_post_log',array('obj_name'=>'upload_persons','IP'=>$_SERVER['REMOTE_ADDR'],'result'=>$result,'session_uid'=>$this->session_uid,'clss'=>362),array('debug'=>0)) ;

    }
    else
    {   echo '<div class=red>Не удалось сохранить данные с источника во временный файл для обработки</div>' ;
        $error='error create temp file ' ;
    }


        }
	    else $error=$access['comment'] ;

    LOGS()->reg_log('upload_persons','<a target=_blank href="'.$this->page_output.'">Отчет</a><br><a href="/temp/full_'.basename($this->log_fname).'" target=_blank>Лог загрузки</a><br><a href="'.$this->log_bash.'" target=_blank>Лог BASH</a>',array()) ;

    $text=ob_get_clean() ;
    $trace_text=ENGINE()->get_html_doc_content($text) ;
	$trace_fname='import_trace_'.$this->session_uid.'.html' ;
    LOGS()->reg_file_log($trace_fname,$trace_text,array('no_append_time'=>1,'return_logfname'=>1)) ;
    echo $text ;

    if ($error) $result['error']=$error ;
	return($result) ;

  }

  function check_access()
  { $error='' ;
    $result=array('status'=>($error)? 'failed':'success',
                  'comment'=>$error,
    ) ;
    return($result) ;
  }

  function panel_view_source($source_DB)
  {
      ?><h3>Загруженные данные (первые 3 строки)</h3><?
        $recs=execSQL('select *  from '.$source_DB->table_xls.' limit 100',0,1) ;
        print_2x_arr($recs) ;
        $recs=execSQL('select *  from '.$this->table_fz.' limit 100',0,1) ;
        print_2x_arr($recs) ;
        $recs=execSQL('select *  from '.$this->table_so.' limit 100',0,1) ;
        print_2x_arr($recs) ;
  }

  function upload_source_file_to_db()
  {
      include_once(_DIR_EXT.'/esmo_gateway/i_xls_to_db_import.php') ;
      $XLS_to_DB = new i_xls_to_db_import(array('uid'=>$this->session_uid)) ;
      $XLS_to_DB->XLS_fname=$this->setting['upload_fname'] ;  // /temp/0_a34d0deb97e04aa9409668dddf7666f6.xlsx
      $XLS_to_DB->row_header=$this->XLS_row_header;  // заголовки - строка 1
      $res=$XLS_to_DB->import() ;
      //damp_array($XLS_to_DB) ;
      //$this->setting['view_source']=1 ;
      if ($this->setting['view_source'])
      {  ?><strong>Прочитанный файл XLS, первые 10 строк с данными</strong><?
         $recs=execSQL('select * from '.$XLS_to_DB->table.' limit 10') ;
         print_2x_arr($recs) ;
      }

      return($XLS_to_DB) ;
  }



  function check_data($data)
  { $data=trim($data) ; //damp_string($data) ;
    $arr=explode('.',$data) ;
    if (_sizeof($arr)==3) return($data) ;
    else
    {  $arr=explode('-',$data) ;// print_r($arr) ; echo '<br>' ;
       if (_sizeof($arr)==3)
       {  $data=$arr[1].'.'.$arr[0] ;
          if ($arr[2]>20) $data.='.19'.$arr[2] ;
          else            $data.='.20'.$arr[2] ;
          return($data) ;
       }
       return('') ;
    }
  }

  // тут происходит постобрабтка данных из XLS файла
  // так как в временную таблицы данные были загружены как есть
  // теперь их надо перенести в таблицы ФЛ и СО в допустимом для импорта виде
  function parse_source_DB_to_table_fl()
  { echo '<strong>Формируем промежуточную таблицу ФЛ</strong><br>' ;
    $sets=$this->setting['field_mappings'] ;

    //damp_array($sets,1,-1) ;
    $recs=execSQL('select * from '.$this->table_source,0,1) ;
      if (_sizeof($recs)) foreach($recs as $rec)
      {   $uid=$rec[$sets['uid']] ;
          $arr_name=array() ;
          if ($rec[$sets['name1']]) $arr_name[]=$rec[$sets['name1']] ;
          if ($rec[$sets['name2']]) $arr_name[]=$rec[$sets['name2']] ;
          if ($rec[$sets['name3']]) $arr_name[]=$rec[$sets['name3']] ;
          if ($rec[$sets['obj_name']]) $arr_name[]=$rec[$sets['obj_name']] ;
          $name=implode(' ',$arr_name) ;

          $data=array('uid'=>$uid,
                      'obj_name'=>$name,
                      //'phone'=>'',
                      'tab_number'=>$rec[$sets['tab_number']],
                      'propusk'=>$rec[$sets['propusk']],
                      'snils'=>$rec[$sets['snils']],
                      'driving'=>$rec[$sets['driving']],
                      'pol'=>($rec[$sets['pol']]=='Мужской' or $rec[$sets['pol']]=='М' or $rec[$sets['pol']]=='М'  or !$rec[$sets['pol']] or $rec[$sets['pol']]=='')? 0:1,
                      'enabled'=>1,
                   ) ;

          list($data['dr'],$data['age'])=$this->get_dr_age($rec[$sets['dr']]) ;

          //damp_array($data,1,-1) ;
          if ($uid!="") multiSQL_insert($this->table_fz,array('mode'=>'REPLACE'))->append($data) ;
      }
       multiSQL_insert($this->table_fz)->flush() ;
  }

  function parse_source_DB_to_table_so()
  {  echo '<strong>Формируем промежуточную таблицу СО</strong><br>' ;
     $recs=execSQL('select * from '.$this->table_source,0,1) ;
     $sets=$this->setting['field_mappings'] ;
      if (_sizeof($recs)) foreach($recs as $rec)
      {   $uid=$rec[$sets['uid']] ;
          $uid_so=$rec[$sets['uid_so']] ;
          if (!$uid_so) $uid_so=$uid ;

          $arr_name=array() ;
          if ($rec[$sets['name1']]) $arr_name[]=$rec[$sets['name1']] ;
          if ($rec[$sets['name2']]) $arr_name[]=$rec[$sets['name2']] ;
          if ($rec[$sets['name3']]) $arr_name[]=$rec[$sets['name3']] ;
          if ($rec[$sets['obj_name']]) $arr_name[]=$rec[$sets['obj_name']] ;
          $name=implode(' ',$arr_name) ;

          $data=array('uid'=>$uid_so,
                      'uid_fl'=>$uid,
                      'obj_name'=>$name,
                      'org_name'=>$rec[$sets['_org_name']],
                      'otdel_name'=>$rec[$sets['_otdels_names']],
                      //'otdel_name1'=>$rec[$sets['_otdels_names1']],
                      //'otdel_name2'=>$rec[$sets['_otdels_names2']],
                      //'otdel_name3'=>$rec[$sets['_otdels_names3']],
                      //'otdel_name4'=>$rec[$sets['_otdels_names4']],
                      //'otdel_name5'=>$rec[$sets['_otdels_names5']],
                      'work_name'=>$rec[$sets['_working_name']],
                      'inrm'=>$rec[$sets['inrm']],
                      'is_main'=>(stripos($rec[$sets['working_status']],'совмес')!==false)? 0:1,
                      'is_second'=>(stripos($rec[$sets['working_status']],'совмес')!==false)? 1:0,
                      'enabled'=>1,
                      'fired_data'=>(1)? 0:time()   // дата увольнения для существующих сотрудников
                   ) ;
          //damp_array($data,1,-1) ;
          if ($uid!="")
          {   //damp_array($data,1,-1) ;
              multiSQL_insert($this->table_so,array('mode'=>'REPLACE'))->append($data) ;
          }
      }
       multiSQL_insert($this->table_so)->flush() ;


  }

    function remove_last_point($num)
    {
        if (substr(trim($num),-1)=='.') $str=substr(trim($num),0,strlen(trim($num))-1) ;
        else                            $str=$num ;
        return($str) ;
    }

    // дата идет в формате 01/01/10, переводим в формат обычной даты
      function get_dr_age($str_data)
      {  $str_data=str_replace(array('/','-'),'.',$str_data) ;
         list($date,$time)=explode(' ',$str_data) ;
         $arr=explode('.',$date) ;
         $dr='' ; $age=0 ;
         if (_sizeof($arr)==3)
          { $now_year=(int)date('y') ;
            $_y=(int)$arr[2] ;
            if (strlen($arr[2])==4)  $yaer=$_y ;
            else if ($now_year>$_y)  $yaer=(int)'20'.$arr[2] ;
            else                     $yaer=(int)'19'.$arr[2] ;
            // измнено для выгрузки из лукойла
            if (!$GLOBALS['LS_esmo_gateway_xls_replace_m_and_d_br']) {
                $month=(int)$arr[0] ;
                $day=(int)$arr[1] ;
            }  else {
                $month=(int)$arr[1] ;
                $day=(int)$arr[0] ;
            }

            $dr=sprintf("%02d.%02d.%04d", $day, $month, $yaer);
            $tt = mktime(0,0,0,$month,$day,date('Y'));   // дата день рождения в этом году
            $now_year=(int)date('Y') ;
            $age=$now_year-$yaer ;
            if (time()<$tt) $age=$age-1 ;
          }
         return(array($dr,$age)) ;
      }








}



?>
