<?php
// входной скрипт для URL https://dev.kvzrm.ru/services/esmo_gateway/upload_persons/
include_once('i_car_import.php');
class c_services_esmo_gateway_upload_cars extends i_car_import
{
  var $table_xml;
  var $db_debug=0;
  var $import_begin_time=0;
  var $read_only=0;
  var $full_update=0;
  var $read_block_stats=array() ;
  var $view_result_mode=0 ;

  // список полей, которые будут проверяться на изменения при импорте авто
  var $arr_car_fields=array('Номер авто'=>'obj_name',
                           'Модель'=>'model',
                           'Владелец авто'=>'model',
                           'Тип авто'=>'type',
                           'Дата покончания ОСАГО'=>'e_osago',
                           'Дата покончания СТС'=>'e_sts',
                           'Дата покончания ГТО'=>'e_gto',
                           'Состояние'=>'enabled',
          ) ;


	  function exec()
	  { FILE_LOG()->append('VIEW_SOURCE: '.(($this->view_source)? 'ON':'OFF')) ;
	    FILE_LOG()->append('READ_ONLY: '.(($this->read_only)? 'ON':'OFF')) ;
	    FILE_LOG()->append('FULL_UPDATE: '.(($this->full_update)? 'YES':'NO')) ;
        $error='' ; $result=array() ;

	    // проверка IP
	    if (!$GLOBALS['LS_gate_extended_server_ip']) { $error='access_denied for '.$_SERVER['REMOTE_ADDR'] ; $this->view_result_mode=1 ; }
	    else
	    {   $arr_ips=explode(',',$GLOBALS['LS_gate_extended_server_ip']) ;
	    	foreach($arr_ips as $i=>$ip) $arr_ips[$i]=trim($ip) ;
	    	if (!in_array($_SERVER['REMOTE_ADDR'],$arr_ips)) { $error='access_denied for '.$_SERVER['REMOTE_ADDR'] ; $this->view_result_mode=1 ; }
	    }

	    if ($error=='')
        {   ob_start() ;
            if (!$this->setting['upload_fname'])
            { $XML_cont = file_get_contents("php://input");
              if (!$XML_cont) $XML_cont=file_get_contents(_DIR_EXT.'/esmo_gateway/demo/'.$_GET['check_file']) ;
              $temp_fdir=hide_server_dir(_TEMP_DIR.$this->session_uid.'.xml') ;
              file_put_contents(_DIR_TO_ROOT.$temp_fdir,$XML_cont) ;
              echo 'XML данные сохранены во временном файле: <a href="'.$temp_fdir.'" target="blank">'.$temp_fdir.'</a><br>' ;
              $this->setting['upload_fname']=$temp_fdir ;
              $this->view_result_mode=1 ;
            }

            // переносим данные XLS во временную таблицу
            include_once(_DIR_EXT.'/esmo_gateway/i_xml_to_db_import.php') ;
            $XML_to_DB = new i_xml_to_db_import(array('session_uid'=>$this->session_uid,'XML_main_element'=>'Car')) ;
            $XML_to_DB->XML_fname=$this->setting['upload_fname'] ;  // /temp/0_a34d0deb97e04aa9409668dddf7666f6.xlsx
            $res=$XML_to_DB->import() ;
            if ($this->setting['view_source'])
           {  ?><h2>Прочитанный файл XLS, первые 10 строк с данными</h2><?
              $recs=execSQL('select * from '.$XML_to_DB->table.' limit 10') ;
              print_2x_arr($recs) ;
           }
           elseif ($res['success'])
                  {
                      $this->table_xml=$XML_to_DB->table ;
                      $this->defined_vars() ;
                      $this->create_temp_tables() ;  // создаем стандартные таблицы ФЛ и СО (используется метод из i_personal_import)
                      $this->parse_XML_DB_to_table_car() ;
                      $this->sync_TEMP_DB_ESMO() ;
                      $result=$this->import_result ;

                      $this->delete_temp_tables() ;


                      //$stats=execSQL_row('select enabled,count(pkey) from obj_site_personals where clss=211 group by enabled') ;
                      //$stats_img1=execSQL_value('select count(pkey) from obj_site_personals where _image_name!=""') ;
                      //$stats_img2=execSQL_value('select count(pkey) from obj_site_personals where upl_img!=""') ;

                      $result['car_count']=$XML_to_DB->row_import ;
                      $result['car_update']=$this->fz_update;
                      $result['car_adding']=$this->fz_create ;
                      $result['session_uid']=$this->session_uid ;
                  }

            $XML_to_DB->delete_temp_tables() ;

            adding_rec_to_table('obj_site_post_log',array('obj_name'=>'upload_cars','IP'=>$_SERVER['REMOTE_ADDR'],'result'=>$result,'session_uid'=>$this->session_uid,'clss'=>362),array('debug'=>0)) ;

            LOGS()->reg_log('upload_cars','<a target=_blank href="'.$this->page_output.'">Отчет</a><br><a href="/temp/full_'.basename($this->log_fname).'" target=_blank>Лог загрузки</a><br><a href="'.$this->log_bash.'" target=_blank>Лог BASH</a>',array()) ;

            $text=ENGINE()->get_html_doc_content(ob_get_clean()) ;
            $trace_fname='import_trace_'.$this->session_uid.'.html' ;
            LOGS()->reg_file_log($trace_fname,$text,array('no_append_time'=>1)) ;
        }

		if (!$this->view_result_mode) echo $text ;
		else
        {   ob_clean() ; // чистим все отправленно е ранее
            if (_sizeof($result)) foreach($result as $key=>$value) echo $key.'='.$value."\n" ;
            if ($error) echo $error ;
        }

		return($result) ;

	  }


	  // тут происходит постобрабтка данных из XML файла
	  // так как в временную таблицы данные были загружены как есть
	  // теперь их надо перенести в таблицы авто в допустимом для импорта виде
	  function parse_XML_DB_to_table_car()
	  { echo '<strong>Формируем промежуточную таблицу АВТО</strong><br>' ;
	  	$recs=execSQL('select * from '.$this->table_xml,0,1) ;
	      if (_sizeof($recs)) foreach($recs as $rec)
	      {   $uid=$rec['uid'] ;
	          $data=array('uid'=>$uid,
	                      'obj_name'=>(isset($rec['GosNumber']))? $rec['GosNumber']:null,
	                      'model'=>(isset($rec['Model']))? $rec['Model']:null,
	                      'type'=>(isset($rec['CarType']))? $rec['CarType']:null,
	                      'e_osago'=>(isset($rec['DateEndOSAGO']))? (int)(($rec['DateEndOSAGO'])? strtotime($rec['DateEndOSAGO']):0):null,
	                      'e_sts'=>(isset($rec['DateEndSTS']))? (int)(($rec['DateEndSTS'])? strtotime($rec['DateEndSTS']):0):null,
	                      'e_gto'=>(isset($rec['DateEndGTO']))? (int)(($rec['DateEndGTO'])? strtotime($rec['DateEndGTO']):0):null,
                          'org_name'=>(isset($rec['CarOwner']))? $rec['CarOwner']:null,
                          'enabled'=>($rec['Fired'])? 0:1,
	                   ) ;
	          if ($uid!="") multiSQL_insert($this->table_car,['mode'=>'REPLACE'])->append($data) ;
	          else if (!$uid) echo '<div class="red">Отсутствует UID АВТО ['.$rec['GosNumber'].']</div>' ;
	      }
	       multiSQL_insert($this->table_car)->flush() ;
	  }

}



?>
