<?php
include_once("c_esmo_gateway_upload.php");
class c_page_cab_esmo_gateway_upload_personals_gate_docs extends c_page_cab_esmo_gateway_upload
{
    public $h1='Загрузка списка сотрудников - документация для разработчиков' ;

    function block_main()
    { $this->page_title() ;
      ?><strong class="red">МАКСИМАЛЬНЫЙ ДОПУСТИМЫЙ РАЗМЕР XML-ПАКЕТА - 1000 КОНТЕЙНЕРОВ ПЕРСОН. ПРИ ПРЕВЫШЕНИИ  МАКСИМАЛЬНО РАЗМЕРА ПАКЕТ БУДЕТ ОТКЛОНЕН.</strong><br>
        <strong class="red">Время между окончанием отправки предудущего пакета и началом отправки следующего пакета должно быть не менее 3 минуты.</strong>
        <br><h2>Описание тегов XML-файла</h2>
        <table class="basic fz_normal left">
            <tr><td>Persons</td><td></td><td>Контейнер списка сотрудников. Должен находиться в корне документа</td></tr>
            <tr><td>Person</td><td></td><td>Контейнер описания сотрудника. Должен находиться в контейнере persons</td></tr>
            <tr><td colspan="3"><strong>Обязательные элементы для добавления нового сотрудника (в случае отсутствия обязательного элемента запись по сотруднику будет проигнорирована):</strong></td></tr>
            <tr><td>uid</td><td>string(128)</td><td>Ваш уникальный идентификатор сотрудника.</td></tr>
            <tr><td>Name</td><td>string(256)</td><td>ФИО сотрудника<span class="red">*</span></td></tr>
            <tr class="background_grey"><td>Surname</td><td>string(50)</td><td>Фамилия сотрудника<span class="red">*</span></td></tr>
            <tr class="background_grey"><td>FistName</td><td>string(50)</td><td>Имя сотрудника<span class="red">*</span></td></tr>
            <tr class="background_grey"><td>Patronymic</td><td>string(50)</td><td>Отчество сотрудника<span class="red">*</span></td></tr>
            <tr><td>Org</td><td>string(256)</td><td>Название организации сотрудника</td></tr>
            <tr><td colspan="3"><span class="red">*</span> - ФИО сотрудника должно быть передано либо в Name, либо в наборе Surname,FistName,Patronymic</td></tr>
            <tr><td colspan="3"><strong>Обязательные элементы для изменения данных по существующему сотруднику (в случае отсутствия обязательного элемента запись по сотруднику будет проигнорирована). Будут изменены только переданные поля</strong></td></tr>
            <tr><td>uid</td><td>string(128)</td><td>Ваш уникальный идентификатор сотрудника.</td></tr>
            <tr><td colspan="3"><strong>Дополнительные элементы, передаются по необходимости</strong></td></tr>
            <tr><td>Dr</td><td>string(10)</td><td>Дата рождения сотрудника, формат ДД.ММ.ГГГГ</td></tr>
            <tr><td>Pol</td><td>string(1)</td><td>Пол сотрудника, М/Ж</td></tr>
            <tr><td>Phone</td><td>string(12)</td><td>Телефон сотрудника</td></tr>
            <tr><td>Propusk</td><td>string(32)</td><td>Номер пропуска</td></tr>
            <tr><td>TabNumber</td><td>string(32)</td><td>Табельный номер</td></tr>
            <tr><td>Permit</td><td>string(32)</td><td>Номер разрешения на вид деятельности (для печати в путевом листе)</td></tr>
            <tr><td>PersonLicense</td><td>string(32)</td><td>Номер лицензии на вид деятельности (для печати в путевом листе)</td></tr>
            <tr><td>DateMedSpravka</td><td>string(32)</td><td>Дата выдачи мед.справки, формат ДД.ММ.ГГГГ (для печати в путевом листе)</td></tr>
            <tr><td>DriverLicense</td><td>string(32)</td><td>Серия, номер водительского удостоверения сотрудника</td></tr>
            <tr><td>DateMedSpravka</td><td>string(32)</td><td>Дата выдачи мед.справки, формат ДД.ММ.ГГГГ</td></tr>
            <tr><td>Structure</td><td>string(256)</td><td>Название подразделения организации</td></tr>
            <tr><td>Working</td><td>string(256)</td><td>Должность</td></tr>
            <tr><td>Fired</td><td>int(1)</td><td>Признак увольнения сотрудника, 0 - активен, 1 - уволен<div class="comment">Если данное поле не передается, сотрудник считается активным. Соответственно, для уволенных сотрудников это поле должно передаваться всегда.</div></td></tr>
            <tr><td>FullAccess</td><td>string(256)</td><td>Проход всегда</td></tr>
            <tr><td>Images_url</td><td></td><td>Контейнер списка фото. Должен находиться в контейнере person</td></tr>
        </table>
        <br><h2>Алгоритм загрузки списка сотрудников</h2>
        <ul>
            <li>UID сотрудника  - уникальный идентификатор в вашей системе. В работе системе ЭСМО используется только для синхронизации данных на шлюзе, поле обязательно для заполнения.</li>
            <li>При загрузке данных сотрудники идентифицируются по UID.</li>
            <li>Если сотрудник найден, информация по нему будет обновлена.</li>
            <li>Если сотрудник не найден, будет создана новая запись.</li>
            <li><strong>Если указано новое название организации, новая организация будет добавлена в базу автоматически.</strong></li>
            <li>Если указано новое для организации название подразделения, новое подразделение будет добавлен в организацию автоматически.</li>
        </ul>
        <br><h2>Алгоритм загрузки фото сотрудников</h2>
        <ul>
            <li>UID сотрудника  - уникальный идентификатор в вашей системе. В работе системе ЭСМО используется только для синхронизации данных на шлюзе, поле обязательно для заполнения.</li>
            <li>При загрузке данных сотрудники идентифицируются по UID.</li>
            <li>Если сотрудник не найден, будет создана новая запись.</li>
            <li>Для сотрудника указывается одно фото в контейнере Images_url.</li>
            <li>Загрузка фото на сервер производиться асинхронно, так как при большом объему записей обработка фото может занять значительное время.</li>
            <li>Фото идентифицируется по названию файла, если при последующей передаче данных будет передано новое имя фото, старое фото будет удалено.</li>
            <li>Асинхронный процесс загрузки фото загрузит новые изображения примерно в течении 5 мин после загрузки XML, (должно быть активно задание планировщика по загрузке фото персонала).</li>
            <li>Последнее загруженное фото будет является текущим фото сотрудника</li>
        </ul>
        <br><h2>Описание ответа шлюза</h2>
                <p>Ответ шлюза приходит в формате tag=value, в случае ошибки будет возвращен только один тег ошибки</p>
                <p>В случае успешной загрузки, будет возвращен набор тегов с описанием кол-ва добавленных и новых записей. Теги при этому будут разделены переносом строки.</p>
                <table class="basic fz_normal left">
                    <tr><td>Ошибки</td><td>error=access_denied</td><td>доступ запрещен, проверьте IP сервера в настройках интеграции</td></tr>
                    <tr><td></td><td>error=member_not_found</td><td>неверный client_id</td></tr>
                    <tr><td></td><td>error=member_is_not_client</td><td>указанный аккаунт не является клиентом системы ЭСМО</td></tr>
                    <tr><td></td><td>error=client_disabled</td><td>Аккаунт клиента заблокирован</td></tr>
                    <tr><td></td><td>error=not_valid_XML_source</td><td>Неверный формат XML, ошибка при разборе файла</td></tr>
                    <tr><td>Успешный импорт</td><td>person_count=XXX</td><td>Число обработанных контейнеров с описаниеми сотрудников</td></tr>
                    <tr><td></td><td>person_update=XXX</td><td>Число обновленных записей по сотрудникам</td></tr>
                    <tr><td></td><td>person_adding=XXX</td><td>Число новых записей по сотрудникам</td></tr>
                    <tr><td></td><td>person_enabled=XXX</td><td>Поле не используется, оставлено для совместимости</td></tr>
                    <tr><td></td><td>person_disabled=XXX</td><td>Поле не используется, оставлено для совместимости</td></tr>
                    <tr><td></td><td>strusture_add=XXX</td><td>Поле не используется, оставлено для совместимости</td></tr>
                    <tr><td></td><td>img_exist=XXX</td><td>Поле не используется, оставлено для совместимости</td></tr>
                    <tr><td></td><td>img_to_upload=XXX</td><td>Поле не используется, оставлено для совместимости</td></tr>
                    <tr><td></td><td>img_to_delete=XXX</td><td>Поле не используется, оставлено для совместимости</td></tr>
                </table>
        <style>
            tr.background_grey {background-color: #d4d4d4
            }
        </style>
      <?

    }



}



?>