// сохранение параметров текщего сертификата в аккаунте
function ESMO_FillCertList(SelectElementID)
{
    var canAsync = !!cadesplugin.CreateObjectAsync;
    if (canAsync && AsyncMode) {include_async_code().then(function (){return ESMO_FillCertList_Async(SelectElementID);});}
    else {
            return ESMO_FillCertList_NPAPI(SelectElementID);
         }
}
// заполнить список сертификатов в элемент select#SelectElementID
function ESMO_FillCertList_Async(SelectElementID)
{
    cadesplugin.async_spawn(function *()
    {
        try { var oStore = yield cadesplugin.CreateObjectAsync("CAdESCOM.Store");
              if (!oStore)
                {
                    alert("store failed");
                    return;
                }

                yield oStore.Open();
            }
            catch (ex)
            {
                alert("Ошибка при открытии хранилища: " + cadesplugin.getLastError(ex));
                return;
            }

        var select_el = $j('select#'+SelectElementID).get(0);
        if(!select_el) return;
        $j('select#'+SelectElementID).find('option').remove();



        var certCnt;
        var certs;

        try {
            certs = yield oStore.Certificates;
            certCnt = yield certs.Count;
        }
        catch (ex) {
            var errormes = document.getElementById("boxdiv").style.display = '';
            return;
        }

        if(certCnt == 0)
        {
            var errormes = document.getElementById("boxdiv").style.display = '';
            return;
        }

        var title ; var value ;
        for (var i = 1; i <= certCnt; i++)
        {
            var cert;
            try
            {
                cert = yield certs.Item(i);
            }
            catch (ex)
            {
                alert("Ошибка при перечислении сертификатов: " + cadesplugin.getLastError(ex));
                return;
            }

            var dateObj = new Date();
            try {   var ValidToDate = new Date((yield cert.ValidToDate));
                    var ValidFromDate = new Date((yield cert.ValidFromDate));
                    var Validator = yield cert.IsValid();
                    var IsValid = yield Validator.Result;
                    if(dateObj< ValidToDate && (yield cert.HasPrivateKey()) && IsValid || true)
                    {   // CertificateAdjuster -  класс из  /AddOns/cryptopro/js_2.1.0/async_code.js
                        //title = new CertificateAdjuster().GetCertInfoString(yield cert.SubjectName, ValidFromDate);
                        title=yield cert.SubjectName ; 
                    }
                    else continue;
                }
            catch (ex)
            {
                alert("Ошибка при получении свойства SubjectName: " + cadesplugin.getLastError(ex));
            }

            try
            {
                value = yield cert.Thumbprint;
            }
            catch (ex)
            {
                alert("Ошибка при получении свойства Thumbprint: " + cadesplugin.getLastError(ex));
            }
            var indx=select_el.length++ ;
            select_el.options[indx].text=title ;
            select_el.options[indx].value=value ;
        }

        yield oStore.Close();
    });//cadesplugin.async_spawn
}

function ESMO_FillCertList_NPAPI(SelectElementID)
{
    sign_log('Загружаем список сертификатов (NPAPI)') ;
    
    try {
        var oStore = cadesplugin.CreateObject("CAdESCOM.Store");
        oStore.Open();
        sign_log('Получен доступ к харнилищу сертификатов') ;
    }
    catch (ex) {
        alert("Ошибка при открытии хранилища: " + cadesplugin.getLastError(ex));
        sign_log('Ошибка при открытии хранилища: ' + cadesplugin.getLastError(ex)) ;
        return;
    }

    var select_el = $j('select#'+SelectElementID).get(0);
    if(!select_el) return;
    $j('select#'+SelectElementID).find('option').remove();
    sign_log('Очиска списка доступных сертификатов - ОК') ;


    var certCnt;

    try {
            certCnt = oStore.Certificates.Count;
            if(certCnt==0)
            {   sign_log('Сертификатов не найдено') ;
                throw "Cannot find object or property. (0x80092004)";
            }
        }
    catch (ex)
    {       oStore.Close();
            sign_log('Получение количества доступных сертификатов - ERROR') ;
            return;
    }

    var title ; var value ;
    for (var i = 1; i <= certCnt; i++)
    {
        var cert;
        try {
              cert = oStore.Certificates.Item(i);
              sign_log('Получение объекта сертификата # '+i+' - OK') ;
            }
        catch (ex) {
            alert("Ошибка при получении объекта сертификата # "+ i + ": "+ cadesplugin.getLastError(ex));
            return;
        }

        var dateObj = new Date();
        try {
            //if(dateObj<cert.ValidToDate && cert.HasPrivateKey() && cert.IsValid().Result)
            {
                var certObj = new CertificateObj(cert);
                //title = certObj.GetCertString();
                title= certObj.cert.SubjectName ;
            }
            //else
            { if(dateObj>=cert.ValidToDate) sign_log('Сертификат # '+i+' - СРОК ДЕЙСВИЯ ИСТЕК, пропущен') ;
              if(cert.HasPrivateKey()==false) sign_log('Сертификат # '+i+' - ОТСУТСТВУЕТ ПРИВАТНЫЙ КЛЮЧ, пропущен') ;
              if(cert.IsValid().Result==false) sign_log('Сертификат # '+i+' - NOT IS VALID, пропущен') ;
              //continue;
            }
        }
        catch (ex)
        {
            alert("Ошибка при получении свойства SubjectName: " + cadesplugin.getLastError(ex));
        }

        try
        {
            value = cert.Thumbprint;
        }
        catch (ex)
        {
            alert("Ошибка при получении свойства Thumbprint: " + cadesplugin.getLastError(ex));
        }

        var indx=select_el.length++ ;
        select_el.options[indx].text=title ;
        select_el.options[indx].value=value ;
    }

    oStore.Close();
}
